#ifndef MCLONE_H
#define MCLONE_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef MTASK_H
#include "MTask.h"
#endif

class MParList;

class MClone : public MTask
{
private:
    const MParContainer *fParContainer; // pointer to container which has to be cloned
    TString fParContainerName;          // given name to search for in the parameterlist

    TObject* fClone;                    // pointer to the cloned object. deletion is handled by MClone

    void Init(const char *name, const char *title);

public:
    MClone(const char *par,          const char *name=NULL, const char *title=NULL);
    MClone(const MParContainer *par, const char *name=NULL, const char *title=NULL);
    ~MClone();

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    TObject *GetClone() const { return fClone; }

    void Clear(Option_t *opt=NULL);

    ClassDef(MClone, 0) // Task to clone (duplicate) an object in memory
};
    
#endif

