#ifndef MREADTREE_H
#define MREADTREE_H

#ifndef MTASK_H
#include "MTask.h"
#endif

class TFile;
class TChain;
class TArrayC;

class MReadTree : public MTask
{
private:
    TFile   *fFile;       // Pointer to file
    TChain  *fChain;      // Pointer to tree

    TArrayC *fVetoList;   // List of Branches which are not allowed to get enabled

    UInt_t   fNumEntry;   // Number of actual entry
    UInt_t   fNumEntries; // Number of Events in Tree

    Bool_t   fLeafEnabled; // Flag whether UseLeaf is called the first time or not

    Bool_t HasVeto(const char *name) const;

public:
    MReadTree(const char *treename, const char *filename=NULL, const char *name=NULL, const char *title=NULL);
    ~MReadTree();

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    Int_t AddFile(const char *fname);
    void  VetoBranch(const char *name);

    void UseLeaf(const char *name);

    Bool_t GetEvent();

    Bool_t DecEventNum(UInt_t dec=1); // decrease number of event (position in tree)
    Bool_t IncEventNum(UInt_t inc=1); // increase number of event (position in tree)
    Bool_t SetEventNum(UInt_t nr);    // set number of event (position in tree)

    UInt_t GetEventNum() const { return fNumEntry;   }
    UInt_t GetEntries() const  { return fNumEntries; }

    ClassDef(MReadTree, 0)	// Reads one tree
};

#endif
