/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
//   MTask                                                                 //
//                                                                         //
//   Base class for all tasks which can perfomed in a tasklist             //
//   For each event processed in the eventloop all the different           //
//   tasks in the tasklist will be processed.                              //
//                                                                         //
//   So all tasks must inherit from this baseclass.                        //
//                                                                         //
//   The inheritance from MInputStreamID is used to indicate the           //
//   type of event that this task is for. If it is "All" it is executed    //
//   independantly of the actual ID of the task list.                      //
//                                                                         //
//   Inside this abstract class, there are three fundamental function:     //
//                                                                         //
//   - PreProcess():   executed before the eventloop starts. Here you      //
//                     can initiate different things, open files, etc.     //
//                     As an argument this function gets a pointer to the  //
//                     parameter list. You can stop the execution by       //
//                     returning kFALSE instead of kTRUE. If an error      //
//                     occured and you return kFALSE make sure, that       //
//                     any action is closed correctly and all newly        //
//                     created object are deleted. The PostProcess in      //
//                     such a case won't be executed by the Tasklist or    //
//                     Eventloop.                                          //
//                                                                         //
//   - Process():      executed for each event in the eventloop. Do it     //
//                     one task after the other (as they occur in the      //
//                     tasklist). Only the tasks with a Stream ID          //
//                     which matches the actual ID of the tasklist         //
//                     are executed. A task can return kFALSE to           //
//                     stop the execuition of the tasklist or              //
//                     kCONTINUE to skip the pending tasks.                //
//                                                                         //
//   - PostProcess():  executed after the eventloop. Here you can close    //
//                     output files, start display of the run parameter,   //
//                     etc. PostProcess should be executed only if         //
//                     PreProcess was successfull (returned kTRUE)         //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#include "MTask.h"

ClassImp(MTask);

// --------------------------------------------------------------------------
//
// This is processed before the eventloop starts
//
// It is the job of the PreProcess to connect the tasks
// with the right container in the parameter list.
//
// the virtual implementation returns kTRUE
//
Bool_t MTask::PreProcess(MParList *pList)
{
    return kTRUE;
}

// --------------------------------------------------------------------------
//
// This is processed for every event in the eventloop
//
// the virtual implementation returns kTRUE
//
Bool_t MTask::Process()
{
    return kTRUE;
}

// --------------------------------------------------------------------------
//
// This is processed after the eventloop starts
//
// the virtual implementation returns kTRUE
//
Bool_t MTask::PostProcess()
{
    return kTRUE;
}


