/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Harald Kornmayer 1/2001 (harald@mppmu.mpg.de)
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

#include "MShowSpect.h"

#include "MLog.h"
#include "MLogManip.h"
#include "MParList.h"      // MParList
#include "MGDisplayAdc.h"  // MGDisplayAdc


////////////////////////////////////////////////////////////////////////
//
//  MGShowSpect.h
//
//  A Gui Task to show the raw ADC values in the histograms
//

ClassImp(MShowSpect)

MShowSpect::MShowSpect(const char *nameHist, const char *name, const char *title)
{
    //
    // default constructor
    //

    *fName  = name ? name : ClassName();
    *fTitle = title ? title : "Task to ??? (Harald?)";

    strcpy( fHistName, nameHist ) ;
} 


Bool_t MShowSpect::PreProcess(MParList *pList)
{
  //
  //   Do the preprocessing for MShowSpect
  // 
  //   Connects Histogramms in the MHFadcCam container as the input
  //

  fHists = (MHFadcCam*) pList->FindObject( fHistName );
  
  if (!fHists)
    {
        *fLog << dbginf << " Error: MHFadcCam '" << fHistName << "' not found!" << endl;
        return kFALSE;
    }
  
  return kTRUE;
} 


Bool_t MShowSpect::PostProcess()
{
  //   just start the gui for displaying the adc spectra

  new MGDisplayAdc(fHists, gClient->GetRoot(), gClient->GetRoot(), 600, 600);

  return kTRUE;
} 

