#ifndef MHFADCPIX_H
#define MHFADCPIX_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif

#ifndef ROOT_TH1
#include <TH1.h>
#endif

class MHFadcPix : public TObject
{
private:
    TH1F *fHistHi;
    TH1F *fHistLo;

public:
    MHFadcPix(UInt_t pixid=0);
    ~MHFadcPix();

    TH1F *GetHistHi() { return fHistHi; }
    TH1F *GetHistLo() { return fHistLo; }

    void FillHi(Byte_t i) { fHistHi->Fill(i); }
    void FillLo(Byte_t i) { fHistLo->Fill(i); }

    void DrawHi() { fHistHi->Draw(); }
    void DrawLo() { fHistLo->Draw(); }

    void Draw(Option_t *opt=NULL);

    ClassDef(MHFadcPix, 1) // Conatiner to hold two histograms container spektrums for the lo-/hi gain of one pixel
};

#endif

