#ifndef MFTRIGGERLVL1_H
#define MFTRIGGERLVL1_H

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MFTriggerLvl1                                                           //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////

#ifndef MFILTER_H
#include "MFilter.h"
#endif

class MMcTrig;
class MParList;

class MFTriggerLvl1 : public MFilter
{
private:
    const MMcTrig *fMcTrig;
    TString fContName;

    typedef enum { kELowerThan, kEGreaterThan } FilterType_t;
    FilterType_t fFilterType;

    Bool_t fResult;
    Int_t  fValue;

    void Init(const char type, const Int_t val);

public:
    MFTriggerLvl1(const char *cname="MMcTrig", const char type='>', const Int_t val=0);
    MFTriggerLvl1(const MMcTrig *mctrig,       const char type='>', const Int_t val=0);

    Bool_t IsExpressionTrue() const;
    Bool_t PreProcess(MParList *pList);
    Bool_t Process();

    ClassDef(MFTriggerLvl1, 0)		// A Filter for the Level 1 Trigger
};

#endif
