#ifndef MGEOMCAM_H
#define MGEOMCAM_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif
#ifndef MPARCONTAINER_H
#include "MParContainer.h"
#endif

class MGeomPix;
class TObjArray;

class MGeomCam : public MParContainer
{
private:
    UInt_t   fNumPixels;  // Number of pixels in this camera
    Float_t  fMaxRadius;  // maximum radius of the camera (eg. for GUI layout)

    TObjArray *fPixels;   // Array of singel pixels storing the geometry

protected:
    void CalcMaxRadius();

public:

    MGeomCam(UInt_t npix, const char *name=NULL, const char *title=NULL);

    virtual ~MGeomCam();

    UInt_t  GetNumPixels() const { return fNumPixels; }
    Float_t GetMaxRadius() const { return fMaxRadius; }

    MGeomPix &operator[](Int_t i);
    MGeomPix &operator[](Int_t i) const;

    virtual void Print(Option_t *opt=NULL);

    ClassDef(MGeomCam, 1)  // Geometry base class for the camera
};

#endif

