#ifndef SDOLIST_H
#define SDOLIST_H

#include <pthread.h>

#include "gendef.h"

class PendingSDO
{
public:
    BYTE_t Node;
    WORD_t Idx;
    BYTE_t Subidx;
    PendingSDO *Next;

    PendingSDO(BYTE_t n=0, WORD_t i=0, BYTE_t s=0)
        : Node(n), Idx(i), Subidx(s), Next(NULL) {}
};

class PendingSDOList
{
private:
    PendingSDO *fFirst;
    PendingSDO *fLast;

    pthread_mutex_t fMux;

public:
    PendingSDOList();
    ~PendingSDOList();

    void Add(BYTE_t node, WORD_t idx, BYTE_t subidx);
    void Del(BYTE_t node, WORD_t idx, BYTE_t subidx);
    void DelAll();

    int IsPending() const;
    int IsPending(BYTE_t node);
    int IsPending(BYTE_t node, WORD_t idx, BYTE_t subidx);
};

#endif
