/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */


void CT1Hillas()
{
    //
    // This is a demonstration program which calculates the Hillas
    // parameter out of a CT1 dataset.

    //
    // Create a empty Parameter List and an empty Task List
    // The tasklist is identified in the eventloop by its name
    //
    MParList  plist;

    MTaskList tlist;
    plist.AddToList(&tlist);

    //
    // The geometry container must be created by yourself to make sure
    // that you don't choos a wrong geometry by chance
    //
    MGeomCamCT1 geomcam;
    plist.AddToList(&geomcam);

    //
    // The Hillas histograms (MHHillas) could be created automatically
    // but to make sure, that they are not deleted when the macro is
    // finished you must create them yourself and add it to the list
    //
    MHHillas  *hists = new MHHillas;
    plist.AddToList(hists);

    MHStarMap *smap = new MHStarMap;
    plist.AddToList(smap);

    //
    // Now setup the tasks and tasklist:
    //
    //  1) read in the data from a ct1 ascii file   MCTReadAscii
    //  2) clean the image                          MImgCleanStd
    //  3) calculate hillas                         MHillasCalc
    //  4) fill the hillas into the histograms      MFillHHillas
    //
    MCT1ReadAscii read("data/MCCT1_97_ga45.dat");
    // read.AddFile("data/MCCT1_97_ga20.dat");

    MImgCleanStd  clean;
    MHillasCalc   hcalc;
    MFillHHillas  hfill;
    MFillHStarMap sfill;

    tlist.AddToList(&read);
    tlist.AddToList(&clean);
    tlist.AddToList(&hcalc);
    tlist.AddToList(&hfill);
    tlist.AddToList(&sfill);

    //
    // Create and setup the eventloop
    //
    MEvtLoop evtloop;
    evtloop.SetParList(&plist)

    //
    // Execute your analysis
    //
    if (!evtloop.Eventloop())
        return;

    //
    // After the analysis is finished we can display the histograms
    //
    hists->Draw();
    smap->Draw();
}
