/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Harald Kornmayer 1/2001 (harald@mppmu.mpg.de)
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

///////////////////////////////////////////////////////////////////////
//
// MHFadcPix
//
// This container stores a hostogram to display an Fadc Spekrtum.
// The spektrum of all the values measured by the Fadcs.
//
///////////////////////////////////////////////////////////////////////

#include "MHFadcPix.h"

#include <TPad.h>

ClassImp(MHFadcPix);

// --------------------------------------------------------------------------
//
// Creates the histograms for lo and hi gain of one pixel
//
MHFadcPix::MHFadcPix(UInt_t pixid)
{
    // FIXME! Set the right axis titles and ... and ...
    Char_t tmp1[40];
    Char_t tmp2[40];

    //    if (pixid)
    //    {
    sprintf(tmp1, "HiGain%03d", pixid);
    sprintf(tmp2, "Hi Gain Pixel #%d", pixid);
    //    }
    fHistHi =  new TH1F(tmp1, tmp2, 256, 0, 255);

    //    if (pixid)
    //    {
    sprintf(tmp1, "LoGain%03d", pixid);
    sprintf(tmp2, "Lo Gain Pixel #%d", pixid);
    //    }
    fHistLo = new TH1F(tmp2, tmp2, 256, 0, 255);
}

// --------------------------------------------------------------------------
MHFadcPix::~MHFadcPix()
{
    delete fHistHi;
    delete fHistLo;
}

// --------------------------------------------------------------------------
void MHFadcPix::Draw(Option_t *)
{
    if (!gPad)
    {
        if (!gROOT->GetMakeDefCanvas())
            return;
        (gROOT->GetMakeDefCanvas())();
    }

    gPad->Divide(1, 2);

    gPad->cd(0);
    fHistHi->Draw();

    gPad->cd(1);
    fHistLo->Draw();
}
