#ifndef MTRIGGERRATECALC_H
#define MTRIGGERRATECALC_H

#ifndef MAGIC_H
#include "MAGIC.h"
#endif
#ifndef ROOT_TObjArray
#include <TObjArray.h>
#endif
#ifndef MTASK_H
#include "MTask.h"
#endif

class MParList;
class MMcEvt;
class MMcTrig;
class MHMcRate;

class MMcTriggerRateCalc : public MTask
{
private:
    MMcEvt    *fMcEvt;        //!

    TObjArray *fMcRate;
    TObjArray *fMcTrig;

    Int_t      fDimension;     // Information about the trigger conditions
                               // in the root file to be read.
    Int_t      fNum;           // decoded dimension

    Float_t    fTrigger[10];   // Number of triggered showers
    Float_t    fShowers;       // Number of simulated showers
    Float_t    fAnalShow;      // Number of analysed showers

    Int_t      fPartId;        // Incident particle that generates showers

    void Init(int dim, int part, float *trigbg,
              float simbg, const char *name, const char *title);

    MHMcRate *GetRate(UInt_t i) const { return (MHMcRate*)((*fMcRate)[i]); }
    MMcTrig  *GetTrig(UInt_t i) const { return (MMcTrig*)((*fMcTrig)[i]); }

public:
    MMcTriggerRateCalc(int dim=0, int part=14, float *trigbg=NULL,
                       float simbg=100000,
                       const char *name=NULL, const char *title=NULL);

    MMcTriggerRateCalc(float rate, int dim, int part, float *trigbg,
                       float simbg,
                       const char *name=NULL, const char *title=NULL);

    Bool_t PreProcess(MParList *pList);
    Bool_t Process();
    Bool_t PostProcess();

    ClassDef(MMcTriggerRateCalc, 0)	// Task to compute the trigger rate
};

#endif 
