#ifndef SLASTARS_H
#define SLASTARS_H

#include "Slalib.h"

class SlaStars : public Slalib
{
private:
    AltAz    fAltAz;    // [rad]
    RaDec    fRaDec;    // [rad]

    double   fAmprms[21];
    double   fAoprms[14];

public:
    SlaStars();
    virtual ~SlaStars();

    //    const AltAz GetAltAz() const { return fAltAz*360/D2PI; }
    //    const ZdAz  GetZdAz()  const { return ZdAz(DPI/2-fAltAz.Alt(), fAltAz.Az())*360/D2PI; }
    //    const RaDec GetRaDec() const { return fRaDec*360/D2PI; }

    virtual void SetMjd(const double mjd);

    void   Set(const AltAz &altaz);
    void   Set(const ZdAz  &zdaz);
    void   Set(const RaDec &radec);

    ZdAz   GetApproxVel(const RaDec &radec) const; // [rad/rad];

    RaDec  CalcRaDec(const AltAz &altaz) const;
    RaDec  CalcRaDec(const ZdAz  &altaz) const;

    AltAz  CalcAltAz(const RaDec &radec) const;
    ZdAz   CalcZdAz (const RaDec &radec) const;
};

#endif
