#include "SlaPlanets.h"

#include <iostream.h>

#include "slalib.h"

SlaPlanets::SlaPlanets() : Slalib(), fDt(slaDt(2000.0)/60./60./24.)
{
}

SlaPlanets::~SlaPlanets()
{
}

void SlaPlanets::SetMjd(const double mjd)
{
    Slalib::SetMjd(mjd);

    //
    // coordinates of earth: heliocentric, equatoril, J2000
    //
    double veb[3]; // barycentric velocity
    double ceb[3]; // barycentric coordinates
    double veh[3]; // heliocentric velocity

    slaEvp(mjd + fDt, 2000.0, veb, ceb, veh, fEarth);
}

void SlaPlanets::UpdatePlanetPos(ePlanets_t planet)
{
    double cp[6] = { 0, 0, 0, 0, 0, 0 };

    double coord[6];

    switch (planet)
    {
    case kEMoon:
        //
        // -- approximate geocentric pos and vel --
        //
        slaDmoon(GetMjd() + fDt, coord);
        break;

    case kEMercury:
    case kEVenus:
    case kEMars:
    case kEJupiter:
    case kESaturn:
    case kEUranus:
    case kENeptune:
    case kEPluto:
        {
            //
            // coordinates of planet: heliocentric, equatoril, J2000
            //

            int rc;
            slaPlanet(GetMjd(), planet, cp, &rc);

            if (rc)
                return;
        }
        // !! Fall through!

    case kESun:
        coord[0] = cp[0] - fEarth[0];
        coord[1] = cp[1] - fEarth[1];
        coord[2] = cp[2] - fEarth[2];
        break;
    }

    fZdAz[planet] = XYZ2ZdAz(coord);
}
