/* ======================================================================== *\
!
! *
! * This file is part of MARS, the MAGIC Analysis and Reconstruction
! * Software. It is distributed to you in the hope that it can be a useful
! * and timesaving tool in analysing Data of imaging Cerenkov telescopes.
! * It is distributed WITHOUT ANY WARRANTY.
! *
! * Permission to use, copy, modify and distribute this software and its
! * documentation for any purpose is hereby granted without fee,
! * provided that the above copyright notice appear in all copies and
! * that both that copyright notice and this permission notice appear
! * in supporting documentation. It is provided "as is" without express
! * or implied warranty.
! *
!
!
!   Author(s): Thomas Bretz  12/2000 (tbretz@uni-sw.gwdg.de)
!
!   Copyright: MAGIC Software Development, 2000-2001
!
!
\* ======================================================================== */

/////////////////////////////////////////////////////////////////////////////
//                                                                         //
// MPedestalCam                                                            //
//                                                                         //
// Hold the Pedestal information for all pixels in the camera              //
//                                                                         //
/////////////////////////////////////////////////////////////////////////////
#include "MPedestalCam.h"

#include "MLog.h"

ClassImp(MPedestalCam);

// --------------------------------------------------------------------------
//
// Default constructor. Creates a MPedestalPix object for each pixel
//
MPedestalCam::MPedestalCam(const char *name, const char *title)
{
    *fName  = name  ? name  : "MPedestalCam";
    *fTitle = title ? title : "Storage container for all Pedestal Information in the camera";

    fArray = new TClonesArray("MPedestalPix", 577);

    //
    // TClonesArray: The 'new operator with placement' must be used
    //
    for (int i=0; i<577; i++)
        new ((*fArray)[i]) MPedestalPix;
}

// --------------------------------------------------------------------------
//
// Delete the array conatining the pixel pedest information
//
MPedestalCam::~MPedestalCam()
{
    // FIXME: Do we have to delete the objects itself?
    delete fArray;
}

