int swtrig(const char *fname)
{
    gEnv->GetValue("TFile.Recover", 0);
    TChain c("Events");
    if (c.AddFile(fname, 0)!=1)
    {
        gLog << "ERROR - Number of added files does not match 1." << endl;
        return 1;
    }

    c.SetAlias("Baseline", "MSoftwareTrigger.fBaseline");
    c.SetAlias("Signal",   "MSoftwareTrigger.fAmplitude");
    c.SetAlias("ID",       "(0xff00&MRawEvtHeader.fTrigPattern[0])");
    c.SetAlias("DATA",     "ID==0x000");
    c.SetAlias("CAL",      "ID==0x100");
    c.SetAlias("PED",      "ID==0x400");
    c.SetAlias("SELECT",   "Baseline < (Signal/1000)^1.5+75");

    Long64_t cnt27s = c.Draw("Signal", "!SELECT && DATA", "goff");

    Long64_t cnt00050 = c.Draw("Signal", "SELECT && DATA && (Signal>50)",    "goff");
    Long64_t cnt00100 = c.Draw("Signal", "SELECT && DATA && (Signal>100)",   "goff");
    Long64_t cnt00200 = c.Draw("Signal", "SELECT && DATA && (Signal>200)",   "goff");
    Long64_t cnt00350 = c.Draw("Signal", "SELECT && DATA && (Signal>350)",   "goff");
    Long64_t cnt00500 = c.Draw("Signal", "SELECT && DATA && (Signal>500)",   "goff");
    Long64_t cnt00750 = c.Draw("Signal", "SELECT && DATA && (Signal>750)",   "goff");
    Long64_t cnt01000 = c.Draw("Signal", "SELECT && DATA && (Signal>1000)",  "goff");
    Long64_t cnt01250 = c.Draw("Signal", "SELECT && DATA && (Signal>1250)",  "goff");
    Long64_t cnt02500 = c.Draw("Signal", "SELECT && DATA && (Signal>2500)",  "goff");
    Long64_t cnt05000 = c.Draw("Signal", "SELECT && DATA && (Signal>5000)",  "goff");
    Long64_t cnt10000 = c.Draw("Signal", "SELECT && DATA && (Signal>10000)", "goff");
    Long64_t cnt20000 = c.Draw("Signal", "SELECT && DATA && (Signal>20000)", "goff");

    cout << "result ";
    cout << cnt27s   << ' ';
    cout << cnt00050 << ' ';
    cout << cnt00100 << ' ';
    cout << cnt00200 << ' ';
    cout << cnt00350 << ' ';
    cout << cnt00500 << ' ';
    cout << cnt00750 << ' ';
    cout << cnt01000 << ' ';
    cout << cnt01250 << ' ';
    cout << cnt02500 << ' ';
    cout << cnt05000 << ' ';
    cout << cnt10000 << ' ';
    cout << cnt20000 << endl;

    return 0;
}
