int mcmerpp(const char *fin="ceres.root", const char *fout="star.root")
{
    TFile filein (fin,  "READ");
    if (!filein)
    {
        cerr << "Failed to open '" << fin << "'" << endl;
        return -1;
    }

    TFile fileout(fout, "UPDATE");
    if (!fileout)
    {
        cerr << "Failed to open '" << fout << "'" << endl;
        return -1;
    }


    TTree *tree = dynamic_cast<TTree*>(filein.Get("OriginalMC"));
    if (!tree)
    {
        cerr << "Tree 'OriginalMC' not found in '" << fin << "'" << endl;
        return -1;
    }

    //tree->SetBranchStatus("*", 1);

    // Now we clone the tree without unpacking and repacking.
    // When it has not been moved it will be deleted in the TFile destructor

    TTree *newtree = tree->CloneTree(-1, "fast SortBasketsByEntry");
    if (!newtree)
        return -1;
    newtree->Write();
    delete newtree;

    cerr << "OriginalMC copied from '" << fin << "' to '" << fout << "'" << endl;

    return 0;
}
