#ifndef MARS_Prediction
#define MARS_Prediction

#include <math.h>

#include "nova.h"

namespace FACT
{
    using namespace Nova;

    double PredictI(const double &jd, const EquPosn &src_pos)
    {
        // Sun properties
        const EquPosn  sun  = GetSolarEquCoords(jd);
        const ZdAzPosn hrzs = GetHrzFromEqu(sun, jd);

        // Moon properties
        const EquPosn moon = GetLunarEquCoords(jd, 0.01);
        const HrzPosn hrzm = GetHrzFromEqu(moon, jd);
        const double  disk = GetLunarDisk(jd);

        // Derived moon properties
        const double angle = GetAngularSeparation(moon, src_pos);
        const double edist = GetLunarEarthDist(jd)/384400;

        // Current prediction
        const double sin_malt  = hrzm.alt<0 ? 0 : sin(hrzm.alt*M_PI/180);
        const double cos_mdist = cos(angle*M_PI/180);
        const double sin_szd   = sin(hrzs.zd*M_PI/180);

        const double c0 = pow(disk,      2.63);
        const double c1 = pow(sin_malt,  0.60);
        const double c2 = pow(edist,    -2.00);
        const double c3 = exp(0.67*cos_mdist*cos_mdist*cos_mdist*cos_mdist);
        const double c4 = exp(-97.8+105.8*sin_szd*sin_szd);

        return  6.2 + 95.7*c0*c1*c2*c3 + c4; // [muA]
    }
}

#endif
