#ifndef MARS_MDataFormat
#define MARS_MDataFormat

#ifndef MARS_MAGIC
#include "MAGIC.h"
#endif

#ifndef ROOT_Rtypes
#include <Rtypes.h>
#endif

#include <stdint.h>

#include <iosfwd>
#include <fstream>

class MCorsikaFormat
{
protected:
   std::istream  *fIn;

public:
    enum
    {
        kBlockLengthRaw  = 0x00005994, // Raw Corsika without Thinning
        kBlockLengthThin = 0x00006660, // Raw Corsika with Thinning

        kSyncMarker  = 0xd41f8a37,     // EventIO

        kRUNH = 0x484e5552, // "RUNH"
        kRUNE = 0x454e5552, // "RUNE"
        kEVTH = 0x48545645, // "EVTH"
        kEVTE = 0x45545645, // "EVTE"
    };

   MCorsikaFormat(std::istream * in)
        : fIn(in) { }
   virtual ~MCorsikaFormat();

   virtual Bool_t NextBlock(Int_t   readState, Int_t & blockType, Int_t & blockVersion,
                            Int_t & blockIdentifier, Int_t & blockLength) const = 0;

           void   Seek(std::streampos offset)    {fIn->seekg(offset, std::ios::cur);}

   virtual Bool_t SeekEvtEnd() = 0;

   virtual Bool_t IsEventioFormat() const = 0;

   virtual Bool_t Eof() const;

           Bool_t Read(void *ptr, Int_t i) const;

   static MCorsikaFormat *CorsikaFormatFactory(const char *fileName);
};


class MCorsikaFormatRaw : public MCorsikaFormat
{
private:
   uint32_t fBlockLength;

public:
   MCorsikaFormatRaw(std::istream * in, const uint32_t &bl)
        : MCorsikaFormat(in), fBlockLength(bl) {}

   Bool_t NextBlock(Int_t   readState, Int_t & blockType, Int_t & blockVersion,
                    Int_t & blockIdentifier, Int_t & blockLength) const;

   Bool_t SeekEvtEnd();

   Bool_t IsEventioFormat() const {return kFALSE;}
};


class MCorsikaFormatEventIO : public MCorsikaFormat
{

public:
    MCorsikaFormatEventIO(std::istream *in)
        : MCorsikaFormat(in) {}


    Bool_t NextBlock(Int_t   readState, Int_t & blockType, Int_t & blockVersion,
                     Int_t & blockIdentifier, Int_t & blockLength) const;

    Bool_t SeekEvtEnd();

    Bool_t IsEventioFormat() const { return kTRUE; }

};

#endif

