#ifndef MARS_MDrsCalibration
#define MARS_MDrsCalibration

// -------------------------------------------------------------------

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef MARS_DrsCalib
#include "DrsCalib.h"
#endif

class MDrsCalibration : public MParContainer, public DrsCalibration
{
public:
    MDrsCalibration(const char *name=0, const char *title=0)
    {
        fName  = name  ? name  : "MDrsCalibration";
        fTitle = title ? title : "";
    }

    bool ReadFits(TString str)
    {
        gSystem->ExpandPathName(str);

        const std::string msg = ReadFitsImp(str.Data());
        if (msg.empty())
            return true;

        *fLog << err << msg << std::endl;
        return false;
    }

    void Plot();

    ClassDef(MDrsCalibration, 1)
};

#endif
