#ifndef MARS_MDrsCalibration
#define MARS_MDrsCalibration

// -------------------------------------------------------------------

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

#ifndef ROOT_TSystem
#include <TSystem.h>
#endif

#ifndef MARS_MLogManip
#include "MLogManip.h"
#endif

#ifndef MARS_DrsCalib
#include "DrsCalib.h"
#endif


class MDrsCalibration : public MParContainer, public DrsCalibration
{
public:
    MDrsCalibration(const char *name=0, const char *title=0)
    {
        fName  = name  ? name  : "MDrsCalibration";
        fTitle = title ? title : "";
    }

    bool ReadFits(const TString &str)
    {
        gSystem->ExpandPathName(str);

        string msg;
        try
        {
            msg = ReadFitsImp(str.Data());
        }
        catch (const exception &e)
        {
            msg = e.what();
        }

        if (msg.empty())
        {
            *fLog << inf << "Read DRS calibration file " << fname << endl;
            return true;
        }

        *fLog << err << "Error reading from " << fname << ": " << msg << endl;
        return false;
    }

    void Plot();

    ClassDef(MDrsCalibration, 1)
};

#endif
