#ifndef MARS_MRawFitsRead
#define MARS_MRawFitsRead

#ifndef MARS_MRawFileRead
#include "MRawFileRead.h"
#endif

#include <vector>

class MRawFitsRead : public MRawFileRead
{
private:
    std::vector<UInt_t> fPCTime; //! Buffer

    istream *OpenFile(const char *filename);
    Bool_t   ReadRunHeader(istream &fin);
    Bool_t   InitReadData(istream &fin);
    Bool_t   ReadEvent(istream &fin);
    void     SkipEvent(istream &fin);

public:
    MRawFitsRead(const char *filename=NULL, const char *name=NULL, const char *title=NULL);

    static Bool_t IsFits(const char *name);

    ClassDef(MRawFitsRead, 0)	// Task to read the raw data binary file
};

#endif
