#ifndef MARS_MOptics
#define MARS_MOptics

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class MQuaternion;

class MOptics : public MParContainer
{
public:
    MOptics(const char *name=NULL, const char *title=NULL);

    virtual Double_t GetMaxR() const = 0;
    virtual Double_t GetA() const = 0;
    virtual Bool_t CanHit(const MQuaternion &p) const = 0;

    virtual Int_t ExecuteOptics(MQuaternion &p, MQuaternion &u) const = 0;

    virtual Bool_t IsValid() const = 0;

    ClassDef(MOptics, 1) // Base class for optics (reflector, lens)
};

#endif
