#ifndef MARS_MOptics
#define MARS_MOptics

#ifndef MARS_MParContainer
#include "MParContainer.h"
#endif

class TVector3;
class MQuaternion;

class MOptics : public MParContainer
{
public:
    MOptics(const char *name=NULL, const char *title=NULL);

    virtual Double_t GetMaxR() const = 0;
    virtual Double_t GetA() const = 0;
    virtual Bool_t CanHit(const MQuaternion &p) const = 0;

    virtual Int_t ExecuteOptics(MQuaternion &p, MQuaternion &u, const Short_t &wavelength) const = 0;

    virtual Bool_t IsValid() const = 0;

    // -----------------------------------------------------------

    static double CriticalAngle(double n1, double n2);

    static double SchlickReflectivity(double alpha, double n1, double n2);
    static double SchlickReflectivity(const TVector3 &u, const TVector3 &n, double n1, double n2);

    static bool ApplyRefraction(TVector3 &u, const TVector3 &n, double n1, double n2);
    static bool ApplyRefraction(MQuaternion &u, const TVector3 &n, double n1, double n2);

    static int ApplyTransitionFast(TVector3 &u, TVector3 n, double n1, double n2);
    static int ApplyTransitionFast(MQuaternion &u, const TVector3 &n, double n1, double n2);

    static int ApplyTransition(TVector3 &u, TVector3 n, double n1, double n2, bool fresnel=true);
    static int ApplyTransition(MQuaternion &u, const TVector3 &n, double n1, double n2, bool fresnel=true);

    ClassDef(MOptics, 1) // Base class for optics (reflector, lens)
};

#endif
