#ifndef MARS_Nova
#define MARS_Nova

#include <libnova/solar.h>
#include <libnova/lunar.h>
#include <libnova/rise_set.h>
#include <libnova/transform.h>

namespace Nova
{
    typedef ln_lnlat_posn LnLatPosn;
    typedef ln_hrz_posn   HrzPosn;
    typedef ln_equ_posn   EquPosn;
    typedef ln_rst_time   RstTime;

    HrzPosn GetHrzFromEqu(const EquPosn &obj, const LnLatPosn &obs, double jd)
    {
        HrzPosn hrz;
        ln_get_hrz_from_equ(const_cast<EquPosn*>(&obj), const_cast<LnLatPosn*>(&obs), jd, &hrz);
        return hrz;
    }

    RstTime GetSolarRst(double jd, const LnLatPosn &obs, double hrz=LN_SOLAR_STANDART_HORIZON)
    {
        RstTime rst;
        ln_get_solar_rst_horizon(jd, const_cast<LnLatPosn*>(&obs), hrz, &rst);
        return rst;
    }

    RstTime GetLunarRst(double jd, const LnLatPosn &obs)
    {
        RstTime rst;
        ln_get_lunar_rst(jd, const_cast<LnLatPosn*>(&obs), &rst);
        return rst;
    }

    double GetLunarDisk(double jd)
    {
        return ln_get_lunar_disk(jd);
    }

    EquPosn GetLunarEquCoords(double jd, double precision=0)
    {
        EquPosn equ;
        ln_get_lunar_equ_coords_prec(jd, &equ, precision);
        return equ;
    }
}

#endif
