// ==========================================================================
// ============ see plot_ranger function at the end of the file =============
// ==========================================================================
void plot_resolution()
{
    // Get the profile produced by Draw from the current pad
    TProfile *p = (TProfile*)gPad->FindObject("htemp");
    if (!p)
        return;

    // Change errors from error of mean to sqrt(variance) ("spread")
    p->SetErrorOption("s");

    // Create a new histogram with the errors as entries
    TH1D *h = p->ProjectionX("ptemp", "C=E");

    // Remove the profile from the pad and from memory
    delete p;

    // Split the title into x- and y-axis title and set them accordingly
    TObjArray *arr = TString(h->GetTitle()).Tokenize(":");
    h->SetXTitle(arr->At(1)->GetName());
    h->SetYTitle(arr->At(0)->GetName());
    delete arr;

    // Some additional configuration
    h->SetDirectory(0);
    h->SetStats(kFALSE);
    h->SetMinimum(0);

    // Draw the new histogram into the current pad
    h->Draw();
}

// ==========================================================================
//
// Run the macro with
//
//      root hawc/plot_ranger.C
//
// The default file name is "ranger.csv.root", To change this use
//
//      root -b -q hawc/ratescan.C\(\"myfile.root\"\)
//
// The defaul ttree name is "Events", To change this use
//
//      root -b -q hawc/ratescan.C\(\"myfile.root\",\"MyTree\"\)
//
// From within root, the escape characters can be omitted, e.g.
//
//      root
//      [0] .x hawc/ratescan.C("myfile.root","MyTree")
//
// ==========================================================================

void plot_ranger(const char *filename="ranger.csv.root", const char *tree="Events")
{
    // Crate a chian to read the trees and add the file
    // (or all files if wildcards are used)
    TChain c(tree);
    c.Add(filename);

    // Create the display and set a title
    MStatusDisplay *d = new MStatusDisplay;
    d->SetTitle(filename);

    // ------------------------------------------------------------------

    TCanvas &c0 = d->AddTab("Pediction");
    gPad->SetGrid();
    c.Draw("Predictions:True", "", "col");
    c.Draw("Predictions:True", "", "same");

    TGraph *g = (TGraph*)gPad->FindObject("Graph");
    if (!g)
        return;

    TF1 equal("equal", "x", -1e100, 1e100);
    equal.DrawCopy("same");

    // ------------------------------------------------------------------

    TF1 zero("zero", "0", -1e100, 1e100);
    zero.SetLineStyle(kDashed);
    zero.SetLineWidth(1);
    zero.SetLineColor(kBlue);

    TCanvas &c1 = d->AddTab("Bias");
    c1.Divide(2,2);

    c1.cd(1);
    c.Draw("Predictions-True:True", "", "col");
    c.Draw("Predictions-True:True", "", "same");
    zero.DrawCopy("same");

    c1.cd(2);
    c.Draw("Predictions-True:Predictions", "", "col");
    c.Draw("Predictions-True:Predictions", "", "same");
    zero.DrawCopy("same");

    c1.cd(3);
    c.Draw("(Predictions-True)/True:True", "", "col");
    c.Draw("(Predictions-True)/True:True", "", "same");
    zero.DrawCopy("same");

    c1.cd(4);
    c.Draw("(Predictions-True)/Predictions:Predictions", "", "col");
    c.Draw("(Predictions-True)/Predictions:Predictions", "", "same");
    zero.DrawCopy("same");

    // ------------------------------------------------------------------

    TCanvas &c2 = d->AddTab("Resolution");
    c2.Divide(2,2);

    c2.cd(1);
    c.Draw("Predictions-True:True", "", "prof");
    plot_resolution();

    c2.cd(2);
    c.Draw("Predictions-True:Predictions", "", "prof");
    plot_resolution();

    c2.cd(3);
    c.Draw("(Predictions-True)/True:True", "", "prof");
    plot_resolution();

    c2.cd(4);
    c.Draw("(Predictions-True)/Predictions:Predictions", "", "prof");
    plot_resolution();

    // ------------------------------------------------------------------

    TObjArray *leaves = c.GetListOfLeaves();

    TIter Next(leaves);
    TObject *o=0;
    while ((o=Next()))
    {
        TString name = o->GetName();
        if (name=="True" || name=="Predictions")
            continue;

        TCanvas &cc = d->AddTab(name);
        cc.Divide(2,2);

        cc.cd(1);
        c.Draw("Predictions-True:"+name, "", "col");
        c.Draw("Predictions-True:"+name, "", "same");
        zero.DrawCopy("same");

        cc.cd(2);
        c.Draw("(Predictions-True)/Predictions:"+name, "", "col");
        c.Draw("(Predictions-True)/Predictions:"+name, "", "same");
        zero.DrawCopy("same");

        cc.cd(3);
        c.Draw("Predictions-True:"+name, "", "prof");
        plot_resolution();

        cc.cd(4);
        c.Draw("(Predictions-True)/Predictions:"+name, "", "prof");
        plot_resolution();
    }

    // ------------------------------------------------------------------
    // To store the display into a root or pdf file do

    //d->SaveAs("display.root");
    d->SaveAs("display.pdf");
}
