path_synchron=""
path_hawc=""
path_tel=""
output_path=""

hawc_files=$(ls $path_hawc)
tel_files=$(ls $path_tel)

hawc_keys="_reco.root"
tel_keys="_Y.root"

hawc_list=()      # list of HAWC files in path_hawc
tel_list=()       # list of HAWC's Eye files in path_tel

# Search for reco HAWC files in path_hawc and add to hawc_list
for hfile in ${hawc_files[@]};do
  hfile_name="$hfile"

  hfile_type=${hfile_name:20}

  if [ "$hfile_type" = "_reco.root" ];then
    hawc_list+=($hfile_name)
  fi

done

# Search for HAWC'sEye files in path_tel and add to tel_list
for telfile in ${tel_files[@]};do
  telfile_name="$telfile"

  telfile_type=${telfile_name:12}

  if [ "$telfile_type" = "_Y.root" ];then
    tel_list+=($telfile_name)

  fi
done

# Run synchron.C
for hawc_file in ${hawc_list[@]};do
  for tel_file in ${tel_list[@]};do
  rootcern -b -q $path_synchron\(\"$path_hawc$hawc_file\",\"$path_tel$tel_file\",\"$output_path${hawc_file:0:20}"_"$tel_file\"\)
  done
done
