#ifndef MARS_MGeomCamFAMOUS
#define MARS_MGeomCamFAMOUS

#ifndef MARS_MGeomCam
#include "MGeomCam.h"
#endif

class MGeomCamFAMOUS : public MGeomCam
{
private:
    enum { kDirCenter, kDirNE, kDirNW, kDirW, kDirSW, kDirSE, kDirE };

    static Double_t CalcXY(Int_t dir, Int_t ring, Int_t i, Double_t &x, Double_t &y);

    void CreateCam(bool all=true);

public:
    MGeomCamFAMOUS(const char *name=NULL);
    MGeomCamFAMOUS(Double_t dist, const char *name=NULL);
    MGeomCamFAMOUS(Double_t dist, bool all, const char *name=NULL);

    Bool_t HitFrame(MQuaternion p, const MQuaternion &u) const;

    ClassDef(MGeomCamFAMOUS, 1) // Geometry class for the final FAMOUS camera
};

#endif
