

void currents(const char *fname, double beg=0, double end=100000)
{
    fits file(fname);

    //file.PrintColumns();
    //file.PrintKeys();

    Double_t time;
    Double_t jd;

    float Imon[64];
    float Tmon[64];
    float Umon[64];
    float Tpsu[2];
    file.SetPtrAddress("Time",  &time);
    file.SetPtrAddress("Imon",  Imon);
    file.SetPtrAddress("Tmon",  Tmon);
    file.SetPtrAddress("Vmon",  Umon);
    file.SetPtrAddress("Tpsu",  Tpsu);

    UInt_t offset = file.GetUInt("MJDREF");
    if (beg < 30000)
        beg+=offset;
    if (end < 30000)
        end+=offset;

    double AvgUmed = 0;
    double AvgTmed = 0;
    double AvgImed = 0;
    double AvgUavg = 0;
    double AvgTavg = 0;
    double AvgIavg = 0;
    double AvgUrms = 0;
    double AvgTrms = 0;
    double AvgIrms = 0;
    double AvgUdev = 0;
    double AvgTdev = 0;
    double AvgIdev = 0;
    double AvgPsu  = 0;
/*
    double RmsUmed = 0;
    double RmsTmed = 0;
    double RmsImed = 0;
    double RmsUavg = 0;
    double RmsTavg = 0;
    double RmsIavg = 0;
    double RmsUrms = 0;
    double RmsTrms = 0;
    double RmsIrms = 0;
    double RmsPsu  = 0;
*/
    int count = 0;

    double Umed = 0;
    double Tmed = 0;
    double Imed = 0;
    double Udev = 0;
    double Tdev = 0;
    double Idev = 0;
    double Uavg = 0;
    double Tavg = 0;
    double Iavg = 0;
    double Urms = 0;
    double Trms = 0;
    double Irms = 0;

    double psu = 0;

    double diff  = -1;

    while (file.GetNextRow())
    {
        time += offset;
        jd    = time + 2400000.5;

        if (time>end)
            break;

        Udev = MMath::MedianDev(64, Umon, Umed);
        Tdev = MMath::MedianDev(64, Tmon, Tmed);
        Idev = MMath::MedianDev(64, Imon, Imed);
        Uavg = TMath::Mean(64, Umon);
        Tavg = TMath::Mean(64, Tmon);
        Iavg = TMath::Mean(64, Imon);
        Urms = TMath::RMS(64, Umon);
        Trms = TMath::RMS(64, Tmon);
        Irms = TMath::RMS(64, Imon);

        psu  = (Tpsu[0]+Tpsu[1])/2;

        if (time<beg)
        {
            diff = beg-time;
            continue;
        }

        AvgUmed += Umed;
        AvgTmed += Tmed;
        AvgImed += Imed;
        AvgUavg += Uavg;
        AvgTavg += Tavg;
        AvgIavg += Iavg;
        AvgUrms += Urms;
        AvgTrms += Trms;
        AvgIrms += Irms;
        AvgUdev += Udev;
        AvgTdev += Tdev;
        AvgIdev += Idev;
        AvgPsu  += psu;

        count ++;
    }

    if (count==0)
    {
        if (diff<5./24/3600)
        {
            cout << "result";
            cout << " NULL";
            cout << " NULL";
            cout << " NULL";
            cout << " NULL";
            cout << " NULL";
            cout << " NULL";
            cout << " NULL";
            cout << " NULL";
            cout << " NULL";
            cout << " NULL";
            cout << " NULL";
            cout << " NULL";
            cout << " NULL";
            cout << endl;
            return;
        }

        cout << "result";
        cout << " " << Umed;
        cout << " " << Uavg;
        cout << " " << Udev;
        cout << " " << Urms;

        cout << " " << Imed;
        cout << " " << Iavg;
        cout << " " << Idev;
        cout << " " << Irms;

        cout << " " << Tmed;
        cout << " " << Tavg;
        cout << " " << Tdev;
        cout << " " << Trms;

        cout << " " << psu;
        cout << endl;
        return;
    }

    AvgUmed /= count;
    AvgImed /= count;
    AvgTmed /= count;

    AvgUavg /= count;
    AvgIavg /= count;
    AvgTavg /= count;

    AvgUrms /= count;
    AvgIrms /= count;
    AvgTrms /= count;

    AvgUdev /= count;
    AvgIdev /= count;
    AvgTdev /= count;

    AvgPsu  /= count;


    cout << "result";
    cout << " " << AvgUmed;
    cout << " " << AvgUavg;
    cout << " " << AvgUdev;
    cout << " " << AvgUrms;

    cout << " " << AvgImed;
    cout << " " << AvgIavg;
    cout << " " << AvgIdev;
    cout << " " << AvgIrms;

    cout << " " << AvgTmed;
    cout << " " << AvgTavg;
    cout << " " << AvgTdev;
    cout << " " << AvgTrms;

    cout << " " << AvgPsu;

    cout << endl;
}
