#/bin/bash

# This is the directory in which to serach for files
DIR="/data/raw"
# This is the path to the fitsdump executable
FITSDUMP=~/FACT++/build/fitsdump
# File to which the queries are written
OUTPUT="insert-queries.sql"

# Remove an existing file with queries
rm -f ${OUTPUT}

# Loop over all tokens returned by the given bash extension
for SUBDIR in ${DIR}/[0-9][0-9][0-9][0-9]/[0-9][0-9]/[0-9][0-9]
do

   # Extract year, month and day from directory name 
   YEAR=`echo ${SUBDIR} | cut -f6 -d\/`
   MONTH=`echo ${SUBDIR} | cut -f7 -d\/`
   DAY=`echo ${SUBDIR} | cut -f8 -d\/`

   # Loop over all files in this subdirectory
   for ROOT in ${SUBDIR}/${YEAR}${MONTH}${DAY}*.fits.fz
   do
      FILE=`echo ${ROOT} | cut -f2 -d_`
      echo ${YEAR} ${MONTH} ${DAY} ${FILE} ${ROOT}

      # Extact the header from the fits file with fitsdump, the following chain
      # properly formats the output, replaces T/F with true/false, replaces
      # run-ytpes by numeric types, adds enclosures for SQL variable names where
      # necessary, removes enclosures around hex-numbers and adds commas
      # after all lines except the last one
      RESULT=`${FITSDUMP} -h ${ROOT} \
         | grep 'NIGHT\|RUNID\|TSTART\|TSTOP\|STEP\|DATE\|NROI[^T]\|DAC[0-7]\|DNA[01][^0-9]\|FWVER[01][^0-9]\|DRSCALIB\|NTRG\|NTRG\|ZNAXIS2\|REFCLK\|ZRATIO\|RUNTYPE' \
         | grep -v CHECKSUM \
         | cut -c4-  \
         | cut -f1 -d\/ \
         | sed "s/'drs-pedestal'/1/g" \
         | sed "s/'drs-gain'/2/g" \
         | sed "s/'pedestal'/3/g" \
         | sed "s/'data'/4/g" \
         | sed "s/'custom'/0/g" \
         | sed 's/\ T\ /true/g' \
         | sed 's/\ F\ /false/g' \
         | sed 's/^DATE-END/`DATE-END`/' \
         | sed 's/^DATE-OBS/`DATE-OBS`/' \
         | sed 's/^DATE[^-]/`DATE`/' \
         | sed "s/^\(.*\)'\(0x[0-9a-f]*\)'\(.*\)$/\1\2\3/g" \
         | sed '$!s/$/,/' >> query.txt`

      # count the number of lines in the result
      CNT=`echo ${RESULT} | wc -l`
      
      echo "== $CNT =="
      
      # If the result is not empty write the corresponding insert query to the file
      if [ $CNT -ne 0 ]
      then
          echo "INSERT INTO RawData SET" >> ${OUTPUT}
          echo ${RESULT}                 >> ${OUTPUT}
          echo ";"                       >> ${OUTPUT}                                     
      fi

   done

done
