// ==========================================================================
// ============ see plot_callisto function at the end of the file ===========
// ==========================================================================
int HandleInput(int evtnum)
{
    // This is a pure man's command line interface to wait for a key input
    // and allow exit but at the same time allow interaction with the GUI
    TTimer timer("gSystem->ProcessEvents();", 50, kFALSE);
    while (1)
    {
        // While reading the input process gui events asynchronously
        timer.TurnOn();
        const char *gl = Getline("Type 'q' to exit, or event number and <return> to go on: ");
        timer.TurnOff();

        TString input = gl;
        if (input=="q\n" || input==".q\n")
            return -1;

        if (input=="\n")
            return evtnum+1;

        return atoi(input.Data());
    };

    return -1;
}

// ==========================================================================
//
// Run the macro with
//
//      root hawc/plot_callisto.C\(\"00000001.003_Y_MonteCarlo003_Events.root\"\)
//
// The default file name is a Y-file (either as Monte Carlo-truth from ceres
// or from the callisto)
//
// From within root, the escape characters can be omitted, e.g.
//
//      root
//      [0] .x hawc/plot_callisto.C("00000001.003_Y_MonteCarlo003_Events.root")
//
// ==========================================================================

void plot_callisto(const char *fname)
{
    // Create the file for reading and get the tree
    TFile file(fname);
    if (file.IsZombie())
    {
        cout << "Could not open file." << endl;
        return;
    }

    TTree *T = 0;
    file.GetObject("Events", T);
    if (!T)
    {
        cout << "Could not access tree." << endl;
        return;
    }

    // Setup the branch with the calibrated datafor reading
    MSignalCam *signal = NULL;
    chain.SetBranchAddress("MSignalCam.", &signal);

    // Create the FAMOUS style camera with a
    // focal distance of 0.5m and 61 pixels
    MGeomCamFAMOUS geom(0.5, kFALSE);

    // Instantiate three camera histograms
    MHCamera cam_signal(geom);
    MHCamera cam_cleaned(geom);
    MHCamera cam_time(geom);

    // Setup names for the cameras
    cam_signal.SetName("Signal");
    cam_cleaned.SetName("Cleaned");
    cam_time.SetName("Time");

    // Fix minimum for amplitude at 0 ("disable zero suppression")
    cam_signal.SetMinimum(0);
    cam_cleaned.SetMinimum(0);

    // Create a canvas and divide it into 4 (2x2) pads
    // Add all four camera displays in the pads
    TCanvas c;
    c.Divide(2,2);

    c.cd(1);
    cam_signal.Draw();

    c.cd(2);
    cam_cleaned.Draw();

    c.cd(3);
    cam_time.Draw();

    // Loop over the data
    int evtnum = 0;
    while (evtnum>=0)
    {
        // Infinite loop (start over at the beginning)
        if (evtnum>=T->GetEntries())
            evtnum = 0;

        // Get event
        chain.GetEntry(evtnum);

        //  0: Number of Photons*PixRatio <default>
        //  1: Error*sqrt(PixRatio)
        //  2: Cleaning level = Num Photons*sqrt(PixRatio)/Error
        //  3: Number of Photons
        //  4: Error
        //  5: Island index
        //  6: arrival time of mapped pixels
        //  7: arrival time if signa avove 20phe
        //  8: arrival time
        // 10: as 0, but returns kFALSE if signal <=0
        // 11: as 8, but returns kFALSE if signal <=0

        // This is a function which directly copies the entries
        // from *signal into the camera histograms. The number
        // is an ID which contents to be copied. This could also
        // be done in a manula loop over all pixels.
        cam_signal.SetCamContent(*signal, 10); // num phot uncleaned
        cam_cleaned.SetCamContent(*signal, 3); // num phot cleaned
        cam_time.SetCamContent(*signal, 8); // arr time cleaned

        // Signal root that the objects displayed in all four pads
        // were changed and the pads have to be updated
        for (int i=0; i<4; i++)
        {
            c.GetPad(i+1)->Modified();
            c.GetPad(i+1)->Update();
        }

        // Wait for user intput
        evtnum = HandleInput(evtnum);
    }
}
