#!/bin/bash

# The data is expected to be found in /data/raw and data/callisto
DATA="/data"
CALLISTO=callisto
# The .success file in /data/star will be resetted
STAR=star
# Directory to Mars environment (usually Mars/build)
MARS=~/Mars/build
# Relative path to macros
MACROS=../hawc/processing

DATNIGHT=$1
DATRUNID=$2

# Split both into year, month, day
DATYEAR=`echo ${DATNIGHT}  | cut -c1-4`
DATMONTH=`echo ${DATNIGHT} | cut -c5-6`
DATDAY=`echo ${DATNIGHT}   | cut -c7-8`

DRSYEAR=`echo ${DRSNIGHT}  | cut -c1-4`
DRSMONTH=`echo ${DRSNIGHT} | cut -c5-6`
DRSDAY=`echo ${DRSNIGHT}   | cut -c7-8`

# Formatting of the file paths and names
DATPATH="${DATYEAR}/${DATMONTH}/${DATDAY}"
DRSPATH="${DRSYEAR}/${DRSMONTH}/${DRSDAY}"

PREFIX=`printf ${DATNIGHT}_%03d ${DATRUNID}`

DATNAME=`printf ${DATNIGHT}_%03d.fits.fz ${DATRUNID}`
DRSNAME=`printf ${DRSNIGHT}_%03d.drs.fits ${DRSRUNID}`

COUT=${DATA}/${CALLISTO}/${DATPATH}
SOUT=${DATA}/${STAR}/${DATPATH}

  echo ""
  echo DAT=${DATNAME} [${DATPATH}]
  echo DRS=${DRSNAME} [${DRSPATH}]

  # Check if not yet successfully processed
  # Removing this file can be used to trigger a re-processing
  # the next time this script is executed
  if [ ! -f "${OUT}/.${PREFIX}.success" ]
  then

     cd ${MARS}

     mkdir -p ${OUT}

     # Trigger reprocessing of the process-fils in the star directory
     rm -f "${DATA}/${STAR}/${DATPATH}/.${PREFIX}.*"

     # Flag that a process is running
     rm ${OUT}/.${PREFIX}.done
     rm ${OUT}/.${PREFIX}.success

     touch ${OUT}/.${PREFIX}.running

     # Execute the calibration and write output to log-file
     root -b -q -l ${MACROS}/callisto.C'("'${DATA}/raw/${DATPATH}/${DATNAME}'","'${DATA}/raw/${DRSPATH}/${DRSNAME}'","'${OUT}'")' \
        2>&1 | tee ${OUT}/${PREFIX}.log

     RC=${PIPESTATUS[0]}

     # Remember exit status of callisto
     echo RC=${RC} | tee -a ${OUT}/${PREFIX}.log
     echo ${RC} > ${OUT}/.${PREFIX}.done

     # Processing is finished
     rm -f ${OUT}/.${PREFIX}.running

     # If processing was successfull write corresponding flag
     if [ "${RC}" == "0" ]
     then
         touch ${OUT}/.${PREFIX}.success
     fi

     cd -

  else
     echo Skipped.
  fi

done
