#include <algorithm>

void trigger(const char *fname, double beg=0, double end=100000)
{
    fits file(fname);

    //file.PrintColumns();
    //file.PrintKeys();

    Double_t time;
    UShort_t adc;
    UInt_t dead, run;
    float temp;
    UInt_t qos;
    file.SetPtrAddress("QoS",  &qos);
    file.SetPtrAddress("Time", &time);
    //file.SetPtrAddress("adc",  &adc);
    file.SetPtrAddress("dead_time",  &dead);
    file.SetPtrAddress("run_time",   &run);
    file.SetPtrAddress("temp",       &temp);

    UInt_t offset = file.GetUInt("MJDREF");
    if (beg < 30000)
        beg+=offset;
    if (end < 30000)
        end+=offset;

    double average  = 0;
    double med_avg  = 0;
    double med_rms  = 0;
    UShort_t max_tot  = 0;
    int    cnt  = 0;

    double th_last = -1;
    float temp_last = -1;
    UShort_t max_last = -1;
    double diff = -1;

    double tot_dead = 0;
    double tot_run  = 0;
    double avg_temp = 0;
    double avg_th   = 0;
    int count = 0;


    while (file.GetNextRow())
    {
        if (qos!=4)
            continue;

        time += offset;

        if (time>end)
            break;

        if (time<beg)
        {
            //th_last   = adc;
            temp_last = temp;
            diff = beg-time;
            continue;
        }

        //avg_th   += adc;
        avg_temp += temp;
        tot_dead += dead;
        tot_run  += run,

        count ++;
    }

    if (count==0)
    {
        if (diff<5./24/3600)
            return;

        cout << "result NULL, NULL, NULL, " << temp_last << endl;
        return;
    }

    //avg_th   /= count;
    avg_temp /= count;

    cout << "result " << tot_run*10e-9 << ", " << tot_dead*10e-9 << ", " << 1.-tot_dead/tot_run << ", " << avg_temp << endl;
}
