#ifndef MARS_MImgCleanFAMOUS
#define MARS_MImgCleanFAMOUS

#ifndef MARS_MTask
#include "MTask.h"
#endif

class MGeomCam;
class MGeom;
class MSignalCam;
class MArrivalTime;

class MImgCleanFAMOUS : public MTask
{
private:
    static const TString gsNameGeomCam;    // default name of the 'MGeomCam' container
    static const TString gsNameSignalCam;  // default name of the 'MSignalCam' container

    const MGeomCam   *fCam;  //!
          MSignalCam *fEvt;  //!

    Float_t fSignalMin;
    Float_t fSignalMax;
    Float_t fTimeMin;
    Float_t fTimeMax;
    Float_t fSlopeMin;
    Float_t fSlopeMax;
    Float_t fTimeWindow;

    TString  fNameGeomCam;    // name of the 'MGeomCam' container
    TString  fNameSignalCam;  // name of the 'MSignalCam' container

    // MImgCleanFAMOUS
    void ResetCleaning() const;
    void FindIsland(Int_t) const;
    void DoCleaning() const;

    // MGTask, MTask, MParContainer
    Int_t ReadEnv(const TEnv &env, TString prefix, Bool_t print);
    //void  StreamPrimitive(ostream &out) const;

    Int_t PreProcess(MParList *pList);
    Int_t Process();

public:
    MImgCleanFAMOUS(const char *name=NULL, const char *title=NULL);

    void Print(Option_t *o="") const;

    void SetSignalMinMax(const Float_t &min, const Float_t &max) { fSignalMin=min; fSignalMax=max; }
    void SetTimeMinMax(const Float_t &min, const Float_t &max) { fTimeMin=min; fTimeMax=max; }
    void SetSlopeMinMax(const Float_t &min, const Float_t &max) { fSlopeMin=min; fSlopeMax=max; }
    void SetTimeWindow(const Float_t &deltat) { fTimeWindow=deltat; }

    void SetNameSignalCam(const char *name)   { fNameSignalCam = name; }
    void SetNameGeomCam(const char *name)     { fNameGeomCam = name; }

    ClassDef(MImgCleanFAMOUS, 1)    // task doing the image cleaning
}; 

#endif
