/***************************************************************************
 *   Copyright (C) 2004 by Martin Merck                                    *
 *   merck@astro.uni-wuerzburg.de                                          *
 *   
 *   This software is part of the MAGIC software.                                                                      *
 ***************************************************************************/

#ifndef _TAPER_H_
#define _TAPER_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <kmainwindow.h>

#include "taperview.h"

class KPrinter;
class KToggleAction;
class KURL;

/**
 * This class serves as the main window for Taper.  It handles the
 * menus, toolbars, and status bars.
 *
 * @short Main window class
 * @author Martin Merck <merck@astro.uni-wuerzburg.de>
 * @version 0.1
 */
class Taper : public KMainWindow
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    Taper();

    /**
     * Default Destructor
     */
    virtual ~Taper();

    /**
     * Use this method to load whatever file/URL you have
     */
    void load(const KURL& url);

protected:
    /**
     * Overridden virtuals for Qt drag 'n drop (XDND)
     */
    virtual void dragEnterEvent(QDragEnterEvent *event);
    virtual void dropEvent(QDropEvent *event);

protected:
    /**
     * This function is called when it is time for the app to save its
     * properties for session management purposes.
     */
    void saveProperties(KConfig *);

    /**
     * This function is called when this app is restored.  The KConfig
     * object points to the session management config file that was saved
     * with @ref saveProperties
     */
    void readProperties(KConfig *);


private slots:
    void fileNew();
    void fileOpen();
    void fileSave();
    void fileSaveAs();
    void filePrint();
    void optionsShowToolbar();
    void optionsShowStatusbar();
    void optionsConfigureKeys();
    void optionsConfigureToolbars();
    void optionsPreferences();
    void newToolbarConfig();

    void changeStatusbar(const QString& text);
    void changeCaption(const QString& text);

private:
    void setupAccel();
    void setupActions();

private:
    TaperView *m_view;

    KPrinter   *m_printer;
    KToggleAction *m_toolbarAction;
    KToggleAction *m_statusbarAction;
};

#endif // _TAPER_H_
