/***************************************************************************
 *   Copyright (C) 2004 by Martin Merck                                    *
 *   merck@astro.uni-wuerzburg.de                                          *
 *                                                                         *
 *   This software is part of the MAGIC software.                                                                      *
 ***************************************************************************/

#include "taper.h"
#include <kapplication.h>
#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>

static const char description[] =
    I18N_NOOP("A KDE Application");

static const char version[] = "0.1";

static KCmdLineOptions options[] =
{
    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("taper", I18N_NOOP("Taper"), version, description,
                     KAboutData::License_Custom, "(C) 2004 Martin Merck", 0, 0, "merck@astro.uni-wuerzburg.de");
    about.addAuthor( "Martin Merck", 0, "merck@astro.uni-wuerzburg.de" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions(options);
    KApplication app;

    // register ourselves as a dcop client
    app.dcopClient()->registerAs(app.name(), false);

    // see if we are starting with session management
    if (app.isRestored())
    {
        RESTORE(Taper);
    }
    else
    {
        // no session.. just start up normally
        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        if (args->count() == 0)
        {
            Taper *widget = new Taper;
            widget->show();
        }
        else
        {
            int i = 0;
            for (; i < args->count(); i++)
            {
                Taper *widget = new Taper;
                widget->show();
                widget->load(args->url(i));
            }
        }
        args->clear();
    }

    return app.exec();
}
