#ifndef MARS_MGenIRPhoton
#define MARS_MGenIRPhoton

#ifndef ROOT_TRandom
#include <TRandom.h>
#endif

class TF1;
class MParticle;

class MGenIRPhoton
{
private:
    TF1 *fSrc;

    TRandom fRand;

    Double_t fZ;

    static Double_t Planck(Double_t *x, Double_t *k=NULL);

public:
    MGenIRPhoton();
    virtual ~MGenIRPhoton();

    void SetZ(Double_t z) { fZ = z; }

    MParticle *GetRandom();

    ClassDef(MGenIRPhoton, 0) //
};
    
#endif

