//Double_t kRad2Deg = 180./TMath::Pi();

#include <float.h>
Double_t GetMin(TH1 *h)
{
    Double_t min = FLT_MAX;
    for (int i=1; i<=h->GetXaxis()->GetNbins(); i++)
    {
        if (h->GetBinContent(i)<min && h->GetBinContent(i)!=0)
            min = h->GetBinContent(i);
    }
    return min;
}

void GetRange(TChain *chain, const char *name, Double_t &min, Double_t &max)
{
    TString str("MPhoton.MParticle.");

    MPhoton *p = new MPhoton;

    chain->SetBranchAddress("MPhoton.", &p);

    min =  FLT_MAX;
    max = -FLT_MAX;

    Int_t n = chain->GetEntries();
    for (int i=0; i<n; i++)
    {
        chain->GetEntry(i);

        TLeaf *leaf = chain->GetLeaf(str+name);
        if (!leaf)
            return 0;
        Double_t val = leaf->GetValue();

        if (p->IsPrimary())
            continue;

        if (val < min)
            min = val;
        if (val > max)
            max = val;
    }
}

void analp()
{
    TChain chain("Photons");
    // chain.Add("cascade_100kpc_a_1e6.root");
    // chain.Add("cascade_100kpc_b_1e6.root");
    // chain.Add("cascade_500kpc_0*.root");
    chain.Add("cascade_500kpc_21d_0*.root");
    // chain.Add("cascade_100kpc_0*.root");
    // chain.Add("cascade_100kpc_14*.root");
    // chain.Add("cascade_100kpc_0*.root");
    // chain.Add("cascade_500kpc_21d_*.root");
    // chain.Add("cascade_100kpc_4*.root");
    // chain.Add("cascade_500kpc_21d_B1e-18_*.root");


    Int_t n = chain.GetEntries();

    cout << "Found " << n << " entries." << endl;

    if (n==0)
        return;

    MBinning binsx;
    binsx.SetEdgesLog(21, 1e4, 1e11);

    MBinning binspolx;
    MBinning binspola;
    MBinning binspolr;
    binspolx.SetEdges(16, -180, 180);

    const Double_t ls = 299792458;         // [m/s]
    const Double_t ly = 3600.*24.*365.*ls; // [m/ly]
    const Double_t pc = 1./3.258;          // [pc/ly]

    Double_t max;
    Double_t min;
    Int_t nbins=20;

    TTreePlayer &play = *chain.GetPlayer();

    GetRange(&chain, "fTheta", min, max);
    Double_t conv = kRad2Deg*60;
    min *= conv;
    max *= conv;
    cout << "fTheta: " << min  << " < " << max  << " [']" << endl;
    play.FindGoodLimits(10, nbins, min, max, kFALSE);
    cout << "    " << nbins << ": " << min << " < " << max << endl;
    binspola.SetEdges(nbins, min, max);

    GetRange(&chain, "fR", min, max);
    max/=4;
    cout << "fR:     " << min  << " < " << max  << " [kpc]" << endl;
    play.FindGoodLimits(10, nbins, min, max, kFALSE);
    cout << "    " << nbins << ": " << min << " < " << max << endl;
    binspolr.SetEdges(nbins, min, max);

    TH1D h;
    h.SetName("Photons");
    MH::SetBinning(&h, &binsx);

    TH1D prim;
    MH::SetBinning(&prim, &binsx);

    TH2D r;
    TH2D a;
    MH::SetBinning(&a, &binspolx, &binspola);
    MH::SetBinning(&r, &binspolx, &binspolr);

    MPhoton *p = new MPhoton;
    chain.SetBranchAddress("MPhoton.", &p);

    Double_t weight =  0;
    Double_t alpha  = -2;
    Double_t plot   =  2;
    Double_t E;
    for (int i=0; i<n; i++)
    {
        chain.GetEntry(i);

        Double_t Ep = p->GetEnergy();

        if (i==0)
            weight = pow(Ep, alpha);

        if (p->IsPrimary())
        {
            weight = pow(Ep, alpha);
            prim.Fill(Ep, pow(Ep,plot) * weight);
            E = Ep;
            continue;
        }

        //if (Ep==E)
        //    continue;

        h.Fill(Ep, pow(Ep,plot) * weight);
        Double_t v = p->GetPhi()*kRad2Deg;
        r.Fill(fmod(v+180, 360)-180, p->GetR(), weight);
        v = p->GetPsi()*kRad2Deg;
        a.Fill(fmod(v+180, 360)-180, p->GetTheta()*kRad2Deg*60, weight);
    }

    delete p;

    TH1 *g=r.ProjectionX();
    cout << "Mean fPhi: " << g->GetMean() << " +- " << g->GetRMS() << endl;
    delete g;
    g=a.ProjectionX();
    cout << "Mean fPsi: " << g->GetMean() << " +- " << g->GetRMS() <<  endl;
    delete g;

    gStyle->SetOptStat(10);

    TLine line;

//    delete gROOT->FindObject("Analysis Arrival");
    c = MH::MakeDefCanvas("Analysis Arrival", "");
    c->Divide(2,2);

    c->cd(1);
    gPad->SetLogy();
    gPad->SetLogz();
    gPad->SetTheta(70);
    gPad->SetPhi(90);
    h.SetTitle(Form(" E^{%.1f}  Spectra ", alpha));
    h.SetXTitle("E\\gamma [GeV]");
    h.SetYTitle(Form("E^{%.1f} * Counts", plot));
    r.SetTitle(" Distance from Observer ");
    r.GetXaxis()->SetLabelOffset(-0.015);
    r.GetXaxis()->SetTitleOffset(1.1);
    r.GetXaxis()->SetRangeUser(1e4, 1e9);
    r.SetXTitle("\\Phi [\\circ]");
    r.SetYTitle("R [kpc]");
    r.DrawCopy("surf1pol");

    c->cd(2);
    gPad->SetLogy();
    gPad->SetLogz();
    gPad->SetTheta(70);
    gPad->SetPhi(90);
    a.SetTitle(" Hit Angle for Observer ");
    a.GetXaxis()->SetLabelOffset(-0.015);
    a.GetXaxis()->SetTitleOffset(1.1);
    a.GetXaxis()->SetRangeUser(1e4, 1e9);
    a.SetXTitle("\\Psi [\\circ]");
    a.SetYTitle("\\Theta [']");
    a.DrawCopy("surf1pol");

    c->cd(3);
    gPad->SetLogy();
    g=r.ProjectionY();
    g->SetMinimum(GetMin(g)/2);
    g->SetDirectory(NULL);
    g->SetBit(kCanDelete);
    g->SetTitle(" Hit Observers Plain ");
    g->GetXaxis()->SetLabelOffset(0);
    g->GetXaxis()->SetTitleOffset(1.1);
    g->GetYaxis()->SetTitleOffset(1.3);
    g->SetXTitle("R [kpc]");
    g->SetYTitle("Counts");
    g->Draw();

    c->cd(4);
    gPad->SetLogy();
    g=a.ProjectionY();
    g->SetMinimum(GetMin(g)/2);
    g->SetDirectory(NULL);
    g->SetBit(kCanDelete);
    g->SetTitle("Hit Angle");
    g->GetXaxis()->SetLabelOffset(0);
    g->GetXaxis()->SetTitleOffset(1.1);
    g->GetYaxis()->SetTitleOffset(1.3);
    g->SetXTitle("\\Phi [']");
    g->SetYTitle("Counts");
    g->Draw();

  //  delete gROOT->FindObject("Analysis Photons");
    TCanvas *c = MH::MakeDefCanvas("Analysis Photons", "", 580, 870);
    c->Divide(1,2);

    c->cd(1);
    gPad->SetLogx();
    gPad->SetLogy();
    prim.SetFillStyle(0);
    h.SetFillStyle(0);
    h.GetXaxis()->SetLabelOffset(-0.015);
    h.GetXaxis()->SetTitleOffset(1.1);
//    h.GetXaxis()->SetRangeUser(1e4, 1e9);
    prim.SetMarkerStyle(kPlus);
    h.SetMarkerStyle(kMultiply);
    prim.SetMarkerColor(kRed);
    prim.SetLineColor(kRed);

    h.DrawCopy("P");
    prim.DrawCopy("Psame");
    prim.DrawCopy("Csame");
    h.DrawCopy("Csame");
 
    c->cd(2);
    gPad->SetLogx();
    TH1D div;
    MH::SetBinning(&div, &binsx);
    div.Divide(&h, &prim);
    div.SetTitle("Spectrum / Primary Spectrum");
    div.GetXaxis()->SetLabelOffset(-0.015);
    div.GetXaxis()->SetTitleOffset(1.1);
    div.SetXTitle("E\\gamma [GeV]");
    div.SetYTitle("Ratio");
    line.SetLineColor(kBlue);
    line.SetLineWidth(1);
    div.DrawCopy();
    line.DrawLine(4, 1, 11, 1);
}
