//Double_t kRad2Deg = 180./TMath::Pi();

#include <float.h>

Double_t GetMin(TH1 *h)
{
    Double_t min = FLT_MAX;
    for (int i=1; i<=h->GetXaxis()->GetNbins(); i++)
    {
        if (h->GetBinContent(i)<min && h->GetBinContent(i)!=0)
            min = h->GetBinContent(i);
    }
    return min;
}

void GetRange(TChain *chain, const char *name, Int_t &nbins, Double_t &min, Double_t &max, Double_t conv=1)
{
    TString str("MPhoton.MParticle.");

    MPhoton *p = new MPhoton;

    chain->SetBranchAddress("MPhoton.", &p);

    min =  FLT_MAX;
    max = -FLT_MAX;

    Int_t n = chain->GetEntries();
    for (int i=0; i<n; i++)
    {
        chain->GetEntry(i);

        TLeaf *leaf = chain->GetLeaf(str+name);
        if (!leaf)
            return 0;

        Double_t val = leaf->GetValue();

        if (p->IsPrimary())
            continue;

        if (val < min)
            min = val;
        if (val > max)
            max = val;
    }

    min *= conv;
    max *= conv;

    chain.GetPlayer();
    TTreePlayer &play = *chain.GetPlayer();

    Int_t n;
    play.FindGoodLimits(nbins, n, min, max, kFALSE);
    nbins = n;
}

void analp()
{
    TChain chain("Photons");
    chain.Add("cascade_500kpc_*.root");

    MBinning binsx;
    binsx.SetEdgesLog(21, 1e4, 1e11);

    Double_t alpha = -1.8;
    Double_t plot  =  1.8;

    Int_t nbins = 20;

    // ------------------------------

    Int_t n = chain.GetEntries();

    cout << endl << "Found " << n << " entries." << endl;

    if (n==0)
        return;

    MBinning binspolx;
    MBinning binspola;
    MBinning binspolr;
    binspolx.SetEdges(16, -180, 180);

    Double_t min, max;
    GetRange(&chain, "fTheta", nbins, min, max, kRad2Deg*60);
    binspola.SetEdges(nbins, min, max);
    cout << "fTheta, " << nbins << ": " << min << " ... " << max << " [']" << endl;

    GetRange(&chain, "fR", nbins, min, max);
    binspolr.SetEdges(nbins, min, max);
    cout << "fR,     " << nbins << ": " << min << " ... " << max << " [kpc]" << endl;

    TH1D h;
    TH1D prim;
    MH::SetBinning(&h, &binsx);
    MH::SetBinning(&prim, &binsx);

    TH2D r;
    TH2D a;
    MH::SetBinning(&a, &binspolx, &binspola);
    MH::SetBinning(&r, &binspolx, &binspolr);

    MPhoton *p = new MPhoton;
    chain.SetBranchAddress("MPhoton.", &p);

    chain.GetEntry(0);
    if (!p->IsPrimary())
        return;

    Double_t z = p->GetZ();
    Double_t R = MParticle::RofZ(&z);

    cout << "Z = " << z << endl;
    cout << "R = " << R << "kpc" << endl;

    Double_t weight = 0;

    for (int i=0; i<n; i++)
    {
        chain.GetEntry(i);

        Double_t Ep = p->GetEnergy();

        if (p->IsPrimary())
        {
            weight = pow(Ep, alpha);
            prim.Fill(Ep, pow(Ep, plot+alpha));
            continue;
        }

        h.Fill(Ep, pow(Ep,plot) * weight);

        Double_t phi = fmod(p->GetPhi()*kRad2Deg+180, 360)-180;
        Double_t psi = fmod(p->GetPsi()*kRad2Deg+180, 360)-180;

        r.Fill(phi, p->GetR(),                 weight);
        a.Fill(psi, p->GetTheta()*kRad2Deg*60, weight);
    }

    delete p;

    TH1 *g=r.ProjectionX();
    cout << "Mean fPhi: " << g->GetMean() << " +- " << g->GetRMS() << endl;
    delete g;
    g=a.ProjectionX();
    cout << "Mean fPsi: " << g->GetMean() << " +- " << g->GetRMS() <<  endl;
    delete g;

    gStyle->SetOptStat(10);

    TLine line;

//    delete gROOT->FindObject("Analysis Arrival");
    c = MH::MakeDefCanvas("Analysis Arrival", "");
    c->Divide(2,2);

    gStyle->SetPalette(1, 0);

    c->cd(1);
    r.SetTitle(" Distance from Observer ");
    r.GetXaxis()->SetLabelOffset(-0.015);
    r.GetXaxis()->SetTitleOffset(1.1);
    r.GetXaxis()->SetRangeUser(1e4, 1e9);
    r.SetXTitle("\\Phi [\\circ]");
    r.SetYTitle("R [kpc]");
    TPad &pad = *gPad;
    pad.Divide(2,2);
    pad.cd(1);
    gPad->SetLogy();
    gPad->SetLogz();
    gPad->SetTheta(0);
    gPad->SetPhi(90);
    g = r.DrawCopy("surf1pol");
    pad.cd(2);
    gPad->SetLogy();
    gPad->SetLogz();
    gPad->SetTheta(70);
    gPad->SetPhi(90);
    g->Draw("surf1pol");
    pad.cd(3);
    gPad->SetLogy();
    gPad->SetLogz();
    gPad->SetTheta(90);
    gPad->SetPhi(90);
    g->Draw("surf1pol");
    pad.cd(4);
    gPad->SetLogy();
    gPad->SetLogz();
    gPad->SetTheta(20);
    gPad->SetPhi(90);
    g->Draw("surf1pol");

    c->cd(2);
    a.SetTitle(" Hit Angle for Observer ");
    a.GetXaxis()->SetLabelOffset(-0.015);
    a.GetXaxis()->SetTitleOffset(1.1);
    a.GetXaxis()->SetRangeUser(1e4, 1e9);
    a.SetXTitle("\\Psi [\\circ]");
    a.SetYTitle("\\Theta [']");
    TPad &pad = *gPad;
    pad.Divide(2,2);
    pad.cd(1);
    gPad->SetLogy();
    gPad->SetLogz();
    gPad->SetTheta(0);
    gPad->SetPhi(90);
    g = a.DrawCopy("surf1pol");
    pad.cd(2);
    gPad->SetLogy();
    gPad->SetLogz();
    gPad->SetTheta(70);
    gPad->SetPhi(90);
    g->Draw("surf1pol");
    pad.cd(3);
    gPad->SetLogy();
    gPad->SetLogz();
    gPad->SetTheta(90);
    gPad->SetPhi(90);
    g->Draw("surf1pol");
    pad.cd(4);
    gPad->SetLogy();
    gPad->SetLogz();
    gPad->SetTheta(20);
    gPad->SetPhi(90);
    g->Draw("surf1pol");

    c->cd(3);
    gPad->SetLogy();
    g=r.ProjectionY();
    g->SetMinimum(GetMin(g)/2);
    g->SetDirectory(NULL);
    g->SetBit(kCanDelete);
    g->SetTitle(" Hit Observers Plain ");
    g->GetXaxis()->SetLabelOffset(0);
    g->GetXaxis()->SetTitleOffset(1.1);
    g->GetYaxis()->SetTitleOffset(1.3);
    g->SetXTitle("R [kpc]");
    g->SetYTitle("Counts");
    g->Draw();

    c->cd(4);
    gPad->SetLogy();
    g=a.ProjectionY();
    g->SetMinimum(GetMin(g)/2);
    g->SetDirectory(NULL);
    g->SetBit(kCanDelete);
    g->SetTitle("Hit Angle");
    g->GetXaxis()->SetLabelOffset(0);
    g->GetXaxis()->SetTitleOffset(1.1);
    g->GetYaxis()->SetTitleOffset(1.3);
    g->SetXTitle("\\Phi [']");
    g->SetYTitle("Counts");
    g->Draw();

  //  delete gROOT->FindObject("Analysis Photons");
    TCanvas *c = MH::MakeDefCanvas("Analysis Photons", "", 580, 870);
    c->Divide(1,2);

    c->cd(1);
    gPad->SetLogx();
    gPad->SetLogy();
    h.SetFillStyle(0);
    h.SetName("Photons");
    h.SetTitle(Form(" E^{%.1f}  Spectra ", alpha));
    h.SetXTitle("E\\gamma [GeV]");
    h.SetYTitle(Form("E^{%.1f} * Counts", plot));
    h.GetXaxis()->SetLabelOffset(-0.015);
    h.GetXaxis()->SetTitleOffset(1.1);
    h.SetMarkerStyle(kMultiply);
    prim.SetFillStyle(0);
    prim.SetMarkerStyle(kPlus);
    prim.SetMarkerColor(kRed);
    prim.SetLineColor(kRed);
    TH1 &g1=*h.DrawCopy("P");
    TH1 &g2=*prim.DrawCopy("Psame");
    g2.Draw("Csame");
    g1.Draw("Csame");
 
    c->cd(2);
    gPad->SetLogx();
    TH1D div;
    MH::SetBinning(&div, &binsx);
    div.Divide(&h, &prim);
    div.SetTitle("Spectrum / Primary Spectrum");
    div.GetXaxis()->SetLabelOffset(-0.015);
    div.GetXaxis()->SetTitleOffset(1.1);
    div.SetXTitle("E\\gamma [GeV]");
    div.SetYTitle("Ratio");
    line.SetLineColor(kBlue);
    line.SetLineWidth(1);
    div.DrawCopy();
    line.DrawLine(4, 1, 11, 1);
}
