//Double_t kRad2Deg = 180./TMath::Pi();

void anale()
{
    TChain chain("Electrons");
//    chain.Add("cascade_100kpc_0*.root");
//    chain.Add("cascade_100kpc_14*.root");
//    chain.Add("cascade_100kpc_4*.root");
    chain.Add("cascade_100kpc_21d.root");
/*
    chain.Add("cascade_100kpc_01.root");
    chain.Add("cascade_100kpc_02.root");
    chain.Add("cascade_100kpc_03.root");
    */


    MElectron *e = new MElectron;
    chain.SetBranchAddress("MElectron.", &e);

    Int_t n = chain.GetEntries();

    cout << "Found " << n << " entries." << endl;

    MBinning binsx;
    MBinning binsy;
    MBinning binsr;
    binsx.SetEdgesLog(80, 1e1, 1e9);
    binsy.SetEdgesLog(80, 1e1, 1e9);
    binsr.SetEdgesLog(84, 1e-5, 1.8);

    TH2D h;
    h.SetName("Photons");
    h.SetTitle(" Photons from inv.Compton ");
    h.SetXTitle("E_{e} [GeV]");
    h.SetYTitle("E\\gamma [GeV]");
    h.SetZTitle("Counts");
    MH::SetBinning(&h, &binsx, &binsy);

    TH2D r;
    r.SetName("ratio");
    r.SetTitle("Ratio E\\gamma / E_{e}");
    r.SetXTitle("E_{e} [GeV]");
    r.SetYTitle("Ratio");
    r.SetZTitle("Counts");
    MH::SetBinning(&r, &binsx, &binsr);

    Double_t E = -1;
    for (int i=0; i<n; i++)
    {
        chain.GetEntry(i);

        if (e->IsPrimary())
        {
            E = e->GetEnergy();
            continue;
        }

        Double_t dE = E - e->GetEnergy();

        h.Fill(E, dE);
        r.Fill(E, dE/E);

        E = e->GetEnergy();
    }

    delete e;

    gStyle->SetOptStat(10);

    TLine line;
    line.SetLineColor(kBlack);
    line.SetLineWidth(1);

    TCanvas *c = new TCanvas("c1", "name");
    c->Divide(2,2);

    c->cd(1);
    gPad->SetLogx();
    gPad->SetLogy();
    h.GetXaxis()->SetRangeUser(5e3, 1e9);
    h.GetXaxis()->SetLabelOffset(-0.015);
    h.GetXaxis()->SetTitleOffset(1.1);
    h.GetYaxis()->SetTitleOffset(1.1);
//    h.SetMinimum(1e1);
//    h.SetMaximum(1e9);
    h.DrawCopy();
    TH1 *p=h.ProfileX();
    p->SetDirectory(NULL);
    p->SetBit(kCanDelete);
    p->SetLineColor(kRed);
    p->Draw("same");
    line.DrawLine(4.2, 4.2, 8.8, 8.8);

    c->cd(2);
    gPad->SetLogx();
    gPad->SetLogy();
    r.GetXaxis()->SetLabelOffset(-0.015);
    r.GetXaxis()->SetTitleOffset(1.1);
    r.GetXaxis()->SetRangeUser(1e4, 1e9);
    r.DrawCopy();
    p=r.ProfileX();
    p->SetDirectory(NULL);
    p->SetBit(kCanDelete);
    p->SetLineColor(kRed);
    p->Draw("same");

    c->cd(3);
    gPad->SetLogx();
    p=h.ProjectionX();
    p->SetDirectory(NULL);
    p->SetBit(kCanDelete);
    p->SetTitle("e^{-} / \\gamma Distribution");
    p->GetXaxis()->SetLabelOffset(-0.015);
    p->GetXaxis()->SetTitleOffset(1.1);
    p->GetYaxis()->SetTitleOffset(1.3);
    p->SetXTitle("E [GeV]");
    p->SetYTitle("Counts");
    p->Draw();
    p=h.ProjectionY();
    p->SetDirectory(NULL);
    p->SetBit(kCanDelete);
    p->SetTitle("Projection Y");
    p->SetLineColor(kBlue);
    p->Draw("same");

    c->cd(4);
    gPad->SetLogx();
    p=r.ProjectionY();
    p->SetDirectory(NULL);
    p->SetBit(kCanDelete);
    p->SetTitle("Ratio E\\gamma / E_{e}");
    p->GetXaxis()->SetLabelOffset(-0.015);
    p->GetXaxis()->SetTitleOffset(1.1);
    p->GetYaxis()->SetTitleOffset(1.3);
    p->SetXTitle("Ratio");
    p->SetYTitle("Counts");
    p->SetLineColor(kBlue);
    p->Draw();
}
