#ifndef MARS_MElectron
#define MARS_MElectron

#ifndef MARS_MParticle
#include "MParticle.h"
#endif

class MPhoton;

class MElectron : public MParticle
{
public:
    MElectron(Double_t e=0, Double_t z=0, Bool_t type=kFALSE) : MParticle(type?MParticle::kEPositron:MParticle::kEElectron)
    {
        fEnergy = e;
        fZ      = z;
    }

    MElectron(MParticle &p, Bool_t type=kFALSE) : MParticle(p, type?MParticle::kEPositron:MParticle::kEElectron) { }
    MElectron(MParticle &p, Double_t e, Bool_t type=kFALSE) : MParticle(p, e, type?MParticle::kEPositron:MParticle::kEElectron) {}

    void operator=(MParticle &p) { MParticle::operator=(p); }

    // ----------------------------------------------------------------

    static Double_t DiSum(Double_t *x, Double_t *k=NULL);
    static Double_t Li(Double_t *x, Double_t *k);
    static Double_t Li2(Double_t *x, Double_t *k=NULL);
    static Double_t Flim(Double_t *x, Double_t *k=NULL);
    static Double_t Compton(Double_t *x, Double_t *k);
    static Double_t InteractionLength(Double_t *E, Double_t *k=NULL);
    static Double_t GetInteractionLength(Double_t E, Double_t z=0);

    Double_t GetInteractionLength() const;

    // ----------------------------------------------------------------

    static Double_t p_e(Double_t *x, Double_t *k);
    static Double_t G_q(Double_t *x, Double_t *k);
    static Double_t EnergyLoss(Double_t *E, Double_t *z=NULL, Double_t *ep=NULL);
    static Double_t GetEnergyLoss(Double_t E, Double_t z=0, Double_t *ep=NULL);

    Double_t GetEnergyLoss(Double_t *ep) const;

    // ----------------------------------------------------------------

    MPhoton *DoInvCompton(Double_t theta);
    Bool_t SetNewPositionB(Double_t B);

    // ----------------------------------------------------------------

    static void DrawInteractionLength(Double_t z);
    void DrawInteractionLength() const;

    ClassDef(MElectron, 1)
};

#endif
