#ifndef MARS_MPhoton
#define MARS_MPhoton

#ifndef MARS_MParticle
#include "MParticle.h"
#endif

class TH1;

class MPhoton : public MParticle
{
public:

    MPhoton(Double_t e=0, Double_t z=0)
        : MParticle(MParticle::kEGamma)
    {
        fEnergy = e;
        fZ      = z;
    }

        MPhoton(MParticle &p) : MParticle(p, MParticle::kEGamma) { }
        MPhoton(MParticle &p, Double_t e) : MParticle(p, e, MParticle::kEGamma) { }

    void operator=(MParticle &p) { MParticle::operator=(p); }

    void Fill(TH1 &h, Double_t idx, Double_t w) const;

    // ----------------------------------------------------------------

    static Double_t Sigma_gg(Double_t *x, Double_t *k=NULL);
    static Double_t Int1(Double_t *x, Double_t *k=NULL);
    static Double_t Int2(Double_t *x, Double_t *k);
    static Double_t InteractionLength(Double_t *x, Double_t *k=NULL);
    static Double_t GetInteractionLength(Double_t energy, Double_t z=0);

    Double_t GetInteractionLength() const;

    // ----------------------------------------------------------------

    static void DrawInteractionLength(Double_t z, Double_t from=2e2, Double_t to=1e11, Option_t*opt="");
    void DrawInteractionLength() const;

    ClassDef(MPhoton, 1)
};

#endif
