#include "MCascade.h"

void phys()
{
    MCascade cascade;

    cascade.SetSourceZ(0.1);             // Readshift of source
    cascade.SetB(0/*1e-6*/);             // [G] mean magnetic field
    cascade.SetBradius(50);              // [Mpc]
    cascade.SetRuntime(8*60);            // [min] maximum time to run the simulation
    cascade.SetEnergyBins(18, 1e2, 1e5); // [GeV]
    cascade.SetMaxInvCompton(512);       // [#] maximum number of inv. Compton (-1 means infinite)
    cascade.SetRatioInvCompton(0);       // [%] allowed Emis of electron (0 means disabled)
    cascade.SetSpectralIndex(-1);        // -1 means a E^2 plot
    cascade.SetDisplayIndex(1);          //  1 means a E^-2 spectrum

    //
    // Run the simulation: filename, eventdisply (on/off)
    //
    //cascade.Run("cascade_0.03_18_1e2_1e5_B1e-6_50Mpc_256_1.root", kTRUE);
    cascade.Run("cascade_0.1_18_1e2_1e5_B0_512_02.root", kFALSE);
}

