#ifndef MARS_MFit
#define MARS_Mfit

/*
#include <float.h>
#include <iomanip.h>

#include <TF1.h>
#include <TH1.h>
#include <TH2.h>
#include <TLine.h>
#include <TLeaf.h>
#include <TChain.h>
#include <TGaxis.h>
#include <TStyle.h>
#include <TCanvas.h>
#include <TMinuit.h>
#include <TPolyMarker.h>
#include <TTreePlayer.h>

#include "MH.h"
#include "MBinning.h"

#include "MPhoton.h"
*/
#ifndef ROOT_TString
#include <TString.h>
#endif
#ifndef ROOT_TObject
#include <TObject.h>
#endif

class TH1;
class TF1;

class TMinuit;

class MFit : public TObject
{
private:
    static void Func(Int_t &npar, Double_t *gin, Double_t &f, Double_t *par, Int_t flag);
    static void FuncLog(Int_t &npar, Double_t *gin, Double_t &f, Double_t *par, Int_t flag);

    static TF1  *fgFunc;
    static TH1  *fgHist;

    static Int_t fgBinMin;
    static Int_t fgBinMax;

private:
    enum {
        kIsOwner = BIT(14)
    };

    TH1 *fHist;
    TF1 *fFunc;

    TMinuit *fMinuit;

    void DeleteF();
    void DeleteH();

public:
    MFit() : fHist(NULL), fFunc(NULL), fMinuit(NULL)
    {
    }

    MFit(TString formula, Double_t min=0, Double_t max=1) : fHist(NULL), fFunc(NULL), fMinuit(NULL)
    {
        SetFunc(formula, min, max);
    }

    ~MFit()
    {
        DeleteF();
        DeleteH();
    }

    void SetFunc(TF1 *f);
    void SetFunc(TString formula, Double_t min, Double_t max);
    void SetHist(TH1 *h, Bool_t candelete=kFALSE);
    void SetRange(Double_t lo, Double_t hi);

    void Fit(Bool_t log=kFALSE);
    void FitLog() { Fit(kTRUE); }

    void Fit(TH1 *h) { SetHist(h); Fit(); }
    void FitLog(TH1 *h) { SetHist(h); FitLog(); }

    void Print(Option_t *opt="") const;
    void SetParameter(Int_t n, TString name, Double_t start, Double_t min=0, Double_t max=0);

    Double_t GetParameter(Int_t n) const;
    Double_t GetParError(Int_t n) const;

    Double_t operator[](Int_t n) const;

    TF1 *DrawCopy(Option_t *o="") const;

    ClassDef(MFit, 0)
};

#endif
