/* ================================================================== */
/**
 *  @file atmo.h
 *  @short Use of tabulated atmospheric profiles and atmospheric refraction.
 *
 *  @author  Konrad Bernloehr 
 *  $Date: 2006/06/19 15:45:45 $
 *  $Revision: 1.1 $
 *
 *  Copyright (C) 2001 Konrad Bernloehr. All rights reserved.
 *  Distribution and use of this software with the CORSIKA program is
 *  allowed and free. No redistribution separate of CORSIKA or of
 *  modified versions granted without permission. Modifications may,
 *  however, be distributed as patches to the original version.
 *  This software comes with no warranties.
 *
 */
/* ================================================================== */

#ifndef ATMO_H__LOADED

#define ATMO_H__LOADED 1

/* The CORSIKA version against which this software should match. */
/* If your CORSIKA is somewhat newer than 5.901 there is probably */
/* no reason to worry; incompatible changes should not happen */
/* all too often. */
#ifndef CORSIKA_VERSION
# define CORSIKA_VERSION 6000
#endif

#if (CORSIKA_VERSION < 5901)
typedef float cors_real_now_t;
#else
typedef double cors_real_now_t;
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* Function prototypes for functions implemented in this file */

/* FORTRAN called functions (beware changes of parameter types !!) */
void atmset_(int *iatmo, double *obslev);
double rhofx_(double *height);
double thickx_(double *height);
double refidx_(double *height);
double heighx_(double *thick);
void raybnd_(double *zem, cors_real_now_t *u, cors_real_now_t *v, double *w, 
   cors_real_now_t *dx, cors_real_now_t *dy, cors_real_now_t *dt);
void atmfit_(int *nlp, double *hlay, double *aatm, double *batm, double *catm);

/* C called functions (parameter types are always checked) */
double rpol(double *x, double *y, int n, double xp);

/* FORTRAN functions called from C */
/// The CORSIKA built-in density lookup function.
double rhof_(double *height);
/// The CORSIKA built-in function for vertical atmospheric thickness (overburden).
double thick_(double *height);
/// The CORSIKA built-in function for the height as a function of overburden.
double heigh_(double *thick);

#ifdef __cplusplus
}
#endif

#endif
