
*TITLE : CORSIKA 6.500 (svn r100)  08/06/2006  
*D. HECK AND T.PIEROG, IK FZK KARLSRUHE
*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================
C
C      OOO      OOO     OOOO       OOOO    OO   O      O      O
C     O   O    O   O    O    O    O    O   OO   O    O       O O
C    O        O     O   O     O   O        OO   O  O        O   O
C    O        O     O   O    O     OOOO    OO   OO         O     O
C    O        O     O   OOOO           O   OO   O  O       OOOOOOO
C     O   O    O   O    O   O     O    O   OO   O    O     O     O
C      OOO      OOO     O     O    OOOO    OO   O      O   O     O
C
C - - - - - -  CO(SMIC) R(AY) SI(MULATION FOR) KA(SCADE)  - - - - - - -
C
C
C  A PROGRAM TO SIMULATE EXTENSIVE AIR SHOWERS IN ATMOSPHERE
C
C  BASED ON A PROGRAM OF P.K.F. GRIEDER, UNIVERSITY BERN, SWITZERLAND
C
C  SELECTABLE INTERACTION MODELS:
C
C  HADRONIC HIGH ENERGY
C    DPMJET MODEL FROM J. RANFT, UNIVERSITY OF SIEGEN, SIEGEN, GERMANY
C    HDPM 'DUAL PARTON MODEL' FROM J.N. CAPDEVIELLE, COLLEGE DE FRANCE,
C        PARIS, FRANCE
C    NEXUS FROM K. WERNER ET AL., UNIVERSITY OF NANTES, NANTES, FRANCE
C    QUARK GLUON STRING MODEL FROM N.N. KALMYKOV AND S.S. OSTAPCHENKO,
C        MOSCOW STATE UNIVERSITY, MOSCOW, RUSSIA
C    SIBYLL FROM R. ENGEL, R.S. FLETCHER, T.K. GAISSER, P. LIPARI, T.
C        STANEV, BARTOL RESEARCH INSTITUTE, UNIVERSITY OF DELAWARE,
C        NEWARK, USA
C    VENUS FROM K. WERNER, UNIVERSITY OF NANTES, NANTES, FRANCE
C
C  HADRONIC LOW ENERGY
C    FLUKA MODEL FROM A. FASSO (CERN), A. FERRARI, J. RANFT (SIEGEN),
C        P. SALA, INFN MILAN, MILAN, ITALY
C    GHEISHA (CERN VERSION) FROM H. FESEFELDT, UNIVERSITY OF AACHEN,
C        AACHEN, GERMANY
C    URQMD MODEL FROM URQMD COLLABORATION, UNIVERSITY FRANKFURT,
C        FRANKFURT (MAIN), GERMANY
C
C  ELECTROMAGNETIC ALL ENERGIES
C    EGS4 FROM W.R. NELSON, H. HIRAYAMA, W.O. ROGERS,
C        SLAC, STANFORD, USA
C    NKG FORMULAS FOR SIMULATION OF ELECTROMAGNETIC PARTICLES
C
C  INSTITUT FUER KERNPHYSIK
C  FORSCHUNGSZENTRUM KARLSRUHE
C  POSTFACH 3640
C  D-76021 KARLSRUHE
C  GERMANY
C
C-----------------------------------------------------------------------
C  COPYRIGHT AND ANY OTHER APPROPRIATE LEGAL PROTECTION OF THESE
C  COMPUTER PROGRAMS AND ASSOCIATED DOCUMENTATION RESERVED IN ALL
C  COUNTRIES OF THE WORLD.
C
C  THESE PROGRAMS OR DOCUMENTATION MAY NOT BE REPRODUCED BY ANY METHOD
C  WITHOUT PRIOR WRITTEN CONSENT OF FORSCHUNGSZENTRUM KARLSRUHE OR ITS
C  DELEGATE.
C
C  FORSCHUNGSZENTRUM KARLSRUHE WELCOMES COMMENTS CONCERNING THE CORSIKA
C  CODE BUT UNDERTAKES NO OBLIGATION FOR MAINTENANCE OF THE PROGRAMS,
C  NOR RESPONSIBILITY FOR THEIR CORRECTNESS, AND ACCEPTS NO LIABILITY
C  WHATSOEVER RESULTING FROM THE USE OF ITS PROGRAMS.
C
C-----------------------------------------------------------------------
C  IN CASE OF PROBLEMS CONTACT:
C
C            D. HECK
C  E-MAIL:   DIETER.HECK@IK.FZK.DE
C  FAX:      (49) 7247-82-4075
C  TEL:      (49) 7247-82-3777
C
C  OR
C            T. PIEROG
C  E-MAIL:   TANGUY.PIEROG@IK.FZK.DE
C  FAX:      (49) 7247-82-4075
C  TEL:      (49) 7247-82-8134
C
C  PLEASE ASK FOR UPDATED VERSIONS OF THE PROGRAM.
C-----------------------------------------------------------------------
*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================
C
C     OPTIONS
C     =======
C
C  HERE ARE ALL THE AVAILABLE CPP OPTIONS:
C-----------------------------------------------------------------------
C COMPUTER OPTIONS
C    MAC        VERSION FOR APPLE MACINTOSH UNDER SYSTEM 7
C    UNIX       VERSION FOR VARIOUS WORKSTATIONS AND PC''S LIKE
C                             DEC STATIONS UNDER ULTRIX,
C                             ALPHA STATIONS UNDER DEC UNIX (TRU64),
C                             PC''S UNDER LINUX, ETC.
C     BYTERECL   VERSION WITH RECL PARAMETER IN BYTES
C                             (DEFAULT IS (4-BYTE) WORDS WHICH IS
C                             APPRPRIATE FOR DEC FORTRAN COMPILERS;
C                             USE BYTERECL FOR ABOUT ANYTHING ELSE).
C     OLDDATE    VERSION USING OLD DATE AND TIME ROUTINES WHICH ARE
C                             NOT Y2K COMPLIANT.
C                             (DEFAULT IS NEW 'DATE_AND_TIME' ROUTINE)
C     OLDDATE2   VERSION USING OLD DATE AND TIME ROUTINES FOR LINUX
C                             BETA WHICH ARE NOT Y2K COMPLIANT.
C                             (DEFAULT IS NEW 'DATE_AND_TIME' ROUTINE)
C     TIMERC     VERSION USING C-ROUTINE 'TIMERC' FOR DATE AND TIME
C-----------------------------------------------------------------------
C HADRONIC INTERACTION MODEL OPTIONS
C    DPMJET     VERSION USING DPMJET MODEL FOR HIGH ENERGY HAD. INTER.
C    NEXUS      VERSION USING NEXUS FOR HIGH ENERGY HAD. INTERACTIONS
C    QGSJET     VERSION USING QGSJET MODEL FOR HIGH ENERGY HAD. INTER.
C    (QGSJETOLD) DEFAULT USING QGSJET WITH PARAMETERS OF OLD QGSJET
C    !QGSJETOLD  VERSION USING QGSJET WITH MODIFIED N&O CROSS-SECTIONS
C                   (KALMYKOV EFFECT)
C     QGSII      VERSION USING QGSJET II
C    SIBYLL     VERSION USING SIBYLL FOR HIGH ENERGY HAD. INTERACTIONS
C    VENUS      VERSION USING VENUS  FOR HIGH ENERGY HAD. INTERACTIONS
C
C    FLUKA      VERSION USING FLUKA FOR LOW ENERGY HAD. INTERACTIONS
C     LINUX      FLUKA VERSION FOR LINUX MACHINES
C    GHEISHA    VERSION USING GHEISHA FOR LOW ENERGY HAD. INTERACTIONS
C    URQMD      VERSION USING URQMD FOR LOW ENERGY HAD. INTERACTIONS
C-----------------------------------------------------------------------
C OTHER OPTIONS
C    ANAHIST    VERSION PRODUCING HISTOGRAMS OF SHOWER ANALYSIS
C    ATMEXT     VERSION USING TABULATED MODTRAN ATMOSPHERE
C               (IN CONNECTION WITH CHERENKOV OPTION)
C    AUGCERLONG VERSION PRODUCING LONGITUDINAL CHERENKOV DISTRIBUTION
C               (NOT TO BE COMBINED WITH CERENKOV)
C    AUGERHIST  VERSION PRODUCING HISTO''S AT UP TO 20 OBSERVATION LEVELS
C    AUGERINFO  WRITES AUGER INFO FILE INSTEAD OF DBASE FILE
C    CEFFIC     VERSION TO APPLY ALREADY DURING EAS SIMULATION
C               ATM. ABSORPTION, MIRROR REFLECTIVITY AND QUANTUM EFF.
C               (SAVES LOTS OF TIME AND DISK SPACE)
C               (ONLY IN CONNECTION WITH CHERENKOV OPTION)
C    CERENKOV   VERSION FOR CHERENKOV LIGHT GENERATION
C    COMPACT    VERSION FOR COMPACT PARTILCE OUTPUT FILE
C    CURVED     VERSION FOR CURVED (SLIDING PLANE) ATMOSPHERE
C    IACT       VERSION FOR IMAGING ATMOSPHERIC CHERENKOV TELESCOPES
C               (ONLY IN CONNECTION WITH CHERENKOV OPTION)
C    INTCLONG   INTEGRATED CHERENKOV PHOTON NUMBERS FOR LONGITUDINAL
C               DEVELOPMENT (IN CONNECTION WITH CHERENKOV OR
C               AUGCERLONG OPTION)
C    INTTEST    VERSION FOR INTERACTION TEST (NO SHOWER DEVELOPMENT)
C    LPM        VERSION SELECTING LPM-EFFECT WITHOUT THINNING
C    NEUTRINO   VERSION FOR EXPLICIT NEUTRINO TREATMENT
C    NOCLONG    SUPPRESS LONGITUDINAL DEVELOPMENT FOR CHERENKOV
C               (ONLY IN CONNECTION WITH CHERENKOV OPTION)
C    NUPRIM     VERSION FOR NEUTRINO PRIMARY TREATED BY HERWIG MODEL
C    PLOTSH     VERSION FOR PRODUCTION OF SHOWER PLOTS
C    PRESHOWER  GAMMA PRESHOWERING IN EARTH MAGNETIC FIELD
C     REDHAT     PRESHOWER ROUTINES FOR REDHAT 7.2 OPREATING SYSTEM
C    ROOTOUT    VERSION FOR ROOT PARTICLE OUTPUT FILE
 
C    SLANT      VERSION FOR LONGITUDINAL DEVELOPMENT IN SLANT DEPTH
C    STACEE     CHERENKOV OUTPUT FORMAT FOR STACEE EXPERIMENT
C    STACKIN    STACK INPUT OF PARTICLES FROM EXTERNAL INTERACTION
C    THIN       VERSION FOR THINNING
C    UPWARD     VERSION INCLUDING UPWARD GOING PARTICLES
C    VIEWCONE   VERSION FOR FIXED ANGLE AND VIEWING CONE
C    VOLUMECORR VERSION FOR VERTICAL STRING DETECTORS
C    VOLUMEDET  VERSION FOR NON-FLAT (VOLUME) DETECTORS
C-----------------------------------------------------------------------

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================
C
C     DATACARDS
C     =========
C
C  THE PROGRAM CAN BE RUN BY SEVERAL STEERING CARDS. THEY CONSIST OF
C  A KEYWORD (A6) AND ONE OR MORE PARAMETERS. THE CARDS MAY BE GIVEN IN
C  ANY ORDER. IF NO CARD IS SUPPLIED FOR A SPECIAL PARAMETER, A DEFAULT
C  VALUE IS TAKEN. THE DEFAULTS ARE GIVEN BELOW.
C  INPUT IS FORMAT FREE, UPPER AND LOWER CASE CHARACTERS ARE ACCEPTED.
C
C  EXPLANATION :
C  =============
C  KEYWORD  VARIABLES   DESCRIPTION
C-----------------------------------------------------------------------
C  RUNNR          I     RUN NUMBER OF THIS SIMULATION
C  EVTNR          I     EVENT NUMBER FOR FIRST SHOWER, SECOND SHOWER
C                       WILL GET NUMBER EVTNR+1 AND SO ON
C  NSHOW          I     NUMBER OF SHOWERS TO BE GENERATED
C  OBSLEV         F     OBSERVATION LEVEL ABOVE SEA IN CM
C                       UP TO 10 LEVELS ARE POSSIBLE
C                       (FOR AUGERHIST UP TO 20 LEVELS ARE POSSIBLE)

C  PRMPAR         I     PARTICLE TYPE OF PRIMARY PARTICLE
C  THETAP        2F     ZENITH ANGLE RANGE OF PRIM. PARTICLE IN DEGREES
C  PHIP          2F     AZIMUTH ANGLE RANGE OF PRIM. PARTICLE IN DEGREES

C  ERANGE        2F     LIMITS OF ENERGY RANGE
C  ESLOPE         F     EXPONENT OF DIFF. ENERGY SPECTRUM TO BE THROWN
C  FIXCHI         F     STARTING ALTITUDE OF PRIMARY IN G/CM**2
C  TSTART         L     DEFINE ZERO POINT OF ARRIVAL TIME AT ENTRANCE INTO
C                       ATMOSPHERE (ELSE: AT FIRST INTERACTION)
C  FIXHEI       F,I     FIX HEIGHT OF FIRST INTERACTION IN CM (RANDOM
C                       AT 0.), TYPE OF TARGET FOR 1ST INTERACTION:
C                       0=RANDOM, 1=NITROGEN, 2=OXYGEN, 3=ARGON
C  HADFLG        6I     STEERING OF HADRONIC INTERACTIONS
C                       NFLAIN, NFLDIF, NFLPI0, NFLPIF, NFLCHE, NFRAGM
C                       (MEANING SEE BELOW)
C  ELMFLG        2L     SELECTING NKG AND/OR EGS FOR TREATING ELECTRONS
C                       AND GAMMAS
C  STEPFC         F     MULTIPLE SCATTERING MAX. STEP LENGTH FACTOR
C  RADNKG         F     RANGE OF LATERAL NKG DISTRIBUTION IN CM
C  QGSJET       L,I     SELECT QGSJET MODEL FOR HIGH ENERGY HADR. INTERACT.
C  QGSSIG         L     SELECT QGSJET CROSS-SECTIONS
C  ECUTS         4F     KINETIC ENERGY CUTS FOR HADRONS, MUONS,
C                       ELECTRONS AND GAMMAS IN GEV
C  ECTMAP         F     GAMMA FACTOR CUT FOR PARTICLE PRINTOUT IN GEV
C  SEED          3I     STARTING SEED, NUMBER OF CALLS AND NUMBER OF
C                       BILLIONS OF CALLS (SEE RMMAR IN CERN LIBRARY)
C                       UP TO 4 SEQUENCES ARE USED IN THE MOMENT
C  MAXPRT         I     THE MAXIMUM NUMBER OF EVENTS TO BE PRINTED
C  MAGNET        2F     THE COMPONENTS OF THE EARTH MAGNETIC FIELD
C  ARRANG         F     ANGLE (DEG) ARRAY X_DIRECTION AND MAGNETIC NORD
C  LONGI     L,F,2L     SELECT SAMPLING OF LONGITUDINAL SHOWER DEVELOPMENT,
C                       DEFINE THE SAMPLING STEPS IN G/CM**2, SET THE
C                       FLAG FOR CHARGED LONGITUDINAL DISTRIBUTION FIT
C                       FLAG FOR LONGITUD. OUTPUT
C  MUMULT         L     FLAG FOR MULTIPLE SCATTERING OF MUONS (T=MOLIERE)
C  MUADDI         L     ADDITIONAL INFORMATION ON MUON AT MUONS BIRTHPLACE
C  DEBUG    L,I,L,I     DEBUG PRINTOUT FLAG AND LOG.UNIT
C                       FOR PRINTOUT AND DELAYED ACTIVATION OF DEBUG
C  EGSDEB         I     COUNTER FOR DELAYED DEBUG ACTICVATION IN EGS
C  PAROUT        2L     FLAGS FOR MPATAP SUPPRESS AND TABLE OUT ACTIVATION

C  OUTPUT         I     REDIRECT PRINTER OUTPUT TO UNIT
C  ATMOD          I     SELECT ATMOSPHERIC MODEL NUMBER
C  ATMA      4F(5F)     ATMOSPHERIC A PARAMETERS
C  ATMB          4F     ATMOSPHERIC B PARAMETERS
C  ATMC      4F(5F)     ATMOSPHERIC C PARAMETERS
C  ATMLAY        4F     ATMOSPHERIC LAYER BOUNDARY ALTITUDE

C  ATMOSPHERE   I,L     EXTERNAL TABUL. ATMOSPHERE # AND REFRACTION USAGE

C  DIRECT       A59     DATASET NAME FOR PARTICLE OUTPUT FILE

C  CERSIZ         F     MAXIMAL SIZE FOR GROUP OF CHERENKOV PHOTONS
C  CERARY     2I,4F     DEFINITION OF THE ARRAY OF CHERENKOV DETECTORS
C  CERFIL         L     FLAG TO DIRECT CHERENKOV OUTPUT TO FILE
C  CDEBUG         L     CHERENKOV DEBUG FLAG
C  CWAVLG        2F     LOWER AND UPPER WAVELENGTH LIMIT FOR CHERENKOV
C  CSCAT       I,2F     MULTIPLE USE OF CHERENKOV EVENTS, AND RANGE OF
C                       CORE SCATTER
C  VIEWCONE      2F     OPENING ANGLE FOR INNER AND OUTER CONE (DEGREES)
C  PLOTSH         L     FLAG TO ENABLE/DISABLE OUTPUT FOR PLOTS
C  DATBAS         L     PARAMETERS ARE WRITTEN TO DATABASE FILE
C  HOST         A20     HOST NAME OF COMPUTER IN USE FOR DBASE FILE
C  USER         A20     USER NAME FOR DBASE FILE

C  EXIT                 ENDS DATA CARD READING
C
C-----------------------------------------------------------------------
C
C  LIST OF PROGRAM STEERING CARDS WITH DEFAULT VALUES :
C  ====================================================
C
C  RUNNR   1
C  EVTNR   1
C  NSHOW   10
C  OBSLEV  110.E2

C  PRMPAR  14
C  THETAP  0.  0.
C  PHIP    0.  0.

C  ERANGE  1.E4  1.E4
C  ESLOPE  0.
C  FIXHEI  0.  0
C  FIXCHI  0.
C  TSTART  F
C  HADFLG  0  0  0  0  0  2
C  ELMFLG  T  F
C  STEPFC  1.
C  RADNKG  200.E2
C  QGSJET  T  0
C  QGSSIG  T
C  ECUTS   .3  .3  .003  .003
C  ECTMAP  1.E4
C  SEED    1  0  0
C  SEED    2  0  0
C  SEED    3  0  0
C  MAXPRT  10
C  MUADDI  F
C  MUMULT  T
C  MAGNET  20.  42.8
C  ARRANG  0.
C  LONGI   F  20.  F  F
C  DEBUG   F  6  F  100000
C  EGSDEB  2147483647
C  PAROUT  T  F

C  OUTPUT  6
C  ATMOD   1
C  ATMA    0.  0.  0.  0.  (0.)
C  ATMB    0.  0.  0.  0.
C  ATMC    0.  0.  0.  0.  (0.)
C  ATMLAY  4.E5  10.E5  40.E5  100.E5

C  ATMOSPHERE  0  F

C  DIRECT 'anynameupto64characters'

C  SEED    3  0  0
C  CERARY  27  27  1500.  1500.  100.  100.
C  CERFIL  T
C  CERSIZ  0.
C  CWAVLG  300.  450.
C  CSCAT   1  0.  0.
C  VIEWCONE  0.  0.
C  PLOTSH  F

C  DATBAS  F
C  HOST   '       '
C  USER   '       '

C  EXIT
C
C-----------------------------------------------------------------------
*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================
C
C    OUTPUT FORMAT FOR PARTICLE OR CHERENKOV OUTPUT TAPE (MPATAP/MCETAP)
C    =============
C

C   ( BLOCKLENGTH = 22932 FIXED, ALL WORDS ARE 4 BYTES LONG )
C   EACH BLOCK CONSISTS OF 21 SUBBLOCKS OF 273 WORDS

C   THESE SUBBLOCKS CAN BE :
C           RUN HEADER
C           EVENT HEADER
C           DATABLOCK
C           (LONG I:N)
C           EVENT END
C           RUN END
C   THE CONTENTS OF THESE BLOCKS IS DESCRIBED BELOW.
C   A DATA TAPE HAS THEN THE FOLLOWING STRUCTURE :
C           RUN HEADER 1
C             EVENT HEADER 1
C               DATABLOCK
C               DATABLOCK
C               ...
C               ...
C               (LONG 1:1)
C               ...
C               (LONG 1:N)
C             EVENT END 1
C             EVENT HEADER 2
C               DATABLOCK
C               DATABLOCK
C               ...
C               ...
C               (LONG 2:1)
C               ...
C               (LONG 2:N)
C             EVENT END 2
C             ...
C             ...
C             EVENT HEADER #NEVT
C               DATABLOCK
C               DATABLOCK
C               ...
C               ...
C               (LONG #NEVT:1)
C               ...
C               (LONG #NEVT:N)
C             EVENT END #NEVT
C           RUN END 1
C           RUN HEADER 2
C             ...
C           RUN END 2
C           ...
C           RUN HEADER #NRUN
C             ...
C           RUN END #NRUN
C
C=======================================================================
C
C      RUN HEADER : ( ONCE PER RUN )
C      ============
C
C     1     'RUNH'
C     2     RUN NUMBER
C     3     DATE OF BEGIN RUN ( YYMMDD )
C     4     VERSION OF CORSIKA PROGRAM
C
C      OBSERVATION LEVELS ( MAXIMAL 10 )
C     5     NUMBER OF OBSERVATION LEVELS
C     5+I   HEIGHT OF LEVEL I IN CM
C
C      ENERGY SPECTRUM
C    16     SLOPE OF ENERGY SPECTRUM
C    17     LOWER ENERGY LIMIT
C    18     UPPER ENERGY LIMIT
C
C      ELECTROMAGNETIC PARTICLES
C    19     FLAG FOR EGS4
C    20     FLAG FOR NKG
C
C      CUTOFFS IN SIMULATION
C    21     KIN. ENERGY CUTOFF FOR HADRONS   IN GEV
C    22     KIN. ENERGY CUTOFF FOR MUONS     IN GEV
C    23     KIN. ENERGY CUTOFF FOR ELECTRONS IN GEV
C    24     KIN. ENERGY CUTOFF FOR GAMMAS    IN GEV
C
C      RUN PARAMETERS AND PHYSICAL CONSTANTS
C    24+I   C(I),    I=1,50
C    74+I   0,       I=1,20      NO LONGER USED
C    94+I   CKA(I),  I=1,40
C   134+I   CETA(I), I=1,5
C   139+I   CSTRBA(I)I=1,11
C   150+I   0,       I=1,104     NO LONGER USED
C   254+I   AATM(I), I=1,5
C   259+I   BATM(I), I=1,5
C   264+I   CATM(I), I=1,5
C   270     NFLAIN  (AS REAL)
C   271     NFLDIF  (AS REAL)
C   272     NFLPI0 + 100.* NFLPIF (AS REAL)
C   273     NFLCHE + 100.* NFRAGM (AS REAL)

C
C=======================================================================
C
C      EVENTHEADER : ( ONCE PER EVENT )
C      =============
C
C     1     'EVTH'
C     2     EVENT NUMBER
C
C      PRIMARY PARTICLE
C     3     PARTICLE ID ( PARTICLE CODE OR A * 100 + Z FOR NUCLEI )
C     4     TOTAL ENERGY IN GEV
C     5     STARTING ALTITUDE IN G/CM**2
C     6     NUMBER OF FIRST INTERACTION TARGET IF FIXED
C     7     Z- COORDINATE IN CM OF FIRST INTERACTION
C           (NEGATIV IF TIME STARTS AT MARGIN OF ATMOSPHERE)
C     8     PX MOMENTUM IN X DIRECTION
C     9     PY MOMENTUM IN Y DIRECTION
C    10     PZ MOMENTUM IN -Z DIRECTION
C    11     THETA (ZENITH ANGLE) IN RAD
C    12     PHI (AZIMUTH ANGLE)  IN RAD
C
C      RANDOM NUMBER INITIALIZATION ( SUBROUT. RMMARD )
C      ( UP TO 10 DIFFERENT SEQUENCES )
C    13     NUMBER OF DIFFERENT SEQUENCES
C
C    11+3*I INTEGER SEED OF SEQUENCE I
C    12+3*I NUMBER OF OFFSET RANDOM CALLS ( MOD 10**6 ) OF SEQUENCE I
C    13+3*I NUMBER OF OFFSET RANDOM CALLS ( MILLIONS )  OF SEQUENCE I
C
C      GENERAL INFORMATION
C    44     RUN NUMBER
C    45     DATE OF BEGIN RUN ( YYMMDD )
C    46     VERSION OF CORSIKA PROGRAM
C
C      OBSERVATION LEVELS ( MAXIMAL 10 )
C    47     NUMBER OF OBSERVATION LEVELS
C    47+I   HEIGHT OF LEVEL I IN CM
C
C      ENERGY SPECTRUM
C    58     SLOPE OF ENERGY SPECTRUM
C    59     LOWER LIMIT OF ENERGY RANGE IN GEV
C    60     UPPER LIMIT OF ENERGY RANGE IN GEV
C
C      CUTOFFS IN SIMULATION
C    61     CUTOFF FOR HADRONS   KINETIC ENERGY IN GEV
C    62     CUTOFF FOR MUONS     KINETIC ENERGY IN GEV
C    63     CUTOFF FOR ELECTRONS KINETIC ENERGY IN GEV
C    64     CUTOFF FOR GAMMAS    KINETIC ENERGY IN GEV
C
C      HDPM MODEL PARAMETERS
C    65     NFLAIN ( AS REAL )
C    66     NFLDIF ( AS REAL )
C    67     NFLPI0 ( AS REAL )
C    68     NFLPIF ( AS REAL )
C    69     NFLCHE ( AS REAL )
C    70     NFRAGM ( AS REAL )
C
C      EARTH''S MAGNETIC FIELD COMPONENT
C    71     BX IN MICROTESLA
C    72     BZ IN MICROTESLA
C
C      ELECTROMAGNETIC PARTICLES
C    73     FLAG FOR EGS4
C    74     FLAG FOR NKG
C
C      OTHER FLAGS
C    75     GHEISHA/URQMD/FLUKA  FLAG (1.=GHEISHA, 2.=URQMD, 3.=FLUKA)
C    76     VENUS FLAG (0.=HDPM, 1.=VENUS, 2.=SIBYLL,
C                       3.=QGSJET, 4.=DPMJET, 5.=NEXUS)
C    77     CHERENKOV FLAG
C    78     NEUTRINO FLAG
C    79     CURVED FLAG (0.=STANDARD, 2.=CURVED)
C    80     COMPUTER FLAG (3.=UNIX OR LINUX SYSTEM, 4.=MACINTOSH)
C
C      ANGULAR DISTRIBUTION OF PRIMARY PARTICLE
C    81     LOWER EDGE OF PRIMARY THETA SELECTION (IN DEGREES)
C    82     UPPER EDGE OF PRIMARY THETA SELECTION (IN DEGREES)
C    83     LOWER EDGE OF PRIMARY PHI   SELECTION (IN DEGREES)
C    84     UPPER EDGE OF PRIMARY PHI   SELECTION (IN DEGREES)
C
C      CHERENKOV SETTINGS IN CASE OF CHERENKOV CALCULATIONS
C    85     CERSIZ   CHERENKOV PHOTON BUNCH SIZE
C    86     NCERX    NUMBER OF CHERENKOV DETECTORS IN X DIRECTION
C    87     NCERY    NUMBER OF CHERENKOV DETECTORS IN Y DIRECTION
C    88     DCERX    GRID SPACING IN X DIRECTION IN CM
C    89     DCERY    GRID SPACING IN Y DIRECTION IN CM
C    90     ACERX    CHERENKOV DETECTOR SIZE IN X DIRECTION IN CM
C    91     ACERY    CHERENKOV DETECTOR SIZE IN Y DIRECTION IN CM
C    92     LCERFI   FLAG FOR STEERING CHERENKOV PHOTON OUTPUT
C
C    93     ARRANR   ANGLE (RAD) ARRAY X-DIRECTION AND MAGNETIC NORD
C    94     FLAG     FOR ADDITIONAL MUON INFORMATION ON PARTICLE TAPE
C    95     STEPFC   ELECTRON MULTIPLE SCATTERING STEP SIZE FACTOR (EGS)
C    96     WAVLGL   CHERENKOV WAVELENGTH BANDWIDTH LOWER LIMIT (NM)
C    97     WAVLGU   CHERENKOV WAVELENGTH BANDWIDTH UPPER LIMIT (NM)
C
C      CHERENKOV STUFF FOR SCATTERED EVENTS
C    98     ICERML   NUMBER I OF TIMES A SINGLE EVENT IS USED (UP TO 20)
C    98+I   CERXOS(I)  X OFFSET IN CM FOR THE ITH EVENT IN CM
C   118+I   CERYOS(I)  Y OFFSET IN CM FOR THE ITH EVENT IN CM
C
C   139     SIBYLL INTERACTION FLAG (1.=VERS.1.6; 2.=VERS.2.1)
C   140     SIBYLL CROSS-SECTION FLAG (1.=VERS.1.6; 2.=VERS.2.1)
C   141     QGSJET INTERACTION FLAG (1.=OLD QGSJET; 2.=QGSJET01)
C   142     QGSJET CROSS-SECTION FLAG (1.=OLD QGSJET; 2.=QGSJET01)
C   143     DPMJET INTERACTION FLAG
C   144     DPMJET CROSS-SECTION FLAG
C   145     VENUS/NEXUS CROSS-SECTION FLAG (1.=VENUSSIG, 2.=NEXUSSIG)
C   146     MUON MUTLTIPLE SCATTERING FLAG (1.=MOLIERE,0.=GAUSS)
C   147     NKG RADIAL DISTRIBUTION RANGE IN CM
C   148     ENERGY FRACTION OF THINNING LEVEL HADRONIC
C   149     ENERGY FRACTION OF THINNING LEVEL EM-PARTICLES
C   150     ACTUAL WEIGHT LIMIT FOR THINNING HADRONIC
C   151     ACTUAL WEIGHT LIMIT FOR THINNING EM-PARTICLES
C   152     MAX RADIUS FOR RADIAL THINNING IN CM
C   153     VIEWCONE(1) ANGLE OF INNER VIEWING CONE
C   154     VIEWCONE(2) ANGLE OF OUTER VIEWING CONE

C   155..273  NOT YET USED

C
C=======================================================================
C
C      PARTICLE DATA BLOCKS :
C      ======================
C
C      (CONTAINING UP TO 39 PARTICLES, 7 WORDS EACH)
C
C    7*(N-1)+1  PARTICLE IDENTIFICATION
C               ( PART.ID*1000 + HADR.GENERATION*10 + NO. OF OBS.LEVEL )
C                 <5627           <100                 <10
C               (IF PART.ID = 9900 THEN CHERENKOV PHOTON WITH
C                    NINT(NUMBER OF PHOTONS IN BUNCH)*10 + 1)
C    7*(N-1)+2  PX  MOMENTUM IN X DIRECTION
C    7*(N-1)+3  PY  MOMENTUM IN Y DIRECTION
C    7*(N-1)+4  PZ  MOMENTUM IN -Z DIRECTION
C    7*(N-1)+5  X- COORDINATE IN CM
C    7*(N-1)+6  Y- COORDINATE IN CM
C    7*(N-1)+7  T TIME SINCE FIRST INTERACTION (OR ENTRANCE INTO
C               ATMOSPHERE) IN NSEC
C               ( Z-COORDINATE IN CM FOR ADDITIONAL MUON INFORMATION)
C

C
C           FOR N = 1.... 39
C
C   IF LAST BLOCK IS NOT COMPLETELY FILLED, TRAILING ZEROS ARE ADDED
C
C=======================================================================
C
C      CHERENKOV BUNCH DATA BLOCKS :
C      ============================
C
C      (CONTAINING UP TO 39 BUNCHES, 7 WORDS EACH)
C
C    7*(N-1)+1  NUMBER OF PHOTONS IN BUNCH
C                  (FOR STANDARD PARTICLE OUTPUT FILE:
C                   99.E5 + NINT(NUMBER OF PHOTONS IN BUNCH)*10 + 1
C    7*(N-1)+2  X- COORDINATE IN CM
C    7*(N-1)+3  Y- COORDINATE IN CM
C    7*(N-1)+4  DIRECTION COSINUS TO X AXIS
C    7*(N-1)+5  DIRECTION COSINUS TO Y AXIS
C    7*(N-1)+6  T TIME SINCE FIRST INTERACTION (OR ENTRANCE INTO
C               ATMOSPHERE) IN NSEC
C    7*(N-1)+7  PRODUCTION HEIGHT OF BUNCH IN CM

C
C           FOR N = 1.... 39
C
C   IF LAST BLOCK IS NOT COMPLETELY FILLED, TRAILING ZEROS ARE ADDED
C
C=======================================================================
C
C      LONGITUDINAL BLOCKS:
C      ====================
C      OPTIONAL, IF (LONGI = .TRUE.  .AND.  FLONGOUT = .FALSE.)
C
C     1     'LONG'
C     2     EVENT NUMBER
C     3     PARTICLE ID ( PARTICLE CODE OR A * 100 + Z FOR NUCLEI )
C     4     TOTAL ENERGY IN GEV
C     5     (TOTAL NUMBER OF LONGITUDINAL STEPS) * 100 +
C               NUMBER OF LONGITUDINAL BLOCKS/SHOWER
C     6     CURRENT NUMBER 'M' OF LONGITUDINAL BLOCK
C     7     ALTITUDE OF FIRST INTERACTION IN G/CM**2
C     8     THETA (ZENITH ANGLE) IN RAD
C     9     PHI (AZIMUTH ANGLE) IN RAD
C    10     CUTOFF FOR HADRONS   KINETIC ENERGY IN GEV
C    11     CUTOFF FOR MUONS     KINETIC ENERGY IN GEV
C    12     CUTOFF FOR ELECTRONS KINETIC ENERGY IN GEV
C    13     CUTOFF FOR GAMMAS            ENERGY IN GEV
C
C      FOR N = 1, 26 AND FOR J LONGITUDINAL STEPS:
C   10*N+ 4 VERTICAL DEPTH OF STEP J       IN G/CM**2
C   10*N+ 5 NUMBER OF GAMMAS                AT STEP J
C   10*N+ 6 NUMBER OF E+          PARTICLES AT STEP J
C   10*N+ 7 NUMBER OF E-          PARTICLES AT STEP J
C   10*N+ 8 NUMBER OF MU+         PARTICLES AT STEP J
C   10*N+ 9 NUMBER OF MU-         PARTICLES AT STEP J
C   10*N+10 NUMBER OF HADRONIC    PARTICLES AT STEP J
C   10*N+11 NUMBER OF ALL CHARGED PARTICLES AT STEP J
C   10*N+12 NUMBER OF NUCLEI                AT STEP J
C   10*N+13 NUMBER OF CHERENKOV PHOTONS     AT STEP J
C
C       FOR FIRST  'LONG' BLOCK:          1 ... J ...   26
C       FOR SECOND 'LONG' BLOCK:         27 ... J ...   52
C       ...
C       FOR 'M'TH  'LONG' BLOCK: (M-1)*26+1 ... J ... M*26
C
C   IF LAST BLOCK IS NOT COMPLETELY FILLED, TRAILING ZEROS ARE ADDED
C

C
C=======================================================================
C
C      END EVT: ( ONCE PER EVENT )
C      ========
C
C     1     'EVTE'
C     2     EVENT NUMBER
C
C      STATISTICS FOR SHOWER
C     3     WEIGHTED NUMBER OF GAMMAS    WRITTEN TO MPATAP
C     4     WEIGHTED NUMBER OF ELECTRONS WRITTEN TO MPATAP
C     5     WEIGHTED NUMBER OF HADRONS   WRITTEN TO MPATAP
C     6     WEIGHTED NUMBER OF MUONS     WRITTEN TO MPATAP
C     7     NUMBER OF WEIGHTED PARTICLES WRITTEN TO MPATAP
C
C      NKG OUTPUT (208 WORDS) IF SELECTED
C     7+I   I=1,21  LATERAL DIST. IN  X DIRECTION FOR 1. LEVEL (/CM**2)
C    28+I   I=1,21  LATERAL DIST. IN  Y DIRECTION FOR 1. LEVEL (/CM**2)
C    49+I   I=1,21  LATERAL DIST. IN XY DIRECTION FOR 1. LEVEL (/CM**2)
C    70+I   I=1,21  LATERAL DIST. IN YX DIRECTION FOR 1. LEVEL (/CM**2)
C
C    91+I   I=1,21  LATERAL DIST. IN  X DIRECTION FOR 2. LEVEL (/CM**2)
C   112+I   I=1,21  LATERAL DIST. IN  Y DIRECTION FOR 2. LEVEL (/CM**2)
C   133+I   I=1,21  LATERAL DIST. IN XY DIRECTION FOR 2. LEVEL (/CM**2)
C   154+I   I=1,21  LATERAL DIST. IN YX DIRECTION FOR 2. LEVEL (/CM**2)
C
C   175+I   I=1,10  ELECTRON NUMBER AT LEVELS FOR LONGITUDINAL DIST.
C   185+I   I=1,10  AGE             AT LEVELS FOR LONGITUDINAL DIST.
C   195+I   I=1,10  DISTANCES FOR NKG LATERAL DISTRIBUTION (CM)
C   205+I   I=1,10  LOCAL AGE                         1. LEVEL
C
C   215+I   I=1,10  LEVEL HEIGHT IN G/CM**2 FOR LONGITUDINAL DIST.
C   225+I   I=1,10  LEVEL HEIGHT IN CM      FOR LONGITUDINAL DIST.
C   235+I   I=1,10  DISTANCE BINS FOR LOCAL AGE (CM)
C   245+I   I=1,10  LOCAL AGE                         2. LEVEL
C
C     LONGITUDINAL DEVELOPMENT (IF SELECTED)
C   255+I   I=1,6   PARAMETERS OF LONGITUDINAL DISTRIBUTION OF CHARGED
C                   PARTICLES
C     262   CHI**2  PER DEGREE OF FREEDOM OF FIT TO LONGITUDINAL
C                   DISTRIBUTION
C     263   WEIGHTED NUMBER OF GAMMAS    ARRIVING AT OBSERVATION LEVEL
C     264   WEIGHTED NUMBER OF ELECTRONS ARRIVING AT OBSERVATION LEVEL
C     265   WEIGHTED NUMBER OF HADRONS   ARRIVING AT OBSERVATION LEVEL
C     266   WEIGHTED NUMBER OF MUONS     ARRIVING AT OBSERVATION LEVEL
C

C   267..273  NOT YET USED

C
C=======================================================================
C
C      END RUN
C      =======
C
C     1     'RUNE'
C     2     RUNNR
C
C      STATISTICS FOR RUN
C     3     NUMBER OF EVENTS PROCESSED
C

C     4..273  NOT YET USED

C
C-----------------------------------------------------------------------
*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================
C
C     PARTICLE CODES
C     ==============
C
C  NAMING CONVENTION FOR PARTICLES IN CORSIKA ACCORDING TO GEANT WITH
C  EXTENSIONS FOR RESONANCES (RHO, K*, AND DELTA), NEUTRINOS, AND NUCLEI
C
C        1   GAMMA
C        2   POSITRON
C        3   ELECTRON
C     (  4   NEUTRINO   SEE 66..69 )
C        5   MUON +
C        6   MUON -
C        7   PION 0
C        8   PION +
C        9   PION -
C       10   KAON 0 LONG
C       11   KAON +
C       12   KAON -
C       13   NEUTRON
C       14   PROTON
C       15   ANTI PROTON
C       16   KAON 0 SHORT
C       17   ETA        SEE ALSO 71..74
C       18   LAMBDA
C       19   SIGMA +
C       20   SIGMA 0
C       21   SIGMA -
C       22   XI 0
C       23   XI -
C       24   OMEGA (BARYON)
C       25   ANTI NEUTRON
C       26   ANTI LAMBDA
C       27   ANTI SIGMA -
C       28   ANTI SIGMA 0
C       29   ANTI SIGMA +
C       30   ANTI XI 0
C       31   ANTI XI +
C       32   ANTI OMEGA (BARYON)
C     ( 33   TAU +        )
C     ( 34   TAU -        )
C     ( 35   D +          )
C     ( 36   D -          )
C     ( 37   D 0          )
C     ( 38   ANTI D 0     )
C     ( 39   F +          )
C     ( 40   F -          )
C     ( 41   LAMBDA C +   )
C     ( 42   W +          )
C     ( 43   W -          )
C     ( 44   Z0           )
C     ( 45   DEUTERON     )
C     ( 46   TRITIUM      )
C     ( 47   ALPHA        )
C     ( 48                )
C     ( 49                )
C       50   OMEGA MESON
C       51   RHO 0
C       52   RHO +
C       53   RHO -
C       54   DELTA ++
C       55   DELTA +
C       56   DELTA 0
C       57   DELTA -
C       58   ANTI DELTA --
C       59   ANTI DELTA -
C       60   ANTI DELTA 0
C       61   ANTI DELTA +
C       62   K* 0
C       63   K* +
C       64   K* -
C       65   ANTI K* 0
C       66   ELECTRON NEUTRINO
C       67   ELECTRON ANTI NEUTRINO
C       68   MUON NEUTRINO
C       69   MUON ANTI NEUTRINO
C     ( 70                )
C       71   ETA --> GAMMA + GAMMA
C       72   ETA --> PI(0) + PI(0) + PI(0)
C       73   ETA --> PI(+) + PI(-) + PI(0)
C       74   ETA --> PI(+) + PI(-) + GAMMA
C       75   MUON +  ADDITIONAL INFORMATION OF ORIGIN
C       76   MUON -  ADDITIONAL INFORMATION OF ORIGIN
C
C      116   D 0
C      117   D +
C      118   ANTI D -
C      119   ANTI D 0
C      120   D_S +
C      121   ANTI D_S -
C      122   ETA-C
C      123   D* 0
C      124   D* +
C      125   ANTI D* -
C      126   ANTI D* 0
C      127   D*_S +
C      128   ANTI D*_S -
C
C      130   J/PSI
C      131   TAU +
C      132   TAU -
C      133   TAU NEUTRINO
C      134   TAU ANTI NEUTRINO
C
C      137   LAMBDA_C +
C      138   XI_C +
C      139   XI_C 0
C      140   SIGMA_C ++
C      141   SIGMA_C +
C      142   SIGMA_C 0
C      143   XI_C PRIME +
C      144   XI_C PRIME 0
C      145   OMEGA_C 0
C
C      149   ANTI LAMBDA_C -
C      150   ANTI XI_C -
C      151   ANTI XI_C 0
C      152   ANTI SIGMA_C --
C      153   ANTI SIGMA_C -
C      154   ANTI SIGMA_C 0
C      155   ANTI XI_C PRIME -
C      156   ANTI XI_C PRIME 0
C      157   ANTI OMEGA_C 0
C
C      161   SIGMA_C * ++
C      162   SIGMA_C * +
C      163   SIGMA_C * 0
C
C      171   ANTI SIGMA_C * --
C      172   ANTI SIGMA_C * -
C      173   ANTI SIGMA_C * 0
C
C  NAMING CONVENTION FOR NUCLEI:
C     AAZZ   NUCLEUS OF ZZ PROTONS AND (AA-ZZ) NEUTRONS
C            RESTRICTIONS:  AA < 59   AND   ZZ < AA+1
C
C     9900   CHERENKOV PHOTONS ON THE PARTICLE OUTPUT FILE
C-----------------------------------------------------------------------

C=======================================================================
C
C  DESCRIPTION OF GLOBAL VARIABLES USED IN THE COMMONS OF THE PROGRAM
C  ==================================================================
C  (IN ALPHABETIC ORDER OF COMMONS)
C

C --------------/CRAIR/--------------------------
C  COMPOS(3)   = COMPOSITION OF AIR, ATOMIC FRACTIONS OF N, O, AR
C  PROBTA(3)   = INTEGRATED ATOMIC FRACTIONS
C  AVERAW      = AVERAGE ATOMIC WEIGHT OF AIR
C  AVOGDR      = AVOGADROS NUMBER * MILLIBARN/CM**2
C
C --------------/CRATMOS/------------------------
C  AATM(5)     = ACTUAL COEFFICIENTS FOR PARAMETRIZATION OF ATMOSPHERE
C  AATM0(5,..) = COEFFICIENTS FOR PARAMETRIZATION OF ATMOSPHERE
C  BATM(5)     = ACTUAL COEFFICIENTS FOR PARAMETRIZATION OF ATMOSPHERE
C  BATM0(5,..) = COEFFICIENTS FOR PARAMETRIZATION OF ATMOSPHERE
C  CATM(5)     = ACTUAL COEFFICIENTS FOR PARAMETRIZATION OF ATMOSPHERE
C  CATM0(5,..) = COEFFICIENTS FOR PARAMETRIZATION OF ATMOSPHERE
C  DATM(5)     = 1. / CATM(I)
C  MODATM      = INDEX OF ATMOSPHERIC MODEL
C
C --------------/CRATMOS2/-----------------------
C  HLAY(6)     = ALTITUDE OF ACTUAL ATMOSPHERIC LAYER BOUNDARIES
C  HLAY0(5,..) = ALTITUDE OF ATMOSPHERIC LAYER BOUNDARIES
C  THICKL(5)   = THICKNESS AT ATMOSPHERIC LAYER BOUNDARIES
C  LAYNO(..)   = POINTER OF ATMOSPHERE TO LAYER NUMBER
C  LAYNEW      = FLAG INDICATING NEW ATMOSPHERIC LAYER BOUNDARIES
C

C --------------/CRATMOSX/-----------------------
C  IATMOX      = MODTRAN ATMOSPHERIC MODEL NUMBER
C  FREFRX      = FLAG INDICATING REFRACTIVE INDEX IS TAKEN
C
C --------------/CRATMOSL/-----------------------
C  PATH1(500)  = SLANT PATH LENGTH FOR BIN
C  RHOSLT(500) = DENSITY ALONG SLANT BIN
C  TSLANT(500) = SLANT THICKNESS  TOP OF ATMOSPHERE TO BIN
C  HLAYS(6)    = SLANT PATH FROM TOP OF ATMOSPHERE TO LAYER BOUNDARY
C  RHOS(6)     = DENSITY AT LAYER BOUNDARY
C  THICKS(6)   = SLANT THICKNESS TOP OF ATMOSPHERE TO LAYER BOUNDARY
C  IENDT       = LAST BIN FOR SLANT DEPTH INTERPOLATION
C

C --------------/CRAVPT/-------------------------
C  AVPT        = AVERAGE TRANSVERSE MOMENTUM FOR PIONS
C  AVPK        = AVERAGE TRANSVERSE MOMENTUM FOR KAONS
C  AVPN        = AVERAGE TRANSVERSE MOMENTUM FOR NUCLEONS
C  AVPH        = AVERAGE TRANSVERSE MOMENTUM FOR STRANGE BARYONS
C  AVPE        = AVERAGE TRANSVERSE MOMENTUM FOR ETAS
C
C --------------/CRBOUNDS/-----------------------
C  (SEE EGS4 MANUAL)
C
C --------------/CRBREMPR/-----------------------
C  (SEE EGS4 MANUAL)
C
C --------------/CRBUFFS/------------------------
C  MAXBUF      = PARAMETER FOR MAXIMAL BUFFER SIZE
C  MAXLEN      = PARAMETER FOR SIZE OF PARTICLE FIELDS
C
C  RUNH(MAXBUF)= BUFFER FOR RUN   HEADER
C  RUNE(MAXBUF)= BUFFER FOR RUN   END
C  EVTH(MAXBUF)= BUFFER FOR EVENT HEADER
C  EVTE(MAXBUF)= BUFFER FOR EVENT END
C  DATAB(MAXBUF)= BUFFER FOR DATA
C  ARRAYLONG( )= BUFFER FOR LONGITUDINAL PARTICLE DISTRIBUTION
C  LH          = BUFFER POINTER
C
C --------------/CRCEREN1/-----------------------
C  CERELE      = CHERENKOV PHOTONS FROM ELECTRONS
C  CERHAD      = CHERENKOV PHOTONS FROM HADRONS
C  ETADSN      = CORRECTION FACTOR FOR REFRACTIVE INDEX CALCULATION
C  WAVLGL      = CHERENKOV WAVE LENGTH BAND LOWER END (NANOMETER)
C  WAVLGU      = CHERENKOV WAVE LENGTH BAND UPPER END (NANOMETER)
C  CYIELD      = CHERENKOV YIELD FACTOR
C  CERSIZ      = MAXIMAL NUMBER OF PHOTONS IN ONE BUNCH
C  CERNOR      = NORMALISATION FACTOR FOR CALC. OF WAVELENGTH OF C-PHOTONS
C  LCERFI      = FLAG FOR STEERING CHERENKOV PHOTON OUTPUT
C  LCERDB      = FLAG FOR DEBUG OUTPUT IN CHERENKOV PART
C
C --------------/CRCEREN2/-----------------------
C  ACERX       = CHERENKOV DETECTOR SIZE IN X DIRECTION IN CM
C  ACERY       = CHERENKOV DETECTOR SIZE IN Y DIRECTION IN CM
C  CERXOS(I)   = X OFFSETS OF SHOWER CORE FOR THE MULTIPLE EVENTS IN CM
C  CERYOS(I)   = Y OFFSETS OF SHOWER CORE FOR THE MULTIPLE EVENTS IN CM
C  DCERX       = GRID SPACING IN X DIRECTION IN CM
C  DCERXI      = INVERSE OF GRID SPACING IN X DIRECTION
C  DCERY       = GRID SPACING IN Y DIRECTION IN CM
C  DCERYI      = INVERSE OF GRID SPACING IN Y DIRECTION
C  EPSX        = HALF COVERAGE RATIO IN X DIRECTION
C  EPSY        = HALF COVERAGE RATIO IN Y DIRECTION
C  FCERX       = OFFSET FOR A ODD/EVEN NUMBER OF CHEREKOV DETECTORS IN X
C  FCERY       = OFFSET FOR A ODD/EVEN NUMBER OF CHEREKOV DETECTORS IN Y
C  WL          = WAVELENGTH OF CHERENKOV PHOTON
C  XCMAX       = MAX. EXTENSION OF ARRAY IN X DIRECTION
C  XCMAXS      = MAX. EXTENSION OF ARRAY IN X DIRECTION INCL. SCATTER
C  XSCATT      = RANGE OF X SCATTER OF SHOWER CORE IN CM
C  YCMAX       = MAX. EXTENSION OF ARRAY IN Y DIRECTION
C  YCMAXS      = MAX. EXTENSION OF ARRAY IN Y DIRECTION INCL. SCATTER
C  YSCATT      = RANGE OF Y SCATTER OF SHOWER CORE IN CM
C  PHOTCM      = NUMBER OF CHERENKOV PHOTONS EMITTED FROM PATH ELEMENT
C  XCER        = X-DISTANCE FROM SHOWER AXIS AT DET.LEVEL FOR CHERENKOV
C  YCER        = Y-DISTANCE FROM SHOWER AXIS AT DET.LEVEL FOR CHERENKOV
C  UEMIS       = EMISSION ANGLE COSINES OF CHERENKOV PHOTONS
C  VEMIS       = EMISSION ANGLE COSINES OF CHERENKOV PHOTONS
C  WEMIS       = EMISSION ANGLE COSINES OF CHERENKOV PHOTONS
C  CARTIM      = ARRIVAL TIME OF CHERENKOV PHOTONS
C  ZEMIS       = Z-COORDINATE OF EMISSION POINT

C  NCERX       = NUMBER OF CHERENKOV DETECTORS IN X DIRECTION
C  NCERY       = NUMBER OF CHERENKOV DETECTORS IN Y DIRECTION
C  ICERML      = NUMBER OF MULTIPLE CHERENKOV ARRAYS
C
C --------------/CRCEREN3/-----------------------
C  MAXBF2      = MAXIMUM BUFFER SIZE FOR CERENKOV PHOTONS
C
C  CERCNT      = CHERENKOV PHOTON COUNTER
C  DATAB2(...) = BUFFER FOR DATA FOR CHERENKOV OUTPUT
C  NRECER      = COUNTER FOR DIRECT ACCESS OUTPUT OF CHERENKOV PHOTONS
C  LHCER       = CHERENKOV BUFFER POINTER
C

C --------------/CRCHISTA/-----------------------
C  IHYCHI(124) = INTERACTION LENGTH STATISTICS FOR STRANGE BARYONS
C  IKACHI(124) = INTERACTION LENGTH STATISTICS FOR KAONS
C  IMUCHI(124) = INTERACTION LENGTH STATISTICS FOR MUONS
C  INNCHI(124) = INTERACTION LENGTH STATISTICS FOR NUCLEI
C  INUCHI(124) = INTERACTION LENGTH STATISTICS FOR NUCLEONS
C  IPICHI(124) = INTERACTION LENGTH STATISTICS FOR PIONS
C  INECHI(124) = INTERACTION LENGTH STATISTICS FOR NEUTRINOS
C
C --------------/CRCONSTA/-----------------------
C  PI          = 3.14159...     SET IN BLOCK DATA
C  PI2         = 2 * PI
C  OB3         = ONE BY THREE = 1./3.
C  TB3         = TWO BY THREE = 2./3.
C  ENEPER      = 2.718281828 (EULER''S CONSTANT)
C

C --------------/CRCORFRAM/----------------------
C  DETSYS      = FLAG FOR DETECTOR FRAME(TRUE, IF WE ARE ALREADY IN DS)
C

C --------------/CRCURVE/------------------------
C  CHAPAR      = ARRAY OF PARTICLE NUMBERS FOR LONGIT. DISTRIBUTION
C  DEP         = ARRAY OF DEPTH VALUES FOR LONGITUDINAL DISTRIBUTION
C  ERR         = ARRAY OF ERRORS OF PARTICLE NUMBERS IN LONG. DIST.
C  NSTP        = NUMBER OF STEPS FOR LONGITUDINAL DIST. FIT
C
C --------------/CRDECAYC/------------------------
C  GAM345(3)   = GAMMA FACTOR OF PARTICLE EMERGING FROM 3 BODY DECAY
C  COS345(3)   = COSINE THETA OF PARTICLE EMERGING FROM 3 BODY DECAY
C  PHI345(3)   = ANGLE  PHI   OF PARTICLE EMERGING FROM 3 BODY DECAY
C  CPHI345(3)  = COSINE PHI   OF PARTICLE EMERGING FROM 3 BODY DECAY
C  SPHI345(3)  = SINE   PHI   OF PARTICLE EMERGING FROM 3 BODY DECAY
C
C --------------/CRDPMFLG/-----------------------
C  NFLAIN      = 0  RANDOM NUMBER OF INTERACTIONS IN AIR TARGET
C              = 1  FIXED  NUMBER OF INTERACTIONS IN AIR TARGET
C  NFLDIF      = 0  NO DIFFRACTIVE INTERACTION IF NFLAIN = 0 AND MORE
C                   THAN 1 INTERACTION
C  NFLPI0      = 0  RAPIDITY OF PI0 TREATED ACCORDING TO COLLIDER DATA
C              = 1  RAPIDITY OF PI0 SAME AS THAT OF CHARGED
C  NFLCHE      = 0  CHARGE EXCHANGE INTERACTION POSSIBLE
C              = 1  NO CHARGE EXCHANGE INTERACTION POSSIBLE
C  NFLPIF      = 0  NO FLUCTUATION OF NUMBER OF PI0
C              = 1  FLUCTUATION OF NUMBER OF PI0 AS SEEN IN COLLIDER
C  NFRAGM      = 0  TOTAL FRAGMENTATION OF PRIMARY NUCLEUS IN 1.INTERACT
C              = 1  NO FRAGMENTATION AND NO EVAPORATION
C              = 2  REALISTIC FRAGMENTATION OR EVAPORATION (PT AFTER JACEE)
C              = 3  REALISTIC FRAGMENTATION OR EVAPORATION (PT AFTER GOLDHABER)
C              = 4  REALISTIC FRAGMENTATION OR EVAPORATION WITH PT-0
C
C --------------/CREDECAY/-----------------------
C  CETA(1)     = BRANCHING RATIO FOR ETA DECAY
C  CETA(2)     = BRANCHING RATIO FOR ETA DECAY
C  CETA(3)     = BRANCHING RATIO FOR ETA DECAY
C  CETA(4)     = ASYMMETRY TERM    IN DECAY  ETA-->PI(+) + PI(-) + PI(0)
C  CETA(5)     = MAXIMUM AMPLITUDE IN DECAY  ETA-->PI(+) + PI(-) + PI(0)
C

C --------------/CREGSDEB/-----------------------
C  JCLOCK      = PRESET COUNTER FOR EGS-DEBUG ACTIVATION
C  NCLOCK      = ACTUAL ELECTRON COUNTER FOR EGS-DEBUG
C  FEGSDB      = DEBUG FALG FOR EGS-DEBUGGING
C
C --------------/CRELABCT/-----------------------
C  ELCUT(.)    = CUT ON KINETIC ENERGY OF PARTICLES (HADR.,MU, E, GAMMA)
C
C --------------/CRELADPM/-----------------------
C  ELMEAN(40)  = MEAN ELASTICITY FOR ENERGY BINS PER SHOWER
C  ELMEAA(40)  = MEAN ELASTICITY FOR ENERGY BINS FOR ALL SHOWERS
C  IELDPM(.)   = ELASTICITY STATISTICS IN DUAL PARTON MODELL FOR SHOWER
C  IELDPA(.)   = ELASTICITY STATISTICS IN DUAL PARTON MODELL FOR ALL
C
C --------------/CRELASTY/-----------------------
C  ELAST       = ELASTICITY OF FIRST REACTION
C
C --------------/CRELECIN/-----------------------
C  (SEE EGS4 MANUAL)
C  STERNCOR    = PARAMETER FOR STERNHEIMER CORRECTION (SEE SUBR. ELECTR)
C
C --------------/CREPCONT/-----------------------
C  EDEP        = ENERGY DEPOSITED ALONG STEP
C  RATIO       = RATIO TOTAL STEP LENGTH/SCATTERING LENGTH FOR ELECTRONS
C  TSTEP       = DISTANCE TO NEXT INTERACTION
C  TUSTEP      = TOTAL (CURVED) STEP LENGTH REQUESTED
C  USTEP       = USER STEP LENGTH REQUESTED
C  TVSTEP      = ACTUAL TOTAL STEP LENGTH
C  VSTEP       = ACTUAL STEP LENGTH
C  RHOFAC      = DENSITY FACTOR
C  EOLD        = ENERGY AT BEGIN OF STEP
C  ENEW        = ENERGY AT END OF STEP
C  EKE         = KINETIC ENERGY OF ELECTRON
C  ELKE        = LOGARITHM OF ELECTRON KINETIC ENERGY
C  BETA2       = VELOCITY OF ELECTRON SQUARED
C  GLE         = LOGARITHM OF GAMMA ENERGY
C  TSCAT       = SEE EQ. 2.14.82 IN SLAC-265
C  IDISC       = FLAG INDICATING PARTICLE IS TO BE DISCARDED
C  IROLD       = INDEX OF OLD ATMOSPERIC LAYER
C  IRNEW       = INDEX OF NEW ATMOSPHERIC LAYER
C
C --------------/CRETHMAP/-----------------------
C  ECTMAP      = CUT TO PRINT OUT PARTICLES
C  ELEFT       = SUMMED ENERGY OF PARTICLES ON STACK
C

C --------------/CRFLULIN/-----------------------
C  ICFTABL     = CONVERSION TABLE PARTICLE CODE CORSIKA TO FLUKA
C  IFCTABL     = CONVERSION TABLE PARTICLE CODE FLUKA TO CORSIKA

C
C --------------/CRGENER/------------------------
C  GEN         = GENERATION OF PARTICLE
C  ALEVEL      = LEVEL OF LAST HADRONIC INTERACTION
C
C --------------/GHEISHA COMMONS/----------------
C             SEE: GHEISHA ROUTINES
C
C --------------/CGCOMP/-------------------------
C  ACOMP       = ATOMIC WEIGHT OF COMPONENT (GHEISHA)
C  ZCOMP       = ATOMIC NUMBER OF COMPONENT (GHEISHA)
C  WCOMP       = ATOMIC FRACTION OF COMPONENT (GHEISHA)
C  KK          = NUMBER OF TARGET COMPONENTS (GHEISHA)
C
C --------------/CRGEOMEGS/----------------------
C  ZALTIT      = STARTING ALTITUDE (EGS4)
C  BOUND       = BOUNDARIES OF ATMOSPHERIC LAYERS (EGS4)
C  OBSLVL      = OBSERVATION LEVEL (EGS4)
C  OBSLV2      = OBSERVATION LEVEL - 1G/CM**2 (EGS4 AUGERHIST)
C  NEWOBS      = POINTER FOR NEXT OBSERVATIONLEVEL (EGS4)
C
C --------------/CRGNUPR/------------------------
C  SE14(.)     = ARRAY FOR COLLISION PROBABILITY
C  SE16(.)     = ARRAY FOR COLLISION PROBABILITY
C  SE40(.)     = ARRAY FOR COLLISION PROBABILITY
C
C --------------/CRINDICE/-----------------------
C  NNUCN(.)    = # OF NEUTRON       PAIRS  IN 1ST + 2ND / 3RD STRING
C  NKA0(.)     = # OF NEUTRAL KAON  PAIRS  IN 1ST + 2ND / 3RD STRING
C  NHYPN(.)    = # OF NEUTR.STR.BAR.PAIRS  IN 1ST + 2ND / 3RD STRING
C  NETA(I,K)   = # OF ETAS                 IN 1ST + 2ND / 3RD STRING
C                SEPARATELY DEFINED FOR EACH DECAY MODE K
C  NETAS(I)    = # OF ETAS                 IN 1ST + 2ND / 3RD STRING
C  NPIZER(.)   = # OF PI(0)S               IN 1ST + 2ND / 3RD STRING
C  NNC         = # OF PROTON                 PAIRS
C  NKC         = # OF CHARGED KAON           PAIRS
C  NHC         = # OF CHARGED STRANGE BARYON PAIRS
C  NPC         = # OF CHARGED PIONS
C  NCH         = # OF CHARGED PARTICLES
C  NNN         = TOTAL # OF NEUTRON        PAIRS
C  NKN         = TOTAL # OF NEUTRAL KAON   PAIRS
C  NHN         = TOTAL # OF NEUTR.STR.BAR. PAIRS
C  NET         = TOTAL # OF ETAS
C  NPN         = TOTAL # OF PI(0)S
C
C --------------/CRINTER/------------------------
C  AVCH        = AVERAGE # OF CHARGED PARTICLES
C  AVCH3       = AVERAGE # OF CHARGED PARTICLES IN 3RD STRING
C  DC0         = AVERAGE DENSITY AT CENTRE OF RAPIDITY
C  DLOG        = LOG OF DIFFRACTIVE MASS SQUARED
C  DMLOG       = LOG(ECMDIF**2 - MASS PI(0)**2 - MASS DIFFR.PART.**2)
C  ECMDIF      = DIFFRACTIVE MASS FOR HDPM
C  ECMDPM      = C.M ENERGY FOR HDPM
C  ELAB        = LAB ENERGY OF INCOMING PARTICLE IN SDPM/HDPM
C  FNEUT       = # OF NEUTRAL PARTICLES (ALL 3 STRINGS)  WITH FLUCTUAT
C  FNEUT2      = # OF NEUTRAL PARTICLES (1ST+2ND STRING) WITH FLUCTUAT
C  GNU         = # OF COLLISIONS IN TARGET
C  PLAB        = MOMENTUM OF INCOMING PARTICLE IN LAB SYSTEM
C  POSC2       = POSITION OF GAUSSIAN FOR 1ST+2ND STRING (CHARGED)
C  POSC3       = POSITION OF GAUSSIAN FOR 3RD     STRING (CHARGED)
C  POSN2       = POSITION OF GAUSSIAN FOR 1ST+2ND STRING (NEUTRAL)
C  POSN3       = POSITION OF GAUSSIAN FOR 3RD     STRING (NEUTRAL)
C  RC3TO2      = RATIO (CHARGED OF 3RD STRING)/(CHARGED 1ST+2ND STRING)
C  S           = C.M. ENERGY SQUARED
C  SEUGF       = NUMBER OF GAMMAS (WITH FLUCTUATION)
C  SEUGP       = NUMBER OF GAMMAS (AVERAGE PARAMETRIZED)
C  SLOG        = LOG OF C.M.ENERGY SQUARED
C  SLOGSQ      = SQUARE OF LOG OF C.M.ENERGY SQUARED
C  SMLOG       = LOG ( C.M. ENERGY SQUARED  - 2 * NUCL.MASS**2 )(HDPM)
C  WIDC2       = WIDTH    OF GAUSSIAN FOR 1ST+2ND STRING (CHARGED)
C  WIDC3       = WIDTH    OF GAUSSIAN FOR 3RD     STRING (CHARGED)
C  WIDN2       = WIDTH    OF GAUSSIAN FOR 1ST+2ND STRING (NEUTRAL)
C  WIDN3       = WIDTH    OF GAUSSIAN FOR 3RD     STRING (NEUTRAL)
C  YCM         = RAPIDITY OF CM SYSTEM IN LABORATORY
C  YY0         = RAPIDITY OF DIFFRACTIVE SYSTEM IN CMS
C  ZN          = CENTR. RAP. DENSITY FOR CALCULATION OF PT
C  IDIF        = DIFFRACTION FLAG IN HDPM
C  ITAR        = PARTICLE CODE OF TARGET NUCLEON IN HDPM
C
C --------------/CRIRET/-------------------------
C  IRET1       = RETURN CODE
C  IRET2       = RETURN CODE
C  IRETE       = RETURN CODE FOR ENERGY CUT (LOGICAL)
C
C --------------/CRISTA/-------------------------
C  IFINET      = # ETAS PRODUCED IN FIRST INTERACTION
C  IFINNU      = # NUCLEONS PRODUCED IN FIRST INTERACTION
C  IFINKA      = # KAONS PRODUCED IN FIRST INTERACTION
C  IFINPI      = # PIONS PRODUCED IN FIRST INTERACTION
C  IFINHY      = # STRANG BARYONS PRODUCED IN FIRST INTERACTION
C  IFINOT      = # OTHER HADRONS PRODUCED IN FIRST INTERACTION
C
C --------------/CRKAONS/------------------------
C  CKA(.)      = PHYSICAL CONSTANTS FOR KAONS
C  CKA(2)      = MEAN FOR KAON LONG. MOMENTUM COMING FROM VHMESO
C  CKA(23)     = BRANCH RATIO K(+,-) DECAY
C  CKA(24)     = BRANCH RATIO K0S DECAY
C  CKA(25)     = BRANCH RATIO K0L DECAY
C  CKA(26)     = BRANCH RATIO K0L DECAY
C  CKA(27)     = BRANCH RATIO K0L DECAY
C  CKA(47)     = BRANCH RATIO K(+,-) DECAY
C  CKA(48)     = BRANCH RATIO K(+,-) DECAY
C  CKA(49)     = BRANCH RATIO K(+,-) DECAY
C  CKA(50)     = BRANCH RATIO K(+,-) DECAY
C  CKA(51)     = G     OF K+,- ===> PI+,- + PI+,- + PI-,+
C  CKA(52)     = H     OF K+,- ===> PI+,- + PI+,- + PI-,+
C  CKA(53)     = K     OF K+,- ===> PI+,- + PI+,- + PI-,+
C  CKA(54)     = AMPMX OF K+,- ===> PI+,- + PI+,- + PI-,+
C  CKA(55)     = G     OF K+,- ===> PI0 + PI0 + PI+,-
C  CKA(56)     = H     OF K+,- ===> PI0 + PI0 + PI+,-
C  CKA(57)     = K     OF K+,- ===> PI0 + PI0 + PI+,-
C  CKA(58)     = AMPMX OF K+,- ===> PI0 + PI0 + PI+,-
C  CKA(59)     = G,H,K OF K0L ===> PI0 + PI0 + PI0
C  CKA(60)     = AMPMX OF K0L ===> PI0 + PI0 + PI0
C  CKA(61)     = G     OF K0L ===> PI+ + PI- + PI0
C  CKA(62)     = H     OF K0L ===> PI+ + PI- + PI0
C  CKA(63)     = K     OF K0L ===> PI+ + PI- + PI0
C  CKA(64)     = AMPMX OF K0L ===> PI+ + PI- + PI0
C  CKA(65)     = LAMBDA-PLUS OF K+,- ===> PI0 + E + NU
C  CKA(66)     = LAMBDA-ZERO OF K+,- ===> PI0 + E + NU
C  CKA(67)     = AMPMX       OF K+,- ===> PI0 + E + NU
C  CKA(68)     = LAMBDA-PLUS OF K+,- ===> PI0 + MU + NU
C  CKA(69)     = LAMBDA-ZERO OF K+,- ===> PI0 + MU + NU
C  CKA(70)     = AMPMX       OF K+,- ===> PI0 + MU + NU
C  CKA(71)     = LAMBDA-PLUS OF K0L ===> PI + E + NU
C  CKA(72)     = LAMBDA-ZERO OF K0L ===> PI + E + NU
C  CKA(73)     = AMPMX       OF K0L ===> PI + E + NU
C  CKA(74)     = LAMBDA-PLUS OF K0L ===> PI + MU + NU
C  CKA(75)     = LAMBDA-ZERO OF K0L ===> PI + MU + NU
C  CKA(76)     = AMPMX       OF K0L ===> PI + MU + NU
C
C --------------/CRLAYER/------------------------
C  HBARO       = BAROMETRIC EXPONENT OF ATMOSPHERIC LAYER (EGS4)
C  HBAROI      = INVERSE OF BAROMETRIC EXP. OF ATMOSPHERIC LAYER (EGS4)
C
C --------------/CRLEPAR/------------------------
C  LEPAR1      = TYPE OF LEADING PARTICLE BEFORE / AFTER CHARGE EXCHANGE
C  LEPAR2      = TYPE OF TARGET  PARTICLE BEFORE / AFTER CHARGE EXCHANGE
C  LASTPI      = # OF CHARGED PIONS CREATED/DELETED BY CHARGE EXCHANGE
C  NRESPC      = # OF CHARGED PIONS TO BE CREATED BY RESONANCE DECAY
C  NRESPN      = # OF NEUTRAL PIONS TO BE CREATED BY RESONANCE DECAY
C  NCPLUS      = POSITIVE CHARGE EXCESS BY RESONANCE/CHARGE EXCHANGE
C
C --------------/CRLONGI/------------------------
C  LNGMAX      = MAXIMUM ARRAY LENGTH OF LONGI ARRAYS
C  ADLONG(I,K) = AVERAGE OF DLONG OVER ALL SHOWERS
C  AELONG(I,K) = AVERAGE OF ELONG OVER ALL SHOWERS
C  APLONG(I,K) = AVERAGE OF PLONG OVER ALL SHOWERS
C  DLONG(I,K)  = LONGITUDINAL ENERGY DEPOSITS PER SHOWER IN I BINS FOR
C                1=ABSORBED GAMMAS, 2=EM-IONIZATION, 3=E-CUTTED EM,
C                4=MU-& MU+ IONOZATION, 5= E-CUTTED MUONS,
C                6=HADRON IONIZATION, 7=E-CUTTED HADRONS, 8=NEUTRINO,
C                9=SUM OF DEPOSITS, 10=DUMMY,
C                11=ANGL. CUTTED GAMMAS, 12=DUMMY, 13=ANGL. CUTTED EM,
C                14=DUMMY, 15=ANGL. CUTTED MUONS, 16=DUMMY,
C                17=ANGL. CUTTED HADRONS, 18=ANGL. CUTTED NEUTRINOS,
C                19=DUMMY
C  ELONG(I,K)  = LONGITUDINAL ENERGY DISTRIBUTIONS PER SHOWER IN I
C                BINS FOR K= GAMMAS, POSITRONS, ELECTRONS, MU+, MU-,
C                HADRONS, CHARGED, NUCLEI, AND CHERENKOV PHOTONS
C  HLONG(I)    = THE HEIGHT VALUES IN CM FOR THE LEVELS IN G/CM**2
C  PLONG(I,K)  = LONGITUDINAL PARTICLE DISTRIBUTIONS PER SHOWER IN I
C                BINS FOR K= GAMMAS, POSITRONS, ELECTRONS, MU+, MU-,
C                HADRONS, CHARGED, NUCLEI, AND CHERENKOV PHOTONS
C  SDLONG(I,K) = STANDARD DEVIATION OF DLONG
C  SELONG(I,K) = STANDARD DEVIATION OF ELONG
C  SPLONG(I,K) = STANDARD DEVIATION OF PLONG
C  THSTEP      = STEP WIDTH IN G/CM**2 FOR LONGITUDINAL DISTRIBUTION
C  THSTPI      = 1/THSTEP
C  LHEIGH      = STEP NUMBER AT INTERACTION POINT
C  NSTEP       = NUMBER OF STEPS FOR LONGITUDINAL DISTRIBUTION
C  LLONGI      = LOGICAL TO STEER THE SAMPLING OF LONGITUDINAL DISTRIBUTION
C  FLGFIT      = LOGICAL TO ENABLE/DISABLE FIT TO CHARGED PART. LONG. DISTR.
C - - - - - - - /CRSLANT/ - - - - - - - - - - - -
C  RLONG()     = ARRAY FOR DISTANCES TO PLANE NORMAL TO SHOWER AXIS
C  THCKRL()    = ARRAY FOR THICKNESS TO PLANE NORMAL TO SHOWER AXIS
C  CTH         = COSINE OF PRIMARY FOR PLANE NORMAL TO SHOWER AXIS
C  STHCPH      = SINTHE*COSPHI OF PRIMARY FOR PLANE NORM. TO SHOWER AXIS
C  STHSPH      = SINTHE*SINPHI OF PRIMARY FOR PLANE NORM. TO SHOWER AXIS
C  RLOFF       = OFFSET OF PLANE NORMAL TO SHOWER AXIS
C
C --------------/CRMAGANG/-----------------------
C  ARRANG      = ANGLE (DEG) ARRAY X-DIRECTION AND MAGNETIC NORD
C  ARRANR      = ANGLE (RAD) ARRAY X-DIRECTION AND MAGNETIC NORD
C  COSANG      = COSINE OF ARRANR
C  SINANG      = SIN OF ARRANR
C
C --------------/CRMAGNET/-----------------------
C  BX          = MAGNET FIELD STRENGTH COMPONENT TO NORTH [MICROTESLA]
C  BZ          = MAGNET FIELD STRENGTH COMPONENT DOWNWARD [MICROTESLA]
C  BVAL        = SQUARED MAGNET FIELD STRENGTH
C  BNORMC      = MAGNETIC DEFLECTION CONSTANT [GEV/CM]
C  BNORM       = MAGNETIC DEFLECTION CONSTANT [MEV/CM]
C  COSB        = COS OF INCLINATION ANGLE
C  SINB        = SIN OF INCLINATION ANGLE
C  BLIMIT      = LIMIT FACTOR FOR STEP SIZE OF ELECTRONS IN MAGN.FIELD
C
C --------------/CRMEDIA/------------------------
C  (SEE EGS4 MANUAL)
C
C --------------/CRMEDIAC/------------------------
C  (SEE EGS4 MANUAL)
C
C --------------/CRMISC/--------------------------
C  (SEE EGS4 MANUAL)
C
C --------------/CRMPARTI/-----------------------
C  MPARTO(.)   = ARRAY FOR MEAN # OF PARTICLES
C  MPHOTO(20)  = MEAN # OF GAMMAS WRITTEN TO TAPE PER LEVEL
C  MPOSIT(20)  = MEAN # OF E+ WRITTEN TO TAPE PER LEVEL
C  MELECT(20)  = MEAN # OF E- WRITTEN TO TAPE PER LEVEL
C  MNU(20)     = MEAN # OF NEUTRINOS WRITTEN TO TAPE PER LEVEL
C  MMUP(20)    = MEAN # OF MU+ WRITTEN TO TAPE PER LEVEL
C  MMUM(20)    = MEAN # OF MU- WRITTEN TO TAPE PER LEVEL
C  MPI0(20)    = MEAN # OF PI(0) WRITTEN TO TAPE PER LEVEL
C  MPIP(20)    = MEAN # OF PI+ WRITTEN TO TAPE PER LEVEL
C  MPIM(20)    = MEAN # OF PI- WRITTEN TO TAPE PER LEVEL
C  MK0L(20)    = MEAN # OF K0L WRITTEN TO TAPE PER LEVEL
C  MKPL(20)    = MEAN # OF K + WRITTEN TO TAPE PER LEVEL
C  MKMI(20)    = MEAN # OF K - WRITTEN TO TAPE PER LEVEL
C  MNEUTR(20)  = MEAN # OF NEUTRONS WRITTEN TO TAPE PER LEVEL
C  MPROTO(20)  = MEAN # OF PROTONS WRITTEN TO TAPE PER LEVEL
C  MPROTB(20)  = MEAN # OF ANTIPROTONS WRITTEN TO TAPE PER LEVEL
C  MK0S(20)    = MEAN # OF K0S WRITTEN TO TAPE PER LEVEL
C  MHYP(20)    = MEAN # OF STRANGE BARYONS WRITTEN TO TAPE PER LEVEL
C  MDEUT(20)   = MEAN # OF DEUTERONS WRITTEN TO TAPE PER LEVEL
C  MTRIT(20)   = MEAN # OF TRITONS WRITTEN TO TAPE PER LEVEL
C  MHELI3(20)  = MEAN # OF 3HELIUM WRITTEN TO TAPE PER LEVEL
C  MALPHA(20)  = MEAN # OF ALPHAS WRITTEN TO TAPE PER LEVEL
C  MOTHER(20)  = MEAN # OF OTHER PARTICLES WRITTEN TO TAPE PER LEVEL
C  MMUOND      = MEAN # OF MUONS DECAYED TO ELECTRONS/POSITRONS
C  MNEUTB(20)  = MEAN # OF ANTINEUTRONS WRITTEN TO TAPE PER LEVEL
C
C --------------/CRMULT/-------------------------
C  EKINL       = ENERGY FOR ENERGY-MULTIPLICITY MATRIX
C  MSMM        = MULTIPLICITY FOR ENERGY-MULTIPLICITY MATRIX
C  MULTMA(.)   = ENERGY-MULTIPLICITY MATRIX FOR SHOWER
C  MULTOT(.)   = ENERGY-MULTIPLICITY MATRIX FOR SHOWER GROUP
C
C --------------/CRMULTS/-------------------------
C  (SEE EGS4 MANUAL)
C
C --------------/CRMUMULT/-----------------------
C  CHC         = CONSTANT CHI_C   FOR MUOMN MULTIPLE SCATTERING
C  OMC         = CONSTANT OMEGA_C FOR MUOMN MULTIPLE SCATTERING
C  PHISCT      = AZIMUTAL ANGLE OF MUON MULTIPLE SCATTERING
C  CPHISCT     = COSINE OF AZIMUTAL ANGLE OF MUON MULTIPLE SCATTERING
C  SPHISCT     = SINE   OF AZIMUTAL ANGLE OF MUON MULTIPLE SCATTERING
C  STEPL       = STEP LENGTH FOR MUON TRANSPORT STEP
C  VSCAT       = POLAR ANGLE OF MUON MULTIPLE SCATTERING
C  FMOLI       = FLAG INDICATING MOLIERE (T) OR GAUSS (F) SCATTERING
C
C --------------/CRMUON/-------------------------
C  PRRMMU      = REST MASS OF MUON (EGS4)
C  RMMUT2      = 2 * REST MASS OF MUON (EGS4)
C
C --------------/CRMUPART/-----------------------
C  AMUPAR(0:16)= REGISTER FOR MUON PARTICLE ADDITIONAL INFO
C  BCUT        = CUT-OFF ENERGY FOR MUON BREMSSTRAHLUNG
C  CMUON(11)   = CONSTANTS FOR MUON BREMSSTRAHLUNG CALCULATION
C  AATOM       = NUCLEONS IN TARGET FOR MUON INTERACTIONS
C  CONSTKINE   = KINEMATIC CONSTANT FOR MUON INTERACTIONS
C  EBYMU       = MASS RATION ELECT. MASS / MUON MASS
C  EE          = TOTAL ENERGY OF MUON FOR INTERACTIONS
C  SE          = SQUARE ROOT OF E_NEPER
C  VFRAC       = ENERGY FRACTION FOR SECONDARY IN MUON INTERACTION
C  VMAX        = MAX. VALUE OF ENERGY FRACTION FOR MUON INTERACT.
C  VMIN        = MIN. VALUE OF ENERGY FRACTION FOR MUON INTERACT.
C  ZATOM       = ATOMIC NUMBER OF TARGET FOR MUON INTERACTIONS
C  FMUBRM      = FLAG TO INDICATE MUON HAS TO UNDERGO BREMSSTRAHLUNG
C  FMUNUC      = FLAG TO INDICATE MUON HAS TO UNDERGO NUCL.INTERACT.
C  FMUORG      = FLAG TO INDICATE WHETHER MUON BELONGS TO AMUPAR(.)
C
C --------------/CRNCOUNT/-----------------------
C  NCOUN(8)    = COUNTER OF ANTINUCLEONS IN VARIOUS BOX ROUTINES
C
C --------------/CRNCSNCS/-----------------------
C  SIGN30(.)   = ARRAY FOR CROSS-SECTIONS NITROGEN
C  SIGN45(.)   = ARRAY FOR CROSS-SECTIONS NITROGEN
C  SIGN60(.)   = ARRAY FOR CROSS-SECTIONS NITROGEN
C  SIGO30(.)   = ARRAY FOR CROSS-SECTIONS OXYGEN
C  SIGO45(.)   = ARRAY FOR CROSS-SECTIONS OXYGEN
C  SIGO60(.)   = ARRAY FOR CROSS-SECTIONS OXYGEN
C  SIGA30(.)   = ARRAY FOR CROSS-SECTIONS ARGON
C  SIGA45(.)   = ARRAY FOR CROSS-SECTIONS ARGON
C  SIGA60(.)   = ARRAY FOR CROSS-SECTIONS ARGON
C  PNOA30(.)   = ARRAY FOR PROBABILITY OF # OF INTERACTIONS
C  PNOA45(.)   = ARRAY FOR PROBABILITY OF # OF INTERACTIONS
C  PNOA60(.)   = ARRAY FOR PROBABILITY OF # OF INTERACTIONS
C  SIG30A(.)   = ARRAY FOR CROSS-SECTIONS AIR
C  SIG45A(.)   = ARRAY FOR CROSS-SECTIONS AIR
C  SIG60A(.)   = ARRAY FOR CROSS-SECTIONS AIR
C
C --------------/CRNEWPAR/-----------------------
C  EA(3000)    = ENERGY            OF SECONDARY PARTICLE IN HDPM
C  PT2(3000)   = PT**2             OF SECONDARY PARTICLE IN HDPM
C  PX(3000))   = PT IN X DIRECTION OF SECONDARY PARTICLE IN HDPM
C  PY(3000))   = PT IN Y DIRECTION OF SECONDARY PARTICLE IN HDPM
C  TMAS(3000)  = TRANSVERSE MASS   OF SECONDARY PARTICLE IN HDPM
C  YR(3000)    = RAPIDITY          OF SECONDARY PARTICLE IN HDPM
C  ITYP(3000)  = PARTICLE TYPE     OF SECONDARY PARTICLE IN HDPM
C  IA1 ... IJ1 = LOWER BOUNDARY OF PARTICLE SPECIES
C  IA2 ... II2 = UPPER BOUNDARY OF PARTICLES 3RD STRING
C  NTOT        = TOTAL NUMBER OF PARTICLES
C
C --------------/CRNKGI/-------------------------
C  SEL(10)     = USED FOR AVERAGING OF SL(10)
C  SELLG(10)   = USED FOR LOGARITHMIC AVERAGING OF SL(10)
C  STH(10)     = AGE IN STEPS OF 100 G/CM**2, SUM OVER ALL SHOWERS
C  ZEL(10)     = USED FOR FLUCTUATION OF SEL(10)
C  ZELLG(10)   = USED FOR FLUCTUATION OF SELLG(10)
C  ZSL(10)     = USED FOR FLUCTUATION OF STH(10))
C  DIST(10)    = DISTANCES FROM CORE IN CM (USED BY AVAGE)
C  DISX(.)     = DISTANCES OF BINS FOR RADIAL DISTRIBUTION IN X  (IN CM)
C  DISY(.)     = DISTANCES OF BINS FOR RADIAL DISTRIBUTION IN Y  (IN CM)
C  DISXY(.)    = DISTANCES OF BINS FOR RADIAL DISTRIBUTION IN XY (IN CM)
C  DISYX(.)    = DISTANCES OF BINS FOR RADIAL DISTRIBUTION IN YX (IN CM)
C  DLAX(.)     = USED FOR AVERAGING OF CZX
C  DLAY(.)     = USED FOR AVERAGING OF CZY
C  DLAXY(.)    = USED FOR AVERAGING OF CZXY
C  DLAYX(.)    = USED FOR AVERAGING OF CZYX
C  OBSATI(2)   = OBSERVATION LEVELS IN CM (USED IN NKG) (MAX. 2)
C  RADNKG      = RADIUS RANGE FOR NKG ELECTRON DENSITIES IN CM
C  RMOL(1)     = MOLIERE RADIUS IN AIR IN CM AT LOWER LEVEL
C  RMOL(2)     = MOLIERE RADIUS IN AIR IN CM AT HIGHER LEVEL
C  TLEV(10)    = LEVELS IN NKG IN G/CM**2
C  TLEVCM(10)  = LEVELS IN NKG IN CM
C  IALT(2)     = # OF LEVELS IN NKG FOR WHICH ELECT.DENSITIES ARE CALCUL
C
C --------------/CRNKGS/-------------------------
C  CZX(.)      = LATERAL DIST. OF ELECTRONDENSITY IN X (NKG) (/CM**2)
C  CZY(.)      = LATERAL DIST. OF ELECTRONDENSITY IN Y (NKG) (/CM**2)
C  CZXY(.)     = LATERAL DIST. OF ELECTRONDENSITY IN XY (NKG) (/CM**2)
C  CZYX(.)     = LATERAL DIST. OF ELECTRONDENSITY IN YX (NKG) (/CM**2)
C  SAH(10)     = AGE IN STEPS OF 100 G/CM**2
C  SL(10)      = NUMBER OF ELECTRONS IN STEPS OF 100 G/CM**2
C  ZNE(10)     = PARAMETER USED FOR LONGITUDINAL AGE CALCULATION
C
C --------------/CRNKGSUB/-----------------------
C  XXOLD       = COORDINATE OF EM PARTICLE FOR SUBTRACT. FROM NKG (EGS4)
C  YYOLD       = COORDINATE OF EM PARTICLE FOR SUBTRACT. FROM NKG (EGS4)
C  ZZOLD       = COORDINATE OF EM PARTICLE FOR SUBTRACT. FROM NKG (EGS4)
C
C --------------/CRNPARTI/-----------------------
C  NPARTO(.)   = ARRAY CONTAINING  # OF PARTICLES AT OBSERVATION LEVEL
C  NPART2(.)   = ARRAY CONTAINING  # OF PARTICLES AT OBSERVATION LEVEL
C  NPHOTO(20)  = # OF GAMMAS WRITTEN TO TAPE PER LEVEL
C  NPOSIT(20)  = # OF E+ WRITTEN TO TAPE PER LEVEL
C  NELECT(20)  = # OF E- WRITTEN TO TAPE PER LEVEL
C  NNU(20)     = # OF NEUTRINOS WRITTEN TO TAPE PER LEVEL
C  NMUP(20)    = # OF MU+ WRITTEN TO TAPE PER LEVEL
C  NMUM(20)    = # OF MU- WRITTEN TO TAPE PER LEVEL
C  NPI0(20)    = # OF PI(0) WRITTEN TO TAPE PER LEVEL
C  NPIP(20)    = # OF PI+ WRITTEN TO TAPE PER LEVEL
C  NPIM(20)    = # OF PI- WRITTEN TO TAPE PER LEVEL
C  NK0L(20)    = # OF K0L WRITTEN TO TAPE PER LEVEL
C  NKPL(20)    = # OF K+ WRITTEN TO TAPE PER LEVEL
C  NKMI(20)    = # OF K- WRITTEN TO TAPE PER LEVEL
C  NNEUTR(20)  = # OF NEUTRONS WRITTEN TO TAPE PER LEVEL
C  NPROTO(20)  = # OF PROTONS WRITTEN TO TAPE PER LEVEL
C  NPROTB(20)  = # OF ANTIPROTONS WRITTEN TO TAPE PER LEVEL
C  NK0S(20)    = # OF K0S WRITTEN TO TAPE PER LEVEL
C  NHYP(20)    = # OF STR. BARYONS WRITTEN TO TAPE PER LEVEL
C  NDEUT(20)   = # OF DEUTERONS WRITTEN TO TAPE PER LEVEL
C  NTRIT(20)   = # OF TRITONS WRITTEN TO TAPE PER LEVEL
C  NHELI3(20)  = # OF 3HELIUM WRITTEN TO TAPE PER LEVEL
C  NALPHA(20)  = # OF ALPHAS WRITTEN TO TAPE PER LEVEL
C  NOTHER(20)  = # OF OTHER PARTICLES WRITTEN TO TAPE PER LEVEL
C  NMUOND      = # OF MUONS DECAYED TO ELECTRONS/POSITRONS
C  NNEUTB(20)  = # OF ANTINEUTRONS WRITTEN TO TAPE PER LEVEL
C

C --------------/CROBSPAR/-----------------------
C  OBSLEV(..)  = OBSERVATION LEVELS (CM)
C  THCKOB(..)  = LAYER THICKNESS AT OBSERVATION LEVEL (G/CM**2)
C  XOFF(..)    = OFFSET OF X COOR. FOR INCLINED SHOWERS AT OBS. LEVEL
C  YOFF(..)    = OFFSET OF Y COOR. FOR INCLINED SHOWERS AT OBS. LEVEL
C  HEIGHP      = HEIGHT OF FIRST INTERACTION
C  THETAP      = ACTUAL THETA OF PRIMARY PARTICLE IN RADIAN
C  PHIP        = ACTUAL PHI OF PRIMARY PARTICLE IN RADIAN
C  THETPR(2)   = RANGE OF THETA OF PRIMARY PARTICLE IN RADIAN
C  PHIPR(2)    = RANGE OF PHI OF PRIMARY PARTICLE IN RADIAN
C  VUECON(2)   = RANGE OF VIEWING CONE AROUND FIXED THETA+PHI IN RADIAN

C  NOBSLV      = # OF OBSERVATION LEVELS
C
C --------------/CRPAM/--------------------------
C  PAMA(6000)  = MASS OF PARTICLE (GEV)
C  SIGNUM(6000)= SIGN AND CHARGE OF PARTICLES
C  RESTMS(6000)= RELEASABLE KINETIC ENERGY OF PARTICLE
C  DECTIM(200) = LIFE TIME AT REST OF UNSTABLE PARTICLES
C
C --------------/CRPARPAR/-----------------------
C..CURRENT PARTICLE AND EQUIVALENCED QUANTITIES
C  CURPAR(0)   = PARTICLE TYPE
C  CURPAR(1)   = GAMMA,  LORENTZ FACTOR IN LAB
C  CURPAR(2)   = COSTHE, DIRECTION COSINE Z-DIRECTION
C  CURPAR(3)   = PHIX,   DIRECTION COSINE X-DIRECTION
C  CURPAR(4)   = PHIY,   DIRECTION COSINE Y-DIRECTION
C  CURPAR(5)   = H,      HEIGHT (TRUE HEIGHT)
C  CURPAR(6)   = T,      ACCUMULATED TIME IN SEC
C  CURPAR(7)   = X,      X-POSITION
C  CURPAR(8)   = Y,      Y-POSITION
C  CURPAR(9)   = CHI,    PENETRATED MATERIAL UNTIL DECAY OR REACTION
C                (G/CM**2)  CALCULATED IN BOX2
C  CURPAR(10)  = BETA,   V/C, CALCULATED IN BOX2
C  CURPAR(11)  = GCM,    GAMMA  IN CM, CALCULATED IN NUCINT
C  CURPAR(12)  = ECM,    ENERGY IN CM, CALCULATED IN NUCINT

C  CURPAR(14)  = HAPP    APPARENT HEIGHT  IN CARTESIAN COORDINATE SYSTEM
C  CURPAR(15)  = COSTAP  APPARENT ZENITH ANGLE IN CART.COORDINATE SYSTEM
C  CURPAR(16)  = COSTEA  ANGLE PARTICLE TO MID DETECT AT CENTER EARTH

C..SECONDARY PARTICLE
C  SECPAR(..)  = PARTICLE FIELD FOR SECONDARY PARTICLE (COMP. CURPAR)
C  SECPAR(9)   = GENERATION OF PARTICLE
C  SECPAR(10)  = LEVEL OF LAST INTERACTION
C  SECPAR(11)  = POLARIZATION DIRECTION: COS(THETA) FOR MUONS
C  SECPAR(12)  = POLARIZATION DIRECTION: PHI FOR MUONS

C  SECPAR(14)  = APPARENT HEIGHT  IN CARTESIAN COORDINATE SYSTEM
C  SECPAR(15)  = APPARENT ZENITH ANGLE IN CART.COORDINATE SYSTEM
C  SECPAR(16)  = ANGLE PARTICLE TO MID DETECT AT CENTER EARTH

C..PRIMARY PARTICLE
C  PRMPAR(..)  = PARTICLE FIELD FOR PRIMARY PARTICLE (COMP. CURPAR)
C..PARTICLE TO BE WRITTEN TO TAPE
C  OUTPAR(..)  = PARTICLE FIELD FOR OUTPUT PARTICLE (COMP. SECPAR)
C  C(.)        = PHYSICAL CONSTANSTS
C  C(1)        = EARTH'' RADIUS (CM)
C  C(2)        = MAX DISTANCE IN LOCAL COORDINATE SYSTEM AT SEA LEVEL
C  C(3)        = MAX DISTANCE IN LOCAL COORD. SYSTEM AT TOP OF ATMOSPH.
C  C(4)        = CONSTANT FOR MAX DIST IN LOCAL COORD. SYSTEM (SEE START)
C  C(6)        = (MASS OF MUON+/MASS OF KAON+)**2
C  C(7)        = (MASS OF MUON+/MASS OF PION+)**2
C  C(8)        = (PAMA(5)**2 + PAMA(2)**2)/(2*PAMA(5))
C  C(9)        = MAX DISTANCE IN LOCAL COORDINATE SYSTEM (CHIMAX/RHO)
C  C(10)       = CUTOFF LORENTZ FACTOR FOR RECOIL NUCLEON
C  C(11)       = CUTOFF LORENTZ FACTOR FOR RECOIL PION
C  C(12)       = PEAK POSITION FOR PT DISTRIBUTION (IN PTRANS)
C  C(15)       = 1. + (MASS OF ELECTRON/MASS OF MUON)**2 (SEE START)
C  C(16)       = 2. * MASS OF ELECTRON / MASS OF MUON (SEE START)
C  C(21)       = COULOMB SCATTERING LENGTH (G/CM**2)
C  C(22)       = CONSTANT FOR SPECIFIC IONISATION LOSS IN AIR
C  C(23)       = CONSTANT FOR SPECIFIC IONISATION LOSS IN AIR
C  C(24)       = (SPECIFIC IONIS. LOSS IN AIR FOR MIN.ION. PARTICLES)
C  C(25)       = SPEED OF LIGHT (CM/SEC)
C  C(26)       = CUT IN     THETA  FOR ANGLES TO BE ADDED
C  C(27)       = CUT IN COS(THETA) FOR ANGLES TO BE ADDED
C  C(28)       = CUT IN     THETA  FOR ALL PARTICLES, CUTS UPWARD GOING
C  C(29)       = CUT IN COS(THETA) FOR ALL PARTICLES, CUTS UPWARD GOING
C  C(30)       = PARAMETER FOR COULOMB SCATTERING OF MUONS
C  C(34)       = CUTOFF FOR PT IN SUBROUT. PTRANS
C  C(45)       = 2 * PAMA(14) * PAMA(8) INTERNALLY COMPUTED
C  C(46)       = PAMA(14)**2 + PAMA(8)**2 INTERNALLY COMPUTED
C  C(48)       = (PAMA(8)**2 + PAMA(5)**2) /(2.D0*PAMA(8)*PAMA(5))
C  C(49)       = SQRT(C(48)**2 - 1.D0) / C(48) INTERNALLY COMPUTED
C  C(50)       = FINE STRUCTURE CONSTANT
C  E00         = ENERGY OF PRIMARY
C  E00PN       = ENERGY OF PRIMARY PER NUCLEON
C  PTOT0       = TOTAL MOMENTUM OF PRIMARY
C  PTOT0N      = TOTAL MOMENTUM OF PRIMARY PER NUCLEON
C  THICKH      = THICK(H) MASS OVERBURDEN OF ACTUAL PARTICLE ALTITUDE
C  ITYPE       = CURPAR(0)  PARTICLE TYPES ACCORDING TO GEANT
C                IN ADDITION : A*100+Z=HEAVY NUCLEI (FOR PRIMARIES ONLY)
C  LEVL        = LEVEL # OF PARTICLE WRITTEN TO TAPE
C

C --------------/CRPATHCM/------------------------
C  (SEE EGS4 MANUAL)
C
C --------------/CRPHOTIN/------------------------
C  (SEE EGS4 MANUAL)
C
C --------------/CRPION/--------------------------
C  PI0MSQ      = MASS OF PI(0) SQUARED (EGS4)
C  PITHR       = THRESHOLD ENERGY FOR PHOTONUCLEAR INTERACT. (EGS4)
C  PICMAS      = MASS OF CHARGED PION (EGS4)
C  PI0MAS      = MASS OF PI(0) (EGS4)
C  AMASK0      = MASS OF NEUTRAL KAON (EGS4)
C  AMASKC      = MASS OF CHARGED KAON (EGS4)
C  AMASPR      = MASS OF PROTON (EGS4)
C  AMASNT      = MASS OF NEUTRON (EGS4)
C
C --------------/CRPOLAR/------------------------
C  POLART      = COS(THETA) ; POLARIZATION DIRECTION OF MUON
C  POLARF      = PHI        ; POLARIZATION DIRECTION OF MUON
C
C --------------/CRPRIMSP/-----------------------
C  PSLOPE      = SLOPE OF PRIMARY DIFFERENTIAL ENERGY SPECTRUM
C                IF PRIMARY ENERGY IS TO BE COMPUTED FROM A SPECTRUM
C  LLIMIT      = LOWER LIMIT OF ENERGY SECTION FOR PRIMARY (GEV)
C  ULIMIT      = UPPER LIMIT OF ENERGY SECTION FOR PRIMARY (GEV)
C  LL          = USED FOR PRIMARY ENERGY SELECTION
C  UL          = USED FOR PRIMARY ENERGY SELECTION
C  SLEX        = EXPONENT OF SLOPE OF PRIMARY SPECTRUM
C  ISPEC       = 0 FOR FIXED ENERGY   = 1 FOR ENERGY SPECTRUM
C

C --------------/CRQGSC/-------------------------
C  LEVLDQ      = LEVEL OF DEBUG OUTPUT IN CASE OF DEBUGGIUNG
C  IQGSVER     = QGSJET VERSION NUMBER * 10
C  FQGS        = FLAG TO ACTIVATE QGSJET INTERACTION ROUTINES
C  FQGSSG      = FLAG TO ACTIVATE QGSJET CROSS-SECTIONS
C
C --------------/CRQGSDEB/-----------------------
C  E000        = ENERGY/NUCLEON OF PROJECTILE BEFORE COLLISION
C  IRAND(3)    = RANDOM GENERATOR STATUS AT BEGIN OF QGSJET INTERACTION
C  ICPP        = PROJECTILE TYPE
C  IAPP        = NUMBER OF NUCLEONS IN PROJECTILE NUCLEUS
C  IATT        = NUMBER OF NUCLEONS IN TARGET NUCLEUS
C
C --------------/CRQGSLIN/-----------------------
C  ICTABL(..)  = TABLE TO CONVERT PARTICLE TYPE FROM CORSIKA TO QGSJET
C  IQTABL(..)  = TABLE TO CONVERT PARTICLE TYPE FROM QGSJET TO CORSIKA
C
C --------------/CRQGSSGM/-----------------------
C  QFRACN(..)  = TABULATED VALUES OF HADRON 14N CROSS-SECTIONS (QGSJET)
C  QFRANO(..)  = TABUL. VALUES OF HADRON 14N+16O CROSS-SECTIONS (QGSJET)
C  SIGQAIR(..) = TABULATED VALUES OF HADRON AIR CROSS-SECTIONS (QGSJET)
C  SIGQHN(..)  = TABULATED VALUES OF HADR. NUCL.CROSS-SECTIONS (QGSJET)
C

C --------------/CRRANDPA/-----------------------
C  RD(3000)    = ARRAY (DOUBLE PRECISION) FOR RANDOM NUMBERS
C  FAC         = VARIABLE OF SUBROUT. RANNOR
C  U1          = VARIABLE OF SUBROUT. RANNOR
C  U2          = VARIABLE OF SUBROUT. RANNOR
C  NSEQ        = # OF RANDOM GENERATOR SEQUENCE
C  ISEED(.,.)  = RANDOM GENERATOR SEED
C  KNOR        = FLAG TO STEER GENERATION OF NORMAL DISTRIBUTED RANDOMS
C
C --------------/CRRANMA3/-----------------------
C  KSEQ        = PARAMETER DEFINING MAX. NUMBER OF INDEPENDENT SEQUENCES
C  CD          = STARTING NUMBER FOR RANDOM GENERATOR
C  CINT        = STARTING NUMBER FOR RANDOM GENERATOR
C  CM          = STARTING NUMBER FOR RANDOM GENERATOR
C  TWOM24      = 2**-24 (MANTISSA SINGLE PRECISION)
C  TWOM48      = 2**-48 (MANTISSA DOUBLE PRECISION)
C  MODCNS      = MODULUS (NOTOT * MODCNS = NTOT2) FOR RANDOM GENERATOR
C
C --------------/CRRANMA4/-----------------------
C  C()         = ARRAY(KSEQ) FOR RANDOM GENERATOR
C  U()         = ARRAY(97,KSEQ) FOR RANDOM GENERATOR
C  IJKL()      = ARRAY(KSEQ) FOR RANDOM GENERATOR
C  I97()       = ARRAY(KSEQ) FOR RANDOM GENERATOR
C  J97()       = ARRAY(KSEQ) FOR RANDOM GENERATOR
C  NTOT()      = ARRAY(KSEQ) FOR RANDOM GENERATOR
C  NTOT2()     = ARRAY(KSEQ) FOR RANDOM GENERATOR
C  JSEQ        = ACTUAL SEQUENCE NUMBER
C  UNI         = FINAL RANDOM NUMBER
C
C --------------/CRRATIOS/-----------------------
C  RPI0R       = RATIO # PI(0) / # ALL NEUTRAL PARTICLES
C  RPIER       = RATIO # PI(0)+ETA / # ALL NEUTRAL PARTICLES
C  RPEKR       = RATIO # PI(0)+ETA+KA0/ # ALL NEUTRAL PARTICLES
C  RPEKNR      = RATIO # PI(0)+ETA+KA0+NEUTR/ # ALL NEUTRAL PARTICLES
C  PPICH       = RATIO # PI+(+-) / # ALL CHARGED PARTICLES
C  PPINCH      = RATIO # PI+(+-)+PROTON / # ALL CHARGED PARTICLES
C  PPNKCH      = RATIO # PI+(+-)+PROTON+K(+-) / # ALL CHARGED PARTICLES
C  ISEL        = INDICATOR FOR LOW MULTIPLICITY OF SECONDARY PARTICLES
C  NEUTOT      = TOTAL # OF NEUTRAL PARTICLES  IN HDPM
C  NTOTEM      = TOTAL #OF SECONDARY PARTICLES IN HDPM
C
C --------------/CRRECORD/-----------------------
C  IRECOR      = # WORDS WRITTEN ON PARTICLE TAPE RECORDS
C
C --------------/CRREJECT/-----------------------
C  AVNREJ(..)  = AVERAGE NUMBER OF REJECTED ELECTRONS IN EGS
C  ALTMIN(..)  = MINIMUM ALTITUDE FOR REJECTION OF ELECTRONS AT OBS.LEVL
C  ANEXP(..)   = AVERAGE NUMBER OF ELECTRONS TO BE EXPECTED AT OBS.LEVEL
C  THICKA(..)  = THICKNESS OF AIR LAYER
C  THICKD(..)  = THICKNESS OF AIR LAYER BELOW OBSERVATION LEVEL
C  CUTLN       = LOGARITHM OF CUTTING ENERGY FOR REJECT IN EGS
C  EONCUT      = CUTTING ENERGY (IN MEV) FOR REJECT IN EGS
C  FNPRIM      = FLAG INDICATING THE PRIMARY PARTICLE IN EGS
C
C --------------/CRRESON/------------------------
C  RDRES(2)    = RANDOM NUMBERS FOR RESONANCE DECAYS
C  RESRAN(.)   = RANDOM NUMBERS FOR RESONANCE DECAYS
C  IRESPAR     = POINTER FOR ARRAY RESRAN
C
C --------------/CRREST/-------------------------
C  CONTNE(3)   = FRACTION OF NEUTRONS IN TARGET LT
C  TAR         = NUMBER OF NUCLEONS IN TARGET
C  LT          = INDEX FOR INTERACTING TARGET (1=N, 2=O, 3=AR)
C

C --------------/CRRTABLE/-----------------------
C  MHEIGH      = PARAMETER NUMBER OF VALUES IN HEIGHT
C  NTHETA      = PARAMETER NUMBER OF VALUES IN THETA
C
C  DISTEF(.,.) = CHANGE OF CORE DISTANCE FOR CHERENKOV PHOTON
C  TOF(.,.)    = TIME OF FLIGHT OF CHERENKOV PHOTON
C

C --------------/CRRUNPAR/-----------------------
C  FIXHEI      = HEIGHT OF FIRST INTERACTION IF TAKEN FIXED (CM)
C  THICK0      = HEIGHT OF START OF PRIMARY (IN G/CM**2)
C  HILOECM     = ENERGY THRESHOLD FOR HIGH ENERGY MODEL IN CM
C  HILOELB     = ENERGY THRESHOLD FOR HIGH ENERGY MODEL IN LAB
C  SIG1I       = CROSS-SECTION FOR FIRST INTERACTION
C  TARG1I      = TARGET OF FIRST INTERACTION
C  STEPFC      = STEP LENGTH FACTOR FOR ELECTRON MULTIPLE SCATTERING

C  NRRUN       = # OF RUN
C  NSHOW       = # OF SHOWERS TO GENERATE
C  MPATAP      = LUN OF DATASET FOR PARTICLE OUTPUT
C  MONIIN      = LUN OF CARD READER
C  MONIOU      = LUN OF LINE PRINTER
C  MDEBUG      = LUN OF DEBUG OUTPUT
C  NUCNUC      = LUN OF CROSS-SECTION FILE
C  MTABOUT     = LUN OF TABLE OUTPUT FOR CHARGED PARTICLES
C  MLONGOUT    = LUN OF LONGITUDINAL TABLE OUTPUT

C  MCETAP      = LUN OF DATASET FOR CHERENKOV PHOTONS OUTPUT
C  ISHOWNO     = # OF ACTUAL SHOWER
C  ISHW        = INDEX OF SHOWER LOOP
C  NOPART      = COUNTER FOR PARTICLES WRITTEN TO TAPE
C  NRECS       = # OF BIG   BLOCKS PUT OUT (FOR TP)
C  NBLKS       = # OF SMALL BLOCKS PUT OUT (FOR TP)
C  MAXPRT      = MAXIMUM NUMBER OF EVENTS TO BE PRINTED
C  NDEBDL      = NUMBER OF MAPPED PARTICLE THAT ACTIVATES DELAYED DEBUG
C  N1STTR      = NUMBER OF FIXED FIRST TARGET 0=RANDOM, 1=N, 2=O, 3=AR
C  MDBASE      = LUN OF DATABASE FILE

C  NPLEM       = NUMBER OF TRACKS OF EM PARTICLES FOR PLOT
C  NPLMU       = NUMBER OF TRACKS OF MUONS        FOR PLOT
C  NPLHAD      = NUMBER OF TRACKS OF HADRONS      FOR PLOT

C  DEBDEL      = FLAG TO STEER DELAYED ACTIVATION OF DEBUG
C  DEBUG       = FLAG TO STEER PRINTOUT FOR DEBUGGING
C  FDECAY      = FLAG INDICATING PARTICLE UNDERGOES DECAY
C  FEGS        = FLAG FOR USE OF EGS4
C  FIRSTI      = FLAG INDICATING FIRST INTERACTION IN HDPM
C  FIXINC      = FLAG TO KEEP ANGLES OF INCIDENCE FIXED
C  FIXTAR      = FLAG TO INDICATE FIXED TARGET FOR FIRST INTERACTION
C  FIX1I       = FLAG TO KEEP HEIGHT OF FIRST INTERACTION FIXED
C  FMUADD      = FLAG TO INDICATE ADDITIONAL MUON OUTPUT ON MPATAP
C  FNKG        = FLAG FOR USE OF NKG FORMULAS
C  FPRINT      = LOGICAL VARIABLE TO STEER PRINTING
C  FDBASE      = FLAG FOR WRITING SUMMARY FILE FOR DATABASE
C  FPAROUT     = FLAG INDICATING PARTICLE OUTPUT
C  FTABOUT     = FLAG INDICATING TABLE OUTPUT
C  FLONGOUT    = FLAG INDICATING LONGITUDINAL OUTPUT
C  GHEISH      = FLAG TO ACTIVATE GHEISHA ROUTINES
C  GHESIG      = FLAG TO INDICATE THAT GHEISHA CROSS-SECTION IS USED
C  GHEISDB     = FLAG TO ACTIVATE GHEISHA DEBUG OUTPUT
C  USELOW      = FLAG INDICATING LOW ENERGY HADRONIC INTERACTION
C  TMARGIN     = FLAG INDICATING ARR. TIME ZERO AT ENTRANCE INTO ATMOSPHERE

C  FFLUDB      = FLAG INDICATING DEBUG OF FLUKA
C  FFLUKA      = FLAG INDICATING USE OF FLUKA
C  FFLUSIG     = FLAG INDICATING THAT FLUKA SIGMA IS AVAILABLE
C  PLOTSH      = FLAG TO ENABLE/DISABLE PRODUCTION OF FILES FOR PLOTS

C --------------/CRRUNPAC/-----------------------
C  DSN         = DATA SET NAME OF PARTICLE OUTPUT
C  DSNTAB      = DATA SET NAME OF TABLE OUTPUT
C  DSNLONG     = DATA SET NAME OF LONGITUDINAL OUTPUT
C  HOST        = NAME OF HOST COMPUTER IN USE
C  USER        = NAME OF USER

C  LSTDSN      = DATA SET NAME OF LIST OUTPUT

C  DSNFLOUT    = DATA SET NAME OF FLUKA LIST OUTPUT
C  DSNFLERR    = DATA SET NAME OF FLUKA ERROR OUTPUT
C  CPLOT       = DATA SET NAME OF OUTPUT FILES FOR PLOTSH

C
C --------------/CRSIGM/-------------------------
C  SIGMA       = INELASTIC CROSS-SECTION FOR HADRON NUCLEON COLLISION
C  SIGANN      = NUCLEON ANNIHILATION CROSS-SECTION
C  SIGAIR      = INELASTIC CROSS-SECTION IN AIR
C  FRACTN      = NITROGEN FACTION OF INELASTIC AIR CROSS-SECTION
C  FRCTNO      = NITROGEN+OXYGEN FACTION OF INELASTIC AIR CROSS-SECTION
C
C --------------/CRSIGMU/-------------------------
C  BREMSTAB    = TABLE OF MUON BREMSSTRAHLUNG CROSS-SECTIONS
C  NUCTAB      = TABLE OF MUON NUCLEAR INTERACTION CROSS-SECTIONS
C  PAIRTAB     = TABLE OF MUON PAIR PRODUCTION CROSS-SECTIONS
C  DEDXMU      = TABLE OF MUON ENEGY LOSS IN DIFFERENT MATERIALS
C  DEDXM       = TABLE OF MUON ENEGY LOSS IN AIR
C
C --------------/CRSTACKE/-----------------------
C  E(NP)       = ENERGY OF PARTICLE ON EGS STACK
C  TIM(NP)     = TIME OF PARTICLE ON EGS STACK
C  U(NP)       = X DIRECTION COSINE OF PARTICLE ON EGS STACK
C  V(NP)       = Y DIRECTION COSINE OF PARTICLE ON EGS STACK
C  W(NP)       = Z DIRECTION COSINE OF PARTICLE ON EGS STACK
C  X(NP)       = X COORDINATE OF PARTICLE ON EGS STACK
C  Y(NP)       = Y COORDINATE OF PARTICLE ON EGS STACK
C  Z(NP)       = Z COORDINATE OF PARTICLE ON EGS STACK
C  DNEAR       = DISTANCE TO NEXT LAYER BOUNDARY OF PART. ON EGS STACK

C  ZAP(NP)     = APPARENT HEIGHT IN CARTESIAN COORDINATE SYSTEM (EGS)
C  WAP(NP)     = APPARENT ZENITH ANGLE IN CART.COORDINATE SYSTEM (EGS)
C  WA(NP)      = ANGLE PARTICLE TO MID DETECT AT CENTER EARTH (EGS)

C  IQ(NP)      = PARTICLE IDENTIFIER (EGS)
C  IGEN(NP)    = GENERATION COUNTER OF PARTICLE ON EGS STACK
C  IR(NP)      = ACTUAL ATMOSPHERIC LAYER OF PARTICLE ON EGS STACK
C  IOBS(NP)    = # OF NEXT OBSERVATION LEVEL FOR PARTICLE ON EGS STACK
C  LPCTE(NP)   = INDEX OF LONGITUDINAL LAYER FOR PARTICLE ON EGS STACK
C  NP          = STACK POINTER OF PARTICLE ON EGS STACK
C
C --------------/CRSTACKF/-----------------------
C  MAXSTK      = PARAMETER FOR MAXIMAL STACK SIZE

C  STACKI(MAXSTK)=PARTICLE STACK FOR 2 * 256 PARTICLES A 17 WORDS
C  MSTACKP     = STACK POINTER
C  MEXST       = LUN OF SCRATCH DSN FOR EXTERNAL STACK
C  NSHIFT      = # OF STACK SHIFTS
C  NOUREC      = # OF OUTPUT RECORDS
C  ICOUNT      = POSITION OF PARTICLE WITHIN STACK
C  NTO         = # OF PARTICLES WRITTEN TO STACK
C  NFROM       = # OF PARTICLES READ FROM STACK
C
C --------------/CRSTATI/-------------------------
C  SABIN(40)   = LOW  EDGE OF KIN. ENERGY FOR INTERACTION-ENERGY TABLE
C  SBBIN(40)   = HIGH EDGE OF KIN. ENERGY FOR INTERACTION-ENERGY TABLE
C  INBIN(40)   = COUNTER FOR NUCLEON TABLE FOR SHOWER
C  IPBIN(40)   = COUNTER FOR PION TABLE FOR SHOWER
C  IKBIN(40)   = COUNTER FOR KAON TABLE FOR SHOWER
C  IHBIN(40)   = COUNTER FOR STRANGE BARYON TABLE FOR SHOWER
C
C --------------/CRSTRBAR/-----------------------
C  CSTRBA(5)   = BRANCHING RATIO FOR DECAY OF LAMDA
C  CSTRBA(6)   = BRANCHING RATIO FOR DECAY OF SIGMA(+)
C  CSTRBA(10)  = BRANCHING RATIO FOR DECAY OF OMEGA(-)
C  CSTRBA(11)  = BRANCHING RATIO FOR DECAY OF OMEGA(-)
C
C --------------/CRTABLES/-----------------------
C  IEBIN       = PARAMETER # OF ENERGY BINS
C  ITBIN       = PARAMETER # OF ARRIVAL TIME BINS
C  IDBIN       = PARAMETER # OF DISTANCE BINS
C  G_ARRAY     = ARRAY FOR GAMMAS IN BINS IN ENERGY, TIME, CORE DISTANCE
C  E_ARRAY     = ARRAY FOR ELECTRONS IN BINS IN ENERGY, TIME, CORE DIST.
C  M_ARRAY     = ARRAY FOR MUONS IN BINS IN ENERGY, TIME, CORE DISTANCE
C  EBOFF       = ENERGY       OFFSET         FOR BINNING
C  EBFAC       = ENERGY       SCALING FACTOR FOR BINNING
C  TBOFF       = ARRIVAL TIME OFFSET         FOR BINNING
C  TBFAC       = ARRIVAL TIME SCALING FACTOR FOR BINNING
C  DBOFF       = DISTSANCE    OFFSET         FOR BINNING
C  DBFAC       = DISTSANCE    SCALING FACTOR FOR BINNING
C  EBMIN       = PARAMETER: MINIMUM ENERGY FOR ENERGY TABLE
C  EBMAX       = PARAMETER: MAXIMUM ENERGY FOR ENERGY TABLE
C  TBMIN       = PARAMETER: MINIMUM ARRIVAL TIME FOR TIME TABLE
C  TBMAX       = PARAMETER: MAXIMUM ARRIVAL TIME FOR TIME TABLE
C  DBMIN       = PARAMETER: MINIMUM DISTANCE FOR DISTANCE TABLE
C  DBMAX       = PARAMETER: MAXIMUM DISTANCE FOR DISTANCE TABLE
C
C --------------/CRTHNVAR/-----------------------
C  MAXICOUNT   = PARAMETER FOR MAXIMAL INTERMEDIATE STACK SIZE
C  STACKINT(,) = INTERMEDIATE STACK OF PARTICLE COORDINATES
C  INT_ICOUNT  = POINTER FOR INTERMEDIATE PARTICLE STACK
C  MODETHN     = MODE FOR READING IN THIN VARIABLES
C  THINNING    = FLAG INDICATING THINNING FOR CURRENT INTERACTION

C
C --------------/CRTHRESH/-----------------------
C  (SEE EGS4 MANUAL)
C

C --------------/CRTIMLIM/-----------------------
C  DSTLIM      = DISTANCE LIMIT (DOWNSTREAM DETECTOR) FOR TIME LIMIT
C  TIMLIM      = TIME LIMIT FOR PARTICLE SINCE 1. INTERACT (SEC)
C
C --------------/CRUSEFUL/-----------------------
C  (SEE EGS4 MANUAL)
C
C --------------/CRVERS/-------------------------
C  VERNUM      = VERSION NUMBER OF CORSIKA
C  MVDATE      = DATE OF VERSION AS INTEGER (YYYYMMDD)
C  VERDAT(.)   = DATE OF RELEASE OF VERSION
C
C --------------/CRVKIN/-------------------------
C  BETACM      = BETA IN CENTER OF MASS
C
C --------------/CRWGHTMA/-----------------------
C  MWGHMA(,)   = WEIGHT MATRIX OF SINGLE SHOWER
C  MWGHTOT(,)  = TOTALIZED WEIGHT MATRIX OF ALL SHOWERS
C

C=======================================================================
C
C  DESCRIPTION OF GLOBAL VARIABLES USED IN THE COMMONS OF THE PROGRAM
C  ==================================================================
C  (IN ALPHABETIC ORDER OF THE VARIABLE NAMES)
C
C  AATM(5)     = ACTUAL COEFFICIENTS FOR PARAMETRIZATION OF ATMOSPHERE
C  AATM0(5,..) = COEFFICIENTS FOR PARAMETRIZATION OF ATMOSPHERE
C  AATOM       = NUCLEONS IN TARGET FOR MUON INTERACTIONS

C  ACERX       = CHERENKOV DETECTOR SIZE IN X DIRECTION IN CM
C  ACERY       = CHERENKOV DETECTOR SIZE IN Y DIRECTION IN CM

C  ACOMP       = ATOMIC WEIGHT OF COMPONENT (GHEISHA)
C  ADLONG(I,K) = AVERAGE OF DLONG OVER ALL SHOWERS
C  AELONG(I,K) = AVERAGE OF ELONG OVER ALL SHOWERS
C  ALEVEL      = LEVEL OF LAST HADRONIC INTERACTION
C  ALTMIN(..)  = MINIMUM ALTITUDE FOR REJECTION OF ELECTRONS AT OBS.LEVL
C  AMUPAR(0:16)= REGISTER FOR MUON PARTICLE ADDITIONAL INFO
C  ANEXP(..)   = AVERAGE NUMBER OF ELECTRONS TO BE EXPECTED AT OBS.LEVEL
C  APLONG(I,K) = AVERAGE OF PLONG OVER ALL SHOWERS
C  ARRANG      = ANGLE (DEG) ARRAY X-DIRECTION AND MAGNETIC NORD
C  ARRANR      = ANGLE (RAD) ARRAY X-DIRECTION AND MAGNETIC NORD
C  ARRAYLONG( )= BUFFER FOR LONGITUDINAL PARTICLE DISTRIBUTION

C  AVCH        = AVERAGE # OF CHARGED PARTICLES IN HDPM
C  AVCH3       = AVERAGE # OF CHARGED PARTICLES IN 3RD STRING IN HDPM
C  AVERAW      = AVERAGE ATOMIC WEIGHT OF AIR
C  AVNREJ(..)  = AVERAGE NUMBER OF REJECTED ELECTRONS IN EGS
C  AVOGDR      = AVOGADROS NUMBER * MILLIBARN/CM**2
C  AVPE        = AVERAGE TRANSVERSE MOMENTUM FOR ETAS
C  AVPH        = AVERAGE TRANSVERSE MOMENTUM FOR STRANGE BARYONS
C  AVPK        = AVERAGE TRANSVERSE MOMENTUM FOR KAONS
C  AVPN        = AVERAGE TRANSVERSE MOMENTUM FOR NUCLEONS
C  AVPT        = AVERAGE TRANSVERSE MOMENTUM FOR PIONS
C
C  BETA2       = VELOCITY OF ELECTRON SQUARED
C  BATM(5)     = ACTUAL COEFFICIENTS FOR PARAMETRIZATION OF ATMOSPHERE
C  BATM0(5,..) = COEFFICIENTS FOR PARAMETRIZATION OF ATMOSPHERE
C  BCUT        = CUT-OFF ENERGY FOR MUON BREMSSTRAHLUNG

C  BETA        = CURPAR(10)
C  BETACM      = BETA IN CENTER OF MASS
C  BLIMIT      = LIMIT FACTOR FOR STEP SIZE OF ELECTRONS IN MAGN.FIELD
C  BNORM       = MAGNETIC DEFLECTION CONSTANT [MEV/CM]
C  BNORMC      = MAGNETIC DEFLECTION CONSTANT [GEV/CM]
C  BOUND       = BOUNDARIES OF ATMOSPHERIC LAYERS (EGS4)
C  BREMSTAB    = TABLE OF MUON BREMSSTRAHLUNG CROSS-SECTIONS
C  BVAL        = SQUARED MAGNET FIELD STRENGTH
C  BX          = MAGNET FIELD STRENGTH COMPONENT TO NORTH [MICROTESLA]
C  BZ          = MAGNET FIELD STRENGTH COMPONENT DOWNWARD [MICROTESLA]
C
C  C(.)  PHYSICAL CONSTANSTS
C  C(1)        = EARTH'' RADIUS (CM)
C  C(2)        = MAX DISTANCE IN LOCAL COORDINATE SYSTEM AT SEA LEVEL
C  C(3)        = MAX DISTANCE IN LOCAL COORD. SYSTEM AT TOP OF ATMOSPH.
C  C(4)        = CONSTANT FOR MAX DIST IN LOCAL COORD. SYSTEM (SEE START)
C  C(6)        = (MASS OF MUON+/MASS OF KAON+)**2
C  C(7)        = (MASS OF MUON+/MASS OF PION+)**2
C  C(8)        = (PAMA(5)**2 + PAMA(2)**2)/(2*PAMA(5))
C  C(9)        = MAX DISTANCE IN LOCAL COORDINATE SYSTEM (CHIMAX/RHO)
C  C(10)       = CUTOFF LORENTZ FACTOR FOR RECOIL NUCLEON
C  C(11)       = CUTOFF LORENTZ FACTOR FOR RECOIL PION
C  C(12)       = PEAK POSITION FOR PT DISTRIBUTION (IN PTRANS)
C  C(15)       = 1. + (MASS OF ELECTRON/MASS OF MUON)**2 (SEE START)
C  C(16)       = 2. * MASS OF ELECTRON / MASS OF MUON (SEE START)
C  C(21)       = COULOMB SCATTERING LENGTH (G/CM**2)
C  C(22)       = CONSTANT FOR SPECIFIC IONISATION LOSS IN AIR
C  C(23)       = CONSTANT FOR SPECIFIC IONISATION LOSS IN AIR
C  C(24)       = (SPECIFIC IONIS. LOSS IN AIR FOR MIN.ION. PARTICLES)
C  C(25)       = SPEED OF LIGHT (CM/SEC)
C  C(26)       = CUT IN     THETA  FOR ANGLES TO BE ADDED
C  C(27)       = CUT IN COS(THETA) FOR ANGLES TO BE ADDED
C  C(28)       = CUT IN     THETA  FOR ALL PARTICLES, CUTS UPWARD GOING
C  C(29)       = CUT IN COS(THETA) FOR ALL PARTICLES, CUTS UPWARD GOING
C  C(30)       = PARAMETER FOR COULOMB SCATTERING OF MUONS
C  C(34)       = CUTOFF FOR PT IN SUBROUT. PTRANS
C  C(35)       = MEAN FOR PION LONG. MOMENTUM COMING FROM FORW. ISOBAR
C  C(36)       = MEAN FOR PION LONG. MOMENTUM COMING FROM FORW. ISOBAR
C  C(45)       = 2 * PAMA(14) * PAMA(8) INTERNALLY COMPUTED
C  C(46)       = PAMA(14)**2 + PAMA(8)**2 INTERNALLY COMPUTED
C  C(48)       = (PAMA(8)**2 + PAMA(5)**2) /(2.D0*PAMA(8)*PAMA(5))
C  C(49)       = SQRT(C(48)**2 - 1.D0) / C(48) INTERNALLY COMPUTED
C  C(50)       = FINE STRUCTURE CONSTANT
C  C()         = ARRAY(KSEQ) FOR RANDOM GENERATOR

C  CARTIM      = ARRIVAL TIME OF CHERENKOV PHOTONS

C  CATM(5)     = ACTUAL COEFFICIENTS FOR PARAMETRIZATION OF ATMOSPHERE
C  CATM0(5,..) = COEFFICIENTS FOR PARAMETRIZATION OF ATMOSPHERE

C  CD          = STARTING NUMBER FOR RANDOM GENERATOR

C  CERCNT      = CHERENKOV PHOTON COUNTER
C  CERELE      = CHERENKOV PHOTONS FROM ELECTRONS
C  CERHAD      = CHERENKOV PHOTONS FROM HADRONS
C  CERNOR      = NORMALISATION FACTOR FOR CALC. OF WAVELENGTH OF C-PHOTONS

C  CERSIZ      = MAXIMAL NUMBER OF PHOTONS IN ONE BUNCH
C  CERXOS(I)   = X OFFSETS OF SHOWER CORE FOR THE MULTIPLE EVENTS IN CM
C  CERYOS(I)   = Y OFFSETS OF SHOWER CORE FOR THE MULTIPLE EVENTS IN CM

C  CETA(1)     = BRANCHING RATIO FOR ETA DECAY
C  CETA(2)     = BRANCHING RATIO FOR ETA DECAY
C  CETA(3)     = BRANCHING RATIO FOR ETA DECAY
C  CETA(4)     = ASYMMETRY TERM    IN DECAY  ETA-->PI(+) + PI(-) + PI(0)
C  CETA(5)     = MAXIMUM AMPLITUDE IN DECAY  ETA-->PI(+) + PI(-) + PI(0)
C  CHAPAR      = ARRAY OF PARTICLE NUMBERS FOR LONGIT. DISTRIBUTION
C  CHC         = CONSTANT CHI_C   FOR MUOMN MULTIPLE SCATTERING
C  CHI         = CURPAR(9)
C  CINT        =STARTING NUMBER FOR RANDOM GENERATOR
C  CKA(.)  PHYSICAL CONSTANTS FOR KAONS
C  CKA(2)      = MEAN FOR KAON LONG. MOMENTUM COMING FROM VHMESO
C  CKA(23)     = BRANCH RATIO K(+,-) DECAY
C  CKA(24)     = BRANCH RATIO K0S DECAY
C  CKA(25)     = BRANCH RATIO K0L DECAY
C  CKA(26)     = BRANCH RATIO K0L DECAY
C  CKA(27)     = BRANCH RATIO K0L DECAY
C  CKA(47)     = BRANCH RATIO K(+,-) DECAY
C  CKA(48)     = BRANCH RATIO K(+,-) DECAY
C  CKA(49)     = BRANCH RATIO K(+,-) DECAY
C  CKA(50)     = BRANCH RATIO K(+,-) DECAY
C  CKA(51)     = G     OF K+,- ===> PI+,- + PI+,- + PI-,+
C  CKA(52)     = H     OF K+,- ===> PI+,- + PI+,- + PI-,+
C  CKA(53)     = K     OF K+,- ===> PI+,- + PI+,- + PI-,+
C  CKA(54)     = AMPMX OF K+,- ===> PI+,- + PI+,- + PI-,+
C  CKA(55)     = G     OF K+,- ===> PI0 + PI0 + PI+,-
C  CKA(56)     = H     OF K+,- ===> PI0 + PI0 + PI+,-
C  CKA(57)     = K     OF K+,- ===> PI0 + PI0 + PI+,-
C  CKA(58)     = AMPMX OF K+,- ===> PI0 + PI0 + PI+,-
C  CKA(59)     = G,H,K OF K0L ===> PI0 + PI0 + PI0
C  CKA(60)     = AMPMX OF K0L ===> PI0 + PI0 + PI0
C  CKA(61)     = G     OF K0L ===> PI+ + PI- + PI0
C  CKA(62)     = H     OF K0L ===> PI+ + PI- + PI0
C  CKA(63)     = K     OF K0L ===> PI+ + PI- + PI0
C  CKA(64)     = AMPMX OF K0L ===> PI+ + PI- + PI0
C  CKA(65)     = LAMBDA-PLUS OF K+,- ===> PI0 + E + NU
C  CKA(66)     = LAMBDA-ZERO OF K+,- ===> PI0 + E + NU
C  CKA(67)     = AMPMX       OF K+,- ===> PI0 + E + NU
C  CKA(68)     = LAMBDA-PLUS OF K+,- ===> PI0 + MU + NU
C  CKA(69)     = LAMBDA-ZERO OF K+,- ===> PI0 + MU + NU
C  CKA(70)     = AMPMX       OF K+,- ===> PI0 + MU + NU
C  CKA(71)     = LAMBDA-PLUS OF K0L ===> PI + E + NU
C  CKA(72)     = LAMBDA-ZERO OF K0L ===> PI + E + NU
C  CKA(73)     = AMPMX       OF K0L ===> PI + E + NU
C  CKA(74)     = LAMBDA-PLUS OF K0L ===> PI + MU + NU
C  CKA(75)     = LAMBDA-ZERO OF K0L ===> PI + MU + NU
C  CKA(76)     = AMPMX       OF K0L ===> PI + MU + NU
C  CM          =STARTING NUMBER FOR RANDOM GENERATOR
C  CMUON(11)   = CONSTANTS FOR MUON BREMSSTRAHLUNG CALCULATION

C  COMPOS(3)   = COMPOSITION OF AIR, ATOMIC FRACTIONS OF N, O, AR
C  CONSTKINE   = KINEMATIC CONSTANT FOR MUON INTERACTIONS
C  CONTNE(3)   = FRACTION OF NEUTRONS IN TARGET LT
C  COSANG      = COSINE OF ARRANR

C  COSTAP      = CURPAR(15) APPARENT ZENITH ANGLE IN CART.COORD. SYSTEM
C  COSTEA      = CURPAR(16) ANGLE PARTICLE TO MID DETECTOR AT CENTER EARTH

C  COSTHE      = CURPAR(2)
C  COSB        = COS OF INCLINATION ANGLE MAGNETIC FIELD
C  COS345(3)   = COSINE THETA OF PARTICLE EMERGING FROM 3 BODY DECAY
C  CPHISCT     = COSINE OF AZIMUTAL ANGLE OF MUON MULTIPLE SCATTERING
C  CPHI345(3)  = COSINE PHI   OF PARTICLE EMERGING FROM 3 BODY DECAY

C  CPLOT       = DATA SET NAME OF OUTPUT FILES FOR PLOTSH

C  CSTRBA(5)   = BRANCHING RATIO FOR DECAY OF LAMDA
C  CSTRBA(6)   = BRANCHING RATIO FOR DECAY OF SIGMA(+)
C  CSTRBA(10)  = BRANCHING RATIO FOR DECAY OF OMEGA(-)
C  CSTRBA(11)  = BRANCHING RATIO FOR DECAY OF OMEGA(-)
C  CTH         = COSINE OF PRIMARY FOR PLANE NORMAL TO SHOWER AXIS
C..CURRENT PARTICLE AND EQUIVALENCED QUANTITIES
C  CURPAR(0)   = PARTICLE TYPE
C  CURPAR(1)   = GAMMA,  LORENTZ FACTOR IN LAB
C  CURPAR(2)   = COSTHE, DIRECTION COSINE Z-DIRECTION
C  CURPAR(3)   = PHIX,   DIRECTION COSINE X-DIRECTION
C  CURPAR(4)   = PHIY,   DIRECTION COSINE Y-DIRECTION
C  CURPAR(5)   = H,      HEIGHT
C  CURPAR(6)   = T,      ACCUMULATED TIME IN SEC
C  CURPAR(7)   = X,      X-POSITION
C  CURPAR(8)   = Y,      Y-POSITION
C  CURPAR(9)   = CHI,    PENETRATED MATERIAL UNTIL DECAY OR REACTION
C                (G/CM**2)  CALCULATED IN BOX2
C  CURPAR(10)  = BETA    V/C, CALCULATED IN BOX2
C  CURPAR(11)  = GCM     GAMMA  IN CM, CALCULATED IN NUCINT
C  CURPAR(12)  = ECM     ENERGY IN CM, CALCULATED IN NUCINT

C  CURPAR(14)  = HAPP    APPARENT HEIGHT  IN CARTESIAN COORDINATE SYSTEM
C  CURPAR(15)  = COSTAP  APPARENT ZENITH ANGLE IN CART.COORDINATE SYSTEM
C  CURPAR(16)  = COSTEA  ANGLE PARTICLE TO MID DETECTOR AT CENTER EARTH

C  CUTLN       = LOGARITHM OF CUTTING ENERGY FOR REJECT IN EGS

C  CYIELD      = CHERENKOV YIELD FACTOR

C  CZX(.)      = LATERAL DIST. OF ELECTRONDENSITY IN X (NKG) (/CM**2)
C  CZY(.)      = LATERAL DIST. OF ELECTRONDENSITY IN Y (NKG) (/CM**2)
C  CZXY(.)     = LATERAL DIST. OF ELECTRONDENSITY IN XY (NKG) (/CM**2)
C  CZYX(.)     = LATERAL DIST. OF ELECTRONDENSITY IN YX (NKG) (/CM**2)
C
C  DATAB(MAXBUF)= BUFFER FOR DATA

C  DATAB2(273) = BUFFER FOR DATA FOR CHERENKOV OUTPUT

C  DATM(5)     = 1. / CATM(I) ACT. COEFFICIENT FOR PARAM. OF ATMOSPHERE
C  DBFAC       = DISTSANCE    SCALING FACTOR FOR BINNING
C  DBMAX       = MAXIMUM DISTANCE FOR DISTANCE TABLE
C  DBMIN       = MINIMUM DISTANCE FOR DISTANCE TABLE
C  DBOFF       = DISTSANCE    OFFSET         FOR BINNING

C  DCERX       = GRID SPACING IN X DIRECTION IN CM
C  DCERY       = GRID SPACING IN Y DIRECTION IN CM
C  DCERXI      = INVERSE OF GRID SPACING IN X DIRECTION
C  DCERYI      = INVERSE OF GRID SPACING IN Y DIRECTION

C  DC0         = AVERAGE DENSITY AT CENTRE OF RAPIDITY (HDPM)
C  DEBDEL      = FLAG TO STEER DELAYED ACTIVATION OF DEBUG
C  DEBUG       = FLAG TO STEER PRINTOUT FOR DEBUGGING
C  DECTIM(...) = LIFE TIME AT REST OF UNSTABLE PARTICLES
C  DEDXMU      = TABLE OF MUON ENEGY LOSS IN DIFFERENT MATERIALS
C  DEDXM       = TABLE OF MUON ENEGY LOSS IN AIR
C  DEP         = ARRAY OF DEPTH VALUES FOR LONGITUDINAL DISTRIBUTION

C  DETSYS      = FLAG FOR DETECTOR FRAME(TRUE, IF WE ARE ALREADY IN DS)
C  DISTEF(.,.) = CHANGE OF CORE DISTANCE FOR CHERENKOV PHOTON

C  DIAG        = DISTANCE BETWEEN STARTING POINT AND MIDDLE OF DETECTOR

C  DIST(10)    = DISTANCES FROM CORE IN CM (USED BY AVAGE)  (NKG)
C  DISX(.)     = DISTANCES OF BINS FOR RADIAL DISTRIBUTION IN X  (IN CM)
C  DISXY(.)    = DISTANCES OF BINS FOR RADIAL DISTRIBUTION IN XY (IN CM)
C  DISY(.)     = DISTANCES OF BINS FOR RADIAL DISTRIBUTION IN Y  (IN CM)
C  DISYX(.)    = DISTANCES OF BINS FOR RADIAL DISTRIBUTION IN YX (IN CM)
C  DLAX(.)     = USED FOR AVERAGING OF CZX
C  DLAXY(.)    = USED FOR AVERAGING OF CZXY
C  DLAY(.)     = USED FOR AVERAGING OF CZY
C  DLAYX(.)    = USED FOR AVERAGING OF CZYX
C  DLOG        = LOG OF DIFFRACTIVE MASS SQUARED  (HDPM)
C  DLONG(I,K)  = LONGITUDINAL ENERGY DEPOSITS PER SHOWER IN I BINS FOR
C                1=ABSORBED GAMMAS, 2=EM-IONIZATION, 3=E-CUTTED EM,
C                4=MU-& MU+ IONOZATION, 5= E-CUTTED MUONS,
C                6=HADRON IONIZATION, 7=E-CUTTED HADRONS, 8=NEUTRINO,
C                9=SUM OF DEPOSITS, 10=DUMMY,
C                11=ANGL. CUTTED GAMMAS, 12=DUMMY, 13=ANGL. CUTTED EM,
C                14=DUMMY, 15=ANGL. CUTTED MUONS, 16=DUMMY,
C                17=ANGL. CUTTED HADRONS, 18=ANGL. CUTTED NEUTRINOS,
C                19=DUMMY
C  DMLOG       = LOG(ECMDIF**2 - MASS PI(0)**2 - MASS DIFFR.PART.**2)
C  DNEAR(NP)   = DISTANCE TO NEXT LAYER BOUNDARY OF PART. ON EGS STACK
C  DSN(.)      = DATA SET NAME OF PARTICLE OUTPUT

C  DSNFLERR    = DATA SET NAME OF FLUKA ERROR OUTPUT
C  DSNFLOUT    = DATA SET NAME OF FLUKA LIST OUTPUT

C  DSNLONG     = DATA SET NAME OF LONGITUDINAL OUTPUT
C  DSNTAB      = DATA SET NAME OF TABLE OUTPUT

C  DSTLIM      = DISTANCE LIMIT (DOWNSTREAM DETECTOR) FOR TIME LIMIT

C
C  E(NP)       = ENERGY OF PARTICLE ON EGS STACK
C  EA(3000)    = ENERGY OF SECONDARY PARTICLE IN HDPM
C  EBFAC       = ENERGY       SCALING FACTOR FOR BINNING
C  EBMAX       = MAXIMUM ENERGY FOR ENERGY TABLE
C  EBMIN       = MINIMUM ENERGY FOR ENERGY TABLE
C  EBOFF       = ENERGY       OFFSET         FOR BINNING
C  EBYMU       = MASS RATION ELECT. MASS / MUON MASS
C  ECM         = CURPAR(12)

C  ECMDIF      = DIFFRACTIVE MASS FOR HDPM
C  ECMDPM      = C.M. ENERGY FOR HDPM
C  ECTMAP      = CUT TO PRINT OUT PARTICLES
C  EDEP        = ENERGY DEPOSITED ALONG STEP
C  EE          = TOTAL ENERGY OF MUON FOR INTERACTIONS

C  EKE         = KINETIC ENERGY OF ELECTRON
C  EKINL       = ENERGY FOR ENERGY-MULTIPLICITY MATRIX
C  ELAB        = LAB ENERGY OF INCOMING PARTICLE IN SDPM/HDPM
C  ELAST       = ELASTICITY OF FIRST REACTION
C  ELCUT(.)    = CUT ON KINETIC ENERGY OF PARTICLES
C  ELEFT       = SUMMED ENERGY OF PARTICLES ON STACK

C  ELKE        = LOGARITHM OF ELECTRON KINETIC ENERGY
C  ELMEAA(.)   = MEAN ELASTICITY FOR ENERGY BINS FOR ALL SHOWERS
C  ELMEAN(.)   = MEAN ELASTICITY FOR ENERGY BINS PER SHOWER
C  ELONG(I,K)  = LONGITUDINAL ENERGY DISTRIBUTIONS PER SHOWER IN I
C                BINS FOR K= GAMMAS, POSITRONS, ELECTRONS, MU+, MU-,
C                HADRONS, CHARGED, NUCLEI, AND CHERENKOV PHOTONS
C  ENEPER      = 2.718281828 (EULER''S CONSTANT)
C  ENEW        = ENERGY AT END OF STEP

C  EOLD        = ENERGY AT BEGIN OF STEP
C  EONCUT      = CUTTING ENERGY (IN MEV) FOR REJECT IN EGS

C  EPSX        = HALF COVERAGE RATIO IN X DIRECTION
C  EPSY        = HALF COVERAGE RATIO IN Y DIRECTION

C  ERR         = ARRAY OF ERRORS OF PARTICLE NUMBERS IN LONG. DIST.

C  ETADSN      = CORRECTION FACTOR FOR REFRACTIVE INDEX CALCULATION
C  EVTE(MAXBUF)= BUFFER FOR EVENT END
C  EVTH(MAXBUF)= BUFFER FOR EVENT HEADER
C  E00         = ENERGY OF PRIMARY NEEDED FOR REJECT IN EGS
C  E00PN       = ENERGY OF PRIMARY PER NUCLEON

C  E000        = ENERGY/NUCLEON OF PROJECTILE BEFORE COLLISION

C  E_ARRAY     = ARRAY FOR ELECTRONS IN BINS IN ENERGY, TIME, CORE DIST.
C
C  FAC         = VARIABLE OF SUBROUT. RANNOR

C  FCERX       = OFFSET FOR A ODD/EVEN NUMBER OF CHEREKOV DETECTORS IN X
C  FCERY       = OFFSET FOR A ODD/EVEN NUMBER OF CHEREKOV DETECTORS IN Y

C  FDBASE      = FLAG FOR WRITING SUMMARY FILE FOR DATABASE
C  FDECAY      = FLAG INDICATING PARTICLE UNDERGOES DECAY

C  FEGS        = FLAG FOR USE OF EGS4
C  FEGSDB      = DEBUG FALG FOR EGS-DEBUGGING

C  FFLUDB      = FLAG INDICATING DEBUG OF FLUKA
C  FFLUKA      = FLAG INDICATING USE OF FLUKA
C  FFLUSIG     = FLAG INDICATING THAT FLUKA SIGMA IS AVAILABLE

C  FIRSTI      = FLAG INDICATING FIRST INTERACTION IN HDPM
C  FIXHEI      = HEIGHT OF FIRST INTERACTION IF TAKEN FIXED (CM)
C  FIXINC      = FLAG TO KEEP ANGLES OF INCIDENCE FIXED
C  FIXTAR      = FLAG TO INDICATE FIXED TARGET FOR FIRST INTERACTION
C  FIX1I       = FLAG TO KEEP HEIGHT OF FIRST INTERACTION FIXED
C  FLGFIT      = LOGICAL TO ENABLE/DISABLE FIT TO CHARGED PART. LONG. DISTR.
C  FLONGOUT    = FLAG INDICATING LONGITUDINAL OUTPUT
C  FMOLI       = FLAG INDICATING MOLIERE (T) OR GAUSS (F) SCATTERING
C  FMUADD      = FLAG TO INDICATE ADDITIONAL MUON OUTPUT ON MPATAP
C  FMUBRM      = FLAG TO INDICATE MUON HAS TO UNDERGO BREMSSTRAHLUNG
C  FMUNUC      = FLAG TO INDICATE MUON HAS TO UNDERGO NUCL.INTERACT.
C  FMUORG      = FLAG TO INDICATE WHETHER MUON BELONGS TO AMUPAR(.)
C  FNEUT       = # OF NEUTRAL PARTICLES (ALL 3 STRINGS)  WITH FLUCTUAT
C  FNEUT2      = # OF NEUTRAL PARTICLES (1ST+2ND STRING) WITH FLUCTUAT

C  FNKG        = FLAG FOR USE OF NKG FORMULAS
C  FNPRIM      = FLAG INDICATING THE PRIMARY PARTICLE IN EGS
C  FPAROUT     = FLAG INDICATING PARTICLE OUTPUT

C  FRACTN      = NITROGEN FACTION OF INELASTIC AIR CROSS-SECTION
C  FRCTNO      = NITROGEN+OXYGEN FACTION OF INELASTIC AIR CROSS-SECTION

C  FREFRX      = FLAG INDICATING REFRACTIVE INDEX IS TAKEN
C  FPRINT      = LOGICAL VARIABLE TO STEER PRINTING

C  FQGS        = FLAG TO ACTIVATE QGSJET INTERACTION ROUTINES
C  FQGSSG      = FLAG TO ACTIVATE QGSJET CROSS-SECTIONS

C  FTABOUT     = FLAG INDICATING TABLE OUTPUT
C

C  GAMMA       = CURPAR(1)
C  GAM345(3)   = GAMMA FACTOR OF PARTICLE EMERGING FROM 3 BODY DECAY
C  GCM         = CURPAR(11)
C  GEN         = GENERATION OF PARTICLE
C  GHEISDB     = FLAG TO ACTIVATE GHEISHA DEBUG OUTPUT
C  GHEISH      = FLAG TO ACTIVATE GHEISHA ROUTINES
C  GHESIG      = FLAG TO INDICATE THAT GHEISHA CROSS-SECTION IS USED

C  GLE         = LOGARITHM OF GAMMA ENERGY
C  GNU         = # OF COLLISIONS IN TARGET (HDPM)
C  G_ARRAY     = ARRAY FOR GAMMAS IN BINS IN ENERGY, TIME, CORE DISTANCE
C
C  H           = CURPAR(5)
C  HBARO       = BAROMETRIC EXPONENT OF ATMOSPHERIC LAYER (EGS4)
C  HBAROI      = INVERSE OF BAROMETRIC EXP. OF ATMOSPHERIC LAYER (EGS4)
C  HEIGHP      = HEIGHT OF FIRST INTERACTION

C  HAPP        = CURPAR(14) APPARENT HEIGHT IN CARTESIAN COORD. SYSTEM
C  HILOECM     = ENERGY THRESHOLD FOR HIGH ENERGY MODEL IN CM
C  HILOELB     = ENERGY THRESHOLD FOR HIGH ENERGY MODEL IN LAB
C  HLAY(6)     = ALTITUDE OF ACTUAL ATMOSPHERIC LAYER BOUNDARIES
C  HLAYS(6)    = SLANT PATH FROM TOP OF ATMOSPHERE TO LAYER BOUNDARY
C  HLAY0(5,..) = ALTITUDE OF ATMOSPHERIC LAYER BOUNDARIES
C  HLONG(I)    = THE HEIGHT VALUES IN CM FOR THE LEVELS IN G/CM**2

C  HOST        = NAME OF HOST COMPUTER IN USE
C
C  IALT(2)     = # OF LEVELS IN NKG FOR WHICH ELECT.DENSITIES ARE CALCUL

C  IAPP        = NUMBER OF NUCLEONS IN PROJECTILE NUCLEUS
C  IATT        = NUMBER OF NUCLEONS IN TARGET NUCLEUS

C  IATMOX      = MODTRAN ATMOSPHERIC MODEL NUMBER

C  IA1 ... IJ1 = LOWER BOUNDARY OF PARTICLE SPECIES IN HDPM
C  IA2 ... II2 = UPPER BOUNDARY OF PARTICLES 3RD STRING IN HDPM

C  ICERML      = NUMBER OF MULTIPLE CHERENKOV ARRAYS

C  ICFTABL     = CONVERSION TABLE PARTICLE CODE CORSIKA TO FLUKA

C  ICOUNT      = POSITION OF PARTICLE WITHIN STACK

C  ICPP        = PROJECTILE TYPE

C  ICTABL()    = TABLE TO CONVERT PARTICLE TYPE FROM CORSIKA TO QGSJET

C  IDBIN       = PARAMETER # OF DISTANCE BINS
C  IDIF        = DIFFRACTION FLAG IN HDPM
C  IDISC       = FLAG INDICATING PARTICLE IS TO BE DISCARDED

C  IEBIN       = PARAMETER # OF ENERGY BINS
C  IELDPA(.)   = ELASTICITY STATISTICS IN DUAL PARTON MODELL FOR ALL
C  IELDPM(.)   = ELASTICITY STATISTICS IN DUAL PARTON MODELL FOR SHOWER

C  IFCTABL     = CONVERSION TABLE PARTICLE CODE FLUKA TO CORSIKA

C  IFINET      = # ETAS PRODUCED IN FIRST INTERACTION
C  IFINHY      = # STRANG BARYONS PRODUCED IN FIRST INTERACTION
C  IFINKA      = # KAONS PRODUCED IN FIRST INTERACTION
C  IFINNU      = # NUCLEONS PRODUCED IN FIRST INTERACTION
C  IFINOT      = # OTHER HADRONS PRODUCED IN FIRST INTERACTION
C  IFINPI      = # PIONS PRODUCED IN FIRST INTERACTION
C  IGEN(NP)    = GENERATION COUNTER OF PARTICLE ON EGS STACK

C  IHBIN(40)   = COUNTER FOR STRANGE BARYON TABLE FOR SHOWER
C  IHYCHI(124) = INTERACTION LENGTH STATISTICS FOR STRANGE BARYONS
C  IKACHI(124) = INTERACTION LENGTH STATISTICS FOR KAONS
C  IKBIN(40)   = COUNTER FOR KAON TABLE FOR SHOWER
C  IJKL()      = ARRAY(KSEQ) FOR RANDOM GENERATOR
C  IMUCHI(124) = INTERACTION LENGTH STATISTICS FOR MUONS
C  INBIN(40)   = COUNTER FOR NUCLEON TABLE FOR SHOWER
C  INECHI(124) = INTERACTION LENGTH STATISTICS FOR NEUTRINOS
C  INNCHI(124) = INTERACTION LENGTH STATISTICS FOR NUCLEI
C  INT_ICOUNT  = POINTER FOR INTERMEDIATE PARTICLE STACK
C  INUCHI(124) = INTERACTION LENGTH STATISTICS FOR NUCLEONS
C  IOBS(NP)    = # OF NEXT OBSERVATION LEVEL FOR PARTICLE ON EGS STACK
C  IPBIN(40)   = COUNTER FOR PION TABLE FOR SHOWER
C  IPICHI(124) = INTERACTION LENGTH STATISTICS FOR PIONS

C  IQ(NP)      = PARTICLE IDENTIFIER (EGS)

C  IQGSVER     = QGSJET VERSION NUMBER * 10
C  IQTABL      = TABLE TO CONVERT PARTICLE TYPE FROM QGSJET TO CORSIKA

C  IR(NP)      = ACTUAL ATMOSPHERIC LAYER OF PARTICLE ON EGS STACK

C  IRAND(3)    = RANDOM GENERATOR STATUS AT BEGIN OF HADR. INTERACTION

C  IRECOR      = # WORDS WRITTEN ON PARTICLE TAPE RECORDS
C  IRESPAR     = POINTER FOR ARRAY RESRAN

C  IRET1       = RETURN CODE
C  IRET2       = RETURN CODE
C  IRETE       = RETURN CODE FOR ENERGY CUT (LOGICAL)
C  IRNEW       = INDEX OF NEW ATMOSPHERIC LAYER
C  IROLD       = INDEX OF OLD ATMOSPERIC LAYER

C  ISEED(.,.)  = RANDOM GENERATOR SEED
C  ISEL        = INDICATOR FOR LOW MULTIPLICITY OF SEC.PARTICLES (HDPM)
C  ISHOWNO     = # OF ACTUAL SHOWER
C  ISHW        = INDEX OF SHOWER LOOP
C  ISPEC       = 0 FOR FIXED ENERGY   = 1 FOR ENERGY SPECTRUM

C  ITAR        = PARTICLE CODE OF TARGET NUCLEON IN HDPM
C  ITBIN       = PARAMETER # OF ARRIVAL TIME BINS

C  ITYP(3000)  = PARTICLE TYPE OF SECONDARY PARTICLE IN HDPM
C  ITYPE       = CURPAR(0)  PARTICLE TYPES ACCORDING TO GEANT
C                IN ADDITION : A*100+Z=HEAVY NUCLEI (FOR PRIMARIES ONLY)
C  I97()       = ARRAY(KSEQ) FOR RANDOM GENERATOR
C
C  JCLOCK      = PRESET COUNTER FOR EGS-DEBUG ACTIVATION

C  JSEQ        = ACTUAL SEQUENCE NUMBER
C  J97()       = ARRAY(KSEQ) FOR RANDOM GENERATOR
C

C  KK          = NUMBER OF TARGET COMPONENTS (GHEISHA)
C  KNOR        = FLAG TO STEER GENERATION OF NORMAL DISTRIBUTED RANDOMS
C  KSEQ        = PARAMETER DEFINING MAX. NUMBER OF INDEPENDENT SEQUENCES
C
C  LASTPI      = # OF CHARGED PIONS CREATED/DELETED BY CHARGE EXCHANGE
C  LAYNEW      = FLAG INDICATING NEW ATMOSPHERIC LAYER BOUNDARIES
C  LAYNO(..)   = POINTER OF ATMOSPHERE MODEL TO LAYER NUMBER

C  LCERDB      = FLAG FOR DEBUG OUTPUT IN CHERENKOV PART
C  LCERFI      = FLAG FOR STEERING CHERENKOV PHOTON OUTPUT

C  LEPAR1      = TYPE OF LEADING PARTICLE BEFORE / AFTER CHARGE EXCHANGE
C  LEPAR2      = TYPE OF TARGET  PARTICLE BEFORE / AFTER CHARGE EXCHANGE

C  LEVL        = LEVEL # OF PARTICLE WRITTEN TO TAPE

C  LEVLDQ      = LEVEL OF DEBUG OUTPUT IN CASE OF DEBUGGIUNG

C  LH          = BUFFER POINTER

C  LHCER       = CHERENKOV BUFFER POINTER

C  LHEIGH      = STEP NUMBER AT INTERACTION POINT

C  LL          = USED FOR PRIMARY ENERGY SELECTION
C  LLIMIT      = LOWER LIMIT OF ENERGY SECTION FOR PRIMARY (GEV)
C  LLONGI      = LOGICAL TO STEER THE SAMPLING OF LONGITUDINAL DISTRIBUTION
C  LNGMAX      = MAXIMUM ARRAY LENGTH OF LONGI ARRAYS
C  LPCTE(NP)   = INDEX OF LONGITUDINAL LAYER FOR PARTICLE ON EGS STACK

C  LT          = INDEX FOR INTERACTING TARGET (1=N, 2=0, 3=A)

C
C  MALPHA(20)  = MEAN # OF ALPHAS WRITTEN TO TAPE PER LEVEL

C  MAXBF2      = MAXIMUM BUFFER SIZE FOR CHERENKOV PHOTONS

C  MAXBUF      = PARAMETER FOR MAXIMAL BUFFER SIZE

C  MAXICOUNT   = PARAMETER FOR MAXIMAL INTERMEDIATE STACK SIZE
C  MAXLEN      = PARAMETER FOR SIZE OF PARTICLE FIELDS
C  MAXPRT      = NUMBER OF SHOWERS TO BE PRINTED
C  MAXSTK      = PARAMETER FOR MAXIMAL STACK SIZE
C  MCETAP      = LUN OF DATASET FOR CHERENKOV PHOTONS OUTPUT

C  MDBASE      = LUN OF DATABASE FILE
C  MDEBUG      = LUN OF DEBUG OUTPUT
C  MDEUT(20)   = MEAN # OF DEUTERONS WRITTEN TO TAPE PER LEVEL
C  MELECT(20)  = MEAN # OF E- WRITTEN TO TAPE PER LEVEL
C  MEXST       = LUN OF SCRATCH DSN FOR EXTERNAL STACK

C  MHEIGH      = PARAMETER NUMBER OF VALUES IN HEIGHT

C  MHELI3(20)  = MEAN # OF 3HELIUM WRITTEN TO TAPE PER LEVEL

C  MHYP(20)    = MEAN # OF STRANGE BARYONS WRITTEN TO TAPE PER LEVEL
C  MKMI(20)    = MEAN # OF K - WRITTEN TO TAPE PER LEVEL
C  MKPL(20)    = MEAN # OF K + WRITTEN TO TAPE PER LEVEL
C  MK0L(20)    = MEAN # OF K0L WRITTEN TO TAPE PER LEVEL
C  MK0S(20)    = MEAN # OF K0S WRITTEN TO TAPE PER LEVEL
C  MLONGOUT    = LUN OF LONGITUDINAL TABLE OUTPUT

C  MMUM(20)    = MEAN # OF MU- WRITTEN TO TAPE PER LEVEL
C  MMUOND      = MEAN # OF MUONS DECAYED TO ELECTRONS/POSITRONS
C  MMUP(20)    = MEAN # OF MU+ WRITTEN TO TAPE PER LEVEL
C  MNEUTB(20)  = MEAN # OF ANTINEUTRONS WRITTEN TO TAPE PER LEVEL
C  MNEUTR(20)  = MEAN # OF NEUTRONS WRITTEN TO TAPE PER LEVEL
C  MNU(20)     = MEAN # OF NEUTRINOS WRITTEN TO TAPE PER LEVEL
C  MODATM      = INDEX OF ATMOSPHERIC MODEL
C  MODCNS      = MODULUS (NOTOT * MODCNS = NTOT2) FOR RANDOM GENERATOR

C  MONIIN      = LUN OF CARD READER
C  MONIOU      = LUN OF LINE PRINTER
C  MOTHER(20)  = MEAN # OF OTHER PARTICLES WRITTEN TO TAPE PER LEVEL
C  MPARTO(.)   = ARRAY FOR MEAN # OF PARTICLES
C  MPATAP      = LUN OF DATASET FOR PARTICLE OUTPUT
C  MPHOTO(20)  = MEAN # OF GAMMAS WRITTEN TO TAPE PER LEVEL
C  MPIM(20)    = MEAN # OF PI- WRITTEN TO TAPE PER LEVEL
C  MPIP(20)    = MEAN # OF PI+ WRITTEN TO TAPE PER LEVEL
C  MPI0(20)    = MEAN # OF PI(0) WRITTEN TO TAPE PER LEVEL
C  MPOSIT(20)  = MEAN # OF E+ WRITTEN TO TAPE PER LEVEL
C  MPROTB(20)  = MEAN # OF ANTIPROTONS WRITTEN TO TAPE PER LEVEL
C  MPROTO(20)  = MEAN # OF PROTONS WRITTEN TO TAPE PER LEVEL
C  MSMM        = MULTIPLICITY FOR ENERGY-MULTIPLICITY MATRIX
C  MSTACKP      = STACK POINTER
C  MTABOUT     = LUN OF TABLE OUTPUT FOR CHARGED PARTICLES

C  MTRIT(20)   = MEAN # OF TRITONS WRITTEN TO TAPE PER LEVEL
C  MULTMA(.)   = ENERGY-MULTIPLICITY MATRIX FOR SHOWER
C  MULTOT(.)   = ENERGY-MULTIPLICITY MATRIX FOR SHOWER GROUP

C  MVDATE      = DATE OF VERSION AS INTEGER (YYYYMMDD)

C  M_ARRAY     = ARRAY FOR MUONS IN BINS IN ENERGY, TIME, CORE DISTANCE
C
C  NALPHA(20)  = # OF ALPHAS WRITTEN TO TAPE PER LEVEL
C  NBLKS       = # OF SMALL BLOCKS PUT OUT (FOR TP)

C  NCERX       = NUMBER OF DETECTORS IN X DIRECTION
C  NCERY       = NUMBER OF DETECTORS IN Y DIRECTION

C  NCH         = # OF CHARGED PARTICLES (HDPM)
C  NCLOCK      = ACTUAL ELECTRON COUNTER FOR EGS-DEBUG

C  NCOUN(8)    = COUNTER OF ANTINUCLEONS IN VARIOUS BOX ROUTINES
C  NCPLUS      = POSITIVE CHARGE EXCESS BY RESONANCE/CHARGE EXCHANGE
C  NDEBDL      = NUMBER OF MAPPED PARTICLE THAT ACTIVATES DELAYED DEBUG
C  NDEUT(20)   = # OF DEUTERONS WRITTEN TO TAPE PER LEVEL

C  NELECT(20)  = # OF ELECTRONS WRITTEN TO TAPE PER LEVEL
C  NET         = TOTAL # OF ETAS  (HDPM)
C  NETA(I,K)   = # OF ETAS  IN 1ST + 2ND / 3RD STRING (HDPM)
C                SEPARATELY DEFINED FOR EACH DECAY MODE K
C  NETAS(I)    = # OF ETAS                 IN 1ST + 2ND / 3RD STRING
C  NEUTOT      = TOTAL # OF NEUTRAL PARTICLES  IN HDPM
C  NEWOBS      = POINTER FOR NEXT OBSERVATIONLEVEL (EGS4)

C  NFLAIN      = 0  RANDOM NUMBER OF INTERACTIONS IN AIR TARGET
C              = 1  FIXED  NUMBER OF INTERACTIONS IN AIR TARGET
C  NFLCHE      = 0  CHARGE EXCHANGE INTERACTION POSSIBLE
C              = 1  NO CHARGE EXCHANGE INTERACTION POSSIBLE
C  NFLDIF      = 0  NO DIFFRACTIVE INTERACTION IF NFLAIN = 0 AND MORE
C                   THAN 1 INTERACTION
C  NFLPIF      = 0  NO FLUCTUATION OF NUMBER OF PI0
C              = 1  FLUCTUATION OF NUMBER OF PI0 AS SEEN IN COLLIDER
C  NFLPI0      = 0  RAPIDITY OF PI0 TREATED ACCORDING TO COLLIDER DATA
C              = 1  RAPIDITY OF PI0 SAME AS THAT OF CHARGED
C  NFRAGM      = 0  TOTAL FRAGMENTATION OF PRIMARY NUCLEUS IN 1.INTERACT
C              = 1  NO FRAGMENTATION AND NO EVAPORATION
C              = 2  REALISTIC FRAGMENTATION OR EVAPORATION (PT AFTER JACEE)
C              = 3  REALISTIC FRAGMENTATION OR EVAPORATION (PT AFTER GOLDHABER)
C              = 4  REALISTIC FRAGMENTATION OR EVAPORATION WITH PT-0
C  NFROM       = # OF PARTICLES READ FROM STACK
C  NHC         = # OF CHARGED STRANGE BARYON PAIRS  (HDPM)
C  NHELI3(20)  = # OF 3HELIUM WRITTEN TO TAPE PER LEVEL
C  NHN         = TOTAL # OF NEUTR.STR.BAR. PAIRS    (HDPM)
C  NHYP(20)    = # OF STR. BARYONS WRITTEN TO TAPE PER LEVEL
C  NHYPN(.)    = # OF NEUTR.STR.BAR.PAIRS  IN 1ST + 2ND / 3RD STRING
C  NKA0(.)     = # OF NEUTRAL KAON  PAIRS  IN 1ST + 2ND / 3RD STRING
C  NKC         = # OF CHARGED KAON  PAIRS  (HDPM)
C  NKMI(20)    = # OF K- WRITTEN TO TAPE PER LEVEL
C  NKN         = TOTAL # OF NEUTRAL KAON   PAIRS  (HDPM)
C  NKPL(20)    = # OF K+ WRITTEN TO TAPE PER LEVEL
C  NK0L(20)    = # OF K0L WRITTEN TO TAPE PER LEVEL
C  NK0S(20)    = # OF K0S WRITTEN TO TAPE PER LEVEL
C  NMUM(20)    = # OF MU- WRITTEN TO TAPE PER LEVEL
C  NMUOND      = # OF MUONS DECAYED TO ELECTRONS/POSITRONS
C  NMUP(20)    = # OF MU+ WRITTEN TO TAPE PER LEVEL
C  NNC         = # OF PROTON/ANTIPROTON PAIRS  (HDPM)
C  NNEUTB(20)  = # OF ANTINEUTRONS WRITTEN TO TAPE PER LEVEL
C  NNEUTR(20)  = # OF NEUTRONS WRITTEN TO TAPE PER LEVEL

C  NNN         = TOTAL # OF NEUTRON/ANTINEUTRON PAIRS (HDPM)

C  NNU(20)     = # OF NEUTRINOS WRITTEN TO TAPE PER LEVEL
C  NNUCN(.)    = # OF NEUTRON PAIRS  IN 1ST + 2ND / 3RD STRING (HDPM)
C  NOBSLV      = # OF OBSERVATION LEVELS
C  NOPART      = COUNTER FOR PARTICLES WRITTEN TO TAPE
C  NOTHER(20)  = # OF OTHER PARTICLES WRITTEN TO TAPE PER LEVEL
C  NOUREC      = # OF OUTPUT RECORDS
C  NP          = STACK POINTER OF PARTICLE ON EGS STACK

C  NPARTO(.)   = ARRAY CONTAINING  # OF PARTICLES AT OBSERVATION LEVEL
C  NPART2(.)   = ARRAY CONTAINING  # OF PARTICLES AT OBSERVATION LEVEL
C  NPC         = # OF CHARGED PIONS (HDPM)
C  NPHOTO(20)  = # OF GAMMAS WRITTEN TO TAPE PER LEVEL
C  NPIM(20)    = # OF PI- WRITTEN TO TAPE PER LEVEL
C  NPIP(20)    = # OF PI+ WRITTEN TO TAPE PER LEVEL
C  NPIZER(.)   = # OF PI(0)S IN 1ST + 2ND / 3RD STRING (HDPM)
C  NPI0(20)    = # OF PI(0) WRITTEN TO TAPE PER LEVEL

C  NPLEM       = NUMBER OF TRACKS OF EM PARTICLES FOR PLOT
C  NPLHAD      = NUMBER OF TRACKS OF HADRONS      FOR PLOT
C  NPLMU       = NUMBER OF TRACKS OF MUONS        FOR PLOT

C  NPN         = TOTAL # OF PI(0)S  (HDPM)
C  NPOSIT(20)  = # OF POSITRONS WRITTEN TO TAPE PER LEVEL
C  NPROTB(20)  = # OF ANTIPROTONS WRITTEN TO TAPE PER LEVEL
C  NPROTO(20)  = # OF PROTONS WRITTEN TO TAPE PER LEVEL

C  NRECER      = COUNTER FOR DIRECT ACCESS OUTPUT OF CHERENKOV PHOTONS

C  NRECS       = # OF BIG BLOCKS PUT OUT (FOR TP)
C  NRESPC      = # OF CHARGED PIONS TO BE CREATED BY RESONANCE DECAY
C  NRESPN      = # OF NEUTRAL PIONS TO BE CREATED BY RESONANCE DECAY
C  NRRUN       = # OF RUN
C  NSEQ        = # OF RANDOM GENERATOR SEQUENCE
C  NSHIFT      = # OF STACK SHIFTS
C  NSHOW       = # OF SHOWERS TO GENERATE
C  NSTEP       = NUMBER OF STEPS FOR LONGITUDINAL DISTRIBUTION
C  NSTP        = NUMBER OF STEPS FOR LONGITUDINAL DIST. FIT

C  NTHETA      = PARAMETER NUMBER OF VALUES IN THETA

C  NTO         = # OF PARTICLES WRITTEN TO STACK
C  NTOT        = TOTAL NUMBER OF PARTICLES (HDPM)
C  NTOT()      = ARRAY(KSEQ) FOR RANDOM GENERATOR
C  NTOTEM      = TOTAL #OF SECONDARY PARTICLES IN HDPM
C  NTOT2()     = ARRAY(KSEQ) FOR RANDOM GENERATOR
C  NTRIT(20)   = # OF TRITONS WRITTEN TO TAPE PER LEVEL
C  NUCNUC      = LUN OF CROSS-SECTION FILE
C  NUCTAB      = TABLE OF MUON NUCLEAR INTERACTION CROSS-SECTIONS

C  N1STTR      = NUMBER OF FIXED FIRST TARGET 0=RANDOM, 1=N, 2=O, 3=AR
C
C  OBSATI(2)   = OBSERVATION LEVELS IN CM (USED IN NKG)(MAX. 2)
C  OBSLEV(..)  = OBSERVATION LEVELS (CM)
C  OBSLVL      = OBSERVATION LEVEL (EGS4)
C  OBSLV2      = OBSERVATION LEVEL - 1G/CM**2 (EGS4 AUGERHIST)
C  OB3         = ONE BY THREE = 1./3.
C  OMC         = CONSTANT OMEGA_C FOR MUOMN MULTIPLE SCATTERING
C  ..PARTICLE TO BE WRITTEN TO TAPE
C  OUTPAR(..)  = PARTICLE FIELD FOR OUTPUT PARTICLE (COMP. SECPAR)
C
C  PAIRTAB     = TABLE OF MUON PAIR PRODUCTION CROSS-SECTIONS
C  PAMA(6000)  = MASS OF PARTICLE (GEV)
C  PATH1(500)  = SLANT PATH LENGTH
C  PHIX        = CURPAR(3)
C  PHIY        = CURPAR(4)
C  PHIPR(2)    = RANGE PHI OF PRIMARY PARTICLE IN RADIAN
C  PHIP        = ACTUAL PHI OF PRIMARY PARTICLE IN RADIAN
C  PHISCT      = AZIMUTAL ANGLE OF MUON MULTIPLE SCATTERING
C  PHI345(3)   = ANGLE PHI OF PARTICLE EMERGING FROM 3 BODY DECAY

C  PHOTCM      = NUMBER OF CHERENKOV PHOTONS EMITTED FROM PATH ELEMENT

C  PI          = 3.14159...     SET IN BLOCK DATA
C  PI2         = 2 * PI
C  PICMAS      = MASS OF CHARGED PION (EGS4)
C  PITHR       = THRESHOLD ENERGY FOR PHOTONUCLEAR INTERACT. (EGS4)
C  PI0MAS      = MASS OF PI(0) (EGS4)
C  PI0MSQ      = MASS OF PI(0) SQUARED (EGS4)
C  PLAB        = MOMENTUM OF INCOMING PARTICLE IN LAB SYSTEM
C  PLONG(I,K)  = LONGITUDINAL PARTICLE DISTRIBUTIONS PER SHOWER IN I
C                BINS FOR K= GAMMAS, POSITRONS, ELECTRONS, MU+, MU-,
C                HADRONS, CHARGED, NUCLEI, AND CHERENKOV PHOTONS

C  PLOTSH      = FLAG TO ENABLE/DISABLE PRODUCTION OF FILES FOR PLOTS
C  PNOA30(.)   = ARRAY FOR PROBABILITY OF # OF INTERACTIONS
C  PNOA45(.)   = ARRAY FOR PROBABILITY OF # OF INTERACTIONS
C  PNOA60(.)   = ARRAY FOR PROBABILITY OF # OF INTERACTIONS
C  POLARF      = PHI        ; POLARIZATION DIRECTION OF MUON
C  POLART      = COS(THETA) ; POLARIZATION DIRECTION OF MUON
C  POSC2       = POSITION OF GAUSSIAN FOR 1ST+2ND STRING (CHARGED)
C  POSC3       = POSITION OF GAUSSIAN FOR 3RD     STRING (CHARGED)
C  POSN2       = POSITION OF GAUSSIAN FOR 1ST+2ND STRING (NEUTRAL)
C  POSN3       = POSITION OF GAUSSIAN FOR 3RD     STRING (NEUTRAL)
C  PPICH       = RATIO # PI+(+-) / # ALL CHARGED PARTICLES (HDPM)
C  PPINCH      = RATIO # PI+(+-)+PROTON / # ALL CHARGED PARTICLES (HDPM)
C  PPNKCH      = RATIO # PI+(+-)+PROTON+K(+-) / # ALL CHARGED PARTICLES

C  PRMPAR(..)  = PARTICLE FIELD FOR PRIMARY PARTICLE (COMP. CURPAR)
C  PROBTA(3)   = INTEGRATED ATOMIC FRACTIONS

C  PRRMMU      = REST MASS OF MUON (EGS4)
C  PSLOPE      = SLOPE OF PRIMARY DIFFERENTIAL ENERGY SPECTRUM
C                IF PRIMARY ENERGY IS TO BE COMPUTED FROM A SPECTRUM
C  PT2(3000)   = PT**2             OF SECONDARY PARTICLE IN HDPM
C  PTOT0       = TOTAL MOMENTUM OF PRIMARY
C  PTOT0N      = TOTAL MOMENTUM OF PRIMARY PER NUCLEON
C  PX(3000))   = PT IN X DIRECTION OF SECONDARY PARTICLE IN HDPM
C  PY(3000))   = PT IN Y DIRECTION OF SECONDARY PARTICLE IN HDPM
C

C  QFRACN      = TABULATED VALUES OF HADRON 14N CROSS-SECTIONS (QGSJET)
C  QFRANO      = TABUL. VALUES OF HADRON 14N+16O CROSS-SECTIONS (QGSJET)
C
C  RADNKG      = RADIUS RANGE FOR NKG ELECTRON DENSITIES IN CM

C  RATIO       = RATIO TOTAL STEP LENGTH/SCATTERING LENGTH FOR ELECTRONS
C  RC3TO2      = RATIO (CHARGED OF 3RD STRING)/(CHARGED 1ST+2ND STRING)
C  RD(3000)    = ARRAY (DOUBLE PRECISION) FOR RANDOM NUMBERS
C  RDRES(2)    = RANDOM NUMBERS FOR RESONANCE DECAYS
C  RESRAN(.)   = RANDOM NUMBERS FOR RESONANCE DECAYS
C  RESTMS(6000)= RELEASABLE KINETIC ENERGY OF PARTICLE
C  RHOFAC      = DENSITY FACTOR
C  RHOS(6)     = DENSITY AT LAYER BOUNDARY
C  RLOFF       = OFFSET OF PLANE NORMAL TO SHOWER AXIS
C  RLONG()     = ARRAY FOR DISTANCES TO PLANE NORMAL TO SHOWER AXIS
C  RMOL(1)     = MOLIERE RADIUS IN AIR IN CM AT LOWER LEVEL
C  RMOL(2)     = MOLIERE RADIUS IN AIR IN CM AT HIGHER LEVEL
C  RMMUT2      = 2 * REST MASS OF MUON (EGS4)

C  RPEKNR      = RATIO # PI(0)+ETA+KA0+NEUTR/ # ALL NEUTRAL PARTICLES
C  RPEKR       = RATIO # PI(0)+ETA+KA0/ # ALL NEUTRAL PARTICLES (HDPM)
C  RPIER       = RATIO # PI(0)+ETA / # ALL NEUTRAL PARTICLES (HDPM)
C  RPI0R       = RATIO # PI(0) / # ALL NEUTRAL PARTICLES (HDPM)
C  RHOSLT(500) = DENSITY ALONG SLANT BIN
C  RUNE(MAXBUF)= BUFFER FOR RUN   END
C  RUNH(MAXBUF)= BUFFER FOR RUN   HEADER
C
C  S           = C.M. ENERGY SQUARED  IN HDPM
C  SABIN(40)   = LOW  EDGE OF KIN. ENERGY FOR INTERACTION-ENERGY TABLE
C  SAH(10)     = AGE IN STEPS OF 100 G/CM**2

C  SBBIN(40)   = HIGH EDGE OF KIN. ENERGY FOR INTERACTION-ENERGY TABLE
C  ..SECONDARY PARTICLE
C  SECPAR(..)  = PARTICLE FIELD FOR SECONDARY PARTICLE (COMP. CURPAR)
C  SECPAR(9)   = GENERATION OF PARTICLE
C  SECPAR(10)  = LEVEL OF LAST INTERACTION
C  SECPAR(11)  = POLARIZATION DIRECTION: COS(THETA) FOR MUONS
C  SECPAR(12)  = POLARIZATION DIRECTION: PHI FOR MUONS

C  SECPAR(14)  = APPARENT HEIGHT  IN CARTESIAN COORDINATE SYSTEM
C  SECPAR(15)  = APPARENT ZENITH ANGLE IN CART.COORDINATE SYSTEM
C  SECPAR(16)  = ANGLE PARTICLE TO MID DETECT AT CENTER EARTH

C  SDLONG(I,K) = STANDARD DEVIATION OF DLONG
C  SE          = SQUARE ROOT OF E_NEPER
C  SELONG(I,K) = STANDARD DEVIATION OF ELONG
C  SEL(10)     = USED FOR AVERAGING OF SL(10)   (NKG)
C  SELLG(10)   = USED FOR LOGARITHMIC AVERAGING OF SL(10)
C  SEUGF       = NUMBER OF GAMMAS (WITH FLUCTUATION) (HDPM)
C  SEUGP       = NUMBER OF GAMMAS (AVERAGE PARAMETRIZED) (HDPM)
C  SE14(.)     = ARRAY FOR COLLISION PROBABILITY
C  SE16(.)     = ARRAY FOR COLLISION PROBABILITY
C  SE40(.)     = ARRAY FOR COLLISION PROBABILITY

C  SIGAIR      = INELASTIC CROSS-SECTION IN AIR
C  SIGANN      = NUCLEON ANNIHILATION CROSS-SECTION
C  SIGA30(.)   = ARRAY FOR CROSS-SECTIONS ARGON
C  SIGA45(.)   = ARRAY FOR CROSS-SECTIONS ARGON
C  SIGA60(.)   = ARRAY FOR CROSS-SECTIONS ARGON
C  SIGMA       = INELASTIC CROSS-SECTION FOR HADRON NUCLEON COLLISION

C  SIGNUM(6000) = SIGN AND CHARGE OF PARTICLES
C  SIGN30(.)   = ARRAY FOR CROSS-SECTIONS NITROGEN
C  SIGN45(.)   = ARRAY FOR CROSS-SECTIONS NITROGEN
C  SIGN60(.)   = ARRAY FOR CROSS-SECTIONS NITROGEN
C  SIGO30(.)   = ARRAY FOR CROSS-SECTIONS OXYGEN
C  SIGO45(.)   = ARRAY FOR CROSS-SECTIONS OXYGEN
C  SIGO60(.)   = ARRAY FOR CROSS-SECTIONS OXYGEN

C  SIGQAIR     = TABULATED VALUES OF HADRON AIR CROSS-SECTIONS (QGSJET)
C  SIGQHN      = TABULATED VALUES OF HADR. NUCL.CROSS-SECTIONS (QGSJET)

C  SIG1I       = CROSS-SECTION FOR FIRST INTERACTION
C  SIG30A(.)   = ARRAY FOR CROSS-SECTIONS AIR
C  SIG45A(.)   = ARRAY FOR CROSS-SECTIONS AIR
C  SIG60A(.)   = ARRAY FOR CROSS-SECTIONS AIR
C  SINANG      = SIN OF ARRANR
C  SINB        = SIN OF INCLINATION ANGLE MAGNETIC FIELD

C  SL(10)      = NUMBER OF ELECTRONS IN STEPS OF 100 G/CM**2 (NKG)
C  SLEX        = EXPONENT OF SLOPE OF PRIMARY SPECTRUM
C  SLOG        = LOG OF C.M. ENERGY SQUARED  (HDPM)
C  SLOGSQ      = SQUARE OF LOG OF C.M. ENERGY SQUARED  (HDPM)
C  SMLOG       = LOG ( C.M. ENERGY SQUARED  - 2 * NUCL.MASS**2 ) (HDPM)
C  SPHISCT     = SINE   OF AZIMUTAL ANGLE OF MUON MULTIPLE SCATTERING
C  SPHI345(3)  = SINE   PHI   OF PARTICLE EMERGING FROM 3 BODY DECAY
C  SPLONG(I,K) = STANDARD DEVIATION OF PLONG

C  STACKI(MAXSTK)=PARTICLE STACK FOR 2 * 256 PARTICLES A 17 WORDS
C  STACKINT(,) = INTERMEDIATE STACK OF PARTICLE COORDINATES
C  STEPFC      = STEP LENGTH FACTOR FOR ELECTRON MULTIPLE SCATTERING
C  STEPL       = STEP LENGTH FOR MUON TRANSPORT STEP
C  STERNCOR    = PARAMETER FOR STERNHEIMER CORRECTION (SEE SUBR. ELECTR)
C  STH(10)     = AGE IN STEPS OF 100 G/CM**2, SUM OVER ALL SHOWERS (NKG)
C  STHCPH      = SINTHE*COSPHI OF PRIMARY FOR PLANE NORM. TO SHOWER AXIS
C  STHSPH      = SINTHE*SINPHI OF PRIMARY FOR PLANE NORM. TO SHOWER AXIS

C
C  T           = CURPAR(6)

C  TAR         = NUMBER OF NUCLEONS IN TARGET (HDPM)
C  TARG1I      = TARGET OF FIRST INTERACTION
C  TBFAC       = ARRIVAL TIME SCALING FACTOR FOR BINNING
C  TBMAX       = MAXIMUM ARRIVAL TIME FOR TIME TABLE
C  TBMIN       = MINIMUM ARRIVAL TIME FOR TIME TABLE
C  TBOFF       = ARRIVAL TIME OFFSET         FOR BINNING
C  TB3         = TWO BY THREE = 2./3.

C  TIM(NP)     = TIME OF PARTICLE ON EGS STACK
C  THCKOB(..)  = LAYER THICKNESS AT OBSERVATION LEVEL (G/CM**2)
C  THETPR(2)   = RANGE OF THETA OF PRIMARY PARTICLE IN RADIAN
C  THETAP      = ACTUAL THETA OF PRIMARY PARTICLE IN RADIAN
C  THCKRL()    = ARRAY FOR THICKNESS TO PLANE NORMAL TO SHOWER AXIS
C  THICKA(..)  = THICKNESS OF AIR LAYER (EGS)
C  THICKD(..)  = THICKNESS OF AIR LAYER BELOW OBSERVATION LEVEL (EGS)
C  THICKH      = THICK(H) MASS OVERBURDEN OF ACTUAL PARTICLE ALTITUDE
C  THICKL(5)   = THICKNESS AT ATMOSPHERIC LAYER BOUNDARIES
C  THICKS(6)   = SLANT THICKNESS TOP OF ATMOSPHERE TO LAYER BOUNDARY
C  THICK0      = HEIGHT OF START OF PRIMARY (IN G/CM**2)
C  THINNING    = FLAG INDICATING THINNING FOR CURRENT INTERACTION

C  THSTEP      = STEP WIDTH IN G/CM**2 FOR LONGITUDINAL DISTRIBUTION
C  THSTPI      = 1/THSTEP

C  TIMLIM      = TIME LIMIT FOR PARTICLE SINCE 1. INTERACT (SEC)

C  TLEV(10)    = LEVELS IN NKG IN G/CM**2  (NKG)
C  TLEVCM(10)  = LEVELS IN NKG IN CM  (NKG)
C  TMARGIN     = FLAG INDICATING ARR. TIME ZERO AT ENTRANCE INTO ATMOSPHERE
C  TMAS(3000)  = TRANSVERSE MASS   OF SECONDARY PARTICLE IN HDPM

C  TOF(.,.)    = TIME OF FLIGHT OF CHERENKOV PHOTON
C  TSCAT       = SEE EQ. 2.14.82 IN SLAC-265

C  TSLANT(500) = SLANT THICKNESS  TOP OF ATMOSPHERE TO BIN
C  TSTEP       = DISTANCE TO NEXT INTERACTION
C  TUSTEP      = TOTAL (CURVED) STEP LENGTH REQUESTED
C  TVSTEP      = ACTUAL TOTAL STEP LENGTH
C  TWOM24      = 2**-24 (MANTISSA SINGLE PRECISION)
C  TWOM48      = 2**-48 (MANTISSA DOUBLE PRECISION)
C
C  U(NP)       = X DIRECTION COSINE OF PARTICLE ON EGS STACK
C  U()         = ARRAY(KSEQ) FOR RANDOM GENERATOR

C  UEMIS       = EMISSION ANGLE COSINES OF CHERENKOV PHOTONS

C  UL          = USED FOR PRIMARY ENERGY SELECTION
C  ULIMIT      = UPPER LIMIT OF ENERGY SECTION FOR PRIMARY (GEV)

C  UNI         = FINAL RANDOM NUMBER

C  USELOW      = FLAG INDICATING LOW ENERGY HADRONIC INTERACTION
C  USER        = NAME OF USER
C  USTEP       = USER STEP LENGTH REQUESTED
C  U1          = VARIABLE OF SUBROUT. RANNOR
C  U2          = VARIABLE OF SUBROUT. RANNOR
C
C  V(NP)       = Y DIRECTION COSINE OF PARTICLE ON EGS STACK

C  VEMIS       = EMISSION ANGLE COSINES OF CHERENKOV PHOTONS

C  VERDAT(.)   = DATE OF RELEASE OF VERSION
C  VERNUM      = VERSION NUMBER OF CORSIKA
C  VFRAC       = ENERGY FRACTION FOR SECONDARY IN MUON INTERACTION
C  VMAX        = MAX. VALUE OF ENERGY FRACTION FOR MUON INTERACT.
C  VMIN        = MIN. VALUE OF ENERGY FRACTION FOR MUON INTERACT.
C  VSCAT       = POLAR ANGLE OF MUON MULTIPLE SCATTERING
C  VSTEP       = ACTUAL STEP LENGTH

C  VUECON(2)   = RANGE OF VIEWING CONE AROUND FIXED THETA+PHI IN RADIAN

C
C  W(NP)       = Z DIRECTION COSINE OF PARTICLE ON EGS STACK

C  WA(NP)      = ANGLE PARTICLE TO MID DETECT AT CENTER EARTH (EGS)
C  WAP(NP)     = APPARENT ZENITH ANGLE IN CART.COORDINATE SYSTEM (EGS)

C  WAVLGL      = CHERENKOV WAVE LENGTH BAND LOWER END (NANOMETER)
C  WAVLGU      = CHERENKOV WAVE LENGTH BAND UPPER END (NANOMETER)

C  WCOMP       = ATOMIC FRACTION OF COMPONENT (GHEISHA)

C  WEMIS       = EMISSION ANGLE COSINES OF CHERENKOV PHOTONS
C  WL          = WAVELENGTH OF CHERENKOV PHOTON

C  WIDC2       = WIDTH OF GAUSSIAN FOR 1ST+2ND STRING (CHARGED) (HDPM)
C  WIDC3       = WIDTH OF GAUSSIAN FOR 3RD     STRING (CHARGED) (HDPM)
C  WIDN2       = WIDTH OF GAUSSIAN FOR 1ST+2ND STRING (NEUTRAL) (HDPM)
C  WIDN3       = WIDTH OF GAUSSIAN FOR 3RD     STRING (NEUTRAL) (HDPM)
C
C  X           = CURPAR(7)
C  X(NP)       = X COORDINATE OF PARTICLE ON EGS STACK

C  XCER        = X-DISTANCE FROM SHOWER AXIS AT DET.LEVEL FOR CHERENKOV
C  XCMAX       = MAX. EXTENSION OF ARRAY IN X DIRECTION
C  XCMAXS      = MAX. EXTENSION OF ARRAY IN X DIRECTION INCL. SCATTER
C  XOFF(..)    = OFFSET OF X COOR. FOR INCLINED SHOWERS AT OBS. LEVEL

C  XSCATT      = RANGE OF X SCATTER OF SHOWER CORE IN CM

C  XXOLD       = COORDINATE OF EM PARTICLE FOR SUBTRACT. FROM NKG (EGS4)
C
C  Y           = CURPAR(8)
C  Y(NP)       = Y COORDINATE OF PARTICLE ON EGS STACK

C  YCER        = Y-DISTANCE FROM SHOWER AXIS AT DET.LEVEL FOR CHERENKOV
C  YCMAX       = MAX. EXTENSION OF ARRAY IN Y DIRECTION
C  YCMAXS      = MAX. EXTENSION OF ARRAY IN Y DIRECTION INCL. SCATTER

C  YCM         = RAPIDITY OF CM SYSTEM IN LABORATORY  (HDPM)

C  YOFF(..)    = OFFSET OF Y COOR. FOR INCLINED SHOWERS AT OBS. LEVEL

C  YSCATT      = RANGE OF Y SCATTER OF SHOWER CORE IN CM

C  YR(3000)    = RAPIDITY  OF SECONDARY PARTICLE IN HDPM
C  YYOLD       = COORDINATE OF EM PARTICLE FOR SUBTRACT. FROM NKG (EGS4)
C  YY0         = RAPIDITY OF DIFFRACTIVE SYSTEM IN CMS (HDPM)
C
C  Z(NP)       = Z COORDINATE OF PARTICLE ON EGS STACK
C  ZALTIT      = STARTING ALTITUDE (EGS4)

C  ZAP(NP)     = APPARENT HEIGHT IN CARTESIAN COORDINATE SYSTEM (EGS)
C  ZATOM       = ATOMIC NUMBER OF TARGET FOR MUON INTERACTIONS

C  ZCOMP       = ATOMIC NUMBER OF COMPONENT (GHEISHA)

C  ZEL(10)     = USED FOR FLUCTUATION OF SEL(10)          (NKG)
C  ZELLG(10)   = USED FOR FLUCTUATION OF SELLG(10)

C  ZEMIS       = Z-COORDINATE OF EMISSION POINT

C  ZN          = CENTR. RAP. DENSITY FOR CALCULATION OF PT
C  ZNE(10)     = PARAMETER USED FOR LONGITUDINAL AGE CALCULATION (NKG)
C  ZSL(10)     = USED FOR FLUCTUATION OF STH(10))         (NKG)
C  ZZOLD       = COORDINATE OF EM PARTICLE FOR SUBTRACT. FROM NKG (EGS4)
C
C=======================================================================

       

       

       

       

*-- Author :    The CORSIKA development group   21/04/1994
C======================================================================

      PROGRAM AAMAIN

C-----------------------------------------------------------------------
C  MAIN PROGRAM
C
C  SIMULATION OF EXTENSIVE AIR SHOWERS
C  PREPARES INITIALIZATIONS
C  GENERATES SHOWERS IN THE SHOWER LOOP
C  TREATES PARTICLES IN THE PARTICLE LOOP
C  PERFORMS PRINTING OF TABLES AT END OF SHOWER AND AT END OF RUN
C-----------------------------------------------------------------------

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

c-----changed--add
c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
      parameter (xct=1)
      parameter (yct=2)
      parameter (zct=3)
      parameter (ctthet=4)
      parameter (ctphi=5)
      parameter (ctdiam=6)
      parameter (ctfoc=7)
c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c-----changed--add

c      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

      COMMON /CRATMOS2/HLAY,HLAY0,THICKL,LAYNO,LAYNEW
      DOUBLE PRECISION HLAY(6),HLAY0(5,0:9),THICKL(5)
      INTEGER          LAYNO(0:22)
      LOGICAL          LAYNEW
c-----changed--add
      logical       fmfb
c-----changed--add

c-----changed--add--trajectory
c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
      COMMON /CRTRAJ/  DECL,RA,TRAD,TYEAR,TMONTH,TDAY,THOUR,
     *                 TMINUTE,TSECOND,DURATION,TRAJLOGIC
      DOUBLE PRECISION DECL,RA,TRAD,trphip1,trthetap1
      INTEGER TYEAR,TMONTH,TDAY,THOUR,TMINUTE,TSECOND,
     *        DURATION,rngstep
      integer*8 trierr
      LOGICAL TRAJLOGIC
      data trierr/0/

c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c-----changed--add--trajectory


      COMMON /CRBUFFS/ RUNH,RUNE,EVTH,EVTE,DATAB,ARRAYLONG,LH
      INTEGER          MAXBUF,MAXLEN
      PARAMETER        (MAXLEN=16)

      PARAMETER        (MAXBUF=39*7)
      REAL             RUNH(MAXBUF),EVTH(MAXBUF),EVTE(MAXBUF),
     *                 RUNE(MAXBUF),DATAB(MAXBUF),ARRAYLONG(MAXBUF)
      INTEGER          LH
      CHARACTER*4      CRUNH,CRUNE,CEVTH,CEVTE,CLONG
      EQUIVALENCE      (RUNH(1),CRUNH), (RUNE(1),CRUNE)
      EQUIVALENCE      (EVTH(1),CEVTH), (EVTE(1),CEVTE)
      EQUIVALENCE      (ARRAYLONG(1),CLONG)

      COMMON /CRCHISTA/IHYCHI,IKACHI,IMUCHI,INNCHI,INUCHI,IPICHI,INECHI
      INTEGER          IHYCHI(124),IKACHI(124),IMUCHI(124),INNCHI(124),
     *                 INUCHI(124),IPICHI(124),INECHI(124)

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRCURVE/ CHAPAR,DEP,ERR,NSTP
      DOUBLE PRECISION CHAPAR(1200),DEP(1200),ERR(1200)
      INTEGER          NSTP

      COMMON /CRELADPM/ELMEAN,ELMEAA,IELDPM,IELDPA
      DOUBLE PRECISION ELMEAN(40),ELMEAA(40)
      INTEGER          IELDPM(40,13),IELDPA(40,13)

      COMMON /CRELASTY/ELAST
      DOUBLE PRECISION ELAST

      COMMON /CRGENER/ GEN,ALEVEL
      DOUBLE PRECISION GEN,ALEVEL

      COMMON /CRIRET/  IRET1,IRET2,IRETE
      INTEGER          IRET1,IRET2
      LOGICAL          IRETE

      COMMON /CRISTA/  IFINET,IFINNU,IFINKA,IFINPI,IFINHY,IFINOT
      INTEGER          IFINET,IFINNU,IFINKA,IFINPI,IFINHY,IFINOT

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRMAGNET/BX,BZ,BVAL,BNORMC,BNORM,COSB,SINB,BLIMIT
      DOUBLE PRECISION BX,BZ,BVAL,BNORMC,BNORM,COSB,SINB,BLIMIT

      COMMON /CRMPARTI/MPARTO
      DOUBLE PRECISION MPARTO(20,25),MPHOTO(20),MPOSIT(20),MELECT(20),
     *                 MNU(20),MMUP(20),MMUM(20),MPI0(20),MPIP(20),
     *                 MPIM(20),MK0L(20),MKPL(20),MKMI(20),MNEUTR(20),
     *                 MPROTO(20),MPROTB(20),MK0S(20),MHYP(20),
     *                 MNEUTB(20),MDEUT(20),MTRIT(20),MHELI3(20),
     *                 MALPHA(20),MOTHER(20),MMUOND
      EQUIVALENCE (MPARTO(1, 1),MPHOTO(1)), (MPARTO(1, 2),MPOSIT(1)),
     *            (MPARTO(1, 3),MELECT(1)), (MPARTO(1, 4),MNU(1))   ,
     *            (MPARTO(1, 5),MMUP(1))  , (MPARTO(1, 6),MMUM(1))  ,
     *            (MPARTO(1, 7),MPI0(1))  , (MPARTO(1, 8),MPIP(1))  ,
     *            (MPARTO(1, 9),MPIM(1))  , (MPARTO(1,10),MK0L(1))  ,
     *            (MPARTO(1,11),MKPL(1))  , (MPARTO(1,12),MKMI(1))  ,
     *            (MPARTO(1,13),MNEUTR(1)), (MPARTO(1,14),MPROTO(1)),
     *            (MPARTO(1,15),MPROTB(1)), (MPARTO(1,16),MK0S(1))  ,
     *            (MPARTO(1,18),MHYP(1))  , (MPARTO(1,19),MDEUT(1)) ,
     *            (MPARTO(1,20),MTRIT(1)) , (MPARTO(1,21),MHELI3(1)),
     *            (MPARTO(1,22),MALPHA(1)), (MPARTO(1,23),MOTHER(1)),
     *            (MPARTO(1,24),MMUOND)   , (MPARTO(1,25),MNEUTB(1))

      COMMON /CRMULT/  EKINL,MSMM,MULTMA,MULTOT
      DOUBLE PRECISION EKINL
      INTEGER          MSMM,MULTMA(40,13),MULTOT(40,13)

      COMMON /CRMUMULT/CHC,OMC,PHISCT,STEPL,VSCAT,FMOLI
      DOUBLE PRECISION CHC,OMC,PHISCT,STEPL,VSCAT
      LOGICAL          FMOLI

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRNCOUNT/NCOUN
      INTEGER          NCOUN(8)

      COMMON /CRNKGI/  SEL,SELLG,STH,ZEL,ZELLG,ZSL,DIST,
     *                 DISX,DISY,DISXY,DISYX,DLAX,DLAY,DLAXY,DLAYX,
     *                 OBSATI,RADNKG,RMOL,TLEV,TLEVCM,IALT
      DOUBLE PRECISION SEL(10),SELLG(10),STH(10),ZEL(10),ZELLG(10),
     *                 ZSL(10),DIST(10),
     *                 DISX(-10:10),DISY(-10:10),
     *                 DISXY(-10:10,2),DISYX(-10:10,2),
     *                 DLAX (-10:10,2),DLAY (-10:10,2),
     *                 DLAXY(-10:10,2),DLAYX(-10:10,2),
     *                 OBSATI(2),RADNKG,RMOL(2),TLEV(10),TLEVCM(10)
      INTEGER          IALT(2)

      COMMON /CRNKGS/  CZX,CZY,CZXY,CZYX,SAH,SL,ZNE
      DOUBLE PRECISION CZX(-10:10,2),CZY(-10:10,2),CZXY(-10:10,2),
     *                 CZYX(-10:10,2),SAH(10),SL(10),ZNE(10)

      COMMON /CRNPARTI/NPARTO,NPART2
      DOUBLE PRECISION NPARTO(20,25), NPART2(20,25),
     *                 NPHOTO(20),NPOSIT(20),NELECT(20),
     *                 NNU(20),NMUP(20),NMUM(20),NPI0(20),NPIP(20),
     *                 NPIM(20),NK0L(20),NKPL(20),NKMI(20),NNEUTR(20),
     *                 NPROTO(20),NPROTB(20),NK0S(20),NHYP(20),
     *                 NNEUTB(20),NDEUT(20),NTRIT(20),NHELI3(20),
     *                 NALPHA(20),NOTHER(20),NMUOND
      EQUIVALENCE (NPARTO(1, 1),NPHOTO(1)), (NPARTO(1, 2),NPOSIT(1)),
     *            (NPARTO(1, 3),NELECT(1)), (NPARTO(1, 4),NNU(1))   ,
     *            (NPARTO(1, 5),NMUP(1))  , (NPARTO(1, 6),NMUM(1))  ,
     *            (NPARTO(1, 7),NPI0(1))  , (NPARTO(1, 8),NPIP(1))  ,
     *            (NPARTO(1, 9),NPIM(1))  , (NPARTO(1,10),NK0L(1))  ,
     *            (NPARTO(1,11),NKPL(1))  , (NPARTO(1,12),NKMI(1))  ,
     *            (NPARTO(1,13),NNEUTR(1)), (NPARTO(1,14),NPROTO(1)),
     *            (NPARTO(1,15),NPROTB(1)), (NPARTO(1,16),NK0S(1))  ,
     *            (NPARTO(1,18),NHYP(1))  , (NPARTO(1,19),NDEUT(1)) ,
     *            (NPARTO(1,20),NTRIT(1)) , (NPARTO(1,21),NHELI3(1)),
     *            (NPARTO(1,22),NALPHA(1)), (NPARTO(1,23),NOTHER(1)),
     *            (NPARTO(1,24),NMUOND)   , (NPARTO(1,25),NNEUTB(1))

      COMMON /CROBSPAR/OBSLEV,THCKOB,XOFF,YOFF,HEIGHP,THETAP,PHIP,
     *                 THETPR,PHIPR,

     *                 VUECON,

     *                 NOBSLV
      DOUBLE PRECISION OBSLEV(20),THCKOB(20),XOFF(20),YOFF(20),
     *                 HEIGHP,THETAP,THETPR(2),PHIP,PHIPR(2)

      DOUBLE PRECISION VUECON(2)

      INTEGER          NOBSLV

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRPRIMSP/PSLOPE,LLIMIT,ULIMIT,LL,UL,SLEX,ISPEC
      DOUBLE PRECISION PSLOPE,LLIMIT,ULIMIT,LL,UL,SLEX
      INTEGER          ISPEC

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRECORD/IRECOR
      INTEGER          IRECOR

      COMMON /CRREJECT/AVNREJ,ALTMIN,ANEXP,THICKA,THICKD,CUTLN,EONCUT,

     *                 FNPRIM
      DOUBLE PRECISION AVNREJ(20),ALTMIN(20),ANEXP(20),THICKA(20),
     *                 THICKD(20),CUTLN,EONCUT

      LOGICAL          FNPRIM

      COMMON /CRRESON/ RDRES,RESRAN,IRESPAR
      DOUBLE PRECISION RDRES(2),RESRAN(100000)
      INTEGER          IRESPAR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSIGM/  SIGMA,SIGANN,SIGAIR,FRACTN,FRCTNO
      DOUBLE PRECISION SIGMA,SIGANN,SIGAIR,FRACTN,FRCTNO

      COMMON /CRSTACKF/STACKI,MSTACKP,MEXST,NSHIFT,NOUREC,ICOUNT,
     *                 NTO,NFROM
      INTEGER          MAXSTK

      PARAMETER        (MAXSTK = 17*256*2)
      DOUBLE PRECISION STACKI(MAXSTK)
      INTEGER          MSTACKP,MEXST,NSHIFT,NOUREC,ICOUNT,NTO,NFROM

      COMMON /CRSTATI/ SABIN,SBBIN,INBIN,IPBIN,IKBIN,IHBIN
      DOUBLE PRECISION SABIN(40),SBBIN(40)
      INTEGER          INBIN(40),IPBIN(40),IKBIN(40),IHBIN(40)

      INTEGER          IEBIN, ITBIN, IDBIN
      PARAMETER        (IEBIN=40,ITBIN=30,IDBIN=20)
      COMMON /CRTABLES/G_ARRAY, E_ARRAY, M_ARRAY,
     *                 EBOFF,EBFAC,TBOFF,TBFAC,DBOFF,DBFAC
      REAL             G_ARRAY(IEBIN,ITBIN,IDBIN)
      REAL             E_ARRAY(IEBIN,ITBIN,IDBIN)
      REAL             M_ARRAY(IEBIN,ITBIN,IDBIN)
      REAL             EBOFF,EBFAC,TBOFF,TBFAC,DBOFF,DBFAC
      REAL             EBMIN,EBMAX,TBMIN,TBMAX,DBMIN,DBMAX
      PARAMETER        (EBMIN=1.E-4,EBMAX=1.E4)
      PARAMETER        (TBMIN=10.,TBMAX=1.E4)
      PARAMETER        (DBMIN=5.E3,DBMAX=5.E5)

      COMMON /CRTHNVAR/STACKINT,

     *                 INT_ICOUNT,MODETHN,THINNING

      INTEGER          MAXICOUNT
      PARAMETER        (MAXICOUNT=200000)

      DOUBLE PRECISION STACKINT(0:16,MAXICOUNT)
      INTEGER          INT_ICOUNT,MODETHN
      LOGICAL          THINNING

      COMMON /CRTIMLIM/DSTLIM,TIMLIM
      DOUBLE PRECISION DSTLIM,TIMLIM

      COMMON /CRVERS/  VERNUM,MVDATE,VERDAT
      DOUBLE PRECISION VERNUM
      INTEGER          MVDATE
      CHARACTER*18     VERDAT

      COMMON /CRCEREN1/CERELE,CERHAD,ETADSN,WAVLGL,WAVLGU,CYIELD,
     *                 CERSIZ,CERNOR,LCERFI,LCERDB
      DOUBLE PRECISION CERELE,CERHAD,ETADSN,WAVLGL,WAVLGU,CYIELD,
     *                 CERSIZ,CERNOR
      LOGICAL          LCERFI,LCERDB

      COMMON /CRCEREN2/ACERX,ACERY,CERXOS,CERYOS,
     *                 DCERX,DCERXI,DCERY,DCERYI,EPSX,EPSY,FCERX,FCERY,
     *                 WL,XCMAX,XCMAXS,XSCATT,YCMAX,YCMAXS,YSCATT,
     *                 PHOTCM,XCER,YCER,UEMIS,VEMIS,WEMIS,CARTIM,
     *                 XEMIS,YEMIS,ZEMIS,XSTEP,YSTEP,ZSTEP,
     *                 XSTEP2,YSTEP2,ZSTEP2,

     *                 NCERX,NCERY,ICERML
      DOUBLE PRECISION ACERX,ACERY,CERXOS(20),CERYOS(20),
     *                 DCERX,DCERXI,DCERY,DCERYI,EPSX,EPSY,FCERX,FCERY,
     *                 WL,XCMAX,XCMAXS,XSCATT,YCMAX,YCMAXS,YSCATT
      DOUBLE PRECISION PHOTCM,XCER,YCER,UEMIS,VEMIS,WEMIS,CARTIM,
     *                 XEMIS,YEMIS,ZEMIS,XSTEP,YSTEP,ZSTEP,
     *                 XSTEP2,YSTEP2,ZSTEP2

      INTEGER          NCERX,NCERY,ICERML
c-----changed---add
      integer icerml1
c-----changed---add

      COMMON /CRCEREN3/CERCNT,DATAB2,NRECER,LHCER
      INTEGER          MAXBF2

      PARAMETER        ( MAXBF2 = 39 * 7 )

      DOUBLE PRECISION CERCNT
      REAL             DATAB2(MAXBF2)
      INTEGER          NRECER,LHCER

       
c----changed-add
c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
*keep,certel.
      common /certel/  cormxd,cord,coralp,ctpars,omega,
     +                 photn,photnp,phpt,pht,vphot,
     +                 vchi,veta,vzeta,vchim,vetam,vzetam,
     +                 lambda,mu,nu,nctels,ncph,phip1,thetap1
      double precision cormxd,cord,coralp,ctpars(40,7),omega(20,3,3),
     +                 photn(3),photnp(3),phpt(3),pht,vphot(3),
     +                 vchi(3),veta(3),vzeta(3),vchim,vetam,vzetam,
     +                 lambda,mu,nu
      integer          nctels,ncph(5)
      double precision xg,yg,zg,xgp,ygp,zgp,up,vp,wp,xpcut,ypcut,zpcut
      double precision thetap1,phip1
      equivalence (photn(1) ,xg)   ,(photn(2) ,yg)   ,(photn(3) ,zg)  ,
     +            (photnp(1),xgp)  ,(photnp(2),ygp)  ,(photnp(3),zgp),
     +            (phpt(1)  ,xpcut),(phpt(2)  ,ypcut),(phpt(3)  ,zpcut),
     +            (vphot(1) ,up)   ,(vphot(2) ,vp)   ,(vphot(3) ,wp)    

c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c     Angles for the "spinning" of a particle around the 
c     main axis of the CT
      common /spinang/ spinxi
      double precision spinxi
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c-----changed-add
       

       

       

       

      DOUBLE PRECISION JNBIN(40),JPBIN(40),JKBIN(40),JHBIN(40)
      DOUBLE PRECISION CHI2,FPARAM(6)
      DOUBLE PRECISION MPART2(20,25),MPHOT2(20),MPOSI2(20),MELEC2(20),
     *                 MNU2(20),MMUP2(20),MMUM2(20),MPI02(20),MPIP2(20),
     *                 MPIM2(20),MK0L2(20),MKPL2(20),MKMI2(20),
     *                 MNETR2(20),MPROT2(20),MPRTB2(20),MK0S2(20),
     *                 MHYP2(20),MNETB2(20),MDEUT2(20),MTRIT2(20),
     *                 MHEL32(20),MALPH2(20),MOTH2(20)
      EQUIVALENCE (MPART2(1, 1),MPHOT2(1)), (MPART2(1, 2),MPOSI2(1)),
     *            (MPART2(1, 3),MELEC2(1)), (MPART2(1, 4),MNU2(1))  ,
     *            (MPART2(1, 5),MMUP2(1)) , (MPART2(1, 6),MMUM2(1)) ,
     *            (MPART2(1, 7),MPI02(1)) , (MPART2(1, 8),MPIP2(1)) ,
     *            (MPART2(1, 9),MPIM2(1)) , (MPART2(1,10),MK0L2(1)) ,
     *            (MPART2(1,11),MKPL2(1)) , (MPART2(1,12),MKMI2(1)) ,
     *            (MPART2(1,13),MNETR2(1)), (MPART2(1,14),MPROT2(1)),
     *            (MPART2(1,15),MPRTB2(1)), (MPART2(1,16),MK0S2(1)) ,
     *            (MPART2(1,18),MHYP2(1)) , (MPART2(1,19),MDEUT2(1)),
     *            (MPART2(1,20),MTRIT2(1)), (MPART2(1,21),MHEL32(1)),
     *            (MPART2(1,22),MALPH2(1)), (MPART2(1,23),MOTH2 (1)),
     *            (MPART2(1,25),MNETB2(1))

      DOUBLE PRECISION THICK
      INTEGER          LPCT0,LPCT1,NSTEP1
      SAVE
      EXTERNAL         BLOCK1,EGS4BD,HEIGH,THICK
      DOUBLE PRECISION DL,FIXHAPP,THCKHN

      DOUBLE PRECISION THICKC
      EXTERNAL         THICKC

      LOGICAL          FLAGC
      DOUBLE PRECISION XVC1,XVC2,YVC1,YVC2,ZVC1,ZVC2

C  VARIABLES BEING USED FOR RUNTIME
      REAL             TDIFF
      INTEGER          ILEFTA,ILEFTB,TIME
      EXTERNAL         TIME
C-----------------------------------------------------------------------

      CERELE = 0.D0
      CERHAD = 0.D0
      NRECER = 0

C  INITIALIZE AND READ RUN STEERING CARDS
      CALL START

      IF ( CERSIZ .LE. 0.D0 ) THEN
        ICRSIZ = 0
      ELSE
        ICRSIZ = 1
      ENDIF
c-----changed
      icerml1=0
c-----changed

C  RESET COUNTER FOR WORDS WRITTEN TO TAPE
      IRECOR = 0

C  RESET COUNTER FOR AVERAGE HEIGHT OF 1ST INTERACTION
      CHISUM = 0.D0
      CHISM2 = 0.D0

C  SET ARRAYS FOR SCALES OF KINETIC ENERGY-INTERACTION TABLE
      SABIN(1) = 0.D0
      SBBIN(1) = 0.1D0
      DO  J = 2, 40
        SABIN(J) = 10.D0**((J-5.D0)/3.D0)
        SBBIN(J) = 10.D0**((J-4.D0)/3.D0)
      ENDDO

     
c--------trajectory changed-------------------
      if ( trajlogic ) then
C  get real zenith and azimuth ranges
C  rngstep: get one evaluation per minute (duration in seconds)
        rngstep = dble(duration)/60.
        thetmin=70.
        thetmax=0.
c        phimin=0.
        phimin=360.
        phimax=0.
        do  j = 1, rngstep 
           call sourcepath(rngstep,trthetap1,trphip1,trierr)
           write (21,*) j,trthetap1,trphip1
         
           if (trierr.gt.0) then
            print *, "Problems with Subroutine SOURCEPATH" ,trierr
            stop
           endif


           if ( trthetap1 .lt. thetmin ) thetmin=trthetap1
           if ( trthetap1 .gt. thetmax ) thetmax=trthetap1
           if ( trphip1 .lt. phimin ) phimin=trphip1
           if ( trphip1 .gt. phimax ) phimax=trphip1
        enddo
C  convert from rad to degree and assign to corsika variables

ccc changed for test 14.08.09, must not be commented out under normal circumstances
        thetpr(1) = thetmin*90./asin(1.)
        thetpr(2) = thetmax*90./asin(1.)
        phipr(1) = phimin*90./asin(1.)
        phipr(2) = phimax*90./asin(1.)
      endif              
c--------------------------------------------

C  CHECK AND SET PRIMARY PARAMETERS
c-----changed
      CALL INPRM(icerml1)
c-----changed


C  INITIALIZE NKG ROUTINES
      CALL ININKG

C  RESET COUNTERS FOR NUCLEON, PION AND KAON TABLE FOR ALL SHOWERS
C  RESET ENERGY-MULTIPLICITY & ENERGY-ELASTICITY MATRIX FOR ALL SHOWERS
      DO  J = 1, 40
        JNBIN(J)  = 0.D0
        JPBIN(J)  = 0.D0
        JKBIN(J)  = 0.D0
        JHBIN(J)  = 0.D0
        ELMEAA(J) = 0.D0
        DO  L = 1, 13
          MULTOT(J,L) = 0
          IELDPA(J,L) = 0
        ENDDO
      ENDDO
C  RESET STACKINT
      DO  J = 1, MAXICOUNT
        DO  K = 0, MAXLEN
          STACKINT(K,J) = 0.D0
        ENDDO
      ENDDO

C  RESET ARRAYS FOR INTERACTION LENGTH STATISTICS
      DO  J = 1, 124
        IHYCHI(J) = 0
        IKACHI(J) = 0
        IMUCHI(J) = 0
        INUCHI(J) = 0
        IPICHI(J) = 0
        INNCHI(J) = 0
      ENDDO

C  RESET ARRAY FOR MEAN VALUES AND STANDARD DEVIATION
      DO  K = 1, 25
        DO  J = 1, 20
          MPARTO(J,K) = 0.D0
          MPART2(J,K) = 0.D0
        ENDDO
      ENDDO

C  RESET ARRAYS FOR AVERAGE LONGITUDINAL DISTRIBUTION
      IF ( LLONGI ) THEN
        LPCT0 = NSTEP
        LPCT1 = 1

        NSTEP1 = NSTEP

        DO  J = 0, NSTEP1
          DO  K = 1, 10
            AELONG(J,K) = 0.D0
            APLONG(J,K) = 0.D0
            SELONG(J,K) = 0.D0
            SPLONG(J,K) = 0.D0

          ENDDO
          DO  K = 1, 19
            ADLONG(J,K) = 0.D0
            SDLONG(J,K) = 0.D0
          ENDDO
        ENDDO
      ENDIF

C  STEERING OF PRINTOUT OF RANDOM GENERATOR SEEDS
      IPROUT = MIN( 100, NSHOW/20 )
      IPROUT = MAX( 1, IPROUT )

C  TIME AT BEGINNING

      ILEFTA = TIME()
C-----------------------------------------------------------------------
C  LOOP OVER SHOWERS
      DO  2 ISHW = 1, NSHOW

        ISHOWNO = ISHOWNO + 1
        I       = ISHW
        IF ( ISHW .LE. MAXPRT ) THEN
          FPRINT = .TRUE.
        ELSE
          FPRINT = .FALSE.
        ENDIF

C  FIRST INTERACTION DATA
        FIRSTI = .TRUE.
        IFINET = 0
        IFINNU = 0
        IFINKA = 0
        IFINPI = 0
        IFINHY = 0
        ELAST  = 0.D0
        THICK1 = 0.D0
        TARG1I = 0.D0
        SIGAIR = 0.D0
        SIG1I  = 0.D0

C  RESET COUNTERS
        DO  K = 1, 25
          DO  J = 1, 20
            NPARTO(J,K) = 0.D0
            NPART2(J,K) = 0.D0
          ENDDO
        ENDDO

        NRECS = 0
        NBLKS = 0
        DO  KKK = 1, 20
          AVNREJ(KKK) = 0.D0
        ENDDO
        IRESPAR = 0

C  RESET COUNTERS FOR NUCLEON, PION AND KAON TABLE FOR SHOWER
C  RESET ENERGY-MULTIPLICITY & ENERGY-ELASTICITY MATRIX FOR SHOWER
        DO  J = 1, 40
          INBIN(J) = 0
          IPBIN(J) = 0
          IKBIN(J) = 0
          IHBIN(J) = 0
          ELMEAN(J) = 0.D0
          DO  L = 1, 13
            MULTMA(J,L) = 0
            IELDPM(J,L) = 0
          ENDDO
        ENDDO

C  RESET PARTICLE TABLES
        IF ( FTABOUT ) THEN
          DO  IIE = 1, IEBIN
            DO  IIT = 1, ITBIN
              DO  IID = 1, IDBIN
                G_ARRAY(IIE,IIT,IID) = 0.
                E_ARRAY(IIE,IIT,IID) = 0.
                M_ARRAY(IIE,IIT,IID) = 0.
              ENDDO
            ENDDO
          ENDDO
        ENDIF

C  INITIALIZE PARTICLE STACK
        CALL ISTACK
        IRET1 = 0

C  INITIALIZE EVENT HEADER AND END FOR EACH EVENT
        DO  L = 2, 43
          EVTH(L) = 0.
        ENDDO

        DO  L = 2, MAXBUF
          EVTE(L) = 0.
        ENDDO

C  SHOWER BEGIN PRINTOUT
        IF ( FPRINT  .OR.  DEBUG ) WRITE(MONIOU,105) ISHOWNO
 105    FORMAT ('1',10('='),' SHOWER NO ',I10,' ',47('=')/)

C  RANDOM GENERATOR STATUS AT BEGINNING OF SHOWER CALCULATION
        EVTH(13) = NSEQ
        DO  L = 1, NSEQ
          CALL RMMAQD( ISEED(1,L),L,'R' )
C  SEED
          EVTH(11+L*3) = ISEED(1,L)
C  NUMBER OF CALLS
          EVTH(12+L*3) = MOD( ISEED(2,L), 1000000 )
C  NUMBER OF MILLIONS
          EVTH(13+L*3) = ISEED(3,L)*1000 + INT( ISEED(2,L)/1000000 )
        ENDDO
        IF ( FPRINT  .OR.  DEBUG  .OR.  MOD(ISHW-1,IPROUT) .EQ. 0 ) THEN
          CALL PRTIME( TTIME )
          WRITE(MONIOU,158) ISHOWNO,(L,(ISEED(J,L),J=1,3),L=1,NSEQ)
 158      FORMAT(' AND RANDOM NUMBER GENERATOR AT BEGIN OF EVENT :',I8,
     *            /,(' SEQUENCE = ',I2,'  SEED = ',I9 ,'  CALLS = ',I9,
     *               '  BILLIONS = ',I9))
        ENDIF
C  RESET KNOR
        KNOR = .TRUE.
C  GET FULL RANDOM GENERATOR STATUS (103 WORDS PER SEQUENCE)
CC      DO  495  L = 1, NSEQ
CC        CALL RMMAQD( ISEED(1,L),L,'RV' )
CC495   CONTINUE

C  GET PRIMARY ENERGY INTO PRMPAR(1)
        IF ( ISPEC .EQ. 0 ) THEN
          PRMPAR(1) = LLIMIT
        ELSE
          CALL RMMARD( RD,1,1 )
          IF ( PSLOPE .NE. -1.D0 ) THEN
            PRMPAR(1) = ( RD(1)*UL + ( 1.D0-RD(1) )*LL )**SLEX
          ELSE
            PRMPAR(1) = LLIMIT * LL**RD(1)
          ENDIF
          IF ( FPRINT  .OR.  DEBUG  .OR.  MOD(ISHW-1,IPROUT) .EQ. 0 )
     *       WRITE(MONIOU,*) 'PRIMARY ENERGY = ',PRMPAR(1),' GEV'
        ENDIF
C  IF YOU WANT TO USE KINETIC ENERGY IN PRIMARY SPECTRUM
C  YOU HAVE TO ADD THE PRIMARY''S REST MASS:
cc       PRMPAR(1) = PRMPAR(1) + PAMA(NINT( PRMPAR(0) ))


C  GET PRIMARY ANGLES OF INCIDENCE
C>>>>>>>>>changed trajectory >>>>>>>>>>>>>>>>>>>>>>>>>>
        if ( trajlogic ) then

          call sourcepath(nshow,thetap,phip,trierr)

          if (trierr.gt.0) then
           print *, "Problems with Subroutine SOURCEPATH" ,trierr
           stop
          endif

          prmpar(2) = cos(thetap)
          prmpar(15) = cos(thetap) 
       else       
C>>>>>>>>>>changed trajectory>>>>>>>>>>>>>>>>>>>>>>>>>>

        IF ( FIXINC ) THEN
C  PRIMARY ANGLE FIXED
          THETAP = THETPR(1)
          PHIP   = PHIPR(1)

          IF ( VUECON(2) .GT. 0.D0 ) THEN
C  THROW UNIFORMLY DISTRIBUTED DIRECTION IN VIEWING CONE OR CONE RING
C  FOR NOW

   46       CALL RMMARD( RD,3,1 )

            CT1 = COS( VUECON(1) )
            CT2 = COS( VUECON(2) )
            CTT = RD(2) * ( CT2 - CT1 ) + CT1
            THETAP = ACOS( CTT )
            PHIP = RD(1) * PI2
C  TEMPORARY CARTESIAN COORDINATES
            XVC1 = COS( PHIP )*SIN( THETAP )
            YVC1 = SIN( PHIP )*SIN( THETAP )
            ZVC1 = COS( THETAP )
C  ROTATE AROUND Y AXIS
            XVC2 = XVC1*COS( THETPR(1) ) + ZVC1*SIN( THETPR(1) )
            YVC2 = YVC1
            ZVC2 = ZVC1*COS( THETPR(1) ) - XVC1*SIN( THETPR(1) )

C  FOR A HORIZONTAL TARGET, THE COS(THETA) WEIGHT IS OBTAINED BY
C  THROWING THE DICE ANOTHER TIME.
            IF ( RD(3) .GT. ZVC2 ) GOTO 46

            THETAP = ACOS( ZVC2 )

            IF ( THETAP .GT. 88.D0*(PI/180.D0) ) GOTO 46

            PHIP = ATAN2(YVC2,XVC2) + PHIPR(1)
            IF ( PHIP .GT. PI2  ) PHIP = PHIP - PI2
            IF ( PHIP .LT. 0.D0 ) PHIP = PHIP + PI2
          ENDIF

C  COSINE OF APPARENT ZENIT ANGLE IS PUT IN PRMPAR(15)
C  (COSINE OF LOCAL ZENIT ANGLE IS IN PRMPAR(2))
          PRMPAR(15) = COS( THETAP )

        ELSE
C  CHOOSE ANGLES AT RANDOM WITH EQUAL FLUX FOR ALL DIRECTIONS
C  WITH HORIZONTAL DETECTOR ARRAY (SEE: O.C. ALLKOFER & P.K.F. GRIEDER,
C  COSMIC RAYS ON EARTH, IN: PHYSICS DATA 25/1, H.BEHRENS & G.EBEL ED.,
C  (FACHINFORMATIONSZENTRUM KARLSRUHE, GERMANY, 1983) CHPT. 1.1.2)
           CALL RMMARD( RD,3,1 )
           CT1 = SIN( THETPR(1) )**2
           CT2 = SIN( THETPR(2) )**2
           CTT = SQRT( 1.D0 - RD(2)*(CT2 - CT1) - CT1 )

           THETAP = ACOS( CTT )

          PHIP   = RD(1) * ( PHIPR(2) - PHIPR(1) ) + PHIPR(1)

C  CALCULATION IS THE SAME AS IN THE CASE OF A FLAT ATMOSPHERE BECAUSE
C  FOR THIS CALCULATION THE APPARENT ANGLES AT DETECTOR ARE NEEDED.
C  COSINE OF APPARENT ZENITH ANGLE IS PUT IN PRMPAR(15) = COSTAP
          PRMPAR(15) = CTT
        ENDIF
       
C>>>>>>>>>changed trajectory >>>>>>>>>>>>>>>>>>>>>>>>>>

        ENDIF
C >>>>>>>>>>changed trajectory>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>


        IF ( FPRINT  .OR.  DEBUG  .OR.  MOD(ISHW-1,IPROUT) .EQ. 0 ) THEN

          IF ( VUECON(2) .GT. 0.D0 ) WRITE(MONIOU,669) THETAP,PHIP
          print *,"thetap,phip"
          print *,thetap,phip
 669      FORMAT(' PRIMARY ANGLES (RAD) ARE: THETA = ',F6.4,
     *           ' RAD  AND ',' PHI = ',F7.4,' RAD')
        ENDIF

C  DEFINE HEIGHT FOR START AT THICK0 (IN G/CM**2)
C  WHICH IS 112.8 KM FOR THICK0 = 0
        PRMPAR(5) = HEIGH( THICK0 )

        IF ( LLONGI ) LPCT0 = MIN( INT( THICK0*THSTPI ), LPCT0 )

C  COUNTER FOR PARTICLE OUTPUT
        LH = 0

C  RESET GENERATION COUNTER
        GEN = 0.D0
C  CALCULATE COORDINATE CORRECTION FOR TOP OF ATMOSPHERE
C  ALL CALCULATIONS FOR  CURPAR ARE MADE IN COOINC
C  (COSTHE, HAPP, COSTEA). (X, Y) FOR SHOWER CORE = (0,0)
        H = PRMPAR(5)
        CURPAR(15) = PRMPAR(15)
        CALL COOINC

C  RESET ARRAY FOR LONGITUDINAL DISTRIBUTION PER SHOWER
        IF ( LLONGI ) THEN
          DO  K = 1, 10
            DO  J = 0, NSTEP1
              ELONG(J,K) = 0.D0
              PLONG(J,K) = 0.D0

            ENDDO
          ENDDO
          DO  K = 1, 19
            DO  J = 0, NSTEP1
              DLONG(J,K) = 0.D0
            ENDDO
          ENDDO
        ENDIF

C  COUNTER FOR CHERENKOV OUTPUT
        IF ( LCERFI ) LHCER = 0
C  CALCULATE BUNCH SIZE FOR CHERENKOV PHOTONS IF NOT SET IN DATAC
        IF ( ICRSIZ .EQ. 0 ) THEN
          CALL GETBUS( NINT(PRMPAR(0)),PRMPAR(1),PRMPAR(2),CERSIZ )
          IF ( FPRINT  .OR.  DEBUG ) WRITE(MONIOU,*)
     *             'CHERENKOV BUNCH SIZE IS CALCULATED TO=',CERSIZ
        ENDIF

        IF ( ICERML .GE. 1 ) THEN
c-----changes--add 
           if (icerml1.ge.21) then
          DO  III = 1, ICERML
            CALL SELCOR( CERXOS(III),CERYOS(III) )
c            WRITE(MONIOU,4437) ISHW,III,CERXOS(III),CERYOS(III)
 4437       FORMAT(' CORE OF EVENT ',I5,' (SCATT# ',I2,
     *             ') AT ',F12.2,9X,F12.2,' CM')
          ENDDO
          else
c----add (simulation of the axis core)
          DO 4438  III = 1,ICERML

 5226     CALL RMMARD( RD,2,3 )
c-- the part of core simulation from AM 

          if(yscatt.eq.xscatt) then
             r=xscatt
          phip1= pi2*rd(2)
          xx = r*dcos(phip1)/dcos(thetap)
          yy = r*dsin(phip1)

             else
          r = xscatt**2+rd(1)*(yscatt**2-xscatt**2)          
          phip1= pi2*rd(2)
          xx = dsqrt(r)*dcos(phip1)/dcos(thetap)
          yy = dsqrt(r)*dsin(phip1)
          endif
	 cerxos(iii)=xx*dcos(phip)-yy*dsin(phip)
	 ceryos(iii)=xx*dsin(phip)+yy*dcos(phip)
c            WRITE(MONIOU,4437) ISHW,III,CERXOS(III),CERYOS(III)
4438     CONTINUE

          endif
c-----changes--add 
        ENDIF
        DO  III = 1, 20
          EVTH( 98+III) = CERXOS(III)
          EVTH(118+III) = CERYOS(III)
        ENDDO

C  GET GAMMA FACTOR FROM ENERGY
C  FOR  MASSLESS PRIMARIES  PRMPAR(1) STAYS = ENERGY
        IF ( PAMA(NINT( PRMPAR(0) )) .NE. 0.D0 ) THEN
          PRMPAR(1) = PRMPAR(1) / PAMA(NINT( PRMPAR(0) ))
          IF ( PRMPAR(1) .LE. 1.D0 ) THEN
            WRITE(MONIOU,*) 'GAMMA FACTOR ',SNGL(PRMPAR(1)),
     *                      ' OF PRIMARY IS TOO LOW'
            WRITE(MONIOU,*)
            WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
            WRITE(MONIOU,*) 'SEE KEYWORD: ERANGE'
            STOP
          ENDIF
        ENDIF

C  SET PRIMARY TO CURRENT PARTICLE
        DO  J = 0, 8
          CURPAR(J) = PRMPAR(J)
        ENDDO
        DO  J = 1, 8
          NCOUN(J)  = 0
        ENDDO

C  CALCULATE FIRST INTERACTION POINT IF HADRONIC
        H = HEIGH( THICK0 )
        CALL BOX2
        IF ( FIX1I ) THEN

C  CALCULATE GEOMETRIC PATH LENGTH TO FIXED FIRST INTERACTION POINT IN
C  DETECTOR FRAME (DUE TO DIFFERENCES IN H AND FIXHEI (POSSIBLY VERY
C  DIFFERENT COORDINATE FRAMES) AND TAKE NRANGC FOR GETTING CHI IN A
C  CURVED ATMOSPHERE
          DIAG = SQRT( (C(1)+FIXHEI)**2 - (C(1)+OBSLEV(1))**2
     *                          * (1.D0-PRMPAR(15))*(1.D0+PRMPAR(15)) )
     *           - (C(1)+OBSLEV(1))*PRMPAR(15)

          FIXHAPP = OBSLEV(1) + DIAG * PRMPAR(15)
          DL = (HAPP - FIXHAPP) / PRMPAR(15)
C  SET TIME LIMIT TO AVOID UNNECESSARY COMPUTING TIME WITH PARTICLES
C  WELL ABOVE THE TIME LIMIT. THE TIME LIMIT IS GIVEN BY THE 
C  PROPAGATION TIME ALONG DIAD WITH SPEED OF LIGHT AND SOME ADDITIONAL
C  DISTANCE DOWNSTREAM OF THE DETECTOR DLIMIT (CM).
C  FOR SAFETY ADD ADDITIONAL 20 MICROSEC. (ALL TIME UNITS IN SEC)
          IF ( DSTLIM .GT. 0.D0 ) THEN
            TIMLIM = ( DIAG + DSTLIM ) / C(25) + 2.D-5
          ELSE
C  DEFAULT LIMIT IS 20 KM  
            TIMLIM = ( DIAG + 20.D5 ) / C(25) + 2.D-5
          ENDIF
          CALL NRANGC( DL )

          H = FIXHEI
C  FIRST INTERACTION IS NOT DECAY ONLY FOR HADRONS
          IF ( PRMPAR(0) .GE. 7 ) THEN
            FDECAY = .FALSE.
          ENDIF

        ELSE
C  CHI IS GIVEN BY BOX2

          THICKH = THICK0
          THCKHN = THICKC( CHI )

C  STARTING ALTITUDE MUST BE INSIDE ATMOSPHERE
          H = HEIGH( THCKHN )
          H = MAX( H, HLAY(1) + 100.D0 )
          H = MIN( H, HLAY(6) - 1.D0 )
        ENDIF
        HEIGHP = H
        THICK1 = THICK( H )
        IF ( CURPAR(0) .GT. 3.D0  .OR.  .NOT. FEGS ) THEN
          CHISUM = CHISUM + THICK1
          CHISM2 = CHISM2 + THICK1**2
        ENDIF
        ALEVEL = H

C  STORE PRIMARY COORDINATES FOR ADDITIONAL MUON INFORMATION
        IF ( FMUADD ) THEN
          IF ( CURPAR(0) .EQ. 5  .OR.  CURPAR(0) .EQ. 6 ) THEN
            DO  J = 0, MAXLEN
              AMUPAR(J) = CURPAR(J)
            ENDDO
            AMUPAR(5) = PRMPAR(5)
            IF ( DEBUG ) WRITE(MDEBUG,*) 'AAMAIN: MUON STORED IN AMUPAR'
            FMUORG = .TRUE.
          ELSE
            FMUORG = .FALSE.
          ENDIF
        ENDIF

C  SET TARGET FLAG IF SELECTED FOR FIRST INTERACTION
        IF ( N1STTR .GT. 0  .AND.  PRMPAR(0) .GT. 3.D0 ) THEN
          FIXTAR  = .TRUE.
          FDECAY  = .FALSE.
          EVTH(6) = REAL(N1STTR)
        ELSE
          FIXTAR  = .FALSE.
          EVTH(6) = 0.
        ENDIF

C  INITIALIZE ARRAYS FOR NKG FOR EACH SHOWER
        IF ( FNKG ) CALL STANKG

C  STORE FIRST PARTICLE IN HEADER AND PRINT IT OUT
        EVTH( 2) = REAL(ISHOWNO)
        EVTH( 3) = PRMPAR(0)
        IF ( PAMA(NINT( PRMPAR(0) )) .EQ. 0.D0 ) THEN
C  PRIMARY ENERGY FOR MASSLESS PARTICLES (GAMMAS, NEUTRINOS)
          E00   = PRMPAR(1)
          E00PN = PRMPAR(1)
          INUCL = 1
        ELSE
          E00   = PRMPAR(1) * PAMA(NINT( PRMPAR(0) ))
          INUCL = INT( MAX( 1.D0, PRMPAR(0)/100.D0 ) )
          E00PN = E00 / INUCL
        ENDIF
        EVTH(148) = 0.
        EVTH(149) = 0.
        EVTH(150) = 0.
        EVTH(151) = 0.
        EVTH(152) = 0.

        IF ( FEGS ) THEN
C  PARAMETER FOR ELECTRON AND GAMMA REJECT (CONVERT ENERGY TO MEV)
C  TO BE USED WITH SPITZER ALGORITHM
CDH       EONCUT = .5D-9 * SQRT( E00*1000.D0 )
C  LIMITATION OF ENERGY DEPENDENCE TO VALUES BELOW 100 TEV
          EONCUT = .5D-9 * SQRT( MIN( E00*1000.D0, 1.D8 ) )
          CUTLN  = LOG(EONCUT)
        ENDIF
        EVTH( 4) = E00
        EVTH( 5) = THICK0
        EVTH( 7) = HEIGHP

        PTOT0    = SQRT( (E00-PAMA(NINT( CURPAR(0) )))
     *                  *(E00+PAMA(NINT( CURPAR(0) ))) )

        PTOT0N   = PTOT0 / INUCL
C  PUT APPARENT ANGLES (SEEN FROM DETECTOR) INTO EVENT HEADER
        ST       = SQRT( (1.D0-COSTAP) * (1.D0+COSTAP) )
        EVTH(10) = PTOT0 * COSTAP
        THETA    = ACOS( COSTAP )
        EVTH( 8) = PTOT0 * PHIX
        EVTH( 9) = PTOT0 * PHIY
        EVTH(11) = THETA
        IF ( PHIX .NE. 0.D0  .OR.  PHIY .NE. 0.D0 ) THEN
          EVTH(12) = SNGL( ATAN2(  PHIY,PHIX ) )
        ELSE
          EVTH(12) = 0.
        ENDIF

C  WRITE ENERGY AND ANGLES OF PRIMARY TO DBASE FILE FOR THE FIRST SHOWER
        IF ( FDBASE  .AND.  ISHW .EQ. 1 ) THEN
          WRITE(MDBASE,668) E00, THETA*180.D0/PI, EVTH(12)*180.D0/PI

 668      FORMAT(1P,'#energy_prim#',E14.7,'#theta_prim#',E14.7,
     *           '#phi_prim#',E14.7)

          CLOSE(UNIT=MDBASE)
        ENDIF

        EVTH(85) = CERSIZ

        IF ( DEBUG  .OR.  FPRINT ) THEN
          WRITE(MONIOU,*)
          IF ( TMARGIN ) THEN
            WRITE(MONIOU,*) 'TRACKING STARTS AT MARGIN OF ATMOSPHERE'
          ELSE
            WRITE(MONIOU,*) 'TRACKING STARTS AT FIRST INTERACTION'
          ENDIF
        ENDIF

        IF ( PRMPAR(0) .GT. 3.D0 ) THEN
          IF ( DEBUG ) THEN
            WRITE(MONIOU,102) (CURPAR(J),J = 0,8)
 102        FORMAT (' PRIMARY PARAMETERS AT FIRST INTERACTION POINT'/
     *               16X,1P,9E11.3)
          ELSEIF ( FPRINT ) THEN
            WRITE(MONIOU,1021) (CURPAR(J),J = 0,8)
 1021     FORMAT (' PRIMARY PARAMETERS AT FIRST INTERACTION POINT'/
     *               1X,1P,9E11.3)

          ENDIF
        ELSE
          IF ( FPRINT  .OR.  DEBUG ) WRITE(MONIOU,132)
 132      FORMAT (/' PRIMARY PARTICLE IS ELECTROMAGNETIC')
        ENDIF

C  WRITE EVENT HEADER INTO BUFFER

C  FOR EM PARTICLES EVTH IS WRITTEN TO BUFFER IN EGS (IF ACTIVE)
        IF ( EVTH(3) .GT. 3.0  .OR.  .NOT. FEGS ) THEN

C  NEGATIVE FIRST INTERACTIN HEIGHT, IF TRACKING STARTS AT ATMOS. MARGIN
c-----changed - commented one line
c          IF ( TMARGIN ) EVTH(7) = -EVTH(7)
c-----changed 

          CALL TOBUF( EVTH,0 )

          IF ( LCERFI ) CALL TOBUFC( EVTH,0 )

        ENDIF

C  PRINT HEADER FOR HIGH ENERGY PARTICLES
        IF ( FPRINT  .OR.  DEBUG ) WRITE(MONIOU,103)

 103    FORMAT(/'                    TYPE       GAMMA    COSTHETA ',
     *     '     PHIX      PHIY      HEIGHT      TIME       X-CM  ',
     *     '     Y-CM    GEN/CHI ALEVEL E ON STACK'/)

        NOPART = 0

        IF ( PRMPAR(0) .LE. 3.D0  .OR.
     *      (PRMPAR(0) .EQ. 5.D0  .OR.  PRMPAR(0) .EQ. 6.D0) ) THEN
C  GIVE PARTICLE TO EGS OR NKG IF ELECTROMAGNETIC
C  AND TAKE THEN NEXT PARTICLE FROM STACK
C  FLAG FOR NO PRIMARY INTERACTION IS SET FOR ALL BUT ELM. PRIMARIES
          IF ( PRMPAR(0) .LE. 3.D0 ) THEN
C  EM PARTICLES
            BNORMC = BNORM*1.D-3
            FNPRIM = .FALSE.

          ELSE
C  MUONS
            FNPRIM = .TRUE.
            H      = PRMPAR(5)
            IF ( TMARGIN ) BNORMC = BNORM*1.D-3
          ENDIF
c-----changed--add
          fmfb=.true.
          CALL BOX3(fmfb)
          fmfb=.false.
c-----changed--add
          BNORMC = BNORM*1.D-3
          IF ( FEGS ) THEN
            CHISUM = CHISUM + THICK( ABS(DBLE(EVTH(7))) )
            CHISM2 = CHISM2 + THICK( ABS(DBLE(EVTH(7))) )**2
          ENDIF
          FIRSTI = .FALSE.
          GOTO 4

        ELSEIF ( CURPAR(0) .GE. 50  .AND.  CURPAR(0) .LE. 65 ) THEN
C  RESONANCES ARE ILLEGAL PRIMARY PARTICLES
          WRITE(MONIOU,*)
          WRITE(MONIOU,*) 'AAMAIN: UNEXPECTED PARTICLE TYPE=',ITYPE
          WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
          WRITE(MONIOU,*) 'SEE KEYWORD: PRMPAR'
          STOP
        ELSE
C  HADRONIC PARTICLES
          FNPRIM = .TRUE.
C  CHECK OBSERVATION LEVEL PASSAGE AND UPDATE PARTICLE COORDINATES
          HNEW   = H
C  FOR SUBR. UPDATE WE NEED THE START ALTITUDE H
          H      = HEIGH( THICK0 )

C  TRACK THE PARTICLE WHEN ENTERING THE ATMOSPHERE
          FLAGC  = .FALSE.
c--changed---add
          fmfb=.true.
          CALL UPDATC(IPAS,FLAGC,fmfb)
          fmfb=.false.
c--changed---add

          IF ( IRET2 .NE. 0 ) GOTO 4
          IF ( IPAS .EQ. 0 ) THEN
CDH   25.04.2003
*           THICK1 = THICK( H )
C  PARTICLE DID NOT REACH OBSERVATION LEVEL
C  START CLOCK AT DFIRST INTERACTION (MAGNETIC FIELD IS SET IN INPRM)
*           CURPAR(6) = 0.D0
C  CLOCK HAS BEEN STARTED AT TOP OF ATMOSPHERE
C  JUMP INTO NORMAL PARTICLE TREATMENT FOR HADRONS
            GOTO 6
          ENDIF

          IF ( DEBUG ) WRITE(MDEBUG,*)
     *       'AAMAIN: PRIMARY REACHED LOWEST OBSERVATION LEVEL'
          GOTO 4
        ENDIF

C-----------------------------------------------------------------------
C  NORMAL CYCLE
  7     CONTINUE

C  IF ENERGY IS TOO SMALL, TAKE NEXT PARTICLE BY JUMP TO LABEL 4
        IF ( GAMMA .LE. 1.D0 ) THEN

          IF ( CURPAR(0) .NE. 1.D0 ) THEN

            IF ( CURPAR(0) .EQ. 5.D0  .OR.  CURPAR(0) .EQ. 6.D0 )
     *                                                 FMUORG = .FALSE.
            IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

              LHEIGH = INT( THICK( H )*THSTPI + 1.D0 )

              IF     ( ITYPE .EQ. 2                      ) THEN
                DLONG(LHEIGH,3) = DLONG(LHEIGH,3) + (GAMMA+1.D0)*PAMA(2)
              ELSEIF ( ITYPE .EQ. 3                      ) THEN
                DLONG(LHEIGH,3) = DLONG(LHEIGH,3) + (GAMMA-1.D0)*PAMA(2)
              ELSEIF ( ITYPE .EQ. 5  .OR.   ITYPE .EQ. 6 ) THEN
                DLONG(LHEIGH,5) = DLONG(LHEIGH,5) + GAMMA * PAMA(5)
              ELSE
                DLONG(LHEIGH,7) = DLONG(LHEIGH,7) + GAMMA * PAMA(ITYPE)
     *                                            - RESTMS(ITYPE)

              ENDIF
            ENDIF
            GOTO 4
          ENDIF
C  SPECIAL TREATMENT FOR GAMMAS

          ITYPE = 1
          CHI   = 0.D0
          GOTO 5

        ENDIF

C  DETERMINE PLACE OF NEXT INTERACTION
        CALL BOX2

C  CHECK PASSAGE THROUGH OBSERVATION LEVELS AND TRACK PARTICLES TO THE
C  PLACE OF INTERACTION
  5     CONTINUE
        IRET1 = 0
c---------changed
        CALL BOX3(fmfb)
c---------changed

        IF ( IRET1 .NE. 0 ) GOTO 4

  6     CONTINUE

        IRET1 = 0
        MSMM  = 0

C  INCREMENT PARTICLE GENERATION AND PROCESS NUCLEAR INTERACTION
        GEN = GEN + 1.D0
C  INITIALIZE INTERMEDIATE STACK FOR ONE REACTION
        INT_ICOUNT = 0
        CALL NUCINT
C  TRANSFER INTERMEDIATE STACK FOR ONE REACTION
        CALL TSTEND

C  ENERGY - MULTIPLICITY STATISTICS
        IF ( EKINL .LE. 0.1D0 ) THEN
          MEN = 1
        ELSE
          MEN = 4.D0 + 3.D0 * LOG10(EKINL)
          MEN = MIN( MEN, 40 )
        ENDIF
        IF ( MSMM .LE. 1 ) THEN
          MMU = 1
        ELSE
          MMU = 1.D0 + 3.D0 * LOG10(DBLE(MSMM))
          MMU = MIN( MMU, 13 )
        ENDIF

        MULTMA(MEN,MMU) = MULTMA(MEN,MMU) + 1
        MULTOT(MEN,MMU) = MULTOT(MEN,MMU) + 1

        IF ( DEBUG ) WRITE(MDEBUG,*) 'AAMAIN: EKINL,MSMM=',
     *                                  SNGL(EKINL),MSMM

        IF ( IRET1 .EQ. 0 ) THEN

          IF ( DEBUG ) WRITE(MDEBUG,666) (CURPAR(II),II=0,9)
 666      FORMAT(' AAMAIN: CURPAR=',1P,10E11.3)

          GOTO 7
        ENDIF

C  GET NEXT PARTICLE FROM STACK, IF IRET=1 ALL PARTICLES ARE DONE
  4     CONTINUE
        IRET1 = 0
        CALL FSTACK
        IF ( FMUADD ) THEN
          IF ( (CURPAR(0) .EQ. 5  .OR.  CURPAR(0) .EQ. 6)
     *         .AND.  IRET1 .EQ. 0  .AND.  .NOT. FMUORG ) THEN
            DO  J = 0, MAXLEN
              AMUPAR(J) = CURPAR(J)
            ENDDO
            IF ( DEBUG ) WRITE(MDEBUG,*) 'AAMAIN: MUON STORED IN AMUPAR'
            FMUORG = .TRUE.
          ENDIF
        ENDIF

C  STACK IS EMPTY, IF IRET1 IS 1
        IF ( IRET1 .EQ. 0 ) GOTO 7

C-----------------------------------------------------------------------
C  FINISH SHOWER AND PRINT INFORMATION
        CALL OUTEND

        IF ( PLOTSH ) THEN

          WRITE(MONIOU,3881) NPLEM,NPLMU,NPLHAD
 3881     FORMAT(' PARTICLES STORED FOR PLOT OF 1. SHOWER:'/
     *       ' ',I10,' ELECTRONS AND GAMMAS'/
     *       ' ',I10,' MUONS'/
     *       ' ',I10,' HADRONS')

          CLOSE(55)
          CLOSE(56)
          CLOSE(57)

          PLOTSH = .FALSE.
        ENDIF

*       IF ( DEBUG ) WRITE(MDEBUG,442) NPARTO
*442    FORMAT(' AAMAIN: NPARTO='/(' ',10F10.0))

        IF ( FPRINT  .OR.  DEBUG ) THEN
          IFI    = 1
          IOBSLV = MIN( 5, NOBSLV )
          WRITE(MONIOU,54) (K,K=IFI,IOBSLV)
  54      FORMAT (/' PARTICLES AT DETECTOR LEVEL :'/
     *             ' FOR LEVEL         ', 5I13)
          WRITE(MONIOU,55) (OBSLEV(K),K=IFI,IOBSLV)
  55      FORMAT ( ' HEIGHT IN CM        ',1P, 5E13.3/)
          WRITE(MONIOU,555) (THCKOB(K),K=IFI,IOBSLV)
 555      FORMAT ( ' HEIGHT IN G/CM**2   ',1P, 5E13.3/)

          WRITE(MONIOU,776) 'PROTONS      ',(NPROTO(K),K=IFI,IOBSLV)
          WRITE(MONIOU,776) 'ANTIPROTONS  ',(NPROTB(K),K=IFI,IOBSLV)
          WRITE(MONIOU,776) 'NEUTRONS     ',(NNEUTR(K),K=IFI,IOBSLV)
          WRITE(MONIOU,776) 'ANTINEUTRONS ',(NNEUTB(K),K=IFI,IOBSLV)
          WRITE(MONIOU,775) 'GAMMAS       ',(NPHOTO(K),K=IFI,IOBSLV)
          WRITE(MONIOU,775) 'ELECTRONS    ',(NELECT(K),K=IFI,IOBSLV)
          WRITE(MONIOU,775) 'POSITRONS    ',(NPOSIT(K),K=IFI,IOBSLV)

          WRITE(MONIOU,776) 'MU -         ',(NMUM  (K),K=IFI,IOBSLV)
          WRITE(MONIOU,776) 'MU +         ',(NMUP  (K),K=IFI,IOBSLV)
          WRITE(MONIOU,776) 'PI 0         ',(NPI0  (K),K=IFI,IOBSLV)
          WRITE(MONIOU,776) 'PI -         ',(NPIM  (K),K=IFI,IOBSLV)
          WRITE(MONIOU,776) 'PI +         ',(NPIP  (K),K=IFI,IOBSLV)
          WRITE(MONIOU,776) 'K0L          ',(NK0L  (K),K=IFI,IOBSLV)
          WRITE(MONIOU,776) 'K0S          ',(NK0S  (K),K=IFI,IOBSLV)
          WRITE(MONIOU,776) 'K -          ',(NKMI  (K),K=IFI,IOBSLV)
          WRITE(MONIOU,776) 'K +          ',(NKPL  (K),K=IFI,IOBSLV)
          WRITE(MONIOU,776) 'STR. BARYONS ',(NHYP  (K),K=IFI,IOBSLV)
          WRITE(MONIOU,776) 'DEUTERONS    ',(NDEUT (K),K=IFI,IOBSLV)
          WRITE(MONIOU,776) 'TRITONS      ',(NTRIT (K),K=IFI,IOBSLV)
          WRITE(MONIOU,776) '3HELIUM      ',(NHELI3(K),K=IFI,IOBSLV)
          WRITE(MONIOU,776) 'ALPHAS       ',(NALPHA(K),K=IFI,IOBSLV)
          WRITE(MONIOU,776) 'OTHER PARTIC.',(NOTHER(K),K=IFI,IOBSLV)
          WRITE(MONIOU,*)
          WRITE(MONIOU,776) 'DECAYED MUONS',NMUOND
 775      FORMAT(' NO OF ',A13, '= ',1P,5E13.6,0P)
 776      FORMAT(' NO OF ',A13, '= ',5F13.0)

          IF ( NOBSLV .GT. 5 ) THEN
            IOBSLV = NOBSLV
            WRITE(MONIOU,54) (K,K=6,IOBSLV)
            WRITE(MONIOU,55) (OBSLEV(K),K=6,IOBSLV)
            WRITE(MONIOU,555) (THCKOB(K),K=6,IOBSLV)
            WRITE(MONIOU,776) 'PROTONS      ',(NPROTO(K),K=6,IOBSLV)
            WRITE(MONIOU,776) 'ANTIPROTONS  ',(NPROTB(K),K=6,IOBSLV)
            WRITE(MONIOU,776) 'NEUTRONS     ',(NNEUTR(K),K=6,IOBSLV)
            WRITE(MONIOU,776) 'ANTINEUTRONS ',(NNEUTB(K),K=6,IOBSLV)
            WRITE(MONIOU,775) 'GAMMAS       ',(NPHOTO(K),K=6,IOBSLV)
            WRITE(MONIOU,775) 'ELECTRONS    ',(NELECT(K),K=6,IOBSLV)
            WRITE(MONIOU,775) 'POSITRONS    ',(NPOSIT(K),K=6,IOBSLV)

            WRITE(MONIOU,776) 'MU -         ',(NMUM  (K),K=6,IOBSLV)
            WRITE(MONIOU,776) 'MU +         ',(NMUP  (K),K=6,IOBSLV)
            WRITE(MONIOU,776) 'PI 0         ',(NPI0  (K),K=6,IOBSLV)
            WRITE(MONIOU,776) 'PI -         ',(NPIM  (K),K=6,IOBSLV)
            WRITE(MONIOU,776) 'PI +         ',(NPIP  (K),K=6,IOBSLV)
            WRITE(MONIOU,776) 'K0L          ',(NK0L  (K),K=6,IOBSLV)
            WRITE(MONIOU,776) 'K0S          ',(NK0S  (K),K=6,IOBSLV)
            WRITE(MONIOU,776) 'K -          ',(NKMI  (K),K=6,IOBSLV)
            WRITE(MONIOU,776) 'K +          ',(NKPL  (K),K=6,IOBSLV)
            WRITE(MONIOU,776) 'STR. BARYONS ',(NHYP  (K),K=6,IOBSLV)
            WRITE(MONIOU,776) 'DEUTERONS    ',(NDEUT (K),K=6,IOBSLV)
            WRITE(MONIOU,776) 'TRITONS      ',(NTRIT (K),K=6,IOBSLV)
            WRITE(MONIOU,776) '3HELIUM      ',(NHELI3(K),K=6,IOBSLV)
            WRITE(MONIOU,776) 'ALPHAS       ',(NALPHA(K),K=6,IOBSLV)
            WRITE(MONIOU,776) 'OTHER PARTIC.',(NOTHER(K),K=6,IOBSLV)
            WRITE(MONIOU,*)
          ENDIF

        ENDIF

C  ADD UP FOR MEAN VALUES
        DO  K = 1, 25
          DO  J = 1, 20
            MPARTO(J,K) = MPARTO(J,K) + NPARTO(J,K)
            MPART2(J,K) = MPART2(J,K) + NPARTO(J,K)**2
          ENDDO
        ENDDO

        IOBSLV  = NOBSLV

        DO  K = 1, IOBSLV
          EVTE(3)   = EVTE(3) + NPHOTO(K)
          EVTE(263) = EVTE(263) + NPART2(K,1)
          EVTE(4)   = EVTE(4) + NELECT(K) + NPOSIT(K)
          EVTE(264) = EVTE(264) + NPART2(K,2) + NPART2(K,3)
          DO  J = 7,23
            EVTE(5)   = EVTE(5) + NPARTO(K,J)
            EVTE(265) = EVTE(265) + NPART2(K,J)
          ENDDO
          EVTE(5)   = EVTE(5) + NNEUTB(K)
          EVTE(265) = EVTE(265) + NPART2(K,25)
          EVTE(6)   = EVTE(6) + NMUP(K) + NMUM(K)
          EVTE(266) = EVTE(266) + NPART2(K,5) + NPART2(K,6)
        ENDDO
        EVTE(7) = NOPART

         IF ( FPRINT  .OR.  DEBUG ) WRITE(MONIOU,110)
     *                  IFINNU,IFINPI,IFINET,IFINKA,IFINHY,
     *                  IFINNU+IFINPI+IFINET+IFINKA+IFINHY,
     *                  ELAST,THICK1,SIG1I,TARG1I
 110    FORMAT(/
     *  ' NO OF NUCLEONS  PRODUCED IN FIRST HADR. INTERACTION =',I10/
     *  ' NO OF PIONS     PRODUCED IN FIRST HADR. INTERACTION =',I10/
     *  ' NO OF ETAS      PRODUCED IN FIRST HADR. INTERACTION =',I10/
     *  ' NO OF KAONS     PRODUCED IN FIRST HADR. INTERACTION =',I10/
     *  ' NO OF S.BARYONS PRODUCED IN FIRST HADR. INTERACTION =',I10/
     *  ' TOTAL MULTIPLICITY       OF FIRST HADR. INTERACTION =',I10/
     *  ' ELASTICITY               OF FIRST HADR. INTERACTION =',F10.4/
     *  ' VERTICAL DEPTH (G/CM**2) OF FIRST HADR. INTERACTION =',F10.4/
     *  ' CROSS-SECTION MILLIBARN  OF FIRST HADR. INTERACTION =',F10.4/
     *  ' TARGET MASS NUMBER       OF FIRST HADR. INTERACTION =',F10.4/)

C  PRINT OUT NKG RESULT FOR ONE SHOWER IF SELECTED
        IF ( FNKG ) CALL AVAGE

        IF ( LLONGI ) THEN
C  TREAT LONGITUDINAL DISTRIBUTIONS

          DO  J = 0, NSTEP1
C  ADD UP ENERGY DEPOSIT AND IONIZATION FOR SUM
C  FOR ENERGY CUT AS WELL AS FOR ANGLE CUT
            DLONG(J,9) = DLONG(J,1)+DLONG(J,2)+DLONG(J,3)+DLONG(J,4)
     *                      +DLONG(J,5)+DLONG(J,6)+DLONG(J,7)+DLONG(J,8)
     *                      +DLONG(J,11)+DLONG(J,13)+DLONG(J,15)
     *                      +DLONG(J,17)+DLONG(J,18)
C  ADD ELECTRONS, POSITRONS, MUONS AND NUCLEI TO THE CHARGED PARTICLES
            ELONG(J,7) = ELONG(J,7) + ELONG(J,2) + ELONG(J,3)
     *                 + ELONG(J,4) + ELONG(J,5) + ELONG(J,8)
C  ADD UP ALL ENERGIES FOR SUM
            ELONG(J,9) = ELONG(J,1) + ELONG(J,2) + ELONG(J,3)
     *               + ELONG(J,4) + ELONG(J,5) + ELONG(J,6) + ELONG(J,8)
C  ADD ALL CHARGED PARTICLES TO CHARGED SUM
            PLONG(J,7) = PLONG(J,7) + PLONG(J,2) + PLONG(J,3)
     *                 + PLONG(J,4) + PLONG(J,5) + PLONG(J,8)

C  ADD UP FOR MEAN VALUES OF LONGITUDINAL DISTRIBUTION
            DO  K = 1, 10
              AELONG(J,K) = AELONG(J,K) + ELONG(J,K)
              SELONG(J,K) = SELONG(J,K) + ELONG(J,K)**2
              APLONG(J,K) = APLONG(J,K) + PLONG(J,K)
              SPLONG(J,K) = SPLONG(J,K) + PLONG(J,K)**2

            ENDDO
            DO  K = 1, 19
              ADLONG(J,K) = ADLONG(J,K) + DLONG(J,K)
              SDLONG(J,K) = SDLONG(J,K) + DLONG(J,K)**2
            ENDDO
          ENDDO

C  PRINT LONGITUDINAL DISTRIBUTIONS PER SHOWER
          IF ( FPRINT  .OR.  DEBUG ) THEN
C  PARTICLE DISTRIBUTION
            WRITE(MONIOU,910) THSTEP,
     *      'GAMMAS','POSITRONS','ELECTRONS','MU+','MU-','HADRONS',
     *      'CHARGED','NUCLEI','CHERENKOV',

     *      ( J*THSTEP,(PLONG(J,K),K=1,9),J=LPCT1,NSTEP1 )
 910        FORMAT(/' ---------- LONGITUDINAL PARTICLE DISTRIBUTION IN '
     *        ,'VERT. STEPS OF ',F5.0,' G/CM**2 ',44(1H-)/

     *        '  DEPTH ',3A14,3A12,A12,A11,A12/
     *        (' ',F6.0,F15.0,2F14.0,3F12.0,F14.0,F11.0,1P,E12.5,0P) )
C  ENERGY DISTRIBUTION
            WRITE(MONIOU,908) THSTEP,
     *      'GAMMAS','POSITRONS','ELECTRONS','MU+','MU-','HADRONS',
     *      'CHARGED','NUCLEI','SUM',

     *      ( J*THSTEP,(ELONG(J,K),K=1,9),J=LPCT1,NSTEP1 )
 908        FORMAT(/' ---------- LONGITUDINAL ENERGY DISTRIBUTION ',
     *        '[GEV] IN VERT. STEPS OF ',F5.0,' G/CM**2 ',40(1H-)/

     *        '  DEPTH',9(A12,1X)/ (' ',F6.0,1P,9E13.5,0P) )

C  ENERGY DEPOSIT
            WRITE(MONIOU,909) THSTEP,
     *       ' GAMMA      ','EM IONIZ','EM CUT','MU IONIZ','MU CUT',
     *       'HADR IONIZ','HADR CUT','NEUTRINO ','    SUM',
     *       ( (2*J-1)*.5*THSTEP,DLONG(J,1)+DLONG(J,11),DLONG(J,2),
     *                           DLONG(J,3)+DLONG(J,13),DLONG(J,4),
     *                           DLONG(J,5)+DLONG(J,15),DLONG(J,6),
     *                           DLONG(J,7)+DLONG(J,17),
     *                           DLONG(J,8)+DLONG(J,18),DLONG(J,9),
     *                                     J=MAX(1,LPCT1),NSTEP1-1 )
 909        FORMAT(/' ---------- LONGITUDINAL ENERGY DEPOSIT [GEV] IN ',
     *        'VERT. STEPS OF ',F5.0,' G/CM**2 ',45(1H-)/
     *        '  DEPTH ',3A14,6A12,/,(' ',F6.1,1X,3F14.1,5F12.1,F13.1))
            WRITE(MONIOU,9091) (2*NSTEP-1)*.5*THSTEP,
     *         DLONG(NSTEP1,1)+DLONG(NSTEP1,11),DLONG(NSTEP1,2),
     *         DLONG(NSTEP1,3)+DLONG(NSTEP1,13),DLONG(NSTEP1,4),
     *         DLONG(NSTEP1,5)+DLONG(NSTEP1,15),DLONG(NSTEP1,6),
     *         DLONG(NSTEP1,7)+DLONG(NSTEP1,17),
     *         DLONG(NSTEP1,8)+DLONG(NSTEP1,18),DLONG(NSTEP1,9)

 9091       FORMAT(' ',F6.1,1X,1P,3E14.7,5E12.5,E13.6)

            DLONGSUM = 0.D0
            DO  K = 1, 19

              DLONG(LNGMAX,K) = 0.D0
              DO  J = 0, NSTEP1

                DLONG(LNGMAX,K) = DLONG(LNGMAX,K) + DLONG(J,K)
              ENDDO
              IF ( K .NE. 9 ) DLONGSUM = DLONGSUM + DLONG(LNGMAX,K)
            ENDDO
            WRITE(MONIOU,907) (DLONG(LNGMAX,K),K=1,8)
 907        FORMAT(' ',20X,'        LONGITUDINAL ENERGY SUM [GEV] ',/
     *         ,' ',7X,3E14.7,5E12.6)
            WRITE(MONIOU,9071) (DLONG(LNGMAX,K),K=11,18)
 9071       FORMAT(' ',7X,3F14.1,5F12.1)
            WRITE(MONIOU,919) DLONGSUM
            DO  K = 1, 19
              DLONG(LNGMAX,K) = 0.D0
            ENDDO
          ENDIF
C  WRITE OUT LONGITUDINAL DISTRIBUTION
          IF ( FLONGOUT ) THEN
            WRITE(MLONGOUT,211) NSTEP1,THSTEP,ISHOWNO,
     *      'GAMMAS','POSITRONS','ELECTRONS','MU+','MU-','HADRONS',
     *      'CHARGED','NUCLEI','CHERENKOV'

C
C  DO NOT CHANGE THIS FORMAT, AS THE CorsToRoot PROGRAM DEPENDS ON IT
C
 211        FORMAT(' LONGITUDINAL DISTRIBUTION IN ',I5,
     *             ' VERTICAL STEPS OF ',F5.0,' G/CM**2 FOR SHOWER ',
     *             I7,/,' DEPTH',9(A11,1X) )

C
            DO  J = 1, NSTEP1
              WRITE(MLONGOUT,212) J*THSTEP,(PLONG(J,K),K=1,9)
C
C  DO NOT CHANGE THIS FORMAT, AS THE CorsToRoot PROGRAM DEPENDS ON IT
C
 212          FORMAT(' ',F5.0,1P,9(E12.5),0P)
C
            ENDDO
            WRITE(MLONGOUT,213) NSTEP1,THSTEP,ISHOWNO,
     *             'GAMMA ','EM IONIZ','EM CUT','MU IONIZ','MU CUT',
     *             'HADR IONIZ','HADR CUT','NEUTRINO ','  SUM  '

C
C  DO NOT CHANGE THIS FORMAT, AS THE CorsToRoot PROGRAM DEPENDS ON IT
C
 213        FORMAT(' LONGITUDINAL ENERGY DEPOSIT IN ',I5,
     *             ' VERTICAL STEPS OF ',F5.0,' G/CM**2 FOR SHOWER ',
     *             I7,/,' DEPTH  ',3A11,6A12)

C
            DO  J = 1, NSTEP1
              DEPSTEP = (2*J-1)*.5*THSTEP
              WRITE(MLONGOUT,214) DEPSTEP,
     *         DLONG(J,1)+DLONG(J,11),DLONG(J,2),DLONG(J,3)+DLONG(J,13),
     *         DLONG(J,4),DLONG(J,5)+DLONG(J,15),DLONG(J,6),
     *         DLONG(J,7)+DLONG(J,17),DLONG(J,8)+DLONG(J,18),DLONG(J,9)
C
C  DO NOT CHANGE THIS FORMAT, AS THE CorsToRoot PROGRAM DEPENDS ON IT
C
 214          FORMAT(' ',F6.1,1P,9(E12.5),0P)
C
            ENDDO
          ELSE
C  FILL THE PERMANENT VALUES OF LONGITUDINAL FIELDS:
            ARRAYLONG(2)  = EVTH(2)              !SHOWER NUMBER
            ARRAYLONG(3)  = EVTH(3)              !PRIMARY PARTICLE
            ARRAYLONG(4)  = EVTH(4)              !PRIMARY ENERGY

            ARRAYLONG(7)  = THICK( ABS( DBLE(EVTH(7)) ) )
     *                                           !THICKNS FIRST INTERACT

            ARRAYLONG(8)  = EVTH(11)             !ZENITH ANGLE
            ARRAYLONG(9)  = EVTH(12)             !AZIMUTH ANGLE
            ARRAYLONG(10) = EVTH(61)             !ENERGY CUT HADRONS
            ARRAYLONG(11) = EVTH(62)             !ENERGY CUT MUONS
            ARRAYLONG(12) = EVTH(63)             !ENERGY CUT ELECTRONS
            ARRAYLONG(13) = EVTH(64)             !ENERGY CUT GAMMAS

C  CALCULATE HOW MANY BLOCKS MUST BE WRITTEN
            JJEND = INT( (NSTEP1-1)/26 ) + 1
            ARRAYLONG(5) = JJEND + 100*NSTEP1    !TOTAL # OF LONGI BLOCKS
C                                                ! & NUMBER OF STEPS
C  WRITE THE BLOCKS
            DO  JJ = 1, JJEND
C  SET ACTUAL BLOCK NUMBER
              ARRAYLONG(6) = JJ                  !CURRENT NUMBER OF BLOCK
C  FILL THE BLOCK WITH ACTUAL VALUES
              DO  J = 1, 26
                JPLUS = 10*(J-1)
                JJJ = J + 26 * (JJ-1)
                IF ( JJJ .LE. NSTEP1 ) THEN
C  FILL IN THE THICKNESS VALUES
                  ARRAYLONG(14+JPLUS) = JJJ * THSTEP
                  DO  K = 1, 9
C  FILL IN THE PARTICLE NUMBERS
                    ARRAYLONG(14+JPLUS+K) = PLONG(JJJ,K)
                  ENDDO
                ELSE
C  FILL THE END OF LAST BLOCK WITH ZEROS
                  DO  K = 1, 10
                    ARRAYLONG(13+JPLUS+K) = 0.
                  ENDDO
                ENDIF
              ENDDO
C  NOW WRITE OUT THE BLOCK
              CALL TOBUF( ARRAYLONG,0 )
*             WRITE(MONIOU,3333)JJ,ARRAYLONG
*3333         FORMAT( 1X,I5,3(1X,E10.5),/,(10(1X,E10.5)) )
            ENDDO
          ENDIF

          IF ( FLGFIT ) THEN
            IF ( FPRINT  .OR.  DEBUG ) WRITE(MONIOU,*) ' '
C  PERFORM FIT TO THE LONGITUDINAL DISTRIBUTION OF ALL CHARGED PARTICLES
C  IF EGS IS SELECTED THIS IS THE DISTRIBUTION WHICH IS TO BE TAKEN
            IF ( FEGS ) THEN
              DO  J = 0, NSTEP-LPCT1
                DEP(J+1)    = (J+LPCT1)*THSTEP
                CHAPAR(J+1) = MAX( 0.D0, PLONG(J+LPCT1,7) )
              ENDDO
              NSTP = NSTEP + 1 - LPCT1
              IF ( FPRINT  .OR.  DEBUG )
     *          WRITE(MONIOU,8229) 'ALL CHARGED PARTICLES'
 8229         FORMAT(' FIT OF THE HILLAS CURVE  ',
     *      ' N(T) = P1*((T-P2)/(P3-P2))**((P3-P2)/(P4+P5*T+P6*T**2))',
     *      ' * EXP((P3-T)/(P4+P5*T+P6*T**2))',/
     *      ' TO LONGITUDINAL DISTRIBUTION OF ',A35)
              IF ( FLONGOUT )
     *                 WRITE(MLONGOUT,8229) 'ALL CHARGED PARTICLES'
C  IF NKG IS SELECTED ONLY THE ELECTRON DISTRIBUTION IS AVAILABLE
            ELSEIF ( FNKG ) THEN
              DEP(1)    = 0.D0
              CHAPAR(1) = 0.D0
              DO  J = 1, IALT(1)
                DEP(J+1)    = TLEV(J)
                CHAPAR(J+1) = MAX( 0.D0, SL(J) )
              ENDDO
              NSTP = IALT(1) + 1
              IF ( FPRINT .OR. DEBUG ) WRITE(MONIOU,8229)'NKG ELECTRONS'
              IF ( FLONGOUT ) WRITE(MLONGOUT,8229)'NKG ELECTRONS'
C  IF NONE IS SELECTED IT DOES NOT REALLY MAKE SENSE TO FIT
C  BUT LET''S TAKE THEN ALL CHARGED WHICH ARE MUONS AND HADRONS
            ELSE
              DO  J = 0, NSTEP-LPCT1
                DEP(J+1)    = (J+LPCT1)*THSTEP
                CHAPAR(J+1) = MAX( 0.D0, PLONG(J+LPCT1,7) )
              ENDDO
              NSTP = NSTEP + 1 - LPCT1
              IF ( FPRINT  .OR.  DEBUG )
     *          WRITE(MONIOU,8229) 'MUONS AND CHARGED HADRONS'
              IF ( FLONGOUT )
     *          WRITE(MLONGOUT,8229) 'MUONS AND CHARGED HADRONS'
            ENDIF
            IF ( NSTP .GT. 6 ) THEN
C  THERE ARE MORE THAN 6 STEP VALUES, A FIT SHOULD BE POSSIBLE.
C  DO THE FIT: NPAR AND FPARAM GIVE THE NUMBER OF PARAMETERS USED
C  AND THE FINAL VALUES FOR THE PARAMETERS. CHISQ GIVES THE CHI**2/DOF
C  FOR THE FIT.
              CALL LONGFT( FPARAM,CHI2 )
              IF ( FPRINT  .OR.  DEBUG ) THEN
                IF ( FPARAM(1) .GT. 0.D0 ) THEN
                  WRITE(MONIOU,8230)
     *                         FPARAM,CHI2,CHI2/SQRT(FPARAM(1))*100.D0
 8230             FORMAT(' PARAMETERS         = ',1P,6E12.4/
     *                   ' CHI**2/DOF         = ',E11.4/
     *                   ' AV. DEVIATION IN % = ',E11.4,0P/)
                ELSE
                  WRITE(MONIOU,8231) FPARAM,CHI2
 8231             FORMAT(' PARAMETERS         = ',1P,6E12.4/
     *                   ' CHI**2/DOF         = ',E11.4,0P/,/)
                ENDIF
              ENDIF
              IF ( FLONGOUT ) THEN
                IF ( FPARAM(1) .GT. 0.D0 ) THEN
                  WRITE(MLONGOUT,8230) FPARAM,CHI2,
     *                               CHI2/SQRT(FPARAM(1))*100.D0
                ELSE
                  WRITE(MLONGOUT,8231) FPARAM,CHI2
                ENDIF
              ENDIF
C  STORE RESULT IN END EVENT BLOCK (IF NOT CRAZY)
              IF ( ABS( FPARAM(3) ) .LT. 1.D5 ) THEN
                DO  K = 1, 6
                  EVTE(255+K) = FPARAM(K)
                ENDDO
                EVTE(262) = CHI2
              ELSE
                WRITE(MONIOU,*) 'NO LONGI. FIT POSSIBLE, ',
     *               ' FIT DOES NOT CONVERGE...'
                DO  K = 1, 6
                  EVTE(255+K) = 0.
                ENDDO
                EVTE(262) = 0.
              ENDIF
            ELSE
              WRITE(MONIOU,*) 'NO LONGI. FIT POSSIBLE, ',
     *          ' NSTP = ',NSTP,'  TOO SMALL.'
              DO  K = 1, 6
                EVTE(255+K) = 0.
              ENDDO
              EVTE(262) = 0.
            ENDIF
          ENDIF

        ENDIF

        EVTE(2) = ISHOWNO
C  WRITE SHOWER END TO OUTPUT BUFFER

        CALL TOBUF( EVTE,0 )
        IF ( LCERFI ) THEN
          CALL OUTND2
          CALL TOBUFC( EVTE,0 )
        ENDIF

        IF ( FPRINT  .OR.  DEBUG ) WRITE(MONIOU,208)CERELE,CERHAD
  208   FORMAT(' CHERENKOV PH. FROM ELECTRONS = ',1P,E15.7,
     *        '  CHERENKOV PH. FROM HADRONS = ',E15.7)
        CERELE = 0.D0
        CERHAD = 0.D0
        NRECER = 0

C  STORE TABLES
        IF ( FTABOUT ) THEN
          WRITE(MTABOUT) G_ARRAY,E_ARRAY,M_ARRAY
C  STORE LONG DISTRIBUTION OF CHARGED PARTICLES
          IF ( LLONGI ) THEN
            WRITE(MTABOUT) THSTEP,NSTEP,(PLONG(II,7),II=1,NSTEP)
          ENDIF
        ENDIF

        IF ( FPRINT  .OR.  DEBUG ) WRITE(MONIOU,210) ISHOWNO
 210    FORMAT(/'   END OF SHOWER NO ',I10)

        DO  J = 1, 40
          JNBIN(J) = JNBIN(J) + INBIN(J)
          JPBIN(J) = JPBIN(J) + IPBIN(J)
          JKBIN(J) = JKBIN(J) + IKBIN(J)
          JHBIN(J) = JHBIN(J) + IHBIN(J)
        ENDDO

  2   CONTINUE
C  END OF SHOWER LOOP

C-----------------------------------------------------------------------

      WRITE(MONIOU,*) ' '
      CALL PRTIME( TTIME )
      DO  L = 1, NSEQ
        CALL RMMAQD( ISEED(1,L),L,'R' )
      ENDDO
      WRITE(MONIOU,159) ISHOWNO,(L,(ISEED(J,L),J=1,3),L=1,NSEQ)
 159  FORMAT(' AND RANDOM NUMBER GENERATOR AT END OF EVENT :',I8,
     *      /,(' SEQUENCE = ',I2,'  SEED = ',I9 ,'  CALLS = ',I9,
     *         '  BILLIONS = ',I9))

C  RESET NUMBER OF SHOWERS TO CORRECT VALUE
      ISHW = I

      RUNE(3) = REAL(ISHW)
      TDIFF = ILEFTB - ILEFTA

C  WRITE RUN END TO OUTPUT BUFFER AND FINISH OUTPUT

      CALL TOBUF( RUNE,1 )

      IF ( LCERFI ) CALL TOBUFC( RUNE,1 )

C  TIME SINCE BEGINNING

      ILEFTB = TIME()

      TDIFF  = ILEFTB - ILEFTA

C  MEAN VALUE FOR FIRST INTERACTION ALTITUDE (G/CM**2)
      IF ( ISHW .GT. 1 ) THEN
        CHISM2 = SQRT( ABS(CHISM2-CHISUM**2/ISHW) / (ISHW-1) )
        CHISUM = CHISUM / ISHW
      ELSE
        CHISM2 = 0.D0
      ENDIF

C  OUTPUTS FOR ALL SHOWERS
      WRITE(MONIOU,201) ISHW,TDIFF,TDIFF/ISHW,IRECOR,IRECOR/ISHW,
     *                   CHISUM,CHISM2
 201  FORMAT('1',10('='),' RUN SUMMARY ',56('=')/,/
     *  ' NUMBER OF GENERATED EVENTS = ',I10,/
     *  ' TOTAL TIME USED            = ',F12.0,'   SEC'/
     *  ' TIME PER EVENT             = ',F14.2,' SEC'/
     *  ' TOTAL SPACE ON MPATAP USED = ',I12,' WORDS'/
     *  ' SPACE PER EVENT ON MPATAP  = ',I12,' WORDS'/
     *  ' AVERAGE HEIGHT OF 1ST INT. = ',F10.3,' +-',F10.3,' G/CM**2'/)

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
*     IF ( ISHW .GT. 1 ) THEN

C  DO PRINTING OF AVERAGES ONLY IF MORE THAN 1 SHOWER IS SIMULATED
C  ENERGY - MULTIPLICITY MATRIX FOR ALL SHOWERS
        WRITE(MONIOU,209) (K,K=1,13),(J,(MULTOT(J,K),K=1,13),
     *    10**((J-4.)/3.),10**((J-3.)/3.),J=1,39),
     *    1,(INT(10**((K-1.)/3.)+1),K = 2,13),
     *    2,(INT(10**((K   )/3.)  ),K = 2,13)
 209    FORMAT(/,/' ENERGY - MULTIPLICITY MATRIX FOR ALL SHOWERS'/
     *    ' ENERGY RUNS VERTICALLY, MULTIPLICITY HORIZONTALLY'/,/,
     *    ' ',6X,5I10,3I8,5I6,' ENERGY RANGE [GEV]'/
     *    39(/' ',I4,1X,I11,4I10,3I8,5I6,1P,E10.2,E9.2,0P)/,/
     *    ' MULT. ',5I10,3I8,5I6,4X,'LOWER BIN LIMIT'/
     *    ' RANGE ',5I10,3I8,5I6,4X,'UPPER BIN LIMIT')

C  GET MEAN OF ELASTICITY FOR ENERGY BINS
        DO  J = 1, 40
          NELMEA = 0
          DO  K = 1, 10
            NELMEA = NELMEA + IELDPA(J,K)
          ENDDO
          IF ( NELMEA .NE. 0 ) ELMEAA(J) = ELMEAA(J) / NELMEA
        ENDDO

C  PRINT ENERGY - ELASTICITY MATRIX FOR ALL SHOWERS
        WRITE(MONIOU,408) (K,K=1,10),  (J,(IELDPA(J,K),K=1,10),
     *    ELMEAA(J),10**((J-4.D0)/3.D0),10**((J-3.)/3.D0),J=1,39),
     *    ((K-1)*0.1D0,K=1,10),(K*0.1D0,K=1,10)
 408    FORMAT (/,/' ENERGY - ELASTICITY MATRIX FOR ALL SHOWERS'/
     *    ' ENERGY RUNS VERTICALLY, ELASTICITY HORIZONTALLY'/,/
     *    ' ',4X,7I9,3I10,'   MEAN EL.  ENERGY RANGE [GEV]'/
     *    39(/' ',I3,1X,7I9,3I10,1X,1P,E10.3,2E10.2,0P)//
     *    ' ELA. ',F8.2,6F9.2,3F10.2,5X,'LOWER BIN LIMIT'/
     *    ' RANGE',F8.2,6F9.2,3F10.2,5X,'UPPER BIN LIMIT')

        WRITE(MONIOU,204)
 204    FORMAT (/,/' INTERACTIONS PER KINETIC ENERGY INTERVAL FOR ALL',
     *    ' SHOWERS'/,/'   BIN    LOWER LIMIT    UPPER LIMIT      ',
     *    'NUCLEON        PIONS         KAONS     S.BARYONS        ',
     *    '  TOTAL'/ 12X,'IN GEV',9X,'IN GEV',7X,
     *    '   EVENTS       EVENTS        EVENTS        EVENTS    '/,/)
        WRITE(MONIOU,207) (J,SABIN(J),SBBIN(J),JNBIN(J),JPBIN(J),
     *    JKBIN(J),JHBIN(J),JNBIN(J)+JPBIN(J)+JKBIN(J)+JHBIN(J),J=1,40)
 207    FORMAT(' ',I5,1P,2E15.4,0P,F14.0,3F14.0,F15.0)

C  CALCULATE MEAN VALUES AND STANDARD DEVIATIONS OF PARTICLE NUMBERS
        IF ( ISHW .GT. 1 ) THEN
          DO  K = 1, 25
            IOBSLV = NOBSLV
            DO  J = 1, IOBSLV
              MPART2(J,K) = SQRT( ABS(MPART2(J,K)-MPARTO(J,K)**2/ISHW)
     *                                                  /(ISHW-1) )
              MPARTO(J,K) = MPARTO(J,K)/ISHW
            ENDDO
          ENDDO
        ELSE
          DO  K = 1, 25
            IOBSLV = NOBSLV
            DO  J = 1, IOBSLV
              MPART2(J,K) = 0.D0
            ENDDO
          ENDDO
        ENDIF

C  PRINT MEAN VALUES AND STANDARD DEVIATIONS OF PARTICLE NUMBERS
        IFI    = 1
        IOBSLV = MIN( 3, NOBSLV )
        WRITE(MONIOU,854) (K,K=IFI,IOBSLV)
 854    FORMAT (/ ' AVERAGE NUMBER OF PARTICLES PER EVENT :'/
     *                    ' FROM LEVEL NUMBER ', 3(10X,I10,10X) )
        WRITE(MONIOU,855) (OBSLEV(K),K=IFI,IOBSLV)
 855    FORMAT (  ' HEIGHT IN CM',1P,3(20X,E10.3)/)
        WRITE(MONIOU,856) (THCKOB(K),K=IFI,IOBSLV)
 856    FORMAT ( ' HEIGHT IN G/CM**2',1P,3(14X,E10.3,6X)/)

      WRITE(MONIOU,778)'PROTONS     ',(MPROTO(K),MPROT2(K),K=IFI,IOBSLV)
      WRITE(MONIOU,778)'ANTIPROTONS ',(MPROTB(K),MPRTB2(K),K=IFI,IOBSLV)
      WRITE(MONIOU,778)'NEUTRONS    ',(MNEUTR(K),MNETR2(K),K=IFI,IOBSLV)
      WRITE(MONIOU,778)'ANTINEUTRONS',(MNEUTB(K),MNETB2(K),K=IFI,IOBSLV)
      WRITE(MONIOU,777)'GAMMAS      ',(MPHOTO(K),MPHOT2(K),K=IFI,IOBSLV)
      WRITE(MONIOU,777)'ELECTRONS   ',(MELECT(K),MELEC2(K),K=IFI,IOBSLV)
      WRITE(MONIOU,777)'POSITRONS   ',(MPOSIT(K),MPOSI2(K),K=IFI,IOBSLV)

      WRITE(MONIOU,778)'MU -        ',(MMUM  (K),MMUM2 (K),K=IFI,IOBSLV)
      WRITE(MONIOU,778)'MU +        ',(MMUP  (K),MMUP2 (K),K=IFI,IOBSLV)
      WRITE(MONIOU,778)'PI 0        ',(MPI0  (K),MPI02 (K),K=IFI,IOBSLV)
      WRITE(MONIOU,778)'PI -        ',(MPIM  (K),MPIM2 (K),K=IFI,IOBSLV)
      WRITE(MONIOU,778)'PI +        ',(MPIP  (K),MPIP2 (K),K=IFI,IOBSLV)
      WRITE(MONIOU,778)'K0L         ',(MK0L  (K),MK0L2 (K),K=IFI,IOBSLV)
      WRITE(MONIOU,778)'K0S         ',(MK0S  (K),MK0S2 (K),K=IFI,IOBSLV)
      WRITE(MONIOU,778)'K -         ',(MKMI  (K),MKMI2 (K),K=IFI,IOBSLV)
      WRITE(MONIOU,778)'K +         ',(MKPL  (K),MKPL2 (K),K=IFI,IOBSLV)
      WRITE(MONIOU,778)'STR. BARYONS',(MHYP  (K),MHYP2 (K),K=IFI,IOBSLV)
      WRITE(MONIOU,778)'DEUTERONS   ',(MDEUT (K),MDEUT2(K),K=IFI,IOBSLV)
      WRITE(MONIOU,778)'TRITONS     ',(MTRIT (K),MTRIT2(K),K=IFI,IOBSLV)
      WRITE(MONIOU,778)'3HELIUM     ',(MHELI3(K),MHEL32(K),K=IFI,IOBSLV)
      WRITE(MONIOU,778)'ALPHAS      ',(MALPHA(K),MALPH2(K),K=IFI,IOBSLV)
      WRITE(MONIOU,778)'OTHER PART. ',(MOTHER(K),MOTH2 (K),K=IFI,IOBSLV)
      WRITE(MONIOU,*)
      WRITE(MONIOU,778) 'DECAYED MUONS',MMUOND
 777    FORMAT(' NO OF ',A12,' = ',1P,3(E13.6,' +-',E13.6,' '),0P)
 778    FORMAT(' NO OF ',A12,' = ',3(F13.1,' +-',F13.1,' '))

        IF ( NOBSLV .GT. 3 ) THEN
          IOBSLV = MIN( 6, NOBSLV )
          WRITE(MONIOU,854) (K,K=4,IOBSLV)
          WRITE(MONIOU,855) (OBSLEV(K),K=4,IOBSLV)
          WRITE(MONIOU,856) (THCKOB(K),K=4,IOBSLV)
        WRITE(MONIOU,778)'PROTONS     ',(MPROTO(K),MPROT2(K),K=4,IOBSLV)
        WRITE(MONIOU,778)'ANTIPROTONS ',(MPROTB(K),MPRTB2(K),K=4,IOBSLV)
        WRITE(MONIOU,778)'NEUTRONS    ',(MNEUTR(K),MNETR2(K),K=4,IOBSLV)
        WRITE(MONIOU,778)'ANTINEUTRONS',(MNEUTB(K),MNETB2(K),K=4,IOBSLV)
        WRITE(MONIOU,777)'GAMMAS      ',(MPHOTO(K),MPHOT2(K),K=4,IOBSLV)
        WRITE(MONIOU,777)'ELECTRONS   ',(MELECT(K),MELEC2(K),K=4,IOBSLV)
        WRITE(MONIOU,777)'POSITRONS   ',(MPOSIT(K),MPOSI2(K),K=4,IOBSLV)

        WRITE(MONIOU,778)'MU -        ',(MMUM  (K),MMUM2 (K),K=4,IOBSLV)
        WRITE(MONIOU,778)'MU +        ',(MMUP  (K),MMUP2 (K),K=4,IOBSLV)
        WRITE(MONIOU,778)'PI 0        ',(MPI0  (K),MPI02 (K),K=4,IOBSLV)
        WRITE(MONIOU,778)'PI -        ',(MPIM  (K),MPIM2 (K),K=4,IOBSLV)
        WRITE(MONIOU,778)'PI +        ',(MPIP  (K),MPIP2 (K),K=4,IOBSLV)
        WRITE(MONIOU,778)'K0L         ',(MK0L  (K),MK0L2 (K),K=4,IOBSLV)
        WRITE(MONIOU,778)'K0S         ',(MK0S  (K),MK0S2 (K),K=4,IOBSLV)
        WRITE(MONIOU,778)'K -         ',(MKMI  (K),MKMI2 (K),K=4,IOBSLV)
        WRITE(MONIOU,778)'K +         ',(MKPL  (K),MKPL2 (K),K=4,IOBSLV)
        WRITE(MONIOU,778)'STR. BARYONS',(MHYP  (K),MHYP2 (K),K=4,IOBSLV)
        WRITE(MONIOU,778)'DEUTERONS   ',(MDEUT (K),MDEUT2(K),K=4,IOBSLV)
        WRITE(MONIOU,778)'TRITONS     ',(MTRIT (K),MTRIT2(K),K=4,IOBSLV)
        WRITE(MONIOU,778)'3HELIUM     ',(MHELI3(K),MHEL32(K),K=4,IOBSLV)
        WRITE(MONIOU,778)'ALPHAS      ',(MALPHA(K),MALPH2(K),K=4,IOBSLV)
        WRITE(MONIOU,778)'OTHER PART. ',(MOTHER(K),MOTH2 (K),K=4,IOBSLV)
          WRITE(MONIOU,*)

          IF ( NOBSLV .GT. 6 ) THEN
            IOBSLV = MIN( 9, NOBSLV )
            WRITE(MONIOU,854) (K,K=7,IOBSLV)
            WRITE(MONIOU,855) (OBSLEV(K),K=7,IOBSLV)
            WRITE(MONIOU,856) (THCKOB(K),K=7,IOBSLV)
        WRITE(MONIOU,778)'PROTONS     ',(MPROTO(K),MPROT2(K),K=7,IOBSLV)
        WRITE(MONIOU,778)'ANTIPROTONS ',(MPROTB(K),MPRTB2(K),K=7,IOBSLV)
        WRITE(MONIOU,778)'NEUTRONS    ',(MNEUTR(K),MNETR2(K),K=7,IOBSLV)
        WRITE(MONIOU,778)'ANTINEUTRONS',(MNEUTB(K),MNETB2(K),K=7,IOBSLV)
        WRITE(MONIOU,777)'GAMMAS      ',(MPHOTO(K),MPHOT2(K),K=7,IOBSLV)
        WRITE(MONIOU,777)'ELECTRONS   ',(MELECT(K),MELEC2(K),K=7,IOBSLV)
        WRITE(MONIOU,777)'POSITRONS   ',(MPOSIT(K),MPOSI2(K),K=7,IOBSLV)

        WRITE(MONIOU,778)'MU -        ',(MMUM  (K),MMUM2 (K),K=7,IOBSLV)
        WRITE(MONIOU,778)'MU +        ',(MMUP  (K),MMUP2 (K),K=7,IOBSLV)
        WRITE(MONIOU,778)'PI 0        ',(MPI0  (K),MPI02 (K),K=7,IOBSLV)
        WRITE(MONIOU,778)'PI -        ',(MPIM  (K),MPIM2 (K),K=7,IOBSLV)
        WRITE(MONIOU,778)'PI +        ',(MPIP  (K),MPIP2 (K),K=7,IOBSLV)
        WRITE(MONIOU,778)'K0L         ',(MK0L  (K),MK0L2 (K),K=7,IOBSLV)
        WRITE(MONIOU,778)'K0S         ',(MK0S  (K),MK0S2 (K),K=7,IOBSLV)
        WRITE(MONIOU,778)'K -         ',(MKMI  (K),MKMI2 (K),K=7,IOBSLV)
        WRITE(MONIOU,778)'K +         ',(MKPL  (K),MKPL2 (K),K=7,IOBSLV)
        WRITE(MONIOU,778)'STR. BARYONS',(MHYP  (K),MHYP2 (K),K=7,IOBSLV)
        WRITE(MONIOU,778)'DEUTERONS   ',(MDEUT (K),MDEUT2(K),K=7,IOBSLV)
        WRITE(MONIOU,778)'TRITONS     ',(MTRIT (K),MTRIT2(K),K=7,IOBSLV)
        WRITE(MONIOU,778)'3HELIUM     ',(MHELI3(K),MHEL32(K),K=7,IOBSLV)
        WRITE(MONIOU,778)'ALPHAS      ',(MALPHA(K),MALPH2(K),K=7,IOBSLV)
        WRITE(MONIOU,778)'OTHER PART. ',(MOTHER(K),MOTH2 (K),K=7,IOBSLV)
            WRITE(MONIOU,*)

            IF ( NOBSLV .GT. 9 ) THEN
              IOBSLV = MIN( 10, NOBSLV )
              WRITE(MONIOU,854) (K,K=9,IOBSLV)
              WRITE(MONIOU,855) (OBSLEV(K),K=9,IOBSLV)
              WRITE(MONIOU,856) (THCKOB(K),K=9,IOBSLV)
        WRITE(MONIOU,778)'PROTONS     ',(MPROTO(K),MPROT2(K),K=9,IOBSLV)
        WRITE(MONIOU,778)'ANTIPROTONS ',(MPROTB(K),MPRTB2(K),K=9,IOBSLV)
        WRITE(MONIOU,778)'NEUTRONS    ',(MNEUTR(K),MNETR2(K),K=9,IOBSLV)
        WRITE(MONIOU,778)'ANTINEUTRONS',(MNEUTB(K),MNETB2(K),K=9,IOBSLV)
        WRITE(MONIOU,777)'GAMMAS      ',(MPHOTO(K),MPHOT2(K),K=9,IOBSLV)
        WRITE(MONIOU,777)'ELECTRONS   ',(MELECT(K),MELEC2(K),K=9,IOBSLV)
        WRITE(MONIOU,777)'POSITRONS   ',(MPOSIT(K),MPOSI2(K),K=9,IOBSLV)

        WRITE(MONIOU,778)'MU -        ',(MMUM  (K),MMUM2 (K),K=9,IOBSLV)
        WRITE(MONIOU,778)'MU +        ',(MMUP  (K),MMUP2 (K),K=9,IOBSLV)
        WRITE(MONIOU,778)'PI 0        ',(MPI0  (K),MPI02 (K),K=9,IOBSLV)
        WRITE(MONIOU,778)'PI -        ',(MPIM  (K),MPIM2 (K),K=9,IOBSLV)
        WRITE(MONIOU,778)'PI +        ',(MPIP  (K),MPIP2 (K),K=9,IOBSLV)
        WRITE(MONIOU,778)'K0L         ',(MK0L  (K),MK0L2 (K),K=9,IOBSLV)
        WRITE(MONIOU,778)'K0S         ',(MK0S  (K),MK0S2 (K),K=9,IOBSLV)
        WRITE(MONIOU,778)'K -         ',(MKMI  (K),MKMI2 (K),K=9,IOBSLV)
        WRITE(MONIOU,778)'K +         ',(MKPL  (K),MKPL2 (K),K=9,IOBSLV)
        WRITE(MONIOU,778)'STR. BARYONS',(MHYP  (K),MHYP2 (K),K=9,IOBSLV)
        WRITE(MONIOU,778)'DEUTERONS   ',(MDEUT (K),MDEUT2(K),K=9,IOBSLV)
        WRITE(MONIOU,778)'TRITONS     ',(MTRIT (K),MTRIT2(K),K=9,IOBSLV)
        WRITE(MONIOU,778)'3HELIUM     ',(MHELI3(K),MHEL32(K),K=9,IOBSLV)
        WRITE(MONIOU,778)'ALPHAS      ',(MALPHA(K),MALPH2(K),K=9,IOBSLV)
        WRITE(MONIOU,778)'OTHER PART. ',(MOTHER(K),MOTH2 (K),K=9,IOBSLV)
              WRITE(MONIOU,*)
            ENDIF

          ENDIF
        ENDIF

C  PRINT OUT NKG RESULT FOR ALL SHOWERS IF SELECTED
        IF ( FNKG ) CALL MITAGE

C  CALCULATE MEAN VALUES AND SIGMAS OF LONGITUDINAL DISTRIBUTION
        IF ( LLONGI ) THEN
          IF ( ISHW .GT. 1 ) THEN
            DO  J = 0, NSTEP1
              DO  K = 1, 19
                SDLONG(J,K) = SQRT( MAX( 0.D0,
     *                   (SDLONG(J,K)-ADLONG(J,K)**2/ISHW)/(ISHW-1) ) )
                ADLONG(J,K) = ADLONG(J,K)/ISHW
              ENDDO
              DO  K = 1, 10
                SELONG(J,K) = SQRT( MAX( 0.D0,
     *                   (SELONG(J,K)-AELONG(J,K)**2/ISHW)/(ISHW-1) ) )
                AELONG(J,K) = AELONG(J,K)/ISHW
                SPLONG(J,K) = SQRT( MAX( 0.D0,
     *                   (SPLONG(J,K)-APLONG(J,K)**2/ISHW)/(ISHW-1) ) )
                APLONG(J,K) = APLONG(J,K)/ISHW

              ENDDO
            ENDDO
          ELSE
            DO  J = 0, NSTEP1
              DO  K = 1, 19
                SDLONG(J,K) = 0.D0
              ENDDO
              DO  K = 1, 10
                SELONG(J,K) = 0.D0
                SPLONG(J,K) = 0.D0

              ENDDO
            ENDDO
          ENDIF

C  PRINT AVERAGE LONGITUDINAL PARTICLE DISTRIBUTIONS
          WRITE(MONIOU,911) THSTEP,
     *      'GAMMAS ','POSITRONS','ELECTRONS','MU+  ','MU-  ',

     *      (J*THSTEP,(APLONG(J,K),SPLONG(J,K),K=1,5),J=LPCT0,NSTEP1)
 911      FORMAT(/' AVERAGE LONGITUDINAL PARTICLE DISTRIBUTION IN ',
     *      'VERT. STEPS OF ',F5.0,' G/CM**2 '/' ',132('=')/

     *      ' DEPTH',6X,A9,16X,2(A10,17X),A9,16X,A9 /,/
     *      (' ',F5.0,1X,1P,E10.4,'+-',E10.4,0P,1X,F13.0,'+-',F12.0,
     *      1X,F13.0,'+-',F12.0,1X,F10.0,'+-',F11.0,
     *      1X,F10.0,'+-',F11.0 ))
          WRITE(MONIOU,912) THSTEP,
     *      'HADRONS','CHARGED','NUCLEI','CHERENKOV',

     *      (J*THSTEP,(APLONG(J,K),SPLONG(J,K),K=6,9),J=LPCT0,NSTEP1)
 912      FORMAT(/' AVERAGE LONGITUDINAL PARTICLE DISTRIBUTION IN ',
     *      'VERT. STEPS OF ',F5.0,' G/CM**2 '/' ',118('=')/

     *      ' DEPTH',8X,A9,17X,A10,17X,A9,21X,A9 /,/
     *      (' ',F5.0,1X,F11.1,'+-',F11.1,1X,F13.0,'+-',F13.0,
     *      2X,F10.1,'+-',F10.1,1X,1P,E16.6,'+-',E16.6,0P))

C  PRINT AVERAGE LONGITUDINAL ENERGY DISTRIBUTIONS
          WRITE(MONIOU,915) THSTEP,
     *      'GAMMAS ','POSITRONS','ELECTRONS','MU+  ','MU-  ',

     *      (J*THSTEP,(AELONG(J,K),SELONG(J,K),K=1,5),J=LPCT0,NSTEP1)
 915      FORMAT(/' AVERAGE LONGITUDINAL ENERGY DISTRIBUTION [GEV] ',
     *      'IN VERT. STEPS OF ',F5.0,' G/CM**2 '/' ',131('=')/

     *      ' DEPTH',6X,A9,4(16X,A9),/,/
     *      (' ',F5.0,1X,1P,5(1X,E11.5,'+-',E11.5),0P))
          WRITE(MONIOU,916) THSTEP,
     *      'HADRONS','CHARGED','NUCLEI','ENERGYSUM',

     *      (J*THSTEP,(AELONG(J,K),SELONG(J,K),K=6,9),J=LPCT0,NSTEP1)
 916      FORMAT(/' AVERAGE LONGITUDINAL ENERGY DISTRIBUTION [GEV] ',
     *      'IN VERT. STEPS OF ',F5.0,' G/CM**2 '/' ',110('=')/

     *      ' DEPTH',7X,3(A8,17X),2X,A10, /,/ (' ',F5.0,1X,1P,
     *      3(1X,E11.5,'+-',E11.5),1X,E13.7,'+-',E13.7,0P))

C  PRINT AVERAGE LONGITUDINAL ENERGY DEPOSIT
          ADLONGSUM = 0.D0
          DO  K = 1, 19
            DO  J = 0, NSTEP1
              ADLONG(LNGMAX,K) = ADLONG(LNGMAX,K) + ADLONG(J,K)
            ENDDO
C  DO NOT SUM UP CHERENKOV PHOTONS
            IF ( K .NE. 9 ) ADLONGSUM = ADLONGSUM + ADLONG(LNGMAX,K)
          ENDDO
          WRITE(MONIOU,913) THSTEP,
     *      'GAMMA E_CUT', 'EM IONIZ','EM E-CUT','MU IONIZ','MU E-CUT',

     *      ((2*J-1)*.5*THSTEP,(ADLONG(J,K),SDLONG(J,K),
     *                                       K=1,5),J=LPCT0+1,NSTEP1-1 )
 913      FORMAT(/' AVERAGE LONGITUDINAL ENERGY DEPOSIT [GEV] IN ',
     *      'VERT. STEPS OF ', F5.0,' G/CM**2 '/' ',132('=')/

     *      ' DEPTH',6X,A11,14X,2(A10,17X),A9,16X,A9 /,/
     *      (' ',F6.1,   F10.0,'+-',F10.0,1X,F13.0,'+-',F12.0,
     *      1X,F13.0,'+-',F12.0,1X,F10.0,'+-',F11.0,
     *      1X,F10.0,'+-',F11.0 ))
          WRITE(MONIOU,917) (ADLONG(LNGMAX,K),K=1,5)
 917      FORMAT(' ',20X,'AVERAGE LONGITUDINAL ENERGY SUM [GEV] '/
     *      ' ',3X,F14.1,12X,F14.1,13X,F15.1,11X,F14.1,10X,F14.1)
          WRITE(MONIOU,913) THSTEP,
     *       'GAMMA A-CUT',' (DUMMY)','EM A-CUT','(DUMMY) ','MU A-CUT',

     *      ((2*J-1)*.5*THSTEP,(ADLONG(J,K),SDLONG(J,K),

     *                                     K=11,15),J=LPCT0+1,NSTEP1)
          WRITE(MONIOU,917) (ADLONG(LNGMAX,K),K=11,15)

          WRITE(MONIOU,914) THSTEP,
     *      'HADR IONIZ','HADR E-CUT','NEUTRINO','    SUM',

     *      ((2*J-1)*.5*THSTEP,(ADLONG(J,K),SDLONG(J,K),
     *                                       K=6,9),J=LPCT0+1,NSTEP1 )
 914      FORMAT(/' AVERAGE LONGITUDINAL ENERGY DEPOSIT [GEV] IN ',
     *      'VERT. STEPS OF ',F5.0,' G/CM**2 '/' ',112('=')/

     *      ' DEPTH',7X,A10,16X,A10,16X,A12,15X,A9 /,/
     *      (' ',F6.1,   F11.1,'+-',F11.1,1X,F13.0,'+-',F13.0,
     *      2X,F10.1,'+-',F10.1,1X,F13.1,'+-',F13.1))
          WRITE(MONIOU,918) (ADLONG(LNGMAX,K),K=6,8)
 918      FORMAT(' ',20X,'AVERAGE LONGITUDINAL ENERGY SUM [GEV] ',
     *      /,' ',3X,F14.1,13X,F15.1,13X,F13.1)
          WRITE(MONIOU,914) THSTEP,
     *      '(DUMMY)','HADR A-CUT','NTRINO A-CUT','(DUMMY)',

     *      ((2*J-1)*.5*THSTEP,(ADLONG(J,K),SDLONG(J,K),

     *                                      K=16,19),J=LPCT0+1,NSTEP1)
          WRITE(MONIOU,918) (ADLONG(LNGMAX,K),K=16,18)

          WRITE(MONIOU,919) ADLONGSUM
 919      FORMAT(' ',20X,' ENERGY SUM = ',1P,E15.7,0P,' GEV')

          IF ( FLGFIT ) THEN
C  PERFORM FIT TO THE LONGITUDINAL DISTRIBUTION OF ALL CHARGED PARTICLES
C  IF EGS IS SELECTED THIS IS THE DISTRIBUTION WHICH IS TO BE TAKEN
            IF     ( FEGS ) THEN
              DO  J = 0, NSTEP-LPCT0
                DEP(J+1)    = (J+LPCT0)*THSTEP
                CHAPAR(J+1) = MAX( 0.D0, APLONG(J+LPCT0,7) )
              ENDDO
              NSTP = NSTEP + 1 - LPCT0
              WRITE(MONIOU,8229) 'AVERAGE ALL CHARGED PARTICLES'
C  IF NKG IS SELECTED ONLY THE ELECTRON DISTRIBUTION IS AVAILABLE
            ELSEIF ( FNKG ) THEN
              DEP(1)    = 0.D0
              CHAPAR(1) = 0.D0
              DO  J = 1, IALT(1)
                DEP(J+1)    = TLEV(J)
                CHAPAR(J+1) = MAX( 0.D0, SEL(J)/ISHW )
              ENDDO
              NSTP = IALT(1) + 1
              WRITE(MONIOU,8229) 'AVERAGE NKG ELECTRONS'
C  IF NONE IS SELECTED IT DOES NOT REALLY MAKE SENSE TO FIT
C  BUT LET''S TAKE THEN ALL CHARGED WHICH ARE MUONS AND HADRONS
            ELSE
              DO  J = 0, NSTEP-LPCT0
                DEP(J+1)    = (J+LPCT0)*THSTEP
                CHAPAR(J+1) = MAX( 0.D0, APLONG(J+LPCT0,7) )
              ENDDO
              NSTP = NSTEP + 1 - LPCT0
              WRITE(MONIOU,8229) 'AVERAGE MUONS AND CHARGED HADRONS'
            ENDIF
            IF ( NSTP .GT. 6 ) THEN
C  THERE ARE MORE THAN 6 STEP VALUES, A FIT SHOULD BE POSSIBLE.
C  DO THE FIT: NPAR AND FPARAM GIVE THE NUMBER OF PARAMETERS USED
C  AND THE FINAL VALUES FOR THE PARAMETERS. CHISQ GIVES THE CHI**2/DOF
C  FOR THE FIT.
              CALL LONGFT( FPARAM,CHI2 )
              IF ( FPARAM(1) .GT. 0.D0 ) THEN
                WRITE(MONIOU,8230) FPARAM,CHI2,
     *                               CHI2/SQRT(FPARAM(1))*100.D0
              ELSE
                WRITE(MONIOU,8231) FPARAM,CHI2
              ENDIF
            ELSE
              WRITE(MONIOU,*) 'NO LONGI. FIT POSSIBLE, ',
     *                      ' NSTP = ',NSTP,'  TOO SMALL.'
            ENDIF
          ENDIF
        ENDIF

*     ENDIF
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

C  CONTROL PRINT OUTPUT OF CONSTANTS
      IF ( DEBUG ) THEN
        CALL STAEND
        WRITE(MDEBUG,*) 'AAMAIN: STAEND CALLED'
      ENDIF

      WRITE(MONIOU,*) ' '
      CALL PRTIME( TTIME )
      WRITE(MONIOU,101)
 101  FORMAT (/' ',10('='),' END OF RUN ',48('='))

C  CLOSE ALL OPEN UNITS

      IF ( MONIIN .NE. 5 ) CLOSE (MONIIN)
      IF ( MONIOU .NE. 6 ) CLOSE (MONIOU)
      IF ( MDEBUG .NE. 6 ) CLOSE (MDEBUG)
      CLOSE(MEXST)

      IF ( FPAROUT ) CLOSE (MPATAP)

      IF ( FTABOUT ) CLOSE (MTABOUT)
      IF ( FLONGOUT  .AND.  LLONGI ) CLOSE (MLONGOUT)

      IF ( LCERFI ) CLOSE (MCETAP)

      STOP

      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE ADDANG( COST0,PHI0, COST,PHI, COST1,PHI1 )

C-----------------------------------------------------------------------
C  ADD(ITION OF) ANG(LES)
C
C  ADDITION OF ANGLES IS DONE BY SEQUENTIAL ROTATIONS :
C    1. ROTATE VECTOR AROUND Z AXIS BY -PHI0
C    2. ROTATE VECTOR AROUND Y AXIS BY -THETA0  NOW VECTOR IS (0,0,1)
C
C    3. ROTATE VECTOR AROUND Y AXIS BY  THETA ANGLES TO BE ADDED
C    4. ROTATE VECTOR AROUND Z AXIS BY  PHI
C
C    5. ROTATE VECTOR AROUND Y AXIS BY  THETA0
C    6. ROTATE VECTOR AROUND Z AXIS BY -PHI0
C              NOW VECTOR IS (X,Y,Z) WITH COST1     = Z
C                                     AND TAN(PHI1) = Y/X
C  THIS SUBROUTINE IS CALLED FROM MANY ROUTINES.
C  ARGUMENTS:
C   COST0  = COSINE THETA OF PARTICLE BEFORE
C   PHI0   = PHI          OF PARTICLE BEFORE
C   COST   = COSINE THETA OF ANGLE TO ADD
C   PHI    = PHI          OF ANGLE TO ADD
C   COST1  = COSINE THETA OF PARTICLE AFTER ADDITION OF ANGLES
C   PHI1   = PHI    THETA OF PARTICLE AFTER ADDITION OF ANGLES
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION A,COST,COST0,COST1,CPHI,CPHI0,PHI,PHI0,PHI1,
     *                 SINT,SINT0,SPHI,SPHI0,XXX,YYY,ZZZ
      SAVE
C-----------------------------------------------------------------------

CC    IF ( DEBUG ) WRITE(MDEBUG,*) 'ADDANG:'

      SINT0 = SQRT( (1.D0-COST0) * (1.D0+COST0) )
      SINT  = SQRT( (1.D0-COST)  * (1.D0+COST) )
      SPHI0 = SIN( PHI0 )
      CPHI0 = COS( PHI0 )
      SPHI  = SIN( PHI )
      CPHI  = COS( PHI )

      A   = COST0 * CPHI * SINT + COST * SINT0
      XXX = A    * CPHI0 - SPHI0 * SINT * SPHI
      YYY = A    * SPHI0 + CPHI0 * SINT * SPHI
      ZZZ = COST * COST0 - SINT0 * SINT * CPHI

C  GET NEW COSINE(THETA) AND PHI
      COST1  = MIN( 1.D0, ZZZ )
      IF ( YYY .EQ. 0.D0  .AND.  XXX .EQ. 0.D0 ) THEN
        PHI1 = 0.D0
      ELSE
        PHI1 = ATAN2( YYY, XXX )
      ENDIF

      RETURN
      END

C>>>>>>>>>changed trajectory>>>>>>>>>>>>>>>>>>>>>

C*-- Author: Marlene Doert ---- 14.1.09 -----


      SUBROUTINE JULDAT (I,M,K,H,TJD)
C
C     THIS SUBROUTINE COMPUTES JULIAN DATE, GIVEN CALENDAR DATE AND
C     TIME.  INPUT CALENDAR DATE MUST BE GREGORIAN.  INPUT TIME VALUE
C     CAN BE IN ANY UT-LIKE TIME SCALE (UTC, UT1, TT, ETC.) - OUTPUT
C     JULIAN DATE WILL HAVE SAME BASIS.  ALGORITHM BY FLIEGEL AND
C     VAN FLANDERN.
C
C          I      = YEAR (IN)
C          M      = MONTH NUMBER (IN)
C          K      = DAY OF MONTH (IN)
C          H      = UT HOURS (IN)
C          TJD    = JULIAN DATE (OUT)
C
C
      DOUBLE PRECISION H,TJD
C
C     JD=JULIAN DAY NO FOR DAY BEGINNING AT GREENWICH NOON ON GIVEN DATE
      JD = K-32075+1461*(I+4800+(M-14)/12)/4+367*(M-2-(M-14)/12*12)/12
     .     -3*((I+4900+(M-14)/12)/100)/4
      TJD = JD - 0.5D0 + H/24.D0
C
      RETURN
      END


      SUBROUTINE SIDTIM (TJDH,TJDL,GST)
C
      implicit none
C
C     THIS SUBROUTINE COMPUTES THE GREENWICH SIDEREAL TIME
C     (EITHER MEAN OR APPARENT) AT JULIAN DATE TJDH + TJDL.
C     SEE AOKI, ET AL. (1982) ASTRONOMY AND ASTROPYSICS 105, 359-361.
C
C          TJDH   = JULIAN DATE, HIGH-ORDER PART (IN)
C          TJDL   = JULIAN DATE, LOW-ORDER PART (IN)
C                   JULIAN DATE MAY BE SPLIT AT ANY POINT, BUT
C                   FOR HIGHEST PRECISION, SET TJDH TO BE THE INTEGRAL
C                   PART OF THE JULIAN DATE, AND SET TJDL TO BE THE
C                   FRACTIONAL PART
C          GST    = GREENWICH (MEAN OR APPARENT) SIDEREAL TIME
C                   IN HOURS (OUT)
C
C     NOTE:  FOR MOST APPLICATIONS, BASIS FOR INPUT JULIAN DATE SHOULD
C     BE UT1, WHICH RESULTS IN ORDINARY SIDEREAL TIME OUTPUT IN GST.
C     USE OF INPUT JULIAN DATE BASED ON TDB RESULTS IN 'DYNAMICAL
C     SIDEREAL TIME'.
C
C
      DOUBLE PRECISION TJDH,TJDL,TJD,TH,TL,T0,T,T2,T3,GST,
     .     X,EQEQ,ST,DMOD
C
      DATA T0 / 2451545.00000000D0 /
C     T0 = TDB JULIAN DATE OF EPOCH J2000.0
C
      TJD = TJDH + TJDL
      TH = (TJDH - T0) / 36525.0D0
      TL =  TJDL       / 36525.0D0
      T = TH + TL
      T2 = T * T
      T3 = T2 * T
C
C     FOR APPARENT SIDEREAL TIME, OBTAIN EQUATION OF THE EQUINOXES
      EQEQ = 0.0D0
C
      ST = EQEQ - 6.2D-6*T3 + 0.093104D0*T2 + 67310.54841D0
     .     + 8640184.812866D0 *TL
     .     + 3155760000.0D0   *TL
     .     + 8640184.812866D0 *TH
     .     + 3155760000.0D0   *TH
C
      GST = DMOD (ST / 3600.0D0, 24.0D0)
      IF (GST.LT.0.0D0) GST = GST + 24.0D0
      RETURN
C
      END



      subroutine sourcepath(trsteps,thetap,phip,trierr)

      implicit none
      COMMON /CRTRAJ/  DECL,RA,TRAD,TYEAR,TMONTH,TDAY,THOUR,
     *                 TMINUTE,TSECOND,DURATION,TRAJLOGIC
      DOUBLE PRECISION DECL,RA,TRAD
      INTEGER TYEAR,TMONTH,TDAY,THOUR,TMINUTE,TSECOND,
     *        DURATION,TRSTEPS
      LOGICAL TRAJLOGIC

C#define __RUNPARINC__
      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,
     
     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT
      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH



C      integer*8 tyear,tmonth,tday,thour,tminute,tsecond
      double precision thetap,phip
C,decl,ra
      double precision gmststart,lmststart
C      double precision duration,trad
      double precision alpha,radius,ha,alt,azim,lmst,phi,dec,lambda
      double precision ra1,decl1
      integer*8 trierr, ifirst,n,is,is2
      double precision juliandate,hourplus,juliandatefrac,trtemp

      data n/0/
      data ifirst/0/
      data is/0/
      data is2/0/

      save ifirst,n,is,is2,lambda,lmststart,phi

      if (ifirst.eq.0) then

C      lambda = (17, 53, 26.525, '-') geograph. longitude in hours 
C                                   (degrees x 1 hour / 15 degrees)
       lambda=(17.+53./60.+26.525/3600.)/15.
C      phi= (28, 45, 42.462, '+'), geograph. latitude in radians
       phi=(28.+45./60.+42.462/3600.)*4.*asin(1.)/360.

       hourplus=dble(thour)+dble(tminute)/60.+dble(tsecond)/3600.
       juliandatefrac=0.0
       call JULDAT(tyear,tmonth,tday,hourplus,juliandate)
       call SIDTIM(juliandate,juliandatefrac,gmststart)
       lmststart= gmststart - lambda
       write (68,*) decl,ra,tyear,tmonth,tday,thour,tminute,
     *             duration,trsteps,trad,gmststart,lmststart

       ifirst=1
       n=0 
      
      endif


      n=n+1

C simulate extended source using diffusion in RA Dec      
C trad now given in arcminutes!!!!
      if (trad.gt.0) then
         alpha=4.*asin(1.)*RAND(is)
         radius=trad/60.*sqrt(RAND(is2))
         print *, alpha, radius, trad
         decl1=decl+radius*cos(alpha)
         ra1=ra+radius*sin(alpha)/15.
      else
         decl1=decl
         ra1=ra
      endif

C at this point dec in degrees and ra in hours      

      dec=decl1*4.*asin(1.)/360.

      lmst=lmststart+dble(n)*(dble(duration)/3600.)/dble(trsteps)

C hour angle in radians, when ra given in hours in input
      ha=(lmst-ra1)*4.*asin(1.)/24.


C coordinate conversion
C  asin(1.) = pi/2

      alt = asin(sin(phi)*sin(dec)+cos(phi)*cos(dec)*cos(ha))
C      if (cos(phi) < 0.00001) then
C (polar case)
C         azim=ha
C      else
         trtemp= (sin(dec) - sin(alt)*sin(phi))/(cos(alt)*cos(phi))
         trtemp= 2.*asin(1.) - acos(trtemp)
         if (sin(ha)<0.) then
              azim=trtemp
         else
              azim = -trtemp
         endif
C      endif
      if (azim > 4.*asin(1.)) then
         azim = azim - 4.*asin(1.)
      endif
      if (azim < 0. ) then
         azim = azim + 4.*asin(1.)
      endif

      thetap=(asin(1.)-alt)

C subtract 7 degrees because corsikas north is magnetic north
C whereas coordinates are calculated w.r.t. geographic north
      phip=azim-(7./90.*asin(1.))

      write(68,*) n, lmst, ha, alt, azim, thetap, phip

      if (n.eq.trsteps) then 
      print *,'COME TO END,IFIRST=0'
      ifirst=0
      n=0
      return
      endif

      return

      end

C>>>>>>>>>>>>>>>>>>>>>>>>>>>>changed trajectory>>>>>>>>>>>>>>>>>>






*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE ADDANG3( COST0,CPHI0,SPHI0, COST,PHI,
     *                                            COST1,CPHI1,SPHI1 )

C-----------------------------------------------------------------------
C  ADD(ITION OF) ANG(LES)
C
C  THIS SUBROUTINE IS CALLED FROM MANY ROUTINES.
C  ARGUMENTS:
C   COST0  =  COSINE THETA       OF PARTICLE BEFORE
C   CPHI0  =  DIRECTION COS IN X OF PARTICLE BEFORE
C   SPHI0  = -DIRECTION COS IN Y OF PARTICLE BEFORE
C   COST   =  COSINE THETA       OF ANGLE TO ADD
C   PHI    =  ANGLE  PHI         OF ANGLE TO ADD
C   COST1  =  COSINE THETA       OF PARTICLE AFTER ADDITION OF ANGLES
C   CPHI1  =  DIRECTION COS IN X OF PARTICLE AFTER ADDITION OF ANGLES
C   SPHI1  = -DIRECTION COS IN Y OF PARTICLE AFTER ADDITION OF ANGLES
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION COSDEL,COST,COST0,COST1,CPHI0,CPHI1,
     *                 PHI,PHIX,PHIY,RADINV,
     *                 SINDEL,SINT,SINPSI,SINPS2,SPHI0,SPHI1
      SAVE
C-----------------------------------------------------------------------

CC    IF ( DEBUG ) WRITE(MDEBUG,*) 'ADDANG3:'

      SINT   = SQRT( (1.D0-COST) * (1.D0+COST) )
      SINPS2 = CPHI0**2 + SPHI0**2
C  SMALL POLAR ANGLE CASE
      IF ( SINPS2 .LT. 1.D-40 ) THEN
        CPHI1  = SINT * COS( -PHI )
        SPHI1  = SINT * SIN( -PHI )
        COST1  = COST * COST0
      ELSE
        PHIX   = SINT * COS( -PHI )
        PHIY   = SINT * SIN( -PHI )
        SINPSI = SQRT( SINPS2 )
        COSDEL =  CPHI0 * (1.D0/SINPSI)
        SINDEL = -SPHI0 * (1.D0/SINPSI)
        CPHI1  =  COST0 * COSDEL * PHIX - SINDEL * PHIY + CPHI0 * COST
        SPHI1  = -COST0 * SINDEL * PHIX - COSDEL * PHIY + SPHI0 * COST
        COST1  = -SINPSI * PHIX + COST0 * COST
      ENDIF
      RADINV = 1.5D0 - 0.5D0 * ( CPHI1**2 + SPHI1**2 + COST1**2 )
      CPHI1  = MIN( 1.D0, MAX( -1.D0, RADINV * CPHI1 ) )
      SPHI1  = MIN( 1.D0, MAX( -1.D0, RADINV * SPHI1 ) )
      COST1  = MIN( 1.D0, MAX( -1.D0, RADINV * COST1 ) )

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE ADDANG4( COST0,CPHI0,SPHI0, COST,CPHI,SPHI,
     *                                            COST1,CPHI1,SPHI1 )

C-----------------------------------------------------------------------
C  ADD(ITION OF) ANG(LES)
C
C  THIS SUBROUTINE IS CALLED FROM MANY ROUTINES.
C  ARGUMENTS:
C   COST0  =  COSINE THETA       OF PARTICLE BEFORE
C   CPHI0  =  DIRECTION COS IN X OF PARTICLE BEFORE
C   SPHI0  = -DIRECTION COS IN Y OF PARTICLE BEFORE
C   COST   =  DIRECTION COSINE THETA    OF ANGLE TO ADD
C   CPHI   =  DIRECTION COSINE PHI      OF ANGLE TO ADD
C   SPHI   =  DIRECTION COSINE PHI      OF ANGLE TO ADD
C   COST1  =  COSINE THETA       OF PARTICLE AFTER ADDITION OF ANGLES
C   CPHI1  =  DIRECTION COS IN X OF PARTICLE AFTER ADDITION OF ANGLES
C   SPHI1  = -DIRECTION COS IN Y OF PARTICLE AFTER ADDITION OF ANGLES
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION COSDEL,COST,COST0,COST1,CPHI,CPHI0,CPHI1,
     *                 RADINV,SINDEL,SINPSI,SINPS2,SPHI,SPHI0,SPHI1
      SAVE
C-----------------------------------------------------------------------

CC    IF ( DEBUG ) WRITE(MDEBUG,*) 'ADDANG4:'

      SINPS2 = CPHI0**2 + SPHI0**2
C  SMALL POLAR ANGLE CASE
      IF ( SINPS2 .LT. 1.D-40 ) THEN
        CPHI1 =  CPHI
        SPHI1 = -SPHI
        COST1 = COST * COST0
      ELSE
        SINPSI =  SQRT( SINPS2 )
        COSDEL =  CPHI0 * (1.D0/SINPSI)
        SINDEL = -SPHI0 * (1.D0/SINPSI)
        CPHI1  =  COST0 * COSDEL * CPHI + SINDEL * SPHI + CPHI0 * COST
        SPHI1  = -COST0 * SINDEL * CPHI + COSDEL * SPHI + SPHI0 * COST
        COST1  = -SINPSI * CPHI + COST0 * COST
      ENDIF
      RADINV = 1.5D0 - 0.5D0 * ( CPHI1**2 + SPHI1**2 + COST1**2 )
      CPHI1  = MIN( 1.D0, MAX( -1.D0, RADINV * CPHI1 ) )
      SPHI1  = MIN( 1.D0, MAX( -1.D0, RADINV * SPHI1 ) )
      COST1  = MIN( 1.D0, MAX( -1.D0, RADINV * COST1 ) )

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE ADDANI( COST0,PHI0, COST1,PHI1, DCTH,DPHI )

C-----------------------------------------------------------------------
C  ADD(ITION OF) AN(GLES) I(NVERTED)
C
C  GIVEN TWO DIRECTIONS (0 AND 1) IN A COMMON SYSTEM OF REFERENCE.
C  FIND DCTH AND DPHI SUCH, THAT THE SUBROUT. ADDANG TRANSFORMS
C  (COST0,PHI0) BY ADDING (DCTH,DPHI) INTO (COST1,PHI1).
C  CALCULATION IS DONE BY SEQUENTIAL ROTATIONS :
C    1. ROTATE VECTOR AROUND Z AXIS BY -PHI1
C    2. ROTATE VECTOR AROUND Y AXIS BY -THETA1
C  NOW VECTOR IS (X,Y,Z) WITH DCTH      = Z
C                         AND TAN(DPHI) = Y/X
C  THIS SUBROUTINE IS CALLED FROM MUDECY.
C  ARGUMENTS:
C   COST0  = COSINE THETA OF PARTICLE BEFORE
C   PHI0   = PHI          OF PARTICLE BEFORE
C   COST1  = COSINE THETA OF PARTICLE
C   PHI1   = PHI          OF PARTICLE
C   DCTH   = COSINE THETA OF ANGLE
C   DPHI   = PHI          OF ANGLE
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION COST0,COST1,CP,CP1,CT,CT1,DCTH,DPHI,PHI0,PHI1,
     *                 SP,SP1,ST,ST1,X,XX,Y,YY,Z,ZZ
      SAVE
C-----------------------------------------------------------------------

CC    IF ( DEBUG ) WRITE(MDEBUG,*) 'ADDANI:'

      CT  = COST0
      ST  = SQRT( (1.D0-CT) * (1.D0+CT) )
      CP  = COS( PHI0 )
      SP  = SIN( PHI0 )
      CT1 = COST1
      ST1 = SQRT( (1.D0-CT1) * (1.D0+CT1) )
      CP1 = COS( PHI1 )
      SP1 = SIN( PHI1 )

      X = ST1 * CP1
      Y = ST1 * SP1
      Z = CT1

      XX =  CT*CP*X + CT*SP*Y - ST*Z
      YY = (-SP) *X + CP   *Y
      ZZ =  ST*CP*X + ST*SP*Y + CT*Z

C  GET NEW COSINE(THETA) AND PHI
      DCTH   = ZZ
      IF ( YY .NE. 0.D0  .OR.  XX .NE. 0.D0 ) THEN
        DPHI = ATAN2( YY, XX )
      ELSE
        DPHI = 0.D0
      ENDIF

      RETURN
      END

*-- Author :    The CORSIKA development group   16/05/1995
C=======================================================================

      SUBROUTINE AMOEBA( P,Y,MP,NP,NDIM,FTOL,FUNK,ITER,IFLAG )

C-----------------------------------------------------------------------
C
C  FITTING ROUTINE
C  REFERENCE : NUMERICAL RECIPES, W.H. PRESS ET AL.,
C              CAMBRIDGE UNIVERSITY PRESS, 1992  ISBN 0 521 43064 X
C  ADAPTED FOR DOUBLE PRECISION
C  USES AMOTRY,FUNK
C  THIS SUBROUTINE IS CALLED FROM LONGFT.
C  ARGUMENTS:
C   P      =  ARRAY (NPAR+1,NPAR) WITH PARAMETERS FOR FIT
C   Y      =  ARRAY WITH ERRORS
C   MP     =  NUMBER NPAR+1
C   NDIM   =  NUMBER NPAR OF FREE VARIABLES
C   FTOL   =  TOLERANCE OF FIT
C   FUNK   =  EXTERNAL FUNKTION (GIVING DERIVATIVES)
C   ITER   =  ITERATION COUNTER
C   IFLAG  =  ERROR FLAG
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      INTEGER          ITMAX,NMAX
C  MAXIMUM NUMBER OF TRIAL PER CALL
      PARAMETER        (ITMAX=5000)
      PARAMETER        (NMAX=20)
      INTEGER          MP,NP
      DOUBLE PRECISION FTOL,P(MP,NP),PSUM(NMAX),
     *                 RTOL,SUM,SWAP,Y(MP),YSAVE,YTRY
      INTEGER          I,IFLAG,IHI,ILO,INHI,ITER,J,M,N,NDIM
      DOUBLE PRECISION AMOTRY,FUNK
      SAVE
      EXTERNAL         AMOTRY,FUNK
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,*) 'AMOEBA:'

      IFLAG = 0
      ITER  = 0
  1   CONTINUE
      DO  N = 1, NDIM
        SUM = 0.D0
        DO  M = 1, NDIM+1
          SUM = SUM + P(M,N)
        ENDDO
        PSUM(N) = SUM
      ENDDO
  2   CONTINUE
      ILO = 1
      IF ( Y(1) .GT. Y(2) ) THEN
        IHI  = 1
        INHI = 2
      ELSE
        IHI  = 2
        INHI = 1
      ENDIF
      DO  I = 1, NDIM+1
        IF ( Y(I) .LE. Y(ILO) ) ILO = I
        IF     ( Y(I) .GT.  Y(IHI) ) THEN
          INHI = IHI
          IHI  = I
        ELSEIF ( Y(I) .GT. Y(INHI) ) THEN
          IF ( I .NE. IHI ) INHI = I
        ENDIF
      ENDDO
      RTOL = 2.D0*ABS(Y(IHI)-Y(ILO))/(ABS(Y(IHI))+ABS(Y(ILO)))
      IF ( RTOL .LT. FTOL ) THEN
        SWAP   = Y(1)
        Y(1)   = Y(ILO)
        Y(ILO) = SWAP
        DO  N = 1, NDIM
          SWAP     = P(1,N)
          P(1,N)   = P(ILO,N)
          P(ILO,N) = SWAP
        ENDDO
        RETURN
      ENDIF
      IF ( ITER .GE.ITMAX ) THEN
        IF ( DEBUG ) WRITE(MDEBUG,*) 'AMOEBA: ITMAX EXCEEDED IN AMOEBA'
        IFLAG = 1
        RETURN
      ENDIF
      ITER = ITER + 2
      YTRY = AMOTRY( P,Y,PSUM,MP,NP,NDIM,FUNK,IHI,-1.0D0 )
      IF     ( YTRY .LE.  Y(ILO) ) THEN
        YTRY = AMOTRY( P,Y,PSUM,MP,NP,NDIM,FUNK,IHI,2.0D0 )
      ELSEIF ( YTRY .GE. Y(INHI) ) THEN
        YSAVE = Y(IHI)
        YTRY = AMOTRY( P,Y,PSUM,MP,NP,NDIM,FUNK,IHI,0.5D0 )
        IF ( YTRY .GE. YSAVE ) THEN
          DO  I = 1, NDIM+1
            IF ( I .NE. ILO ) THEN
              DO  J = 1, NDIM
                PSUM(J) = 0.5D0 * (P(I,J) + P(ILO,J))
                P(I,J)  = PSUM(J)
              ENDDO
              Y(I) = FUNK( PSUM )
            ENDIF
          ENDDO
          ITER = ITER + NDIM
          GOTO 1
        ENDIF
      ELSE
        ITER = ITER - 1
      ENDIF
      GOTO 2

      END
C=======================================================================

      DOUBLE PRECISION FUNCTION AMOTRY(P,Y,PSUM,MP,NP,NDIM,FUNK,IHI,FAC)

C-----------------------------------------------------------------------
C
C  REFERENCE : NUMERICAL RECIPES, W.H. PRESS ET AL.,
C              CAMBRIDGE UNIVERSITY PRESS, 1992  ISBN 0 521 43064 X
C  ADAPTED FOR DOUBLE PRECISION
C  USES EXTERNAL FUNCTION FUNK
C  THIS FUNCTION IS CALLED FROM AMOEBA
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      INTEGER          MP,NP,NMAX
      PARAMETER        (NMAX=20)
      DOUBLE PRECISION FAC,P(MP,NP),PSUM(NP),Y(MP),FUNK
      DOUBLE PRECISION FAC1,FAC2,YTRY,PTRY(NMAX)
      INTEGER          IHI,NDIM,J
      SAVE
      EXTERNAL         FUNK
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,*) 'AMOTRY:'

      FAC1 = (1.D0-FAC)/NDIM
      FAC2 = FAC1-FAC
      DO  J = 1, NDIM
        PTRY(J) = PSUM(J) * FAC1 - P(IHI,J) * FAC2
      ENDDO
      YTRY = FUNK( PTRY )
      IF ( YTRY .LT. Y(IHI) ) THEN
        Y(IHI) = YTRY
        DO  J = 1, NDIM
          PSUM(J)  = PSUM(J) - P(IHI,J) + PTRY(J)
          P(IHI,J) = PTRY(J)
        ENDDO
      ENDIF
      AMOTRY = YTRY

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      BLOCK DATA BLOCK1

C-----------------------------------------------------------------------
C
C  INITIALIZES DATA
C  THIS ROUTINE IS CALLED FROM AAMAIN
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRAIR/   COMPOS,PROBTA,AVERAW,AVOGDR
      DOUBLE PRECISION COMPOS(3),PROBTA(3),AVERAW,AVOGDR

      COMMON /CRATMOS/ AATM,AATM0,BATM,BATM0,CATM,CATM0,DATM,MODATM
      DOUBLE PRECISION AATM(5),AATM0(5,0:22),BATM(5),BATM0(5,0:22),
     *                 CATM(5),CATM0(5,0:22),DATM(5)
      INTEGER          MODATM

      COMMON /CRATMOS2/HLAY,HLAY0,THICKL,LAYNO,LAYNEW
      DOUBLE PRECISION HLAY(6),HLAY0(5,0:9),THICKL(5)
      INTEGER          LAYNO(0:22)
      LOGICAL          LAYNEW

      COMMON /CRBUFFS/ RUNH,RUNE,EVTH,EVTE,DATAB,ARRAYLONG,LH
      INTEGER          MAXBUF,MAXLEN
      PARAMETER        (MAXLEN=16)

      PARAMETER        (MAXBUF=39*7)
      REAL             RUNH(MAXBUF),EVTH(MAXBUF),EVTE(MAXBUF),
     *                 RUNE(MAXBUF),DATAB(MAXBUF),ARRAYLONG(MAXBUF)
      INTEGER          LH
      CHARACTER*4      CRUNH,CRUNE,CEVTH,CEVTE,CLONG
      EQUIVALENCE      (RUNH(1),CRUNH), (RUNE(1),CRUNE)
      EQUIVALENCE      (EVTH(1),CEVTH), (EVTE(1),CEVTE)
      EQUIVALENCE      (ARRAYLONG(1),CLONG)

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CREDECAY/CETA
      DOUBLE PRECISION CETA(5)

      COMMON /CRGNUPR/ SE14,SE16,SE40
      DOUBLE PRECISION SE14(3,14),SE16(3,16),SE40(3,40)

      COMMON /CRKAONS/ CKA
      DOUBLE PRECISION CKA(80)

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRNKGI/  SEL,SELLG,STH,ZEL,ZELLG,ZSL,DIST,
     *                 DISX,DISY,DISXY,DISYX,DLAX,DLAY,DLAXY,DLAYX,
     *                 OBSATI,RADNKG,RMOL,TLEV,TLEVCM,IALT
      DOUBLE PRECISION SEL(10),SELLG(10),STH(10),ZEL(10),ZELLG(10),
     *                 ZSL(10),DIST(10),
     *                 DISX(-10:10),DISY(-10:10),
     *                 DISXY(-10:10,2),DISYX(-10:10,2),
     *                 DLAX (-10:10,2),DLAY (-10:10,2),
     *                 DLAXY(-10:10,2),DLAYX(-10:10,2),
     *                 OBSATI(2),RADNKG,RMOL(2),TLEV(10),TLEVCM(10)
      INTEGER          IALT(2)

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRREST/  CONTNE,TAR,LT
      DOUBLE PRECISION CONTNE(3),TAR
      INTEGER          LT

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSTACKF/STACKI,MSTACKP,MEXST,NSHIFT,NOUREC,ICOUNT,
     *                 NTO,NFROM
      INTEGER          MAXSTK

      PARAMETER        (MAXSTK = 17*256*2)
      DOUBLE PRECISION STACKI(MAXSTK)
      INTEGER          MSTACKP,MEXST,NSHIFT,NOUREC,ICOUNT,NTO,NFROM

      COMMON /CRSTRBAR/CSTRBA
      DOUBLE PRECISION CSTRBA(11)

      COMMON /CRVERS/  VERNUM,MVDATE,VERDAT
      DOUBLE PRECISION VERNUM
      INTEGER          MVDATE
      CHARACTER*18     VERDAT

      COMMON /CRCEREN3/CERCNT,DATAB2,NRECER,LHCER
      INTEGER          MAXBF2

      PARAMETER        ( MAXBF2 = 39 * 7 )

      DOUBLE PRECISION CERCNT
      REAL             DATAB2(MAXBF2)
      INTEGER          NRECER,LHCER

       

       

       

       

      INTEGER          I,J
C-----------------------------------------------------------------------

C  AIR
      DATA COMPOS / 0.78479D0, 0.21052D0, 0.00469D0 /
      DATA PROBTA / 0.78479D0, 0.99531D0, 1.D0      /
      DATA AVERAW / 14.543D0 /
C  VALUE OF AVOGADRO REVISED SEPT. 2000 BY D.H.
      DATA AVOGDR / 6.02214199D-4 /

C  ATMOS (U.S.STANDARD IS DEFAULT)
      DATA AATM / -186.5562D0,  -94.919D0,  0.61289D0,0.D0,.01128292D0 /
      DATA BATM / 1222.6562D0,1144.9069D0,1305.5948D0,540.1778D0,1.D0  /
      DATA CATM / 994186.38D0,878153.55D0,636143.04D0,772170.16D0,1.D9 /

      DATA ((AATM0(I,J),I=1,5),J=0,10)
     * /-186.5562D0, -94.919D0  ,.61289D0  ,        0.D0 , .01128292D0 ,
     *  -186.5562D0, -94.919D0  ,.61289D0  ,        0.D0 , .01128292D0 ,
     *  -118.1277D0,-154.258D0  ,.4191499D0, 5.4094056D-4, .01128292D0 ,
     * -195.837264D0,-50.4128778D0,.345594007D0,5.46207D-4,.01128292D0 ,
     * -253.95047D0,-128.97714D0,.353207D0 , 5.526876D-4 , .01128292D0 ,
     * -208.12899D0,-120.26179D0,.31167036D0,5.591489D-4 , .01128292D0 ,
     * -77.875723D0,-214.96818D0,.3721868D0, 5.5309816D-4, .01128292D0 ,
     * -242.56651D0,-103.21398D0,.3349752D0, 5.527485D-4 , .01128292D0 ,
     * -195.34842D0,-71.997323D0,.3378142D0, 5.48224D-4  , .01128292D0 ,
     *    0.D0     , 0.D0       ,      0.D0, 0.D-4       , .01128292D0 ,
     *    0.D0     , 0.D0       ,      0.D0, 0.D-4       , .01128292D0 /
      DATA ((AATM0(I,J),I=1,5),J=11,22)
     * /-137.656D0,  -37.9610D0,   .222659D0, -6.16201D-4 ,.00207722D0 ,
     *  -163.331D0,  -65.3713D0,   .402903D0, -4.79198D-4 ,.00188667D0 ,
     *  -142.801D0,  -70.1538D0,   1.14855D0, -9.10269D-4 ,.00152236D0 ,
     *  -128.601D0,  -39.5548D0,   1.13088D0, -26.4960D-4 ,.00192534D0 ,
     *  -113.139D0,  -79.0635D0,  -54.3888D0,  0.D0       ,.4210330D-2 ,
     *  -59.0293D0,  -21.5794D0,  -7.14839D0,  0.D0       ,.1901750D-3 ,
     *-150.247839D0,-6.66194377D0,.94880452D0,4.8966557223D-4,
     *                                                      .01128292D0,
     *-126.110950D0,-47.6124452D0,1.00758296D0,5.1046180899D-4,
     *                                                      .01128292D0,
     *-159.683519D0,-79.5570480D0,.98914795D0,4.87191289D-4,.01128292D0,
     *-136.562242D0,-44.216539D0,1.37778789D0,5.06583365D-4,.01128292D0,
     *-149.305029D0,-59.771936D0,1.17357181D0,5.03287179D-4,.01128292D0,
     *-149.801663D0,-57.932486D0, .63631894D0,4.35453690D-4,.01128292D0/
      DATA ((BATM0(I,J),I=1,5),J=0,10)
     * / 1222.6562D0, 1144.9069D0, 1305.5948D0, 540.1778D0, 1.D0   ,
     *   1222.6562D0, 1144.9069D0, 1305.5948D0, 540.1778D0, 1.D0   ,
     *   1173.9861D0, 1205.7625D0, 1386.7807D0, 555.8935D0, 1.D0   ,
     *   1240.48D0  , 1117.85D0  , 1210.9D0   , 608.2128D0, 1.D0   ,
     *   1285.2782D0, 1173.1616D0, 1320.4561D0, 680.6803D0, 1.D0   ,
     *   1251.474D0 , 1173.321D0 , 1307.826D0 , 763.1139D0, 1.D0   ,
     *   1103.3362D0, 1226.5761D0, 1382.6933D0, 685.6073D0, 1.D0   ,
     *   1262.7013D0, 1139.0249D0, 1270.2886D0, 681.4061D0, 1.D0   ,
     *   1210.4D0   , 1103.8629D0, 1215.3545D0, 629.7611D0, 1.D0   ,
     *      0.D0    ,    0.D0    ,    0.D0    ,   0.D0    , 1.D0   ,
     *      0.D0    ,    0.D0    ,    0.D0    ,   0.D0    , 1.D0   /
      DATA ((BATM0(I,J),I=1,5),J=11,22)
     * /   1130.74D0,   1052.05D0,   1137.21D0,   442.512D0, 1.D0  ,
     *     1183.70D0,   1108.06D0,   1424.02D0,   207.595D0, 1.D0  ,
     *     1177.19D0,   1125.11D0,   1304.77D0,   433.823D0, 1.D0  ,
     *     1139.99D0,   1073.82D0,   1052.96D0,   492.503D0, 1.D0  ,
     *     1133.10D0,   1101.20D0,   1085.00D0,   1098.00D0, 1.D0  ,
     *     1079.00D0,   1071.90D0,   1182.00D0,   1647.10D0, 1.D0  ,
     *   1198.5972D0, 1198.8796D0, 1419.4152D0,  730.6380D0, 1.D0  ,
     *   1179.5010D0, 1172.4883D0, 1437.4911D0,  761.3281D0, 1.D0  ,
     *   1202.8804D0, 1148.6275D0, 1432.0312D0, 696.42788D0, 1.D0  ,
     *   1175.3347D0, 1180.3694D0, 1614.5404D0, 755.56438D0, 1.D0  ,
     *   1196.9290D0, 1173.2537D0, 1502.1837D0, 750.89705D0, 1.D0  ,
     *   1183.6071D0, 1143.0425D0, 1322.9748D0, 655.67307D0, 1.D0  /
      DATA ((CATM0(I,J),I=1,5),J=0,10)
     * / 994186.38D0, 878153.55D0, 636143.04D0, 772170.16D0, 1.D9  ,
     *   994186.38D0, 878153.55D0, 636143.04D0, 772170.16D0, 1.D9  ,
     *   919546.D0  , 963267.92D0, 614315.D0  , 739059.6D0 , 1.D9  ,
     *   933697.D0  , 765229.D0  , 636790.D0  , 733793.8D0 , 1.D9  ,
     *  1088310.D0  , 935485.D0  , 635137.D0  , 727312.6D0 , 1.D9  ,
     *  1032310.D0  , 925528.D0  , 645330.D0  , 720851.4D0 , 1.D9  ,
     *   932077.D0  ,1109960.D0  , 630217.D0  , 726901.3D0 , 1.D9  ,
     *  1059360.D0  , 888814.D0  , 639902.D0  , 727251.8D0 , 1.D9  ,
     *   970276.D0  , 820946.D0  , 639074.D0  , 731776.5D0 , 1.D9  ,
     *        0.D0  ,      0.D0  ,      0.D0  ,       0.D0 , 1.D9  ,
     *        0.D0  ,      0.D0  ,      0.D0  ,       0.D0 , 1.D9  /
      DATA ((CATM0(I,J),I=1,5),J=11,22)
     * / 867358.D0  , 741208.D0  , 633846.D0  , 759850.D0, 5.4303203D9,
     *   875221.D0  , 753213.D0  , 545846.D0  , 793043.D0, 5.9787908D9,
     *   861745.D0  , 765925.D0  , 581351.D0  , 775155.D0, 7.4095699D9,
     *   861913.D0  , 744955.D0  , 675928.D0  , 829627.D0, 5.8587010D9,
     *   861730.D0  , 826340.D0  , 790950.D0  , 682800.D0, 2.6798156D9,
     *   764170.D0  , 699910.D0  , 635650.D0  , 551010.D0, 59.329575D9,
     *   945766.30D0, 681780.12D0, 620224.52D0, 728157.92D0, 1.D9  ,
     *   939228.66D0, 787969.34D0, 620008.53D0, 724585.33D0, 1.D9  ,
     *   977139.52D0, 858087.01D0, 614451.60D0, 730875.73D0, 1.D9  ,
     *   986169.72D0, 793171.45D0, 600120.97D0, 725247.87D0, 1.D9  ,
     *   985241.10D0, 819245.00D0, 611220.86D0, 725797.06D0, 1.D9  ,
     *   954248.34D0, 800005.34D0, 629568.93D0, 737521.77D0, 1.D9  /
      DATA (LAYNO(J), J=0,22)
     * / 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 2, 3, 4, 5, 6,
     *   7, 8, 9 /
      DATA (HLAY(I),I=1,5)
     * /     -5779.5D2 ,   4.D5  ,      1.D6  ,     4.D6,   1.D7     /
      DATA ((HLAY0(I,J),I=1,5),J=0,9)
     * /     -5779.5D2 ,   4.D5  ,      1.D6  ,     4.D6 ,  1.D7     ,
     *       -5779.5D2 ,   4.D5  ,      1.D6  ,     4.D6 ,  1.D7     ,
     *        0.D0  , 2.66667D5  , 5.33333D5  ,     8.D5 ,  1.D7     ,
     *        0.D0  , 6.66667D5  ,13.33333D5  ,    20.D5 ,  1.D7     ,
     *        0.D0  ,     8.0D5  ,    18.1D5  ,    34.5D5,  1.D7     ,
     *        0.D0  ,     8.3D5  ,    12.9D5  ,    34.0D5,  1.D7     ,
     *        0.D0  ,     5.9D5  ,    12.0D5  ,    34.5D5,  1.D7     ,
     *        0.D0  ,     9.0D5  ,    14.6D5  ,    33.0D5,  1.D7     ,
     *        0.D0  ,     8.0D5  ,    13.0D5  ,    33.5D5,  1.D7     ,
     *        0.D0  ,     7.0D5  ,    11.4D5  ,    37.0D5,  1.D7     /

C  CEREN3
      DATA CERCNT / 0.D0 /

C  CONSTA
      DATA PI  / 3.141592653589793D0 /
      DATA PI2 / 6.283185307179586D0 /
      DATA OB3 / 0.333333333333333D0 /
      DATA TB3 / 0.666666666666666D0 /
C  ENEPER IS CALCULATED IN START: ENEPER = EXP(1.D0)
C  DATA FOR MUPART: CUTOFF FOR BREMSSTRAHLUNG AT 3 MEV
      DATA BCUT /0.003D0/
C  DATA FOR REST: AVERAGE ATOMIC WEIGHT, NEUTRON CONTENTS OF N,O,AR
      DATA TAR / 14.6D0 /, CONTNE / 0.5D0, 0.5D0, 0.55D0 /, LT / 1 /
C  KAON CONSTANTS
C  REVISED NOV. 2004 BY D. HECK
      DATA CKA /     0.D0 ,  0.1D0,     0.D0 ,     0.D0,     0.D0 ,
     *               0.D0 , 0.25D0,     0.5D0,   0.75D0,     1.D0 , !10
     *               0.5D0,  0.2D0,     0.D0 ,    0.D0 ,   149.6D0,
     *             149.6D0,0.236D0,   0.206D0,  0.135D0,   0.222D0, !20
     *               0.5D0,  0.D0 ,  0.6343D0, 0.6895D0,  0.8737D0,
     *             0.6624D0,.3895D0,    0.D0 ,    0.D0 ,     0.D0 , !30
     *               0.D0 ,  0.D0 ,     0.D0 ,    0.D0 ,     1.D0 ,
     *               1.0D5,  0.D0 ,     0.D0 ,    0.D0 ,     0.D0 , !40
     *               0.D0 ,  0.D0 ,     0.D0 ,    0.D0 ,     0.D0 ,
     *               0.D0 ,0.8456D0, 0.9014D0, 0.9501D0,  0.9828D0, !50
     *           -0.2154D0, 0.012D0,-0.0101D0,   1.27D0,   0.638D0,
     *             0.057D0,   0.D0 ,   1.84D0,    0.D0 ,     1.D0 , !60
     *             0.678D0, 0.076D0, 0.0099D0,   2.22D0,  0.0277D0,
     *               0.D0 ,1.288D-2, 0.0278D0,  1.74D-2,  1.194D-2, !70
     *            0.0291D0,   0.D0 , 1.310D-2,  0.033D0,   0.027D0,
     *            1.241D-2,   0.D0 ,    0.D0 ,    0.D0 ,     0.D0  /
C  DATA FOR ETA DECAY
C  REVISED NOV. 2004 BY D. HECK
      DATA CETA /  0.3946D0,  0.7200D0,  0.9496D0,  -1.07D0,  2.07D0 /
C  DATA FOR STRANGE BARYON DECAY
C  REVISED NOV. 2004 BY D. HECK
      DATA CSTRBA / 0.D0     , 0.D0 , 0.D0 , 0.D0 , 0.6482D0,
     *              0.5163D0 , 0.D0 , 0.D0 , 0.D0 , 0.678D0 ,
     *              0.914D0 /
C  PARPAR
C  REVISED NOV. 2004 BY D. HECK
      DATA C /6371315.D2,  6.0D5,     20.0D5,    0.D0 ,         0.D0 ,
     *           0.D0 ,    0.D0 ,      0.D0 ,    2.5D0,        2.07D0,
     *           8.2D0,    0.1D0,      0.D0 ,    0.D0 ,         0.D0 ,
     *           0.D0 ,    0.D0 ,      0.D0 ,    0.D0 ,         0.D0 ,
     *          37.7D0, 1.532873D-4, 9.386417D0, 2.D-3,  29.9792458D9,
     *           1.D0 ,    0.D0 ,     1.57D0,    0.D0 ,       0.021D0,
     *           0.D0 ,    0.D0 ,      0.D0 ,    2.0D1,         0.D0 ,
     *           0.D0 ,    0.D0 ,      0.D0 ,    0.D0 ,         0.D0 ,
     *           0.D0 ,    0.D0 ,      0.D0 ,    0.D0 ,         0.D0 ,
     *           0.D0 ,    0.D0 ,      0.D0 ,    0.D0 , 137.0359998D0 /
C  RUNPAR , STACKF
      DATA MONIIN /  5 /, MONIOU /  6 /, MPATAP / 90 /, MEXST / 96 /,
     *     MDEBUG /  6 /, NUCNUC / 11 /, MDBASE / 45 /, MTABOUT / 46 /,
     *     MLONGOUT / 48 /
     *    ,MCETAP / 91 /

C  UNRELEASABLE ENERGY (REST MASS) FOR ENERGY DEPOSIT
C  THE REST MASSES FOR NUCLEI ARE SET IN PAMAF
      DATA RESTMS/       0.,  -.511D-3,   .511D-3,       0.,  .105658 ,
     *             .105658 ,        0.,        0.,       0.,        0.,
     *                   0.,        0., .9395654 , .938272 , -.938272 ,
     *                   0.,        0.,     .939 ,    .939 ,     .939 ,
     *                .939 ,     .939 ,     .939 ,    .939 ,-.9395654 ,
     *               -.939 ,    -.939 ,    -.939 ,   -.939 ,    -.939 ,
     *               -.939 ,    -.939 ,        0.,       0.,        0.,
     *                   0.,        0.,        0.,       0.,        0.,
     *                   0.,        0.,        0.,       0.,        0.,
     *                   0.,        0.,        0.,       0.,        0.,
     *                   0.,        0.,        0.,    .939 ,     .939 ,
     *                .939 ,     .939 ,    -.939 ,   -.939 ,    -.939 ,
     *               -.939 ,        0.,        0.,       0.,        0.,
     *                   0.,        0.,        0.,       0.,        0.,
     *                   0.,        0.,        0.,       0.,        0.,
     *       5925*0.D0/
C  GNUPR
C  NITROGEN TARGET  14
      DATA ((SE14(I,J),I=1,3),J=1,14)
     *                       / 0.472000D+00,-0.426710D-02, 0.726439D-04,
     *                         0.230324D+00,-0.989733D-03,-0.807077D-05,
     *                         0.138623D+00, 0.609624D-03,-0.401675D-04,
     *                         0.827139D-01, 0.135103D-02,-0.360236D-04,
     *                         0.445693D-01, 0.137582D-02,-0.137674D-04,
     *                         0.206106D-01, 0.998620D-03, 0.422867D-05,
     *                         0.792756D-02, 0.559858D-03, 0.957875D-05,
     *                         0.247793D-02, 0.247480D-03, 0.701650D-05,
     *                         0.615535D-03, 0.860096D-04, 0.324410D-05,
     *                         0.118279D-03, 0.230732D-04, 0.104282D-05,
     *                         0.169210D-04, 0.461424D-05, 0.235175D-06,
     *                         0.169481D-05, 0.647634D-06, 0.358189D-07,
     *                         0.105988D-06, 0.568994D-07, 0.332920D-08,
     *                         0.311374D-08, 0.235385D-08, 0.143213D-09/
C  OXYGEN TARGET  16
      DATA ((SE16(I,J), I=1,3),J=1,16)
     *                        /0.475002D+00,-0.434401D-02, 0.734217D-04,
     *                         0.230261D+00,-0.966152D-03,-0.982228D-05,
     *                         0.137372D+00, 0.642454D-03,-0.408490D-04,
     *                         0.813380D-01, 0.135241D-02,-0.354835D-04,
     *                         0.437870D-01, 0.135776D-02,-0.134429D-04,
     *                         0.204919D-01, 0.988538D-03, 0.398723D-05,
     *                         0.812995D-02, 0.567070D-03, 0.942943D-05,
     *                         0.269031D-02, 0.263160D-03, 0.728079D-05,
     *                         0.732711D-03, 0.993722D-04, 0.366933D-05,
     *                         0.161940D-03, 0.303662D-04, 0.134776D-05,
     *                         0.285325D-04, 0.740356D-05, 0.371648D-06,
     *                         0.390910D-05, 0.140655D-05, 0.768260D-07,
     *                         0.401145D-06, 0.200620D-06, 0.116200D-07,
     *                         0.290010D-07, 0.202033D-07, 0.121929D-08,
     *                         0.131709D-08, 0.128046D-08, 0.795482D-10,
     *                         0.282645D-10, 0.384068D-10, 0.243535D-11/
C  ARGON TARGET  40
      DATA ((SE40(I,J),I=1,3),J=1,18)
     *                       / 0.318084D+00,-0.352566D-02, 0.829469D-04,
     *                         0.193581D+00,-0.238538D-02, 0.404919D-04,
     *                         0.148699D+00,-0.118791D-02,-0.130378D-04,
     *                         0.117201D+00, 0.966097D-04,-0.536044D-04,
     *                         0.876737D-01, 0.106482D-02,-0.612882D-04,
     *                         0.600279D-01, 0.150343D-02,-0.412273D-04,
     *                         0.370180D-01, 0.147347D-02,-0.130096D-04,
     *                         0.204422D-01, 0.117625D-02, 0.743960D-05,
     *                         0.101003D-01, 0.807913D-03, 0.155153D-04,
     *                         0.447163D-02, 0.489622D-03, 0.146804D-04,
     *                         0.177806D-02, 0.265260D-03, 0.102802D-04,
     *                         0.636671D-03, 0.129412D-03, 0.591434D-05,
     *                         0.205809D-03, 0.571042D-04, 0.291674D-05,
     *                         0.601981D-04, 0.228546D-04, 0.126074D-05,
     *                         0.159631D-04, 0.831226D-05, 0.484001D-06,
     *                         0.384379D-05, 0.275100D-05, 0.166440D-06,
     *                         0.841490D-06, 0.829259D-06, 0.515615D-07,
     *                         0.167633D-06, 0.227810D-06, 0.144446D-07/
      DATA((SE40(I,J),I=1,3),J=19,36)
     *                        /0.304029D-07, 0.570494D-07, 0.366843D-08,
     *                         0.502077D-08, 0.130224D-07, 0.845876D-09,
     *                         0.754786D-09, 0.270844D-08, 0.177211D-09,
     *                         0.103229D-09, 0.512862D-09, 0.337323D-10,
     *                         0.128308D-10, 0.883149D-10, 0.583066D-11,
     *                         0.144721D-11, 0.138082D-10, 0.914113D-12,
     *                         0.147837D-12, 0.195621D-11, 0.129757D-12,
     *                         0.136429D-13, 0.250465D-12, 0.166371D-13,
     *                         0.113379D-14, 0.288894D-13, 0.192092D-14,
     *                         0.845213D-16, 0.299003D-14, 0.198959D-15,
     *                         0.562496D-17, 0.276346D-15, 0.183981D-16,
     *                         0.332222D-18, 0.226723D-16, 0.151001D-17,
     *                         0.172872D-19, 0.163915D-17, 0.109200D-18,
     *                         0.785321D-21, 0.103480D-18, 0.689517D-20,
     *                         0.307886D-22, 0.563885D-20, 0.375787D-21,
     *                         0.102630D-23, 0.261299D-21, 0.174154D-22,
     *                         0.285163D-25, 0.100944D-22, 0.672832D-24,
     *                         0.642589D-27, 0.316302D-24, 0.210839D-25/
      DATA((SE40(I,J),I=1,3),J=37,40)
     *                        /0.112817D-28, 0.772286D-26, 0.514807D-27,
     *                         0.144773D-30, 0.137838D-27, 0.918858D-29,
     *                         0.120779D-32, 0.159956D-29, 0.106632D-30,
     *                         0.491605D-35, 0.905709D-32, 0.603784D-33/

C  VERSION NUMBER AND DATE OF RELEASE
      DATA VERNUM / 6.500 /
      DATA MVDATE / 20060608 /
C                  -YYYYMMDD-
      DATA VERDAT / 'JUNE      08, 2006' /
C                    ----+----+----+---

      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE BOX2

C-----------------------------------------------------------------------
C
C  DETERMINES POINT OF INTERACTION OR DECAY FOR ANY PARTICLE
C  HEAVY PRIMARIES AND STRANGE BARYONS INCLUDED
C  ANNIHILATION CROSS-SECTION INCLUDED
C  PRECISE MEAN FREE PATH FOR DECAYING PARTICLES
C  HAS INTERACTION LENGTH STATISTICS INCLUDED
C  THIS SUBROUTINE IS CALLED FROM AAMAIN.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRAIR/   COMPOS,PROBTA,AVERAW,AVOGDR
      DOUBLE PRECISION COMPOS(3),PROBTA(3),AVERAW,AVOGDR

      COMMON /CRATMOS2/HLAY,HLAY0,THICKL,LAYNO,LAYNEW
      DOUBLE PRECISION HLAY(6),HLAY0(5,0:9),THICKL(5)
      INTEGER          LAYNO(0:22)
      LOGICAL          LAYNEW

      COMMON /CRCHISTA/IHYCHI,IKACHI,IMUCHI,INNCHI,INUCHI,IPICHI,INECHI
      INTEGER          IHYCHI(124),IKACHI(124),IMUCHI(124),INNCHI(124),
     *                 INUCHI(124),IPICHI(124),INECHI(124)

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRKAONS/ CKA
      DOUBLE PRECISION CKA(80)

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRNCSNCS/SIGN30,SIGN45,SIGN60,SIGO30,SIGO45,SIGO60,
     *                 SIGA30,SIGA45,SIGA60,PNOA30,PNOA45,PNOA60,
     *                 SIG30A,SIG45A,SIG60A
      DOUBLE PRECISION SIGN30(56),SIGN45(56),SIGN60(56),
     *                 SIGO30(56),SIGO45(56),SIGO60(56),
     *                 SIGA30(56),SIGA45(56),SIGA60(56),
     *                 PNOA30(1540,3),PNOA45(1540,3),PNOA60(1540,3),
     *                 SIG30A(56),SIG45A(56),SIG60A(56)

      COMMON /CROBSPAR/OBSLEV,THCKOB,XOFF,YOFF,HEIGHP,THETAP,PHIP,
     *                 THETPR,PHIPR,

     *                 VUECON,

     *                 NOBSLV
      DOUBLE PRECISION OBSLEV(20),THCKOB(20),XOFF(20),YOFF(20),
     *                 HEIGHP,THETAP,THETPR(2),PHIP,PHIPR(2)

      DOUBLE PRECISION VUECON(2)

      INTEGER          NOBSLV

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRREST/  CONTNE,TAR,LT
      DOUBLE PRECISION CONTNE(3),TAR
      INTEGER          LT

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSIGM/  SIGMA,SIGANN,SIGAIR,FRACTN,FRCTNO
      DOUBLE PRECISION SIGMA,SIGANN,SIGAIR,FRACTN,FRCTNO

      COMMON /CRSIGMU/ BREMSTAB,NUCTAB,PAIRTAB,DEDXMU,DEDXM,
     *                 FRABTN,FRANTN,FRAPTN,FRBTNO,FRNTNO,FRPTNO,
     *                 SIGBRM,SIGNUC,SIGPRM

      DOUBLE PRECISION BREMSTAB(141,3),NUCTAB(141,3),PAIRTAB(141,3),
     *                 DEDXMU(141,3),DEDXM(141),FRABTN,FRANTN,FRAPTN,
     *                 FRBTNO,FRNTNO,FRPTNO,SIGBRM,SIGNUC,SIGPRM

      COMMON /CRSTRBAR/CSTRBA
      DOUBLE PRECISION CSTRBA(11)

       

       

       

       

      COMMON /CRQGSC/  LEVLDQ,IQGSVER,FQGS,FQGSSG
      INTEGER          LEVLDQ,IQGSVER
      LOGICAL          FQGS,FQGSSG

      DOUBLE PRECISION CHIBRM,CHIPRM,CHIINT,CHINUC,CHI1,CHI2,CHI3,COR1,
     *                 DH,EKIN,ELAB,ELABT,PLAB,PLABLG,SIG45,S45SQ,S4530
      DOUBLE PRECISION HEIGH,THICK,CBRSGM,CNUSGM,CPRSGM
      INTEGER          I,IA,IHY,IP,KA,MU,NI,NU

      DOUBLE PRECISION HNEW

      SAVE

      EXTERNAL         HEIGH,THICK,CBRSGM,CNUSGM,CPRSGM
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) (CURPAR(I),I=0,9)
  444 FORMAT(' BOX2  : CURPAR=',1P,10E11.3)

      ITYPE = CURPAR(0)

C  GAMMAS  AND ELECTRONS ARE TREATED SEPARATELY (SEE BOX3)
      IF ( ITYPE .LE. 3 ) THEN
        CHI = 0.D0
        RETURN
      ENDIF

C-----------------------------------------------------------------------
C  RESONANCES ARE TREATED SEPARATELY (SEE BOX3)
      IF ( ITYPE .GE. 50  .AND.  ITYPE .LE. 65 ) THEN
        CHI = 0.D0
        RETURN
      ENDIF

      BETA   = SQRT( (GAMMA-1.D0)*(GAMMA+1.D0) ) / GAMMA
      THICKH = THICK( H )
      ELAB   = PAMA(ITYPE) * GAMMA

C-----------------------------------------------------------------------
C  MU+, MU- DECAYS AFTER ITS LIFE TIME
C  MUON INTERACTS BY BREMSSTRAHLUNG OR PAIR PRODUCTION
      IF     ( ITYPE .EQ. 5  .OR.  ITYPE .EQ. 6 ) THEN
        CALL RMMARD( RD,4,1 )
        COR1 = (-LOG(RD(1))) * C(25) * DECTIM(5)
C  DETERMINE RANGE FOR MUON DECAY

        CALL PRANGC( COR1,.TRUE.,HNEW )
        DH   = MAX( 0.D0, H - HNEW )
        IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : ITYPE,RD(1),CHIDEC=',
     *                                ITYPE,SNGL(RD(1)),SNGL(CHI)
        IF ( GAMMA .LE. 5.D0 ) THEN
C  AT LOW ENERGIES ONLY DECAY IS CONSIDERED
          FDECAY = .TRUE.

        ELSE
C  CALCULATE MUON BREMSSTRAHLUNG CROSS-SECTION FOR AIR (MILLIBARN)
          FRABTN =          COMPOS(1) * CBRSGM( ELAB,1 )
          FRBTNO = FRABTN + COMPOS(2) * CBRSGM( ELAB,2 )
          SIGBRM = FRBTNO + COMPOS(3) * CBRSGM( ELAB,3 )
          IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : SIGBRM=',SNGL(SIGBRM)
C  CALCULATE MEAN FREE PATH FOR BREMSSTRAHLUNG
          CHIBRM = (-LOG(RD(2))) * AVERAW / (AVOGDR * SIGBRM)
          IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : ITYPE,RD(2),CHIBRM=',
     *                               ITYPE,SNGL(RD(2)),SNGL(CHIBRM)
          CHI1   = MIN( CHIBRM, CHI )

C  CALCULATE  MUON PAIR PRODUCTION CROSS-SECTION FOR AIR (MILLIBARN)
          FRAPTN =          COMPOS(1) * CPRSGM( ELAB,1 )
          FRPTNO = FRAPTN + COMPOS(2) * CPRSGM( ELAB,2 )
          SIGPRM = FRPTNO + COMPOS(3) * CPRSGM( ELAB,3 )
          IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : SIGPRM=',SNGL(SIGPRM)
C  CALCULATE MEAN FREE PATH FOR PAIR PRODUCTION
          CHIPRM = (-LOG(RD(3))) * AVERAW / (AVOGDR * SIGPRM)
          IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : ITYPE,RD(3),CHIPRM=',
     *                               ITYPE,SNGL(RD(3)),SNGL(CHIPRM)
          CHI2   = MIN( CHIPRM, CHI1 )

C  CALCULATE MUON NUCLEAR INTERACTION CROSS-SECTION FOR AIR (MILLIBARN)
          FRANTN =          COMPOS(1) * CNUSGM( ELAB,1 )
          FRNTNO = FRANTN + COMPOS(2) * CNUSGM( ELAB,2 )
          SIGNUC = FRNTNO + COMPOS(3) * CNUSGM( ELAB,3 )
          IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : SIGNUC=',SNGL(SIGNUC)
C  CALCULATE MEAN FREE PATH FOR NUCLEAR INTERACTION
          CHINUC = (-LOG(RD(4))) * AVERAW / (AVOGDR * SIGNUC)
          IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : ITYPE,RD(4),CHINUC=',
     *                               ITYPE,SNGL(RD(4)),CHINUC
          CHI3   = MIN( CHINUC, CHI2 )

C  SET FLAGS ACCORDING THE EXPECTED INTERACTION AND SELECT TARGET NUCLEUS
          IF     ( CHI3 .EQ. CHI    ) THEN
            FDECAY = .TRUE.
            FMUNUC = .FALSE.
C  NO TARGET SELECTION FOR MUON DECAY

          ELSEIF ( CHI3 .EQ. CHIPRM ) THEN
            FDECAY = .FALSE.
            FMUNUC = .FALSE.
            FMUBRM = .FALSE.
C  TARGET IS CHOSEN AT RANDOM FOR MUON PAIR PRODUCTION
            CALL RMMARD( RD,1,1 )
            IF     ( RD(1)*SIGPRM .LE. FRAPTN ) THEN
C  PAIR PRODUCTION WITH NITROGEN
              LT  = 1
              TAR = 14.D0
            ELSEIF ( RD(1)*SIGPRM .LE. FRPTNO ) THEN
C  PAIR PRODUCTION WITH OXYGEN
              LT  = 2
              TAR = 16.D0
            ELSE
C  PAIR PRODUCTION WITH ARGON
              LT  = 3
              TAR = 40.D0
            ENDIF

          ELSEIF ( CHI3 .EQ. CHIBRM ) THEN
            FDECAY = .FALSE.
            FMUNUC = .FALSE.
            FMUBRM = .TRUE.
C  TARGET IS CHOSEN AT RANDOM FOR MUON BREMSSTRAHLUNG
            CALL RMMARD( RD,1,1 )
            IF     ( RD(1)*SIGBRM .LE. FRABTN ) THEN
C  BREMSSTRAHLUNG WITH NITROGEN
              LT  = 1
              TAR = 14.D0
            ELSEIF ( RD(1)*SIGBRM .LE. FRBTNO ) THEN
C  BREMSSTRAHLUNG WITH OXYGEN
              LT  = 2
              TAR = 16.D0
            ELSE
C  BREMSSTRAHLUNG WITH ARGON
              LT  = 3
              TAR = 40.D0
            ENDIF

          ELSEIF ( CHI3 .EQ. CHINUC ) THEN
            FDECAY = .FALSE.
            FMUNUC = .TRUE.
C  TARGET IS CHOSEN AT RANDOM FOR MUON NUCLEAR INTERACTION
            CALL RMMARD( RD,1,1 )
            IF     ( RD(1)*SIGNUC .LE. FRANTN ) THEN
C  NUCLEAR INTERACTION WITH NITROGEN
              LT  = 1
              TAR = 14.D0
            ELSEIF ( RD(1)*SIGNUC .LE. FRNTNO ) THEN
C  NUCLEAR INTERACTION WITH OXYGEN
              LT  = 2
              TAR = 16.D0
            ELSE
C  NUCLEAR INTERACTION WITH ARGON
              LT  = 3
              TAR = 40.D0
            ENDIF
          ENDIF
          CHI = CHI3
        ENDIF

C  DECAY LENGTH STATISTICS
        IF ( COSTHE .NE. 0D0 ) THEN
          MU = 1.D0 + ABS( DH * 1.D-4 / COSTHE )
        ELSE
          MU = 123
        ENDIF
        MU = MIN( MU, 123 )
        IMUCHI( MU) = IMUCHI( MU) + 1
        IMUCHI(124) = IMUCHI(124) + 1

C-----------------------------------------------------------------------
C  CHARGED PIONS
      ELSEIF ( ITYPE .EQ. 8  .OR.  ITYPE .EQ. 9 ) THEN
        PLAB = ELAB * BETA
C  CALCULATION OF CROSS-SECTION IN THE LOW ENERGY MODEL
        IF ( ELAB .LE. HILOELB ) THEN
          EKIN    = ELAB - PAMA(ITYPE)
          USELOW  = .TRUE.

          CALL FLUSIG( EKIN,PLAB )
          FFLUSIG = .TRUE.
        ELSE
          FFLUSIG = .FALSE.
          USELOW  = .FALSE.
          GHESIG  = .FALSE.
          IF ( FQGSSG  .AND.  (ELAB .GE. HILOELB) ) THEN
            CALL QGSSIG( ELAB,1 )
          ELSE
C  SIGMA IS ENERGY DEPENDENT INELASTIC PION-NUCLEON CROSS-SECTION
            IF     ( PLAB .LE. 5.D0 ) THEN
              SIGMA  = 20.64D0
            ELSEIF ( PLAB .LT. 1.D3 ) THEN
              PLABLG = LOG(PLAB)
C  INELASTIC CROSS-SECTIONS FROM PARTICLE DATA GROUP
C  (A.BALDINI ET AL., LANDOLT-BOERNSTEIN NEW SERIES I/12A (1987) 193)
              SIGMA  = 24.3D0 - 12.3D0 * PLAB**(-1.91D0)
     *                + 0.324D0 * PLABLG**2 - 2.44D0 * PLABLG
            ELSE
C  FACTOR 0.6667 GIVES RATIO BETWEEN PION AND NUCLEON CROSS-SECTION
              SIGMA  = 19.87D0 * ELAB**.079D0 * 0.6667D0
            ENDIF
C  AUXIL. QUANTITIES FOR INTERPOLATION
            SIG45  = SIGMA - 45.D0
            S45SQ  = SIG45**2 / 450.D0
            S4530  = SIG45 / 30.D0
C  INELASTIC CROSS-SECTIONS OF AIR FOR PROJECTILE WITH MASS NUMBER 1
            SIGAIR = (1.D0 - 2.D0 * S45SQ) * SIG45A(1)
     *                    +(S45SQ - S4530) * SIG30A(1)
     *                    +(S45SQ + S4530) * SIG60A(1)

          ENDIF

        ENDIF
        IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : SIGMA,SIGAIR,GHESIG=',
     *                            SNGL(SIGMA),SNGL(SIGAIR),GHESIG

        CALL RMMARD( RD,2,1 )
C  MEAN FREE PATH FOR INTERACTION (CHIINT)  OR DECAY (CHI)
        CHIINT = (-LOG(RD(1))) * AVERAW / (AVOGDR * SIGAIR)

        IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : ITYPE,RD(1),CHIINT=',
     *                             ITYPE,SNGL(RD(1)),SNGL(CHIINT)
        COR1   = (-LOG(RD(2))) * C(25) * DECTIM(8)

        CALL PRANGC( COR1,.FALSE.,HNEW )
        CHI    = MAX( 0.D0, CHI )
        IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : ITYPE,RD(2),CHIDEC=',
     *                                ITYPE,SNGL(RD(2)),SNGL(CHI)
        CHI    = MIN( CHIINT, CHI )
        IF ( CHI .LT. CHIINT ) THEN
          FDECAY = .TRUE.
        ELSE
          FDECAY = .FALSE.
        ENDIF

C  INTERACTION LENGTH STATISTICS
        CHI = MIN( 2.D9, CHI )
        IP  = 1.D0 + CHI * 0.1D0
        IP  = MIN( IP, 123 )
        IPICHI( IP) = IPICHI( IP) + 1
        IPICHI(124) = IPICHI(124) + 1

C-----------------------------------------------------------------------
C  NEUTRAL PIONS
      ELSEIF ( ITYPE .EQ. 7 ) THEN
C  LOW ENERGY PIONS ARE NOT TRACKED AND DECAY
        IF ( ELAB .LT. 1.D5 ) THEN
          FDECAY = .TRUE.
          CHI    = 0.D0
          IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : ITYPE,CHI,FDECAY=',
     *                                    ITYPE,SNGL(CHI),FDECAY
        ELSE
C  PION IS HIGH ENERGY AND MUST BE TRACKED
          PLAB   = ELAB * BETA
          GHESIG = .FALSE.
          IF ( FQGSSG ) THEN
            CALL QGSSIG( ELAB,1 )
          ELSE
C  SIGMA IS ENERGY DEPENDENT INELASTIC PION-NUCLEON CROSS-SECTION
C  FACTOR 0.6667 GIVES RATIO BETWEEN PION AND NUCLEON CROSS-SECTION
            SIGMA  = 19.87D0 * ELAB**.079D0 * 0.6667D0
C  AUXIL. QUANTITIES FOR INTERPOLATION
            SIG45  = SIGMA - 45.D0
            S45SQ  = SIG45**2 / 450.D0
            S4530  = SIG45 / 30.D0
C  INELASTIC CROSS-SECTIONS OF AIR FOR PROJECTILE WITH MASS NUMBER 1
            SIGAIR = (1.D0 - 2.D0 * S45SQ) * SIG45A(1)
     *                    +(S45SQ - S4530) * SIG30A(1)
     *                    +(S45SQ + S4530) * SIG60A(1)

          ENDIF

          IF ( DEBUG ) WRITE(MDEBUG,*)
     *       'BOX2  : SIGMA,SIGAIR=',SNGL(SIGMA),SNGL(SIGAIR)

          CALL RMMARD( RD,2,1 )
C  MEAN FREE PATH FOR INTERACTION (CHIINT)  OR DECAY (CHI)
          CHIINT = (-LOG(RD(1))) * AVERAW / (AVOGDR * SIGAIR)

          IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : ITYPE,RD(1),CHIINT=',
     *                               ITYPE,SNGL(RD(1)),SNGL(CHIINT)
          COR1   = (-LOG(RD(2))) * C(25) * DECTIM(7)

          CALL NRANGC( COR1*BETA*GAMMA )
          IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : ITYPE,RD(2),CHIDEC=',
     *                                  ITYPE,SNGL(RD(2)),SNGL(CHI)
          CHI    = MIN( CHIINT, CHI )
          IF ( CHI .LT. CHIINT ) THEN
            FDECAY = .TRUE.
          ELSE
            FDECAY = .FALSE.
          ENDIF

        ENDIF

C  INTERACTION LENGTH STATISTICS
        CHI = MIN( 2.D9, CHI )
        IP  = 1.D0 + CHI * 0.1D0
        IP  = MIN( IP, 123 )
        IPICHI( IP) = IPICHI( IP) + 1
        IPICHI(124) = IPICHI(124) + 1

C-----------------------------------------------------------------------
C  NUCLEONS AND ANTINUCLEONS
      ELSEIF ( ITYPE .EQ. 13  .OR.  ITYPE .EQ. 14  .OR.
     *         ITYPE .EQ. 15  .OR.  ITYPE .EQ. 25 ) THEN
        PLAB = ELAB * BETA
C  CALCULATION OF CROSS-SECTION IN THE LOW ENERGY MODEL
        IF ( ELAB .LE. HILOELB ) THEN
          EKIN   = ELAB - PAMA(ITYPE)
          USELOW = .TRUE.

          CALL FLUSIG( EKIN,PLAB )
          FFLUSIG = .TRUE.
        ELSE
          FFLUSIG = .FALSE.
          USELOW = .FALSE.
          GHESIG = .FALSE.
          IF ( FQGSSG  .AND.  (ELAB .GE. HILOELB) ) THEN
            CALL QGSSIG( ELAB,2 )
          ELSE
C  SIGMA IS ENERGY DEPENDENT INELASTIC NUCLEON-NUCLEON CROSS-SECTION
            IF     ( PLAB .LT. 1.D1 ) THEN
              SIGMA  = 29.9D0
            ELSEIF ( PLAB .LT. 1.D3 ) THEN
              PLABLG = LOG(PLAB)
C  INELASTIC CROSS-SECTIONS FROM PARTICLE DATA GROUP
C  (A.BALDINI ET AL., LANDOLT-BOERNSTEIN NEW SERIES I/12B (1987) 150)
              SIGMA  = 30.9D0 - 28.9D0 * PLAB**(-2.46D0)
     *                + 0.192D0 * PLABLG**2 - 0.835D0 * PLABLG
            ELSE
              SIGMA  = 19.87D0 * ELAB**.079D0
            ENDIF

C  ADD ANNIHILATION CROSS-SECTION FOR ANTI-NUCLEONS
            IF ( ITYPE .EQ. 15  .OR.  ITYPE .EQ. 25 ) THEN
C  ANNIHILATION CROSS-SECTIONS FROM PARTICLE DATA GROUP
C  (A.BALDINI ET AL., LANDOLT-BOERNSTEIN NEW SERIES I/12B (1987) 286)
              SIGANN = 0.532D0 + 0.634D2 * PLAB**(-0.71D0)
              SIGMA  = MIN( 120.D0, SIGMA + SIGANN )
            ENDIF
C  AUXIL. QUANTITIES FOR INTERPOLATION
            SIG45  = SIGMA - 45.D0
            S45SQ  = SIG45**2 / 450.D0
            S4530  = SIG45 / 30.D0
C  INELASTIC CROSS-SECTIONS OF AIR FOR PROJECTILE WITH MASS NUMBER 1
            SIGAIR = (1.D0 - 2.D0 * S45SQ) * SIG45A(1)
     *                    +(S45SQ - S4530) * SIG30A(1)
     *                    +(S45SQ + S4530) * SIG60A(1)

          ENDIF
          IF ( ITYPE .EQ. 15  .OR.  ITYPE .EQ. 25 ) THEN
C  TAKE ANNIHILATION AS ADDITION TO HADR. INTERACT. CROSS-SECTION
            SIGANN = 2.25D2 * PLAB**(-0.625D0)
            SIGAIR = SIGAIR + SIGANN
            FRACTN = FRACTN + PROBTA(1) * SIGANN
            FRCTNO = FRCTNO + PROBTA(2) * SIGANN
          ENDIF

        ENDIF
        IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : SIGMA,SIGAIR,GHESIG=',
     *                            SNGL(SIGMA),SNGL(SIGAIR),GHESIG

C  MEAN FREE PATH FROM MOLECULAR WEIGHT, AVOGADRO''S CONSTANT AND SIGMA
        CALL RMMARD( RD,1,1 )
        CHI    = (-LOG(RD(1))) * AVERAW / (AVOGDR * SIGAIR)

        FDECAY = .FALSE.
        IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : ITYPE,RD(1),CHI=',
     *                             ITYPE,SNGL(RD(1)),SNGL(CHI)

C  INTERACTION LENGTH STATISTICS
        CHI = MIN( 2.D9, CHI )
        NU  = 1.D0 + CHI * 0.1D0
        NU  = MIN( NU, 123 )
        INUCHI( NU) = INUCHI( NU) + 1
        INUCHI(124) = INUCHI(124) + 1

C-----------------------------------------------------------------------
C  KAONS (PARTICLE TYPES 10,11,12,16)
      ELSEIF ( ITYPE .EQ. 10  .OR.  ITYPE .EQ. 11  .OR.
     *         ITYPE .EQ. 12  .OR.  ITYPE .EQ. 16 ) THEN
        PLAB = ELAB * BETA
C  CALCULATION OF CROSS-SECTION IN THE LOW ENERGY MODEL
        IF ( ELAB .LE. HILOELB ) THEN
          EKIN   = ELAB - PAMA(ITYPE)
          USELOW = .TRUE.

          CALL FLUSIG( EKIN,PLAB )
          FFLUSIG = .TRUE.
        ELSE
          FFLUSIG = .FALSE.
          USELOW = .FALSE.
          GHESIG = .FALSE.
          IF ( FQGSSG  .AND.  (ELAB .GE. HILOELB) ) THEN
            CALL QGSSIG( ELAB,3 )
          ELSE
C  SIGMA IS ENERGY DEPENDENT INELASTIC KAON-NUCLEON CROSS-SECTION
            IF     ( PLAB .LE. 1.D1 ) THEN
              SIGMA  = 14.11D0
            ELSEIF ( PLAB .LT. 1.D3 ) THEN
              PLABLG = LOG(PLAB)
C  INELASTIC CROSS-SECTIONS FROM PARTICLE DATA GROUP
C  (A.BALDINI ET AL., LANDOLT-BOERNSTEIN NEW SERIES I/12B (1987) 56)
              SIGMA  = 12.3D0 - 7.77D0 * PLAB**(-2.12D0)
     *              + 0.0326D0 * PLABLG**2 + 0.738D0 * PLABLG
            ELSE
C  FACTOR 0.5541 GIVES RATIO BETWEEN KAON AND NUCLEON CROSS-SECTION
              SIGMA  = 19.87D0 * ELAB**.079D0 * 0.5541D0
            ENDIF
C  AUXIL. QUANTITIES FOR INTERPOLATION
            SIG45  = SIGMA - 45.D0
            S45SQ  = SIG45**2 / 450.D0
            S4530  = SIG45 / 30.D0
C  INELASTIC CROSS-SECTIONS OF AIR FOR PROJECTILE WITH MASS NUMBER 1
            SIGAIR = (1.D0 - 2.D0 * S45SQ) * SIG45A(1)
     *                    +(S45SQ - S4530) * SIG30A(1)
     *                    +(S45SQ + S4530) * SIG60A(1)

          ENDIF

        ENDIF
        IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : SIGMA,SIGAIR,GHESIG=',
     *                            SNGL(SIGMA),SNGL(SIGAIR),GHESIG

        CALL RMMARD( RD,2,1 )
C  MEAN FREE PATH FOR INTERACTION (CHIINT)  OR DECAY (CHI)
        CHIINT = (-LOG(RD(1))) * AVERAW / (AVOGDR * SIGAIR)

        IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : ITYPE,RD(1),CHIINT=',
     *                             ITYPE,SNGL(RD(1)),SNGL(CHIINT)

        COR1   = (-LOG(RD(2))) * C(25) * DECTIM(ITYPE)
        IF ( SIGNUM(ITYPE) .EQ. 0.D0 ) THEN
C  NEUTRAL KAONS

          CALL NRANGC( COR1*BETA*GAMMA )
        ELSE
C  CHARGED KAONS

          CALL PRANGC( COR1,.FALSE.,HNEW )
          CHI  = MAX( 0.D0, CHI )
        ENDIF

        IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : ITYPE,RD(2),CHIDEC=',
     *                                ITYPE,SNGL(RD(2)),SNGL(CHI)
        CHI    = MIN( CHIINT, CHI )
        IF ( CHI .LT. CHIINT ) THEN
          FDECAY = .TRUE.
        ELSE
          FDECAY = .FALSE.
        ENDIF

C  INTERACTION LENGTH STATISTICS
        CHI = MIN( 2.D9, CHI )
        KA  = 1.D0 + CHI * 0.1D0
        KA  = MIN( KA, 123 )
        IKACHI( KA) = IKACHI( KA) + 1
        IKACHI(124) = IKACHI(124) + 1

C-----------------------------------------------------------------------
C  ETA MESONS
      ELSEIF ( ITYPE .EQ. 17  .OR.
     *        (ITYPE .GE. 71  .AND.  ITYPE .LE. 74 ) ) THEN
C  LOW ENERGY ETA MESONS ARE NOT TRACKED AND DECAY
        IF ( ELAB .LT. 1.D7 ) THEN
          FDECAY = .TRUE.
          CHI    = 0.D0
          IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : ITYPE,CHI,FDECAY=',
     *                                    ITYPE,SNGL(CHI),FDECAY
        ELSE
C   ETA IS HIGH ENERGY AND MUST BE TRACKED. WE TAKE PION CROSS-SECTIONS
          PLAB   = ELAB * BETA
          GHESIG = .FALSE.
          IF ( FQGSSG ) THEN
            CALL QGSSIG( ELAB,1 )
          ELSE
C  SIGMA IS ENERGY DEPENDENT INELASTIC PION-NUCLEON CROSS-SECTION
C  FACTOR 0.6667 GIVES RATIO BETWEEN PION AND NUCLEON CROSS-SECTION
            SIGMA  = 19.87D0 * ELAB**.079D0 * 0.6667D0
C  AUXIL. QUANTITIES FOR INTERPOLATION
            SIG45  = SIGMA - 45.D0
            S45SQ  = SIG45**2 / 450.D0
            S4530  = SIG45 / 30.D0
C  INELASTIC CROSS-SECTIONS OF AIR FOR PROJECTILE WITH MASS NUMBER 1
            SIGAIR = (1.D0 - 2.D0 * S45SQ) * SIG45A(1)
     *                    +(S45SQ - S4530) * SIG30A(1)
     *                    +(S45SQ + S4530) * SIG60A(1)

          ENDIF

          IF ( DEBUG ) WRITE(MDEBUG,*)
     *       'BOX2  : SIGMA,SIGAIR=',SNGL(SIGMA),SNGL(SIGAIR)

          CALL RMMARD( RD,2,1 )
C  MEAN FREE PATH FOR INTERACTION (CHIINT)  OR DECAY (CHI)
          CHIINT = (-LOG(RD(1))) * AVERAW / (AVOGDR * SIGAIR)

          IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : ITYPE,RD(1),CHIINT=',
     *                               ITYPE,SNGL(RD(1)),SNGL(CHIINT)
          COR1   = (-LOG(RD(2))) * C(25) * DECTIM(17)

          CALL NRANGC( COR1*BETA*GAMMA )
          IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : ITYPE,RD(2),CHIDEC=',
     *                                  ITYPE,SNGL(RD(2)),SNGL(CHI)
          CHI    = MIN( CHIINT, CHI )

C  QGSJET_II CANNOT TREAT ETA THEREFORE MAKE DECAY
          FDECAY = .TRUE.

        ENDIF

C  INTERACTION LENGTH STATISTICS
        CHI = MIN( 2.D9, CHI )
        IP  = 1.D0 + CHI * 0.1D0
        IP  = MIN( IP, 123 )
        IPICHI( IP) = IPICHI( IP) + 1
        IPICHI(124) = IPICHI(124) + 1

C-----------------------------------------------------------------------
C  STRANGE BARYONS ( LAMBDA, SIGMA(+,0,-),XI(0,-), OMEGA- )
      ELSEIF ( (ITYPE .GE. 18  .AND.  ITYPE .LE. 24)  .OR.
     *         (ITYPE .GE. 26  .AND.  ITYPE .LE. 32) ) THEN
        PLAB = ELAB * BETA
C  CALCULATION OF CROSS-SECTION IN THE LOW ENERGY MODEL
        IF ( ELAB .LE. HILOELB ) THEN
          EKIN   = ELAB - PAMA(ITYPE)
          USELOW = .TRUE.

          CALL FLUSIG( EKIN,PLAB )
          FFLUSIG = .TRUE.
        ELSE
          FFLUSIG = .FALSE.
          USELOW = .FALSE.
          GHESIG = .FALSE.
C  CROSS-SECTION FOR BARYONS IS ASSUMED TO BE THE SAME AS FOR NUCLEONS
          IF ( FQGSSG  .AND.  (ELAB .GE. HILOELB) ) THEN
            CALL QGSSIG( ELAB,2 )
          ELSE
C  SIGMA IS ENERGY DEPENDENT INELASTIC NUCLEON-NUCLEON CROSS-SECTION
            IF     ( PLAB .LT. 1.D1 ) THEN
              SIGMA  = 29.9D0
            ELSEIF ( PLAB .LT. 1.D3 ) THEN
              PLABLG = LOG(PLAB)
C  INELASTIC CROSS-SECTIONS FROM PARTICLE DATA GROUP
C  (A.BALDINI ET AL., LANDOLT-BOERNSTEIN NEW SERIES I/12B (1987) 150)
              SIGMA  = 30.9D0 - 28.9D0 * PLAB**(-2.46D0)
     *                + 0.192D0 * PLABLG**2 - 0.835D0 * PLABLG
            ELSE
              SIGMA  = 19.87D0 * ELAB**.079D0
            ENDIF
C  AUXIL. QUANTITIES FOR INTERPOLATION
            SIG45  = SIGMA - 45.D0
            S45SQ  = SIG45**2 / 450.D0
            S4530  = SIG45 / 30.D0
C  INELASTIC CROSS-SECTIONS OF AIR FOR PROJECTILE WITH MASS NUMBER 1
            SIGAIR = (1.D0 - 2.D0 * S45SQ) * SIG45A(1)
     *                  +(S45SQ - S4530) * SIG30A(1)
     *                  +(S45SQ + S4530) * SIG60A(1)

          ENDIF

        ENDIF
        IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : SIGMA,SIGAIR,GHESIG=',
     *                            SNGL(SIGMA),SNGL(SIGAIR),GHESIG

        CALL RMMARD( RD,2,1 )
C  MEAN FREE PATH FOR INTERACTION (CHIINT)  OR DECAY (CHI)
        COR1 = (-LOG(RD(2))) * C(25) * DECTIM(ITYPE)
        IF ( SIGNUM(ITYPE) .EQ. 0.D0 ) THEN
C  NEUTRAL STRANGE BARYONS

          CALL NRANGC( COR1*BETA*GAMMA )
        ELSE
C  CHARGED STRANGE BARYONS

          CALL PRANGC( COR1,.FALSE.,HNEW )
          CHI  = MAX( 0.D0, CHI )
        ENDIF
        IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : ITYPE,RD(2),CHIDEC=',
     *                                ITYPE,SNGL(RD(2)),SNGL(CHI)
        CHIINT = (-LOG(RD(1))) * AVERAW / (AVOGDR * SIGAIR)

        IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : ITYPE,RD(1),CHIINT=',
     *                             ITYPE,SNGL(RD(1)),SNGL(CHIINT)
        CHI    = MIN( CHIINT, CHI )

        IF ( FQGS  .AND.  (.NOT.GHESIG) ) THEN
C  QGSJET_II CANNOT TREAT BARYONS WITH STRANGENESS
          FDECAY = .TRUE.
        ELSE

          IF ( CHI .LT. CHIINT ) THEN
            FDECAY = .TRUE.
          ELSE
            FDECAY = .FALSE.
          ENDIF

        ENDIF

C  GHEISHA CANNOT TREAT SIGMA0 AND ANTI-SIGMA0, LET THEM DECAY
        IF ( GHESIG  .AND.  (ITYPE .EQ. 20  .OR.  ITYPE .EQ. 28) )
     *                                              FDECAY = .TRUE.

C  INTERACTION LENGTH STATISTICS
        CHI = MIN( 2.D9, CHI )
        IHY = 1.D0 + CHI * 0.1D0
        IHY = MIN( IHY, 123 )
        IHYCHI(IHY) = IHYCHI(IHY) + 1
        IHYCHI(124) = IHYCHI(124) + 1

C-----------------------------------------------------------------------
C  HEAVY PRIMARIES ( ITYPE = 100 * A + Z ,  FE -> ITYPE = 5626 )
C  ( APPEARING AT FIRST INTERACTION AND AS REMANENTS OF THE PRIMARY )
      ELSEIF ( ITYPE .GE. 200 ) THEN
        IA = ITYPE / 100
        IF ( IA .GT. 56 ) THEN
          WRITE(MONIOU,*)
          WRITE(MONIOU,*) 'BOX2  : UNEXPECTED PARTICLE TYPE=',ITYPE
          WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
          WRITE(MONIOU,*) 'SEE KEYWORD: PRMPAR'
          STOP
        ENDIF
C  MEAN FREE PATH OF THE HEAVY PRIMARY IS DEDUCED FROM THAT OF A NUCLEON
C  ONLY INELASTIC SCATTERING AT INTERACTIONS WITH HEAVY PRIMARY/FRAGMENT
        ELAB  = (PAMA(13) + PAMA(14)) * 0.5D0 * GAMMA
        PLAB  = ELAB * BETA
C  CALCULATION OF CROSS-SECTION IN THE LOW ENERGY MODEL
        ELABT = ELAB * IA
        IF ( ELAB .LE. HILOELB ) THEN

C  FLUKA CANNOT TREAT HEAVY PRIMARIES
          FFLUSIG = .FALSE.
          USELOW = .FALSE.
          GHESIG = .FALSE.
        ENDIF
        IF ( FQGSSG  .AND.  (ELAB .GE. HILOELB) ) THEN
          CALL QGSSIG( ELAB,ITYPE )
          GOTO 333
        ELSE
C  NO CROSS-SECTION AVAILABLE FOR FLUKA, USE GRIEDER MODEL
C

C  SIGMA IS ENERGY DEPENDENT INELASTIC NUCLEON-NUCLEON CROSS-SECTION
          IF     ( PLAB .LT. 1.D1 ) THEN
            SIGMA  = 29.9D0
          ELSEIF ( PLAB .LT. 1.D3 ) THEN
            PLABLG = LOG(PLAB)
C  INELASTIC CROSS-SECTIONS FROM PARTICLE DATA GROUP
C  (A.BALDINI ET AL., LANDOLT-BOERNSTEIN NEW SERIES I/12B (1987) 150)
            SIGMA  = 30.9D0 - 28.9D0 * PLAB**(-2.46D0)
     *              + 0.192D0 * PLABLG**2 - 0.835D0 * PLABLG
          ELSE
            SIGMA  = 19.87D0 * ELAB**.079D0
          ENDIF

        ENDIF

C  AUXIL. QUANTITIES FOR INTERPOLATION
        SIG45  = SIGMA - 45.D0
        S45SQ  = SIG45**2 / 450.D0
        S4530  = SIG45 / 30.D0
C  INELASTIC CROSS-SECTIONS OF AIR FOR PROJECTILE WITH MASS NUMBER IA
        SIGAIR = (1.D0 - 2.D0 * S45SQ) * SIG45A(IA)
     *                +(S45SQ - S4530) * SIG30A(IA)
     *                +(S45SQ + S4530) * SIG60A(IA)
 333    CONTINUE
        IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : SIGMA,SIGAIR,GHESIG=',
     *                            SNGL(SIGMA),SNGL(SIGAIR),GHESIG

C  CHECK SIGAIR FOR CORRECT CROSS-SECTION
        IF ( SIGAIR .LE. 0.D0 ) THEN
          WRITE(MONIOU,*)
          WRITE(MONIOU,*) 'BOX2: SIGAIR=0.D0, PROGRAM STOPPED ',
     *       ' (UNALLOWED COMBINATION OF PRIMARY WITH CROSS-SECTION)'
          WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
          WRITE(MONIOU,*) 'SEE KEYWORD: PRMPAR'
          STOP
        ENDIF

        CALL RMMARD( RD,1,1 )
C  MEAN FREE PATH FROM MOLECULAR WEIGHT, AVOGADRO''S CONSTANT AND SIGMA
        CHI    = (-LOG(RD(1))) * AVERAW / (AVOGDR * SIGAIR)

        FDECAY = .FALSE.
        IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX2  : ITYPE,RD(1),CHI=',
     *                             ITYPE,SNGL(RD(1)),SNGL(CHI)

C  INTERACTION LENGTH STATISTICS
        CHI = MIN( 2.D9, CHI )
        NI  = 1.D0 + CHI * 0.1D0
        NI  = MIN( NI, 123 )
        INNCHI( NI) = INNCHI( NI) + 1
        INNCHI(124) = INNCHI(124) + 1

C-----------------------------------------------------------------------
C  ERROR IN PARTICLE CODE
      ELSE
        WRITE(MONIOU,*)
        WRITE(MONIOU,*) 'BOX2  : UNEXPECTED PARTICLE TYPE=',ITYPE
        WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
        WRITE(MONIOU,*) 'SEE KEYWORD: PRMPAR'
        STOP
      ENDIF

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================
c----change
      SUBROUTINE BOX3(fmfb)
c---change
C-----------------------------------------------------------------------
C
C  CHECKS PASSAGE THROUGH OBSERVATION LEVEL(S)
C  IRET1=1 KILLS PARTICLE
C  IRET2=1 PARTICLE HAS BEEN CUTTED IN UPDATE
C  THIS SUBROUTINE IS CALLED FROM AAMAIN.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRGENER/ GEN,ALEVEL
      DOUBLE PRECISION GEN,ALEVEL

      COMMON /CRIRET/  IRET1,IRET2,IRETE
      INTEGER          IRET1,IRET2
      LOGICAL          IRETE

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CROBSPAR/OBSLEV,THCKOB,XOFF,YOFF,HEIGHP,THETAP,PHIP,
     *                 THETPR,PHIPR,

     *                 VUECON,

     *                 NOBSLV
      DOUBLE PRECISION OBSLEV(20),THCKOB(20),XOFF(20),YOFF(20),
     *                 HEIGHP,THETAP,THETPR(2),PHIP,PHIPR(2)

      DOUBLE PRECISION VUECON(2)

      INTEGER          NOBSLV

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRTHNVAR/STACKINT,

     *                 INT_ICOUNT,MODETHN,THINNING

      INTEGER          MAXICOUNT
      PARAMETER        (MAXICOUNT=200000)

      DOUBLE PRECISION STACKINT(0:16,MAXICOUNT)
      INTEGER          INT_ICOUNT,MODETHN
      LOGICAL          THINNING

c-----changed--add
      logical fmfb
c-----changed--add
      

       

       

       

      DOUBLE PRECISION THICK
      INTEGER          I,IRET3

      LOGICAL          FLAG
      SAVE
      EXTERNAL         THICK
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) (CURPAR(I),I=0,9)
  444 FORMAT(' BOX3  : CURPAR=',1P,10E11.3)

      IF     ( ITYPE .EQ. 5  .OR.  ITYPE .EQ. 6 ) THEN
C  MUONS ARE TRACKED WITHIN SUBR. MUTRAC
        INT_ICOUNT = 0
c------changed
        CALL MUTRAC(fmfb)
c------changed

C  CALL TO TSTEND IS DONE IN MUON ROUTINES MUTRAC RESP. MUNUCL
        IRET1 = 1
        RETURN

      ELSEIF ( ITYPE .LE. 3 ) THEN
C  ELECTRONS OR GAMMAS  ARE TREATED IN SUBR. EM
        CALL EM
        IRET1 = 1
        RETURN

      ELSEIF ( ITYPE .GE. 50  .AND.  ITYPE .LE. 65 ) THEN
C  RESONANCES DECAY WITHIN SUBR. RESDEC

        IF ( LLONGI ) LHEIGH = INT( THICK( H )*THSTPI + 1.D0 )

        INT_ICOUNT = 0
        CALL RESDEC
        CALL TSTEND
        IRET1 = 1
        RETURN

      ENDIF

C  FOR ALL THE OTHER PARTICLES THE PLACE OF NEXT INTERACTION WAS
C  DETERMINED IN BOX2

C  UPDATE PARTICLE TO INTERACTION POINT OR OBSERVATION LEVEL,
C  WHICHEVER IS CLOSER
      FLAG = .FALSE.
c-----changed--add
      CALL UPDATC(IRET3,FLAG,fmfb)
c-----changed--add

      IF ( DEBUG ) WRITE(MDEBUG,*) 'BOX3  : IRET1,2,3=',
     *                                      IRET1,IRET2,IRET3
      IF ( IRET2 .NE. 0 ) THEN
C  PARTICLE CUTTED BEFORE INTERACTION POINT
C  LONGITUDINAL DEPOSIT IS ALREADY DONE IN UPDATC
        IRET1 = 1
        RETURN
      ELSE
C  KILL PARTICLE AS IT IS AT DETECTOR LEVEL
        IF ( IRET3 .NE. 0 ) THEN
          IRET1 = 1
          RETURN
        ELSE
C  STORE PARTICLE FOR FURTHER TREATMENT
          DO  I = 0, 8
            CURPAR(I) = OUTPAR(I)
          ENDDO
          ALEVEL = H
          BETA   = SQRT( (GAMMA-1.D0)*(GAMMA+1.D0) ) / GAMMA
        ENDIF

      ENDIF

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   12/05/2003
C=======================================================================

      DOUBLE PRECISION FUNCTION CBRSGM( ELAB,MAT )

C-----------------------------------------------------------------------
C  C(ALCULATE) BR(EMSSTRAHLUNG) S(I)G(MA FOR) M(UONS)
C
C  CALCULATES THE CROSS-SECTION IN CURRENT MATERIAL FOR DISCRETE (HARD)
C  MUON BREMSSTRAHLUNG. (SIGMA IN BARN/ATOM)
C  THIS FUNCTION USES TABLES ESTABLISHED WITH THE SUBR. MUPINI
C  ACCORDING THE ROUTINES OF:
C       S. BOTTAI AND L. PERRONE, NUCL. INST. METH. A459 (2001) 319
C  THESE TABLES ARE GIVEN AS LOG OF THE CROSS-SECTIONS.
C  THIS FUNCTION IS CALLED FROM BOX2.
C  ARGUMENTS:
C   ELAB   = TOTAL ENERGY OF MUON
C   MAT    = MATERIAL INDEX: 1=14N, 2=16O, 3=40AR
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSIGMU/ BREMSTAB,NUCTAB,PAIRTAB,DEDXMU,DEDXM,
     *                 FRABTN,FRANTN,FRAPTN,FRBTNO,FRNTNO,FRPTNO,
     *                 SIGBRM,SIGNUC,SIGPRM

      DOUBLE PRECISION BREMSTAB(141,3),NUCTAB(141,3),PAIRTAB(141,3),
     *                 DEDXMU(141,3),DEDXM(141),FRABTN,FRANTN,FRAPTN,
     *                 FRBTNO,FRNTNO,FRPTNO,SIGBRM,SIGNUC,SIGPRM

       

       

       

       

      DOUBLE PRECISION DELTAE,ELAB,WK(3),YE
      INTEGER          I,JE,MAT
      SAVE
C-----------------------------------------------------------------------

C  DETERMINE ENERGY INTERVAL FOR INTERPOLATION
C  WE HAVE 10 POINTS/DECADE AND 2 DECADES BELOW 1 GEV
      YE = 10.D0 * LOG10(ELAB) + 21.D0
      IF ( YE .LT. 1.D0 ) YE = 1.D0
      JE = INT( YE )
      IF ( JE .GT. 139 ) JE = 139
      DELTAE = YE - DBLE(JE)
      WK(3)  = DELTAE * (DELTAE-1.D0) * .5D0
      WK(1)  = 1.D0 - DELTAE  + WK(3)
      WK(2)  = DELTAE - 2.D0 * WK(3)

C  NOW MAKE QUADRATIC INTERPOLATION OF THE LOG OF CROSS-SECTIONS
      CBRSGM = 0.D0
      DO  I = 1, 3
        CBRSGM = CBRSGM + BREMSTAB(JE+I-1,MAT)*WK(I)
      ENDDO
      CBRSGM = EXP(CBRSGM)

C     IF ( DEBUG ) WRITE(MDEBUG,444) ELAB,MAT,CBRSGM
C 444 FORMAT(' CBRSGM: E=',1P,E10.4,' MAT=',I3,' CBRSGM=',E12.5)

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   25/06/2003
C=======================================================================

      DOUBLE PRECISION FUNCTION CDEDXM( ELAB )

C-----------------------------------------------------------------------
C  C(ALCULATE) DE/DX (FOR) M(UON)
C
C  CALCULATES THE CONTINUOUS ENERGY LOSS OF MUONS BY BREMSSTRAHLUNG,
C  PAIR PRODUCTION AND NUCL. INTERACTIONS IN AIR (IN GEV G**-1 CM**2).
C  THIS FUNCTION USES TABLES ESTABLISHED WITH THE SUBR. MUPINI
C  ACCORDING THE ROUTINES OF:
C       S. BOTTAI AND L. PERRONE, NUCL. INST. METH. A459 (2001) 319
C  THIS FUNCTION IS CALLED FROM PRANGC, PRANGE, UPDATE, AND AUGEDP.
C  ARGUMENT:
C   ELAB   = TOTAL ENERGY OF MUON
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSIGMU/ BREMSTAB,NUCTAB,PAIRTAB,DEDXMU,DEDXM,
     *                 FRABTN,FRANTN,FRAPTN,FRBTNO,FRNTNO,FRPTNO,
     *                 SIGBRM,SIGNUC,SIGPRM

      DOUBLE PRECISION BREMSTAB(141,3),NUCTAB(141,3),PAIRTAB(141,3),
     *                 DEDXMU(141,3),DEDXM(141),FRABTN,FRANTN,FRAPTN,
     *                 FRBTNO,FRNTNO,FRPTNO,SIGBRM,SIGNUC,SIGPRM

       

       

       

       

      DOUBLE PRECISION DELTAE,ELAB,WK(3),YE
      INTEGER          I,JE
      SAVE
C-----------------------------------------------------------------------

C  DETERMINE ENERGY INTERVAL FOR INTERPOLATION
C  WE HAVE 10 POINTS/DECADE AND 2 DECADES BELOW 1 GEV
      YE = 10.D0 * LOG10(ELAB) + 21.D0
      IF ( YE .LT. 1.D0 ) YE = 1.D0
      JE = INT( YE )
      IF ( JE .GT. 139 ) JE = 139
      DELTAE = YE - DBLE(JE)
      WK(3)  = DELTAE * (DELTAE-1.D0) * .5D0
      WK(1)  = 1.D0 - DELTAE  + WK(3)
      WK(2)  = DELTAE - 2.D0 * WK(3)

C  NOW MAKE QUADRATIC INTERPOLATION OF THE DEDXM TABLE
      CDEDXM = 0.D0
      DO  I = 1, 3
        CDEDXM = CDEDXM + DEDXM(JE+I-1)*WK(I)
      ENDDO

C     IF ( DEBUG ) WRITE(MDEBUG,444) ELAB,CDEDXM
C 444 FORMAT(' CDEDXM: E=',1P,E10.4,' CDEDXM=',E12.5)

      RETURN
      END

*-- Author :    The CORSIKA development group   16/05/1995
C=======================================================================

      DOUBLE PRECISION FUNCTION CHISQ( F )

C-----------------------------------------------------------------------
C  CHI SQ(UARE)
C
C  THIS FUNCTION CALCULATES THE CHI**2 OBTAINED WITH THE HILLAS
C  FUNCTION AND THE FIT SUBROUT. AMOEBA USING THE PARAMETER SET F
C  SEE: T.K. GAISSER & A.M. HILLAS, PROC. XV ICRC, PLOVDIV, BULGARIA,
C  VOL. 8 (1977) 353
C  THIS FUNCTION IS CALLED FROM LONGFT AND AMOEBA
C  ARGUMETS:
C   F(1)  = HEIGHT AT MAXIMUM
C   F(2)  = SHOWER STARTING POINT
C   F(3)  = T AT MAXIMUM
C   F(4)  = WIDTH PARAMETER 1
C   F(5)  = WIDTH PARAMETER 2 T
C   F(6)  = WIDTH PARAMETER 3 T**2
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCURVE/ CHAPAR,DEP,ERR,NSTP
      DOUBLE PRECISION CHAPAR(1200),DEP(1200),ERR(1200)
      INTEGER          NSTP

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION AUXIL,BALL,BASE,EXPO,F(6),T,WIDTH
      INTEGER          I
      SAVE
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,*) 'CHISQ : PARAMETERS,NSTP =',
     *                              (SNGL(F(I)),I=1,6),NSTP

C  EXCLUDE PATHOLOGICAL PARAMETER SETTINGS
      IF ( F(1) .LE. 0.D0  .OR.   F(2) .GE. F(3)  .OR.
     *    (F(4) .LE. 0.D0  .AND.  F(5) .EQ. 0.D0  .AND.
     *                            F(6) .EQ. 0.D0) ) THEN
        CHISQ = 1.D16
        RETURN
      ENDIF

      CHISQ = 0.D0
C  LOOP OVER THE LONGITUDINAL DISTRIBUTION
      DO  1  I = 1, NSTP
        T = DEP(I)
        IF ( T .GT. F(2) ) THEN
          BASE  = (T-F(2)) / (F(3)-F(2))
          WIDTH = F(4) + T*F(5) + T**2*F(6)
          IF ( WIDTH .LT. 1.D-20 ) THEN
            CHISQ = CHISQ + 1.D16
            GOTO 1
          ENDIF
          EXPO  = (F(3)-F(2)) / WIDTH
          AUXIL = (F(3)-T) / WIDTH
          IF ( ABS(AUXIL) .GT. 20.D0 ) THEN
            CHISQ = CHISQ + 1.D16
            GOTO 1
          ENDIF
          BALL = F(1) * BASE ** EXPO * EXP(AUXIL)
        ELSE
          BALL = 0.D0
        ENDIF
        CHISQ = CHISQ + ((BALL-CHAPAR(I))/ERR(I))**2
 1    CONTINUE
      CHISQ = CHISQ / (NSTP-6)

      IF ( DEBUG ) WRITE(MDEBUG,*) 'CHISQ : CHI**2 =',SNGL(CHISQ)

      RETURN
      END

*-- Author :    The CORSIKA development group   16/05/1995
C=======================================================================

      DOUBLE PRECISION FUNCTION CHISQ1( F )

C-----------------------------------------------------------------------
C  CHI SQ(UARE FOR THE) 1(ST FIT FUNCTION))
C
C  THIS FUNCTION CALCULATES THE CHI**2 OBTAINED WITH THE HILLAS
C  FUNCTION AND THE FIT SUBROUT. AMOEBA USING THE PARAMETER SET F
C  SEE: T.K. GAISSER & A.M. HILLAS, PROC. XV ICRC, PLOVDIV, BULGARIA,
C  VOL. 8 (1977) 353
C  THIS FUNCTION IS CALLED FROM LONGFT AND AMOEBA
C  ARGUMETS:
C   F(1)  = HEIGHT AT MAXIMUM
C   F(2)  = SHOWER STARTING POINT
C   F(3)  = T AT MAXIMUM
C   F(4)  = WIDTH PARAMETER
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCURVE/ CHAPAR,DEP,ERR,NSTP
      DOUBLE PRECISION CHAPAR(1200),DEP(1200),ERR(1200)
      INTEGER          NSTP

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION AUXIL,BALL,BASE,EXPO,F(6),T
      INTEGER          I
      SAVE
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,*)'CHISQ1: PARAMETERS,NSTP =',
     *                             (SNGL(F(I)),I=1,4),NSTP

C  EXCLUDE PATHOLOGICAL PARAMETER SETTINGS
      IF ( F(1) .LE. 0.D0  .OR.  F(2) .GE. F(3)  .OR.
     *                           F(4) .LE. 0.D0 ) THEN
        CHISQ1 = 1.D16
        RETURN
      ENDIF

      CHISQ1 = 0.D0
C  LOOP OVER THE LONGITUDINAL DISTRIBUTION
      DO  1  I = 1, NSTP
        T = DEP(I)
        IF ( T .GT. F(2) ) THEN
          BASE  = (T-F(2)) / (F(3)-F(2))
          AUXIL = F(4)
          IF ( AUXIL .LT. 1.D-20 ) THEN
            CHISQ1 = CHISQ1 + 1.D16
            GOTO 1
          ENDIF
          EXPO  = (F(3)-F(2)) / AUXIL
          AUXIL = (F(3)-T) / AUXIL
          IF ( ABS(AUXIL) .GT. 20.D0 ) THEN
            CHISQ1 = CHISQ1 + 1.D16
            GOTO 1
          ENDIF
          BALL = F(1) * BASE ** EXPO * EXP(AUXIL)
        ELSE
          BALL = 0.D0
        ENDIF
        CHISQ1 = CHISQ1 + ((BALL-CHAPAR(I))/ERR(I))**2
 1    CONTINUE
      CHISQ1 = CHISQ1 / (NSTP-4)

      IF ( DEBUG ) WRITE(MDEBUG,*) 'CHISQ1 : CHI**2 =',SNGL(CHISQ1)

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   15/05/2003
C=======================================================================

      DOUBLE PRECISION FUNCTION CNUSGM( ELAB,MAT )

C-----------------------------------------------------------------------
C  C(ALCULATE) NU(CLEAR INTERACTION) S(I)G(MA FOR) M(UONS)
C
C  CALCULATES THE CROSS-SECTION IN CURRENT MATERIAL FOR DISCRETE (HARD)
C  MUON NUCLEAR INTERACTION. (SIGMA IN BARN/ATOM)
C  THIS FUNCTION USES TABLES ESTABLISHED WITH THE SUBR. MUPINI
C  ACCORDING THE ROUTINES OF:
C       S. BOTTAI AND L. PERRONE, NUCL. INST. METH. A459 (2001) 319
C  THESE TABLES ARE GIVEN AS LOG OF THE CROSS-SECTIONS.
C  THIS FUNCTION IS CALLED FROM BOX2.
C  ARGUMENTS:
C   ELAB   = TOTAL ENERGY OF MUON
C   MAT    = MATERIAL INDEX: 1=14N, 2=16O, 3=40AR
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSIGMU/ BREMSTAB,NUCTAB,PAIRTAB,DEDXMU,DEDXM,
     *                 FRABTN,FRANTN,FRAPTN,FRBTNO,FRNTNO,FRPTNO,
     *                 SIGBRM,SIGNUC,SIGPRM

      DOUBLE PRECISION BREMSTAB(141,3),NUCTAB(141,3),PAIRTAB(141,3),
     *                 DEDXMU(141,3),DEDXM(141),FRABTN,FRANTN,FRAPTN,
     *                 FRBTNO,FRNTNO,FRPTNO,SIGBRM,SIGNUC,SIGPRM

       

       

       

       

      DOUBLE PRECISION DELTAE,ELAB,WK(3),YE
      INTEGER          I,JE,MAT
      SAVE
C-----------------------------------------------------------------------

C  DETERMINE ENERGY INTERVAL FOR INTERPOLATION
C  WE HAVE 10 POINTS/DECADE AND 2 DECADES BELOW 1 GEV
      YE = 10.D0 * LOG10(ELAB) + 21.D0
      IF ( YE .LT. 1.D0 ) YE = 1.D0
      JE = INT( YE )
      IF ( JE .GT. 139 ) JE = 139
      DELTAE = YE - DBLE(JE)
      WK(3)  = DELTAE * (DELTAE-1.D0) * .5D0
      WK(1)  = 1.D0 - DELTAE  + WK(3)
      WK(2)  = DELTAE - 2.D0 * WK(3)

C  NOW MAKE QUADRATIC INTERPOLATION OF THE LOG OF CROSS-SECTIONS
      CNUSGM = 0.D0
      DO  I = 1, 3
        CNUSGM = CNUSGM + NUCTAB(JE+I-1,MAT)*WK(I)
      ENDDO
      CNUSGM = EXP(CNUSGM)

C     IF ( DEBUG ) WRITE(MDEBUG,444) ELAB,MAT,CNUSGM
C 444 FORMAT(' CNUSGM: E=',1P,E10.4,' MAT=',I3,' CNUSGM=',E12.5)

      RETURN
      END

*-- Author :     F. SCHROEDER UNI WUPPERTAL     18/11/1998
C=======================================================================

      SUBROUTINE COOINC

C-----------------------------------------------------------------------
C  COO(RDINATE) IN(ITIALIZATION FOR A) C(URVED ATMOSPHERE)
C
C  INITIALIZES ALL IMPORTANT COORDINATES FOR ONE OBSERVATION LEVEL
C  ROUTINE DETERMINES STARTING PARAMETERS AT HEIGHT GIVEN BY THICK0 FOR
C  A COORDINATE SYSTEM WHICH IS FIXED IN (X,Y) AT THE ASSUMED DETECTOR
C  POSITION AND IN Z AT SEA LEVEL.
C  THIS SUBROUTINE IS CALLED FROM AAMAIN.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CROBSPAR/OBSLEV,THCKOB,XOFF,YOFF,HEIGHP,THETAP,PHIP,
     *                 THETPR,PHIPR,

     *                 VUECON,

     *                 NOBSLV
      DOUBLE PRECISION OBSLEV(20),THCKOB(20),XOFF(20),YOFF(20),
     *                 HEIGHP,THETAP,THETPR(2),PHIP,PHIPR(2)

      DOUBLE PRECISION VUECON(2)

      INTEGER          NOBSLV

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRTIMLIM/DSTLIM,TIMLIM
      DOUBLE PRECISION DSTLIM,TIMLIM

       

       

       

       

      DOUBLE PRECISION AUXIL,DIST,TEA,THETA
      DOUBLE PRECISION DIAG

      SAVE
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,*) 'COOINC: H,COSTAP,PHI =',
     *                     SNGL(H),SNGL(COSTAP),SNGL(PHIP)

C  NOTE : ANGLES THETAP AND PHIP ARE APPARENT ANGLES OF PRIMARY AT
C         THE EDGE OF THE ATMOSPHERE SEEN FROM THE
C         DETECTOR POSITION X=Y=0, Z=OBSLEV(1)
C  FOR CALCULATIONS: COSTAP = COSINE OF APPARENT ZENITH ANGLE THETAP
C  COSTAP IS SET IN AAMAIN BY EQUIVALENCE WITH CURPAR(15)

C  DISTANCE DIAG BETWEEN DETECTOR POSITION  X=Y=0, Z = OBSLEV(1) AND
C  STARTING POINT
      AUXIL  = (C(1)+H)**2 - (C(1)+OBSLEV(1))**2
     *                                  * (1.D0-COSTAP)*(1.D0+COSTAP)
      DIAG   = SQRT( AUXIL ) - (C(1)+OBSLEV(1)) * COSTAP
C  APPARENT HEIGHT HAPP IS PARTICLE Z-COORDINATE IN DETECTOR SYSTEM
      HAPP   = OBSLEV(1) + DIAG * COSTAP
C  CALCULATING COSINE OF THETA_EARTH COSTEA, COSINE OF ZENITH ANGLE BY
C  TAKING A COORDINATE FRAME CENTERED IN THE MIDDLE OF EARTH
      COSTEA = (C(1)+HAPP) / (C(1)+H)
      IF ( DEBUG ) WRITE(MDEBUG,*) 'COOINC: HAPP,COSTEA,DIAG =',
     *                           SNGL(HAPP),COSTEA,SNGL(DIAG)
      COSTEA = MIN( 1.D0, COSTEA )
C  TRANSFORM THE APPARENT ANGLE SEEN FROM DETECTOR POSITION TO LOCAL
C  ANGLES RELATIVE TO THE VERTICAL TO THE MIDDLE OF EARTH
C  NOTE : LOCAL ZENITH ANGLE = DIFFERENCE OF APPARENT ZENITH ANGLE AND
C         THETA_EARTH
      COSTHE = (DIAG + (C(1)+OBSLEV(1))*COSTAP)/(C(1)+H)

C  SET TIME LIMIT TO AVOID UNNECESSARY COMPUTING TIME WITH PARTICLES
C  WELL ABOVE THE TIME LIMIT. THE TIME LIMIT IS GIVEN BY THE 
C  PROPAGATION TIME ALONG DIAD WITH SPEED OF LIGHT AND SOME ADDITIONAL
C  DISTANCE DOWNSTREAM OF THE DETECTOR DLIMIT (CM).
C  FOR SAFETY ADD ADDITIONAL 20 MICROSEC. (ALL TIME UNITS IN SEC)
      IF ( DSTLIM .GT. 0.D0 ) THEN
        TIMLIM = ( DIAG + DSTLIM ) / C(25) + 2.D-5
      ELSE
C  DEFAULT LIMIT IS 20 KM  
        TIMLIM = ( DIAG + 20.D5 ) / C(25) + 2.D-5
      ENDIF

C  DISTANCE DIST BETWEEN THE DETECTOR POSITION X=0, Y=0
C  AND THE ACTUAL INTERACTION POINT MEASURED ON THE EARTH''S SURFACE
      TEA    = ACOS( COSTEA )
      DIST   = C(1) * TEA

C  CONCERNING TRANSFORMATION OF AZIMUTH ANGLE PHI
C  NOTE : THE COORDINATE SYTEMS ONLY DIFFER IN A SHIFT ALONG THE Z-AXIS
C         OR A ROTATION ALONG THE ZENITH ANGLE. BOTH TRANSFORMATIONS
C         JUST CHANGE THETA AND NOT PHI (THETA AND PHI ARE ORTHOGONAL
C         COORDINATES, THUS LINEAR INDEPENDENT).

C  X,Y-COORDINATES SEEN FROM THE DETECTOR POSITION (X=Y=0)
      X = -DIST * COS( PHIP )
      Y = -DIST * SIN( PHIP )
      IF ( DEBUG ) WRITE(MDEBUG,*) 'COOINC: X,Y,COSTHE,DIST =',
     *                    SNGL(X),SNGL(Y),SNGL(COSTHE),SNGL(DIST)

C   FILL PARAMETERS IN PRMPAR
      PRMPAR(2)  = COSTHE
      PRMPAR(7)  = X
      PRMPAR(8)  = Y
      THETA      = ACOS( COSTHE )
      PRMPAR(3)  = SIN( THETA ) * COS( PHIP )
      PRMPAR(4)  = SIN( THETA ) * SIN( PHIP )
C  WE HAVE EQUIVALENCES FOR HAPP AND COSTEA
C     CURPAR(14) = HAPP
C     CURPAR(16) = COSTEA

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   12/05/2003
C=======================================================================

      DOUBLE PRECISION FUNCTION CPRSGM( ELAB,MAT )

C-----------------------------------------------------------------------
C  C(ALCULATE) P(AI)R (PRODUCTION) S(I)G(MA FOR) M(UONS)
C
C  CALCULATES THE CROSS-SECTION IN CURRENT MATERIAL FOR DISCRETE (HARD)
C  MUON PAIR PRODUCTION. (SIGMA IN BARN/ATOM)
C  THIS FUNCTION USES TABLES ESTABLISHED WITH THE SUBR. MUPINI
C  ACCORDING THE ROUTINES OF:
C       S. BOTTAI AND L. PERRONE, NUCL. INST. METH. A459 (2001) 319
C  THESE TABLES ARE GIVEN AS LOG OF THE CROSS-SECTIONS.
C  THIS FUNCTION IS CALLED FROM BOX2.
C  ARGUMENTS:
C   ELAB   = TOTAL ENERGY OF MUON
C   MAT    = MATERIAL INDEX: 1=14N, 2=16O, 3=40AR
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSIGMU/ BREMSTAB,NUCTAB,PAIRTAB,DEDXMU,DEDXM,
     *                 FRABTN,FRANTN,FRAPTN,FRBTNO,FRNTNO,FRPTNO,
     *                 SIGBRM,SIGNUC,SIGPRM

      DOUBLE PRECISION BREMSTAB(141,3),NUCTAB(141,3),PAIRTAB(141,3),
     *                 DEDXMU(141,3),DEDXM(141),FRABTN,FRANTN,FRAPTN,
     *                 FRBTNO,FRNTNO,FRPTNO,SIGBRM,SIGNUC,SIGPRM

       

       

       

       

      DOUBLE PRECISION DELTAE,ELAB,WK(3),YE
      INTEGER          I,JE,MAT
      SAVE
C-----------------------------------------------------------------------

C  DETERMINE ENERGY INTERVAL FOR INTERPOLATION
C  WE HAVE 10 POINTS/DECADE AND 2 DECADES BELOW 1 GEV
      YE = 10.D0 * LOG10(ELAB) + 21.D0
      IF ( YE .LT. 1.D0 ) YE = 1.D0
      JE = INT( YE )
      IF ( JE .GT. 139 ) JE = 139
      DELTAE = YE - DBLE(JE)
      WK(3)  = DELTAE * (DELTAE-1.D0) * .5D0
      WK(1)  = 1.D0 - DELTAE  + WK(3)
      WK(2)  = DELTAE - 2.D0 * WK(3)

C  NOW MAKE QUADRATIC INTERPOLATION OF THE LOG OF CROSS-SECTIONS
      CPRSGM = 0.D0
      DO  I = 1, 3
        CPRSGM = CPRSGM + PAIRTAB(JE+I-1,MAT)*WK(I)
      ENDDO
      CPRSGM = EXP(CPRSGM)

C     IF ( DEBUG ) WRITE(MDEBUG,444) ELAB,MAT,CPRSGM
C 444 FORMAT(' CPRSGM: E=',1P,E10.4,' MAT=',I3,' CPRSGM=',E12.5)

      RETURN
      END

*-- Author :    A.C.Genz, A.A.Malik, CERN, MATHLIB 15/11/1995
C=======================================================================

      SUBROUTINE DADMUL( F,N,A,B,MINPTS,MAXPTS,EPS,WK,IWK,RESULT,
     *                   RELERR,NFNEVL,IFAIL )
C-----------------------------------------------------------------------
C  D(OUBLE PRECISION) AD(APTIVE QUADRATURE FOR) MUL(TIPLE INTEGRALS)
C
C  CERN ROUTINE FOR ADAPTIVE QUADRATURE FOR MULTIPLE INTEGRALS OVER
C  N-DIMENSIONAL RECTANGULAR REGIONS.
C  SEE: http://consult.cern.ch/shortwriteups/d120/top.html
C  THIS ROUTINE IS SLIGHTLY MODIFIED TO MEET REQUIREMENTS OF CORSIKA.
C  THIS ROUTINE IS CALLED FROM DBRELM, DBRSGM, DNUSGM, DPRELM, DPRSGM.
C  ARGUMENTS:   SEE REFERENCE
C-----------------------------------------------------------------------

      IMPLICIT NONE
      DOUBLE PRECISION HF,R1,W2,W4,WP2,WP4,XL2,XL4,XL5
      PARAMETER        (R1  = 1.D0)
      PARAMETER        (HF  = R1/2.D0)
      PARAMETER        (W2  = 980.D0*R1/6561.D0)
      PARAMETER        (W4  = 200.D0*R1/19683.D0)
      PARAMETER        (WP2 = 245.D0*R1/486.D0)
      PARAMETER        (WP4 =  25.D0*R1/729.D0)
      PARAMETER        (XL2 = 0.358568582800318073D0)
      PARAMETER        (XL4 = 0.948683298050513796D0)
      PARAMETER        (XL5 = 0.688247201611685289D0)

      DOUBLE PRECISION A(*),B(*),WK(*)
      DOUBLE PRECISION CTR(15),WTH(15),WTHL(15),Z(15),
     *                 W(2:15,5),WP(2:15,3)
      DOUBLE PRECISION ABSERR,DIF,DIFMAX,EPS,F2,F3,
     *                 RELERR,RESULT,RGNCMP,RGNERR,RGNVAL,RGNVOL,
     *                 SUM1,SUM2,SUM3,SUM4,SUM5,TWONDM
      INTEGER          IDVAXN,IDVAX0,IFAIL,IFNCLS,IRGNST,IRLCLS,
     *                 ISBRGN,ISBRGS,ISBTMP,ISBTPP,IWK,
     *                 J,J1,K,L,M,MAXPTS,MINPTS,N,NFNEVL
      LOGICAL          LDV
      DOUBLE PRECISION F
      EXTERNAL         F
      SAVE

      DATA (W(N,1),W(N,3),N=2,15)
     1/-0.193872885230909911D+00,  0.518213686937966768D-01,
     2 -0.555606360818980835D+00,  0.314992633236803330D-01,
     3 -0.876695625666819078D+00,  0.111771579535639891D-01,
     4 -0.115714067977442459D+01, -0.914494741655235473D-02,
     5 -0.139694152314179743D+01, -0.294670527866686986D-01,
     6 -0.159609815576893754D+01, -0.497891581567850424D-01,
     7 -0.175461057765584494D+01, -0.701112635269013768D-01,
     8 -0.187247878880251983D+01, -0.904333688970177241D-01,
     9 -0.194970278920896201D+01, -0.110755474267134071D+00,
     A -0.198628257887517146D+01, -0.131077579637250419D+00,
     B -0.198221815780114818D+01, -0.151399685007366752D+00,
     C -0.193750952598689219D+01, -0.171721790377483099D+00,
     D -0.185215668343240347D+01, -0.192043895747599447D+00,
     E -0.172615963013768225D+01, -0.212366001117715794D+00/

      DATA (W(N,5),W(N+1,5),N=2,14,2)
     1/ 0.871183254585174982D-01,  0.435591627292587508D-01,
     2  0.217795813646293754D-01,  0.108897906823146873D-01,
     3  0.544489534115734364D-02,  0.272244767057867193D-02,
     4  0.136122383528933596D-02,  0.680611917644667955D-03,
     5  0.340305958822333977D-03,  0.170152979411166995D-03,
     6  0.850764897055834977D-04,  0.425382448527917472D-04,
     7  0.212691224263958736D-04,  0.106345612131979372D-04/

      DATA (WP(N,1),WP(N,3),N=2,15)
     1/-0.133196159122085045D+01,  0.445816186556927292D-01,
     2 -0.229218106995884763D+01, -0.240054869684499309D-01,
     3 -0.311522633744855959D+01, -0.925925925925925875D-01,
     4 -0.380109739368998611D+01, -0.161179698216735251D+00,
     5 -0.434979423868312742D+01, -0.229766803840877915D+00,
     6 -0.476131687242798352D+01, -0.298353909465020564D+00,
     7 -0.503566529492455417D+01, -0.366941015089163228D+00,
     8 -0.517283950617283939D+01, -0.435528120713305891D+00,
     9 -0.517283950617283939D+01, -0.504115226337448555D+00,
     A -0.503566529492455417D+01, -0.572702331961591218D+00,
     B -0.476131687242798352D+01, -0.641289437585733882D+00,
     C -0.434979423868312742D+01, -0.709876543209876532D+00,
     D -0.380109739368998611D+01, -0.778463648834019195D+00,
     E -0.311522633744855959D+01, -0.847050754458161859D+00/
C-----------------------------------------------------------------------

      RESULT = 0.D0
      ABSERR = 0.D0
      IFAIL  = 3
      IF ( N .LT. 2  .OR.  N .GT. 15 ) RETURN
      IF ( MINPTS .GT. MAXPTS ) RETURN

      IFNCLS = 0
      LDV    = .FALSE.
      TWONDM = 2.D0**N
      IRGNST = 2 * N + 3
      IRLCLS = 2**N + 2 * N * (N+1) + 1
      ISBRGN = IRGNST
      ISBRGS = IRGNST
      IF ( MAXPTS .LT. IRLCLS ) RETURN
      DO  J = 1, N
        CTR(J) = (B(J)+A(J)) * HF
        WTH(J) = (B(J)-A(J)) * HF
      ENDDO

   20 RGNVOL = TWONDM
      DO  J = 1, N
        RGNVOL = RGNVOL * WTH(J)
        Z(J)   = CTR(J)
      ENDDO
      SUM1   = F(Z)

      DIFMAX = 0.D0
      SUM2   = 0.D0
      SUM3   = 0.D0
      DO  J = 1, N
        Z(J)   = CTR(J) - XL2 * WTH(J)
        F2     = F(Z)
        Z(J)   = CTR(J) + XL2 * WTH(J)
        F2     = F2 + F(Z)
        WTHL(J)= XL4 * WTH(J)
        Z(J)   = CTR(J) - WTHL(J)
        F3     = F(Z)
        Z(J)   = CTR(J) + WTHL(J)
        F3     = F3 + F(Z)
        SUM2   = SUM2 + F2
        SUM3   = SUM3 + F3
        DIF    = ABS( 7.D0*F2 - F3 - 12.D0*SUM1 )
        DIFMAX = MAX( DIF, DIFMAX )
*       IF ( DIFMAX .EQ. DIF ) IDVAXN = J
        IF ( ABS(DIFMAX - DIF) .LE. DIF*1.D-10 ) IDVAXN = J
        Z(J)   = CTR(J)
      ENDDO

      SUM4   = 0.D0
      DO  J = 2, N
        J1 = J - 1
        DO  K = J, N
          DO  L = 1, 2
            WTHL(J1) = -WTHL(J1)
            Z(J1)    = CTR(J1) + WTHL(J1)
            DO  M = 1, 2
              WTHL(K) = -WTHL(K)
              Z(K)    = CTR(K) + WTHL(K)
              SUM4    = SUM4 + F(Z)
            ENDDO
          ENDDO
          Z(K) = CTR(K)
        ENDDO
        Z(J1) = CTR(J1)
      ENDDO

      SUM5   = 0.D0
      DO  J = 1, N
        WTHL(J) = -XL5 * WTH(J)
        Z(J)    = CTR(J) + WTHL(J)
      ENDDO
   90 SUM5   = SUM5 + F(Z)
      DO  J = 1, N
        WTHL(J) = -WTHL(J)
        Z(J)    = CTR(J) + WTHL(J)
        IF ( WTHL(J) .GT. 0.D0 ) GOTO 90
      ENDDO

      RGNCMP = RGNVOL*(WP(N,1)*SUM1 + WP2*SUM2 + WP(N,3)*SUM3
     *                                                  + WP4*SUM4)
      RGNVAL = W(N,1)*SUM1 + W2*SUM2 + W(N,3)*SUM3
     *                                     + W4*SUM4 + W(N,5)*SUM5
      RGNVAL = RGNVOL * RGNVAL
      RGNERR = ABS( RGNVAL - RGNCMP )
      RESULT = RESULT + RGNVAL
      ABSERR = ABSERR + RGNERR
      IFNCLS = IFNCLS + IRLCLS

      IF ( LDV ) THEN
  110   ISBTMP = 2 * ISBRGN
        IF ( ISBTMP .GT. ISBRGS ) GOTO 160
        IF ( ISBTMP .LT. ISBRGS ) THEN
          ISBTPP = ISBTMP + IRGNST
          IF ( WK(ISBTMP) .LT. WK(ISBTPP) ) ISBTMP = ISBTPP
        ENDIF
        IF ( RGNERR .GE. WK(ISBTMP) ) GOTO 160
        DO  K = 0, IRGNST-1
          WK(ISBRGN-K) = WK(ISBTMP-K)
        ENDDO
        ISBRGN = ISBTMP
        GOTO 110
      ENDIF
  140 ISBTMP = (ISBRGN / (2*IRGNST) ) * IRGNST
      IF ( ISBTMP .GE. IRGNST  ) THEN
        IF ( RGNERR .GT. WK(ISBTMP) ) THEN
          DO  K = 0, IRGNST-1
            WK(ISBRGN-K) = WK(ISBTMP-K)
          ENDDO
          ISBRGN = ISBTMP
          GOTO 140
        ENDIF
      ENDIF
  160 WK(ISBRGN)   = RGNERR
      WK(ISBRGN-1) = RGNVAL
      WK(ISBRGN-2) = IDVAXN
      DO  J = 1, N
        ISBTMP       = ISBRGN - 2*J - 2
        WK(ISBTMP+1) = CTR(J)
        WK(ISBTMP)   = WTH(J)
      ENDDO
      IF ( LDV ) THEN
        LDV = .FALSE.
        CTR(IDVAX0) = CTR(IDVAX0) + 2.D0 * WTH(IDVAX0)
        ISBRGS = ISBRGS + IRGNST
        ISBRGN = ISBRGS
        GOTO 20
      ENDIF
      IF ( RESULT .NE. 0.D0 ) THEN
        RELERR = ABSERR / ABS(RESULT)
      ELSE
        RELERR = 0.D0
      ENDIF
      IF ( ISBRGS+IRGNST .GT. IWK ) IFAIL = 2
      IF ( IFNCLS+2*IRLCLS .GT. MAXPTS ) IFAIL = 1
      IF ( RELERR .LT. EPS  .AND.  IFNCLS .GE. MINPTS ) IFAIL = 0
      IF ( IFAIL .EQ. 3 ) THEN
        LDV    = .TRUE.
        ISBRGN = IRGNST
        ABSERR = ABSERR - WK(ISBRGN)
        RESULT = RESULT - WK(ISBRGN-1)
        IDVAX0 = WK(ISBRGN-2)
        DO  J = 1, N
          ISBTMP = ISBRGN - 2*J - 2
          CTR(J) = WK(ISBTMP+1)
          WTH(J) = WK(ISBTMP)
        ENDDO
        WTH(IDVAX0) = HF * WTH(IDVAX0)
        CTR(IDVAX0) = CTR(IDVAX0) - WTH(IDVAX0)
        GOTO 20
      ENDIF
      NFNEVL = IFNCLS

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE DATAC

C-----------------------------------------------------------------------
C  DATA C(ARDS)
C
C  READS DATA CARDS FROM UNIT 5 TO STEER RUN.
C  READING IS FREE FORMAT WITH BLANK AS SEPARATOR.
C  EACH KEYWORD STARTS ON A NEW LINE LEFTSHIFTED.
C  THIS SUBROUTINE IS CALLED FROM START.
C-----------------------------------------------------------------------
c------changed-------add and comand 
c      IMPLICIT NONE
c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c All this lines are under test
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
      parameter (xct=1)
      parameter (yct=2)
      parameter (zct=3)
      parameter (ctthet=4)
      parameter (ctphi=5)
      parameter (ctdiam=6)
      parameter (ctfoc=7)
c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c------changed-------add and comand 



      COMMON /CRATMOS/ AATM,AATM0,BATM,BATM0,CATM,CATM0,DATM,MODATM
      DOUBLE PRECISION AATM(5),AATM0(5,0:22),BATM(5),BATM0(5,0:22),
     *                 CATM(5),CATM0(5,0:22),DATM(5)
      INTEGER          MODATM

      COMMON /CRATMOS2/HLAY,HLAY0,THICKL,LAYNO,LAYNEW
      DOUBLE PRECISION HLAY(6),HLAY0(5,0:9),THICKL(5)
      INTEGER          LAYNO(0:22)
      LOGICAL          LAYNEW

C  EXTERNAL ATMOSPHERIC MODELS
      COMMON /CRATMOSX/IATMOX,FREFRX
      INTEGER          IATMOX
      LOGICAL          FREFRX

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRDPMFLG/NFLAIN,NFLDIF,NFLPI0,NFLCHE,NFLPIF,NFRAGM
      INTEGER          NFLAIN,NFLDIF,NFLPI0,NFLCHE,NFLPIF,NFRAGM

      COMMON /CREGSDEB/JCLOCK,NCLOCK,FEGSDB
      INTEGER          JCLOCK,NCLOCK
      LOGICAL          FEGSDB

      COMMON /CRELABCT/ELCUT
      DOUBLE PRECISION ELCUT(4)

      COMMON /CRETHMAP/ECTMAP,ELEFT
      DOUBLE PRECISION ECTMAP,ELEFT

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRMAGANG/ARRANG,ARRANR,COSANG,SINANG
      DOUBLE PRECISION ARRANG,ARRANR,COSANG,SINANG

      COMMON /CRMAGNET/BX,BZ,BVAL,BNORMC,BNORM,COSB,SINB,BLIMIT
      DOUBLE PRECISION BX,BZ,BVAL,BNORMC,BNORM,COSB,SINB,BLIMIT

      COMMON /CRMUMULT/CHC,OMC,PHISCT,STEPL,VSCAT,FMOLI
      DOUBLE PRECISION CHC,OMC,PHISCT,STEPL,VSCAT
      LOGICAL          FMOLI

      COMMON /CRNKGI/  SEL,SELLG,STH,ZEL,ZELLG,ZSL,DIST,
     *                 DISX,DISY,DISXY,DISYX,DLAX,DLAY,DLAXY,DLAYX,
     *                 OBSATI,RADNKG,RMOL,TLEV,TLEVCM,IALT
      DOUBLE PRECISION SEL(10),SELLG(10),STH(10),ZEL(10),ZELLG(10),
     *                 ZSL(10),DIST(10),
     *                 DISX(-10:10),DISY(-10:10),
     *                 DISXY(-10:10,2),DISYX(-10:10,2),
     *                 DLAX (-10:10,2),DLAY (-10:10,2),
     *                 DLAXY(-10:10,2),DLAYX(-10:10,2),
     *                 OBSATI(2),RADNKG,RMOL(2),TLEV(10),TLEVCM(10)
      INTEGER          IALT(2)

      COMMON /CROBSPAR/OBSLEV,THCKOB,XOFF,YOFF,HEIGHP,THETAP,PHIP,
     *                 THETPR,PHIPR,

     *                 VUECON,

     *                 NOBSLV
      DOUBLE PRECISION OBSLEV(20),THCKOB(20),XOFF(20),YOFF(20),
     *                 HEIGHP,THETAP,THETPR(2),PHIP,PHIPR(2)

      DOUBLE PRECISION VUECON(2)

      INTEGER          NOBSLV

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      COMMON /CRPRIMSP/PSLOPE,LLIMIT,ULIMIT,LL,UL,SLEX,ISPEC
      DOUBLE PRECISION PSLOPE,LLIMIT,ULIMIT,LL,UL,SLEX
      INTEGER          ISPEC

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      INTEGER          KSEQ
      PARAMETER        (KSEQ = 5)
      COMMON /CRRANMA3/CD,CINT,CM,TWOM24,TWOM48,MODCNS
      DOUBLE PRECISION CD,CINT,CM,TWOM24,TWOM48
      INTEGER          MODCNS

      COMMON /CRREJECT/AVNREJ,ALTMIN,ANEXP,THICKA,THICKD,CUTLN,EONCUT,

     *                 FNPRIM
      DOUBLE PRECISION AVNREJ(20),ALTMIN(20),ANEXP(20),THICKA(20),
     *                 THICKD(20),CUTLN,EONCUT

      LOGICAL          FNPRIM

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRTIMLIM/DSTLIM,TIMLIM
      DOUBLE PRECISION DSTLIM,TIMLIM

      COMMON /CRCEREN1/CERELE,CERHAD,ETADSN,WAVLGL,WAVLGU,CYIELD,
     *                 CERSIZ,CERNOR,LCERFI,LCERDB
      DOUBLE PRECISION CERELE,CERHAD,ETADSN,WAVLGL,WAVLGU,CYIELD,
     *                 CERSIZ,CERNOR
      LOGICAL          LCERFI,LCERDB

      COMMON /CRCEREN2/ACERX,ACERY,CERXOS,CERYOS,
     *                 DCERX,DCERXI,DCERY,DCERYI,EPSX,EPSY,FCERX,FCERY,
     *                 WL,XCMAX,XCMAXS,XSCATT,YCMAX,YCMAXS,YSCATT,
     *                 PHOTCM,XCER,YCER,UEMIS,VEMIS,WEMIS,CARTIM,
     *                 XEMIS,YEMIS,ZEMIS,XSTEP,YSTEP,ZSTEP,
     *                 XSTEP2,YSTEP2,ZSTEP2,

     *                 NCERX,NCERY,ICERML
      DOUBLE PRECISION ACERX,ACERY,CERXOS(20),CERYOS(20),
     *                 DCERX,DCERXI,DCERY,DCERYI,EPSX,EPSY,FCERX,FCERY,
     *                 WL,XCMAX,XCMAXS,XSCATT,YCMAX,YCMAXS,YSCATT
      DOUBLE PRECISION PHOTCM,XCER,YCER,UEMIS,VEMIS,WEMIS,CARTIM,
     *                 XEMIS,YEMIS,ZEMIS,XSTEP,YSTEP,ZSTEP,
     *                 XSTEP2,YSTEP2,ZSTEP2

      INTEGER          NCERX,NCERY,ICERML

c------changed-----add

c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>><<
c------changed trajetory------------
      COMMON /CRTRAJ/  DECL,RA,TRAD,TYEAR,TMONTH,TDAY,THOUR,
     *                 TMINUTE,TSECOND,DURATION,TRAJLOGIC
      DOUBLE PRECISION DECL,RA,TRAD
      INTEGER TYEAR,TMONTH,TDAY,THOUR,TMINUTE,TSECOND,
     *        DURATION
      LOGICAL TRAJLOGIC
c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c All this lines are under test
c - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - 
*keep,certel.
      common /certel/  cormxd,cord,coralp,ctpars,omega,
     +                 photn,photnp,phpt,pht,vphot,
     +                 vchi,veta,vzeta,vchim,vetam,vzetam,
     +                 lambda,mu,nu,nctels,ncph,phip1,thetap1
      double precision cormxd,cord,coralp,ctpars(40,7),omega(20,3,3),
     +                 photn(3),photnp(3),phpt(3),pht,vphot(3),
     +                 vchi(3),veta(3),vzeta(3),vchim,vetam,vzetam,
     +                 lambda,mu,nu
      integer          nctels,ncph(5)
      double precision xg,yg,zg,xgp,ygp,zgp,up,vp,wp,xpcut,ypcut,zpcut
      double precision thetap1,phip1
      equivalence (photn(1) ,xg)   ,(photn(2) ,yg)   ,(photn(3) ,zg)  ,
     +            (photnp(1),xgp)  ,(photnp(2),ygp)  ,(photnp(3),zgp),
     +            (phpt(1)  ,xpcut),(phpt(2)  ,ypcut),(phpt(3)  ,zpcut),
     +            (vphot(1) ,up)   ,(vphot(2) ,vp)   ,(vphot(3) ,wp)    

      character *72 ctfile

      character *6  keyw
c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c     Angles for the "spinning" of a particle around the 
c     main axis of the CT
      common /spinang/ spinxi
      double precision spinxi
C>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
      integer m,nct
cxx----------------
c------changed-----add
       

       

       

       

      COMMON /CRQGSC/  LEVLDQ,IQGSVER,FQGS,FQGSSG
      INTEGER          LEVLDQ,IQGSVER
      LOGICAL          FQGS,FQGSSG

      DOUBLE PRECISION R1,R2
      INTEGER          I,IE,IOBSLV,IS,ISEQ,LENVAL,MMM,MONNEW,NUMERR

      INTEGER          NNTYP
      CHARACTER        LINE*132,TAB*1
      SAVE
C-----------------------------------------------------------------------

C  WRITE TITEL
      WRITE(MONIOU,999)
 999  FORMAT(' ',10('='),' USERS RUN DIRECTIVES FOR THIS SIMULATION ',
     *    27('=')/)
C  SET TABULATOR
      TAB = CHAR(9)

C  DEFAULT VALUES FOR ALL RUN PARAMETERS
      ISEQ = 0
      NSEQ = 1
      ISEED(1,1) = 1
      ISEED(2,1) = 0
      ISEED(3,1) = 0
      ISEED(1,2) = 2
      ISEED(2,2) = 0
      ISEED(3,2) = 0
      ISEED(1,3) = 3
      ISEED(2,3) = 0
      ISEED(3,3) = 0
      ISEED(1,4) = 4
      ISEED(2,4) = 0
      ISEED(3,4) = 0

      NRRUN     = 1
      ISHOWNO   = 0
      LLIMIT    = 1.D4
      ULIMIT    = 1.D4
      PSLOPE    = 0.D0

      PRMPAR(0) = 14.D0

      THETPR(1) = 0.D0
      THETPR(2) = 0.D0
      PHIPR(1)  = 0.D0
      PHIPR(2)  = 0.D0
      NSHOW     = 10
      IOBSLV    = 0
      NOBSLV    = 1

C  DEFAULT VALUE FOR KASCADE
      OBSLEV(1) = 110.D2

      MODATM    = 1
      LAYNEW    = .FALSE.

      ELCUT(1)  = 0.3D0
      ELCUT(2)  = 0.3D0
      ELCUT(3)  = 0.003D0
      ELCUT(4)  = 0.003D0

      ECTMAP  = 1.D4
      NFLAIN  = 0
      NFLDIF  = 0
      NFLPI0  = 0
      NFLPIF  = 0
      NFLCHE  = 0
      NFRAGM  = 2
      FNKG    = .TRUE.
      FMOLI   = .TRUE.
      FMUADD  = .FALSE.
      FEGS    = .FALSE.

      FPAROUT = .TRUE.
      FTABOUT = .FALSE.
      STEPFC  = 1.D0
      MAXPRT  = 10
      BX      = 20.40D0
      BZ      = 43.23D0
      ARRANG  = 0.D0
      LLONGI  = .FALSE.
      THSTEP  = 20.D0
      FLGFIT  = .FALSE.
      FLONGOUT= .FALSE.
      RADNKG  = 200.D2

      FDBASE  = .FALSE.
      DEBUG   = .FALSE.
      DEBDEL  = .FALSE.
      NDEBDL  = 100000000
      THICK0  = 0.D0
      FIX1I   = .FALSE.
      FIXHEI  = 0.D0
      DSN     = 'anynameupto64characters                               '

      TMARGIN = .TRUE.

      DSTLIM  = 1.D8    !1000 km

      HOST    = '                    '
      USER    = '                    '

      WAVLGL  = 300.D0
      WAVLGU  = 450.D0
      CERSIZ  = 0.D0
      NCERX   = 27
      NCERY   = 27
      DCERX   = 1500.D0
      DCERY   = 1500.D0
      ACERX   = 100.D0
      ACERY   = 100.D0
      LCERFI  = .TRUE.
      ICERML  = 1
      XSCATT  = 0.D0
      YSCATT  = 0.D0
      DO  I = 1, 20
        CERXOS(I) = 0.D0
        CERYOS(I) = 0.D0
      ENDDO

      IATMOX  = 0
      FREFRX  = .FALSE.
C  BORDER BETWEEN LOW AND HIGH ENERGY INTERACTION MODELS
C  SET BY DEFAULT TO ELAB = 80 GEV
      HILOELB = 80.D0

      GHEISH  = .FALSE.
      FFLUKA  = .TRUE.
      FFLUDB  = .FALSE.
      FQGS    = .TRUE.
      FQGSSG  = .TRUE.
      LEVLDQ  = 0
      PLOTSH  = .FALSE.
      VUECON(1) = 0.D0
      VUECON(2) = 0.D0
c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c-----changed trajectory---------------------------
C  LOGICAL FOR USE OF TRAJECTORY CALCULATION
      TRAJLOGIC = .FALSE.
C  SOURCE POSITION
      DECL = 22.D0
      RA = 5.57D0
C  START TIME OF OBSERVATION
      TYEAR = 2008
      TMONTH = 11
      TDAY = 22
      THOUR = 1
      TMINUTE = 0
      TSECOND = 0
C  DURATION OF OBSERVATION
      DURATION = 86400
c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>


C-----------------------------------------------------------------------
C  OPEN DATASET FOR COMMANDS

      IF ( MONIIN .NE. 5 ) THEN
        OPEN(UNIT=MONIIN,FILE='INPUTS',STATUS='OLD',FORM='FORMATTED')
        WRITE(MONIOU,*) 'DATA CARDS FOR RUN STEERING ARE ',
     *                  'EXPECTED FROM UNIT',MONIIN
      ELSE
        WRITE(MONIOU,*) 'DATA CARDS FOR RUN STEERING ARE ',
     *                  'EXPECTED FROM STANDARD INPUT'
      ENDIF

      NUMERR = 0
C-----------------------------------------------------------------------
 1    CONTINUE

C  ERASE 'LINE' BY FILLING WITH BLANKS
      LINE = ' '

C  GET A NEW INPUT LINE AND PRINT IT
      READ(MONIIN,500,END=1000) LINE
 500  FORMAT(A)
      DO  IE = LEN(LINE), 1, -1
        IF ( LINE(IE:IE) .NE. ' ' ) GOTO 11
      ENDDO
  11  CONTINUE
C  CHECK FOR HORIZONTAL TABS AND ELIMINATE THEM
      DO  I = 1, IE
        IF ( LINE(I:I) .EQ. TAB ) THEN
          LINE(I:I) = ' '
        ENDIF
      ENDDO
C  ECHO WRITE THE INPUT LINE
      IF ( DEBUG ) THEN
        WRITE(MDEBUG,501) LINE(1:IE)
 501    FORMAT(' DATAC : ',A)
      ELSE
        WRITE(MONIOU,502) LINE(1:IE)
 502    FORMAT(' ',A)
      ENDIF

C  CONVERT FIRST KEYWORD FROM LOWER CASE CHARACTERS TO UPPER CASE
      DO  I = 1,  LEN(LINE)
        IF ( LINE(I:I).EQ.'*' .OR. LINE(I:I).EQ.' ' ) GOTO 101
        CALL LOWUP( LINE(I:I) )
      ENDDO
C  EXCEPT FOR SPECIFIC KEYWORDS CONVERT ALSO THE REMAINING CHARACTERS
  101 IF (        LINE(1:4) .NE. 'HOST'
     *     .AND.  LINE(1:4) .NE. 'USER'
     *     .AND.  LINE(1:6) .NE. 'DIRECT'
     *     .AND.  LINE(1:6) .NE. 'HISTDS'
     *                                   ) THEN
        DO  I = 2, LEN(LINE)
          CALL LOWUP( LINE(I:I) )
        ENDDO
      ENDIF

C-----------------------------------------------------------------------
C  INTERPRET KEYWORD AND READ PARAMETERS
      IS = 0

C  DUMMY LINE (MAY BE USED FOR COMMENTS) NO ACTION
      IF     ( LINE(1:6) .EQ. '      ' ) THEN
      ELSEIF ( LINE(1:1) .EQ. '*'      ) THEN
      ELSEIF ( LINE(1:2) .EQ. 'C '     ) THEN

C  GET ANGLE (DEGREES) BETWEEN ARRAY X-DIRCTION AND MAGNETIC NORD
      ELSEIF ( LINE(1:6) .EQ. 'ARRANG' ) THEN
        CALL DTCDBL( LINE,IS,ARRANG,'ARRANG',1 )

C  READ ATMOSPHERIC PARAMETERS AATM(.,0)
      ELSEIF ( LINE(1:4) .EQ. 'ATMA' ) THEN
        CALL DTCDBL( LINE,IS,AATM0(1,0),'ATMA',1 )
        CALL DTCDBL( LINE,IS,AATM0(2,0),'ATMA',2 )
        CALL DTCDBL( LINE,IS,AATM0(3,0),'ATMA',3 )
        CALL DTCDBL( LINE,IS,AATM0(4,0),'ATMA',4 )
        AATM0(5,0) = .01128292D0
        IF ( MODATM .EQ. 10 ) THEN
          AATM0(1,10) = AATM0(1,0)
          AATM0(2,10) = AATM0(2,0)
          AATM0(3,10) = AATM0(3,0)
          AATM0(4,10) = AATM0(4,0)
          CALL DTCDBL( LINE,IS,AATM0(5,10),'ATMA',5 )
        ENDIF

C  READ ATMOSPHERIC PARAMETERS BATM(.,0)
      ELSEIF ( LINE(1:4) .EQ. 'ATMB' ) THEN
        CALL DTCDBL( LINE,IS,BATM0(1,0),'ATMB',1 )
        CALL DTCDBL( LINE,IS,BATM0(2,0),'ATMB',2 )
        CALL DTCDBL( LINE,IS,BATM0(3,0),'ATMB',3 )
        CALL DTCDBL( LINE,IS,BATM0(4,0),'ATMB',4 )
        BATM0(5,0) = 1.D0
        IF ( MODATM .EQ. 10 ) THEN
          BATM0(1,10) = BATM0(1,0)
          BATM0(2,10) = BATM0(2,0)
          BATM0(3,10) = BATM0(3,0)
          BATM0(4,10) = BATM0(4,0)
        ENDIF

C  READ ATMOSPHERIC PARAMETERS CATM(.,0)
      ELSEIF ( LINE(1:4) .EQ. 'ATMC' ) THEN
        CALL DTCDBL( LINE,IS,CATM0(1,0),'ATMC',1 )
        CALL DTCDBL( LINE,IS,CATM0(2,0),'ATMC',2 )
        CALL DTCDBL( LINE,IS,CATM0(3,0),'ATMC',3 )
        CALL DTCDBL( LINE,IS,CATM0(4,0),'ATMC',4 )
        CATM0(5,0) = 1.D9
        IF ( MODATM .EQ. 10 ) THEN
          CATM0(1,10) = CATM0(1,0)
          CATM0(2,10) = CATM0(2,0)
          CATM0(3,10) = CATM0(3,0)
          CATM0(4,10) = CATM0(4,0)
          CALL DTCDBL( LINE,IS,CATM0(5,10),'ATMC',5 )
        ENDIF

C  READ ATMOSPHERIC LAYER BOUNDARIES HLAY0(.,0)
      ELSEIF ( LINE(1:6) .EQ. 'ATMLAY' ) THEN
        CALL DTCDBL( LINE,IS,HLAY0(2,0),'ATMLAY',1 )
        CALL DTCDBL( LINE,IS,HLAY0(3,0),'ATMLAY',2 )
        CALL DTCDBL( LINE,IS,HLAY0(4,0),'ATMLAY',3 )
        CALL DTCDBL( LINE,IS,HLAY0(5,0),'ATMLAY',4 )
        HLAY0(1,0) = 0.D0
        LAYNEW = .TRUE.

C  GET INTERNAL ATMOSPHERIC MODEL NUMBER
      ELSEIF ( LINE(1:5) .EQ. 'ATMOD' ) THEN
        CALL DTCINT( LINE,IS,MODATM,'ATMOD',1 )

C  SET EXTERNAL ATMOSPHERIC MODEL (MOST USEFUL FOR CHERENKOV LIGHT)
C  AND DETERMINE IF ATMOSPHERIC REFRACTION SHOULD BE ACCOUNTED FOR.
      ELSEIF ( LINE(1:10) .EQ. 'ATMOSPHERE' ) THEN
        CALL DTCINT( LINE,IS,IATMOX,'ATMOSPHERE',1 )
        CALL DTCLOG( LINE,IS,FREFRX,'ATMOSPHERE',2 )

      ELSEIF ( LINE(1:6) .EQ. 'CDEBUG' ) THEN
        CALL DTCLOG( LINE,IS,LCERDB,'CDEBUG',1 )

C  GET CHERENKOV ARRAY SPECIFICATIONS
      ELSEIF ( LINE(1:6) .EQ. 'CERARY' ) THEN
        CALL DTCINT( LINE,IS,NCERX,'CERARY',1 )
        CALL DTCINT( LINE,IS,NCERY,'CERARY',2 )
        CALL DTCDBL( LINE,IS,DCERX,'CERARY',3 )
        CALL DTCDBL( LINE,IS,DCERY,'CERARY',4 )
        CALL DTCDBL( LINE,IS,ACERX,'CERARY',5 )
        CALL DTCDBL( LINE,IS,ACERY,'CERARY',6 )

C  GET CHERENKOV OUTPUT FLAG
      ELSEIF ( LINE(1:6) .EQ. 'CERFIL' ) THEN
        CALL DTCLOG( LINE,IS,LCERFI,'CERFIL',1 )

C  GET MAXIMUM BUNCH SIZE FOR CHERENKOV PHOTONS
      ELSEIF ( LINE(1:6) .EQ. 'CERSIZ' ) THEN
        CALL DTCDBL( LINE,IS,CERSIZ,'CERSIZ',1 )

C  GET CHERENKOV EVENT SCATTERING INFORMATION
      ELSEIF ( LINE(1:5) .EQ. 'CSCAT' ) THEN
        CALL DTCINT( LINE,IS,ICERML,'CSCAT',1 )
        CALL DTCDBL( LINE,IS,XSCATT,'CSCAT',2 )
        CALL DTCDBL( LINE,IS,YSCATT,'CSCAT',3 )

C  GET CHERENKOV WAVELENGTH BAND
      ELSEIF ( LINE(1:6) .EQ. 'CWAVLG' ) THEN
        CALL DTCDBL( LINE,IS,R1,'CWAVLG',1 )
        CALL DTCDBL( LINE,IS,R2,'CWAVLG',2 )
        WAVLGL = MIN( R1, R2 )
        WAVLGU = MAX( R1, R2 )

C  GET DATABASE FLAG
      ELSEIF ( LINE(1:6) .EQ. 'DATBAS' ) THEN
        CALL DTCLOG( LINE,IS,FDBASE,'DATBAS',1 )

C  GET DEBUG FLAG AND DELAYED DEBUG PARAMETERS
      ELSEIF ( LINE(1:5) .EQ. 'DEBUG' ) THEN
        CALL DTCLOG( LINE,IS,DEBUG,'DEBUG',1 )
        CALL DTCINT( LINE,IS,MMM,'DEBUG',2 )
        CALL DTCLOG( LINE,IS,DEBDEL,'DEBUG',3 )
        CALL DTCINT( LINE,IS,NDEBDL,'DEBUG',4 )
        IF ( MMM .LE. 0  .OR.  MMM .GT. 99 ) THEN
          MDEBUG = 6
        ELSE
          MDEBUG = MMM
        ENDIF

C  GET OUTPUT DIRECTORY FOR CALCULATIONS ON UNIX-STATION
      ELSEIF ( LINE(1:6) .EQ. 'DIRECT' ) THEN
        CALL DTCCHR( LINE,IS,DSN,'DIRECT',1,LENVAL )

C  GET ENERGY CUTS FOR PARTICLE PRINTOUT
      ELSEIF ( LINE(1:6) .EQ. 'ECTMAP' ) THEN
        CALL DTCDBL( LINE,IS,ECTMAP,'ECTMAP',1 )

C  GET ENERGY CUTS FOR HADRONS, MUONS, ELECTRONS, AND GAMMAS
      ELSEIF ( LINE(1:5) .EQ. 'ECUTS' ) THEN
        CALL DTCDBL( LINE,IS,ELCUT(1),'ECUTS',1 )
        CALL DTCDBL( LINE,IS,ELCUT(2),'ECUTS',2 )
        CALL DTCDBL( LINE,IS,ELCUT(3),'ECUTS',3 )
        CALL DTCDBL( LINE,IS,ELCUT(4),'ECUTS',4 )

C  GET COUNTER FOR START OF EGS DEBUGGUNG
      ELSEIF ( LINE(1:6) .EQ. 'EGSDEB' ) THEN
        CALL DTCINT( LINE,IS,JCLOCK,'EGSDEB',1 )

C  GET FLAGS FOR ELECTROMAGNETIC OPTIONS (NKG, EGS)
      ELSEIF ( LINE(1:6) .EQ. 'ELMFLG' ) THEN
        CALL DTCLOG( LINE,IS,FNKG,'ELMFLG',1 )
        CALL DTCLOG( LINE,IS,FEGS,'ELMFLG',2 )

C  GET ENERGY RANGE OF PRIMARY PARTICLE
      ELSEIF ( LINE(1:6) .EQ. 'ERANGE' ) THEN
        CALL DTCDBL( LINE,IS,LLIMIT,'ERANGE',1 )
        CALL DTCDBL( LINE,IS,ULIMIT,'ERANGE',2 )

c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c----changed trajectory---------------------------------------

C  GET LOGICAL FOR CALCUATION OF TRAJECTORY
      ELSEIF ( LINE(1:6) .EQ. 'TRAFLG' ) THEN
        CALL DTCLOG( LINE,IS,TRAJLOGIC,'TRAFLG',1 )

C  GET SOURCE POSITION
      ELSEIF ( LINE(1:6) .EQ. 'SRCPOS' ) THEN
        CALL DTCDBL( LINE,IS,RA,'SRCPOS',1 )
        CALL DTCDBL( LINE,IS,DECL,'SRCPOS',2 )

C  GET START TIME AND DURATION OF OBSERVATION
      ELSEIF ( LINE(1:5) .EQ. 'TRATM' ) THEN
        CALL DTCINT( LINE,IS,TYEAR,'TRATM',1 )
        CALL DTCINT( LINE,IS,TMONTH,'TRATM',2 )
        CALL DTCINT( LINE,IS,TDAY,'TRATM',3 )
        CALL DTCINT( LINE,IS,THOUR,'TRATM',4 )
        CALL DTCINT( LINE,IS,TMINUTE,'TRATM',5 )
        CALL DTCINT( LINE,IS,TSECOND,'TRATM',6 )
        CALL DTCINT( LINE,IS,DURATION,'TRATM',7 )


C  PRODUCE (BACKGROUND) EVENTS WITHIN RADIUS TRADIUS AROUND SOURCEPOS
      ELSEIF ( LINE(1:6) .EQ. 'TRARAD' ) THEN
        CALL DTCDBL( LINE,IS,TRAD,'TRARAD',1 )

c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

C  GET SLOPE OF ENERGY SPECTRUM OF PRIMARY PARTICLE
      ELSEIF ( LINE(1:6) .EQ. 'ESLOPE' ) THEN
        CALL DTCDBL( LINE,IS,PSLOPE,'ESLOPE',1 )

C  GET FIRST EVENT NUMBER
      ELSEIF ( LINE(1:5) .EQ. 'EVTNR' ) THEN
        CALL DTCINT( LINE,IS,ISHOWNO,'EVTNR',1 )
        ISHOWNO = MAX( 0, ISHOWNO-1 )
c-----changed-----add-----
c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  
c  get cerenkov file name with cts array specifications
      elseif ( LINE(1:6) .eq. 'CERTEL' ) then
        read(line(7:),'(I10)') nctels
        if(nctels.gt.40) then
           write(MONIOU,*)'Number of telescopes more them 40!!!'
           write(MONIOU,*)'change CERTEL in input card'
           stop 'BAD DATA CARDS'
        endif
cc        d2r = 3.1415926535897932385/180.0
        do 1967 nct=1,nctels
          read(moniin,*) (ctpars(nct,m),m=1,7)
          write(moniou,*) 'Telescope ',nct,(ctpars(nct,m),m=1,7)
 1967     continue
c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  
c-----changed-------add 

C  END OF DATA CARD INPUT
      ELSEIF ( LINE(1:4) .EQ. 'EXIT' ) THEN
        IF ( DEBUG ) THEN
          WRITE(MONIOU,*) 'DATAC : END OF DATACARD INPUT'
        ELSE
          WRITE(MONIOU,*)
          WRITE(MONIOU,*) 'END OF DATACARD INPUT'
        ENDIF
        GOTO 1001

C  GET FIXED HEIGHT (G/CM**2) OF PARTICLE START
      ELSEIF ( LINE(1:6) .EQ. 'FIXCHI' ) THEN
        CALL DTCDBL( LINE,IS,THICK0,'FIXCHI',1 )

C  GET FIXED HEIGHT OF FIRST INTERACTION AND FIRST TARGET
      ELSEIF ( LINE(1:6) .EQ. 'FIXHEI' ) THEN
        CALL DTCDBL( LINE,IS,FIXHEI,'FIXHEI',1 )
        CALL DTCINT( LINE,IS,N1STTR,'FIXHEI',2 )
        IF ( FIXHEI .GT. 0. ) FIX1I = .TRUE.

C  GET FLAG FOR FLUKA WRITE OUT
      ELSEIF ( LINE(1:6) .EQ. 'FLUDBG' ) THEN
        CALL DTCLOG( LINE,IS,FFLUDB,'FLUDBG',1 )

C  GET FLAGS FOR HADRON INTERACTION OPTIONS
      ELSEIF ( LINE(1:6) .EQ. 'HADFLG' ) THEN
        CALL DTCINT( LINE,IS,NFLAIN,'HADFLG',1 )
        CALL DTCINT( LINE,IS,NFLDIF,'HADFLG',2 )
        CALL DTCINT( LINE,IS,NFLPI0,'HADFLG',3 )
        CALL DTCINT( LINE,IS,NFLPIF,'HADFLG',4 )
        CALL DTCINT( LINE,IS,NFLCHE,'HADFLG',5 )
        CALL DTCINT( LINE,IS,NFRAGM,'HADFLG',6 )

C  GET TRANSITION ENERGY BETWEEN INTERACTION MODELS
      ELSEIF ( LINE(1:5) .EQ. 'HILOW' ) THEN
        CALL DTCDBL( LINE,IS,HILOELB,'HILOW',1 )

C  GET NAME OF HOST COMPUTER
      ELSEIF ( LINE(1:4) .EQ. 'HOST' ) THEN
        CALL DTCCHR( LINE,IS,HOST,'HOST',1,LENVAL )

C  GET PARAMETER FOR LONGITUDINAL DEVELOPMENT
      ELSEIF ( LINE(1:5) .EQ. 'LONGI' ) THEN
        CALL DTCLOG( LINE,IS,LLONGI,'LONGI',1 )
        CALL DTCDBL( LINE,IS,THSTEP,'LONGI',2 )
        CALL DTCLOG( LINE,IS,FLGFIT,'LONGI',3 )
        CALL DTCLOG( LINE,IS,FLONGOUT,'LONGI',4 )

C  GET PARAMETERS OF MAGNETIC FIELD
      ELSEIF ( LINE(1:6) .EQ. 'MAGNET' ) THEN
        CALL DTCDBL( LINE,IS,BX,'MAGNET',1 )
        CALL DTCDBL( LINE,IS,BZ,'MAGNET',2 )

C  GET NUMBER OF EVENTS TO BE PRINTED
      ELSEIF ( LINE(1:6) .EQ. 'MAXPRT' ) THEN
        CALL DTCINT( LINE,IS,MAXPRT,'MAXPRT',1 )
        IF ( MAXPRT .LT. 0 ) MAXPRT = 10

C  GET FLAG FOR ADDITIONAL MUON INFORMATION ON MPATAP
      ELSEIF ( LINE(1:6) .EQ. 'MUADDI' ) THEN
        CALL DTCLOG( LINE,IS,FMUADD,'MUADDI',1 )

C  GET FLAG FOR MUON MULTIPLE SCATTERING (T=MOLIERE, F=GAUSS)
      ELSEIF ( LINE(1:6) .EQ. 'MUMULT' ) THEN
        CALL DTCLOG( LINE,IS,FMOLI,'MUMULT',1 )

C  GET NUMBER OF SHOWERS TO BE PRODUCED
      ELSEIF ( LINE(1:5) .EQ. 'NSHOW' ) THEN
        CALL DTCINT( LINE,IS,NSHOW,'NSHOW',1 )
        IF ( NSHOW .LE. 0 ) NSHOW = 1

C  GET HEIGHT OF OBSERVATION LEVELS
      ELSEIF ( LINE(1:6) .EQ. 'OBSLEV' ) THEN
        IOBSLV = IOBSLV + 1

        IF ( IOBSLV .LE. 1 ) THEN
          CALL DTCDBL( LINE,IS,OBSLEV(IOBSLV),'OBSLEV',1 )
          NOBSLV = IOBSLV
        ELSE

          WRITE(MONIOU,*) 'DATAC : ONLY ONE OBSERVATION LEVEL ,',
     *                    'POSSIBLE IN CURVED VERSION'

          STOP
        ENDIF

C  GET NEW MONITOR OUTPUT UNIT
      ELSEIF ( LINE(1:6) .EQ. 'OUTPUT' ) THEN
        CALL DTCINT( LINE,IS,MONNEW,'OUTPUT',1 )
        WRITE(MONIOU,593) MONIOU,MONNEW
 593    FORMAT(' ATTENTION'/' ========='/
     *         ' LOGFILE OUTPUT REDIRECTED FROM UNIT ',I3,
     *         ' TO UNIT ',I3)
        MONIOU = MONNEW

C  GET FLAGS FOR PARTICLE AND TABLE OUTPUT
      ELSEIF ( LINE(1:6) .EQ. 'PAROUT' ) THEN
        CALL DTCLOG( LINE,IS,FPAROUT,'PAROUT',1 )
        CALL DTCLOG( LINE,IS,FTABOUT,'PAROUT',2 )

C  GET PHI OF PRIMARY PARTICLE
      ELSEIF ( LINE(1:4) .EQ. 'PHIP' ) THEN
        CALL DTCDBL( LINE,IS,R1,'PHIP',1 )
        CALL DTCDBL( LINE,IS,R2,'PHIP',2 )
        PHIPR(1) = MIN( R1, R2 )
        PHIPR(2) = MAX( R1, R2 )

C  GET TYPE OF PRIMARY PARTICLE
      ELSEIF ( LINE(1:6) .EQ. 'PLOTSH' ) THEN
        CALL DTCLOG( LINE,IS,PLOTSH,'PLOTSH',1 )

C  GET TYPE OF PRIMARY PARTICLE
      ELSEIF ( LINE(1:6) .EQ. 'PRMPAR' ) THEN
        CALL DTCINT( LINE,IS,NNTYP,'PRMPAR',1 )
        PRMPAR(0) = NNTYP

C  GET FLAG FOR QGSJET HIGH ENERGY HADRONIC INTERACTION MODEL
      ELSEIF ( LINE(1:6) .EQ. 'QGSJET' ) THEN
        CALL DTCLOG( LINE,IS,FQGS,'QGSJET',1 )
        CALL DTCINT( LINE,IS,LEVLDQ,'QGSJET',2 )
        LEVLDQ = MAX( 0, LEVLDQ )

C  GET CROSS-SECTION FLAG FOR QGSJET HADRONIC INTERACTION MODEL
      ELSEIF ( LINE(1:6) .EQ. 'QGSSIG' ) THEN
        CALL DTCLOG( LINE,IS,FQGSSG,'QGSSIG',1 )

C  GET WIDTH OF NKG LATERAL DISTRIBUTION
      ELSEIF ( LINE(1:6) .EQ. 'RADNKG' ) THEN
        CALL DTCDBL( LINE,IS,RADNKG,'RADNKG',1 )

C  GET RUN NUMBER
      ELSEIF ( LINE(1:5) .EQ. 'RUNNR' ) THEN
        CALL DTCINT( LINE,IS,NRRUN,'RUNNR',1 )
        NRRUN = ABS(NRRUN)

C  GET SEEDS OF RANDOM NUMBER SEQUENCES
      ELSEIF ( LINE(1:4) .EQ. 'SEED' ) THEN
        ISEQ = ISEQ + 1
        IF ( ISEQ .LE. KSEQ ) THEN
          CALL DTCINT( LINE,IS,ISEED(1,ISEQ),'SEED',1 )
          CALL DTCINT( LINE,IS,ISEED(2,ISEQ),'SEED',2 )
          CALL DTCINT( LINE,IS,ISEED(3,ISEQ),'SEED',3 )
          NSEQ = ISEQ
        ELSE
          WRITE(MONIOU,*) 'DATAC : TOO MANY RANDOM GENERATOR SEEDS,',
     *                    ' IGNORE IT'
        ENDIF

C  GET FACTOR FOR ELECTRON''S MULTIPLE SCATTERING LENGTH
      ELSEIF ( LINE(1:6) .EQ. 'STEPFC' ) THEN
        CALL DTCDBL( LINE,IS,STEPFC,'STEPFC',1 )

C  GET THETA OF PRIMARY PARTICLE
      ELSEIF ( LINE(1:6) .EQ. 'THETAP' ) THEN
        CALL DTCDBL( LINE,IS,R1,'THETAP',1 )
        CALL DTCDBL( LINE,IS,R2,'THETAP',2 )
        THETPR(1) = MIN( R1, R2 )
        THETPR(2) = MAX( R1, R2 )

C  GET DISTANCE FOR TIME LIMIT FOR DISCARDING PARTICLES
C  DSTLIM IS MAXIMUM DISTANCE FROM DETERCTOR DOWNSTREAM TO 
C  LIMIT (IN CM) 
      ELSEIF ( LINE(1:6) .EQ. 'TIMLIM' ) THEN
        CALL DTCDBL( LINE,IS,DSTLIM,'TIMLIM',1 )
        DSTLIM = ABS( DSTLIM )

C  GET NAME OF USER
      ELSEIF ( LINE(1:4) .EQ. 'USER' ) THEN
        CALL DTCCHR( LINE,IS,USER,'USER',1,LENVAL )

C  GET CIRCULAR ANGLE RANGE FROM (FIXED) THETA AND PHI DIRECTION
C  WHERE SIMULATED SHOWER DIRECTION SHOULD BE.
      ELSEIF (LINE(1:8) .EQ. 'VIEWCONE' ) THEN
        CALL DTCDBL( LINE,IS,R1,'VIEWCONE',1 )
        CALL DTCDBL( LINE,IS,R2,'VIEWCONE',2 )
        VUECON(1) = MIN( R1, R2 )
        VUECON(2) = MAX( R1, R2 )

C  ILLEGAL KEYWORD
      ELSE
        IE = INDEX(LINE,' ')
        IF ( IE .LE. 0 ) IE = LEN(LINE)+1
        WRITE(MONIOU,*) 'DATAC : UNKNOWN KEYWORD : ',LINE(1:IE-1)
        NUMERR = NUMERR + 1
      ENDIF

      IF ( LINE(1:1) .EQ. '!' ) NUMERR = NUMERR + 1

      GOTO 1

C-----------------------------------------------------------------------
 1000 CONTINUE
      IF ( DEBUG ) THEN
        WRITE(MDEBUG,*) 'DATAC : NO MORE DIRECTIVES FOUND'
      ELSE
        WRITE(MONIOU,*) '*** NO MORE DIRECTIVES FOUND ***'
      ENDIF

 1001 IF ( NUMERR .GT. 0 ) THEN
        WRITE(MONIOU,9000) NUMERR
 9000   FORMAT(1X,I3,' SYNTAX ERROR(S) IN INPUT DATA CARDS.')
        STOP 'BAD DATA CARDS'
      ENDIF

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   25/06/2003
C=======================================================================

      DOUBLE PRECISION FUNCTION DBRELM( JJMAT )

C-----------------------------------------------------------------------
C  D(OUBLE PRECISION) BR(EMSSTRAHLUNG) E(NERGY) L(OSS) M(UONS)
C
C  FUNCTION TO CALCULATE THE MUON BREMSSTRAHLUNG ENERGY LOSS.
C  SEE: S. BOTTAI AND L. PERRONE, NUCL. INST. METH. A459 (2001) 319
C       BILOKON ET AL., NUCL. INSTR. METH. A303 (1991) 381
C       LOHMANN, KOPP, VOSS, YELLOW REPORT FROM CERN 85-03
C  THIS FUNCTION IS CALLED FROM MUPINI.
C  ARGUMENT:
C   JJMAT  = MATERIAL INDEX (1 = 14N, 2 = 16O, 3 = 40AR)
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRAIR/   COMPOS,PROBTA,AVERAW,AVOGDR
      DOUBLE PRECISION COMPOS(3),PROBTA(3),AVERAW,AVOGDR

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      INTEGER          IWK,MAXPTS,MINCAL,MINPTS,N
      PARAMETER        (IWK    = 1000000)
      PARAMETER        (MAXPTS = 100000)
      PARAMETER        (MINCAL = 1)
      PARAMETER        (MINPTS = 10)
      PARAMETER        (N      = 2)
      DOUBLE PRECISION EPSBS
      PARAMETER        (EPSBS  = 1.D-6)

      DOUBLE PRECISION AA(2),B(2),WK(IWK)
      DOUBLE PRECISION ECMIN,ECMAX,RELERR,RESULT,XLOW,XLOW0,XUPP
      INTEGER          IFAIL,JJMAT,NFNEVL
      DOUBLE PRECISION VBSE
      EXTERNAL         VBSE
      SAVE
      DATA             XLOW0 / 1.D-15 /
C-----------------------------------------------------------------------

      DBRELM = 0.D0
C  EE IS THE TOTAL ENERGY OF INCOMING MUON
      ECMIN  = 0.D0
      ECMAX  = EE - CONSTKINE
      XLOW   = XLOW0
      XUPP   = BCUT/EE
      IF ( ECMIN .GE. BCUT ) RETURN
      IF ( ECMAX .LT. BCUT ) XUPP = ECMAX/EE
      IF ( XUPP .LE. XLOW  ) RETURN

C  DADMUL INTEGRATION
      AA(1) = 0.D0
      AA(2) = XLOW
      B(1)  = 1.D0
      B(2)  = XUPP
      CALL DADMUL( VBSE,N,AA,B,MINPTS,MAXPTS
     *                      ,EPSBS,WK,IWK,RESULT,RELERR,NFNEVL,IFAIL )
      IF ( IFAIL .NE. 0 ) THEN
        WRITE(MONIOU,*) 'DBRELM: IFAIL=',IFAIL,' E=',EE,' JJMAT=',JJMAT
        STOP
      ENDIF
C  NORMALIZE TO GET ENERGY LOSS IN GEV * G**-1 * CM**2
      DBRELM = AVOGDR * RESULT * 1.D27 * EE / AATOM

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   12/05/2003
C=======================================================================

      DOUBLE PRECISION FUNCTION DBRSGM( JJMAT )

C-----------------------------------------------------------------------
C  D(OUBLE PRECISION) BR(EMSSTRAHLUNG) S(I)GM(A FOR MUONS)
C
C  FUNCTION TO CALCULATE THE MUON BREMSSTRAHLUNG CROSS-SECTIONS.
C  SEE: S. BOTTAI AND L. PERRONE, NUCL. INST. METH. A459 (2001) 319
C       BILOKON ET AL., NUCL. INSTR. METH. A303 (1991) 381
C       LOHMANN, KOPP, VOSS, YELLOW REPORT FROM CERN 85-03
C  THIS FUNCTION IS CALLED FROM MUPINI.
C  ARGUMENT:
C   JJMAT  = MATERIAL INDEX (1 = 14N, 2 = 16O, 3 = 40AR)
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      INTEGER          IWK,MAXPTS,MINCAL,MINPTS,N
      PARAMETER        (IWK    = 1000000)
      PARAMETER        (MAXPTS = 100000)
      PARAMETER        (MINCAL = 1)
      PARAMETER        (MINPTS = 10)
      PARAMETER        (N      = 2)
      DOUBLE PRECISION EPSBS
      PARAMETER        (EPSBS  = 1.D-6)

      DOUBLE PRECISION AA(2),B(2),WK(IWK)
      DOUBLE PRECISION ECMIN,ECMAX,RELERR,RESULT,XLOW,XLOW0,XUPP
      INTEGER          IFAIL,JJMAT,NFNEVL
      DOUBLE PRECISION VBSS
      EXTERNAL         VBSS
      SAVE
      DATA             XLOW0 / 1.D-15 /
C-----------------------------------------------------------------------

      DBRSGM = 0.D0
C  EE IS THE TOTAL ENERGY OF INCOMING MUON
      IF ( EE-PAMA(5) .LT. BCUT ) RETURN

      ECMIN = 0.D0
      ECMAX = EE - CONSTKINE
      XLOW  = BCUT / EE
      XUPP  = ECMAX / EE
      IF ( ECMAX .LT. BCUT ) RETURN
      IF ( ECMIN .GT. BCUT ) XLOW = ECMIN/EE
      IF ( XLOW .LE. XLOW0 ) XLOW = XLOW0
      IF ( XUPP .LE. XLOW  ) RETURN

C  DADMUL INTEGRATION
      AA(1) = 0.D0
      AA(2) = XLOW
      B(1)  = 1.D0
      B(2)  = XUPP
      CALL DADMUL( VBSS,N,AA,B,MINPTS,MAXPTS
     *                      ,EPSBS,WK,IWK,RESULT,RELERR,NFNEVL,IFAIL )
      IF ( IFAIL .NE. 0 ) THEN
        WRITE(MONIOU,*) 'DBRSGM: IFAIL=',IFAIL,' E=',EE,' JJMAT=',JJMAT
        STOP
      ENDIF
C  CONVERT FROM CM**2  TO MILLIBARN
      DBRSGM = RESULT * 1.D27

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE DECAY1( M0,M3,M4 )

C-----------------------------------------------------------------------
C  DECAY (INTO TWO PARTICLES)
C
C  TWO PARTICLE DECAY WITH FULL KINEMATIC; ENERGY AND MOMENTA CONSERVED
C  THIS SUBROUTINE IS CALLED FROM KDECAY, RESDEC, AND STRDEC.
C  ARGUMENTS:
C   M0     = TYPE OF DECAYING PARTICLE
C   M3     = TYPE OF FIRST PRODUCT PARTICLE (HADRON)
C   M4     = TYPE OF SECOND PRODUCT PARTICLE (HADRON OR GAMMA, NEUTRINO)
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION AUX1,AUX2,AUX2A,AUX3,AUX4,COSTCM,COSTH3,COSTH4,
     *                 GAMMA3,GAMMA4,PHI4,WORK1,WORK2
      INTEGER          I,M0,M3,M4

      SAVE
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) BETA,M0,M3,M4
  444 FORMAT(' DECAY1: BETA,M0,M3,M4=',1P,E10.3,3I5)

C  PARTICLE COORDINATES 5..10 ARE COPIED INTO SECPAR IN CALLING PROGRAM
C  CALCULATE AUXILIARY QUANTITIES
      AUX1   = ( ( PAMA(M0)**2 + PAMA(M3)**2 - PAMA(M4)**2 )
     *            / (2.D0*PAMA(M0)) )**2  - PAMA(M3)**2
      AUX2   = 1.D0 + AUX1 / PAMA(M3)**2
      AUX2A  = SQRT( AUX2 )
      AUX3   = SQRT( 1.D0 - 1.D0 / AUX2 )

      WORK1  = GAMMA * AUX2A
      WORK2  = AUX3 * BETA * WORK1

C  DETERMINE POLAR ANGLE IN CM SYSTEM
      CALL RMMARD( RD,2,1 )
      COSTCM = 2.D0 * RD(1) - 1.D0
      GAMMA3 = WORK1 + WORK2 * COSTCM
C  SECOND PRODUCT PARTICLE WITH NONVANISHING REST MASS
      IF ( PAMA(M4) .NE. 0.D0 ) THEN
        GAMMA4 = (PAMA(M0)*GAMMA - PAMA(M3)*GAMMA3) / PAMA(M4)
        AUX4   = (PAMA(M0)**2 + PAMA(M4)**2 - PAMA(M3)**2 )
     *            / (2.D0*PAMA(M0)*PAMA(M4))
        COSTH4 = MIN( 1.D0, (GAMMA*GAMMA4 - AUX4) /
     *           (BETA * GAMMA * SQRT( (GAMMA4-1.D0)*(GAMMA4+1.D0) )) )
      ELSE
C  SECOND PRODUCT PARTICLE IS GAMMA; THEN GAMMA4 IS THE ENERGY
        GAMMA4 = PAMA(M0)*GAMMA - PAMA(M3)*GAMMA3
        COSTH4 = MIN( 1.D0, (BETA - COSTCM)/(1.D0 - BETA*COSTCM) )
      ENDIF
      PHI4   = RD(2) * PI2
      CALL ADDANG3( COSTHE,PHIX,PHIY, COSTH4,PHI4,
     *                                 SECPAR(2),SECPAR(3),SECPAR(4) )

      IF ( SECPAR(2) .GT. C(29) ) THEN

        SECPAR(0) = M4
        SECPAR(1) = GAMMA4
        IF ( DEBUG ) WRITE(MDEBUG,445) (SECPAR(I),I=0,9)
  445   FORMAT(' DECAY1: SECPAR=',1P,9E11.3,0P,F10.0)

        CALL TSTACK
      ELSE
        IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT
          IF ( M4 .EQ. 1 ) THEN

            DLONG(LHEIGH,11) = DLONG(LHEIGH,11) + GAMMA4
          ELSE
            DLONG(LHEIGH,17) = DLONG(LHEIGH,17) + GAMMA4 * PAMA(M4)
     *                                          - RESTMS(M4)

          ENDIF
        ENDIF
      ENDIF
C  FIRST PRODUCT PARTICLE WITH OPPOSITE AZIMUTHAL DIRECTION
      COSTH3 = MIN( 1.D0, (GAMMA * GAMMA3 - AUX2A)
     *          / (BETA * GAMMA * SQRT( (GAMMA3-1.D0)*(GAMMA3+1.D0)) ))
      CALL ADDANG3( COSTHE,PHIX,PHIY, COSTH3,PHI4+PI,
     *                                  SECPAR(2),SECPAR(3),SECPAR(4) )

      IF ( SECPAR(2) .GT. C(29) ) THEN

        SECPAR(0) = M3
        SECPAR(1) = GAMMA3

        IF ( DEBUG ) WRITE(MDEBUG,445) (SECPAR(I),I=0,9)
        CALL TSTACK
      ELSE
        IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

          DLONG(LHEIGH,17) = DLONG(LHEIGH,17) + GAMMA3 * PAMA(M3)
     *                                          - RESTMS(M3)

        ENDIF
      ENDIF

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE DECAY6(AM0,AM3,AM4,AM5,PARAMA,PARAMB,PARAMC,AMPMX,MODE)

C-----------------------------------------------------------------------
C  DECAY (INTO 3 PARTICLES)
C
C  TREATES DECAY INTO 3 PARTICLES; FULLY CONSERVING ENERGY AND MOMENTA
C  KINEMATIC RANGE PARAMETRISATION SEE PHYS. LETT. 204B (1988) 90-91
C  FOR LEPTONIC KAON DACAY: THE POLARIZATION OF THE MUON AND
C  THE NEUTRINO PRODUCTION IS INCLUDED.
C  THIS SUBROUTINE IS CALLED FROM ETADEC, KDECAY, PI0DEC, AND RESDEC.
C  ARGUMENTS:
C   AM0    = MASS OF DECAYING PARTICLE
C   AM3, AM4, AM5 = MASSES OF RESULTING PARTICLES
C   PARAMA = DALITZ AMPLITUDE PARAMETER (SEE BELOW)
C   PARAMB = DALITZ AMPLITUDE PARAMETER (SEE BELOW)
C   PARAMC = DALITZ AMPLITUDE PARAMETER (SEE BELOW)
C   AMPMX  = MAXIMUM AMPLITUDE OF DALITZ PLOT
C   MODE   = 1  FOR DECAY KAON  ----> 3 PIONS
C          = 2  FOR DECAY ETA   ----> 3 PIONS OR 2 PIONS + GAMMA
C               FOR DECAY PI(0) ----> ELECTRON + POSITRON + GAMMA
C          = 3  FOR DECAY KAON  ----> PION + MUON + NEUTRINO
C          = 4  FOR DECAY KAON  ----> PION + ELECTRON + NEUTRINO
C
C  AMPLITUDE PARAMETERS PARAMA, PARAMB, PARAMC ARE DEPENDENT ON MODE:
C  FOR MODE=1: PARAMA = G      DALITZ AMPLITUDE PARAMETRISATION SEE
C              PARAMB = H      PHYS. LETT. 204B (1988) 181 - 193
C              PARAMC = K
C
C  FOR MODE=2: PARAMA = A      DALITZ AMPLITUDE PARAMETRISATION SEE
C              PARAMB = DUMMY  PHYS. LETT. 204B (1988) 173 - 175;
C              PARAMC = DUMMY  J.G. LAYTER ET.AL. PHYS.REV.D7(1973)2565
C
C  FOR MODE>2: PARAMA = LAMBDA-PLUS    DALITZ AMPLITUDE PARAMETRISATION
C              PARAMB = LAMBDA-ZERO    SEE PHYS. LETT. 204B (1988)
C              PARAMC = DUMMY          182 - 194
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRDECAYC/GAM345,COS345,PHI345
      DOUBLE PRECISION GAM345(3),COS345(3),PHI345(3)

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRPOLAR/ POLART,POLARF
      DOUBLE PRECISION POLART,POLARF

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION ABYM,AMPLI,AMPMX,AM0,AM3,AM34I,AM34SQ,AM35SQ,
     *                 AM4,AM5,APARAL,APERPN,AUXA,AUXB,AUX1,AUX2,AUX2A,
     *                 AUX3,AUX4,AUX4A,AUX5,AUX6,AUX7,AUX8,AUX10,AUX12,
     *                 AUX14,BBYM,BOFQ,CM0SQ,CM3SQ,CM3SQI,CM4SQ,CM5SQ,
     *                 COSALF,COSBET,COSFI4,COSFI5,COSOME,COSPHI,
     *                 COSPSI,COS3CM,COS4CM,COS5CM,
     *                 DISCR,EPIPRM,E3CM,E3STAR,E4CM,E5CM,E5STAR,FACT,
     *                 GRLAMD,OMEGA,PA,PARAMA,PARAMB,PARAMC,PB,PC,PSI,
     *                 P3CM,P3SQ,P4CM,P4SQ,P5CM,P5SQ,ROOT1,ROOT2,
     *                 SINALF,SINBET,SINFI4,SINFI5,SINOMG,SINPHI,SINPSI,
     *                 SINT4,SINT4I,SINT5I,SIN3CM,S0,TBYMSS,XIT,XI0
      INTEGER          MODE
      SAVE
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) AM0,AM3,AM4,AM5
  444 FORMAT(' DECAY6: AM0',1P,E10.3,' AM3',E10.3,' AM4',E10.3,
     *       ' AM5',E10.3)

C  CALCULATE AUXILIARY QUANTITIES
      CM0SQ = AM0**2
      CM3SQ = AM3**2
      CM4SQ = AM4**2
      CM5SQ = AM5**2
      AUX1  = (AM3 + AM4)**2
      AUX2A = (AM0 - AM5)**2
      AUX2  = AUX2A - AUX1
      AUX3  = (AM3 + AM5)**2
      AUX4A = (AM0 - AM4)**2
      AUX4  = AUX4A - AUX3
      AUX5  = CM3SQ - CM4SQ
      AUX6  = CM0SQ - CM5SQ
      AUX7  = 0.5D0 / AM0
      IF     ( MODE .EQ. 1 ) THEN
        AUX8   = (AM0 - AM3)**2
        S0     = OB3 * ( CM0SQ + CM3SQ + CM4SQ + CM5SQ )
        AUX10  = 1.D0 / PAMA(8)**2
      ELSEIF ( MODE .EQ. 2 ) THEN
        AUX14  = 1.D0 / (AM0 - AM3 - AM4 - AM5)
      ELSEIF ( MODE .EQ. 3  .OR.  MODE .EQ. 4 ) THEN
        CM3SQI = 1.D0 / CM3SQ
        AUX12  = (CM0SQ + CM3SQ - CM4SQ) * AUX7
C  XI0 IS XI(0); GRLAMD IS GREAT LAMBDA
        XI0    = ( CM0SQ - CM3SQ) * CM3SQI * (PARAMB - PARAMA)
        GRLAMD = (-XI0) * PARAMA
      ELSE
        WRITE(MONIOU,*) 'DECAY6: UNEXPECTED MODE =',MODE
        RETURN
      ENDIF

 100  CALL RMMARD( RD,3,1 )
C  ARE INVARIANT MASS SQUARES INSIDE BOUNDARY OF DALITZ PLOT?
      AM34SQ = AUX2 * RD(1) + AUX1
      AM35SQ = AUX4 * RD(2) + AUX3
      AM34I  = 0.5D0 / SQRT( AM34SQ )
      E3STAR = (AUX5 + AM34SQ) * AM34I
      E5STAR = (AUX6 - AM34SQ) * AM34I
      ROOT1  = SQRT( E3STAR**2 - CM3SQ )
      ROOT2  = SQRT( E5STAR**2 - CM5SQ )
      DISCR  = AM35SQ - (E3STAR + E5STAR)**2
C  REJECT RANDOM NUMBERS, IF OUTSIDE KINEMATIC BOUNDARY OF DALITZ PLOT
      IF ( DISCR .GT. -((ROOT1 - ROOT2)**2) ) GOTO 100
      IF ( DISCR .LT. -((ROOT1 + ROOT2)**2) ) GOTO 100
C  E3CM, E4CM, E5CM ARE ENERGIES IN THE C. M. SYSTEM
      E4CM   = (CM0SQ + CM4SQ - AM35SQ) * AUX7
      E5CM   = (CM0SQ + CM5SQ - AM34SQ) * AUX7
      E3CM   = AM0 - E4CM - E5CM

      IF     ( MODE .EQ. 1 ) THEN
        FACT  = AUX10 * (AUX2A - 2.D0*AM0*(E5CM-AM5) - S0)
C  AMPLITUDE OF SQUARED MATRIX ELEMENT (SEE PHYS. LETT. B204 (1988) 181)
        AMPLI = 1.D0 + PARAMA*FACT + PARAMB*FACT**2 + PARAMC*( AUX10
     *           * ( AUX4A -AUX8 -2.D0*(E4CM-AM4-E3CM+AM3)*AM0 ) )**2

      ELSEIF ( MODE .EQ. 2 ) THEN
C  AMPLITUDE OF SQUARED MATRIX ELEMENT (SEE PHYS. LETT. B204 (1988) 173)
C  REF: J. G. LAYTER ET AL., PHYS. REV. D7 (1973) 2565
        AMPLI = 1.D0 + PARAMA * ( 3.D0 * (E5CM - AM5) * AUX14 - 1.D0 )

      ELSE
C  EPIPRM IS (ENERGY OF PION)PRIMED
        EPIPRM = AUX12 - E3CM
C  PA, PB, AND PC ARE THE A, B, AND C PARAMETERS
        PA     = AM0 * ( 2.D0 * E4CM * E5CM - AM0 * EPIPRM )
     *            + CM4SQ * ( 0.25D0 * EPIPRM - E5CM )
        PB     = CM4SQ * ( E5CM - 0.5D0 * EPIPRM )
        PC     = CM4SQ * EPIPRM * 0.25D0
C  TBYMSS IS T DIVIDED BY MASS SQUARE OF PION
        TBYMSS = (CM0SQ + CM3SQ - 2.D0 * AM0 * E3CM) * CM3SQI
C  XIT IS XI(T)
        XIT   = XI0 + GRLAMD*TBYMSS
C  AMPLITUDE OF SQUARED MATRIX ELEMENT (PHYS. LETT. B204 (1988) 183)
        AMPLI = (1.D0 + PARAMA*TBYMSS)**2 * ( PA + XIT*PB + XIT**2 *PC )
      ENDIF

C  REJECT RANDOM NUMBERS, IF RD(3) IS LARGER THAN DALITZ PLOT AMPLITUDE
      IF ( RD(3)*AMPMX .GT. AMPLI ) GOTO 100

      IF ( DEBUG ) WRITE(MDEBUG,*) 'DECAY6: E3CM,E4CM,E5CM=',
     *                     SNGL(E3CM),SNGL(E4CM),SNGL(E5CM)
C  P3CM, P4CM, P5CM ARE MOMENTA IN THE C.M. SYSTEM
C  P3SQ, P4SQ, P5SQ ARE SQUARED MOMENTA IN C.M. SYSTEM
      P5SQ   = E5CM**2 - CM5SQ
      P5CM   = SQRT( P5SQ )
      P4SQ   = E4CM**2 - CM4SQ
      P4CM   = SQRT( P4SQ )
      P3SQ   = E3CM**2 - CM3SQ
      P3CM   = SQRT( P3SQ )
C  ANGLE ALFA AND BETA ARE BETWEEN PARTICLE 3 AND 4 RSP. 3 AND 5
      COSALF = (P5SQ - P3SQ - P4SQ) / (2.D0 * P3CM * P4CM)
      SINALF = -SQRT( MAX( 0.D0, (1.D0 - COSALF)*(1.D0 + COSALF)) )
      COSBET = (P4SQ - P3SQ - P5SQ) / (2.D0 * P3CM * P5CM)
      SINBET = SQRT( MAX( 0.D0, (1.D0 - COSBET)*(1.D0 + COSBET)) )
C  NOW SELECT RANDOM NUMBERS FOR THREE INDEPENDENT ANGLES IN CM-SYSTEM
C  COS3CM AND PHI ARE ANGLES OF PARTICLE 3 RELATIVE TO DECAYING PARTICLE
      CALL RMMARD( RD,3,1 )
      COS3CM = 2.D0*RD(1) - 1.D0
      SIN3CM = SQRT( MAX( 0.D0, (1.D0 - COS3CM)*(1.D0 + COS3CM)) )
      PHI345(1) = PI2 * RD(2)
      COSPHI = COS( PHI345(1) )
      SINPHI = SIN( PHI345(1) )
C  ANGLE PSI GIVES ROTATION OF PLANE (3,4,5) RELATIVE TO PLANE (1,3)
      PSI    = PI2 * RD(3)
      COSPSI = COS( PSI )
      SINPSI = SIN( PSI )
C  CALCULATE ALL NEEDED POLAR AND AZIMUTHAL ANGLES IN THE CM-SYSTEM
      COS4CM = COS3CM * COSALF - SIN3CM * COSPSI * SINALF
      IF ( ABS(COS4CM) .LT. 1.D0 ) THEN
         SINT4     = SQRT( (1.D0 - COS4CM) * (1.D0 + COS4CM) )
         SINT4I    = 1.D0 / SINT4
         AUXA      = COS3CM * COSPSI * SINALF + SIN3CM * COSALF
         COSFI4    = (COSPHI*AUXA-SINPHI*SINPSI*SINALF) * SINT4I
         PHI345(2) = ACOS( MAX( -1.D0, MIN( 1.D0, COSFI4 ) ) )
         SINFI4    = (SINPHI*AUXA+COSPHI*SINPSI*SINALF) * SINT4I
         IF ( SINFI4 .LE. 0.D0 ) PHI345(2)  = PI2 - PHI345(2)
      ELSE
         PHI345(2)  = 0.D0
      ENDIF
C  CALCULATE GAMMA FACTORS AND POLAR ANGLES IN LABORATORY SYSTEM
      GAM345(1) = GAMMA * (E3CM + BETA * P3CM * COS3CM) / AM3
      COS345(1) = MIN( 1.D0, (BETA * E3CM + P3CM * COS3CM) * GAMMA
     *           / (AM3 * SQRT( (GAM345(1)-1.D0)*(GAM345(1)+1.D0) )) )
      GAM345(2) = GAMMA * (E4CM + BETA * P4CM * COS4CM) / AM4
      COS345(2) = MIN( 1.D0, (BETA * E4CM + P4CM * COS4CM) * GAMMA
     *           / (AM4 * SQRT( (GAM345(2)-1.D0)*(GAM345(2)+1.D0) )) )
C  CALCULATE PARAMETERS OF PARTICLE 5, IF NEEDED

      IF ( MODE .LE. 2 ) THEN

        COS5CM      = COS3CM * COSBET - SIN3CM * COSPSI * SINBET
        IF ( ABS(COS5CM) .LT. 1.D0 ) THEN
          SINT5I    = 1.D0 / SQRT( (1.D0 - COS5CM) * (1.D0 + COS5CM) )
          AUXB      = COS3CM * COSPSI * SINBET + SIN3CM * COSBET
          COSFI5    = (COSPHI*AUXB-SINPHI*SINPSI*SINBET) * SINT5I
          PHI345(3) = ACOS( MAX( -1.D0, MIN( 1.D0, COSFI5 ) ) )
          SINFI5    = (SINPHI*AUXB+COSPHI*SINPSI*SINBET) * SINT5I
          IF ( SINFI5 .LE. 0.D0 ) PHI345(3)  = PI2 - PHI345(3)
        ELSE
          PHI345(3)  = 0.D0
        ENDIF
        IF ( AM5 .NE. 0.D0 ) THEN
          GAM345(3) = GAMMA * (E5CM + BETA * P5CM * COS5CM) / AM5
          COS345(3) = MIN( 1.D0, (BETA * E5CM + P5CM * COS5CM) * GAMMA
     *               /(AM5 * SQRT((GAM345(3)-1.D0)*(GAM345(3)+1.D0))) )
        ELSE
C  IF PARTICLE 5 IS GAMMA RAY OR NEUTRINO, THEN GAM345(3) IS THE ENERGY
          GAM345(3) = GAMMA * (E5CM + BETA * P5CM * COS5CM)
          COS345(3) = MIN( 1.D0, (BETA * E5CM + P5CM * COS5CM) * GAMMA
     *                           / GAM345(3) )
        ENDIF

      ENDIF

      IF ( MODE .EQ. 3 ) THEN
C  CALCULATION OF MUON POLARIZATION. WE FOLLOW THE DESCRIPTION OF
C  L. JAUNEAU, IN: METHODS IN SUBNUCLEAR PHYSICS, VOL. 3, M. NIKOLIC ED.
C  (GORDON + BREACH, NEW YORK, 1969), P. 123
C  SEE ALSO: L.M. CHOUNET ET AL., PHYS. REP. 4 (1972) 199, APPENDIX 1.
C  SEE ALSO: N. CABBIBO, A. MAKSYMOWICZ, PHYS. LETT. 9 (1964) 352
C  (CORRECTIONS IN: PHYS. LETT. 11 (1964) 360; 14 (1965) 72)
C  WE DEFINE  BOFQ (READ: B OF Q), WHICH IS -B(Q**2)*4
        BOFQ = 1.D0 - XIT
C  ABYM AND BBYM (READ A BY M; B BY M) ARE THE QUANTITIES A/M AND B/M
        ABYM = AM0 * ( BOFQ * EPIPRM - 2.D0 * E5CM )
        BBYM = CM0SQ + 0.25D0 * CM4SQ * BOFQ**2 - BOFQ * AM0 * E4CM
C  NOW CALCULATE THE COMPONENTS APARAL (PARALLEL TO MU DIRECTION) AND
C  APERPN (PERPENDICULAR TO MU DIRECTION) USING QUANTITIES DEFINED IN
C  KAON REST SYSTEM. NOTE OUR DEFINITION OF SINALF (ALWAYS WITH NEGATIVE
C  SIGN) OPPOSITE TO CABBIBO''S SIN(PSI) AND JAUNEAU''S SIN(THETA)
        APARAL = (-P3CM)*AM4*BBYM*COSALF - P4CM * ( AM0*ABYM - BBYM *
     *           ( P3CM*SINALF*(E4CM-AM4)/P4CM + AM0 - E3CM ) )
        APERPN = P3CM*AM4*BBYM*SINALF
C  NOW NORMALIZE THE PARALLEL COMPONENT OF POLARIZATION; POLART IS
C  COSINE OF THE ANGLE BETWEEN MUON MOMENTUM AND POLARISATION
        POLART = APARAL / SQRT( APARAL**2 + APERPN**2 )
C  THE POLARIZATION VECTOR LIES IN THE PLANE OF MOMENTA (PION,MUON).
C  OMEGA IS THE ANGLE BY WHICH THE DECAY PLANE (PION,MUON) IS ROTATET
C  AROUND THE DIRECTION OF MUON RELATIVE TO THE PLANE (KAON,MUON)
        IF ( ABS(COS4CM) .LT. 1.D0  .AND.  SINALF .NE. 0.D0 ) THEN
          COSOME = (COS4CM*COSALF - COS3CM)*SINT4I/SINALF
          OMEGA  = ACOS( MAX( -1.D0, MIN( 1.D0, COSOME ) ) )
          IF ( SINFI4 .NE. 0.D0 ) THEN
            SINOMG = ( COSFI4 * ( COSALF - COS3CM*COS4CM ) * SINT4I
     *                 - SIN3CM * COSPHI ) / (SINALF*SINFI4)
            IF ( SINOMG .LT. 0.D0 ) OMEGA = PI2 - OMEGA
          ENDIF
        ELSE
          OMEGA = 0.D0
        ENDIF
        POLARF  = OMEGA
      ENDIF

      RETURN
      END

*-- Author :    G.A. Erskine CERN          MATHLIB 01/04/1996
C=======================================================================

      DOUBLE PRECISION FUNCTION DGQUAD( F,A,B,N )

C-----------------------------------------------------------------------
C  D(OUBLE PRECISION) G(AUSS) QUAD(RATURE)
C
C  N-POINT GAUSSIAN QUADRATURE
C  SEE: http://consult.cern.ch/shortwriteups/d107/top.html
C  THIS FUNCTION IS CALLED FROM DKOKOE, DKOKOI, AND DKOKOS.
C  ARGUMENTS:   SEE REFERENCE
C-----------------------------------------------------------------------

      IMPLICIT NONE
      DOUBLE PRECISION A,B,F,W(1),X(1)
      INTEGER          N
      EXTERNAL         F
      SAVE
C-----------------------------------------------------------------------

      CALL D107D1( 1,F,A,B,N,X,W )
      DGQUAD = X(1)

      RETURN
      END
C=======================================================================

      SUBROUTINE D107D1( MODE,F,A,B,N,X,W )

C-----------------------------------------------------------------------
C
C  N-POINT GAUSSIAN QUADRATURE
C  SEE: http://consult.cern.ch/shortwriteups/d107/top.html
C  ARGUMENTS:   SEE REFERENCE
C-----------------------------------------------------------------------

      IMPLICIT NONE
      DOUBLE PRECISION Z1,HF
      PARAMETER        (Z1 = 1.D0)
      PARAMETER        (HF = Z1/2.D0)
      DOUBLE PRECISION U(273),V(273),W(*),X(*)
      DOUBLE PRECISION A,ALFA,B,BETA,DELTA,SUM,WTEMP
      INTEGER          J,J1,J2,KTBA(97),MODE,N
      DOUBLE PRECISION F
      EXTERNAL         F
      SAVE

      DATA KTBA
     1/0,1,2,4,6,9,12,16,20,25,30,36,42,49,56,64,3*0,72,3*0,82,7*0,94,
     2 7*0,110,7*0,130,15*0,154,15*0,186,15*0,226,0/

C  N=2.
      DATA U(1)  /5.7735026918962576D-1/, V(1)  /1.D0/
C  N=3.
      DATA U(2)  /7.7459666924148338D-1/, V(2)  /5.5555555555555556D-1/
      DATA U(3)  /0.D0/                 , V(3)  /8.8888888888888889D-1/
C  N=4.
      DATA U(4)  /8.6113631159405258D-1/, V(4)  /3.4785484513745386D-1/
      DATA U(5)  /3.3998104358485626D-1/, V(5)  /6.5214515486254614D-1/
C  N=5.
      DATA U(6)  /9.0617984593866399D-1/, V(6)  /2.3692688505618909D-1/
      DATA U(7)  /5.3846931010568309D-1/, V(7)  /4.7862867049936647D-1/
      DATA U(8)  /0.D0/                 , V(8)  /5.6888888888888889D-1/
C  N=6.
      DATA U(9)  /9.3246951420315203D-1/, V(9)  /1.7132449237917035D-1/
      DATA U(10) /6.6120938646626451D-1/, V(10) /3.6076157304813861D-1/
      DATA U(11) /2.3861918608319691D-1/, V(11) /4.6791393457269105D-1/
C  N=7.
      DATA U(12) /9.4910791234275852D-1/, V(12) /1.2948496616886969D-1/
      DATA U(13) /7.4153118559939444D-1/, V(13) /2.7970539148927667D-1/
      DATA U(14) /4.0584515137739717D-1/, V(14) /3.8183005050511894D-1/
      DATA U(15) /0.D0/                 , V(15) /4.1795918367346939D-1/
C  N=8.
      DATA U(16) /9.6028985649753623D-1/, V(16) /1.0122853629037626D-1/
      DATA U(17) /7.9666647741362674D-1/, V(17) /2.2238103445337447D-1/
      DATA U(18) /5.2553240991632899D-1/, V(18) /3.1370664587788729D-1/
      DATA U(19) /1.8343464249564980D-1/, V(19) /3.6268378337836198D-1/
C  N=9.
      DATA U(20) /9.6816023950762609D-1/, V(20) /8.1274388361574412D-2/
      DATA U(21) /8.3603110732663579D-1/, V(21) /1.8064816069485740D-1/
      DATA U(22) /6.1337143270059040D-1/, V(22) /2.6061069640293546D-1/
      DATA U(23) /3.2425342340380893D-1/, V(23) /3.1234707704000284D-1/
      DATA U(24) /0.D0/                 , V(24) /3.3023935500125976D-1/
C  N=10.
      DATA U(25) /9.7390652851717172D-1/, V(25) /6.6671344308688138D-2/
      DATA U(26) /8.6506336668898451D-1/, V(26) /1.4945134915058059D-1/
      DATA U(27) /6.7940956829902441D-1/, V(27) /2.1908636251598204D-1/
      DATA U(28) /4.3339539412924719D-1/, V(28) /2.6926671930999636D-1/
      DATA U(29) /1.4887433898163121D-1/, V(29) /2.9552422471475287D-1/
C  N=11.
      DATA U(30) /9.7822865814605699D-1/, V(30) /5.5668567116173666D-2/
      DATA U(31) /8.8706259976809530D-1/, V(31) /1.2558036946490462D-1/
      DATA U(32) /7.3015200557404932D-1/, V(32) /1.8629021092773425D-1/
      DATA U(33) /5.1909612920681182D-1/, V(33) /2.3319376459199048D-1/
      DATA U(34) /2.6954315595234497D-1/, V(34) /2.6280454451024666D-1/
      DATA U(35) /0.D0/                 , V(35) /2.7292508677790063D-1/
C  N=12.
      DATA U(36) /9.8156063424671925D-1/, V(36) /4.7175336386511827D-2/
      DATA U(37) /9.0411725637047486D-1/, V(37) /1.0693932599531843D-1/
      DATA U(38) /7.6990267419430469D-1/, V(38) /1.6007832854334623D-1/
      DATA U(39) /5.8731795428661745D-1/, V(39) /2.0316742672306592D-1/
      DATA U(40) /3.6783149899818019D-1/, V(40) /2.3349253653835481D-1/
      DATA U(41) /1.2523340851146892D-1/, V(41) /2.4914704581340279D-1/
C  N=13.
      DATA U(42) /9.8418305471858815D-1/, V(42) /4.0484004765315880D-2/
      DATA U(43) /9.1759839922297797D-1/, V(43) /9.2121499837728448D-2/
      DATA U(44) /8.0157809073330991D-1/, V(44) /1.3887351021978724D-1/
      DATA U(45) /6.4234933944034022D-1/, V(45) /1.7814598076194574D-1/
      DATA U(46) /4.4849275103644685D-1/, V(46) /2.0781604753688850D-1/
      DATA U(47) /2.3045831595513479D-1/, V(47) /2.2628318026289724D-1/
      DATA U(48) /0.D0/                 , V(48) /2.3255155323087391D-1/
C  N=14.
      DATA U(49) /9.8628380869681234D-1/, V(49) /3.5119460331751863D-2/
      DATA U(50) /9.2843488366357352D-1/, V(50) /8.0158087159760210D-2/
      DATA U(51) /8.2720131506976499D-1/, V(51) /1.2151857068790318D-1/
      DATA U(52) /6.8729290481168547D-1/, V(52) /1.5720316715819353D-1/
      DATA U(53) /5.1524863635815409D-1/, V(53) /1.8553839747793781D-1/
      DATA U(54) /3.1911236892788976D-1/, V(54) /2.0519846372129560D-1/
      DATA U(55) /1.0805494870734366D-1/, V(55) /2.1526385346315779D-1/
C  N=15.
      DATA U(56) /9.8799251802048543D-1/, V(56) /3.0753241996117268D-2/
      DATA U(57) /9.3727339240070590D-1/, V(57) /7.0366047488108125D-2/
      DATA U(58) /8.4820658341042722D-1/, V(58) /1.0715922046717194D-1/
      DATA U(59) /7.2441773136017005D-1/, V(59) /1.3957067792615431D-1/
      DATA U(60) /5.7097217260853885D-1/, V(60) /1.6626920581699393D-1/
      DATA U(61) /3.9415134707756337D-1/, V(61) /1.8616100001556221D-1/
      DATA U(62) /2.0119409399743452D-1/, V(62) /1.9843148532711158D-1/
      DATA U(63) /0.D0/                 , V(63) /2.0257824192556127D-1/
C  N=16.
      DATA U(64) /9.8940093499164993D-1/, V(64) /2.7152459411754095D-2/
      DATA U(65) /9.4457502307323258D-1/, V(65) /6.2253523938647893D-2/
      DATA U(66) /8.6563120238783174D-1/, V(66) /9.5158511682492785D-2/
      DATA U(67) /7.5540440835500303D-1/, V(67) /1.2462897125553387D-1/
      DATA U(68) /6.1787624440264375D-1/, V(68) /1.4959598881657673D-1/
      DATA U(69) /4.5801677765722739D-1/, V(69) /1.6915651939500254D-1/
      DATA U(70) /2.8160355077925891D-1/, V(70) /1.8260341504492359D-1/
      DATA U(71) /9.5012509837637440D-2/, V(71) /1.8945061045506850D-1/
C  N=20.
      DATA U(72) /9.9312859918509492D-1/, V(72) /1.7614007139152118D-2/
      DATA U(73) /9.6397192727791379D-1/, V(73) /4.0601429800386941D-2/
      DATA U(74) /9.1223442825132591D-1/, V(74) /6.2672048334109064D-2/
      DATA U(75) /8.3911697182221882D-1/, V(75) /8.3276741576704749D-2/
      DATA U(76) /7.4633190646015079D-1/, V(76) /1.0193011981724044D-1/
      DATA U(77) /6.3605368072651503D-1/, V(77) /1.1819453196151842D-1/
      DATA U(78) /5.1086700195082710D-1/, V(78) /1.3168863844917663D-1/
      DATA U(79) /3.7370608871541956D-1/, V(79) /1.4209610931838205D-1/
      DATA U(80) /2.2778585114164508D-1/, V(80) /1.4917298647260374D-1/
      DATA U(81) /7.6526521133497334D-2/, V(81) /1.5275338713072585D-1/
C  N=24.
      DATA U(82) /9.9518721999702136D-1/, V(82) /1.2341229799987200D-2/
      DATA U(83) /9.7472855597130950D-1/, V(83) /2.8531388628933663D-2/
      DATA U(84) /9.3827455200273276D-1/, V(84) /4.4277438817419806D-2/
      DATA U(85) /8.8641552700440103D-1/, V(85) /5.9298584915436781D-2/
      DATA U(86) /8.2000198597390292D-1/, V(86) /7.3346481411080306D-2/
      DATA U(87) /7.4012419157855436D-1/, V(87) /8.6190161531953276D-2/
      DATA U(88) /6.4809365193697557D-1/, V(88) /9.7618652104113888D-2/
      DATA U(89) /5.4542147138883954D-1/, V(89) /1.0744427011596563D-1/
      DATA U(90) /4.3379350762604514D-1/, V(90) /1.1550566805372560D-1/
      DATA U(91) /3.1504267969616337D-1/, V(91) /1.2167047292780339D-1/
      DATA U(92) /1.9111886747361631D-1/, V(92) /1.2583745634682830D-1/
      DATA U(93) /6.4056892862605626D-2/, V(93) /1.2793819534675216D-1/
C  N=32.
      DATA U(94) /9.9726386184948156D-1/, V(94) /7.0186100094700966D-3/
      DATA U(95) /9.8561151154526834D-1/, V(95) /1.6274394730905671D-2/
      DATA U(96) /9.6476225558750643D-1/, V(96) /2.5392065309262059D-2/
      DATA U(97) /9.3490607593773969D-1/, V(97) /3.4273862913021433D-2/
      DATA U(98) /8.9632115576605212D-1/, V(98) /4.2835898022226681D-2/
      DATA U(99) /8.4936761373256997D-1/, V(99) /5.0998059262376176D-2/
      DATA U(100)/7.9448379596794241D-1/, V(100)/5.8684093478535547D-2/
      DATA U(101)/7.3218211874028968D-1/, V(101)/6.5822222776361847D-2/
      DATA U(102)/6.6304426693021520D-1/, V(102)/7.2345794108848506D-2/
      DATA U(103)/5.8771575724076233D-1/, V(103)/7.8193895787070306D-2/
      DATA U(104)/5.0689990893222939D-1/, V(104)/8.3311924226946755D-2/
      DATA U(105)/4.2135127613063535D-1/, V(105)/8.7652093004403811D-2/
      DATA U(106)/3.3186860228212765D-1/, V(106)/9.1173878695763885D-2/
      DATA U(107)/2.3928736225213707D-1/, V(107)/9.3844399080804566D-2/
      DATA U(108)/1.4447196158279649D-1/, V(108)/9.5638720079274859D-2/
      DATA U(109)/4.8307665687738316D-2/, V(109)/9.6540088514727801D-2/
C  N=40.
      DATA U(110)/9.9823770971055920D-1/, V(110)/4.5212770985331913D-3/
      DATA U(111)/9.9072623869945701D-1/, V(111)/1.0498284531152814D-2/
      DATA U(112)/9.7725994998377426D-1/, V(112)/1.6421058381907889D-2/
      DATA U(113)/9.5791681921379166D-1/, V(113)/2.2245849194166957D-2/
      DATA U(114)/9.3281280827867653D-1/, V(114)/2.7937006980023401D-2/
      DATA U(115)/9.0209880696887430D-1/, V(115)/3.3460195282547847D-2/
      DATA U(116)/8.6595950321225950D-1/, V(116)/3.8782167974472018D-2/
      DATA U(117)/8.2461223083331166D-1/, V(117)/4.3870908185673272D-2/
      DATA U(118)/7.7830565142651939D-1/, V(118)/4.8695807635072232D-2/
      DATA U(119)/7.2731825518992710D-1/, V(119)/5.3227846983936824D-2/
      DATA U(120)/6.7195668461417955D-1/, V(120)/5.7439769099391551D-2/
      DATA U(121)/6.1255388966798024D-1/, V(121)/6.1306242492928939D-2/
      DATA U(122)/5.4946712509512820D-1/, V(122)/6.4804013456601038D-2/
      DATA U(123)/4.8307580168617871D-1/, V(123)/6.7912045815233904D-2/
      DATA U(124)/4.1377920437160500D-1/, V(124)/7.0611647391286780D-2/
      DATA U(125)/3.4199409082575847D-1/, V(125)/7.2886582395804059D-2/
      DATA U(126)/2.6815218500725368D-1/, V(126)/7.4723169057968264D-2/
      DATA U(127)/1.9269758070137110D-1/, V(127)/7.6110361900626242D-2/
      DATA U(128)/1.1608407067525521D-1/, V(128)/7.7039818164247966D-2/
      DATA U(129)/3.8772417506050822D-2/, V(129)/7.7505947978424811D-2/
C  N=48.
      DATA U(130)/9.9877100725242612D-1/, V(130)/3.1533460523058386D-3/
      DATA U(131)/9.9353017226635076D-1/, V(131)/7.3275539012762621D-3/
      DATA U(132)/9.8412458372282686D-1/, V(132)/1.1477234579234539D-2/
      DATA U(133)/9.7059159254624725D-1/, V(133)/1.5579315722943849D-2/
      DATA U(134)/9.5298770316043086D-1/, V(134)/1.9616160457355528D-2/
      DATA U(135)/9.3138669070655433D-1/, V(135)/2.3570760839324379D-2/
      DATA U(136)/9.0587913671556967D-1/, V(136)/2.7426509708356948D-2/
      DATA U(137)/8.7657202027424789D-1/, V(137)/3.1167227832798089D-2/
      DATA U(138)/8.4358826162439353D-1/, V(138)/3.4777222564770439D-2/
      DATA U(139)/8.0706620402944263D-1/, V(139)/3.8241351065830706D-2/
      DATA U(140)/7.6715903251574034D-1/, V(140)/4.1545082943464749D-2/
      DATA U(141)/7.2403413092381465D-1/, V(141)/4.4674560856694280D-2/
      DATA U(142)/6.7787237963266391D-1/, V(142)/4.7616658492490475D-2/
      DATA U(143)/6.2886739677651362D-1/, V(143)/5.0359035553854475D-2/
      DATA U(144)/5.7722472608397270D-1/, V(144)/5.2890189485193667D-2/
      DATA U(145)/5.2316097472223303D-1/, V(145)/5.5199503699984163D-2/
      DATA U(146)/4.6690290475095840D-1/, V(146)/5.7277292100403216D-2/
      DATA U(147)/4.0868648199071673D-1/, V(147)/5.9114839698395636D-2/
      DATA U(148)/3.4875588629216074D-1/, V(148)/6.0704439165893880D-2/
      DATA U(149)/2.8736248735545558D-1/, V(149)/6.2039423159892664D-2/
      DATA U(150)/2.2476379039468906D-1/, V(150)/6.3114192286254026D-2/
      DATA U(151)/1.6122235606889172D-1/, V(151)/6.3924238584648187D-2/
      DATA U(152)/9.7004699209462699D-2/, V(152)/6.4466164435950082D-2/
      DATA U(153)/3.2380170962869362D-2/, V(153)/6.4737696812683923D-2/
C  N=64.
      DATA U(154)/9.9930504173577214D-1/, V(154)/1.7832807216964329D-3/
      DATA U(155)/9.9634011677195528D-1/, V(155)/4.1470332605624676D-3/
      DATA U(156)/9.9101337147674432D-1/, V(156)/6.5044579689783629D-3/
      DATA U(157)/9.8333625388462596D-1/, V(157)/8.8467598263639477D-3/
      DATA U(158)/9.7332682778991096D-1/, V(158)/1.1168139460131129D-2/
      DATA U(159)/9.6100879965205372D-1/, V(159)/1.3463047896718643D-2/
      DATA U(160)/9.4641137485840282D-1/, V(160)/1.5726030476024719D-2/
      DATA U(161)/9.2956917213193958D-1/, V(161)/1.7951715775697343D-2/
      DATA U(162)/9.1052213707850281D-1/, V(162)/2.0134823153530209D-2/
      DATA U(163)/8.8931544599511412D-1/, V(163)/2.2270173808383254D-2/
      DATA U(164)/8.6599939815409282D-1/, V(164)/2.4352702568710873D-2/
      DATA U(165)/8.4062929625258036D-1/, V(165)/2.6377469715054659D-2/
      DATA U(166)/8.1326531512279756D-1/, V(166)/2.8339672614259483D-2/
      DATA U(167)/7.8397235894334141D-1/, V(167)/3.0234657072402479D-2/
      DATA U(168)/7.5281990726053190D-1/, V(168)/3.2057928354851554D-2/
      DATA U(169)/7.1988185017161083D-1/, V(169)/3.3805161837141609D-2/
      DATA U(170)/6.8523631305423324D-1/, V(170)/3.5472213256882384D-2/
      DATA U(171)/6.4896547125465734D-1/, V(171)/3.7055128540240046D-2/
      DATA U(172)/6.1115535517239325D-1/, V(172)/3.8550153178615629D-2/
      DATA U(173)/5.7189564620263403D-1/, V(173)/3.9953741132720341D-2/
      DATA U(174)/5.3127946401989455D-1/, V(174)/4.1262563242623529D-2/
      DATA U(175)/4.8940314570705296D-1/, V(175)/4.2473515123653589D-2/
      DATA U(176)/4.4636601725346409D-1/, V(176)/4.3583724529323453D-2/
      DATA U(177)/4.0227015796399160D-1/, V(177)/4.4590558163756563D-2/
      DATA U(178)/3.5722015833766812D-1/, V(178)/4.5491627927418144D-2/
      DATA U(179)/3.1132287199021096D-1/, V(179)/4.6284796581314417D-2/
      DATA U(180)/2.6468716220876742D-1/, V(180)/4.6968182816210017D-2/
      DATA U(181)/2.1742364374000708D-1/, V(181)/4.7540165714830309D-2/
      DATA U(182)/1.6964442042399282D-1/, V(182)/4.7999388596458308D-2/
      DATA U(183)/1.2146281929612055D-1/, V(183)/4.8344762234802957D-2/
      DATA U(184)/7.2993121787799039D-2/, V(184)/4.8575467441503427D-2/
      DATA U(185)/2.4350292663424433D-2/, V(185)/4.8690957009139720D-2/
C  N=80.
      DATA U(186)/9.9955382265163063D-1/, V(186)/1.1449500031869415D-3/
      DATA U(187)/9.9764986439823769D-1/, V(187)/2.6635335895126817D-3/
      DATA U(188)/9.9422754096568828D-1/, V(188)/4.1803131246948952D-3/
      DATA U(189)/9.8929130249975553D-1/, V(189)/5.6909224514031986D-3/
      DATA U(190)/9.8284857273862907D-1/, V(190)/7.1929047681173128D-3/
      DATA U(191)/9.7490914058572779D-1/, V(191)/8.6839452692608584D-3/
      DATA U(192)/9.6548508904379925D-1/, V(192)/1.0161766041103065D-2/
      DATA U(193)/9.5459076634363491D-1/, V(193)/1.1624114120797827D-2/
      DATA U(194)/9.4224276130987267D-1/, V(194)/1.3068761592401339D-2/
      DATA U(195)/9.2845987717244580D-1/, V(195)/1.4493508040509076D-2/
      DATA U(196)/9.1326310257175765D-1/, V(196)/1.5896183583725688D-2/
      DATA U(197)/8.9667557943877068D-1/, V(197)/1.7274652056269306D-2/
      DATA U(198)/8.7872256767821383D-1/, V(198)/1.8626814208299031D-2/
      DATA U(199)/8.5943140666311110D-1/, V(199)/1.9950610878141999D-2/
      DATA U(200)/8.3883147358025528D-1/, V(200)/2.1244026115782006D-2/
      DATA U(201)/8.1695413868146347D-1/, V(201)/2.2505090246332462D-2/
      DATA U(202)/7.9383271750460545D-1/, V(202)/2.3731882865930101D-2/
      DATA U(203)/7.6950242013504137D-1/, V(203)/2.4922535764115491D-2/
      DATA U(204)/7.4400029758359727D-1/, V(204)/2.6075235767565118D-2/
      DATA U(205)/7.1736518536209988D-1/, V(205)/2.7188227500486381D-2/
      DATA U(206)/6.8963764434202760D-1/, V(206)/2.8259816057276862D-2/
      DATA U(207)/6.6085989898611980D-1/, V(207)/2.9288369583267848D-2/
      DATA U(208)/6.3107577304687197D-1/, V(208)/3.0272321759557981D-2/
      DATA U(209)/6.0033062282975174D-1/, V(209)/3.1210174188114702D-2/
      DATA U(210)/5.6867126812270978D-1/, V(210)/3.2100498673487773D-2/
      DATA U(211)/5.3614592089713193D-1/, V(211)/3.2941939397645401D-2/
      DATA U(212)/5.0280411188878499D-1/, V(212)/3.3733214984611523D-2/
      DATA U(213)/4.6869661517054448D-1/, V(213)/3.4473120451753929D-2/
      DATA U(214)/4.3387537083175609D-1/, V(214)/3.5160529044747593D-2/
      DATA U(215)/3.9839340588196923D-1/, V(215)/3.5794393953416055D-2/
      DATA U(216)/3.6230475349948732D-1/, V(216)/3.6373749905835978D-2/
      DATA U(217)/3.2566437074770191D-1/, V(217)/3.6897714638276009D-2/
      DATA U(218)/2.8852805488451185D-1/, V(218)/3.7365490238730490D-2/
      DATA U(219)/2.5095235839227212D-1/, V(219)/3.7776364362001397D-2/
      DATA U(220)/2.1299450285766613D-1/, V(220)/3.8129711314477638D-2/
      DATA U(221)/1.7471229183264681D-1/, V(221)/3.8424993006959423D-2/
      DATA U(222)/1.3616402280914389D-1/, V(222)/3.8661759774076463D-2/
      DATA U(223)/9.7408398441584599D-2/, V(223)/3.8839651059051969D-2/
      DATA U(224)/5.8504437152420669D-2/, V(224)/3.8958395962769531D-2/
      DATA U(225)/1.9511383256793998D-2/, V(225)/3.9017813656306655D-2/
C  N=96.
      DATA U(226)/9.9968950388323077D-1/, V(226)/7.9679206555201243D-4/
      DATA U(227)/9.9836437586318168D-1/, V(227)/1.8539607889469217D-3/
      DATA U(228)/9.9598184298720929D-1/, V(228)/2.9107318179349464D-3/
      DATA U(229)/9.9254390032376262D-1/, V(229)/3.9645543384446867D-3/
      DATA U(230)/9.8805412632962380D-1/, V(230)/5.0142027429275177D-3/
      DATA U(231)/9.8251726356301468D-1/, V(231)/6.0585455042359617D-3/
      DATA U(232)/9.7593917458513647D-1/, V(232)/7.0964707911538653D-3/
      DATA U(233)/9.6832682846326421D-1/, V(233)/8.1268769256987592D-3/
      DATA U(234)/9.5968829144874254D-1/, V(234)/9.1486712307833866D-3/
      DATA U(235)/9.5003271778443764D-1/, V(235)/1.0160770535008416D-2/
      DATA U(236)/9.3937033975275522D-1/, V(236)/1.1162102099838499D-2/
      DATA U(237)/9.2771245672230869D-1/, V(237)/1.2151604671088320D-2/
      DATA U(238)/9.1507142312089807D-1/, V(238)/1.3128229566961573D-2/
      DATA U(239)/9.0146063531585234D-1/, V(239)/1.4090941772314861D-2/
      DATA U(240)/8.8689451740242042D-1/, V(240)/1.5038721026994938D-2/
      DATA U(241)/8.7138850590929650D-1/, V(241)/1.5970562902562291D-2/
      DATA U(242)/8.5495903343460146D-1/, V(242)/1.6885479864245172D-2/
      DATA U(243)/8.3762351122818712D-1/, V(243)/1.7782502316045261D-2/
      DATA U(244)/8.1940031073793168D-1/, V(244)/1.8660679627411467D-2/
      DATA U(245)/8.0030874413914082D-1/, V(245)/1.9519081140145022D-2/
      DATA U(246)/7.8036904386743322D-1/, V(246)/2.0356797154333325D-2/
      DATA U(247)/7.5960234117664750D-1/, V(247)/2.1172939892191299D-2/
      DATA U(248)/7.3803064374440013D-1/, V(248)/2.1966644438744349D-2/
      DATA U(249)/7.1567681234896763D-1/, V(249)/2.2737069658329374D-2/
      DATA U(250)/6.9256453664217156D-1/, V(250)/2.3483399085926220D-2/
      DATA U(251)/6.6871831004391615D-1/, V(251)/2.4204841792364691D-2/
      DATA U(252)/6.4416340378496712D-1/, V(252)/2.4900633222483610D-2/
      DATA U(253)/6.1892584012546857D-1/, V(253)/2.5570036005349361D-2/
      DATA U(254)/5.9303236477757208D-1/, V(254)/2.6212340735672414D-2/
      DATA U(255)/5.6651041856139717D-1/, V(255)/2.6826866725591762D-2/
      DATA U(256)/5.3938810832435744D-1/, V(256)/2.7412962726029243D-2/
      DATA U(257)/5.1169417715466767D-1/, V(257)/2.7970007616848334D-2/
      DATA U(258)/4.8345797392059636D-1/, V(258)/2.8497411065085386D-2/
      DATA U(259)/4.5470942216774301D-1/, V(259)/2.8994614150555237D-2/
      DATA U(260)/4.2547898840730055D-1/, V(260)/2.9461089958167906D-2/
      DATA U(261)/3.9579764982890860D-1/, V(261)/2.9896344136328386D-2/
      DATA U(262)/3.6569686147231364D-1/, V(262)/3.0299915420827594D-2/
      DATA U(263)/3.3520852289262542D-1/, V(263)/3.0671376123669149D-2/
      DATA U(264)/3.0436494435449635D-1/, V(264)/3.1010332586313837D-2/
      DATA U(265)/2.7319881259104914D-1/, V(265)/3.1316425596861356D-2/
      DATA U(266)/2.4174315616384001D-1/, V(266)/3.1589330770727167D-2/
      DATA U(267)/2.1003131046056720D-1/, V(267)/3.1828758894411006D-2/
      DATA U(268)/1.7809688236761860D-1/, V(268)/3.2034456231992663D-2/
      DATA U(269)/1.4597371465489694D-1/, V(269)/3.2206204794030251D-2/
      DATA U(270)/1.1369585011066592D-1/, V(270)/3.2343822568575928D-2/
      DATA U(271)/8.1297495464425559D-2/, V(271)/3.2447163714064269D-2/
      DATA U(272)/4.8812985136049731D-2/, V(272)/3.2516118713868836D-2/
      DATA U(273)/1.6276744849602970D-2/, V(273)/3.2550614492363166D-2/
C-----------------------------------------------------------------------

      IF ( KTBA( MIN( MAX(1,N), 97 ) ) .EQ. 0 ) THEN
        X(1) = 0.D0
        WRITE(*,101) N
 101    FORMAT(' DGQUAD: ERROR  N = ',I5,' IS NON-PERMISSIBLE')
        RETURN
      ENDIF
      ALFA = HF * (B + A)
      BETA = HF * (B - A)
      IF ( MODE .EQ. 1 ) THEN
        SUM = 0.D0
        J1 = MOD(N,2)
        J2 = KTBA(N) + (N-1)/2
        DO  J = KTBA(N), J2-J1
          DELTA = BETA * U(J)
          SUM   = SUM + V(J) * ( F(ALFA+DELTA) + F(ALFA-DELTA) )
        ENDDO
        IF ( J1 .EQ. 1 ) SUM = SUM + V(J2) * F(ALFA)
        X(1) = BETA * SUM
      ELSE
        J1 = KTBA(N) - 1
        J2 = N + 1
        DO  J = 1, J2/2
          WTEMP   = BETA * V(J1+J)
          DELTA   = BETA * U(J1+J)
          X(J)    = ALFA - DELTA
          W(J)    = WTEMP
          X(J2-J) = ALFA + DELTA
          W(J2-J) = WTEMP
        ENDDO
      ENDIF

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   26/06/2003
C=======================================================================

      DOUBLE PRECISION FUNCTION DKOKOE( Y )

C-----------------------------------------------------------------------
C  D(OUBLE PRECISION) KOKO(ULIN INTEGRATION FOR) E(NERGY LOSS)
C
C  SEE: S. BOTTAI AND L. PERRONE, NUCL. INST. METH. A459 (2001) 319
C     R.P. KOKOULIN AND A.A. PETRUKHIN, PROC. 12TH ICRC, 6 (1971) A2436
C  TO BE USED FOR ENERGY LOSS CALCULATION OF MUON PAIR PRODUCTION.
C  THIS FUNCTION IS CALLED FROM DADMUL (CALLED FROM DPRELM).
C  ARGUMENTS: (TO BE USED BY DADMUL)
C   Y      = DUMMY ARRAY OF DIMENSION N
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

       

       

       

       

      DOUBLE PRECISION Y(2)
      DOUBLE PRECISION ROMAX,ROMIN
      INTEGER          NPNTS
      DOUBLE PRECISION DGQUAD,PPCE
      EXTERNAL         DGQUAD,PPCE
      SAVE
      DATA             ROMIN /0.D0/, NPNTS / 64 /
C-----------------------------------------------------------------------

      VFRAC = 10.D0**Y(2)
C  INITIALIZATION FOR GAUSS INTEGRATION
      ROMAX = SQRT( 1.D0 - 4.D0*PAMA(2)/(EE*VFRAC) )
     *           * ( 1.D0 - 6.D0*PAMA(5)**2/( (1.D0-VFRAC)*EE**2 ) )
C  INTEGRATION WITH N-POINT GAUSSIAN QUADRATURE
      DKOKOE = LOG(10.D0) * VFRAC * DGQUAD( PPCE,ROMIN,ROMAX,NPNTS )
C  NORMALIZATION IS MADE IN DPRELM
      IF ( DKOKOE .LT. 0.D0 ) DKOKOE = 0.D0

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   14/05/2003
C=======================================================================

      DOUBLE PRECISION FUNCTION DKOKOI()

C-----------------------------------------------------------------------
C  D(OUBLE PRECISION) KOKO(ULIN) I(NTEGRATION)
C
C  FUNCTION FOR INTEGRATION OF PAIR PRODUCTION CROSS SECTION WITH
C  RESPECT TO ENERGY ASYMMETRY PARAMETER RO.
C  SEE: S. BOTTAI AND L. PERRONE, NUCL. INST. METH. A459 (2001) 319
C     R.P. KOKOULIN AND A.A. PETRUKHIN, PROC. 12TH ICRC, 6 (1971) A2436
C  TO BE USED FOR SAMPLING OF MUON PAIR PRODUCTION.
C  THIS FUNCTION IS CALLED FROM MUPRPR.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

       

       

       

       

      DOUBLE PRECISION ALPHFA,RE
      PARAMETER        (ALPHFA = 7.297353D-3)
      PARAMETER        (RE     = 3.8615932335D-11) !ELECTRON RADIUS (CM)

      DOUBLE PRECISION ROMAX,ROMIN,VVAL
      INTEGER          NPNTS
      DOUBLE PRECISION DGQUAD,PPCS
      EXTERNAL         DGQUAD,PPCS
      SAVE
      DATA             ROMIN /0.D0/, NPNTS / 64 /
C-----------------------------------------------------------------------

C  EE IS THE TOTAL ENERGY OF INCOMING MUON

C  INITIALIZATION FOR GAUSS INTEGRATION
      VVAL   = 1.D0 - VMIN/VFRAC
      IF ( VVAL .LT. 0.D0 ) VVAL = 1.D-10
      ROMAX = SQRT( VVAL )
     *           * ( 1.D0 - 6.D0*PAMA(5)**2/( (1.D0-VFRAC)*EE**2 ) )
C  INTEGRATION WITH N-POINT GAUSSIAN QUADRATURE
      DKOKOI =  2.D0 * DGQUAD( PPCS,ROMIN,ROMAX,NPNTS )
C  NORMALIZATION
      DKOKOI = DKOKOI * ALPHFA**4 * (TB3/PI)
     *                * ZATOM * (ZATOM+1.D0) * RE**2

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   14/05/2003
C=======================================================================

      DOUBLE PRECISION FUNCTION DKOKOS( Y )

C-----------------------------------------------------------------------
C  D(OUBLE PRECISION) KOKO(ULIN INTEGRATION FOR) S(IGMA)
C
C  SEE: S. BOTTAI AND L. PERRONE, NUCL. INST. METH. A459 (2001) 319
C     R.P. KOKOULIN AND A.A. PETRUKHIN, PROC. 12TH ICRC, 6 (1971) A2436
C  TO BE USED FOR CROSS SECTION CALCULATION OF MUON PAIR PRODUCTION.
C  THIS FUNCTION IS CALLED FROM DADMUL (CALLED FROM DPRSGM).
C  ARGUMENTS: (TO BE USED BY DADMUL)
C   Y      = DUMMY ARRAY OF DIMENSION N
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

       

       

       

       

      DOUBLE PRECISION Y(2)
      DOUBLE PRECISION ROMAX,ROMIN
      INTEGER          NPNTS
      DOUBLE PRECISION DGQUAD,PPCS
      EXTERNAL         DGQUAD,PPCS
      SAVE
      DATA             ROMIN /0.D0/, NPNTS / 64 /
C-----------------------------------------------------------------------

      VFRAC = 10.D0**(Y(2))

C  INITIALIZATION FOR GAUSS INTEGRATION
      ROMAX = SQRT( 1.D0 - 4.D0*PAMA(2)/(EE*VFRAC) )
     *           * ( 1.D0 - 6.D0*PAMA(5)**2/( (1.D0-VFRAC)*EE**2 ) )
C  INTEGRATION WITH N-POINT GAUSSIAN QUADRATURE
      DKOKOS = LOG(10.D0) * VFRAC * DGQUAD( PPCS,ROMIN,ROMAX,NPNTS )
C  NORMALIZATION IS MADE IN DPRSGM
      IF ( DKOKOS .LT. 0.D0 ) DKOKOS = 0.D0

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   04/02/2004
C=======================================================================

      DOUBLE PRECISION FUNCTION DNIELM( JJMAT )

C-----------------------------------------------------------------------
C  D(OUBLE PRECISION) N(UCL.) I(NTER.) E(NERGY) L(OSS) M(UONS)
C
C  FUNCTION TO CALCULATE THE MUON NUCLEAR INTERACTION ENERGY LOSS.
C  SEE: S. BOTTAI AND L. PERRONE, NUCL. INST. METH. A459 (2001) 319
C       BILOKON ET AL., NUCL. INSTR. METH. A303 (1991) 381
C       LOHMANN, KOPP, VOSS, YELLOW REPORT FROM CERN 85-03
C  THIS FUNCTION IS CALLED FROM MUPINI.
C  ARGUMENT:
C   JJMAT  = MATERIAL INDEX (1 = 14N, 2 = 16O, 3 = 40AR)
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRAIR/   COMPOS,PROBTA,AVERAW,AVOGDR
      DOUBLE PRECISION COMPOS(3),PROBTA(3),AVERAW,AVOGDR

      COMMON /CRELABCT/ELCUT
      DOUBLE PRECISION ELCUT(4)

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      INTEGER          IWK,MAXPTS,MINCAL,MINPTS,N
      PARAMETER        (IWK    = 1000000)
      PARAMETER        (MAXPTS = 100000)
      PARAMETER        (MINCAL = 1)
      PARAMETER        (MINPTS = 10)
      PARAMETER        (N      = 2)
      DOUBLE PRECISION EPSBS
      PARAMETER        (EPSBS  = 1.D-6)

      DOUBLE PRECISION AA(2),B(2),WK(IWK)
      DOUBLE PRECISION ECMIN,ECMAX,RELERR,RESULT,XLOW,XLOW0,XUPP
      INTEGER          IFAIL,JJMAT,NFNEVL
      DOUBLE PRECISION VPHL
      EXTERNAL         VPHL
      SAVE
      DATA             XLOW0 / 1.D-15 /
C-----------------------------------------------------------------------

      DNIELM = 0.D0
C  EE IS THE TOTAL ENERGY OF INCOMING MUON
      ECMIN  = PAMA(8) + PAMA(8)**2 / (PAMA(14) * 2.D0)
      ECMAX  = EE - 0.5D0 * ( PAMA(14) + PAMA(5)**2/PAMA(14) )
      XLOW   = ECMIN / EE
C   TAKE HADRON CUTTING  ENERGY FOR MAXIMUM      CDH MARCH 17, 2005
      XUPP   = ( ELCUT(1) + PAMA(7) ) / EE

      IF ( ECMAX .LT. ELCUT(1)+PAMA(7) ) XUPP = ECMAX/EE
      IF ( ECMIN .GE. ELCUT(1)+PAMA(7) ) RETURN
      IF ( XLOW .LE. XLOW0 ) XLOW = XLOW0
      IF ( XUPP .LE. XLOW  ) RETURN

C  DADMUL INTEGRATION
      AA(1) = 0.D0
      AA(2) = XLOW
      B(1)  = 1.D0
      B(2)  = XUPP
      CALL DADMUL( VPHL,N,AA,B,MINPTS,MAXPTS
     *                     ,EPSBS,WK,IWK,RESULT,RELERR,NFNEVL,IFAIL )
      IF ( IFAIL .NE. 0 ) THEN
        WRITE(MONIOU,*) 'DNIELM: IFAIL=',IFAIL,' E=',EE,' JJMAT=',JJMAT
        STOP
      ENDIF
      DNIELM = RESULT * 1.D27 * EE * AVOGDR / AATOM

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   15/05/2003
C=======================================================================

      DOUBLE PRECISION FUNCTION DNUSGM( JJMAT )

C-----------------------------------------------------------------------
C  D(OUBLE PRECISION) NU(CLEAR INTERACTION) S(I)GM(A FOR MUONS)
C
C  FUNCTION TO CALCULATE THE MUON NUCLEAR INTERACTION CROSS-SECTIONS.
C  SEE: S. BOTTAI AND L. PERRONE, NUCL. INST. METH. A459 (2001) 319
C       BILOKON ET AL., NUCL. INSTR. METH.  A303 (1991) 381
C       LOHMANN, KOPP, VOSS, YELLOW REPORT FROM CERN 85-03
C  THIS FUNCTION IS CALLED FROM MUPINI.
C  ARGUMENT:
C   JJMAT  = MATERIAL INDEX (1 = 14N, 2 = 16O, 3 = 40AR)
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRELABCT/ELCUT
      DOUBLE PRECISION ELCUT(4)

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

       

       

       

       

      INTEGER          IWK,MAXPTS,MINCAL,MINPTS,N
      PARAMETER        (IWK    = 1000000)
      PARAMETER        (MAXPTS = 100000)
      PARAMETER        (MINCAL = 1)
      PARAMETER        (MINPTS = 10)
      PARAMETER        (N      = 2)
      DOUBLE PRECISION EPSBS
      PARAMETER        (EPSBS  = 1.D-6)
      DOUBLE PRECISION AA(2),B(2),WK(IWK)
      DOUBLE PRECISION ECMIN,ECMAX,RELERR,RESULT,XLOW,XLOW0,XUPP

      INTEGER          IFAIL,JJMAT,NFNEVL
      DOUBLE PRECISION VPHM
      EXTERNAL         VPHM
      SAVE
      DATA             XLOW0 / 1.D-15 /
C-----------------------------------------------------------------------

      DNUSGM = 0.D0
      ECMIN  = PAMA(8) + 0.5D0 * PAMA(8)**2 / PAMA(14)
C  EE IS THE TOTAL ENERGY OF INCOMING MUON
      ECMAX  = EE - 0.5D0 * PAMA(14) * ( 1.D0 + (PAMA(5)/PAMA(14))**2 )
C   TAKE HADRON CUTTING  ENERGY FOR MMINIMU      CDH MARCH 17, 2005
      XLOW   = ( ELCUT(1) + PAMA(7) ) / EE
      XUPP   = ECMAX / EE

      IF ( ECMAX .LT. ELCUT(1)+PAMA(7) ) RETURN
      IF ( ECMIN .GT. ELCUT(1)+PAMA(7) ) XLOW = ECMIN/EE
      IF ( XLOW .LE. XLOW0 ) XLOW = XLOW0
      IF ( XUPP .LE. XLOW  ) RETURN

C  DADMUL INTEGRATION
      AA(1) = 0.D0
      AA(2) = XLOW
      B(1)  = 1.D0
      B(2)  = XUPP
      CALL DADMUL( VPHM,N,AA,B,MINPTS,MAXPTS,
     +                EPSBS,WK,IWK,RESULT,RELERR,NFNEVL,IFAIL )

      IF ( IFAIL .NE. 0 ) THEN
        WRITE(6,*) 'DNUSGM: IFAIL=',IFAIL,' E=',EE,' JJMAT=',JJMAT
        STOP
      ENDIF
C  CONVERT FROM CM**2  TO MILLIBARN
      DNUSGM = RESULT * 1.D27

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   25/06/2003
C=======================================================================

      DOUBLE PRECISION FUNCTION DPRELM( JJMAT )

C-----------------------------------------------------------------------
C  D(OUBLE PRECISION) P(AI)R (PRODUCTION) E(NERGY) L(OSS) M(UONS)
C
C  FUNCTION TO CALCULATE THE MUON BREMSSTRAHLUNG ENERGY LOSS.
C  SEE: S. BOTTAI AND L. PERRONE, NUCL. INST. METH. A459 (2001) 319
C       BILOKON ET AL., NUCL. INSTR. METH. A303 (1991) 381
C       LOHMANN, KOPP, VOSS, YELLOW REPORT FROM CERN 85-03
C  THIS FUNCTION IS CALLED FROM MUPINI.
C  ARGUMENT:
C   JJMAT  = MATERIAL INDEX (1 = 14N, 2 = 16O, 3 = 40AR)
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRAIR/   COMPOS,PROBTA,AVERAW,AVOGDR
      DOUBLE PRECISION COMPOS(3),PROBTA(3),AVERAW,AVOGDR

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      INTEGER          IWK,MAXPTS,MINCAL,MINPTS,N
      PARAMETER        (IWK    = 1000000)
      PARAMETER        (MAXPTS = 100000)
      PARAMETER        (MINCAL = 1)
      PARAMETER        (MINPTS = 10)
      PARAMETER        (N      = 2)
      DOUBLE PRECISION ALPHFA,EPSPP,RE
      PARAMETER        (ALPHFA = 7.297353D-3)
      PARAMETER        (EPSPP  = 1.D-3)
      PARAMETER        (RE     = 3.8615932335D-11) !ELECTRON RADIUS (CM)

      DOUBLE PRECISION AA(2),B(2),WK(IWK)
      DOUBLE PRECISION ECMIN,ECMAX,RELERR,RESULT,XLOW,XLOW0,XUPP
      INTEGER          IFAIL,JJMAT,NFNEVL
      DOUBLE PRECISION DKOKOE
      EXTERNAL         DKOKOE
      SAVE
      DATA             XLOW0 / 1.D-15 /
C-----------------------------------------------------------------------

      DPRELM = 0.D0
C  EE IS THE TOTAL ENERGY OF INCOMING MUON
      ECMIN = 4.D0 * PAMA(2)
      ECMAX = EE - CONSTKINE
      XLOW  = ECMIN / EE
      XUPP  = BCUT / EE

      IF ( ECMAX .LT. BCUT ) XUPP = ECMAX/EE
      IF ( ECMIN .GT. BCUT ) RETURN
      IF ( XLOW .LE. XLOW0 ) XLOW = XLOW0
      IF ( XUPP .LT. XLOW + (ECMIN+0.001D0)/EE ) RETURN
      VMIN  = 4.D0 * PAMA(2) / EE
      VMAX  = 1.D0 - CONSTKINE / EE

C  DADMUL INTEGRATION
      AA(1) = 0.D0
      AA(2) = LOG10(XLOW)
      B(1)  = 1.D0
      B(2)  = LOG10(XUPP)
      CALL DADMUL( DKOKOE,N,AA,B,MINPTS,MAXPTS,
     +                EPSPP,WK,IWK,RESULT,RELERR,NFNEVL,IFAIL )
      IF ( IFAIL .NE. 0 ) THEN
        WRITE(MONIOU,*) 'DPRELM: IFAIL=',IFAIL,' E=',EE,' JJMAT=',JJMAT
        STOP
      ENDIF
C  NORMALIZE TO GET ENERGY LOSS IN GEV * G**-1 * CM**2
      DPRELM = AVOGDR * RESULT * 2.D27 * EE * ALPHFA**4 * (TB3/PI)
     *                 * ZATOM * (ZATOM+1.D0) * RE**2 / AATOM

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   14/05/2003
C=======================================================================

      DOUBLE PRECISION FUNCTION DPRSGM( JJMAT )

C-----------------------------------------------------------------------
C  D(OUBLE PRECISION) P(AI)R (PRODUCTION) S(I)GM(A FOR MUONS)
C
C  FUNCTION TO CALCULATE THE MUON PAIR PRODUCTION CROSS-SECTIONS.
C  SEE: S. BOTTAI AND L. PERRONE, NUCL. INST. METH. A459 (2001) 319
C       BILOKON ET AL., NUCL. INSTR. METH.  A303 (1991) 381
C       LOHMANN, KOPP, VOSS, YELLOW REPORT FROM CERN 85-03
C  THIS FUNCTION IS CALLED FROM MUPINI.
C  ARGUMENT:
C   JJMAT  = MATERIAL INDEX (1 = 14N, 2 = 16O, 3 = 40AR)
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      INTEGER          IWK,MAXPTS,MINCAL,MINPTS,N
      PARAMETER        (IWK    = 1000000)
      PARAMETER        (MAXPTS = 100000)
      PARAMETER        (MINCAL = 1)
      PARAMETER        (MINPTS = 10)
      PARAMETER        (N      = 2)
      DOUBLE PRECISION ALPHFA,EPSPP,RE
      PARAMETER        (ALPHFA = 7.297353D-3)
      PARAMETER        (EPSPP  = 1.D-3)
      PARAMETER        (RE     = 3.8615932335D-11) !ELECTRON RADIUS (CM)

      DOUBLE PRECISION AA(2),B(2),WK(IWK)
      DOUBLE PRECISION ECMIN,ECMAX,RELERR,RESULT,XLOW,XLOW0,XUPP
      INTEGER          IFAIL,JJMAT,NFNEVL
      DOUBLE PRECISION DKOKOS
      EXTERNAL         DKOKOS
      SAVE
      DATA             XLOW0 / 1.D-15 /
C-----------------------------------------------------------------------

      DPRSGM = 0.D0
C  EE IS THE TOTAL ENERGY OF INCOMING MUON
      IF ( EE-PAMA(5) .LT. BCUT ) RETURN

      ECMIN = 4.D0 * PAMA(2)
      ECMAX = EE - CONSTKINE
      XLOW  = BCUT / EE
      XUPP  = ECMAX / EE
      IF ( ECMAX .LT. BCUT ) RETURN
      IF ( ECMIN .GT. BCUT ) XLOW = ECMIN / EE
      IF ( XLOW .LE. XLOW0 ) XLOW = XLOW0
      IF ( XUPP .LE. XLOW  ) RETURN
      VMIN  = 4.D0 * PAMA(2) / EE
      VMAX  = 1.D0 - CONSTKINE / EE

C  DADMUL INTEGRATION
      AA(1) = 0.D0
      AA(2) = LOG10(XLOW)
      B(1)  = 1.D0
      B(2)  = LOG10(XUPP)
      CALL DADMUL( DKOKOS,N,AA,B,MINPTS,MAXPTS,
     +                EPSPP,WK,IWK,RESULT,RELERR,NFNEVL,IFAIL )
      IF ( IFAIL .NE. 0 ) THEN
        WRITE(MONIOU,*) 'DPRSGM: IFAIL=',IFAIL,' E=',EE,' JJMAT=',JJMAT
        STOP
      ENDIF
C  CONVERT FROM CM**2  TO MILLIBARN
      DPRSGM = RESULT * 2.D27 * ALPHFA**4 * (TB3/PI)
     *                 * ZATOM * (ZATOM+1.D0) * RE**2

      RETURN
      END

*-- Author :    K. BERNLOEHR MPIK HEIDELBERG    15/06/1998
C=======================================================================

      SUBROUTINE DTCCHR( LINE,IS,CVAL,KEYWRD,IKEY,LENVAL )

C-----------------------------------------------------------------------
C  D(A)T(A) C(ARD) CH(A)R(ACTER)
C
C  READ CHARACTER PARAMETER FROM DATA CARD CHARACTER STRING
C  ERRORS ARE INDICATED BY WRITING A '!' IN LINE(1:1)
C  THIS SUBROUTINE IS CALLED FROM DATAC.
C  ARGUMETNS:
C   LINE   = CHARACTER STRING OF INPUT LINE
C   IS     = POINTER FOR START OF INTERPRETATION OF 'LINE'
C   CVAL   = CHARACTER STRING TO BE RETURNED
C   KEYWORD= KEYWORD AT BEGIN OF LINE
C   IKEY   = NUMBER OF ARGUMENT AFTER KEYWORD
C   LENVAL = LENGTH OF CHARACTER STRING TO BE RETURNED
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      INTEGER          I,IE,IKEY,IQUOTE,IS,L,LENVAL
      CHARACTER        CVAL*(*),KEYWRD*(*),LINE*(*)
      SAVE
C-----------------------------------------------------------------------

      IF ( IS .LE. 0 ) IS = LEN(KEYWRD)

      L = LEN(LINE)
      DO  I = IS+1, L
        IF ( LINE(I:I) .NE. ' ' ) GOTO 11
      ENDDO
   11 IF ( I .GT. L  .OR.  LINE(I:I) .EQ. '!'
     *               .OR.  LINE(I:I) .EQ. ' ' ) THEN
        IF ( IKEY .LE. 1 ) THEN
          WRITE(MONIOU,6000) KEYWRD
 6000     FORMAT(1X,'DATACARD ',A,' HAS NO PARAMETER(S)')
        ELSE
          WRITE(MONIOU,6001) KEYWRD,IKEY
 6001     FORMAT(1X,'DATACARD ',A,' PARAMETER',I2,' IS MISSING')
        ENDIF
        CVAL      = ' '
        LINE(1:1) = '!'
        LENVAL    = 0
        RETURN
      ENDIF
      IF     ( LINE(I:I) .EQ. '''' ) THEN
        IQUOTE = 1
        IS     = I+1
      ELSEIF ( LINE(I:I) .EQ. '"' ) THEN
        IQUOTE = 2
        IS     = I+1
      ELSE
        IQUOTE = 0
        IS     = I
      ENDIF
      DO  I = IS, L
        IF     ( IQUOTE .EQ. 1 ) THEN
          IF ( LINE(I:I) .EQ. '''' ) GOTO 21
        ELSEIF ( IQUOTE .EQ. 2 ) THEN
          IF ( LINE(I:I) .EQ. '"' ) GOTO 21
        ELSE
          IF ( LINE(I:I) .EQ. ' '  .OR.  LINE(I:I) .EQ. '!' ) GOTO 21
        ENDIF
      ENDDO
   21 CONTINUE
      IE = I
      IF     ( IQUOTE .EQ. 1 ) THEN
        IF ( LINE(I:I) .EQ. '''' ) THEN
          IE = I-1
          LINE(I:I) = ' '
        ENDIF
      ELSEIF ( IQUOTE .EQ. 2 ) THEN
        IF ( LINE(I:I) .EQ. '"' ) THEN
          IE = I-1
          LINE(I:I) = ' '
        ENDIF
      ELSEIF ( LINE(I:I) .EQ. ' '  .OR.  LINE(I:I) .EQ. '!' ) THEN
        IE = I-1
      ENDIF
*     WRITE(*,6666) KEYWRD,IKEY,IS,IE,LINE(IS:IE)
*6666 FORMAT(1X,'DTCCHR : ',A,' #',I3,I4,I4,': ',A)

      CVAL   = LINE(IS:IE)
      LENVAL = IE-IS+1
      IF ( LEN(CVAL) .LT. IE-IS+1 ) THEN
        WRITE(MONIOU,6002)
     *  KEYWRD,IKEY,IE-IS+1,LEN(CVAL),CVAL
 6002   FORMAT(1X,'DATACARD ',A,' PARAMETER',I2,' IS TOO LONG AND HAS',
     *     ' BEEN TRUNCATED FROM',I4,' TO',I4,':'/5X,'''',A,'''')
        LINE(1:1) = '!'
        LENVAL    = LEN(CVAL)
      ENDIF

      IS = IE

      IF ( DEBUG ) WRITE(MDEBUG,6667) CVAL
 6667 FORMAT(1X,'DTCCHR : VALUE = ''',A,'''')

      RETURN
      END

*-- Author :    K. BERNLOEHR MPIK HEIDELBERG    15/06/1998
C=======================================================================

      SUBROUTINE DTCDBL( LINE,IS,DVAL,KEYWRD,IKEY )

C-----------------------------------------------------------------------
C  D(A)T(A) C(ARD) D(OU)BL(E PRECISION)
C
C  READ DOUBLE PRECISION PARAMETER FROM DATA CARD CHARACTER STRING
C  ERRORS ARE INDICATED BY WRITING A '!' IN LINE(1:1)
C  THIS SUBROUTINE IS CALLED FROM DATAC.
C  ARGUMETNS:
C   LINE   = CHARACTER STRING OF INPUT LINE
C   IS     = POINTER FOR START OF INTERPRETATION OF 'LINE'
C   DVAL   = DOUBLE PRECISION VARIABLE TO BE RETURNED
C   KEYWORD= KEYWORD AT BEGIN OF LINE
C   IKEY   = NUMBER OF ARGUMENT AFTER KEYWORD
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION DVAL
      INTEGER          I,IE,IKEY,IS,L
      CHARACTER        CFMTR*8,KEYWRD*(*),LINE*(*)
      SAVE
C-----------------------------------------------------------------------

      IF ( IS .LE. 0 ) IS = LEN(KEYWRD)

      L = LEN(LINE)
      DO  I = IS+1, L
        IF ( LINE(I:I) .NE. ' ' ) GOTO 11
      ENDDO
   11 IF ( I .GT. L  .OR.  LINE(I:I) .EQ. '!'
     *               .OR.  LINE(I:I) .EQ. ' ' ) THEN
        IF ( IKEY .LE. 1 ) THEN
          WRITE(MONIOU,6000) KEYWRD
 6000     FORMAT(1X,'DATACARD ',A,' HAS NO PARAMETER(S)')
        ELSE
          WRITE(MONIOU,6001) KEYWRD,IKEY
 6001     FORMAT(1X,'DATACARD ',A,' PARAMETER',I2,' IS MISSING')
        ENDIF
        DVAL      = 0.D0
        LINE(1:1) = '!'
        RETURN
      ENDIF
      IS = I
      DO  I = IS+1, L
        IF ( LINE(I:I) .EQ. ' '  .OR.  LINE(I:I) .EQ. '!' ) GOTO 21
      ENDDO
   21 IF ( LINE(I:I) .EQ. ' '  .OR.  LINE(I:I) .EQ. '!' ) THEN
        IE = I-1
      ELSE
        IE = I
      ENDIF
*     WRITE(*,*) 'DTCDBL : ',KEYWRD,' #',IKEY,IS,IE,': ',LINE(IS:IE)
      IF ( IE-IS+1 .LT. 10 ) THEN
        CFMTR = '(F .0)'
        WRITE(CFMTR(3:3),'(I1)') IE-IS+1
      ELSE
        CFMTR = '(F  .0)'
        WRITE(CFMTR(3:4),'(I2)') IE-IS+1
      ENDIF
      READ(LINE(IS:IE),CFMTR,ERR=999) DVAL

      IS = IE

      IF ( DEBUG ) WRITE(MDEBUG,*) 'DTCDBL : VALUE = ',DVAL
      RETURN

  999 WRITE(MONIOU,6002) KEYWRD,IKEY,LINE(IS:IE)
 6002 FORMAT(1X,'DATACARD ',A,' PARAMETER',I2,' IS INVALID: ',A)
      LINE(1:1) = '!'
      DVAL      = 0.D0
      IS        = IE

      IF ( DEBUG ) WRITE(MDEBUG,*) 'DTCDBL : VALUE = ',DVAL

      RETURN
      END

*-- Author :    K. BERNLOEHR MPIK HEIDELBERG    15/06/1998
C=======================================================================

      SUBROUTINE DTCINT( LINE,IS,IVAL,KEYWRD,IKEY )

C-----------------------------------------------------------------------
C  D(A)T(A) C(ARD) INT(EGER)
C
C  READ INTEGER PARAMETER FROM DATA CARD CHARACTER STRING
C  ERRORS ARE INDICATED BY WRITING A '!' IN LINE(1:1)
C  THIS SUBROUTINE IS CALLED FROM DATAC.
C  ARGUMETNS:
C   LINE   = CHARACTER STRING OF INPUT LINE
C   IS     = POINTER FOR START OF INTERPRETATION OF 'LINE'
C   IVAL   = INTEGER VARIABLE TO BE RETURNED
C   KEYWORD= KEYWORD AT BEGIN OF LINE
C   IKEY   = NUMBER OF ARGUMENT AFTER KEYWORD
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      INTEGER          I,IE,IKEY,IS,IVAL,L
      CHARACTER        CFMTI*8,KEYWRD*(*),LINE*(*)
      SAVE
C-----------------------------------------------------------------------

      IF ( IS .LE. 0 ) IS = LEN(KEYWRD)

      L = LEN(LINE)
      DO  I = IS+1, L
        IF ( LINE(I:I) .NE. ' ' ) GOTO 11
      ENDDO
   11 IF ( I .GT. L  .OR.  LINE(I:I) .EQ. '!'
     *               .OR.  LINE(I:I) .EQ. ' ' ) THEN
        IF ( IKEY .LE. 1 ) THEN
          WRITE(MONIOU,6000) KEYWRD
 6000     FORMAT(1X,'DATACARD ',A,' HAS NO PARAMETER(S)')
        ELSE
          WRITE(MONIOU,6001) KEYWRD,IKEY
 6001     FORMAT(1X,'DATACARD ',A,' PARAMETER',I2,' IS MISSING')
        ENDIF
        IVAL = 0
        LINE(1:1) = '!'
        RETURN
      ENDIF
      IS = I
      DO  I = IS+1, L
        IF ( LINE(I:I) .EQ. ' '  .OR.  LINE(I:I) .EQ. '!' ) GOTO 21
      ENDDO
   21 IF ( LINE(I:I) .EQ. ' '  .OR.  LINE(I:I) .EQ. '!' ) THEN
        IE = I-1
      ELSE
        IE = I
      ENDIF
*     WRITE(*,*) 'DTCINT : ',KEYWRD,' #',IKEY,IS,IE,': ',LINE(IS:IE)
      DO  I = IS, IE
        IF ( (ICHAR(LINE(I:I)) .LT. ICHAR('0')  .OR.
     *        ICHAR(LINE(I:I)) .GT. ICHAR('9')) .AND.
     *       (LINE(I:I) .NE. '-'  .OR.  I .NE. IS) ) THEN
          WRITE(MONIOU,6002) KEYWRD,IKEY,LINE(IS:IE)
 6002     FORMAT(1X,'DATACARD ',A,' PARAMETER',I2,
     *         ' IS NOT INTEGER: ',A)
          IS        = IE
          IVAL      = 0
          LINE(1:1) = '!'
          RETURN
        ENDIF
      ENDDO
      IF ( IE-IS+1 .LT. 10 ) THEN
        CFMTI = '(I )'
        WRITE(CFMTI(3:3),'(I1)') IE-IS+1
      ELSE
        CFMTI = '(I  )'
        WRITE(CFMTI(3:4),'(I2)') IE-IS+1
      ENDIF
      READ(LINE(IS:IE),CFMTI) IVAL

      IS = IE

      IF ( DEBUG ) WRITE(MDEBUG,*) 'DTCINT : VALUE = ',IVAL

      RETURN
      END

*-- Author :    K. BERNLOEHR MPIK HEIDELBERG    15/06/1998
C=======================================================================

      SUBROUTINE DTCLOG( LINE,IS,LVAL,KEYWRD,IKEY )

C-----------------------------------------------------------------------
C  D(A)T(A) C(ARD) LOG(ICAL)
C
C  READ LOGICAL PARAMETER FROM DATA CARD CHARACTER STRING.
C  MAKE USE OF UPPERCASE CONVERSION OF DATA CARDS.
C  FOR 'T' YOU CAN ALSO USE 'TRUE', '.TRUE.', 'Y', 'YES', 'ON', '1'.
C  FOR 'F' YOU CAN ALSO USE 'FALSE', '.FALSE.', 'N', 'NO', 'OFF', '0'.
C  ERRORS ARE INDICATED BY WRITING A '!' IN LINE(1:1)
C  THIS SUBROUTINE IS CALLED FROM DATAC.
C  ARGUMETNS:
C   LINE   = CHARACTER STRING OF INPUT LINE
C   IS     = POINTER FOR START OF INTERPRETATION OF 'LINE'
C   LVAL   = LOGICAL TO BE RETURNED
C   KEYWORD= KEYWORD AT BEGIN OF LINE
C   IKEY   = NUMBER OF ARGUMENT AFTER KEYWORD
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      INTEGER          I,IE,IKEY,IS,L
      LOGICAL          LVAL
      CHARACTER        KEYWRD*(*),LINE*(*)
      SAVE
C-----------------------------------------------------------------------

      IF ( IS .LE. 0 ) IS = LEN(KEYWRD)

      L = LEN(LINE)
      DO  I = IS+1, L
        IF ( LINE(I:I) .NE. ' ' ) GOTO 11
      ENDDO
   11 IF ( I .GT. L  .OR.  LINE(I:I) .EQ. '!'
     *               .OR.  LINE(I:I) .EQ. ' ' ) THEN
        IF ( IKEY .LE. 1 ) THEN
          WRITE(MONIOU,6000) KEYWRD
 6000     FORMAT(1X,'DATACARD ',A,' HAS NO PARAMETER(S)')
        ELSE
          WRITE(MONIOU,6001) KEYWRD,IKEY
 6001     FORMAT(1X,'DATACARD ',A,' PARAMETER',I2,' IS MISSING')
        ENDIF
        IS        = IE
        LVAL      = .FALSE.
        LINE(1:1) = '!'
        RETURN
      ENDIF
      IS = I
      DO  I = IS+1, L
        IF ( LINE(I:I) .EQ. ' '  .OR.  LINE(I:I) .EQ. '!' ) GOTO 21
      ENDDO
   21 IF ( LINE(I:I) .EQ. ' '  .OR.  LINE(I:I) .EQ. '!' ) THEN
        IE = I-1
      ELSE
        IE = I
      ENDIF

*     WRITE(*,*) 'DTCLOG : ',KEYWRD,' #',IKEY,IS,IE,': ',LINE(IS:IE)
      IF     ( LINE(IS:IE) .EQ. 'T'   .OR.  LINE(IS:IE) .EQ. 'TRUE'
     *   .OR.  LINE(IS:IE) .EQ. '.TRUE.'
     *   .OR.  LINE(IS:IE) .EQ. 'Y'   .OR.  LINE(IS:IE) .EQ. 'YES'
     *   .OR.  LINE(IS:IE) .EQ. 'ON'  .OR.  LINE(IS:IE) .EQ. '1' ) THEN
        LVAL = .TRUE.
      ELSEIF ( LINE(IS:IE) .EQ. 'F'   .OR.  LINE(IS:IE) .EQ. 'FALSE'
     *   .OR.  LINE(IS:IE) .EQ. '.FALSE.'
     *   .OR.  LINE(IS:IE) .EQ. 'N'   .OR.  LINE(IS:IE) .EQ. 'NO'
     *   .OR.  LINE(IS:IE) .EQ. 'OFF' .OR.  LINE(IS:IE) .EQ. '0' ) THEN
        LVAL = .FALSE.
      ELSE
        WRITE(MONIOU,6002) KEYWRD,IKEY,LINE(IS:IE)
 6002   FORMAT(1X,'DATACARD ',A,' PARAMETER',I2,' IS INVALID: ',A)
        LVAL      = .FALSE.
        LINE(1:1) = '!'
      ENDIF

      IS = IE

      IF ( DEBUG ) WRITE(MDEBUG,*) 'DTCLOG : VALUE = ',LVAL

      RETURN
      END

*-- Author :    K. BERNLOEHR MPIK HEIDELBERG    15/06/1998
C=======================================================================

      SUBROUTINE DTCRL( LINE,IS,RVAL,KEYWRD,IKEY )

C-----------------------------------------------------------------------
C  D(A)T(A) C(ARD) R(EA)L
C
C  READ REAL PARAMETER FROM DATA CARD CHARACTER STRING
C  ERRORS ARE INDICATED BY WRITING A '!' IN LINE(1:1)
C  THIS SUBROUTINE IS CALLED FROM DATAC.
C  ARGUMETNS:
C   LINE   = CHARACTER STRING OF INPUT LINE
C   IS     = POINTER FOR START OF INTERPRETATION OF 'LINE'
C   RVAL   = REAL VARIABLE TO BE RETURNED
C   KEYWORD= KEYWORD AT BEGIN OF LINE
C   IKEY   = NUMBER OF ARGUMENT AFTER KEYWORD
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      REAL             RVAL
      INTEGER          I,IE,IKEY,IS,L
      CHARACTER        CFMTR*8,LINE*(*),KEYWRD*(*)
      SAVE
C-----------------------------------------------------------------------

      IF ( IS .LE. 0 ) IS = LEN(KEYWRD)

      L = LEN(LINE)
      DO  I = IS+1, L
        IF ( LINE(I:I) .NE. ' ' ) GOTO 11
      ENDDO
   11 IF ( I .GT. L  .OR.  LINE(I:I) .EQ. '!'
     *               .OR.  LINE(I:I) .EQ. ' ' ) THEN
        IF ( IKEY .LE. 1 ) THEN
          WRITE(MONIOU,6000) KEYWRD
 6000     FORMAT(1X,'DATACARD ',A,' HAS NO PARAMETER(S)')
        ELSE
          WRITE(MONIOU,6001) KEYWRD,IKEY
 6001     FORMAT(1X,'DATACARD ',A,' PARAMETER',I2,' IS MISSING')
        ENDIF
        RVAL      = 0.
        LINE(1:1) = '!'
        RETURN
      ENDIF
      IS = I
      DO  I = IS+1, L
        IF ( LINE(I:I) .EQ. ' '  .OR.  LINE(I:I) .EQ. '!' ) GOTO 21
      ENDDO
   21 IF ( LINE(I:I) .EQ. ' '  .OR.  LINE(I:I) .EQ. '!' ) THEN
        IE = I-1
      ELSE
        IE = I
      ENDIF
*     WRITE(*,*) 'DTCRL : ',KEYWRD,' #',IKEY,IS,IE,': ',LINE(IS:IE)
      IF ( IE-IS+1 .LT. 10 ) THEN
        CFMTR = '(F .0)'
        WRITE(CFMTR(3:3),'(I1)') IE-IS+1
      ELSE
        CFMTR = '(F  .0)'
        WRITE(CFMTR(3:4),'(I2)') IE-IS+1
      ENDIF
      READ(LINE(IS:IE),CFMTR,ERR=999) RVAL

      IF ( DEBUG ) WRITE(MDEBUG,*) 'DTCRL : VALUE = ',RVAL
      IS = IE

      RETURN

  999 WRITE(MONIOU,6002) KEYWRD,IKEY,LINE(IS:IE)
 6002 FORMAT(1X,'DATACARD ',A,' PARAMETER',I2,' IS INVALID: ',A)
      RVAL      = 0.
      LINE(1:1) = '!'
      IS        = IE

      IF ( DEBUG ) WRITE(MDEBUG,*) 'DTCRL : VALUE = ',RVAL

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE EM

C-----------------------------------------------------------------------
C  E(LECTRO) M(AGNETIC PARTICLES)
C
C  ROUTINE FOR TREATING EM PARTICLES
C  THIS SUBROUTINE IS CALLED FROM BOX3.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRGENER/ GEN,ALEVEL
      DOUBLE PRECISION GEN,ALEVEL

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION ENER,THICK
      INTEGER          I
      SAVE
      EXTERNAL         THICK
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) (CURPAR(I),I=0,9)
  444 FORMAT(' EM    : CURPAR=',1P,9E11.3,0P,F6.0)

C  GET CORRECT PARTICLE ENERGY
      IF     ( ITYPE  .EQ. 1 ) THEN
        ENER = CURPAR(1)
      ELSEIF ( ITYPE .EQ. 2  .OR.  ITYPE .EQ. 3 ) THEN
        ENER = CURPAR(1) * PAMA(2)
      ELSE
        WRITE(MONIOU,*) 'EM    : WRONG PARTICLE CODE =',ITYPE
        RETURN
      ENDIF

C  COPY PARTICLE COORDINATES INTO SECPAR
      DO  I = 0, 8
        SECPAR(I) = CURPAR(I)
      ENDDO
      SECPAR( 9) = GEN
      SECPAR(10) = ALEVEL

      SECPAR(14) = CURPAR(14)
      SECPAR(15) = CURPAR(15)
      SECPAR(16) = CURPAR(16)

C  CALL NKG IF SELECTED
      IF ( FNKG ) CALL NKG( ENER )

C  CALL EGS4 IF SELECTED (PARTICLE IS TAKEN IN EGS FROM CURPAR)
      IF ( FEGS ) THEN
        CALL EGS4( ENER )
      ELSE
        IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

          LHEIGH = INT( THICK( H )*THSTPI + 1.D0 )

          IF     ( SECPAR(0) .EQ. 1.D0 ) THEN

            DLONG(LHEIGH,1) = DLONG(LHEIGH,1) + ENER
          ELSEIF ( SECPAR(0) .EQ. 2.D0 ) THEN
            DLONG(LHEIGH,3) = DLONG(LHEIGH,3) + (ENER+PAMA(2))
          ELSE
            DLONG(LHEIGH,3) = DLONG(LHEIGH,3) + (ENER-PAMA(2))

          ENDIF
        ENDIF
      ENDIF

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE ETADEC

C-----------------------------------------------------------------------
C  ETA DEC(AY)
C
C  ROUTINE TREATES DECAY OF ETA
C  DECAY WITH FULL KINEMATIC, ENERGY AND MOMENTA CONSERVED
C  THIS SUBROUTINE IS CALLED FROM NUCINT.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRDECAYC/GAM345,COS345,PHI345
      DOUBLE PRECISION GAM345(3),COS345(3),PHI345(3)

      COMMON /CREDECAY/CETA
      DOUBLE PRECISION CETA(5)

      COMMON /CRGENER/ GEN,ALEVEL
      DOUBLE PRECISION GEN,ALEVEL

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION AUX1,AUX2,COSTH1,COSTH2,EETA2,FI1
      INTEGER          I

      SAVE
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) (CURPAR(I),I=0,9)
  444 FORMAT(' ETADEC: CURPAR=',1P,10E11.3)

C  SELECT MODE OF DECAY, IF NOT ALREADY SELECTED BY THE PARTICLE TYPE
      IF ( ITYPE .EQ. 17 ) THEN
        CALL RMMARD( RD,1,1 )
        IF     ( RD(1) .LE. CETA(1) ) THEN
          ITYPE = 71
        ELSEIF ( RD(1) .LE. CETA(2) ) THEN
          ITYPE = 72
        ELSEIF ( RD(1) .LE. CETA(3) ) THEN
          ITYPE = 73
        ELSE
          ITYPE = 74
        ENDIF
      ENDIF

C  DECAY OF ETA  WITH 4 MODES
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  DECAY    ETA  ---->  GAMMA + GAMMA
      IF     ( ITYPE .EQ. 71 ) THEN
        EETA2  = 0.5D0 * GAMMA * PAMA(17)
        CALL RMMARD( RD,2,1 )
        AUX1   = 1.D0 + BETA * RD(1)
        AUX2   = 1.D0 - BETA * RD(1)
        COSTH1 = (BETA + RD(1)) / AUX1
        COSTH2 = (BETA - RD(1)) / AUX2

        SECPAR(0) = 1.D0
C  FIRST GAMMA (WITH HIGHER ENERGY)
        SECPAR(1) = AUX1 * EETA2
        FI1       = PI2 * RD(2)
        CALL ADDANG3( COSTHE,PHIX,PHIY, COSTH1,FI1,
     *                               SECPAR(2),SECPAR(3),SECPAR(4) )

        IF ( SECPAR(2) .GT. C(29) ) THEN

          CALL TSTACK
        ELSE
          IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

            DLONG(LHEIGH,11) = DLONG(LHEIGH,11) + SECPAR(1)

          ENDIF
        ENDIF
C  SECOND GAMMA (WITH LOWER ENERGY)
        SECPAR(1) = AUX2 * EETA2
        CALL ADDANG3( COSTHE,PHIX,PHIY, COSTH2,FI1+PI,
     *                               SECPAR(2),SECPAR(3),SECPAR(4) )

        IF ( SECPAR(2) .GT. C(29) ) THEN

          CALL TSTACK
        ELSE
          IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

            DLONG(LHEIGH,11) = DLONG(LHEIGH,11) + SECPAR(1)

          ENDIF
        ENDIF

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  DECAY    ETA  ---->  PI(0) + PI(0) + PI(0)
      ELSEIF ( ITYPE .EQ. 72 ) THEN
        CALL DECAY6( PAMA(17), PAMA(7),PAMA(7),PAMA(7),
     *               0.D0,0.D0,0.D0, 1.D0, 2 )
        SECPAR(0) = 7.D0
        DO  I = 1, 3
          CALL ADDANG3( COSTHE,PHIX,PHIY, COS345(I),PHI345(I),
     *                                  SECPAR(2),SECPAR(3),SECPAR(4) )

          IF ( SECPAR(2) .GT. C(29) ) THEN

            SECPAR(1) = GAM345(I)

            CALL TSTACK
          ELSE
            IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

              DLONG(LHEIGH,17) = DLONG(LHEIGH,17) + GAM345(I) * PAMA(7)

            ENDIF
          ENDIF
        ENDDO

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  DECAY    ETA  ---->   PI(-) + PI(+) + PI(0)
      ELSEIF ( ITYPE .EQ. 73 ) THEN
        CALL DECAY6( PAMA(17), PAMA(8),PAMA(8),PAMA(7),
     *               CETA(4),0.D0,0.D0, CETA(5), 2 )
        DO  I = 1, 3
          CALL ADDANG3( COSTHE,PHIX,PHIY, COS345(I),PHI345(I),
     *                                  SECPAR(2),SECPAR(3),SECPAR(4) )

          IF ( SECPAR(2) .GT. C(29) ) THEN

            SECPAR(0) = 10 - I
            SECPAR(1) = GAM345(I)

            CALL TSTACK
          ELSE
            IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

              DLONG(LHEIGH,17) = DLONG(LHEIGH,17) + GAM345(I)*PAMA(10-I)

            ENDIF
          ENDIF
        ENDDO

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  DECAY    ETA  ---->  PI(+) + PI(-) + GAMMA
      ELSEIF ( ITYPE .EQ. 74 ) THEN
        CALL DECAY6( PAMA(17), PAMA(8),PAMA(8),0.D0,
     *               0.D0,0.D0,0.D0, 1.D0, 2 )
        DO  I = 1, 3
          CALL ADDANG3( COSTHE,PHIX,PHIY, COS345(I),PHI345(I),
     *                                 SECPAR(2),SECPAR(3),SECPAR(4) )

          IF ( SECPAR(2) .GT. C(29) ) THEN

            IF ( I .EQ. 3 ) THEN
              SECPAR(0) = 1.D0
            ELSE
              SECPAR(0) = 7 + I
            ENDIF
            SECPAR(1)   = GAM345(I)
            CALL TSTACK
          ELSE
            IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT
              IF ( I .EQ. 3 ) THEN

                DLONG(LHEIGH,11) = DLONG(LHEIGH,11) + GAM345(I)
              ELSE
                DLONG(LHEIGH,17) = DLONG(LHEIGH,17) + GAM345(I)*PAMA(8)

              ENDIF
            ENDIF
          ENDIF
        ENDDO

      ELSE
        WRITE(MONIOU,*) 'ETADEC: UNEXPECTED PARTICLE CODE ITYPE=',ITYPE
      ENDIF

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   24/06/2003
C=======================================================================

      SUBROUTINE FILOPN

C-----------------------------------------------------------------------
C  FIL(E) OP(E)N
C
C  OPENS THE FILES NEEDED FOR OUTPUT.
C  THIS SUBROUTINE IS CALLED FROM START.
C-----------------------------------------------------------------------

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)

      INCLUDE '(IOUNIT)'

      COMMON /CRBUFFS/ RUNH,RUNE,EVTH,EVTE,DATAB,ARRAYLONG,LH
      INTEGER          MAXBUF,MAXLEN
      PARAMETER        (MAXLEN=16)

      PARAMETER        (MAXBUF=39*7)
      REAL             RUNH(MAXBUF),EVTH(MAXBUF),EVTE(MAXBUF),
     *                 RUNE(MAXBUF),DATAB(MAXBUF),ARRAYLONG(MAXBUF)
      INTEGER          LH
      CHARACTER*4      CRUNH,CRUNE,CEVTH,CEVTE,CLONG
      EQUIVALENCE      (RUNH(1),CRUNH), (RUNE(1),CRUNE)
      EQUIVALENCE      (EVTH(1),CEVTH), (EVTE(1),CEVTE)
      EQUIVALENCE      (ARRAYLONG(1),CLONG)

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSTACKF/STACKI,MSTACKP,MEXST,NSHIFT,NOUREC,ICOUNT,
     *                 NTO,NFROM
      INTEGER          MAXSTK

      PARAMETER        (MAXSTK = 17*256*2)
      DOUBLE PRECISION STACKI(MAXSTK)
      INTEGER          MSTACKP,MEXST,NSHIFT,NOUREC,ICOUNT,NTO,NFROM

      INTEGER          IEBIN, ITBIN, IDBIN
      PARAMETER        (IEBIN=40,ITBIN=30,IDBIN=20)
      COMMON /CRTABLES/G_ARRAY, E_ARRAY, M_ARRAY,
     *                 EBOFF,EBFAC,TBOFF,TBFAC,DBOFF,DBFAC
      REAL             G_ARRAY(IEBIN,ITBIN,IDBIN)
      REAL             E_ARRAY(IEBIN,ITBIN,IDBIN)
      REAL             M_ARRAY(IEBIN,ITBIN,IDBIN)
      REAL             EBOFF,EBFAC,TBOFF,TBFAC,DBOFF,DBFAC
      REAL             EBMIN,EBMAX,TBMIN,TBMAX,DBMIN,DBMAX
      PARAMETER        (EBMIN=1.E-4,EBMAX=1.E4)
      PARAMETER        (TBMIN=10.,TBMAX=1.E4)
      PARAMETER        (DBMIN=5.E3,DBMAX=5.E5)

      COMMON /CRCEREN1/CERELE,CERHAD,ETADSN,WAVLGL,WAVLGU,CYIELD,
     *                 CERSIZ,CERNOR,LCERFI,LCERDB
      DOUBLE PRECISION CERELE,CERHAD,ETADSN,WAVLGL,WAVLGU,CYIELD,
     *                 CERSIZ,CERNOR
      LOGICAL          LCERFI,LCERDB

       

       

       

       

      INTEGER          IBL,L
      CHARACTER*8      RQSTAT

      LOGICAL          FEXIST,LDEVNL

      SAVE
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,*) 'FILOPN:'
C  CHECK CORRECTNESS OF RUN NUMBER
      IF ( NRRUN .GT. 999999 ) THEN
        WRITE(MONIOU,*) 'RUN NUMBER = ',NRRUN,' EXCEEDS 999999, STOP'
        STOP
      ENDIF
c--------changed----commented 
cxx------------
cxx call tobuf(runh,0) and tobufc(runh,0) are now in main program

c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>> 
c   Next block of code is obsolete.
c   Now it's used "jcio" routines (C)
C-------------------------------------

cC  OUTPUT FILES SHOULD NORMALLY NOT EXIST BEFORE THE RUN STARTS
      RQSTAT = 'NEW'
cC  LOOK FOR THE FIRST BLANK IN DATASET NAME
c      IBL = INDEX(DSN,' ')
cC  CHECK DATA SET NAME FOR CORRECTNESS
c      IF ( DSN(1:) .EQ. '~' ) THEN
c        WRITE(MONIOU,*)
c        WRITE(MONIOU,*) 'FILOPN: INCORRECT DATA SET NAME'
c        WRITE(MONIOU,*) DSN(1:IBL)
c        WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
c        WRITE(MONIOU,*) 'SEE KEYWORD: DIRECT'
c        STOP
c      ENDIF
cC  OPEN OUTPUT DATA SET FOR RUN
c      DSN(IBL:73) = 'DAT000000'
c      WRITE(DSN(IBL+3:IBL+8),'(I6)') NRRUN
c      DO  L = IBL+3, IBL+8
c        IF ( DSN(L:L) .EQ. ' ' ) DSN(L:L) = '0'
c      ENDDO
c      IF ( FTABOUT ) THEN
c        DSNTAB = DSN
c        DSNTAB(IBL+9:IBL+12) = '.tab'
c      ENDIF
c      IF ( FLONGOUT  .AND.  LLONGI ) THEN
c        IF ( DSN(1:9) .EQ. '/dev/null' ) THEN
c          DSNLONG(1:9)   = DSN(10:18)
c          DSNLONG(10:14) = '.long '
c        ELSE
c          DSNLONG = DSN
c          DSNLONG(IBL+9:IBL+13) = '.long'
c        ENDIF
c      ENDIF
c
c      IF ( FFLUDB ) THEN
c        IF ( DSN(1:9) .EQ. '/dev/null' ) THEN
c          DSNFLOUT(1:9)   = DSN(10:18)
c          DSNFLOUT(10:15) = '.flout'
c          DSNFLERR(1:9)   = DSN(10:18)
c          DSNFLERR(10:15) = '.flerr'
c        ELSE
c          DSNFLOUT = DSN
c          DSNFLOUT(IBL+9:IBL+14) = '.flout'
c          DSNFLERR  = DSN
c          DSNFLERR(IBL+9:IBL+14) = '.flerr'
c        ENDIF
c        OPEN(UNIT=LUNOUT,FORM='FORMATTED',STATUS='UNKNOWN',
c     *       FILE=DSNFLOUT)
c        OPEN(UNIT=LUNERR,FORM='FORMATTED',STATUS='UNKNOWN',
c     *       FILE=DSNFLERR)
c      ELSE
c
cC  A SECOND OPEN TO A FILE WHICH IS ALREADY CONNECTED (IN THIS CASE
cC  /dev/null) IS NOT ALLOWED BY THE PORTLAND COMPILER, ENDING IN AN
cC  ERROR AT RUN TIME. TO REDIRECT A FILE TO /dev/null USE A REDIRECTION
cC  AT RUNTIME WITH UNIX COMMANDS  setenv FORT11 /dev/null
cC                                 setenv FORT15 /dev/null
c
c      ENDIF
c      IF ( DSN(1:9) .EQ. '/dev/null' ) THEN
c        DSN    = '/dev/null'
c        RQSTAT = 'UNKNOWN'
c      ELSE
cC  ON LINUX WITH G77 AN EXISTING FILE CAUSES A CORE DUMP -> FIRST INQUIRE
c        INQUIRE(FILE=DSN,EXIST=FEXIST)
c        IF ( FEXIST ) THEN
c          IBL = INDEX(DSN,' ')
c          IF ( IBL .LE. 1 ) IBL = LEN(DSN)+1
c          WRITE(MONIOU,5791) DSN(1:IBL-1)
 5791     FORMAT(/' FILE ',A,' ALREADY EXISTS. RENAME OR REMOVE IT',
     *           ' OR CHANGE ''DIRECT'' DATA CARD AND TRY AGAIN.')
c          STOP 'FATAL PROBLEM'
c        ENDIF
c      ENDIF
c
cC  OPEN DATASET FOR PARTICLE OUTPUT
c      IF ( FPAROUT ) THEN
c        OPEN(UNIT=MPATAP,FILE=DSN,STATUS=RQSTAT,
c     *       FORM='UNFORMATTED',ACCESS='SEQUENTIAL')
c        WRITE(MONIOU,579) DSN
c 579    FORMAT(/' PARTICLE OUTPUT TO FILE : ',A79)
c
c      ENDIF
cC  OPEN DATASET FOR TABLE OUTPUT
c      IF ( FTABOUT ) THEN
c        OPEN(UNIT=MTABOUT,FILE=DSNTAB,STATUS=RQSTAT,
c     *       FORM='UNFORMATTED',ACCESS='SEQUENTIAL')
c        WRITE(MONIOU,578) DSNTAB,
c     *        IEBIN,EBMIN,EBMAX,
c     *        ITBIN,TBMIN,TBMAX,
c     *        IDBIN,DBMIN,DBMAX
c 578    FORMAT(/' TABLE OUTPUT TO FILE : ',A79/
c     *          '   ENERGY : ',I2,' BINS, RANGE :',1P,2E10.2,' GEV'/
c     *          '   TIME   : ',I2,' BINS, RANGE :',1P,2E10.2,' NS'/
c     *          '   RADIUS : ',I2,' BINS, RANGE :',1P,2E10.2,' CM')
c        WRITE(MTABOUT) IEBIN,EBMIN,EBMAX
c        WRITE(MTABOUT) ITBIN,TBMIN,TBMAX
c        WRITE(MTABOUT) IDBIN,DBMIN,DBMAX
c        EBOFF = LOG10(EBMIN)
c        EBFAC = 1./(LOG10(EBMAX/EBMIN)/IEBIN)
c        TBOFF = LOG10(TBMIN)
c        TBFAC = 1./(LOG10(TBMAX/TBMIN)/ITBIN)
c        DBOFF = LOG10(DBMIN)
c        DBFAC = 1./(LOG10(DBMAX/DBMIN)/IDBIN)
c      ENDIF
c      IF ( FLONGOUT  .AND.  LLONGI ) THEN
c        OPEN(UNIT=MLONGOUT,FILE=DSNLONG,STATUS=RQSTAT,
c     *       FORM='FORMATTED',ACCESS='SEQUENTIAL')
c        WRITE(MONIOU,5781) DSNLONG
c 5781   FORMAT(' LONGITUDINAL OUTPUT TO FILE: ',A79)
c      ENDIF

      IF ( PLOTSH ) THEN
        CPLOT = DSN
        WRITE(MONIOU,3466)CPLOT(IBL:IBL+8),CPLOT(IBL:IBL+8)
     *                   ,CPLOT(IBL:IBL+8)
 3466   FORMAT(/' ATTENTION : PLOTSH OPTION HAS BEEN SELECTED'/
     *    ' TRACK SEGMENTS FOR EACH PARTICLE ARE STORED ON' /
     *    '      ',a9,'.track_em'/
     *    '      ',a9,'.track_mu   AND'/
     *    '      ',a9,'.track_hd'/
     *    ' NEEDS LOTS OF DISK SPACE !!!'/
     *    ' CALCULATE NOT MORE THAN 1 EVENT AT A TIME !'/)

        CPLOT(IBL+9:IBL+18) = '.track_em'
        OPEN(UNIT=55,FILE=CPLOT,FORM='UNFORMATTED',STATUS='UNKNOWN')
        CPLOT(IBL+9:IBL+18) = '.track_mu'
        OPEN(UNIT=56,FILE=CPLOT,FORM='UNFORMATTED',STATUS='UNKNOWN')
        CPLOT(IBL+9:IBL+18) = '.track_hd'
        OPEN(UNIT=57,FILE=CPLOT,FORM='UNFORMATTED',STATUS='UNKNOWN')

        NPLEM  = 0
        NPLMU  = 0
        NPLHAD = 0
      ENDIF
cC  OPEN OUTPUT DATA SET FOR CHERENKOV PHOTONS
c      IF ( LCERFI ) THEN
c        DSN(IBL:73) = 'CER000000'
c        WRITE(DSN(IBL+3:IBL+8),'(I6)') NRRUN
c        DO  L = IBL+3, IBL+8
c          IF ( DSN(L:L) .EQ. ' ' ) DSN(L:L) = '0'
c        ENDDO
c
c        IF ( DSN(1:9) .EQ. '/dev/null' ) THEN
c          DSN    = '/dev/null'
c          RQSTAT = 'UNKNOWN'
c        ELSE
cC  ON LINUX WITH G77 AN EXISTING FILE CAUSES A CORE DUMP -> FIRST INQUIRE
c          INQUIRE(FILE=DSN,EXIST=FEXIST)
c          IF ( FEXIST ) THEN
c            IBL = INDEX(DSN,' ')
c            IF ( IBL .LE. 1 ) IBL = LEN(DSN)+1
c            WRITE(MONIOU,5791) DSN(1:IBL-1)
c            STOP 'FATAL PROBLEM'
c          ENDIF
c        ENDIF

c        OPEN(UNIT=MCETAP,FILE=DSN,STATUS=RQSTAT,
c     *       FORM='UNFORMATTED',ACCESS='SEQUENTIAL')
c        WRITE(MONIOU,580) DSN
c 580    FORMAT(' CHERENKOV OUTPUT TO FILE : ',A79)
c      ELSE
c        WRITE(MONIOU,580) DSN
c      ENDIF

C  RESET DSN
c      DSN(IBL:73) = '         '

C  OPEN THE EXTERNAL STACK
C  BLOCKS OF 32448 BYTES = 4056 REAL*8 = 312 PARTICLES FOR THINNING
C  BLOCKS OF 32640 BYTES = 4080 REAL*8 = 340 PARTICLES FOR STANDARD

C  FOR MOST FORTRAN COMPILERS ON UNIX-LIKE SYSTEMS (GNU g77, HP,
C  IBM RS6000) IT IS NECESSARY TO USE THE NUMBER OF BYTES FOR THE RECL
C  PARAMETER.
      CALL RCLCHK( MEXST,1,L )
      IF ( L .NE. 0 ) THEN
        WRITE(MONIOU,*) 'FATAL ERROR:',L,
     *                  '  RECL HANDLING NOT AS EXPECTED'
        STOP
      ENDIF
      OPEN(UNIT=MEXST,STATUS='SCRATCH',
     *     FORM='UNFORMATTED',ACCESS='DIRECT',RECL=4*MAXSTK)
C-----------------------------------------------------------------------

C  WRITE DATA SET FOR INFORMATION BANK
      IF ( FDBASE ) THEN
C  OPEN OUTPUT DATA SET FOR RUN
        IBL = INDEX(DSN,' ')
C  IF NORMAL OUTPUT DISABLED BUT 'DATBAS T', TRY CURRENT DIRECTORY.
        LDEVNL = .FALSE.
        IF ( DSN(1:9) .EQ. '/dev/null' ) THEN
          LDEVNL = .TRUE.
          IBL = 1
        ENDIF

        DSN(IBL:79) = 'DAT000000.dbase'

        WRITE(DSN(IBL+3:IBL+8),'(I6)') NRRUN
        DO  L = IBL+3, IBL+8
          IF ( DSN(L:L) .EQ. ' ' ) DSN(L:L) = '0'
        ENDDO
        IF ( DSN(1:9) .EQ. '/dev/null' ) THEN
          DSN    = '/dev/null'
          RQSTAT = 'UNKNOWN'
        ELSE
C  ON LINUX WITH G77 AN EXISTING FILE CAUSES A CORE DUMP -> FIRST INQUIRE
          INQUIRE(FILE=DSN,EXIST=FEXIST)
          IF ( FEXIST ) THEN
            IBL = INDEX(DSN,' ')
            IF ( IBL .LE. 1 ) IBL = LEN(DSN)+1
            WRITE(MONIOU,5791) DSN(1:IBL-1)
            STOP 'FATAL PROBLEM'
          ENDIF
        ENDIF
        OPEN(UNIT=MDBASE,FILE=DSN,STATUS=RQSTAT)
        WRITE(MONIOU,581) DSN
 581    FORMAT(/' DBASE OUTPUT TO FILE : ',A79)

        LSTDSN(1:3) = 'LST'
        LSTDSN(4:9) = DSN(IBL+3:IBL+8)
C  RESET DSN TO '/dev/null' AS IT WAS BEFORE.
        IF ( LDEVNL ) DSN = '/dev/null'
        IF (IBL .EQ. 1 ) DSN = '$cwd'
C  RESET DSN
        DSN(IBL+9:IBL+14) = '      '
C  THE MDBASE FILE IS CLOSED IN AAMAIN
      ENDIF
      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE FSTACK

C-----------------------------------------------------------------------
C  F(ROM) STACK
C
C  GETS PARTICLE FROM STACK AND READS FROM DISK IF NECESSARY.
C  THIS SUBROUTINE IS CALLED FROM AAMAIN.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRBUFFS/ RUNH,RUNE,EVTH,EVTE,DATAB,ARRAYLONG,LH
      INTEGER          MAXBUF,MAXLEN
      PARAMETER        (MAXLEN=16)

      PARAMETER        (MAXBUF=39*7)
      REAL             RUNH(MAXBUF),EVTH(MAXBUF),EVTE(MAXBUF),
     *                 RUNE(MAXBUF),DATAB(MAXBUF),ARRAYLONG(MAXBUF)
      INTEGER          LH
      CHARACTER*4      CRUNH,CRUNE,CEVTH,CEVTE,CLONG
      EQUIVALENCE      (RUNH(1),CRUNH), (RUNE(1),CRUNE)
      EQUIVALENCE      (EVTH(1),CEVTH), (EVTE(1),CEVTE)
      EQUIVALENCE      (ARRAYLONG(1),CLONG)

      COMMON /CRETHMAP/ECTMAP,ELEFT
      DOUBLE PRECISION ECTMAP,ELEFT

      COMMON /CRGENER/ GEN,ALEVEL
      DOUBLE PRECISION GEN,ALEVEL

      COMMON /CRIRET/  IRET1,IRET2,IRETE
      INTEGER          IRET1,IRET2
      LOGICAL          IRETE

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRPOLAR/ POLART,POLARF
      DOUBLE PRECISION POLART,POLARF

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSTACKF/STACKI,MSTACKP,MEXST,NSHIFT,NOUREC,ICOUNT,
     *                 NTO,NFROM
      INTEGER          MAXSTK

      PARAMETER        (MAXSTK = 17*256*2)
      DOUBLE PRECISION STACKI(MAXSTK)
      INTEGER          MSTACKP,MEXST,NSHIFT,NOUREC,ICOUNT,NTO,NFROM

       

       

       

       

      INTEGER          I,ISTK,J
      SAVE
      DATA             ISTK / MAXSTK /
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,220) ICOUNT-1
 220  FORMAT(' FSTACK:',I7)

C  STACK EMPTY, SOMETHING TO BE READ FROM DISK ?
      IF ( MSTACKP .EQ. 0 ) THEN
        IF ( NOUREC .EQ. 0 ) THEN
          IF ( FPRINT  .OR.  DEBUG ) WRITE(MONIOU,224) NTO,NFROM
 224      FORMAT(/' NO MORE SECONDARIES FOUND ON STACK'/
     *            ' ',I10,' PARTICLES WRITTEN TO STACK'/
     *            ' ',I10,' PARTICLES READ FROM STACK' )
          CURPAR(0) = 0.D0
          IRET1 = 1
          RETURN
        ENDIF

C  READ LAST BLOCK OF 256 PARTICLES FROM SCRATCH FILE

        READ(MEXST,REC=NOUREC) (STACKI(I),I=1,ISTK/2)
        NOUREC  = NOUREC - 1
        MSTACKP = ISTK/2
      ENDIF

      NFROM  = NFROM + 1
      ICOUNT = ICOUNT - 1

C  PUT PARTICLE FROM STACK INTO CURPAR
      MSTACKP = MSTACKP - MAXLEN - 1
      DO  J = 0, 8
        CURPAR(J) = STACKI(MSTACKP+J+1)
      ENDDO
      GEN    = STACKI(MSTACKP+10)
      ALEVEL = STACKI(MSTACKP+11)
      POLART = STACKI(MSTACKP+12)
      POLARF = STACKI(MSTACKP+13)

      CURPAR(14) = STACKI(MSTACKP+15)
      CURPAR(15) = STACKI(MSTACKP+16)
      CURPAR(16) = STACKI(MSTACKP+17)

      IF ( PAMA(NINT( CURPAR(0) )) .NE. 0.D0 ) THEN
        ELEFT = ELEFT - CURPAR(1)*PAMA(NINT( CURPAR(0) ))
      ELSE
        ELEFT = ELEFT - CURPAR(1)
      ENDIF
      IF ( DEBUG ) WRITE(MDEBUG,667) ICOUNT,(CURPAR(J),J=0,8)
  667 FORMAT('+       ',I7,1X,1P,9E11.3)

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      DOUBLE PRECISION FUNCTION HEIGH( ARG )

C-----------------------------------------------------------------------
C  HEIGH(T AS FUNCTION OF THICKNESS)
C
C  CALCULATES HEIGHT DEPENDING ON THICKNESS OF ATMOSPHERE
C  THIS FUNCTION IS CALLED FROM AAMAIN, BOX2, BOX3, COOINC, INPRM,
C  MUTRAC, PRANGC, STAEND, THICKC, UPDATC, UPDATE, EGSIN1, AND ININKG
C  ARGUMENT:
C   ARG    = MASS OVERLAY IN G/CM**2
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRATMOS/ AATM,AATM0,BATM,BATM0,CATM,CATM0,DATM,MODATM
      DOUBLE PRECISION AATM(5),AATM0(5,0:22),BATM(5),BATM0(5,0:22),
     *                 CATM(5),CATM0(5,0:22),DATM(5)
      INTEGER          MODATM

      COMMON /CRATMOS2/HLAY,HLAY0,THICKL,LAYNO,LAYNEW
      DOUBLE PRECISION HLAY(6),HLAY0(5,0:9),THICKL(5)
      INTEGER          LAYNO(0:22)
      LOGICAL          LAYNEW

C  EXTERNAL ATMOSPHERIC MODELS
      COMMON /CRATMOSX/IATMOX,FREFRX
      INTEGER          IATMOX
      LOGICAL          FREFRX

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION ARG
      SAVE

      DOUBLE PRECISION HEIGHX
      EXTERNAL         HEIGHX

C-----------------------------------------------------------------------

CC    IF ( DEBUG ) WRITE(MDEBUG,*) 'HEIGH : ARG=',SNGL(ARG)

      IF ( IATMOX .GE. 1 ) THEN
        HEIGH = HEIGHX(ARG)
        RETURN
      ENDIF

      IF     ( ARG .GT. THICKL(2) ) THEN
        HEIGH = CATM(1) * LOG ( BATM(1) / (ARG - AATM(1)) )
      ELSEIF ( ARG .GT. THICKL(3) ) THEN
        HEIGH = CATM(2) * LOG ( BATM(2) / (ARG - AATM(2)) )
      ELSEIF ( ARG .GT. THICKL(4) ) THEN
        HEIGH = CATM(3) * LOG ( BATM(3) / (ARG - AATM(3)) )
      ELSEIF ( ARG .GT. THICKL(5) ) THEN
        HEIGH = CATM(4) * LOG ( BATM(4) / (ARG - AATM(4)) )
      ELSE
        HEIGH = (AATM(5) - ARG) * CATM(5)
      ENDIF

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

c-----changed
      SUBROUTINE INPRM(icerml1)
c-----changed

C-----------------------------------------------------------------------
C  IN(PUT) PR(I)M(ARY)
C
C  TAKES INPUT PRIMARY ENERGY FROM SPECIFIED SPECTRUM
C  CHECKS INPUT VARIABLES FOR CONSISTENCY AND LIMITATIONS
C  WRITES DATA BASE FILE
C  INITIALIZES CHERENKOV, IF CERENKOV OPTION SELECTED.
C  THIS SUBROUTINE IS CALLED FROM AAMAIN.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRATMOS/ AATM,AATM0,BATM,BATM0,CATM,CATM0,DATM,MODATM
      DOUBLE PRECISION AATM(5),AATM0(5,0:22),BATM(5),BATM0(5,0:22),
     *                 CATM(5),CATM0(5,0:22),DATM(5)
      INTEGER          MODATM

      COMMON /CRATMOS2/HLAY,HLAY0,THICKL,LAYNO,LAYNEW
      DOUBLE PRECISION HLAY(6),HLAY0(5,0:9),THICKL(5)
      INTEGER          LAYNO(0:22)
      LOGICAL          LAYNEW

C  EXTERNAL ATMOSPHERIC MODELS
      COMMON /CRATMOSX/IATMOX,FREFRX
      INTEGER          IATMOX
      LOGICAL          FREFRX

      COMMON /CRBUFFS/ RUNH,RUNE,EVTH,EVTE,DATAB,ARRAYLONG,LH
      INTEGER          MAXBUF,MAXLEN
      PARAMETER        (MAXLEN=16)

      PARAMETER        (MAXBUF=39*7)
      REAL             RUNH(MAXBUF),EVTH(MAXBUF),EVTE(MAXBUF),
     *                 RUNE(MAXBUF),DATAB(MAXBUF),ARRAYLONG(MAXBUF)
      INTEGER          LH
      CHARACTER*4      CRUNH,CRUNE,CEVTH,CEVTE,CLONG
      EQUIVALENCE      (RUNH(1),CRUNH), (RUNE(1),CRUNE)
      EQUIVALENCE      (EVTH(1),CEVTH), (EVTE(1),CEVTE)
      EQUIVALENCE      (ARRAYLONG(1),CLONG)

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRDPMFLG/NFLAIN,NFLDIF,NFLPI0,NFLCHE,NFLPIF,NFRAGM
      INTEGER          NFLAIN,NFLDIF,NFLPI0,NFLCHE,NFLPIF,NFRAGM

      COMMON /CRELABCT/ELCUT
      DOUBLE PRECISION ELCUT(4)

      COMMON /CRETHMAP/ECTMAP,ELEFT
      DOUBLE PRECISION ECTMAP,ELEFT

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRMAGANG/ARRANG,ARRANR,COSANG,SINANG
      DOUBLE PRECISION ARRANG,ARRANR,COSANG,SINANG

      COMMON /CRMAGNET/BX,BZ,BVAL,BNORMC,BNORM,COSB,SINB,BLIMIT
      DOUBLE PRECISION BX,BZ,BVAL,BNORMC,BNORM,COSB,SINB,BLIMIT

      COMMON /CRNKGI/  SEL,SELLG,STH,ZEL,ZELLG,ZSL,DIST,
     *                 DISX,DISY,DISXY,DISYX,DLAX,DLAY,DLAXY,DLAYX,
     *                 OBSATI,RADNKG,RMOL,TLEV,TLEVCM,IALT
      DOUBLE PRECISION SEL(10),SELLG(10),STH(10),ZEL(10),ZELLG(10),
     *                 ZSL(10),DIST(10),
     *                 DISX(-10:10),DISY(-10:10),
     *                 DISXY(-10:10,2),DISYX(-10:10,2),
     *                 DLAX (-10:10,2),DLAY (-10:10,2),
     *                 DLAXY(-10:10,2),DLAYX(-10:10,2),
     *                 OBSATI(2),RADNKG,RMOL(2),TLEV(10),TLEVCM(10)
      INTEGER          IALT(2)

      COMMON /CROBSPAR/OBSLEV,THCKOB,XOFF,YOFF,HEIGHP,THETAP,PHIP,
     *                 THETPR,PHIPR,

     *                 VUECON,

     *                 NOBSLV
      DOUBLE PRECISION OBSLEV(20),THCKOB(20),XOFF(20),YOFF(20),
     *                 HEIGHP,THETAP,THETPR(2),PHIP,PHIPR(2)

      DOUBLE PRECISION VUECON(2)

      INTEGER          NOBSLV

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRPRIMSP/PSLOPE,LLIMIT,ULIMIT,LL,UL,SLEX,ISPEC
      DOUBLE PRECISION PSLOPE,LLIMIT,ULIMIT,LL,UL,SLEX
      INTEGER          ISPEC

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRREJECT/AVNREJ,ALTMIN,ANEXP,THICKA,THICKD,CUTLN,EONCUT,

     *                 FNPRIM
      DOUBLE PRECISION AVNREJ(20),ALTMIN(20),ANEXP(20),THICKA(20),
     *                 THICKD(20),CUTLN,EONCUT

      LOGICAL          FNPRIM

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRVERS/  VERNUM,MVDATE,VERDAT
      DOUBLE PRECISION VERNUM
      INTEGER          MVDATE
      CHARACTER*18     VERDAT

      COMMON /CRCEREN1/CERELE,CERHAD,ETADSN,WAVLGL,WAVLGU,CYIELD,
     *                 CERSIZ,CERNOR,LCERFI,LCERDB
      DOUBLE PRECISION CERELE,CERHAD,ETADSN,WAVLGL,WAVLGU,CYIELD,
     *                 CERSIZ,CERNOR
      LOGICAL          LCERFI,LCERDB

      COMMON /CRCEREN2/ACERX,ACERY,CERXOS,CERYOS,
     *                 DCERX,DCERXI,DCERY,DCERYI,EPSX,EPSY,FCERX,FCERY,
     *                 WL,XCMAX,XCMAXS,XSCATT,YCMAX,YCMAXS,YSCATT,
     *                 PHOTCM,XCER,YCER,UEMIS,VEMIS,WEMIS,CARTIM,
     *                 XEMIS,YEMIS,ZEMIS,XSTEP,YSTEP,ZSTEP,
     *                 XSTEP2,YSTEP2,ZSTEP2,

     *                 NCERX,NCERY,ICERML
      DOUBLE PRECISION ACERX,ACERY,CERXOS(20),CERYOS(20),
     *                 DCERX,DCERXI,DCERY,DCERYI,EPSX,EPSY,FCERX,FCERY,
     *                 WL,XCMAX,XCMAXS,XSCATT,YCMAX,YCMAXS,YSCATT
      DOUBLE PRECISION PHOTCM,XCER,YCER,UEMIS,VEMIS,WEMIS,CARTIM,
     *                 XEMIS,YEMIS,ZEMIS,XSTEP,YSTEP,ZSTEP,
     *                 XSTEP2,YSTEP2,ZSTEP2

      INTEGER          NCERX,NCERY,ICERML

       

       

       

       

      COMMON /CRQGSC/  LEVLDQ,IQGSVER,FQGS,FQGSSG
      INTEGER          LEVLDQ,IQGSVER
      LOGICAL          FQGS,FQGSSG

      DOUBLE PRECISION EFRAC,VERVEN
      INTEGER          IDPM,ILONG,ILTHIN,ISO
      CHARACTER*1      MARK

      DOUBLE PRECISION H0
      DOUBLE PRECISION HEIGH,THICK

      INTEGER          I

      INTEGER          IFREFRX
c-----changed
      INTEGER icerml1
c-----changed

      SAVE
      EXTERNAL         HEIGH,THICK

C-----------------------------------------------------------------------

      WRITE(MONIOU,504)
  504 FORMAT(/,/' ',10('='),' SHOWER PARAMETERS ', 50('=') )

C  WRITE ENERGY SPECTRUM TO HEADER
      RUNH(16) = PSLOPE
      RUNH(17) = LLIMIT
      RUNH(18) = ULIMIT

      EVTH(58) = PSLOPE
      EVTH(59) = LLIMIT
      EVTH(60) = ULIMIT

      IF ( PRMPAR(0) .GE. 5700.D0  .OR.  PRMPAR(0) .LE. 0.D0 ) THEN
        WRITE(MONIOU,*)
        WRITE(MONIOU,*)'INCORRECT SELECTION OF PRIMARY PARTICLE TYPE = '
     *                  ,INT( PRMPAR(0) )
        WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
        WRITE(MONIOU,*) 'SEE KEYWORD: PRMPAR'
        STOP
      ENDIF
C  CHECK WHETHER NUCLEUS IS A SINGLE NUCLEON
      IF ( PRMPAR(0) .EQ. 100.D0 ) PRMPAR(0) = 13.D0
      IF ( PRMPAR(0) .EQ. 101.D0 ) PRMPAR(0) = 14.D0

      WRITE(MONIOU,*) 'PRIMARY PARTICLE IDENTIFICATION IS ',
     *                NINT( PRMPAR(0) )

C  CHECK RECOMMENDED ENERGY RANGE

C CHECK ENERGY RANGE FOR CROSS-SECTIONS

      IF ( .NOT. FQGSSG  .AND.  ULIMIT .GT. 1.D8 ) THEN

        WRITE(MONIOU,*) ' WARNING: P-AIR CROSS-SECTION DOUBTFULL ',
     *               'FOR ENERGIES ABOVE 10**17 EV'
      ENDIF

      IF ( PRMPAR(0) .GE. 200.D0 ) THEN

        IF ( GHEISH ) THEN
C  GHEISHA CANNOT TREAT NUCLEI

          IF ( LLIMIT .LT. HILOELB * INT( PRMPAR(0)/100.D0 ) ) THEN
            WRITE(MONIOU,503) INT( PRMPAR(0)/100.D0 ),LLIMIT
  503       FORMAT(' NUCLEUS WITH A =',I2,' AND PRIMARY ENERGY =',1P,
     *        E10.3,' GEV IS TOO LOW FOR HIGH ENERGY INTERACTION MODEL'/
     *        ' AND CANNOT BE TREATED BY LOW ENERGY INTERACTION MODEL'/
     *        ' SIMPLE SUPERPOSITION MODEL IS USED',0P/)
            WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
            WRITE(MONIOU,*) 'SEE KEYWORD: ERANGE'
**          STOP
          ENDIF
        ENDIF
      ENDIF

C  DEFINE ENERGY RANGE AND ENERGY SPECTRUM OF PRIMARY
      IF     ( LLIMIT .GT. ULIMIT ) THEN
        WRITE(MONIOU,501) LLIMIT,ULIMIT
  501   FORMAT(' ERROR IN PRIMARY ENERGY SPECIFICATION:',/,
     *    ' LLIMIT=',1P,E10.3,' IS LARGER THAN ULIMIT=',E10.3,' STOP')
        STOP
      ELSEIF ( LLIMIT .EQ. ULIMIT ) THEN
        ISPEC = 0
        WRITE(MONIOU,506) LLIMIT
  506   FORMAT(' PRIMARY ENERGY IS FIXED AT           ',1PE10.3,
     *         ' GEV' )
      ELSE
        ISPEC = 1
        WRITE(MONIOU,505) PSLOPE,LLIMIT,ULIMIT
  505   FORMAT(' PRIMARY ENERGY IS TAKEN FROM SPECTRUM VIA MONTE CARLO'/
     *  5X,' SLOPE OF PRIMARY SPECTRUM                = ',1P,E10.3/
     *  5X,' LOWER LIMIT CUT-OFF FOR PRIMARY SPECTRUM = ',E10.3,' GEV'/
     *  5X,' UPPER LIMIT CUT-OFF FOR PRIMARY SPECTRUM = ',E10.3,' GEV'/)
        IF ( PSLOPE .NE. -1.D0 ) THEN
          LL   = LLIMIT ** (PSLOPE + 1.D0)
          UL   = ULIMIT ** (PSLOPE + 1.D0)
          SLEX = 1.D0 / (PSLOPE + 1.D0)
        ELSE
          LL   = ULIMIT / LLIMIT
        ENDIF
      ENDIF

C  FIRST INTERACTION TARGET FIXED ?
*     IF     ( N1STTR .EQ. 1 ) THEN
*       WRITE(MONIOU,508) 'NITROGEN'
*508    FORMAT(' TARGET OF FIRST INTERACTION IS FIXED TO   ',A8)
*     ELSEIF ( N1STTR .EQ. 2 ) THEN
*       WRITE(MONIOU,508) 'OXYGEN  '
*     ELSEIF ( N1STTR .EQ. 3 ) THEN
*       WRITE(MONIOU,508) 'ARGON   '
*     ELSE
*       N1STTR = 0

*       WRITE(MONIOU,*) 'TARGET OF FIRST INTERACTION IS CHOSEN RANDOMLY'

*     ENDIF

C  CHECK ANGULAR SETTINGS
      IF ( THETPR(1) .LT. 0.D0 ) THEN
        WRITE(MONIOU,*)
        WRITE(MONIOU,*) 'UNALLOWED CHOICE OF THETPR = ',SNGL(THETPR(1)),
     *                  ' DEGREES'
        WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
        WRITE(MONIOU,*) 'SEE KEYWORD: THETAP'
        STOP
      ENDIF
      IF ( THETPR(2) .GT. 88.D0 ) THEN
        WRITE(MONIOU,*)
        WRITE(MONIOU,*) 'UNALLOWED CHOICE OF THETPR = ',SNGL(THETPR(2)),
     *                  ' DEGREES'
        WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
        WRITE(MONIOU,*) 'SEE KEYWORD: THETAP'
        STOP
      ENDIF
C  INCIDENCE ANGLE FIXED ?
      IF ( THETPR(1) .EQ. THETPR(2) .AND. PHIPR(1) .EQ. PHIPR(2) ) THEN
        FIXINC = .TRUE.

      ELSE
        FIXINC = .FALSE.
        WRITE(MONIOU,527) THETPR,PHIPR
  527   FORMAT(' THETA OF INCIDENCE CHOSEN FROM ',F10.2,'...',F10.2,
     *         ' DEGREES'/
     *         ' ANGULAR THETA DEPENDENCE ACCORDING TO FLAT DETECTOR'/
     *         ' PHI   OF INCIDENCE CHOSEN FROM ',F10.2,'...',F10.2,
     *         ' DEGREES')

      ENDIF

      IF     ( VUECON(2) .LT. 0.D0 ) THEN
        WRITE(MONIOU,*)
        WRITE(MONIOU,*) 'UNALLOWED CHOICE OF VUECON = ',
     *              SNGL(VUECON(1)),SNGL(VUECON(2)),' DEGREES < 0.'
        WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
        WRITE(MONIOU,*) 'SEE KEYWORD: VIEWCONE'
        STOP
      ELSEIF ( VUECON(2) .GT. 0.D0 ) THEN
        IF ( .NOT. FIXINC ) THEN
          WRITE(MONIOU,*)
          WRITE(MONIOU,*) 'THE VIEWCONE OPTION REQUIRES FIXED THETA',
     *           ' AND PHI VALUES.'
          WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
          WRITE(MONIOU,*) 'SEE KEYWORD: VIEWCONE'
          STOP
        ENDIF

        IF ( ABS(THETPR(2)-VUECON(2)) .GT. 88.D0-0.1D0 ) THEN

          WRITE(MONIOU,*)
          WRITE(MONIOU,*) 'UNALLOWED COMBINATION OF THETA AND ',
     *        'VIEWCONE'
          WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
          WRITE(MONIOU,*) 'SEE KEYWORD: VIEWCONE AND THETAP'
          STOP
        ENDIF
        WRITE(MONIOU,519) THETPR(1),PHIPR(1),ABS(VUECON(1)),VUECON(2)
 519    FORMAT(' THETA OF VIEWING CONE IS FIXED TO ',F10.2,' DEGREES'/
     *        ' PHI   OF VIEWING CONE IS FIXED TO ',F10.2,' DEGREES'/
     *        ' VIEWING CONE HAS INNER OPENING OF +-',F10.2,' DEGREES'/
     *        ' VIEWING CONE HAS OUTER OPENING OF +-',F10.2,' DEGREES'/)

        IF ( THETPR(2)+VUECON(2) .GT. 88.D0 ) THEN

          WRITE(MONIOU,528)
  528     FORMAT(' A VIEWING CONE WAS CHOSEN WHICH DOES NOT FIT ',
     *      'ENTIRELY INTO THE ALLOWED RANGE',/,
     *      'OF ZENITH ANGLES. ONLY SHOWERS IN THE ALLOWED RANGE ARE ',
     *      'GENERATED BY CORSIKA.')
        ENDIF

      ENDIF

      EVTH(81) = THETPR(1)
      EVTH(82) = THETPR(2)
      EVTH(83) = PHIPR(1)
      EVTH(84) = PHIPR(2)
c      print *,'EVTH(81)',EVTH(81)
c      print *,'EVTH(82)',EVTH(82)
c      print *,'EVTH(83)',EVTH(83)
c      print *,'EVTH(84)',EVTH(84)

      THETPR(1) = THETPR(1)*PI/180.D0
      THETPR(2) = THETPR(2)*PI/180.D0
      PHIPR(1)  = PHIPR(1) *PI/180.D0
      PHIPR(2)  = PHIPR(2) *PI/180.D0

      VUECON(1) = VUECON(1)*PI/180.D0
      VUECON(2) = VUECON(2)*PI/180.D0

C-----------------------------------------------------------------------
C  PRMPAR, OBSLEV, NOBSLV
      PRMPAR(1) = 0.D0
      PRMPAR(6) = 0.D0
      PRMPAR(7) = 0.D0
      PRMPAR(8) = 0.D0

C  CHECK WHETHER OBSERVATION LEVELS ARE IN ALLOWED RANGE
      DO  I = 1, NOBSLV
        IF ( OBSLEV(I) .GT. HLAY(6)-1.D2 ) THEN
          WRITE(MONIOU,120) I,OBSLEV(I),HLAY(6)-1.D2
 120      FORMAT(' UNALLOWED CHOICE OF OBSLEV '/' OBSERVATION LEVEL ',
     *           I2,' IS AT ',F12.3,' CM, WHICH IS ABOVE',
     *           F12.3,' CM'/,/' PLEASE READ THE USERS GUIDE')
          WRITE(MONIOU,*) 'SEE KEYWORD: OBSLEV'
          STOP
        ENDIF
        IF ( OBSLEV(I) .LT. HLAY(1) ) THEN
          WRITE(MONIOU,121) I,OBSLEV(I)
 121      FORMAT(' UNALLOWED CHOICE OF OBSLEV '/' OBSERVATION LEVEL ',
     *          I2,' IS AT ',F12.3,' CM, WHICH IS BELOW LOWEST',
     *          ' ATMOSPHERE BOUNDARY'/,/' PLEASE READ THE USERS GUIDE')
          WRITE(MONIOU,*) 'SEE KEYWORD: OBSLEV'
          STOP
        ENDIF
        THCKOB(I) = THICK( OBSLEV(I) )
      ENDDO

C  WRITE OBSERVATION LEVELS TO HEADER (IN CM)

      RUNH(5)  = REAL(NOBSLV)
      EVTH(47) = REAL(NOBSLV)
      DO  I = 1, NOBSLV
        RUNH(5+I)  = OBSLEV(I)
        EVTH(47+I) = OBSLEV(I)
      ENDDO

C  FIRST INTERACTION HEIGHT FIXED ?
      IF ( FIX1I ) THEN
        IF ( FIXHEI .GE. HLAY(6) ) THEN
          WRITE(MONIOU,122) FIXHEI,HLAY(6)
 122      FORMAT(' UNALLOWED CHOICE OF FIXHEI '/' FIRST INTERACTION ',
     *           'IS FIXED AT ',F12.3,' CM, WHICH IS ABOVE ',
     *           F12.3,' CM'/,/' PLEASE READ THE USERS GUIDE')
          WRITE(MONIOU,*) 'SEE KEYWORD: FIXHEI'
          STOP
        ENDIF

        IF ( FIXHEI .LE. OBSLEV(NOBSLV) ) THEN
          WRITE(MONIOU,123) FIXHEI,OBSLEV(NOBSLV)
 123      FORMAT(' UNALLOWED CHOICE OF FIXHEI '/' FIRST INTERACTION ',
     *           'IS FIXED AT ',F12.3,' CM, '/' WHICH IS BELOW ',
     *           'LOWEST OBSERVATION LEVEL AT ',F12.3,' CM'
     *           /,/' PLEASE READ THE USERS GUIDE')
          WRITE(MONIOU,*) 'SEE KEYWORD: FIXHEI'
          STOP
        ENDIF

        IF ( PRMPAR(0) .LE. 3.D0 ) THEN
          WRITE(MONIOU,124)
 124      FORMAT(' UNALLOWED CHOICE OF FIXHEI IN CURVED VERSION '/
     *           ' THE FIRST INTERACTION CANNOT BE FIXED FOR PRIMARY',
     *           ' PARTICLE TYPE ',I5/,/' PLEASE READ THE USERS GUIDE')
          WRITE(MONIOU,*) 'SEE KEYWORD: FIXHEI'
          STOP
        ENDIF

        WRITE(MONIOU,507) FIXHEI
 507    FORMAT(' HEIGHT OF FIRST INTERACTION IS FIXED TO ',1P,E10.2,
     *         ' CM')
        IF ( N1STTR .GE. 1  .AND.  N1STTR .LE. 3 ) THEN
          IF ( PRMPAR(0) .LE. 3.D0 ) THEN
            WRITE(MONIOU,516) INT( PRMPAR(0) )
 516        FORMAT(' TARGET OF FIRST INTERACTION CANNOT BE FIXED FOR ',
     *           'PRIMARY TYPE ',I5/,/' PLEASE READ THE USERS GUIDE')
            WRITE(MONIOU,*) 'SEE KEYWORD: FIXHEI'
            STOP
          ENDIF
          IF     ( N1STTR .EQ. 1 ) THEN
            WRITE(MONIOU,*) 'TARGET OF FIRST INTERACTION IS NITROGEN'
          ELSEIF ( N1STTR .EQ. 2 ) THEN
            WRITE(MONIOU,*) 'TARGET OF FIRST INTERACTION IS OXYGEN'
          ELSEIF ( N1STTR .EQ. 3 ) THEN
            WRITE(MONIOU,*) 'TARGET OF FIRST INTERACTION IS ARGON'
          ENDIF
        ELSE
          WRITE(MONIOU,*)
     *       'TARGET OF FIRST INTERACTION IS CHOSEN AT RANDOM'
          N1STTR = 0
        ENDIF
      ELSE
        FIXHEI = 0.D0

        WRITE(MONIOU,*) 'HEIGHT OF FIRST INTERACTION IS CHOSEN RANDOMLY'

      ENDIF

C  STARTING ALTITUDE WITHIN ATMOSPHERE?
      IF ( THICK0 .LT. 0.D0 ) THEN
        WRITE(MONIOU,130) THICK0
 130    FORMAT(' UNALLOWED STARTING ALTITUDE WITH NEGATIVE MASS OVERLAY'
     *          ,E12.3/,/' PLEASE READ THE USERS GUIDE')
        WRITE(MONIOU,*) 'SEE KEYWORD: FIXCHI'
        STOP
      ENDIF

      IF ( THICK0 .GE. THCKOB(NOBSLV) ) THEN
        WRITE(MONIOU,131) THICK0
 131    FORMAT(' UNALLOWED STARTING ALTITUDE AT ',F12.3,' G/CM**2',
     *         '  WHICH IS BELOW LOWEST OBSERVATION LEVEL'/,/
     *        ' PLEASE READ THE USERS GUIDE')
        WRITE(MONIOU,*) 'SEE KEYWORD: FIXCHI'
        STOP
      ENDIF

      H0 = HEIGH( THICK0 )

      IF ( THICK0 .EQ. 0.D0 ) THEN
        WRITE(MONIOU,518) H0,THICK0
        WRITE(MONIOU,*) '                 WHICH IS AT TOP OF ATMOSPHERE'
      ELSE
        WRITE(MONIOU,518) H0, THICK0
      ENDIF
 518  FORMAT(' STARTING ALTITUDE AT ',F15.2,' CM (=',
     *                                          F10.2,' G/CM**2)')
      WRITE(MONIOU,202)
 202  FORMAT(/' OBSERVATION LEVEL # IN  CM    AND IN   G/CM**2 ')
      DO  I = 1, NOBSLV
        WRITE(MONIOU,203) I,OBSLEV(I),THCKOB(I)
 203    FORMAT(9X,1P,I2,2E21.8)
      ENDDO

C  LONGITUDINAL SHOWER DEVELOPMENT
      IF ( LLONGI ) THEN
        THSTEP = NINT( THSTEP )
        THSTEP = MAX( 1.D0, THSTEP )
        THSTEP = MIN( THSTEP, DBLE(LNGMAX) )
        THSTPI = 1.D0/THSTEP
        NSTEP  = INT( THCKOB(NOBSLV)*THSTPI ) + 1

        IF ( NSTEP .GE. LNGMAX ) THEN
          NSTEP  = LNGMAX
          THSTEP = THCKOB(NOBSLV)/(NSTEP+1)
          THSTPI = 1.D0/THSTEP
          WRITE(MONIOU,*) 'LONGITUDINAL SHOWER SAMPLING MODIFIED'
        ENDIF
        WRITE(MONIOU,925) NSTEP,THSTEP
 925    FORMAT(/,' LONGITUDINAL SHOWER DEVELOPMENT:'/
     *          '      SHOWER IS SAMPLED IN ',I4,
     *          ' STEPS OF ',F6.1,' G/CM**2')
C  GET HEIGHT VALUES IN CM FOR USE IN EGS
        IF ( DEBUG ) WRITE(MDEBUG,926)
 926    FORMAT(8X,'STEP',8X,'CM', 20X,'G/CM**2')
        DO  I = 0, NSTEP
          HLONG(I) = HEIGH( I*THSTEP )
          IF ( DEBUG ) WRITE(MDEBUG,*) I,HLONG(I),I*THSTEP
        ENDDO
        IF ( FLGFIT ) THEN
          WRITE(MONIOU,*)
     *      '     FIT TO CHARGED PARTICLE LONG. DISTRIBUTION   ENABLED'
        ELSE
          WRITE(MONIOU,*)
     *      '     FIT TO CHARGED PARTICLE LONG. DISTRIBUTION   DISABLED'
        ENDIF
        WRITE(MONIOU,*)
      ENDIF

C-----------------------------------------------------------------------

C  CHECK INPUT OF ENERGY CUTS

C  FLUKA CAN TREAT HADRONS (EXCEPT ANTI-NEUTRONS) DOWN TO 20 MEV
      IF ( ELCUT(1) .LT. 0.02D0 ) THEN

        WRITE(MONIOU,*) 'ELCUT(1) SELECTED INCORRECT TO',ELCUT(1),' GEV'
        WRITE(MONIOU,*)
        WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
        WRITE(MONIOU,*) 'SEE KEYWORD: ECUTS'
        STOP
      ENDIF
      IF ( ELCUT(2) .LT. 0.01D0 ) THEN
        WRITE(MONIOU,*) 'ELCUT(2) SELECTED INCORRECT TO',ELCUT(2),' GEV'
        WRITE(MONIOU,*)
        WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
        WRITE(MONIOU,*) 'SEE KEYWORD: ECUTS'
        STOP
      ENDIF
      IF ( ELCUT(3) .LT. 5.D-5 ) THEN
        WRITE(MONIOU,*) 'ELCUT(3) SELECTED INCORRECT TO',ELCUT(3),' GEV'
        WRITE(MONIOU,*)
        WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
        WRITE(MONIOU,*) 'SEE KEYWORD: ECUTS'
        STOP
      ENDIF
      IF ( ELCUT(4) .LT. 5.D-5 ) THEN
        WRITE(MONIOU,*) 'ELCUT(4) SELECTED INCORRECT TO',ELCUT(4),' GEV'
        WRITE(MONIOU,*)
        WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
        WRITE(MONIOU,*) 'SEE KEYWORD: ECUTS'
        STOP
      ENDIF
      IF ( ELCUT(1) .GT. LLIMIT  .AND.  PRMPAR(0) .GE. 7.D0 ) THEN
        WRITE(MONIOU,*) 'ELCUT(1) SELECTED INCORRECT < LLIMIT= ',LLIMIT
        WRITE(MONIOU,*)
        WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
        WRITE(MONIOU,*) 'SEE KEYWORD: ECUTS'
        STOP
      ENDIF
      IF ( ELCUT(2) .GT. LLIMIT  .AND.
     *     (PRMPAR(0) .EQ. 5.D0  .OR.  PRMPAR(0) .EQ. 6.D0) ) THEN
        WRITE(MONIOU,*) 'ELCUT(2) SELECTED INCORRECT < LLIMIT= ',LLIMIT
        WRITE(MONIOU,*)
        WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
        WRITE(MONIOU,*) 'SEE KEYWORD: ECUTS'
        STOP
      ENDIF
      IF ( ELCUT(3) .GT. LLIMIT  .AND.
     *     (PRMPAR(0) .EQ. 2.D0  .OR.  PRMPAR(0) .EQ. 3.D0) ) THEN
        WRITE(MONIOU,*) 'ELCUT(3) SELECTED INCORRECT < LLIMIT= ',LLIMIT
        WRITE(MONIOU,*)
        WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
        WRITE(MONIOU,*) 'SEE KEYWORD: ECUTS'
        STOP
      ENDIF
      IF ( ELCUT(4) .GT. LLIMIT  .AND.  PRMPAR(0) .EQ. 1.D0 ) THEN
        WRITE(MONIOU,*) 'ELCUT(4) SELECTED INCORRECT < LLIMIT= ',LLIMIT
        WRITE(MONIOU,*)
        WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
        WRITE(MONIOU,*) 'SEE KEYWORD: ECUTS'
        STOP
      ENDIF
      WRITE(MONIOU,703) ECTMAP,ELCUT
  703 FORMAT (' PARTICLES WITH LORENTZ FACTOR LARGER THAN',1P,E15.4,
     *        ' ARE PRINTED OUT'/' SHOWER PARTICLES ENERGY CUT :'/
     *        '      FOR HADRONS   : ',E15.4,' GEV'/
     *        '      FOR MUONS     : ',E15.4,' GEV'/
     *        '      FOR ELECTRONS : ',E15.4,' GEV'/
     *        '      FOR GAMMAS    : ',E15.4,' GEV'/,/)

      DO  I = 1, 4
        RUNH(20+I) = ELCUT(I)
        EVTH(60+I) = ELCUT(I)
      ENDDO

C-----------------------------------------------------------------------
C  PARAMETERS OF EARTH MAGNETIC FIELD OF MIDDLE EUROPE
C  +X DIRECTION IS NORTH, +Y DIRECTION IS EAST, +Z DIRECTION IS DOWN
      BVAL   = SQRT( BX**2 + BZ**2 )
      IF ( BVAL .EQ. 0.D0 ) THEN
        WRITE(MONIOU,*) ' '
        WRITE(MONIOU,*) '==============================='
        WRITE(MONIOU,*) 'MAGNETIC FIELD MUST NOT BE ZERO'
        WRITE(MONIOU,*) '==============================='
        WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
        WRITE(MONIOU,*) 'SEE KEYWORD: MAGNET'
        STOP
      ENDIF
C  BNORM HAS DIMENSIONS OF MEV/CM
      BNORM  = BVAL * C(25) * 1.D-16
C  BNORMC HAS DIMENSIONS OF GEV/CM
      BNORMC = BNORM * 1.D-3
      SINB   = BZ / BVAL
      COSB   = BX / BVAL
      WRITE(MONIOU,*) 'EARTH MAGNETIC FIELD STRENGTH IS ',SNGL(BVAL),
     *                ' MICROTESLA'
      WRITE(MONIOU,*) '     WITH INCLINATION ANGLE      ',
     *               SNGL( ASIN( SINB )*180.D0/PI ),' DEGREES'
      IF ( BVAL .GE. 10000.D0 ) THEN
        WRITE(MONIOU,*) 'YOU WANT TO MAGNETIZE THE GALAXY ?'
        WRITE(MONIOU,*)
        WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
        WRITE(MONIOU,*) 'SEE KEYWORD: MAGNET'
        STOP
      ENDIF
C  LIMITING FACTOR FOR STEP SIZE OF ELECTRON IN MAGNETIC FIELD

C  WE USE A LIMIT OF ABOUT 11.4 DEG (0.2 RAD)
      BLIMIT   = 0.2D0 / BNORM

      EVTH(71) = BX
      EVTH(72) = BZ
C  ANGLE BETWEEN ARRAY X-DIRECTION AND MAGNETIC NORD
C  POSITIV, IF X-DIRECTION OF ARRAY POINTS TO EASTERN DIRECTION
      ARRANR = ARRANG * PI / 180.D0
      COSANG = COS( ARRANR )
      SINANG = SIN( ARRANR )
      EVTH(93) = ARRANR
      IF ( ARRANG .NE. 0.D0 ) THEN
        WRITE(MONIOU,*)
        WRITE(MONIOU,*) 'DETECTOR COORDINATE SYSTEM IS ROTATED AWAY ',
     *                 'FROM NORTH BY ',SNGL(ARRANG),' DEGREES'
      ENDIF

C-----------------------------------------------------------------------
C  DEFINE CHERENKOV ARRAY
      NCERX = MAX( 1, NCERX )
      NCERY = MAX( 1, NCERY )
      ACERX = ABS(ACERX)
      ACERY = ABS(ACERY)
      IF ( NCERX .GT. 1 ) THEN
        DCERX = MAX( 1.D0, ABS(DCERX) )
      ELSE
        DCERX = 0.001D0
      ENDIF
      IF ( NCERY .GT. 1 ) THEN
        DCERY = MAX( 1.D0, ABS(DCERY) )
      ELSE
        DCERY = 0.001D0
      ENDIF
      XCMAX = (ACERX + (NCERX-1) * DCERX) * 0.5D0
      YCMAX = (ACERY + (NCERY-1) * DCERY) * 0.5D0
      DCERXI = 1.D0/DCERX
      EPSX   = ACERX * 0.5D0 * DCERXI
      DCERYI = 1.D0/DCERY
      EPSY   = ACERY * 0.5D0 * DCERYI
      IF ( MOD(NCERX,2) .EQ. 0 ) THEN
        FCERX = -0.5D0
      ELSE
        FCERX = 0.D0
      ENDIF
      IF ( MOD(NCERY,2) .EQ. 0 ) THEN
        FCERY = -0.5D0
      ELSE
        FCERY = 0.D0
      ENDIF

      IF ( STEPFC .NE. 1.D0 ) THEN
        STEPFC = 1.D0
        WRITE(MONIOU,*) 'INPRM : STEPFC CORRECTED TO 1.D0'
      ENDIF
C-----change command 
c      WRITE(MONIOU,472) ACERX,ACERY, DCERX,DCERY,NCERX,NCERY
C-----change command 

 472  FORMAT(/' CHERENKOV ARRAY:'/5X,
     *  ' CHERENKOV STATIONS ARE ',F10.2,'  *  ',F10.2,' CM**2 LARGE'/
     *  5X,' THE GRID SPACING IS   ',F10.2,' AND ',F10.2,' CM',/
     *  5X,' THERE ARE ',I3,' * ',I3,' STATIONS IN X/Y DIRECTIONS'/
     *  5X,' THE CHERENKOV ARRAY IS CENTERED AROUND (0., 0.)'/)

      IF ( NOBSLV .GT. 1 ) WRITE(MONIOU,473) OBSLEV(NOBSLV)*0.01
 473  FORMAT(/' CHERENKOV RADIATION IS REGISTERED ONLY FOR LOWEST',
     * ' OBSERVATION LEVEL AT ', F10.1,' METER'/)

C  CALCULATE CHERENKOV YIELD FACTOR FROM WAVELENGTH BAND
c-----changed limit to 900nm (was 700) 
        IF ( WAVLGL .LT. 100.D0  .OR.  WAVLGU .GT. 900.D0
c--------changed limit to 900nm (was 700)
     *                         .OR.  WAVLGL .GE. WAVLGU ) THEN
        WRITE(MONIOU,*) 'CHERENKOV WAVELENGTH BAND FROM ',SNGL(WAVLGL),
     *                  ' TO ',SNGL(WAVLGU),' NANOMETER'
        WRITE(MONIOU,*) ' IS OUT OF VALIDITY RANGE'
        WRITE(MONIOU,*)
        WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
        WRITE(MONIOU,*) 'SEE KEYWORD: CWAVLG'
        STOP
      ENDIF
      WRITE(MONIOU,*) 'CHERENKOV WAVELENGTH BAND FROM ',SNGL(WAVLGL),
     *                ' TO ',SNGL(WAVLGU),' NANOMETER'
C  WAVELENGTH IS CONVERTED FROM NM TO CM
      CYIELD = (1.D0/WAVLGL - 1.D0/WAVLGU) * 2.D7 * PI / C(50)
C  CALCULATE FACTOR FOR ETA DENSITY NORML.
C  (ETA AT SEA LEVEL = 0.283D-3 FOR U.S. STDANDARD ATMOSPHERE)
      ETADSN = 0.283D-3 * CATM0(1,1) / BATM0(1,1)
      IF ( CERSIZ .GT. 0.D0 ) THEN
        WRITE(MONIOU,*) 'CHERENKOV BUNCH SIZE IS SET TO ',CERSIZ
      ELSE
        WRITE(MONIOU,*) 'CHERENKOV BUNCH SIZE IS CALCULATED FOR EACH ',
     *                 'SHOWER'
      ENDIF
      IF ( .NOT. LCERFI ) THEN
        WRITE(MONIOU,*) 'CHERENKOV PHOTONS ARE WRITTEN TO PARTICLE ',
     *                  'OUTPUT FILE'

      ELSE
        WRITE(MONIOU,*)
     *                'CHERENKOV PHOTONS ARE WRITTEN TO SEPARATE FILE'
      ENDIF

C  SCATTERING OF CENTER OF CHERENKOV ARRAY RELATIVE TO SHOWER AXIS
c-----changed
      ICERML1 = MIN( 40, MAX( 1, ICERML ) )
      if(icerml1.ge.21) then
         icerml=icerml1-20
         else
            icerml=icerml1
         endif
c      ICERML = MIN( 20, MAX( 1, ICERML ) )

      IF ( (icerml1.ge.1).and.(ICERML1 .LE. 20) ) THEN
        XSCATT = ABS(XSCATT)
        YSCATT = ABS(YSCATT)
        WRITE(MONIOU,6225) ICERML,XSCATT,YSCATT
 6225   FORMAT(' DEFINE MULTIPLE CHERENKOV ring TO USE EACH',
     *   ' SHOWER SEVERAL TIMES'/ ' USE EACH EVENT ',I2,' TIMES'/
     *   ' THE EVENTS ARE SCATTERED QUASI RANDOMLY IN THE RANGE '/
     *   18X,' R_min =   ',F10.2,'  R_max  =  ',F10.2,' CM' )
        XCMAXS = XCMAX + XSCATT
        YCMAXS = YCMAX + YSCATT
      ENDIF


      IF ( ICERML1 .GE. 21 ) THEN
c-----changed
        XSCATT = ABS(XSCATT)
        YSCATT = ABS(YSCATT)
        WRITE(MONIOU,5225) ICERML,XSCATT,YSCATT
 5225   FORMAT(' DEFINE MULTIPLE CHERENKOV ARRAYS TO USE EACH',
     *   ' SHOWER SEVERAL TIMES'/ ' USE EACH EVENT ',I2,' TIMES'/
     *   ' THE EVENTS ARE SCATTERED QUASI RANDOMLY IN THE RANGE '/
     *   18X,'   X =  +- ',F10.2,'    Y = +- ',F10.2,' CM' )
        XCMAXS = XCMAX + XSCATT
        YCMAXS = YCMAX + YSCATT
      ENDIF

C  STORE CHERENKOV PARAMETERS IN EVENTHEADER
      EVTH(86) = NCERX
      EVTH(87) = NCERY
      EVTH(88) = DCERX
      EVTH(89) = DCERY
      EVTH(90) = ACERX
      EVTH(91) = ACERY
      IF ( LCERFI ) THEN
        EVTH(92) = 1.
      ELSE
        EVTH(92) = 0.
      ENDIF
      EVTH(96) = WAVLGL
      EVTH(97) = WAVLGU
      EVTH(98) = FLOAT(ICERML)

C  INITIALIZE REFRACTIVE INDEX TABLE
      CALL INRTAB
C-----------------------------------------------------------------------
C  ESTABLISH MUON CONSTANTS AND MUON CROSS-SECTION TABLES
      CALL MUPINI

C  FLAG FOR ADDITIONAL MUON INFORMATION
      IF ( FMUADD ) THEN
        WRITE(MONIOU,*)
        WRITE(MONIOU,*) 'ADDITIONAL INFORMATION ON MUON ORIGIN IS',
     *                  ' WRITTEN TO PARTICLE TAPE'
        EVTH(94) = 1.
      ELSE
        EVTH(94) = 0.
      ENDIF

C  PRINTOUT OF INFORMATIONS FOR DEBUGGING
      IF ( DEBUG ) WRITE(MONIOU,484) MDEBUG
  484 FORMAT(/' ATTENTION ! DEBUGGING IS ACTIVE'/
     *          ' ====> DEBUG INFORMATION WRITTEN TO UNIT ',I3/,/)

C-----------------------------------------------------------------------
C  WRITE RUNHEADER TO OUTPUT BUFFER

      CALL TOBUF( RUNH,0 )

      IF ( LCERFI ) THEN
        CALL TOBUFC( RUNH,0 )
      ENDIF

C-----------------------------------------------------------------------

C  WRITE DATA SET FOR INFORMATION BANK
      IF ( FDBASE ) THEN

        VERVEN = IQGSVER * 0.1D0

C  LONGITUDINAL FLAG (0=NO LONGI, 1=VERT. DEPTH, 2=SLANT DEPTH)
        IF ( LLONGI ) THEN

          ILONG = 1

        ELSE
          ILONG = 0
        ENDIF
C  SET ISO-FLAG (0=ISOBAR MODEL, 1=GHEISHA, 2=URQMD, 3=FLUKA)

        ISO = 3

C  SET DPMFLAG (0=HDPM, 1=VENUS, 2=SIBYLL, 3=QGSJET, 4=DPMJET, 5=NEXUS)
        IF     ( EVTH(76) .EQ. 1. ) THEN
          IDPM = 1
        ELSEIF ( EVTH(76) .EQ. 2. ) THEN
          IDPM = 2
        ELSEIF ( EVTH(76) .EQ. 3. ) THEN
          IDPM = 3
        ELSEIF ( EVTH(76) .EQ. 4. ) THEN
          IDPM = 4
        ELSEIF ( EVTH(76) .EQ. 5. ) THEN
          IDPM = 5
        ELSE
          IDPM = 0
        ENDIF
C  INCREMENT DPMFLAG FOR VARIOUS CROSS-SECTIONS
C  BY (0=HDPM-SIG, 10=VENUSSIG, 20=SIBYLLSIG, 30=QGSSIG, 40=DPMJETSIG,
C      50=NEXUSSIG)
        IF     ( EVTH(145) .EQ. 1. ) THEN
          IDPM = IDPM + 10
        ELSEIF ( EVTH(145) .GE. 2. ) THEN
          IDPM = IDPM + 50
        ELSEIF ( EVTH(140) .NE. 0. ) THEN
          IDPM = IDPM + 20
        ELSEIF ( EVTH(142) .NE. 0. ) THEN
          IDPM = IDPM + 30
        ELSEIF ( EVTH(144) .NE. 0. ) THEN
          IDPM = IDPM + 40
        ENDIF

        MARK = '1'

        ILTHIN = 0
        EFRAC  = 0.D0

        IF ( FREFRX ) THEN
          IFREFRX = 1
        ELSE
          IFREFRX = 0
        ENDIF

        WRITE(MDBASE,666) VERNUM,MARK,MVDATE,SNGL(VERVEN),
     $                    INT(RUNH(3))+20000000,
     $    INT(EVTH(80)),INT(EVTH(79)),INT(EVTH(78)),
     $                    MOD(INT(EVTH(77)),1024),INT(RUNH(2)),
     $    INT(PRMPAR(0)),LLIMIT,ULIMIT,
     $    PSLOPE,INT(RUNH(20)),INT(RUNH(19)),INT(EVTH(76)),
     $                    INT(EVTH(75)),ISO,IDPM,
     $    NFLAIN,NFLDIF,NFLPI0,NFLPIF,NFLCHE,NFRAGM,
     $    ILONG,THSTEP,BX,
     $    BZ,NOBSLV
 666    FORMAT('#version#',F6.3,A1,'#versiondate#',I9,
     $    '#modelversion#',F8.3,'#rundate#',I9,/,
     $    '#computer#',I2,'#curved#',I2,'#neutrino#',I2,
     $    '#cerenkov#',I3,'#runnumber#',I7,/,
     $    '#primary#',I5,'#e_range_l#',1P,E14.7,'#e_range_u#',E14.7,/,
     $    '#slope#',E15.7,0P,'#nkg#',I2,'#egs#',I2,/,
     $    '#model#',I2,'#gheisha#',I2,'#isobar#',I2,
     $    '#model+crossect#',I3,/,
     $    '#hadflag1#',I2,'#hadflag2#',I2,'#hadflag3#',I2,
     $    '#hadflag4#',I2,'#hadflag5#',I2,'#hadflag6#',I2,/,
     $    '#longi#',I2,'#longistep#',1P,E14.7,'#magnetx#',E15.7,/,
     $    '#magnetz#',E15.7,0P,'#nobslev#',I3)

        WRITE(MDBASE,669) OBSLEV(1),OBSLEV(2),OBSLEV(3),
     $    OBSLEV(4),OBSLEV(5),OBSLEV(6),
     $    OBSLEV(7),OBSLEV(8),OBSLEV(9),
     $    OBSLEV(10),ELCUT(1),ELCUT(2),

     $    ELCUT(3), ELCUT(4),EVTH(81),
     $    EVTH(82),EVTH(83),EVTH(84),
     $    FIXHEI,N1STTR,THICK0,
     $    STEPFC,ARRANG,INT(EVTH(94)),NSEQ,
     $    ISEED(1,1),ISEED(2,1),ISEED(3,1),
     $    ISEED(1,2),ISEED(2,2),ISEED(3,2),
     $    ISEED(1,3),ISEED(2,3),ISEED(3,3),
     $    0,DSN,LSTDSN,

     $    ' ARC000.01',' ARC000.01',

     $    NSHOW,HOST,USER

     $    ,IATMOX,IFREFRX

     $    ,VUECON(1)*(180.D0/PI),VUECON(2)*(180.D0/PI)
 669    FORMAT(1P,'#obslev1#',E15.7,'#obslev2#',E15.7,
     $    '#obslev3#',E15.7,/,
     $    '#obslev4#',E15.7,'#obslev5#',E15.7,'#obslev6#',E15.7,/,
     $    '#obslev7#',E15.7,'#obslev8#',E15.7,'#obslev9#',E15.7,/,
     $    '#obslev10#',E15.7,'#hcut#',E14.7,'#mcut#',E14.7,/,
     $    '#ecut#',E14.7,'#gcut#',E14.7,'#theta_l#',E14.7,/,
     $    '#theta_u#',E14.7,'#phi_l#',E15.7,'#phi_u#',E15.7,/,
     $    '#fixhei#',E14.7,'#n1sttr#',0P,I3,1P,'#fixchi#',E14.7,/,
     $    '#stepfc#',E14.7,'#arrang#',E15.7,0P,'#muaddi#',I2,
     $    '#nseq#',I2,/,
     $    '#seq1seed1#',I10,'#seq1seed2#',I9,'#seq1seed3#',I9,/,
     $    '#seq2seed1#',I10,'#seq2seed2#',I9,'#seq2seed3#',I9,/,
     $    '#seq3seed1#',I10,'#seq3seed2#',I9,'#seq3seed3#',I9,/,
     $    '#size#',I10,/,'#dsn_events#',A59,/,
     $    '#dsn_prtout# ',A9,'#tape_name#',A10,'#backup#',A10,/,
     $    '#howmanyshowers#',I10,'#host#',A20,'#user#',A20

     $    ,/,'#atmosphere#',I3,'#refract#',I2

     $    ,/,1P,'#viewcon_l#',E14.7,'#viewcon_u#',E14.7,0P

     $    )
        WRITE(MDBASE,670) ILTHIN,EFRAC

 670    FORMAT('#thinning#',I2,'#thinnlev_had#',1P,E14.7,0P)

      ENDIF

C   IN THE CURVED VERSION WE TREAT THE FITTED PROFILE THROUGH INTERNAL
C   FUNCTIONS ONLY. RESETTING IATMOX IS DONE AFTER THE
C   RUNHEADER AND THE 'DBASE' FILE ARE WRITTEN.
        IATMOX = 0

      WRITE(MONIOU,*) 'NUMBER OF SHOWERS TO GENERATE =',NSHOW
      WRITE(MONIOU,*)

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE ISTACK

C-----------------------------------------------------------------------
C  I(NITIALIZE) STACK
C
C  PREPARES STACK AND EXTERNAL DISK FILE.
C  THIS SUBROUTINE IS CALLED FROM AAMAIN.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRETHMAP/ECTMAP,ELEFT
      DOUBLE PRECISION ECTMAP,ELEFT

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSTACKF/STACKI,MSTACKP,MEXST,NSHIFT,NOUREC,ICOUNT,
     *                 NTO,NFROM
      INTEGER          MAXSTK

      PARAMETER        (MAXSTK = 17*256*2)
      DOUBLE PRECISION STACKI(MAXSTK)
      INTEGER          MSTACKP,MEXST,NSHIFT,NOUREC,ICOUNT,NTO,NFROM

       

       

       

       

      SAVE
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,*) 'ISTACK:'

      NTO     = 0
      NFROM   = 0
      NOUREC  = 0
      NSHIFT  = 0
      MSTACKP = 0
      ELEFT   = 0.D0
      ICOUNT  = 1

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE KDECAY( IGO )

C-----------------------------------------------------------------------
C  K(AON) DECAY
C
C  KAON DECAYS WITH FULL KINEMATIC, ENERGY AND MOMENTA CONSERVED
C  ALL SECONDARY PARTICLES ARE WRITTEN TO STACK.
C  THIS SUBROUTINE IS CALLED FROM NUCINT.
C  ARGUMENT:         (TO CHARACTERIZE THE DECAYING KAON)
C   IGO    = 1  K+
C          = 2  K-
C          = 3  K0S
C          = 4  K0L
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRDECAYC/GAM345,COS345,PHI345
      DOUBLE PRECISION GAM345(3),COS345(3),PHI345(3)

      COMMON /CRIRET/  IRET1,IRET2,IRETE
      INTEGER          IRET1,IRET2
      LOGICAL          IRETE

      COMMON /CRKAONS/ CKA
      DOUBLE PRECISION CKA(80)

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRPOLAR/ POLART,POLARF
      DOUBLE PRECISION POLART,POLARF

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION BETA3,COSTCM,COSTH3,GAMMA3,GAMMA4,
     *                 PHINN,PHI3,RA,WORK1,WORK2
      INTEGER          I,ICHARG,IGO,M3
      SAVE
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) (CURPAR(I),I=0,9)
  444 FORMAT(' KDECAY: CURPAR=',1P,10E11.3)

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  DECAY OF K(+,-) (6 MODES)

      IF     ( IGO .LE. 2 ) THEN
        CALL RMMARD( RD,1,1 )
        RA = RD(1)

C  DECAY  K(+,-)  ---->  MU(+,-) + NEUTRINO
        IF     ( RA .LE. CKA(23) ) THEN

C  NEUTRINO IS DROPPED

          WORK1  = CKA(28) * GAMMA
          WORK2  = CKA(29) * BETA * WORK1
          CALL RMMARD( RD,2,1 )
          COSTCM = RD(1) * 2.D0 - 1.D0
C  MU(+,-)
          GAMMA3 = WORK1 + COSTCM * WORK2
          BETA3  = SQRT( (GAMMA3-1.D0)*(GAMMA3+1.D0) ) / GAMMA3
          COSTH3 = MIN( 1.D0, (GAMMA * GAMMA3 - CKA(28))
     *                   / (BETA * GAMMA * BETA3 * GAMMA3) )
          PHI3   = RD(2) * PI2
          CALL ADDANG3( COSTHE,PHIX,PHIY, COSTH3,PHI3,
     *                                  SECPAR(2),SECPAR(3),SECPAR(4) )

          IF ( SECPAR(2) .GT. C(29) ) THEN

            SECPAR(0) = 4 + IGO
            SECPAR(1) = GAMMA3
C  DIRECTION OF PION IN THE MUON CM SYSTEM (= DIRECTION OF POLARIZATION)
C  SEE: G. BARR ET AL., PHYS. REV. D39 (1989) 3532, EQ. 5
C  POLART IS COS OF ANGLE BETWEEN KAON AND LABORATORY IN THE MU CM
C  POLARF IS ANGLE PHI AROUND THE LAB DIRECTION IN THE MU CM
C  POLART, POLARF WITH RESPECT TO THE MU DIRECTION IN THE LAB SYSTEM
            POLART = ( 2.D0*PAMA(11)*GAMMA*C(6) / (PAMA(5)*GAMMA3)
     *                 - C(6) - 1.D0 ) / ( BETA3 * (1.D0-C(6)) )
            POLARF = PHI3 - PI
C  PION DIRECTION IS DIRECTION OF POLARIZATION FOR K+, OPPOSITE FOR K-
            IF ( ITYPE .EQ. 12 ) THEN
              POLART = -POLART
              POLARF = POLARF + PI
            ENDIF
C  GET THE POLARIZATION DIRECTION IN THE MU CM RELATIVE TO THE CORSIKA
C  COORDINATE SYSTEM
            IF ( SECPAR(3) .NE. 0.D0  .OR.  SECPAR(4) .NE. 0.D0 ) THEN
              PHINN = ATAN2( SECPAR(4), SECPAR(3) )
            ELSE
              PHINN = 0.D0
            ENDIF
            CALL ADDANG( SECPAR(2),PHINN, POLART,POLARF,
     *                                             POLART,POLARF )
            SECPAR(11) = POLART
            SECPAR(12) = POLARF
            CALL TSTACK
            SECPAR(11) = 0.D0
            SECPAR(12) = 0.D0
          ELSE
            IF ( LLONGI ) THEN
C  ADD MUON ENERGY TO LONGITUDINAL ENERGY DEPOSIT

              DLONG(LHEIGH,15) = DLONG(LHEIGH,15) + GAMMA3 * PAMA(5)

            ENDIF
          ENDIF
          IF ( LLONGI ) THEN
C  ADD NEUTRINO ENERGY TO LONGITUDINAL ENERGY DEPOSIT
            GAMMA4 = PAMA(11) * GAMMA - PAMA(5) * GAMMA3

            DLONG(LHEIGH,8) = DLONG(LHEIGH,8) + GAMMA4

          ENDIF

C  DECAY  K(+,-)  ---->  PI(+,-) + PI(0)
        ELSEIF ( RA .LE. CKA(47) ) THEN
          M3 = ITYPE - 3
          CALL DECAY1( ITYPE, M3, 7 )

C  DECAY   K(+,-)  ---->   PI(+,-) + PI(+,-) + PI(-,+)
        ELSEIF ( RA .LE. CKA(48) ) THEN
          CALL DECAY6( PAMA(11), PAMA(8),PAMA(8),PAMA(8),
     *                 CKA(51),CKA(52),CKA(53), CKA(54), 1 )
C  PI(+,-)  AND  PI(+,-) AND  THIRD (ODD) PI(-,+)
          DO  I = 1, 3
            CALL ADDANG3( COSTHE,PHIX,PHIY, COS345(I),PHI345(I),
     *                                  SECPAR(2),SECPAR(3),SECPAR(4) )

            IF ( SECPAR(2) .GT. C(29) ) THEN

              IF ( I .EQ. 3 ) THEN
                SECPAR(0) = 10 - IGO
              ELSE
                SECPAR(0) =  7 + IGO
              ENDIF
              SECPAR(1) = GAM345(I)
              CALL TSTACK
            ELSE
              IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

                DLONG(LHEIGH,17) = DLONG(LHEIGH,17)
     *                                   + GAM345(I) * PAMA(8)

              ENDIF
            ENDIF
          ENDDO

C  DECAY  K(+,-)  ---->  PI(0)  + E(+,-) + NEUTRINO
        ELSEIF ( RA .LE. CKA(49) ) THEN
          CALL DECAY6( PAMA(11), PAMA(7),PAMA(2),0.D0,
     *                 CKA(65),CKA(66),0.D0, CKA(67), 4 )
C  PI(0)  AND  E(+,-) / NEUTRINO IS DROPPED
          DO  250  I = 1, 2
            CALL ADDANG3( COSTHE,PHIX,PHIY, COS345(I),PHI345(I),
     *                                  SECPAR(2),SECPAR(3),SECPAR(4) )

            IF ( SECPAR(2) .GT. C(29) ) THEN

              IF ( I .EQ. 1 ) THEN
                SECPAR(0) = 7.D0

              ELSE
                SECPAR(0) = 1 + IGO
              ENDIF
              SECPAR(1) = GAM345(I)
              CALL TSTACK
            ELSE
              IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT
                IF     ( I .EQ. 1 ) THEN
                  DLONG(LHEIGH,17) = DLONG(LHEIGH,17)+GAM345(1)*PAMA(7)

                ELSE
                  IF ( IGO .EQ. 1 ) THEN
                    DLONG(LHEIGH,13) = DLONG(LHEIGH,13)
     *                                + (GAM345(2)+1.D0) * PAMA(2)
                  ELSE
                    DLONG(LHEIGH,13) = DLONG(LHEIGH,13)
     *                                + (GAM345(2)-1.D0) * PAMA(2)
                  ENDIF

                ENDIF
              ENDIF
            ENDIF
  250     CONTINUE

          IF ( LLONGI ) THEN
C  ADD NEUTRINO ENERGY TO LONGITUDINAL ENERGY DEPOSIT
            GAM345(3)=GAMMA*PAMA(11)-GAM345(1)*PAMA(7)-GAM345(2)*PAMA(2)

            DLONG(LHEIGH,8) = DLONG(LHEIGH,8) + GAM345(3)

          ENDIF

C  DECAY  K(+,-)  ---->  PI(0)  + MU(+,-) + NEUTRINO
        ELSEIF ( RA .LE. CKA(50) ) THEN
          CALL DECAY6( PAMA(11), PAMA(7),PAMA(5),0.D0,
     *                 CKA(68),CKA(69),0.D0, CKA(70), 3 )
C  PI(0)  AND  MU(+,-) / NEUTRINO IS DROPPED
          DO  260  I = 1, 2
            CALL ADDANG3( COSTHE,PHIX,PHIY, COS345(I),PHI345(I),
     *                                  SECPAR(2),SECPAR(3),SECPAR(4) )

            IF ( SECPAR(2) .GT. C(29) ) THEN

              SECPAR(1)   = GAM345(I)
              IF ( I .EQ. 1 ) THEN
                SECPAR(0) = 7.D0

              ELSE
                SECPAR(0) = 4 + IGO
                IF ( SECPAR(0) .EQ. 6.D0 ) THEN
C  INVERT POLARIZATION DIRECTION FOR MU(-)
                  POLART  = -POLART
                  POLARF  =  POLARF + PI
                ENDIF
C  GET THE POLARIZATION DIRECTION IN THE MU CM RELATIVE TO THE CORSIKA
C  COORDINATE SYSTEM
                IF ( SECPAR(3).NE.0.D0  .OR.  SECPAR(4).NE.0.D0 ) THEN
                  PHINN = ATAN2( SECPAR(4), SECPAR(3) )
                ELSE
                  PHINN = 0.D0
                ENDIF
                CALL ADDANG( SECPAR(2),PHINN, POLART,POLARF,
     *                                                  POLART,POLARF )
                SECPAR(11) = POLART
                SECPAR(12) = POLARF
              ENDIF
              CALL TSTACK
              SECPAR(11) = 0.D0
              SECPAR(12) = 0.D0
            ELSE
              IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT
                 IF     ( I .EQ. 1 ) THEN
                   DLONG(LHEIGH,17) = DLONG(LHEIGH,17)+GAM345(2)*PAMA(7)

                 ELSE
                   DLONG(LHEIGH,15) = DLONG(LHEIGH,15)+GAM345(2)*PAMA(5)

                 ENDIF
              ENDIF
            ENDIF
  260     CONTINUE

          IF ( LLONGI ) THEN
C  ADD NEUTRINO ENERGY TO LONGITUDINAL ENERGY DEPOSIT
            GAM345(3)=GAMMA*PAMA(11)-GAM345(1)*PAMA(7)-GAM345(2)*PAMA(5)

            DLONG(LHEIGH,8) = DLONG(LHEIGH,8) + GAM345(3)

          ENDIF

C  DECAY  K(+,-)  ---->  PI(0) + PI(0) + PI(+,-)
        ELSE
          CALL DECAY6( PAMA(11), PAMA(7),PAMA(7),PAMA(8),
     *                 CKA(55),CKA(56),CKA(57), CKA(58), 1 )
C  PI(0)''S  AND  PI(+,-)
          DO  I = 1, 3
            IF ( I .EQ. 3 ) THEN
              SECPAR(0) = 7 + IGO
            ELSE
              SECPAR(0) = 7.D0
            ENDIF
            CALL ADDANG3( COSTHE,PHIX,PHIY, COS345(I),PHI345(I),
     *                                  SECPAR(2),SECPAR(3),SECPAR(4) )

            IF ( SECPAR(2) .GT. C(29) ) THEN

              SECPAR(1) = GAM345(I)
              CALL TSTACK
            ELSE
              IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT
                GAMMA4 = GAM345(I) * PAMA(NINT( SECPAR(0) ))

                DLONG(LHEIGH,17) = DLONG(LHEIGH,17) + GAMMA4

              ENDIF
            ENDIF
          ENDDO

        ENDIF

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  DECAY OF K0S  (2 MODES)
      ELSEIF ( IGO .EQ. 3 ) THEN

        CALL RMMARD( RD,1,1 )
C  DECAY  K0S  ---->  PI(+) + PI(-)
        IF ( RD(1) .LE. CKA(24) ) THEN
          CALL DECAY1( ITYPE, 8, 9 )

C  DECAY  K0S  ---->  PI(0) + PI(0)
        ELSE
          CALL DECAY1( ITYPE, 7, 7 )

        ENDIF

C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  DECAY OF K0L   (4 MODES)
      ELSEIF ( IGO .EQ. 4 ) THEN
        CALL RMMARD( RD,1,1 )
        RA = RD(1)

C  DECAY   K0L  ---->   PI(+,-)  + E(-,+) + NEUTRINO
        IF     ( RA .LE. CKA(27) ) THEN
          CALL DECAY6( PAMA(10), PAMA(8),PAMA(2),0.D0,
     *                 CKA(71),CKA(72),0.D0, CKA(73), 4 )
          CALL RMMARD( RD,1,1 )
C  CHARGE ASYMMETRY PREFERS FORMATION OF PI(-)
          ICHARG = INT( 1.5016D0 + RD(1) )
C  PI(+,-)  AND  E(-,+) / NEUTRINO IS DROPPED
          DO  420  I = 1, 2
            SECPAR(0) = 10 - 3*I - (2*I-3)*ICHARG

            CALL ADDANG3( COSTHE,PHIX,PHIY, COS345(I),PHI345(I),
     *                                  SECPAR(2),SECPAR(3),SECPAR(4) )

            IF ( SECPAR(2) .GT. C(29) ) THEN

              SECPAR(1) = GAM345(I)
              CALL TSTACK
            ELSE
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT
              IF ( LLONGI ) THEN
                IF     ( I .EQ. 1 ) THEN
                  DLONG(LHEIGH,17) = DLONG(LHEIGH,17)+GAM345(1)*PAMA(8)

                ELSE
                  IF ( SECPAR(0) .EQ. 2.D0 ) THEN
                    DLONG(LHEIGH,13) = DLONG(LHEIGH,13)
     *                                     + (GAM345(2)+1.D0) * PAMA(2)
                  ELSE
                    DLONG(LHEIGH,13) = DLONG(LHEIGH,13)
     *                                     + (GAM345(2)-1.D0) * PAMA(2)
                  ENDIF

                ENDIF
              ENDIF
            ENDIF
  420     CONTINUE

          IF ( LLONGI ) THEN
C  ADD NEUTRINO ENERGY TO LONGITUDINAL ENERGY DEPOSIT
            GAM345(3)=GAMMA*PAMA(10)-GAM345(1)*PAMA(8)-GAM345(2)*PAMA(2)

            DLONG(LHEIGH,8) = DLONG(LHEIGH,8) + GAM345(3)

          ENDIF

C  DECAY   K0L  ---->  PI(+,-)  + MU(-,+) + NEUTRINO
        ELSEIF ( RA .LE. CKA(26) ) THEN
          CALL DECAY6( PAMA(10), PAMA(8),PAMA(5),0.D0,
     *                 CKA(74),CKA(75),0.D0, CKA(76), 3 )
          CALL RMMARD( RD,1,1 )
C  CHARGE ASYMMETRY PREFERS FORMATION OF PI(-)
          ICHARG = INT( 1.5016D0 + RD(1) )

C  PI(+,-)  AND  MU(-,+) / NEUTRINO IS DROPPED
          DO  430  I = 1, 2

            CALL ADDANG3( COSTHE,PHIX,PHIY, COS345(I),PHI345(I),
     *                                  SECPAR(2),SECPAR(3),SECPAR(4) )

            IF ( SECPAR(2) .GT. C(29) ) THEN

              SECPAR(1)   = GAM345(I)
              IF     ( I .EQ. 1 ) THEN
                SECPAR(0) = 7 + ICHARG
              ELSEIF ( I .EQ. 2 ) THEN
                SECPAR(0) = 7 - ICHARG
                IF ( SECPAR(0) .EQ. 6.D0 ) THEN
C  INVERT POLARIZATION DIRECTION FOR MU(-)
                  POLART = -POLART
                  POLARF =  POLARF + PI
                ENDIF
C  GET THE POLARIZATION DIRECTION IN THE MU CM RELATIVE TO THE CORSIKA
C  COORDINATE SYSTEM
                IF ( SECPAR(3).NE.0.D0  .OR.  SECPAR(4).NE.0.D0 ) THEN
                  PHINN = ATAN2( SECPAR(4), SECPAR(3) )
                ELSE
                  PHINN = 0.D0
                ENDIF
                CALL ADDANG( SECPAR(2),PHINN, POLART,POLARF,
     *                                                  POLART,POLARF )
                SECPAR(11) = POLART
                SECPAR(12) = POLARF

              ENDIF
              CALL TSTACK
              SECPAR(11) = 0.D0
              SECPAR(12) = 0.D0
            ELSE
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT
              IF ( LLONGI ) THEN
                 IF     ( I .EQ. 1 ) THEN
                   DLONG(LHEIGH,17) = DLONG(LHEIGH,17)+GAM345(1)*PAMA(8)

                ELSE
                   DLONG(LHEIGH,15) = DLONG(LHEIGH,15)+GAM345(2)*PAMA(5)

                 ENDIF
              ENDIF
            ENDIF
  430     CONTINUE

          IF ( LLONGI ) THEN
C  ADD NEUTRINO ENERGY TO LONGITUDINAL ENERGY DEPOSIT
            GAM345(3)=GAMMA*PAMA(10)-GAM345(1)*PAMA(8)-GAM345(2)*PAMA(5)

            DLONG(LHEIGH,8) = DLONG(LHEIGH,8) + GAM345(3)

          ENDIF

C  DECAY   K0L  ---->  PI(0) + PI(0) + PI(0)
        ELSEIF ( RA .LE. CKA(25) ) THEN
C  SEE: S.V. SOMALWAR ET AL., PHYS.REV.LET. 68(1992)2580
          CALL DECAY6( PAMA(10), PAMA(7),PAMA(7),PAMA(7),
     *                 CKA(59),-.0033D0,CKA(59), CKA(60), 1 )
C  PI(0)''S
          SECPAR(0) = 7.D0
          DO  I = 1, 3
            CALL ADDANG3( COSTHE,PHIX,PHIY, COS345(I),PHI345(I),
     *                                  SECPAR(2),SECPAR(3),SECPAR(4) )

            IF ( SECPAR(2) .GT. C(29) ) THEN

              SECPAR(1) = GAM345(I)
              CALL TSTACK
            ELSE
              IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

                DLONG(LHEIGH,17) = DLONG(LHEIGH,17)
     *                                  + GAM345(I) * PAMA(7)

              ENDIF
            ENDIF
          ENDDO

C  DECAY   K0L  ---->   PI(+) + PI(-) + PI(0)
        ELSE
          CALL DECAY6( PAMA(10), PAMA(8),PAMA(8),PAMA(7),
     *                 CKA(61),CKA(62),CKA(63), CKA(64), 1 )
C  PI(+)  AND  PI(-)  AND  PI(0)
          DO  I = 1, 3
            CALL ADDANG3( COSTHE,PHIX,PHIY, COS345(I),PHI345(I),
     *                                  SECPAR(2),SECPAR(3),SECPAR(4) )

            IF ( SECPAR(2) .GT. C(29) ) THEN

              IF ( I .EQ. 3 ) THEN
                SECPAR(0) = 7.D0
              ELSE
                SECPAR(0) = 7 + I
              ENDIF
              SECPAR(1) = GAM345(I)
              CALL TSTACK
            ELSE
              IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT
                IF ( I .EQ. 3 ) THEN

                  DLONG(LHEIGH,17) = DLONG(LHEIGH,17)+GAM345(I)*PAMA(7)
                ELSE
                  DLONG(LHEIGH,17) = DLONG(LHEIGH,17)+GAM345(I)*PAMA(8)

                ENDIF
              ENDIF
            ENDIF
          ENDDO

        ENDIF
      ENDIF

C  KILL CURRENT PARTICLE
      IRET1 = 1

      RETURN
      END

*-- Author :    The CORSIKA development group   16/05/1995
C=======================================================================

      SUBROUTINE LONGFT( FPARAM,CHI2 )

C-----------------------------------------------------------------------
C  LONG(ITUDINAL) F(I)T
C
C  THIS ROUTINE PERFORMS A FIT TO THE LONGITUDINAL DISTRIBUTION OF AN
C  AIR SHOWER. DUE TO THE LARGE PARTICLE NUMBERS IN AN AIR SHOWER THE
C  STATISTICAL ERRORS ON THE PARTICLE NUMBER AT A GIVEN LEVEL ARE
C  MINUTE. THIS LEADS TO RATHER LARGE CHI**2/DOF FOR THE FITS EVEN IF
C  THE FITTED FUNCTION MATCHES THE POINTS BETTER THAN SAY 1%.
C  KEEP IN MIND THAT FITTING IS A DIFFICULT TASK AND THE RESULTS DO NOT
C  NECESSARILY REPRESENT THE ABOLUTE MINIMUM OR EVEN A GOOD
C  APPROXIMATION.
C
C  IN A FIRST STEP A 4 PARAMETER FIT IS TRIED BASED ON M. HILLAS'' CURVE
C  WITH WIDTH PARAMETER LAMBDA :
C   N(T) = NMAX * ((T-T0)/(TMAX-T0))**((TMAX-T0)/P) * EXP((TMAX-T)/P)
C  WITH:
C   NMAX = PARTICLE NUMBER AT TMAX
C   T    = DEPTH IN G/CM**2
C   T0   = STARTING DEPTH OF SHOWER
C   TMAX = DEPTH OF SHOWER MAXIMUM
C   P    = WIDTH PARAMETER LAMBDA
C
C  IN A SECOND STEP WE REFINE THE FIT WITH THE START VALUES FROM THE 4
C  PARAMETER FIT AND USE A 6 PARAMETER FIT BASED ON M. HILLAS'' CURVE
C  REPLACING HIS WIDTH PARAMETER LAMBDA BY A POLYNOMIAL OF 3. DEGREE.
C   N(T) = NMAX * ((T-T0)/(TMAX-T0))**((TMAX-T0)/(P1+P2*T+P3*T**2))
C               * EXP((TMAX-T)/(P1+P2*T+P3*T**2))
C  WITH:
C   NMAX = PARTICLE NUMBER AT TMAX
C   T    = DEPTH IN G/CM**2
C   T0   = STARTING DEPTH OF SHOWER
C   TMAX = DEPTH OF SHOWER MAXIMUM
C   P1 .. P3 = PARAMETERS OF A POLYNOMIAL DESCRIBING THE WIDTH
C
C  THIS SUBROUTINE IS CALLED FROM AAMAIN.
C  ARGUMENTS:
C   FPARAM = ARRAY WITH THE FINAL FITTED PARAMETERSTHE 6 PARAMETER
C   CHI2   = CHI SQUARED
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCURVE/ CHAPAR,DEP,ERR,NSTP
      DOUBLE PRECISION CHAPAR(1200),DEP(1200),ERR(1200)
      INTEGER          NSTP

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      INTEGER          NPAR
      PARAMETER        (NPAR=6)
      DOUBLE PRECISION F(NPAR),FPARAM(NPAR),CHI2,CHISQ,CHISQ1
      DOUBLE PRECISION P(NPAR+1,NPAR),Y(NPAR+1),EPS
      DOUBLE PRECISION P1(NPAR-1,NPAR-2),FPARAM1(NPAR-2),CHI21
      DOUBLE PRECISION HALFW,T0,TMAX,NMAX,FAC
      INTEGER          I,II,ILOWER,IMAX,IUPPER,J,JJ,K,ITER,IFLAG
      SAVE
      EXTERNAL         CHISQ,CHISQ1
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,*) 'LONGFT:'

C  FIND GOOD START VALUES FOR XMAX AND FMAX
      NMAX = 0.D0
      TMAX = 400.D0
      IMAX = 0
      DO  I = 1, NSTP
        ERR(I) = MAX( 1.D0, SQRT( CHAPAR(I) ) )
        IF ( CHAPAR(I) .GT. NMAX ) THEN
          NMAX = CHAPAR(I)
          TMAX = DEP(I)
          IMAX = I
        ENDIF
      ENDDO
C  STARTVALUE FOR X0 IS ABOUT WHERE MORE THAN 1 PARTICLE SHOWS UP
      II = 1
      DO  I = 1, NSTP
        IF ( CHAPAR(I) .GT. 1.D0 ) GOTO 1
        II = I
      ENDDO
C  OBVIOUSLY WE HAVE NO PARTICLES IN THE DISTRIBUTION
      WRITE(MONIOU,*)
     *         'LONGFT: NO PARTICLES IN LONGITUDINAL DISTRIBUTION'
      WRITE (MONIOU,*)'        NO FIT POSSIBLE'
      DO  I = 1, NPAR
        FPARAM(I) = 0.D0
      ENDDO
      CHI2 = 0.D0
      RETURN

 1    CONTINUE
      IF ( II .GT. 1 ) THEN
        T0 = 0.5 * ( DEP(II) + DEP(II-1) )
      ELSE
        T0 = DEP(II)
      ENDIF
C  FIND A START VALUE FOR THE WIDTH PARAMETER AT HALF OF MAXIMUM
      IF ( NSTP .GT. 10 ) THEN
        DO  I = 1, IMAX
          IF ( CHAPAR(I) .GT. 0.5D0*NMAX ) THEN
            IUPPER = I
            GOTO 31
          ENDIF
        ENDDO
        IUPPER = IMAX - 1
 31     CONTINUE
        DO  I = IMAX, NSTP
          IF ( CHAPAR(I) .LT. 0.5D0*NMAX ) THEN
            ILOWER = I
            GOTO 32
          ENDIF
        ENDDO
        ILOWER = NSTP - 1
 32     CONTINUE
        HALFW = (DEP(ILOWER) - DEP(IUPPER)) /3.9D0
      ELSE
C  IF WE HAVE ONLY A FEW POINTS, TAKE AN AVERAGE VALUE FOR THE WIDTH
        HALFW = 70.D0
      ENDIF

C-----------------------------------------------------------------------
C  FIT IS PERFORMED WITH THE SUBROUT. AMOEBA FROM:
C      NUMERICAL RECIPES, W.H. PRESS ET AL.,
C      CAMBRIDGE UNIVERSITY PRESS, 1992  ISBN 0 521 43064 X
C  SEE THERE HOW IT HAS TO BE USED.

C  WE FIRST FIT THE GAISSER-HILLAS CURVE WITH SIMPLE WIDTH PARAMETER
C  THERFORE THE NUMBER OF FREE PARAMETERS IS SET TO 4 = NPAR-2
C  CREATE A SET OF NPAR-1 STARTING VERTICES
C  HERE IS THE FIRST ONE
      P1(1,1) = NMAX
      P1(1,2) = T0
      P1(1,3) = TMAX
      P1(1,4) = HALFW
      IF (DEBUG) WRITE(MDEBUG,*) 'LONGFT: START VALS=',(P1(1,I),I=1,4)

C  LOOP OVER FITTING ROUTINE (2 TIMES 3 FITS WITH VARYING PRECISION)
      DO  J = 1, 2
        DO  JJ = 1, 3
C  START WITH CRUDE PRECISION AND IMPROVE STEP BY STEP
C  AFTER THREE STEPS ENLARGE AGAIN
          EPS = 10.D0**(-3.D0-JJ*0.5D0)
          FAC = 1.D0 + 2.D0**(2.1D0*(1.D0-JJ))
C  GO AS WELL IN DIFFERENT DIRECTIONS
          IF ( J .EQ. 2 ) FAC = 1.D0/FAC
C  GET OTHER NPAR-2 STARTING VERTICES FROM THE STARTING POINT BY
C  VARIATION OF ONLY ONE OF THE COORDINATE VALUES
          DO  I = 2, NPAR-1
            DO  K = 1, NPAR-2
              P1(I,K) = P1(1,K)
            ENDDO
            IF ( P1(I,I-1) .EQ. 0.D0 ) THEN
              P1(I,I-1) = 1.D0
            ELSE
              P1(I,I-1) = P1(I,I-1) * FAC
            ENDIF
          ENDDO
          IF ( DEBUG ) WRITE(MDEBUG,*) 'LONGFT: TRIAL1,FAC,EPS ',
     *                                               J,FAC,EPS
C  CALCULATE FUNCTION VALUES AT THE START VERTICES
          DO  I = 1, NPAR-1
            DO  K = 1, NPAR-2
              F(K) = P1(I,K)
            ENDDO
            Y(I) = CHISQ1(F)
          ENDDO
C  PERFORM A FIT
          CALL AMOEBA( P1,Y,NPAR-1,NPAR-2,NPAR-2,EPS,CHISQ1,ITER,IFLAG )
          IF ( DEBUG ) THEN
            WRITE(MDEBUG,*) 'LONGFT: ITER1/IFLAG=',ITER,IFLAG
            WRITE(MDEBUG,*) 'LONGFT: PARAMETERS1=',(SNGL(P1(1,K)),K=1,4)
            WRITE(MDEBUG,*) 'LONGFT: CHISQ2     =',Y(1)
          ENDIF

C  STORE CHI**2 AT FIRST TRIAL OR AT IMPROVED RESULT
          IF ( J .EQ. 1  .OR.  Y(1) .LT. CHI2 ) THEN
            DO  I = 1, NPAR-2
              FPARAM1(I) = P1(1,I)
            ENDDO
            CHI21 = Y(1)
          ENDIF
C  END OF LOOPS OVER THE FITTING ROUTINE
        ENDDO
      ENDDO
      IF (DEBUG) WRITE(MDEBUG,*) 'LONGFIT: INTERMEDIATE PARAMETERS ARE',
     *                   (SNGL(FPARAM1(I)),I=1,4),CHI21
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  CREATE A SET OF NPAR+1 STARTING VERTICES
C  HERE IS THE FIRST ONE (THE FIRST FOUR PARAMETERS REMAIN UNCHANGED)
C  EXPERIENCE SHOWS, THAT THE FIFTH PARAMETER IS USUALLY NEGATIVE
      P(1,1) = FPARAM1(1)
      P(1,2) = FPARAM1(2)
      P(1,3) = FPARAM1(3)
      P(1,4) = FPARAM1(4)
**    P(1,5) = -0.01D0 ! GIVES SOMETIMES EXTREMELY BAD FITS (OCT. 00 DH)
      P(1,5) = 0.D0
      P(1,6) = 0.D0

C  LOOP OVER THE FITTING ROUTINE (2 TIMES 5 FITS WITH VARYING PRECISION)
      DO  J = 1, 2
        DO  JJ = 1, 5
C  START WITH CRUDE PRECISION AND IMPROVE STEP BY STEP
C  AFTER FIVE STEPS ENLARGE AGAIN
          EPS = 10.D0**(-3.D0-JJ*0.5D0)
          FAC = 1.D0 + 2.D0**(2.1D0*(1.D0-JJ))
C  GO AS WELL IN DIFFERENT DIRECTIONS
          IF ( J .EQ. 2 ) FAC = 1.D0/FAC
C  GET OTHER NPAR STARTING VERTICES FROM THE STARTING POINT BY VARIATION
C  OF ONLY ONE OF THE COORDINATE VALUES
          DO  I = 2, NPAR+1
            DO  K = 1, NPAR
              P(I,K) = P(1,K)
            ENDDO
            IF ( P(I,I-1) .EQ. 0.D0 ) THEN
              P(I,I-1) = 1.D0
            ELSE
              P(I,I-1) = P(I,I-1) * FAC
            ENDIF
          ENDDO
          IF ( DEBUG ) WRITE(MDEBUG,*) 'LONGFT: TRIAL,FAC,EPS ',J,
     *                                     SNGL(FAC),SNGL(EPS)
C  CALCULATE FUNCTION VALUES AT THE START VERTICES
          DO  I = 1, NPAR+1
            DO  K = 1, NPAR
              F(K) = P(I,K)
            ENDDO
            Y(I) = CHISQ(F)
          ENDDO
C  PERFORM A FIT
          CALL AMOEBA( P,Y,NPAR+1,NPAR,NPAR,EPS,CHISQ,ITER,IFLAG )
          IF ( DEBUG ) THEN
            WRITE(MDEBUG,*) 'LONGFT: ITER/IFLAG=',ITER,IFLAG
            WRITE(MDEBUG,*) 'LONGFT: PARAMETERS=',(SNGL(P(1,K)),K=1,6)
            WRITE(MDEBUG,*) 'LONGFT: CHISQ     =',SNGL(Y(1))
          ENDIF
C  STORE VALUES AT FIRST TRIAL OR AT IMPROVED RESULT
          IF ( J .EQ. 1  .OR.  Y(1) .LT. CHI2 ) THEN
            DO  I = 1, NPAR
              FPARAM(I) = P(1,I)
            ENDDO
            CHI2 = Y(1)
          ENDIF
C  END OF LOOPS OVER THE FITTING ROUTINE
        ENDDO
      ENDDO

      RETURN
      END

*-- Author :    K. BERNLOEHR MPIK HEIDELBERG    15/06/1998
C=======================================================================

      SUBROUTINE LOWUP( CHAR )

C-----------------------------------------------------------------------
C  (CONVERTS) LOW(ER CASE CHARACTER TO) UP(PER CASE CHARACTER)
C
C  THIS SUBROUTINE IS CALLED FROM DATAC.
C  ARGUMENT:
C   CHAR   =  CHARACTER TO BE CONVERTED
C-----------------------------------------------------------------------

      IMPLICIT NONE

      INTEGER          IDX
      CHARACTER*1      CHAR
      CHARACTER        LOWCHR*26, UPRCHR*26
      SAVE
      DATA             UPRCHR/'ABCDEFGHIJKLMNOPQRSTUVWXYZ'/
      DATA             LOWCHR/'abcdefghijklmnopqrstuvwxyz'/
C-----------------------------------------------------------------------

      IDX = INDEX(LOWCHR,CHAR)
      IF ( IDX .NE. 0 ) CHAR = UPRCHR(IDX:IDX)

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE       15/10/1996
C=======================================================================

      SUBROUTINE MMOL4( Y,X,VAL,ARG,EPS,IER )

C-----------------------------------------------------------------------
C  M(UON) MOL(IERE SCATTERING) 4 (POINT CONTINUED FRACT. INTERPOLATION)
C
C  ROUTINE TAKEN FROM IBM SCIENTIFIC SUBROUT. PACKAGE
C  ROUTINE TAKEN FROM GEANT321 (CERN)
C  4 POINT CONTINUED FRACTION INTERPOLATION.
C  THIS SUBROUTINE IS CALLED FROM MMOLIE.
C  ARGUMENTS:
C   Y      = INTERPOLATED VALUE FOR THE ARGUMENT X
C   X      = ARGUMENT FOR Y
C   VAL    = VALUE ARRAY
C   ARG    = ARGUMENT ARRAY
C   EPS    = DESIRED ACCURACY
C   IER    = OUTPUT ERROR PARAMETER
C             0 ACCURACY O.K.
C             1 ACCURACY CAN NOT BE TESTED IN 4TH ORDER INTERPOLATION
C             2 TWO IDENTICAL ELEMENTS IN THE ARGUMENT ARRAY
C-----------------------------------------------------------------------

      IMPLICIT  NONE

      REAL      ARG(4),AUX,DELT,EPS,H,P1,P2,P3,Q1,Q2,Q3,VAL(4),X,Y,Z
      INTEGER   I,II,III,IER,J,JEND
      SAVE
C-----------------------------------------------------------------------

      IER = 1
      Y   = VAL(1)
      P2  = 1.
      P3  = Y
      Q2  = 0.
      Q3  = 1.
      DO  16  I = 2, 4
        II = 0
        P1 = P2
        P2 = P3
        Q1 = Q2
        Q2 = Q3
        Z  = Y
        JEND = I - 1
   3    AUX  = VAL(I)
        DO  10  J = 1, JEND
          H = VAL(I) - VAL(J)
          IF ( ABS(H) .GT. 1.E-6*ABS(VAL(I)) ) GOTO 9
          IF ( ARG(I) .EQ. ARG(J) ) GOTO 17
          IF ( J .LT. JEND ) GOTO 8
          II  = II + 1
          III = I + II
          IF ( III .GT. 4 ) GOTO 19
          VAL(I)   = VAL(III)
          VAL(III) = AUX
          AUX      = ARG(I)
          ARG(I)   = ARG(III)
          ARG(III) = AUX
          GOTO 3
   8      VAL(I) = 1.E36
          GOTO 10
   9      VAL(I) = ( ARG(I)-ARG(J) ) / H
  10    CONTINUE
        P3 = VAL(I) * P2 + ( X - ARG(I-1) ) * P1
        Q3 = VAL(I) * Q2 + ( X - ARG(I-1) ) * Q1
        IF ( Q3. NE. 0. ) THEN
          Y = P3 / Q3
        ELSE
          Y = 1.E36
        ENDIF
        DELT = ABS(Z-Y)
        IF ( DELT .LE. EPS ) GOTO 19
  16  CONTINUE
      RETURN
  17  IER = 2
      RETURN
  19  IER = 0

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE       15/10/1996
C=======================================================================

      SUBROUTINE MMOLIE( OMEGA,DENS )

C-----------------------------------------------------------------------
C   M(UON) MOLIE(RE MULTIPLE SCATTERING)
C
C  TREATES MOLIERE MULTIPLE SCATTERING FOR MUONS
C  CORRECTED FOR FINITE ANGLE SCATTERING
C  THIS SUBROUTINE IS IN ANALOGY WITH SUBROUT. GMOLIE.
C  (AUTHOR: M.S.DIXIT, NRCC, OTTAWA) OF GEANT321
C  SEE CERN PROGRAM LIBRARY LONG WRITEUP W5013
C  THIS SUBROUTINE IS CALLED FROM UPDATE.
C  ARGUMENTS:
C   OMEGA  = NUMBER OF SCATTERINGS FOR THE STEP
C   DENS   = LOCAL DENSITY
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRMUMULT/CHC,OMC,PHISCT,STEPL,VSCAT,FMOLI
      DOUBLE PRECISION CHC,OMC,PHISCT,STEPL,VSCAT
      LOGICAL          FMOLI

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION TINT(40),B,BINV,CHIC,CNST,DB,DENS,OMEGA,SINTH,
     *                 TEST,TMP,XINT
      REAL             ARG(4),F0I(40),F1I(40),F2I(40),
     *                 THRED(40),VAL(4),F,THRI,XINT2
      INTEGER          IER,JA,L,M,NA,NA3,NA3M,NMAX
      SAVE

      DATA THRED/  0.00, 0.10, 0.20, 0.30
     +          ,  0.40, 0.50, 0.60, 0.70
     +          ,  0.80, 0.90, 1.00, 1.10
     +          ,  1.20, 1.30, 1.40, 1.50
     +          ,  1.60, 1.70, 1.80, 1.90
     +          ,  2.00, 2.20, 2.40, 2.60
     +          ,  2.80, 3.00, 3.20, 3.40
     +          ,  3.60, 3.80, 4.00, 5.00
     +          ,  6.00, 7.00, 8.00, 9.00
     +          , 10.00,11.00,12.00,13.00 /
      DATA F0I/
     +  0.000000E+00 ,0.995016E-02 ,0.392106E-01 ,0.860688E-01
     + ,0.147856E+00 ,0.221199E+00 ,0.302324E+00 ,0.387374E+00
     + ,0.472708E+00 ,0.555142E+00 ,0.632121E+00 ,0.701803E+00
     + ,0.763072E+00 ,0.815480E+00 ,0.859142E+00 ,0.894601E+00
     + ,0.922695E+00 ,0.944424E+00 ,0.960836E+00 ,0.972948E+00
     + ,0.981684E+00 ,0.992093E+00 ,0.996849E+00 ,0.998841E+00
     + ,0.999606E+00 ,0.999877E+00 ,0.999964E+00 ,0.999990E+00
     + ,0.999998E+00 ,0.999999E+00 ,0.100000E+01 ,0.100000E+01
     + ,0.100000E+01 ,0.100000E+01 ,0.100000E+01 ,0.100000E+01
     + ,1.000000E+00 ,1.000000E+00 ,1.000000E+00 ,1.000000E+00 /
      DATA F1I/
     +   0.000000E+00, 0.414985E-02, 0.154894E-01, 0.310312E-01
     + , 0.464438E-01, 0.569008E-01, 0.580763E-01, 0.468264E-01
     + , 0.217924E-01,-0.163419E-01,-0.651205E-01,-0.120503E+00
     + ,-0.178272E+00,-0.233580E+00,-0.282442E+00,-0.321901E+00
     + ,-0.350115E+00,-0.366534E+00,-0.371831E+00,-0.367378E+00
     + ,-0.354994E+00,-0.314803E+00,-0.266539E+00,-0.220551E+00
     + ,-0.181546E+00,-0.150427E+00,-0.126404E+00,-0.107830E+00
     + ,-0.933106E-01,-0.817375E-01,-0.723389E-01,-0.436650E-01
     + ,-0.294700E-01,-0.212940E-01,-0.161406E-01,-0.126604E-01
     + ,-0.102042E-01,-0.840465E-02,-0.704261E-02,-0.598886E-02/
      DATA F2I/
     +   0.000000    , 0.121500E-01, 0.454999E-01, 0.913000E-01
     + , 0.137300E+00, 0.171400E+00, 0.183900E+00, 0.170300E+00
     + , 0.132200E+00, 0.763000E-01, 0.126500E-01,-0.473500E-01
     + ,-0.936000E-01,-0.119750E+00,-0.123450E+00,-0.106300E+00
     + ,-0.732800E-01,-0.312400E-01, 0.128450E-01, 0.528800E-01
     + , 0.844100E-01, 0.114710E+00, 0.106200E+00, 0.765830E-01
     + , 0.435800E-01, 0.173950E-01, 0.695001E-03,-0.809500E-02
     + ,-0.117355E-01,-0.125449E-01,-0.120280E-01,-0.686530E-02
     + ,-0.385275E-02,-0.231115E-02,-0.147056E-02,-0.982480E-03
     + ,-0.682440E-03,-0.489715E-03,-0.361190E-03,-0.272582E-03/
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,*) 'MMOLIE: OMEGA=',SNGL(OMEGA),
     *                                    ' DENS=',SNGL(DENS)

C  COMPUTE VSCAT ANGLE FROM MOLIERE DISTRIBUTION
      VSCAT = 0.D0
      IF ( OMEGA .LE. ENEPER ) RETURN
      CNST  = LOG(OMEGA)
      B     = 5.D0
      DO  L = 1, 10
        IF ( ABS(B) .LT. 1.D-10 ) THEN
          B = 1.D-10
        ENDIF
        DB = - ((B - LOG(ABS(B)) - CNST)/(1.D0 - 1.D0/B))
        B  = B + DB
        IF ( ABS(DB) .LE. 0.0001D0 ) GOTO 20
      ENDDO
      RETURN
 20   CONTINUE
      IF ( B .LE. 0.D0 ) RETURN
C  CHC IS DEFINED DIFFERENTLY FROM GEANT
      CHIC = CHC * SQRT( CHI ) / ( PAMA(5) * GAMMA * BETA**2 )
      BINV = 1.D0/B
      TINT(1) = 0.D0
      DO  JA = 2, 4
        TINT(JA) = F0I(JA) + ( F1I(JA) + F2I(JA)*BINV ) * BINV
      ENDDO
      NMAX = 4
 40   CONTINUE
      CALL RMMARD( RD,2,1 )
      XINT = RD(2)
      DO  NA = 3, 40
        IF ( NA .GT. NMAX ) THEN
          TINT(NA) = F0I(NA) + ( F1I(NA) + F2I(NA)*BINV ) * BINV
          NMAX = NA
        ENDIF
        IF ( XINT .LE. TINT(NA-1) ) GOTO 60
      ENDDO
      IF ( XINT .LE. TINT(40) ) THEN
        NA = 40
        GOTO 60
      ELSE
        TMP  = 1.D0 - ( 1.D0 - B*(1.D0-XINT) )**5
        IF ( TMP .LE. 0.D0 ) GOTO 40
        THRI = 5.D0 / TMP
        GOTO 80
      ENDIF
 60   CONTINUE
      NA  = MAX(NA-1,3)
      NA3 = NA-3
      DO  M = 1, 4
        NA3M   = NA3 + M
        ARG(M) = TINT(NA3M)
        VAL(M) = THRED(NA3M)**2
      ENDDO
      F = THRED(NA) * .02D0
      XINT2 = XINT
      CALL MMOL4( THRI,XINT2,VAL,ARG,F,IER )
 80   CONTINUE
      VSCAT = CHIC * SQRT( ABS(B*THRI) )
      IF ( VSCAT .GT. PI ) GOTO 40
      SINTH = SIN( VSCAT )
      TEST  = VSCAT * (RD(1))**2
      IF ( TEST .GT. SINTH ) GOTO 40

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE       15/10/1996
C=======================================================================

      SUBROUTINE MPOISS( AMEAN,NPRAN )

C-----------------------------------------------------------------------
C   M(UON COULOMB SCATTERING) POISS(ON DISTRIBUTION)
C
C  GENERATES A RANDOM NUMBER POISSON DISTRIBUTED WITH MEAN VALUE AMEAN.
C  THIS SUBROUTINE IS IN ANALOGY WITH SUBROUT. GPOISS.
C  (AUTHOR: L. URBAN) OF GEANT321
C  SEE CERN PROGRAM LIBRARY LONG WRITEUP W5013.
C  THIS SUBROUTINE IS CALLED FROM MUCOUL.
C  ARGUMENTS:
C   AMEAN  =  MEAN VALUE OF RANDOM NUMBER
C   NPRAN  =  RANDOM NUMBER POISSON DISTRIBUTED
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION AMEAN,AN,HMXINT,P,PLIM,RR,S,X
      INTEGER          NPRAN
      SAVE
      DATA             PLIM/16.D0/,HMXINT/2.D9/
C-----------------------------------------------------------------------

C  PROTECTION AGAINST NEGATIVE MEAN VALUES
      AN = 0.D0
      IF ( AMEAN .GT. 0.D0 ) THEN
        IF ( AMEAN .LE. PLIM ) THEN
          CALL RMMARD( RD,1,1 )
          P  = EXP(-AMEAN)
          S  = P
          IF ( RD(1) .LE. S ) GOTO 20
 10       AN = AN + 1.D0
          P  = P * AMEAN / AN
          S  = S + P
          IF ( S .LT. RD(1)  .AND.  P .GT. 1.D-30 ) GOTO 10
        ELSE
          CALL RMMARD( RD,2,1 )
          RR = SQRT( (-2.D0)*LOG(RD(1)) )
          X  = RR * COS( PI2 * RD(2) )
          AN = MIN( MAX( 0.D0, AMEAN+X*SQRT( AMEAN ) ), HMXINT )
        ENDIF
      ENDIF
 20   NPRAN = AN

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE       25/09/1996
C=======================================================================

      SUBROUTINE MUBREM

C-----------------------------------------------------------------------
C  MU(ON) BREM(SSTRAHLUNG)
C
C  TREATES MUON BREMSSTRAHLUNG (WITHOUT POLARISATION EFFECTS)
C  IN ANALOGY WITH SUBROUT. GBREMM FROM GEANT WRITTEN BY L. URBAN
C  EXPLANATIONS SEE CERN PROGRM LIBRARY LONG WRITEUP W5013
C  THIS SUBROUTINE IS CALLED FROM MUTRAC.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRAIR/   COMPOS,PROBTA,AVERAW,AVOGDR
      DOUBLE PRECISION COMPOS(3),PROBTA(3),AVERAW,AVOGDR

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRELABCT/ELCUT
      DOUBLE PRECISION ELCUT(4)

      COMMON /CRGENER/ GEN,ALEVEL
      DOUBLE PRECISION GEN,ALEVEL

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRPOLAR/ POLART,POLARF
      DOUBLE PRECISION POLART,POLARF

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRREST/  CONTNE,TAR,LT
      DOUBLE PRECISION CONTNE(3),TAR
      INTEGER          LT

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSIGMU/ BREMSTAB,NUCTAB,PAIRTAB,DEDXMU,DEDXM,
     *                 FRABTN,FRANTN,FRAPTN,FRBTNO,FRNTNO,FRPTNO,
     *                 SIGBRM,SIGNUC,SIGPRM

      DOUBLE PRECISION BREMSTAB(141,3),NUCTAB(141,3),PAIRTAB(141,3),
     *                 DEDXMU(141,3),DEDXM(141),FRABTN,FRANTN,FRAPTN,
     *                 FRBTNO,FRNTNO,FRPTNO,SIGBRM,SIGNUC,SIGPRM

       

       

       

       

      DOUBLE PRECISION ALFA1,BETA1,COSTH3,CREJ,D,EKIN,F1,
     *                 PHI3,SCREJ,SIGNEW,SIGOLD,SINTH3,THETA3,
     *                 U,UMAX,V,VC,VM,V1,W1,Z
      INTEGER          I,JCOUNT
      SAVE
      DOUBLE PRECISION CBRSGM,THICK
      EXTERNAL         CBRSGM,THICK
      DATA             ALFA1/0.625D0/
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) (CURPAR(I),I=0,9)
  444 FORMAT(' MUBREM: CURPAR=',1P,10E11.3)

C  COPY VERTEX COORDINATES TO SECPAR
      DO  I = 5, 8
        SECPAR(I) = CURPAR(I)
      ENDDO
      SECPAR( 9) = GEN

      SECPAR(14) = CURPAR(14)
      SECPAR(15) = CURPAR(15)
      SECPAR(16) = CURPAR(16)

      IF ( LLONGI ) LHEIGH = INT( THICK( H )*THSTPI + 1.D0 )

C  TOTAL AND KINETIC ENERGY OF MUON
      EE   = PAMA(5) * GAMMA
      EKIN = EE - PAMA(5)
      IF ( EKIN .LE. BCUT ) THEN
C  MUON ENERGY IS TOO LOW TO PRODUCE BREMSSTRAHLUNG
        SECPAR(1) = CURPAR(1)
        GOTO 900
      ENDIF

C  CHECK THE REDUCED CROSS-SECTIONS AND SKIP INTERACTION EVENTUALLY
C  RESTORE OLD CROSS SECTION
      IF     ( LT .EQ. 1 ) THEN
        SIGOLD =  FRABTN / COMPOS(1)
      ELSEIF ( LT .EQ. 2 ) THEN
        SIGOLD = (FRBTNO - FRABTN) / COMPOS(2)
      ELSEIF ( LT .EQ. 3 ) THEN
        SIGOLD = (SIGBRM - FRBTNO) / COMPOS(3)
      ELSE
        WRITE(MONIOU,*) 'MUBREM: WRONG TARGET LT =',LT,' STOP'
        STOP
      ENDIF
C  GET NEW CROSS-SECTION
      SIGNEW = CBRSGM( EE,LT )
      CALL RMMARD( RD,1,1 )
      IF ( RD(1)*SIGOLD .GT. SIGNEW ) THEN
C  SKIP INTERACTION IF RANDOM NUMBER SMALLER THAN CROSS-SECTION RATIO
        SECPAR(1) = CURPAR(1)
        GOTO 900
      ENDIF

      VC = BCUT/EE
      VM = 1.D0 - CMUON(6+LT)/EE
      IF ( VM .LE. 0.D0 ) THEN
C  MAXIMUM OF BREMSSTRAHLUNG SPECTRUM IS NEGATIVE, NO BREMSSTRAHLUNG
        SECPAR(1) = CURPAR(1)
        GOTO 900
      ENDIF
      CREJ  = CMUON(3+LT)/EE

      JCOUNT = 0
  50  CONTINUE
      JCOUNT = JCOUNT + 1
      IF ( JCOUNT .GT. 1000 ) THEN
        SECPAR(1) = CURPAR(1)
        GOTO 900
      ENDIF
      CALL RMMARD( RD,2,1 )
      V     = VC*(VM/VC)**RD(1)
      V1    = 1.D0 - V
C  COMPUTE REJECTION FUNCTION
      F1    = CMUON(LT) - LOG(1.D0 + CREJ*V/V1)
      SCREJ = (V1 + 0.75D0*V*V)*F1/CMUON(LT)
      IF ( RD(2) .GT. SCREJ ) GOTO 50

C  GAMMA ENERGY
      SECPAR(1) = EE * V

C  RADIATED GAMMA BELOW CUT?
      IF ( SECPAR(1) .LE. ELCUT(4) ) THEN
        IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

          DLONG(LHEIGH,1) = DLONG(LHEIGH,1) + SECPAR(1)

        ENDIF
C  REDUCE ENERGY OF MUON
        GOTO 800
      ENDIF

C  SET MATERIAL CONSTANTS CMUON(.) ACCORDING TO
C  TARGET INDEX LT (1=N, 2=O, 3=AR)  WHICH HAS BEEN SET IN BOX2
      IF     ( LT .EQ. 1 ) THEN
        Z = 7.D0
      ELSEIF ( LT .EQ. 2 ) THEN
        Z = 8.D0
      ELSE
        Z = 18.D0
      ENDIF

C  GENERATE EMITTED GAMMA ANGLES WITH RESPECT TO MUON DIRECTION
C  PHI IS GENERATED ISOTROPICALLY AND THETA IS ASSIGNED A UNIVERSAL
C  ANGULAR DISTRIBUTION WITH D=D(Z,E,V)
C  THIS FUNCTION APPROXIMATES THE REAL DISTRIBUTION FUNCTION WHICH CAN
C  BE FOUND IN: YUNG-SU TSAI, REV. MOD. PHYS. 46(1974)815
C                   +ERRATUM: REV. MOD. PHYS. 49(1977)421
      D = 0.13D0 *(0.8D0 + 1.3D0/Z) * (100.D0 + 1.D0/EE) * (1.D0 + V)
      W1   = 9.D0 / (9.D0 + D)
      UMAX = EE * PI / PAMA(5)
 10   CONTINUE
      CALL RMMARD( RD,3,1 )
      IF ( RD(1) .LE. W1 ) THEN
        BETA1 = ALFA1
      ELSE
        BETA1 = 3.D0 * ALFA1
      ENDIF
      U = (- LOG( RD(2) * RD(3) ) / BETA1)
C  CUT: THETA SHOULD BE .LE. PI  !
C  THIS CONDITION DEPENDS ON E IN THE CASE OF D=CONST TOO!
      IF ( U .GE. UMAX ) GOTO 10

      THETA3 = U * PAMA(ITYPE) / EE
      COSTH3 = COS( THETA3 )
      SINTH3 = SIN( THETA3 )
      CALL RMMARD( RD,1,1 )

      PHI3   = PI2 * RD(1)
      CALL ADDANG3( COSTHE,PHIX,PHIY, COSTH3,PHI3,
     *                                SECPAR(2),SECPAR(3),SECPAR(4) )

      IF ( SECPAR(2) .GT. C(29) ) THEN

C  WRITE BREMSSTRAHLUNG GAMMA TO STACK
        SECPAR( 0) = 1.D0
        SECPAR(10) = H
        CALL TSTACK
      ELSE
        IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

          DLONG(LHEIGH,11) = DLONG(LHEIGH,11) + SECPAR(1)

        ENDIF
      ENDIF

C  REDUCE ENERGY OF MUON
 800  CONTINUE
      EE        = EE * V1
      SECPAR(1) = EE/PAMA(5)

 900  CONTINUE
C  WRITE MUON TO STACK
      SECPAR( 0) = CURPAR(0)
      SECPAR( 2) = CURPAR(2)
      SECPAR( 3) = CURPAR(3)
      SECPAR( 4) = CURPAR(4)
      SECPAR(10) = ALEVEL
      CALL TSTACK

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE       15/10/1996
C=======================================================================

      SUBROUTINE MUCOUL( OMEGA,DENS )

C-----------------------------------------------------------------------
C   MU(ON) COUL(OMB SCATTERING OF SINGLE SCATTERING EVENTS)
C
C  TREATES SINGLE COULOMB SCATTERING FOR MUONS IN SMALL ANGLE
C  APPROXIMATION.
C  THIS SUBROUTINE IS IN ANALOGY WITH SUBROUT. GMCOUL
C  (AUTHOR: G. LYNCH, LBL) OF GEANT321
C  SEE CERN PROGRAM LIBRARY LONG WRITEUP W5013
C  THIS SUBROUTINE IS CALLED FROM UPDATE.
C  ARGUMENTS:
C   OMEGA  = NUMBER OF SCATTERINGS FOR THE STEP
C   DENS   = LOCAL DENSITY
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRMUMULT/CHC,OMC,PHISCT,STEPL,VSCAT,FMOLI
      DOUBLE PRECISION CHC,OMC,PHISCT,STEPL,VSCAT
      LOGICAL          FMOLI

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION DENS,OMCF,OMEGA,OMEGA0,PHIS,SUMX,SUMY,
     *                 THET,THMIN2
      INTEGER          I,NSCMX,NSCA
      SAVE
      DATA             OMCF/1.167D0/,NSCMX/50/
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,*) 'MUCOUL: OMEGA=',SNGL(OMEGA),
     *                                     ' DENS=',SNGL(DENS)

C  COMPUTE NUMBER OF SCATTERS (POISSON DISTR. WITH MEAN OMEGA0)
      OMEGA0 = OMCF*OMEGA
      CALL MPOISS( OMEGA0,NSCA )
      IF ( NSCA .LE. 0 ) THEN
        VSCAT = 0.D0
        RETURN
      ENDIF
      NSCA = MIN( NSCA, NSCMX )
      CALL RMMARD( RD,2*NSCA,1 )

C  THMIN2 IS THE SCREENING ANGLE
      THMIN2 = CHC**2/( OMCF*OMC * (PAMA(5)*BETA*GAMMA)**2 )
      SUMX   = 0.D0
      SUMY   = 0.D0
      DO  I = 1, NSCA
        THET = SQRT( THMIN2*((1.D0/RD(I)) - 1.D0) )
        PHIS = PI2 * RD(NSCA+I)
        SUMX = SUMX + THET * COS( PHIS )
        SUMY = SUMY + THET * SIN( PHIS )
      ENDDO
      VSCAT  = SQRT( SUMX**2 + SUMY**2 )

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE MUDECY

C-----------------------------------------------------------------------
C  MU(ON) DEC(A)Y
C
C  TREATES DECAY OF MUON INTO ELECTRON (INCLUDING POLARISATION EFFECTS)
C  INCLUDING NEUTRINOS, IF SELECTED.
C  THIS SUBROUTINE IS CALLED FROM MUTRAC.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRGENER/ GEN,ALEVEL
      DOUBLE PRECISION GEN,ALEVEL

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRPOLAR/ POLART,POLARF
      DOUBLE PRECISION POLART,POLARF

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION AUX2,COSDE,COSTH3,COS3CM,COS3C1,COS3C2,
     *                 E3CM,GAMMA3,GAMMA4,PHINN,PHI3CM,PHI3C2,PHI31,
     *                 P3CM,THICK,XI
      INTEGER          I
      SAVE
      EXTERNAL         THICK
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) (CURPAR(I),I=0,9)
  444 FORMAT(' MUDECY: CURPAR=',1P,10E11.3)

C  COPY VERTEX COORDINATES TO SECPAR
      DO  I = 5, 8
        SECPAR(I) = CURPAR(I)
      ENDDO
      SECPAR( 9) = GEN
      SECPAR(10) = ALEVEL

      SECPAR(14) = CURPAR(14)
      SECPAR(15) = CURPAR(15)
      SECPAR(16) = CURPAR(16)

      IF ( LLONGI ) LHEIGH = INT( THICK( H )*THSTPI + 1.D0 )

C  MUON DECAYS INTO ELECTRON AND NEUTRINOS
      XI    = 2*ITYPE - 11
C  ELECTRON ENERGY SPECTRUM  N(E) * DE = CONST * E**2 * (3/2*E0-E) * DE
C  IS GAINED BY THE REJECTION/REFLECTION METHOD
   6  CONTINUE
      CALL RMMARD( RD,4,1 )
      IF ( RD(1)**2*(3.D0-RD(1)*2.D0) .LT. RD(2) ) RD(1) = 1.D0-RD(1)
      E3CM  = PAMA(2) + RD(1) * ( C(8) - PAMA(2) )
      IF ( E3CM .GT. 0.5D0*PAMA(5) ) GOTO 6
      P3CM  = SQRT( (E3CM-PAMA(2)) * (E3CM+PAMA(2)) )
C  NOW DETERMINE COS3C1 AND PHI31 BY RANDOM SELECTION
C  WITH RESPECT TO THE POLARIZATION DIRECTION OF THE MUON IN THE MU CM
C  GIVEN BY POLART, POLARF
      COSDE = 2.D0 * RD(4) - 1.D0
      AUX2  = ( 1.D0 - 2.D0*RD(1) ) / ( 3.D0 - 2.D0*RD(1) )
      IF ( ABS(AUX2) .GT. 1.D-2 ) THEN
        COS3C1 = XI*(SQRT(1.D0-(2.D0*COSDE-AUX2)*AUX2) - 1.D0) / AUX2
      ELSE
        COS3C1 = (-XI) * COSDE
      ENDIF
      PHI31 = RD(3) * PI2

C  NOW ADD ELECTRON EMISSION ANGLE COS3C1 TO THE POLARISATION DIRECTION
C  TO GET THE DIRECTION (RELATIVE TO THE CORSIKA COORDINATE SYSTEM)
      CALL ADDANG( POLART,POLARF, COS3C1,PHI31, COS3C2,PHI3C2 )
C  GET THE ELECTRON DIRECTION RELATIVE TO THE MUON LAB DIRECTION

      IF ( CURPAR(3) .NE. 0.D0  .OR.  CURPAR(4) .NE. 0.D0 ) THEN
        PHINN = ATAN2( CURPAR(4), CURPAR(3) )
      ELSE
        PHINN = 0.D0
      ENDIF

      CALL ADDANI( CURPAR(2),PHINN, COS3C2,PHI3C2, COS3CM,PHI3CM )
C  LORENTZ TRANSFORMATION TO THE LAB SYSTEM
      GAMMA3  = GAMMA * ( E3CM + BETA * P3CM * COS3CM ) / PAMA(2)
      COSTH3  = MIN( 1.D0, GAMMA * (P3CM * COS3CM + BETA * E3CM) /
     *                (PAMA(2) * SQRT( (GAMMA3-1.D0)*(GAMMA3+1.D0) )) )
      CALL ADDANG3( CURPAR(2),CURPAR(3),CURPAR(4), COSTH3,PHI3CM,
     *                                  SECPAR(2),SECPAR(3),SECPAR(4) )

      IF ( SECPAR(2) .GT. C(29) ) THEN

        SECPAR(0) = ITYPE - 3
        SECPAR(1) = GAMMA3
        CALL TSTACK
      ELSE
        IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT
          IF ( ITYPE .EQ. 5 ) THEN

            DLONG(LHEIGH,13) = DLONG(LHEIGH,13) + (GAMMA3+1.D0)*PAMA(2)
          ELSE
            DLONG(LHEIGH,13) = DLONG(LHEIGH,13) + (GAMMA3-1.D0)*PAMA(2)

          ENDIF
        ENDIF
      ENDIF
      POLART = 0.D0
      POLARF = 0.D0

      IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT
        GAMMA4 = GAMMA * PAMA(5) - GAMMA3 * PAMA(2)

        DLONG(LHEIGH,8) = DLONG(LHEIGH,8) + GAMMA4

      ENDIF

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   13/06/2003
C=======================================================================

      SUBROUTINE MUNUCL

C-----------------------------------------------------------------------
C  MU(ON) NUCL(EAR INTERATION)
C
C  TREATES MUON NUCLEAR INTERACTION
C  IN ANALOGY WITH SUBR. GMUNU OF BOTTAI & PERRONE.
C  SEE: S. BOTTAI AND L. PERRONE, NUCL. INST. METH. A459 (2001) 319
C       L.B. BEZRUKOV AND E.V. BUGAEV, SOV.J.NUCL.PHYS. 33 (1981) 635
C  THIS SUBROUTINE IS CALLED FROM MUTRAC.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRAIR/   COMPOS,PROBTA,AVERAW,AVOGDR
      DOUBLE PRECISION COMPOS(3),PROBTA(3),AVERAW,AVOGDR

      COMMON /CRBUFFS/ RUNH,RUNE,EVTH,EVTE,DATAB,ARRAYLONG,LH
      INTEGER          MAXBUF,MAXLEN
      PARAMETER        (MAXLEN=16)

      PARAMETER        (MAXBUF=39*7)
      REAL             RUNH(MAXBUF),EVTH(MAXBUF),EVTE(MAXBUF),
     *                 RUNE(MAXBUF),DATAB(MAXBUF),ARRAYLONG(MAXBUF)
      INTEGER          LH
      CHARACTER*4      CRUNH,CRUNE,CEVTH,CEVTE,CLONG
      EQUIVALENCE      (RUNH(1),CRUNH), (RUNE(1),CRUNE)
      EQUIVALENCE      (EVTH(1),CEVTH), (EVTE(1),CEVTE)
      EQUIVALENCE      (ARRAYLONG(1),CLONG)

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CREGSDEB/JCLOCK,NCLOCK,FEGSDB
      INTEGER          JCLOCK,NCLOCK
      LOGICAL          FEGSDB

      COMMON /CRELABCT/ELCUT
      DOUBLE PRECISION ELCUT(4)

      COMMON /CRGENER/ GEN,ALEVEL
      DOUBLE PRECISION GEN,ALEVEL

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRMULT/  EKINL,MSMM,MULTMA,MULTOT
      DOUBLE PRECISION EKINL
      INTEGER          MSMM,MULTMA(40,13),MULTOT(40,13)

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CROBSPAR/OBSLEV,THCKOB,XOFF,YOFF,HEIGHP,THETAP,PHIP,
     *                 THETPR,PHIPR,

     *                 VUECON,

     *                 NOBSLV
      DOUBLE PRECISION OBSLEV(20),THCKOB(20),XOFF(20),YOFF(20),
     *                 HEIGHP,THETAP,THETPR(2),PHIP,PHIPR(2)

      DOUBLE PRECISION VUECON(2)

      INTEGER          NOBSLV

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      COMMON /CRPION/  PI0MSQ,PITHR,PICMAS,PI0MAS,AMASK0,AMASKC,AMASPR,
     *                 AMASNT
      DOUBLE PRECISION PI0MSQ,PITHR,PICMAS,PI0MAS,AMASK0,AMASKC,AMASPR,
     *                 AMASNT

      COMMON /CRPOLAR/ POLART,POLARF
      DOUBLE PRECISION POLART,POLARF

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRREJECT/AVNREJ,ALTMIN,ANEXP,THICKA,THICKD,CUTLN,EONCUT,

     *                 FNPRIM
      DOUBLE PRECISION AVNREJ(20),ALTMIN(20),ANEXP(20),THICKA(20),
     *                 THICKD(20),CUTLN,EONCUT

      LOGICAL          FNPRIM

      COMMON /CRREST/  CONTNE,TAR,LT
      DOUBLE PRECISION CONTNE(3),TAR
      INTEGER          LT

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSIGMU/ BREMSTAB,NUCTAB,PAIRTAB,DEDXMU,DEDXM,
     *                 FRABTN,FRANTN,FRAPTN,FRBTNO,FRNTNO,FRPTNO,
     *                 SIGBRM,SIGNUC,SIGPRM

      DOUBLE PRECISION BREMSTAB(141,3),NUCTAB(141,3),PAIRTAB(141,3),
     *                 DEDXMU(141,3),DEDXM(141),FRABTN,FRANTN,FRAPTN,
     *                 FRBTNO,FRNTNO,FRPTNO,SIGBRM,SIGNUC,SIGPRM

      COMMON /CRSTACKE/E,TIM,U,V,W,X,Y,Z,DNEAR,

     *                 ZAP,WAP,WA,

     *                 IQ,IGEN,IR,IOBS,LPCTE,NP
      DOUBLE PRECISION E(60),TIM(60),U(60),V(60),W(60),
     *                 X(60),Y(60),Z(60),DNEAR(60)

     *                 ,ZAP(60),WAP(60),WA(60)

      INTEGER          IQ(60),IGEN(60),IR(60),IOBS(60),LPCTE(60),NP

       

       

       

       

      DOUBLE PRECISION ALPHFA,AM21,AM22,APH,CSI,ELE1,ELE2
      PARAMETER        (ALPHFA = 7.297353D-3)
C  BEZRUKOV''S M1**2 AND M2**2
      PARAMETER        (AM21    = 0.54D0)       ! SQUARE MASS IN GEV**2
      PARAMETER        (AM22    = 1.80D0)       ! SQUARE MASS IN GEV**2
      PARAMETER        (APH    = 0.00282D0)
C  BEZRUKOV''S XI (POLARISATION DEPENDENCE) = CSI
      PARAMETER        (CSI    = 0.25D0)
      PARAMETER        (ELE1   = 0.0808D0)
      PARAMETER        (ELE2   = -0.4525D0)

      DOUBLE PRECISION ARGO,AUXIL1,BPH,COEF,COEF1,COSTH3,CPH,
     *                 DPH,EKIN,EPH,E1,FACTO,FPH,GG,GMAX,GMIN,HHH,PHI3,
     *                 SS,SIGN,SIGNEW,SIGOLD,SNI,SNIMAX,SNIMIN,
     *                 TTT,VPH,VPH1,VPH2,ZZZ
      INTEGER          I,JCOUNT
      SAVE
      DOUBLE PRECISION CNUSGM,THICK
      EXTERNAL         CNUSGM,THICK
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) (CURPAR(I),I=0,9)
  444 FORMAT(' MUNUCL: CURPAR=',1P,10E11.3)

C  COPY VERTEX COORDINATES TO SECPAR
      DO  I = 5, 8
        SECPAR(I) = CURPAR(I)
      ENDDO
      SECPAR( 9) = GEN

      SECPAR(14) = CURPAR(14)
      SECPAR(15) = CURPAR(15)
      SECPAR(16) = CURPAR(16)
      IF ( LLONGI ) LHEIGH = INT( THICK( CURPAR(5) )*THSTPI + 1.D0 )

C  SET MATERIAL CONSTANTS ACCORDING TO TARGET INDEX LT (1=N, 2=O, 3=AR)
C  WHICH HAS BEEN SET IN BOX2, AND RESTORE OLD CROSS-SECTIONS
      IF     ( LT .EQ. 1 ) THEN
        AATOM  = 14.D0
        SIGOLD =  FRANTN / COMPOS(1)
      ELSEIF ( LT .EQ. 2 ) THEN
        AATOM  = 16.D0
        SIGOLD = (FRNTNO - FRANTN) / COMPOS(2)
      ELSEIF ( LT .EQ. 3 ) THEN
        AATOM  = 40.D0
        SIGOLD = (SIGNUC - FRNTNO) / COMPOS(3)
      ELSE
        WRITE(MONIOU,*) 'MUNUCL: WRONG TARGET LT=',LT,' STOP'
        STOP
      ENDIF

C  TOTAL AND KINETIC ENERGY OF MUON
      EE   = PAMA(5) * CURPAR(1)
      EKIN = EE - PAMA(5)
      IF ( EKIN .LE. BCUT ) RETURN
C  CHECK THE REDUCED CROSS-SECTIONS AND SKIP INTERACTION EVENTUALLY
      SIGNEW = CNUSGM( EE,LT )
      CALL RMMARD( RD,1,1 )
      IF ( RD(1)*SIGOLD .GT. SIGNEW ) THEN
C  SKIP INTERACTION IF RANDOM NUMBER SMALLER THAN CROSS-SECTION RATIO
        SECPAR(0) = CURPAR(0)
        SECPAR(1) = CURPAR(1)
        SECPAR(2) = CURPAR(2)
        SECPAR(3) = CURPAR(3)
        SECPAR(4) = CURPAR(4)
C  WRITE MUON UNCHANGED TO STACK
        CALL TSTACK
        CALL TSTEND
        RETURN
      ENDIF

C  SAMPLE THE ENERGY FRACTION SNI OF VIRTUAL GAMMA
C  LIMITS FOR VIRTUAL GAMMA''S ENERGY ARE  SNIMIN AND SNIMAX
      SNIMIN = ( PAMA(8) + 0.5D0*PAMA(8)**2/PAMA(14) )/EE
      SNIMAX = 1.D0 - ( PAMA(14) + PAMA(5)**2/PAMA(14) ) * 0.5D0/EE

C  USE FOR SAMPLING A FUNCTION  WHICH IS SOMEWHAT LARGER, BUT
C  CAN BE INTEGRATED AND THE INTEGRAL CAN BE INVERTED.
C  AFTERWARDS CORRECT SAMPLING IS DONE BY REJECTION TECHNIQUE
      IF ( EE .LE. 1.D6 ) THEN
        COEF  = 0.073D0 * LOG10(EE) - 1.565D0
        FACTO = 1.D10 / (10.D0**(8.8D0-0.1D0*(.2D0+LOG10(EE)**2/6.D0)))
     *                                                   * AATOM/22.D0
      ELSEIF ( EE .GT. 1.D6 ) THEN
        COEF  = 0.063D0 * LOG10(EE) - 1.55326D0
        FACTO = 1.D10 / (10.D0**(8.8D0-0.1D0*LOG10(EE)))
     *                                                   * AATOM/22.D0
      ENDIF
      COEF1  = COEF + 1.D0
      GMIN   = FACTO/COEF1 * SNIMIN**COEF1
      GMAX   = FACTO/COEF1 * SNIMAX**COEF1

      JCOUNT = 0
 1    CONTINUE
      JCOUNT = JCOUNT + 1
      IF ( JCOUNT .GT. 1000 ) THEN
        SECPAR(0) = CURPAR(0)
        SECPAR(1) = CURPAR(1)
        SECPAR(2) = CURPAR(2)
        SECPAR(3) = CURPAR(3)
        SECPAR(4) = CURPAR(4)
C  WRITE MUON UNCHANGED TO STACK
        CALL TSTACK
        CALL TSTEND
        RETURN
      ENDIF
      CALL RMMARD( RD,2,1 )
      ARGO   = GMIN + RD(1)*(GMAX-GMIN)
      SNI    = (COEF1*ARGO/FACTO)**(1.D0/COEF1)
      AUXIL1 = RD(2) * FACTO * SNI**COEF

      IF ( SNI .GE. 1.D0 ) THEN
        VPH = 0.D0
        GOTO 99
      ENDIF
C  CALCULATE BEZRUKOV''S T
      TTT  = PAMA(5)**2 * SNI**2 / (1.D0 - SNI)
C  SS IS ENERGY**2 IN CM SYSTEM, EE IS TOTAL ENERGY OF INCOMING MUON
      SS   = 2.D0 * PAMA(14) * SNI * EE
C  CROSS-SECTION OF VIRTUAL GAMMA WITH NUCLEON (IN MICROBARNS)
C  SEE: A. DONNACHIE + P.V. LANDSHOFF, PHYS.LETT. B296 (1992) 227
*     SIGN = 67.7D0 * SS**ELE1 + 129.D0 * SS**ELE2
C  SEE: PARTICLE DATA GROUP, EUROPHYS. J. C15 (2000) 231
      SIGN = 59.3D0 * SS**0.093D0 + 120.2D0 * SS**(-0.358D0)
C  SCALE THE CROSS-SECTION WITH ATOMIC NUMBER
      ZZZ  = SIGN * APH * AATOM**OB3
C  CALCULATE BOTTAI''S H(V)
      HHH  = 1.D0 - 2.D0/SNI + 2.D0/SNI**2
C  CALCULATE BEZRUKOV''S NUCLEAR SHADOWING G(X)
      GG   = ( 0.5D0 + ((1.D0+ZZZ)*EXP(-ZZZ)-1.D0)/ZZZ**2 ) * 9.D0/ZZZ
C  FACTOR BEFORE LARGE BRACKET
      BPH  = AATOM * SNI * SIGN * (ALPHFA/(8.D0*PI))
C  AUXILIARY QUANTITIES
      CPH  = 1.D0 + AM21/TTT
      DPH  = 1.D0 + AM22/TTT
      EPH  = 2.D0 * PAMA(5)**2 / TTT
      FPH  = AM21 / (AM21 + TTT)
C  FIRST PART WITHIN LARGE BRACKET
      VPH1 = HHH * LOG(DPH) - EPH + GG * (HHH*LOG(CPH) - HHH*FPH - EPH)
C  SECOND PART WITHIN LARGE BRACKET
      VPH2 = (2.D0 * CSI * PAMA(5)**2/TTT)
     *         * ( GG * FPH + (AM22/TTT) * LOG( 1.D0 + TTT/AM22 ) )
C  FINAL CROSS-SECTION
      VPH  = MAX( 0.D0, BPH * (VPH1+VPH2) )
 99   CONTINUE
C  USE REJECTION METHOD FOR SAMPLING OF SNI
      IF ( AUXIL1 .GE. VPH ) GOTO 1

C  SNI FINALLY IS ENERGY FRACTION OF VIRTUAL GAMMA
C  ENERGY OF RESIDUAL MUON
      E1         = EE * (1.D0 - SNI)
      SECPAR(0)  = CURPAR(0)
      SECPAR(1)  =  E1/PAMA(ITYPE)
      CALL RMMARD( RD,1,1 )
      PHI3       = RD(1) * PI
C  COSTH3 IS SET TO 1 (FORWARD MOVEMENT WITHOUT TRANSVERSE MOMENTUM)
      COSTH3     = 1.D0
      CALL ADDANG3( CURPAR(2),CURPAR(3),CURPAR(4), COSTH3,PHI3,
     *                               SECPAR(2),SECPAR(3),SECPAR(4) )
      SECPAR(10) = CURPAR(5)
      IF ( E1 - PAMA(5) .LE. ELCUT(2) ) THEN
        IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

          DLONG(LHEIGH,5) = DLONG(LHEIGH,5) + E1

        ENDIF
      ELSE

        IF ( SECPAR(2) .GT. C(29) ) THEN

C  WRITE RESIDUAL MUON TO STACK
          CALL TSTACK
          CALL TSTEND
        ELSE
          IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

            DLONG(LHEIGH,15) = DLONG(LHEIGH,15) + E1

          ENDIF
        ENDIF
      ENDIF

C  NOW TREAT THE VIRTUAL GAMMA AS REAL GAMMA
      ITYPE     = 1
      CURPAR(0) = 1.D0
      CURPAR(1) = SNI * EE
C  COSTH3 IS SET TO 1 (FORWARD MOVEMENT WITHOUT TRANSVERSE MOMENTUM)
      CALL ADDANG3( CURPAR(2),CURPAR(3),CURPAR(4), COSTH3,PHI3+PI,
     *                               CURPAR(2),CURPAR(3),CURPAR(4) )

      IF ( DEBUG ) WRITE(MDEBUG,445) (CURPAR(I),I=0,9)
  445 FORMAT(' MUNUCL: PIGEN =',1P,10E11.3)

C  CHECK: ENERGY OF VIRTUAL GAMMA IS SUFFICIENT FOR PION PRODUCTION ?
      IF ( CURPAR(1) .LE. MAX( ELCUT(4), PITHR*1.D-3 ) ) THEN
        IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

          DLONG(LHEIGH,1) = DLONG(LHEIGH,1) + CURPAR(1)

        ENDIF

      ELSE
        CURPAR(12) = SQRT( (PAMA(14) + CURPAR(1)*2.D0)*PAMA(14) )
        CURPAR(11) = (CURPAR(1) + PAMA(14))/CURPAR(12)

C  STORE VIRTUAL GAMMA INTO EGS STACK AND CALL SUBR. PIGEN
C  FILL IN STARTING COORDINATES
        NP = 1
        TIM(1) = CURPAR(6)
        X(1)   = CURPAR(7)
        Y(1)   =-CURPAR(8)
C  STARTS IN HEIGHT 'Z' DOWNWARDS
        Z(1)   =-CURPAR(5)
C  START DIRECTION COSINES
        U(1)   = CURPAR(3)
        V(1)   =-CURPAR(4)
        W(1)   = CURPAR(2)
        IF ( LLONGI ) LPCTE(1) = MIN( NSTEP,
     *                         INT( THICK( CURPAR(5) )*THSTPI + 1.D0 ) )

        ZAP(1) =-CURPAR(14)
        WAP(1) = CURPAR(15)
        WA(1)  = CURPAR(16)

        IGEN(1) = GEN
C  CONVERSION GEV --> MEV
        E(1)    = CURPAR(1) * 1000.D0
        IQ(1)   = NINT( CURPAR(0) )
C  TREAT THE PHOTONUCLEAR INTERACTION WITH EGS BY PIGEN
        CALL PIGEN( .FALSE. )
C  ALL SECONDARIES ARE WRITTEN TO STACK AND TSTEND WAS CALLED IN PIGEN
      ENDIF

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE       12/05/2003
C=======================================================================

      SUBROUTINE MUPINI

C-----------------------------------------------------------------------
C  MU(ON) P(ARAMETER) INI(TIALIZATION)
C
C  INTIALIZES MUON PARAMETERS FOR MULTIPLE SCATTERING.
C  ESTABLISHES TABLES FOR CROSS-SECTIONS OF BEMSSTRAHLUNG,
C  PAIR PRODUCTION AND NUCLEAR INTERACTION.
C  ESTABLISHES TABLES FOR MUON ENERGY LOSS FOR BEMSSTRAHLUNG,
C  PAIR PRODUCTION, AND NUCLEAR INTERACTION.
C  THIS SUBROUTINE IS CALLED FROM INPRM.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRAIR/   COMPOS,PROBTA,AVERAW,AVOGDR
      DOUBLE PRECISION COMPOS(3),PROBTA(3),AVERAW,AVOGDR

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRELABCT/ELCUT
      DOUBLE PRECISION ELCUT(4)

      COMMON /CRMUMULT/CHC,OMC,PHISCT,STEPL,VSCAT,FMOLI
      DOUBLE PRECISION CHC,OMC,PHISCT,STEPL,VSCAT
      LOGICAL          FMOLI

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      COMMON /CRPION/  PI0MSQ,PITHR,PICMAS,PI0MAS,AMASK0,AMASKC,AMASPR,
     *                 AMASNT
      DOUBLE PRECISION PI0MSQ,PITHR,PICMAS,PI0MAS,AMASK0,AMASKC,AMASPR,
     *                 AMASNT

      COMMON /CRPRIMSP/PSLOPE,LLIMIT,ULIMIT,LL,UL,SLEX,ISPEC
      DOUBLE PRECISION PSLOPE,LLIMIT,ULIMIT,LL,UL,SLEX
      INTEGER          ISPEC

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSIGMU/ BREMSTAB,NUCTAB,PAIRTAB,DEDXMU,DEDXM,
     *                 FRABTN,FRANTN,FRAPTN,FRBTNO,FRNTNO,FRPTNO,
     *                 SIGBRM,SIGNUC,SIGPRM

      DOUBLE PRECISION BREMSTAB(141,3),NUCTAB(141,3),PAIRTAB(141,3),
     *                 DEDXMU(141,3),DEDXM(141),FRABTN,FRANTN,FRAPTN,
     *                 FRBTNO,FRNTNO,FRPTNO,SIGBRM,SIGNUC,SIGPRM

       

       

       

       

      DOUBLE PRECISION AAIR(3),YE,ZAIR(3)
      DOUBLE PRECISION BREMS,DEDXBR,DEDXNI,DEDXPR,ELOSS,GAM0,NUCLE,PAIR
      INTEGER          J,JE,JJMAT
      SAVE
      DOUBLE PRECISION DEDXMUB(141,3),DEDXMNI(141,3),DEDXMUP(141,3),
     *                 DEDXMB(141),DEDXMN(141),DEDXMP(141)
      DOUBLE PRECISION CBRSGM,CNUSGM,CPRSGM,DBRELM,DBRSGM,
     *                 DNIELM,DNUSGM,DPRELM,DPRSGM
      EXTERNAL         CBRSGM,CNUSGM,CPRSGM,
     *                 DBRELM,DBRSGM,DNIELM,DNUSGM,DPRELM,DPRSGM
      DATA             AAIR/14.D0,16.D0, 40.D0/
      DATA             ZAIR/ 7.D0, 8.D0, 18.D0/
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,*) 'MUPINI: INITIALIZE MUON DATA'

C  SET BCUT BELOW THE PI THERSHOLD
      BCUT      = MIN( ELCUT(3), PITHR*1.D-3 )

      IF ( DEBUG ) WRITE(MDEBUG,*) 'MUPINI: BCUT =',BCUT,' GEV'
C  SET CONSTANTS FOR MUON BREMSSTRAHLUNG
      CMUON(7)  =  7.D0**OB3
      CMUON(8)  =  8.D0**OB3
      CMUON(9)  = 18.D0**OB3
      CMUON(1)  = LOG( 189.D0 * PAMA(5) / (CMUON(7)*PAMA(2)) )
      CMUON(2)  = LOG( 189.D0 * PAMA(5) / (CMUON(8)*PAMA(2)) )
      CMUON(3)  = LOG( 189.D0 * PAMA(5) / (CMUON(9)*PAMA(2)) )
     *                   + LOG( TB3/CMUON(9) )
      SE        = SQRT( EXP(1.D0) )
      CMUON(4)  = 189.D0 * SE*PAMA(5)**2/(2.D0*PAMA(2)*CMUON(7))
      CMUON(5)  = 189.D0 * SE*PAMA(5)**2/(2.D0*PAMA(2)*CMUON(8))
      CMUON(6)  = 189.D0 * SE*PAMA(5)**2/(2.D0*PAMA(2)*CMUON(9))
      CMUON(10) = 0.75D0 * PAMA(5) * SE
      CMUON(7)  = CMUON(7) * CMUON(10)
      CMUON(8)  = CMUON(8) * CMUON(10)
      CMUON(9)  = CMUON(9) * CMUON(10)
      CMUON(11) = LOG( BCUT/PAMA(5) )
C  MASS RATIO ELETRON BY MUON
      EBYMU     = PAMA(2)/PAMA(5)
C  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

C  CALCULATE CROSS SECTION TABLES
C  MAXIMUM PRIMARY ENERGY DETERMINES MAXIMUM OF TABLE VALUES NEEDED
      JE = 10 * LOG10(ULIMIT) + 22
      JE = MIN( JE, 141 )

C  MATERIAL LOOP (JJMAT=1: 14N; JJMAT=2: 16O; JJMAT=3: 40AR)
      DO  JJMAT = 1, 3
        ZATOM     = ZAIR(JJMAT)
        AATOM     = AAIR(JJMAT)
        CONSTKINE = CMUON(JJMAT+6)

        IF ( DEBUG ) WRITE(MDEBUG,101) JJMAT
 101    FORMAT(' MUPINI: MUON CROSS SECTIONS (MBARN) FOR MATERIAL ',
     *         'INDEX = ',I3,/,' BIN',1X,
     *         'ENERGY (GEV)',3X,'SIGBREMS',6X,'SIGPAIR',7X,'SIGNUCL')

C  ENERGY LOOP (10 MEV AT J=1; 1 GEV AT J=21; 1000 EEV AT J=141)
        DO  J = 1, JE
          YE = DBLE(J - 21)/10.D0
C  CALCULATE TOTAL ENERGY EE (IN GEV)
          EE = 10.D0**YE
C  TOTAL ENERGY (EE), ATOMIC NUMBER (ZATOM), NUCLEON NUMBER (AATOM)
C  ARE TRANSMITTED TO THE FUNCTIONS VIA COMMON MUPART
C  CALCULATE CROSS SECTIONS (MILLIBARN)
          BREMSTAB(J,JJMAT) = DBRSGM(JJMAT)
          NUCTAB(J,JJMAT)   = DNUSGM(JJMAT)
          PAIRTAB(J,JJMAT)  = DPRSGM(JJMAT)
          IF ( DEBUG ) WRITE(MDEBUG,102) J,EE,BREMSTAB(J,JJMAT),
     *       PAIRTAB(J,JJMAT),NUCTAB(J,JJMAT)
 102      FORMAT(' ',I3,1P,1X,E12.5,3(1X,E13.6))
          BREMSTAB(J,JJMAT) = LOG(MAX( BREMSTAB(J,JJMAT), 1.D-30 ) )
          NUCTAB(J,JJMAT)   = LOG(MAX( NUCTAB(J,JJMAT), 1.D-30 ) )
          PAIRTAB(J,JJMAT)  = LOG(MAX( PAIRTAB(J,JJMAT), 1.D-30 ) )
        ENDDO
      ENDDO

      IF ( DEBUG ) THEN
        WRITE(MDEBUG,103)
 103    FORMAT(' MUPINI: MUON CROSS SECTIONS (MBARN) FOR AIR'/' BIN',1X,
     *         'ENERGY (GEV)',3X,'SIGBREMS',6X,'SIGPAIR',7X,'SIGNUCL')
        DO  J = 1, JE
          YE = DBLE(J - 21)/10.D0
C  CALCULATE TOTAL ENERGY EE (IN GEV)
          EE = 10.D0**YE
C  CALCULATE THE CROSS SECTIONS FOR AIR
          BREMS =         COMPOS(1) * CBRSGM( EE,1 )
          BREMS = BREMS + COMPOS(2) * CBRSGM( EE,2 )
          BREMS = BREMS + COMPOS(3) * CBRSGM( EE,3 )
          PAIR  =         COMPOS(1) * CPRSGM( EE,1 )
          PAIR  = PAIR  + COMPOS(2) * CPRSGM( EE,2 )
          PAIR  = PAIR  + COMPOS(3) * CPRSGM( EE,3 )
          NUCLE =         COMPOS(1) * CNUSGM( EE,1 )
          NUCLE = NUCLE + COMPOS(2) * CNUSGM( EE,2 )
          NUCLE = NUCLE + COMPOS(3) * CNUSGM( EE,3 )
          WRITE(MDEBUG,104) J,EE,BREMS,PAIR,NUCLE
 104      FORMAT(' ',I3,1P,1X,E12.5,5(1X,E13.6))
        ENDDO
      ENDIF
C  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

C  CALCULATE ENERGY LOSS TABLES. AS WE REGARD CUT VALUES ONLY BELOW 21 MEV
C  WE MAY NEGLECT NUCLEAR INTERACTIONS FOR THE ENERGY LOSS TABLES.
C  TOTAL ENERGY (EE), ATOMIC NUMBER (ZATOM), NUCLEON NUMBER (AATOM)
C  ARE TRANSMITTED TO THE FUNCTIONS VIA COMMON MUPART
C  MATERIAL LOOP (JJMAT=1:14N; JJMAT=2: 16O; JJMAT=3: 40AR)
      DO  JJMAT = 1, 3
        ZATOM     = ZAIR(JJMAT)
        AATOM     = AAIR(JJMAT)
        CONSTKINE = CMUON(JJMAT+6)
C  ENERGY LOOP (10 MEV AT J=1; 1 GEV AT J=21; 1000 EEV AT J=141)
        IF ( DEBUG ) WRITE(MDEBUG,105) JJMAT
 105    FORMAT(' MUPINI: MUON ENERGY LOSS (GEV G**-1 CM**2) FOR ',
     *         'MATERIAL INDEX = ',I3/' BIN',1X,
     *         'ENERGY (GEV)',3X,'DEDXBREM',6X,'DEDXPAIR',6X,
     *         'NUCLEAR',8X,'SUM')
        DO  J = 1, JE
          YE = DBLE(J - 21)/10.D0
C  CALCULATE TOTAL ENERGY EE (IN GEV)
          EE = 10.D0**YE
C  TOTAL ENERGY (EE), ATOMIC NUMBER (ZATOM), NUCLEON NUMBER (AATOM)
C  ARE TRANSMITTED TO THE FUNCTIONS VIA COMMON MUPART
C  ENERGY LOSS IN MATERIAL COMPONENTS
          DEDXBR           = DBRELM(JJMAT)
          DEDXPR           = DPRELM(JJMAT)
          DEDXNI           = DNIELM(JJMAT)
          DEDXMU(J,JJMAT)  = DEDXBR + DEDXPR + DEDXNI
          DEDXMUB(J,JJMAT) = DEDXBR
          DEDXMUP(J,JJMAT) = DEDXPR
          DEDXMNI(J,JJMAT) = DEDXNI
          IF ( DEBUG ) WRITE(MDEBUG,106)
     *               J,EE,DEDXBR,DEDXPR,DEDXNI,DEDXMU(J,JJMAT)
 106      FORMAT(' ',I3,1P,1X,E12.5,4(1X,E13.6))
        ENDDO
      ENDDO

C  CALCULATE ENERGY LOSS IN AIR
      IF ( DEBUG ) WRITE(MDEBUG,107)
 107    FORMAT(' MUPINI: MUON ENERGY LOSS (GEV G**-1 CM**2) FOR AIR'/
     *    ' BIN',1X,'ENERGY (GEV)',5X,'ELOSS',8X,'DEDXMB',8X,
     *    'DEDXMP',8X,'DEDXMN',8X,' SUM')
      DO  J = 1, JE
        YE = DBLE(J - 21)/10.D0
C  CALCULATE TOTAL ENERGY EE (IN GEV)
C  CALCULATE ENERGY LOSS IN AIR
        EE = 10.D0**YE
        DEDXM(J) = COMPOS(1) * DEDXMU(J,1)
     *            +COMPOS(2) * DEDXMU(J,2)
     *            +COMPOS(3) * DEDXMU(J,3)
        DEDXMB(J) = COMPOS(1) * DEDXMUB(J,1)
     *             +COMPOS(2) * DEDXMUB(J,2)
     *             +COMPOS(3) * DEDXMUB(J,3)
        DEDXMP(J) = COMPOS(1) * DEDXMUP(J,1)
     *             +COMPOS(2) * DEDXMUP(J,2)
     *             +COMPOS(3) * DEDXMUP(J,3)
        DEDXMN(J) = COMPOS(1) * DEDXMNI(J,1)
     *             +COMPOS(2) * DEDXMNI(J,2)
     *             +COMPOS(3) * DEDXMNI(J,3)
        GAM0     = MAX( 1.0001D0, EE / PAMA(5) )
        ELOSS    = C(22) * ( GAM0**2 * (LOG(GAM0**2-1.D0)
     *                  - 0.5D0 * LOG(GAM0 * C(16) + C(15))
     *                      + C(23)) /(GAM0**2-1.D0) - 1.D0 )
        IF ( DEBUG ) WRITE(MDEBUG,108)
     *      J,EE,ELOSS,DEDXMB(J),DEDXMP(J),DEDXMN(J),ELOSS+DEDXM(J)
 108    FORMAT(' ',I3,1P,1X,E12.5,5(1X,E13.6))
      ENDDO

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE       04/10/1996
C=======================================================================

      SUBROUTINE MUPRPR

C-----------------------------------------------------------------------
C  MU(ON) P(AI)R PR(ODUCTION)
C
C  TREATES MUON PAIR PRODUCTION (WITHOUT POLARISATION EFFECTS)
C  IN ANALOGY WITH SUBR. GPAIRM OF BOTTAI & PERRONE.
C  SEE: S. BOTTAI AND L. PERRONE, NUCL. INST. METH. A459 (2001) 319
C  THIS SUBROUTINE IS CALLED FROM MUTRAC.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRAIR/   COMPOS,PROBTA,AVERAW,AVOGDR
      DOUBLE PRECISION COMPOS(3),PROBTA(3),AVERAW,AVOGDR

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRELABCT/ELCUT
      DOUBLE PRECISION ELCUT(4)

      COMMON /CRGENER/ GEN,ALEVEL
      DOUBLE PRECISION GEN,ALEVEL

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRPOLAR/ POLART,POLARF
      DOUBLE PRECISION POLART,POLARF

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRREST/  CONTNE,TAR,LT
      DOUBLE PRECISION CONTNE(3),TAR
      INTEGER          LT

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSIGMU/ BREMSTAB,NUCTAB,PAIRTAB,DEDXMU,DEDXM,
     *                 FRABTN,FRANTN,FRAPTN,FRBTNO,FRNTNO,FRPTNO,
     *                 SIGBRM,SIGNUC,SIGPRM

      DOUBLE PRECISION BREMSTAB(141,3),NUCTAB(141,3),PAIRTAB(141,3),
     *                 DEDXMU(141,3),DEDXM(141),FRABTN,FRANTN,FRAPTN,
     *                 FRBTNO,FRNTNO,FRPTNO,SIGBRM,SIGNUC,SIGPRM

       

       

       

       

      DOUBLE PRECISION COSTH3,EKIN,ENEG,EPOS,EPP,GX,
     *                 PHI3,RAT12,RO,ROMAX,ROMIN,SIGNEW,SIGOLD,
     *                 SINT1,SINT2,SK,SK1,SK2,SMAX,SMX1,SMX2,SNINT,
     *                 TRUR,TRUV,VC
      INTEGER          I,JCOUNT,NPNTS
      SAVE
      DOUBLE PRECISION CPRSGM,DKOKOI,PPCS,THICK
      EXTERNAL         CPRSGM,DKOKOI,PPCS,THICK
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) (CURPAR(I),I=0,9)
  444 FORMAT(' MUPRPR: CURPAR=',1P,10E11.3)

C  COPY VERTEX COORDINATES TO SECPAR
      DO  I = 5, 8
        SECPAR(I) = CURPAR(I)
      ENDDO
      SECPAR( 9) = GEN

      SECPAR(14) = CURPAR(14)
      SECPAR(15) = CURPAR(15)
      SECPAR(16) = CURPAR(16)

      IF ( LLONGI ) LHEIGH = INT( THICK( H )*THSTPI + 1.D0 )

C  SET MATERIAL CONSTANTS CMUON(.) ACCORDING TO TARGET INDEX LT
C  (1=N, 2=O, 3=AR)  WHICH WAS SET IN BOX2; RESTORE OLD CROSS-SECTION
      IF     ( LT .EQ. 1 ) THEN
        ZATOM  = 7.D0
        SIGOLD =   FRAPTN / COMPOS(1)
      ELSEIF ( LT .EQ. 2 ) THEN
        ZATOM  = 8.D0
        SIGOLD = (FRPTNO - FRAPTN) / COMPOS(2)
      ELSEIF ( LT .EQ. 3 ) THEN
        ZATOM  = 18.D0
        SIGOLD = (SIGPRM - FRPTNO) / COMPOS(3)
      ELSE
        WRITE(MONIOU,*) 'MUPRPR: WRONG TARGET LT =',LT,' STOP'
        STOP
      ENDIF

C  TOTAL AND KINETIC ENERGY OF MUON
      EE     = PAMA(5) * GAMMA
      EKIN   = EE - PAMA(5)
      IF ( EKIN .LE. BCUT ) GOTO 900
C  CHECK THE REDUCED CROSS-SECTIONS AND SKIP INTERACTION EVENTUALLY
C  GET NEW CROSS-SECTION
      SIGNEW = CPRSGM( EE,LT )
      CALL RMMARD( RD,1,1 )
      IF ( RD(1)*SIGOLD .GT. SIGNEW ) THEN
C  SKIP INTERACTION IF RANDOM NUMBER SMALLER THAN CROSS-SECTION RATIO
        GOTO 900
      ENDIF
C
      VMIN  = 4.D0 * PAMA(2) / EE
      VC    = BCUT / EE
      VMIN  = MAX( VMIN, VC )
      VMAX  = 1.D0 - CMUON(10) * ZATOM**OB3 / EE
      IF ( VMAX .LE. VMIN ) GOTO 900

      ROMIN  = 0.D0
      NPNTS  = 64
C  CALCULATE AUXILIARY VARIABLES
      SK  = (ZATOM * (ZATOM + 1.D0)) / ( 26.D0 * 27.D0 )
      SK1 = SK * 0.4D-24
      SK2 = SK * 0.5D-29
      SNINT = 0.003535533905932738D0
      SINT1 = SK1 * LOG(SNINT/VMIN)
      SINT2 = -0.5D0 * SK2 * ( 1.D0/VMAX**2 - 1.D0/SNINT**2 )
      RAT12 = SINT1 / (SINT1+SINT2)

C  SAMPLE THE ENERGY FRACTION VFRAC TRANSFERRED TO THE PAIR
      JCOUNT = 0
 321  CONTINUE
      JCOUNT = JCOUNT + 1
      IF ( JCOUNT .GT. 1000 ) THEN
        GOTO 900
      ENDIF
      CALL RMMARD( RD,3,1 )
      IF ( RD(1) .LE. RAT12 ) THEN
        VFRAC = EXP(  LOG( VMIN) + RD(2) * SINT1/SK1 )
      ELSE
        VFRAC = SQRT( 1.D0 / ( 1.D0/SNINT**2 - 2.D0*RD(2)*SINT2/SK2 ) )
      ENDIF
      IF ( VFRAC .LT. SNINT ) THEN
        GX = SK1/VFRAC
      ELSE
        GX = SK2/(VFRAC**3)
      ENDIF
C  NORMALIZATION TO MBARN IS MADE IN DKOKOI
      TRUV  = DKOKOI()
      IF ( RD(3)*GX .GT. TRUV ) GOTO 321

      IF ( VFRAC .GE. VMAX ) VFRAC = VMAX
      IF ( VFRAC .LE. VMIN ) VFRAC = VMIN

C  WE HAVE VFRAC, NOW SAMPLE THE ENERGY ASYMMETRY RO OF THE PAIR
      ROMAX = ( 1.D0 - 6.D0*PAMA(5)**2/( (1.D0-VFRAC)*EE**2 ) )
     *              * SQRT( 1.D0 - VMIN / VFRAC )
      ROMIN = -ROMAX
 456  CONTINUE
      CALL RMMARD( RD,2,1 )
      RO    = ROMAX * ( 2.D0*RD(1) - 1.D0 )
C  HERE WE NEED NO NORMALIZATION OF PPCS
      SMX1  = PPCS( 0.D0 )
      SMX2  = PPCS( ROMIN )
      TRUR  = PPCS( RO )
      SMAX  = 2.D0 * MAX( SMX1, SMX2 )
      IF ( SMAX*RD(2) .GT. TRUR ) GOTO 456

C  CALCULATE THE ENERGIES
      EPP   = VFRAC * EE
      EPOS  = 0.5D0 * EPP * (1.D0 + RO)
      ENEG  = EPP - EPOS
C  CALCULATE THE ANGLES
      COSTH3 = COS( PAMA(5)/EE )
      CALL RMMARD( RD,1,1 )
      PHI3   = PI2 * RD(1)

C  TREAT THE POSITRON
      IF ( EPOS .GT. BCUT+PAMA(2) ) THEN
        CALL ADDANG3( COSTHE,PHIX,PHIY, COSTH3,PHI3,
     *                           SECPAR(2),SECPAR(3),SECPAR(4) )

        IF ( SECPAR(2) .GT. C(29) ) THEN

          SECPAR( 0) = 2.D0
          SECPAR( 1) = EPOS/PAMA(2)
          SECPAR(10) = H
          CALL TSTACK
        ELSE
          IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

            DLONG(LHEIGH,13) = DLONG(LHEIGH,13) + EPOS + PAMA(2)

          ENDIF
        ENDIF
      ELSE
        IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

          DLONG(LHEIGH,3) = DLONG(LHEIGH,3) + EPOS + PAMA(2)

        ENDIF
      ENDIF

C  TREAT THE ELECTRON
      IF ( ENEG .GT. BCUT+PAMA(2) ) THEN
C  THE PHI DIRECTION IS OPPOSITE TO POSITRON
        CALL ADDANG3( COSTHE,PHIX,PHIY, COSTH3,PHI3+PI,
     *                           SECPAR(2),SECPAR(3),SECPAR(4) )

        IF ( SECPAR(2) .GT. C(29) ) THEN

          SECPAR( 0) = 3.D0
          SECPAR( 1) = ENEG/PAMA(2)
          SECPAR(10) = H
          CALL TSTACK
        ELSE
          IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

            DLONG(LHEIGH,13) = DLONG(LHEIGH,13) + ENEG - PAMA(3)

          ENDIF
        ENDIF
      ELSE
        IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

          DLONG(LHEIGH,3) = DLONG(LHEIGH,3) + ENEG - PAMA(3)

        ENDIF
      ENDIF

C  REDUCE ENERGY OF MUON
      GAMMA = (EE - EPP)/ PAMA(5)
C  THE CHANGEMENT OF THE MUON ANGLE IS NEGLECTED
 900  CONTINUE
C  WRITE MUON TO STACK
      SECPAR( 0) = CURPAR(0)
      SECPAR( 1) = GAMMA
      SECPAR( 2) = CURPAR(2)
      SECPAR( 3) = CURPAR(3)
      SECPAR( 4) = CURPAR(4)
      SECPAR(10) = ALEVEL
      CALL TSTACK

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE       25/09/1996
C=======================================================================

c-----changed
      SUBROUTINE MUTRAC(fmfb)
c-----changed

C-----------------------------------------------------------------------
C  MU(ON) TRAC(KING)
C
C  TRACKS THE MUON REGARDING MAX. STEP LENGTH FOR MULTIPLE SCATTERING
C  CHECKS PASSAGE THROUGH OBSERVATION LEVELS.
C  IRET1=1 KILLS PARTICLE
C  IRET2=1 PARTICLE HAS BEEN CUTTED IN UPDATE
C  THIS SUBROUTINE IS CALLED FROM BOX3.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRGENER/ GEN,ALEVEL
      DOUBLE PRECISION GEN,ALEVEL

      COMMON /CRIRET/  IRET1,IRET2,IRETE
      INTEGER          IRET1,IRET2
      LOGICAL          IRETE

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRMAGNET/BX,BZ,BVAL,BNORMC,BNORM,COSB,SINB,BLIMIT
      DOUBLE PRECISION BX,BZ,BVAL,BNORMC,BNORM,COSB,SINB,BLIMIT

      COMMON /CRMUMULT/CHC,OMC,PHISCT,STEPL,VSCAT,FMOLI
      DOUBLE PRECISION CHC,OMC,PHISCT,STEPL,VSCAT
      LOGICAL          FMOLI

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRNPARTI/NPARTO,NPART2
      DOUBLE PRECISION NPARTO(20,25), NPART2(20,25),
     *                 NPHOTO(20),NPOSIT(20),NELECT(20),
     *                 NNU(20),NMUP(20),NMUM(20),NPI0(20),NPIP(20),
     *                 NPIM(20),NK0L(20),NKPL(20),NKMI(20),NNEUTR(20),
     *                 NPROTO(20),NPROTB(20),NK0S(20),NHYP(20),
     *                 NNEUTB(20),NDEUT(20),NTRIT(20),NHELI3(20),
     *                 NALPHA(20),NOTHER(20),NMUOND
      EQUIVALENCE (NPARTO(1, 1),NPHOTO(1)), (NPARTO(1, 2),NPOSIT(1)),
     *            (NPARTO(1, 3),NELECT(1)), (NPARTO(1, 4),NNU(1))   ,
     *            (NPARTO(1, 5),NMUP(1))  , (NPARTO(1, 6),NMUM(1))  ,
     *            (NPARTO(1, 7),NPI0(1))  , (NPARTO(1, 8),NPIP(1))  ,
     *            (NPARTO(1, 9),NPIM(1))  , (NPARTO(1,10),NK0L(1))  ,
     *            (NPARTO(1,11),NKPL(1))  , (NPARTO(1,12),NKMI(1))  ,
     *            (NPARTO(1,13),NNEUTR(1)), (NPARTO(1,14),NPROTO(1)),
     *            (NPARTO(1,15),NPROTB(1)), (NPARTO(1,16),NK0S(1))  ,
     *            (NPARTO(1,18),NHYP(1))  , (NPARTO(1,19),NDEUT(1)) ,
     *            (NPARTO(1,20),NTRIT(1)) , (NPARTO(1,21),NHELI3(1)),
     *            (NPARTO(1,22),NALPHA(1)), (NPARTO(1,23),NOTHER(1)),
     *            (NPARTO(1,24),NMUOND)   , (NPARTO(1,25),NNEUTB(1))

      COMMON /CROBSPAR/OBSLEV,THCKOB,XOFF,YOFF,HEIGHP,THETAP,PHIP,
     *                 THETPR,PHIPR,

     *                 VUECON,

     *                 NOBSLV
      DOUBLE PRECISION OBSLEV(20),THCKOB(20),XOFF(20),YOFF(20),
     *                 HEIGHP,THETAP,THETPR(2),PHIP,PHIPR(2)

      DOUBLE PRECISION VUECON(2)

      INTEGER          NOBSLV

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION AUX,CHITOT,STPTOT
      INTEGER          I,IRET3
      LOGICAL          FSCAT
c-----changed--add
      logical fmfb
c-----changed--add
      SAVE

      LOGICAL          FLAG
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) (CURPAR(I),I=0,9)
  444 FORMAT(' MUTRAC: CURPAR=',1P,10E11.3)

C  THE PLACE OF NEXT INTERACTION WAS DETERMINED IN BOX2
C  KEEP TOTAL STEP LENGTH UNTIL DECAY OR INTERACTION OCCURS
      CHITOT = CHI
      IF ( FDECAY ) THEN

        STPTOT = STEPL
      ENDIF

 10   CONTINUE

C  CALCULATE MAX STEP SIZE (10 RAD. LENGTH) FOR MULTIPLE SCATTERING
C  THE MAXIMUM STEP SIZE DEPENDS ON THE ENERGY TO GET ARRIVAL TIMES
C  WITH UNCERTAINTIES SMALLER THAN  1 NSEC
      AUX = MIN( 10.D0, 0.015D0*GAMMA )

      CHI = MIN( AUX*C(21), CHITOT )

      IF ( CHI .GE. CHITOT ) THEN
        FSCAT = .FALSE.
        IF ( DEBUG ) WRITE(MDEBUG,*) 'MUTRAC: CHI=',SNGL(CHI)
      ELSE
        FSCAT = .TRUE.
        IF ( DEBUG ) WRITE(MDEBUG,*) 'MUTRAC: C(XX)=',SNGL(AUX*C(21))
      ENDIF

C  UPDATE PARTICLE TO INTERACTION POINT OR OBSERVATION LEVEL,
C  WHICHEVER IS CLOSER
      FLAG = .TRUE.
c-----changed--add
      CALL UPDATC(IRET3,FLAG,fmfb)
c-----changed--add

C  IRET3 = 1 MEANS PARTCLE HAS PASSED OBSERVATION LEVEL
      IF ( DEBUG ) WRITE(MDEBUG,*) 'MUTRAC: IRET1,2,3=',
     *                                      IRET1,IRET2,IRET3
      IF ( IRET2 .NE. 0 ) THEN
C  IRET2 = 1 MEANS PARTICLE IS CUTTED IN UPDATC/UPDATE
C  MUON CUTTED BEFORE INTERACTION POINT
C  LONGITUDINAL DEPOSIT IS ALREADY DONE IN UPDATC
        IRET1 = 1
        FMUORG = .FALSE.
        RETURN
      ELSE
        IF ( IRET3 .EQ. 0 ) THEN
C  STORE MUON FOR FURTHER TREATMENT
          DO  I = 0, 8
            CURPAR(I) = OUTPAR(I)
          ENDDO
          BETA = SQRT( (GAMMA-1.D0)*(GAMMA+1.D0) ) / GAMMA
        ELSE
C  KILL PARTICLE AS IT IS AT DETECTOR LEVEL
          IRET1 = 1
          FMUORG = .FALSE.
          RETURN
        ENDIF
      ENDIF

      IF ( FDECAY ) THEN
C  MUON DECAYS AT END OF PATH (MUDECY WRITES EM-PARTICLE TO STACK)
        IF ( FSCAT ) THEN
C  CHITOT IS THE MATERIAL STILL TO BE TRACKED
C  STPTOT IS THE PATHLENGTH STILL TO BE TRACKED
          STPTOT = STPTOT - STEPL
          CHITOT = CHITOT - CHI
          IF ( CHITOT .GT. 0.D0  .AND.  STPTOT .GT. 0.D0 ) GOTO 11
        ENDIF
        ALEVEL = H
        CALL MUDECY
        CALL TSTEND

        NMUOND  = NMUOND + 1.D0

        FMUORG = .FALSE.

      ELSE
C  MUON UNDERGOES NUCL. INTERACT OR BREMSSTR/PAIRPR AT END OF PATH
C  MUNUCL WRITES SECONDARY PARTICLES AND MUON TO STACK
C  MUBREM/MUPRPR WRITE EM-PARTICLES AND MUON TO STACK
        IF ( FSCAT ) THEN
C  MUON HAS MADE MULTIPLE SCATTERING
C  CHITOT IS THE MATERIAL STILL TO BE TRACKED
          CHITOT = CHITOT - CHI
          IF ( CHITOT .GT. 0.D0 ) GOTO 11
        ENDIF
        IF ( FMUNUC ) THEN
          CALL MUNUCL
C  TSTEND IS CALLED IN MUNUCL
        ELSE
          IF ( FMUBRM ) THEN
            CALL MUBREM
          ELSE
            CALL MUPRPR
          ENDIF
          CALL TSTEND
        ENDIF
      ENDIF
      IRET1 = 1
      RETURN

 11   CONTINUE

      IF ( DEBUG ) WRITE(MDEBUG,457) (CURPAR(I),I=0,9)
 457  FORMAT(' MUTRAC: SCATTER',1P,10E11.3)

      GOTO 10

      END

*-- Author :    F. SCHROEDER UNI WUPPERTAL      17/09/1998
C=======================================================================

      SUBROUTINE NRANGC( ARG )

C-----------------------------------------------------------------------
C  N(EUTRAL PARTICLE) RANGE C(URVED ATMOSPHERE)
C
C  DETERMINES PENETRATED MATTER CHI FOR NEUTRAL PARTICLES
C  TAKING INTO ACCOUNT A CURVED ATMOSPHERE.
C  THIS SUBROUTINE IS CALLED FROM AAMAIN AND BOX2.
C  ARGUMENT:
C   ARG    = GEOMETRIC LENGTH OF PARTICLE TRACK
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRATMOS2/HLAY,HLAY0,THICKL,LAYNO,LAYNEW
      DOUBLE PRECISION HLAY(6),HLAY0(5,0:9),THICKL(5)
      INTEGER          LAYNO(0:22)
      LOGICAL          LAYNEW

C  EXTERNAL ATMOSPHERIC MODELS
      COMMON /CRATMOSX/IATMOX,FREFRX
      INTEGER          IATMOX
      LOGICAL          FREFRX

      COMMON /CROBSPAR/OBSLEV,THCKOB,XOFF,YOFF,HEIGHP,THETAP,PHIP,
     *                 THETPR,PHIPR,

     *                 VUECON,

     *                 NOBSLV
      DOUBLE PRECISION OBSLEV(20),THCKOB(20),XOFF(20),YOFF(20),
     *                 HEIGHP,THETAP,THETPR(2),PHIP,PHIPR(2)

      DOUBLE PRECISION VUECON(2)

      INTEGER          NOBSLV

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION ARG,ARGNEW,COSDIF,COSPHI,COSTAPNEW,COSTHENEW,
     *                 DH,HOLD,HNEW,RADIUS,SINPHI,
     *                 SINTHE,SINTHENEW,THICK,TRANS,TRANSNEW,XNEW,YNEW
      SAVE
      EXTERNAL         THICK

C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) ARG,THICKH
  444 FORMAT(' NRANGC: ARG=',1P,E10.3,' THICKH=',E10.3)

C  START VALUES
      CHI  = 0.D0
      HNEW = H
      XNEW = X
      YNEW = Y
      SINTHE = SQRT( (1.D0-COSTHE) * (1.D0+COSTHE) )
      IF ( SINTHE .NE. 0.D0 ) THEN
        COSPHI = PHIX / SINTHE
        SINPHI = PHIY / SINTHE
      ELSE
        COSPHI = 0.D0
        SINPHI = 0.D0
      ENDIF
      COSTHENEW = COSTHE
      COSTAPNEW = COSTAP

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  LOOP OVER PIECES OF ARG (EACH IN ITS LOCAL FLAT COORDINATE FRAME)
  2   CONTINUE
      SINTHENEW = SQRT( (1.D0-COSTHENEW)*(1.D0+COSTHENEW) )
      TRANS     = ARG * SINTHENEW
C  MAXIMAL HORIZONTAL STEP (DEPENDS ON THICKNESS AT PARTICLE ALTITUDE)
CDH 17.06.2002
      TRANSNEW = MIN( TRANS, MAX( (C(4) * THICKH + C(3)), C(2) ) )
C
      IF ( DEBUG ) WRITE(MDEBUG,*) 'NRANGC: TRANSNEW=',SNGL(TRANSNEW)

      IF ( SINTHENEW .LE. 0.D0 ) THEN
C  PARTICLE TRACK IS VERTICAL
        ARGNEW = ARG
      ELSE
        ARGNEW = TRANSNEW / SINTHENEW
      ENDIF
      DH  = ARGNEW * COSTHENEW

      IF ( IATMOX .GT. 0 ) THEN
        IF ( HNEW-DH .LE. HLAY(1) ) THEN
          CHI = CHI + (THICKL(1) - THICK( HNEW )) / COSTHENEW

          IF ( DEBUG ) WRITE(MDEBUG,*)
     *               'NRANGC: HNEW,CHI= ',SNGL(HLAY(1)),SNGL(CHI)
          RETURN
        ENDIF
      ENDIF
      CHI = CHI + (THICK( HNEW-DH ) - THICK( HNEW )) / COSTHENEW

C  ACTUAL VALUES
      ARG = ARG - ARGNEW
      IF (DEBUG) WRITE(MDEBUG,*) 'NRANGC: ARG,CHI=',SNGL(ARG),SNGL(CHI)

C  LOOP UNTIL COMPLETE PARTICLE TRACK LENGTHS IS TRANSFORMED INTO CHI
      IF ( ARG .GT. 0.D0 ) THEN
C  NEW COORDINATE FRAME
        HOLD = HNEW
C  NEW HEIGHT IN OLD COORDINATE FRAME
        HNEW = HNEW - DH
C  NEW ACTUAL HEIGHT AT NEW THICKNESS GRADIENT
C  (CALCULATED WITH PARAMETERS OF OLD COORDINATE FRAME)
        HNEW = SQRT( TRANSNEW**2 + (C(1)+HNEW)**2 ) - C(1)
C  TERMINATE PROCESS IF PARTICLE WELL BELOW OBSERVATION LEVEL
        IF ( HNEW .LT. OBSLEV(1) - 1.D6 ) THEN
          IF ( DEBUG ) WRITE(MDEBUG,*) 'NRANGC: HNEW,CHI,ARG=',
     *                         SNGL(HNEW),SNGL(CHI),SNGL(ARG)
          RETURN
        ENDIF
        COSDIF   = ( (C(1)+HNEW)**2 + (C(1)+HOLD)**2 - ARGNEW**2 ) /
     *                             ( 2.D0 * (C(1)+HNEW) * (C(1)+HOLD) )
        IF (DEBUG) WRITE(MDEBUG,*) 'NRANGC: HNEW,COSDIF=',
     *                           SNGL(HNEW),SNGL(COSDIF)
        COSDIF = MIN( 1.D0, COSDIF )
C  DIRECTION OF PARTICLE RELATIVE TO DETECTOR CENTER
        IF ( COSDIF .LT. 1.D0 ) THEN
          RADIUS = ARGNEW * SQRT( (1.D0-COSTAPNEW)*(1.D0+COSTAPNEW)
     *                           /((1.D0-COSDIF)*(1.D0+COSDIF)) )
     *                    * C(1) * ACOS( COSDIF )/(C(1)+HNEW)
        ELSE
          RADIUS = ARGNEW * SQRT( (1.D0-COSTAPNEW)*(1.D0+COSTAPNEW) )
        ENDIF
        XNEW   = XNEW + RADIUS * COSPHI
        YNEW   = YNEW + RADIUS * SINPHI
C  COSINE OF NEW LOCAL ZENITH ANGLE
        COSTHENEW = MIN( 1.D0, ( COSTHENEW * COSDIF
     *                    - SQRT( (1.D0-COSDIF)*(1.D0+COSDIF)
     *                         *(1.D0-COSTHENEW)*(1.D0+COSTHENEW) ) ) )
        IF ( DEBUG ) WRITE(MDEBUG,*) 'NRANGC: COSTHENEW=',COSTHENEW
C  TERMINATE PROCESS IF PARTICLE MOVES OUT OF ANGULAR RANGE (UPWARD?)
        IF ( COSTHENEW .LE. C(29) ) RETURN
        GOTO 2
      ENDIF

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE NUCINT

C-----------------------------------------------------------------------
C  NUC(LEAR) INT(ERACTION)
C
C  SELECTS TYPE OF INTERACTION PROCESS ACCORDING TO ECM
C  HEAVY PRIMARIES AND STRANGE BARYONS INCLUDED.
C  THIS SUBROUTINE IS CALLED FROM AAMAIN.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRAIR/   COMPOS,PROBTA,AVERAW,AVOGDR
      DOUBLE PRECISION COMPOS(3),PROBTA(3),AVERAW,AVOGDR

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRGENER/ GEN,ALEVEL
      DOUBLE PRECISION GEN,ALEVEL

      COMMON /CRIRET/  IRET1,IRET2,IRETE
      INTEGER          IRET1,IRET2
      LOGICAL          IRETE

      COMMON /CRKAONS/ CKA
      DOUBLE PRECISION CKA(80)

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRMULT/  EKINL,MSMM,MULTMA,MULTOT
      DOUBLE PRECISION EKINL
      INTEGER          MSMM,MULTMA(40,13),MULTOT(40,13)

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRPOLAR/ POLART,POLARF
      DOUBLE PRECISION POLART,POLARF

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSIGM/  SIGMA,SIGANN,SIGAIR,FRACTN,FRCTNO
      DOUBLE PRECISION SIGMA,SIGANN,SIGAIR,FRACTN,FRCTNO

      COMMON /CRSTATI/ SABIN,SBBIN,INBIN,IPBIN,IKBIN,IHBIN
      DOUBLE PRECISION SABIN(40),SBBIN(40)
      INTEGER          INBIN(40),IPBIN(40),IKBIN(40),IHBIN(40)

      COMMON /CRVKIN/  BETACM
      DOUBLE PRECISION BETACM

       

       

       

       

      DOUBLE PRECISION BETA3,COSMU,COSTCM,COSTH3,ETOT,GAMMA3,
     *                 PHI,PHIMU,PHI3,SINMU,THICK,WORK1,WORK2
      INTEGER          I,IGO,KJ
      SAVE
      EXTERNAL         THICK
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) (CURPAR(I),I=0,9)
  444 FORMAT(' NUCINT: CURPAR=',1P,10E11.3)

C  COPY VERTEX COORDINATES INTO SECPAR
      DO  I = 5, 8
        SECPAR(I) = CURPAR(I)
      ENDDO
C  SET GENERATION AND LEVEL OF LAST INTERACTION
      SECPAR( 9) = GEN
      SECPAR(10) = ALEVEL
C  RESET POLARIZATION, NOT USED FOR PARTICLES OTHER THAN MUONS YET
      SECPAR(11) = 0.D0
      SECPAR(12) = 0.D0

      SECPAR(14) = CURPAR(14)
      SECPAR(15) = CURPAR(15)
      SECPAR(16) = CURPAR(16)

      THICKH = THICK( H )

      IF ( LLONGI ) LHEIGH = INT( THICKH * THSTPI + 1.D0 )

C  CALCULATE KIN. ENERGY BIN
      EKINL = PAMA(ITYPE) * ( GAMMA - 1.D0 )
      ETOT  = PAMA(ITYPE) * GAMMA
      IF ( EKINL .GE. .1D0 ) THEN
        KJ = INT( MIN( 40.D0, 5.D0 + 3.D0*LOG10(EKINL) ) )
      ELSE
        KJ = 1
      ENDIF

C-----------------------------------------------------------------------
C  CHARGED PION INCIDENT
      IF     ( ITYPE .EQ.  8  .OR.  ITYPE .EQ.  9 ) THEN
        IF ( DEBUG ) WRITE(MDEBUG,*) 'NUCINT: PION EKINL=',SNGL(EKINL),
     *                               ' ETOT=',ETOT

        IPBIN(KJ) = IPBIN(KJ) + 1

C  DECAY OR INTERACTION FOR CHARGED PIONS ?
        IF ( FDECAY ) THEN
C  INCREMENT GENERATION COUNTER TO DIFFERENTIATE BETWEEN MUONS FROM
C  DECAYS (K-DECAY: GEN=NORMAL, PI-DECAY: GEN INCREASED BY 50)
          SECPAR( 9) = SECPAR( 9) + 50.D0
C  DECAY  PI(+,-)  ---->  MU(+,-) + (ANTI)-NEUTRINO(MU)
          WORK1  = C(48) * GAMMA
          WORK2  = C(49) * BETA * WORK1
          CALL RMMARD( RD,2,1 )
          COSTCM = 2.D0 * RD(1) - 1.D0
          GAMMA3 = WORK1 + COSTCM * WORK2
          BETA3  = SQRT( (GAMMA3-1.D0)*(GAMMA3+1.D0) ) / GAMMA3
          COSTH3 = MIN( 1.D0, ( GAMMA * GAMMA3 - C(48) )
     *                      /( BETA * GAMMA * BETA3 * GAMMA3 ) )
          PHI3   = PI2 * RD(2)
C  NEUTRINO IS DROPPED
          IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT
            SECPAR(1) = PAMA(8) * GAMMA - PAMA(5) * GAMMA3

            DLONG(LHEIGH,8) = DLONG(LHEIGH,8) + SECPAR(1)

          ENDIF

C  MUON
          IF ( PHIX .NE. 0.D0  .OR.  PHIY .NE. 0.D0 ) THEN
            PHI = ATAN2( PHIY, PHIX )
          ELSE
            PHI = 0.D0
          ENDIF
          CALL ADDANG( COSTHE,PHI, COSTH3,PHI3, COSMU,PHIMU )
          IF ( COSMU .GT. C(29) ) THEN
C  DIRECTION OF PION IN THE MUON CM SYSTEM (= DIRECTION OF POLARIZATION)
C  SEE: G. BARR ET AL., PHYS. REV. D39 (1989) 3532, EQ. 5
C  POLART IS COS OF ANGLE BETWEEN PION AND LABORATORY IN THE MU CM
C  POLARF IS ANGLE PHI AROUND THE LAB DIRECTION IN THE MU CM
C  POLART, POLARF ARE WITH RESPECT TO THE MU DIRECTION IN THE LAB SYSTEM
            POLART = ( 2.D0*PAMA(8)*GAMMA*C(7)/(PAMA(5)*GAMMA3)
     *                 - C(7) - 1.D0 ) / ( BETA3 * (1.D0 - C(7)) )
            POLARF = PHI3 - PI
C  PION DIRECTION IS DIRECTION OF POLARIZATION FOR PI+, OPPOSITE FOR PI-
            IF ( ITYPE .EQ. 9 ) THEN
              POLART = -POLART
              POLARF = POLARF + PI
            ENDIF
C  GET THE POLARIZATION DIRECTION IN THE MU CM RELATIVE TO THE CORSIKA
C  COORDINATE SYSTEM
            CALL ADDANG( COSMU,PHIMU, POLART,POLARF, POLART,POLARF )
C  MUON IS WRITTEN TO STACK
            SECPAR( 0) = CURPAR(0) - 3.D0
            SECPAR( 1) = GAMMA3
            SECPAR( 2) = COSMU
            SINMU      = SQRT( (1.D0 - COSMU) * (1.D0 + COSMU) )
            SECPAR( 3) = SINMU * COS( PHIMU )
            SECPAR( 4) = SINMU * SIN( PHIMU )
            SECPAR(11) = POLART
            SECPAR(12) = POLARF
            CALL TSTACK
            SECPAR(11) = 0.D0
            SECPAR(12) = 0.D0
          ELSE
            IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

              DLONG(LHEIGH,15) = DLONG(LHEIGH,15) + GAMMA3 * PAMA(5)

            ENDIF
          ENDIF
          IRET1 = 1
          RETURN
        ENDIF

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  CHARGED PION INTERACTS

C  CALCULATE GAMMA, BETA AND ENERGY IN CENTER OF MASS
        ECM    = SQRT( C(45) * GAMMA + C(46) )
        GCM    = (PAMA(ITYPE) * GAMMA + PAMA(14)) / ECM
        BETACM = SQRT( (GCM-1.D0)*(GCM+1.D0) ) / GCM

C  LOW ENERGY HADRONIC INTERACTIONS
C  CHECK IF WE USE LOW ENERGY HADRONIC INTERACTION MODEL
        IF ( USELOW ) THEN

C  USE FLUKA LOW ENERGY HADRONIC INTERACTION MODEL
          CALL FLULNK
        ELSE
          IF ( PAMA(ITYPE)*GAMMA .GT. HILOELB ) THEN
C  USE HIGH ENERGY HADRONIC INTERACTION MODEL
            CALL SDPM( 0 )
          ELSE
            CALL FLULNK
          ENDIF
        ENDIF
C-----------------------------------------------------------------------
C  PI(0) INCIDENT
      ELSEIF ( ITYPE .EQ.  7 ) THEN
        IF ( DEBUG ) WRITE(MDEBUG,*) 'NUCINT: PI(0) EKINL=',SNGL(EKINL),
     *                               ' ETOT=',ETOT

        IPBIN(KJ) = IPBIN(KJ) + 1

C  DECAY OR INTERACTION FOR PIONS ?
        IF ( FDECAY ) THEN
          CALL PI0DEC
        ELSE
C  FOR INTERACTION THE ENERGY MUST BE VERY HIGH
C  CALCULATE GAMMA, BETA AND ENERGY IN CENTER OF MASS
          ECM    = SQRT( 2.D0 * PAMA(14) * PAMA(7) * GAMMA
     *                  + PAMA(14)**2 +PAMA(7)**2 )
          GCM    = (PAMA(7) * GAMMA + PAMA(14)) / ECM
          BETACM = SQRT( (GCM-1.D0)*(GCM+1.D0) ) / GCM
C  HIGH ENERGY INTERACTION MODEL
          CALL SDPM( 0 )
        ENDIF

C-----------------------------------------------------------------------
C  NUCLEON OR ANTINUCLEON INCIDENT
      ELSEIF ( ITYPE .EQ. 13  .OR.  ITYPE .EQ. 14  .OR.
     *         ITYPE .EQ. 15  .OR.  ITYPE .EQ. 25 ) THEN
        IF ( DEBUG ) WRITE(MDEBUG,*) 'NUCINT: NUCL EKINL=',SNGL(EKINL),
     *                               ' ETOT=',ETOT
C  CALCULATE GAMMA, BETA AND ENERGY IN CENTER OF MASS
        GCM    = SQRT( GAMMA * 0.5D0 + 0.5D0 )
        ECM    = PAMA(ITYPE) * GCM * 2.D0
        BETACM = SQRT( (GCM-1.D0)*(GCM+1.D0) ) / GCM
        INBIN(KJ) = INBIN(KJ) + 1

C  LOW ENERGY HADRONIC INTERACTIONS
C  CHECK IF WE USE LOW ENERGY HADRONIC INTERACTION MODEL
        IF ( USELOW ) THEN

C  USE FLUKA LOW ENERGY HADRONIC INTERACTION MODEL
          CALL FLULNK
        ELSE
          IF ( PAMA(ITYPE)*GAMMA .GT. HILOELB ) THEN
C  USE HIGH ENERGY HADRONIC INTERACTION MODEL
            CALL SDPM( 0 )
          ELSE
            CALL FLULNK
          ENDIF
        ENDIF

C-----------------------------------------------------------------------
C  KAON INCIDENT
      ELSEIF ( ITYPE .EQ. 11  .OR.  ITYPE .EQ. 12  .OR.
     *         ITYPE .EQ. 10  .OR.  ITYPE .EQ. 16 ) THEN
        IF ( DEBUG ) WRITE(MDEBUG,*) 'NUCINT: KAON EKINL=',SNGL(EKINL),
     *                               ' ETOT=',ETOT

        IKBIN(KJ) = IKBIN(KJ) + 1

C  DECAY OR INTERACTION FOR KAONS ?
        IF ( FDECAY ) THEN
C  KAON DECAYS. DETERMINE DECAY MODE FOR KAONS
          IF     ( ITYPE .EQ. 10 ) THEN
C  K(0,L)-MESON
            IGO = 4
          ELSEIF ( ITYPE .EQ. 11 ) THEN
C  K(+)-MESON
            IGO = 1
          ELSEIF ( ITYPE .EQ. 12 ) THEN
C  K(-)-MESON
            IGO = 2
          ELSE
C  K(0,S)-MESON
            IGO = 3
          ENDIF
          CALL KDECAY( IGO )
          RETURN

        ELSE
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  KAON INTERACTS
C  CALCULATE GAMMA, BETA AND ENERGY IN CENTER OF MASS
          ECM    = SQRT( CKA(13) * GAMMA + CKA(14) )
          GCM    = ( PAMA(ITYPE) * GAMMA + PAMA(14) ) / ECM
          BETACM = SQRT( (GCM-1.D0)*(GCM+1.D0) ) / GCM
C  LOW ENERGY HADRONIC INTERACTIONS
C  CHECK IF WE USE LOW ENERGY HADRONIC INTERACTION MODEL
          IF ( USELOW ) THEN

C  USE FLUKA LOW ENERGY HADRONIC INTERACTION MODEL
            CALL FLULNK
          ELSE
            IF ( PAMA(ITYPE)*GAMMA .GT. HILOELB ) THEN
C  USE HIGH ENERGY HADRONIC INTERACTION MODEL
              CALL SDPM( 0 )
            ELSE
              CALL FLULNK
            ENDIF
          ENDIF
        ENDIF

C-----------------------------------------------------------------------
C  ETA INCIDENT
      ELSEIF ( ITYPE .EQ. 17  .OR.
     *        (ITYPE .GE. 71  .AND.  ITYPE .LE. 74) ) THEN
        IF ( DEBUG ) WRITE(MDEBUG,*) 'NUCINT: ETA EKINL=',SNGL(EKINL),
     *                               ' ETOT=',ETOT

        IPBIN(KJ) = IPBIN(KJ) + 1

C  DECAY OR INTERACTION FOR ETAS ?
        IF ( FDECAY ) THEN
          CALL ETADEC
        ELSE
C  FOR INTERACTION THE ENERGY MUST BE VERY HIGH
C  CALCULATE GAMMA, BETA AND ENERGY IN CENTER OF MASS
          CURPAR(0) = 17.D0
          ITYPE     = 17
          ECM       = SQRT( 2.D0 * PAMA(14) * PAMA(17) * GAMMA
     *                  + PAMA(14)**2 +PAMA(17)**2 )
          GCM       = (PAMA(17) * GAMMA + PAMA(14)) / ECM
          BETACM    = SQRT( (GCM-1.D0)*(GCM+1.D0) ) / GCM
C  HIGH ENERGY INTERACTION MODEL
          CALL SDPM( 0 )
        ENDIF

C-----------------------------------------------------------------------
C  STRANGE BARYON (LAMDA, SIGMA) INCIDENT
      ELSEIF ( (ITYPE .GE. 18  .AND.  ITYPE .LE. 24)  .OR.
     *         (ITYPE .GE. 26  .AND.  ITYPE .LE. 32) ) THEN
        IF ( DEBUG ) WRITE(MDEBUG,*) 'NUCINT: SBAR EKINL=',SNGL(EKINL),
     *                               ' ETOT=',ETOT

        IHBIN(KJ) = IHBIN(KJ) + 1

C  DECAY OR INTERACTION FOR STRANGE BARYONS?
        IF ( FDECAY ) THEN
          CALL STRDEC
          RETURN
        ENDIF
C  CALCULATE GAMMA, BETA AND ENERGY IN CENTER OF MASS
        ECM    = SQRT( 2.D0 * PAMA(ITYPE) * PAMA(14) * GAMMA
     *              + PAMA(ITYPE)**2 + PAMA(14)**2 )
        GCM    = ( PAMA(ITYPE) * GAMMA + PAMA(14)) / ECM
        BETACM = SQRT( (GCM-1.D0)*(GCM+1.D0) ) / GCM
C  LOW ENERGY HADRONIC INTERACTIONS
C  CHECK IF WE USE LOW ENERGY HADRONIC INTERACTION MODEL
        IF ( USELOW ) THEN

C  USE FLUKA LOW ENERGY HADRONIC INTERACTION MODEL
          CALL FLULNK

        ELSE

C  QGSJET CANNOT TREAT STRANGE BARYONS, THEREFORE DECAY
          CALL STRDEC
          RETURN
        ENDIF

C-----------------------------------------------------------------------
C  HEAVY PRIMARY INCIDENT
      ELSEIF ( ITYPE .GE. 200 ) THEN
        IF ( DEBUG ) WRITE(MDEBUG,*) 'NUCINT: HEAVY PRIMARY EKINL=',
     *                 SNGL(EKINL),' ETOT=',ETOT
C  USE GHEISHA IF THE CROSS-SECTION HAS BEEN CALCULATED FOR GHEISHA
C  CHECK IF WE USE LOW ENERGY HADRONIC INTERACTION MODEL
        IF ( USELOW ) THEN

C  FLUKA WILL NOT TREAT NUCLEI,
C  THEREFORE USE SUPERPOSITION IN SDPM
          CALL SDPM( 0 )
        ELSE
C  USE SDPM AS STEERING ROUTINE IN HIGH ENERGY CASE
          CALL SDPM( 0 )
        ENDIF

C-----------------------------------------------------------------------
C  ILLEGAL PARTICLE
      ELSE

        WRITE(MONIOU,444) (CURPAR(I),I=0,9)

        WRITE(MONIOU,*) 'NUCINT: ILLEGAL PARTICLE = ',ITYPE
        STOP
      ENDIF

C-----------------------------------------------------------------------
C  KILL PARTICLE
      IRET1 = 1

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE OUTEND

C-----------------------------------------------------------------------
C  OUT(PUT AT) END (OF SHOWER)
C
C  WRITE REST OF PARTICLES TO OUTPUT BUFFER.
C  PRINTS INTERACTION LENGTHS STATISTICS.
C  THIS SUBROUTINE IS CALLED FROM AAMAIN.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRBUFFS/ RUNH,RUNE,EVTH,EVTE,DATAB,ARRAYLONG,LH
      INTEGER          MAXBUF,MAXLEN
      PARAMETER        (MAXLEN=16)

      PARAMETER        (MAXBUF=39*7)
      REAL             RUNH(MAXBUF),EVTH(MAXBUF),EVTE(MAXBUF),
     *                 RUNE(MAXBUF),DATAB(MAXBUF),ARRAYLONG(MAXBUF)
      INTEGER          LH
      CHARACTER*4      CRUNH,CRUNE,CEVTH,CEVTE,CLONG
      EQUIVALENCE      (RUNH(1),CRUNH), (RUNE(1),CRUNE)
      EQUIVALENCE      (EVTH(1),CEVTH), (EVTE(1),CEVTE)
      EQUIVALENCE      (ARRAYLONG(1),CLONG)

      COMMON /CRCHISTA/IHYCHI,IKACHI,IMUCHI,INNCHI,INUCHI,IPICHI,INECHI
      INTEGER          IHYCHI(124),IKACHI(124),IMUCHI(124),INNCHI(124),
     *                 INUCHI(124),IPICHI(124),INECHI(124)

      COMMON /CRELADPM/ELMEAN,ELMEAA,IELDPM,IELDPA
      DOUBLE PRECISION ELMEAN(40),ELMEAA(40)
      INTEGER          IELDPM(40,13),IELDPA(40,13)

      COMMON /CRMULT/  EKINL,MSMM,MULTMA,MULTOT
      DOUBLE PRECISION EKINL
      INTEGER          MSMM,MULTMA(40,13),MULTOT(40,13)

      COMMON /CRNCOUNT/NCOUN
      INTEGER          NCOUN(8)

      COMMON /CRNPARTI/NPARTO,NPART2
      DOUBLE PRECISION NPARTO(20,25), NPART2(20,25),
     *                 NPHOTO(20),NPOSIT(20),NELECT(20),
     *                 NNU(20),NMUP(20),NMUM(20),NPI0(20),NPIP(20),
     *                 NPIM(20),NK0L(20),NKPL(20),NKMI(20),NNEUTR(20),
     *                 NPROTO(20),NPROTB(20),NK0S(20),NHYP(20),
     *                 NNEUTB(20),NDEUT(20),NTRIT(20),NHELI3(20),
     *                 NALPHA(20),NOTHER(20),NMUOND
      EQUIVALENCE (NPARTO(1, 1),NPHOTO(1)), (NPARTO(1, 2),NPOSIT(1)),
     *            (NPARTO(1, 3),NELECT(1)), (NPARTO(1, 4),NNU(1))   ,
     *            (NPARTO(1, 5),NMUP(1))  , (NPARTO(1, 6),NMUM(1))  ,
     *            (NPARTO(1, 7),NPI0(1))  , (NPARTO(1, 8),NPIP(1))  ,
     *            (NPARTO(1, 9),NPIM(1))  , (NPARTO(1,10),NK0L(1))  ,
     *            (NPARTO(1,11),NKPL(1))  , (NPARTO(1,12),NKMI(1))  ,
     *            (NPARTO(1,13),NNEUTR(1)), (NPARTO(1,14),NPROTO(1)),
     *            (NPARTO(1,15),NPROTB(1)), (NPARTO(1,16),NK0S(1))  ,
     *            (NPARTO(1,18),NHYP(1))  , (NPARTO(1,19),NDEUT(1)) ,
     *            (NPARTO(1,20),NTRIT(1)) , (NPARTO(1,21),NHELI3(1)),
     *            (NPARTO(1,22),NALPHA(1)), (NPARTO(1,23),NOTHER(1)),
     *            (NPARTO(1,24),NMUOND)   , (NPARTO(1,25),NNEUTB(1))

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRECORD/IRECOR
      INTEGER          IRECOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSTACKF/STACKI,MSTACKP,MEXST,NSHIFT,NOUREC,ICOUNT,
     *                 NTO,NFROM
      INTEGER          MAXSTK

      PARAMETER        (MAXSTK = 17*256*2)
      DOUBLE PRECISION STACKI(MAXSTK)
      INTEGER          MSTACKP,MEXST,NSHIFT,NOUREC,ICOUNT,NTO,NFROM

      COMMON /CRSTATI/ SABIN,SBBIN,INBIN,IPBIN,IKBIN,IHBIN
      DOUBLE PRECISION SABIN(40),SBBIN(40)
      INTEGER          INBIN(40),IPBIN(40),IKBIN(40),IHBIN(40)

       

       

       

       

      INTEGER          I

      INTEGER          J,K,NELMEA

      SAVE
C-----------------------------------------------------------------------

      IF ( LH .GT. 0 ) THEN

        IF ( FPAROUT ) CALL TOBUF( DATAB,0 )

        DO  I = 1, MAXBUF
          DATAB(I) = 0.
        ENDDO
      ENDIF
      LH = 0

      IF ( FPRINT  .OR.  DEBUG ) THEN
        WRITE(MONIOU,101) NSHIFT,NOPART
  101   FORMAT(' ',I10,' SHIFTS TO EXTERNAL STACK'/
     *         ' ',I10,' PARTICLES WRITTEN TO MPATAP')
      ENDIF

      IF ( FPRINT ) THEN
C  PRINT ENERGY - MULTIPLICITY MATRIX
        WRITE(MONIOU,209) ISHOWNO,(K,K=1,13),
     *  (J,(MULTMA(J,K),K=1,13),10**((J-4.)/3.),10**((J-3.)/3.),J=1,39),
     *     1,(INT(10**((K-1.)/3.)+1 ),K = 2,13),
     *     2,(INT(10**((K   )/3.)   ),K = 2,13)
  209   FORMAT(/,/' ENERGY - MULTIPLICITY MATRIX OF SHOWER NO ',I10/
     *           ' ENERGY RUNS VERTICALLY, MULTIPLICITY HORIZONTALLY'/,/
     *           ' ',4X,5I10,3I8,5I6,'   ENERGY RANGE (GEV)'/
     *           39(/' ',I3,1X,5I10,3I8,5I6,1X,1P,2E10.1,0P)//
     *           ' MULT.',I9,4I10,3I8,5I6,4X,'LOWER BIN LIMIT'/
     *           ' RANGE',I9,4I10,3I8,5I6,4X,'UPPER BIN LIMIT')
      ENDIF

C  GET MEAN OF ELASTICITY FOR ENERGY BINS
      DO  J = 1, 40
        NELMEA = 0
        DO  K = 1, 10
          NELMEA = NELMEA + IELDPM(J,K)
        ENDDO
        IF ( NELMEA .NE. 0 ) ELMEAN(J) = ELMEAN(J) / NELMEA
      ENDDO

      IF ( FPRINT ) THEN
C  PRINT ENERGY - ELASTICITY MATRIX
        WRITE(MONIOU,408) ISHOWNO,(K,K=1,10),
     *        (J,(IELDPM(J,K),K=1,10),
     *        ELMEAN(J),10**((J-4.)/3.),10**((J-3.)/3.),J=1,39),
     *        ((K-1)*0.1,K=1,10),(K*0.1,K=1,10)
  408   FORMAT (/,/' ENERGY - ELASTICITY MATRIX OF SHOWER NO ',I10/
     *            ' ENERGY RUNS VERTICALLY, ELASTICITY HORIZONTALLY'/,/
     *            ' ',5X,8I9,2I10,'   MEAN EL.   ENERGY RANGE (GEV)'/
     *            39(/' ',I4,1X,8I9,2I10,2X,1P,E10.3,2E10.1,0P)/,/
     *            ' ELA. ',8F9.2,2F10.2,5X,'LOWER BIN LIMIT'/
     *            ' RANGE',8F9.2,2F10.2,5X,'UPPER BIN LIMIT')

        WRITE(MONIOU,204) ISHOWNO
  204   FORMAT(/,/' INTERACTIONS PER KINETIC ENERGY INTERVAL OF SHOWER',
     *         ' NO ',I10/,/)
        WRITE(MONIOU,205)
  205   FORMAT('   BIN    LOWER LIMIT    UPPER LIMIT    ',
     *         ' NUCLEON       PIONS      KAONS  S.BARYONS      TOTAL'/
     *         '             IN GEV         IN GEV      ',
     *         '  EVENTS      EVENTS     EVENTS     EVENTS  '/)
        WRITE(MONIOU,207) (I,SABIN(I),SBBIN(I),INBIN(I),IPBIN(I),
     *    IKBIN(I),IHBIN(I),INBIN(I)+IPBIN(I)+IKBIN(I)+IHBIN(I),I=1,40)
  207   FORMAT(' ',I5,1P,2E15.4,0P,1X,5I11)
        WRITE(MONIOU,301)
  301   FORMAT (/,/' INTERACTION LENGTH STATISTICS: ',
     *        '    1 BIN CORRESPONDS TO 10 G/CM**2 OR 100M FOR MUONS'/,/
     *        '  BIN      LAMBDA NU   LAMBDA PI   LAMBDA KA   ',
     *                   'LAMBDA HY   LAMBDA MU   LAMBDA NUCLEUS'/)
        WRITE(MONIOU,303) (I,INUCHI(I),IPICHI(I),IKACHI(I),IHYCHI(I),
     *                      IMUCHI(I),INNCHI(I),I=1,124)
  303   FORMAT (' ',I4,6I12)

        WRITE(MONIOU,105) IRECOR
  105   FORMAT (/' NO OF WORDS WRITTEN TO PARTICLE TAPE UP TO NOW =',
     *           I10)
      ENDIF

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE OUTPT1

C-----------------------------------------------------------------------
C  (WRITE PARTICLE) OUTP(U)T  1
C
C  WRITES 39 PARTICLE RECORDS PER PHYSICAL RECORD
C  TABULATES PARAMETERS OF ALL HIGH ENERGY PARTICLES WITH
C  LORENTZ FACTOR LARGER THAN ECTMAP.
C  THIS SUBROUTINE IS CALLED FROM AAMAIN, BOX3, MUTRAC, UPDATC,
C  AND AUSGAB.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRBUFFS/ RUNH,RUNE,EVTH,EVTE,DATAB,ARRAYLONG,LH
      INTEGER          MAXBUF,MAXLEN
      PARAMETER        (MAXLEN=16)

      PARAMETER        (MAXBUF=39*7)
      REAL             RUNH(MAXBUF),EVTH(MAXBUF),EVTE(MAXBUF),
     *                 RUNE(MAXBUF),DATAB(MAXBUF),ARRAYLONG(MAXBUF)
      INTEGER          LH
      CHARACTER*4      CRUNH,CRUNE,CEVTH,CEVTE,CLONG
      EQUIVALENCE      (RUNH(1),CRUNH), (RUNE(1),CRUNE)
      EQUIVALENCE      (EVTH(1),CEVTH), (EVTE(1),CEVTE)
      EQUIVALENCE      (ARRAYLONG(1),CLONG)

      COMMON /CRETHMAP/ECTMAP,ELEFT
      DOUBLE PRECISION ECTMAP,ELEFT

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRMAGANG/ARRANG,ARRANR,COSANG,SINANG
      DOUBLE PRECISION ARRANG,ARRANR,COSANG,SINANG

      COMMON /CRMULT/  EKINL,MSMM,MULTMA,MULTOT
      DOUBLE PRECISION EKINL
      INTEGER          MSMM,MULTMA(40,13),MULTOT(40,13)

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRNPARTI/NPARTO,NPART2
      DOUBLE PRECISION NPARTO(20,25), NPART2(20,25),
     *                 NPHOTO(20),NPOSIT(20),NELECT(20),
     *                 NNU(20),NMUP(20),NMUM(20),NPI0(20),NPIP(20),
     *                 NPIM(20),NK0L(20),NKPL(20),NKMI(20),NNEUTR(20),
     *                 NPROTO(20),NPROTB(20),NK0S(20),NHYP(20),
     *                 NNEUTB(20),NDEUT(20),NTRIT(20),NHELI3(20),
     *                 NALPHA(20),NOTHER(20),NMUOND
      EQUIVALENCE (NPARTO(1, 1),NPHOTO(1)), (NPARTO(1, 2),NPOSIT(1)),
     *            (NPARTO(1, 3),NELECT(1)), (NPARTO(1, 4),NNU(1))   ,
     *            (NPARTO(1, 5),NMUP(1))  , (NPARTO(1, 6),NMUM(1))  ,
     *            (NPARTO(1, 7),NPI0(1))  , (NPARTO(1, 8),NPIP(1))  ,
     *            (NPARTO(1, 9),NPIM(1))  , (NPARTO(1,10),NK0L(1))  ,
     *            (NPARTO(1,11),NKPL(1))  , (NPARTO(1,12),NKMI(1))  ,
     *            (NPARTO(1,13),NNEUTR(1)), (NPARTO(1,14),NPROTO(1)),
     *            (NPARTO(1,15),NPROTB(1)), (NPARTO(1,16),NK0S(1))  ,
     *            (NPARTO(1,18),NHYP(1))  , (NPARTO(1,19),NDEUT(1)) ,
     *            (NPARTO(1,20),NTRIT(1)) , (NPARTO(1,21),NHELI3(1)),
     *            (NPARTO(1,22),NALPHA(1)), (NPARTO(1,23),NOTHER(1)),
     *            (NPARTO(1,24),NMUOND)   , (NPARTO(1,25),NNEUTB(1))

      COMMON /CROBSPAR/OBSLEV,THCKOB,XOFF,YOFF,HEIGHP,THETAP,PHIP,
     *                 THETPR,PHIPR,

     *                 VUECON,

     *                 NOBSLV
      DOUBLE PRECISION OBSLEV(20),THCKOB(20),XOFF(20),YOFF(20),
     *                 HEIGHP,THETAP,THETPR(2),PHIP,PHIPR(2)

      DOUBLE PRECISION VUECON(2)

      INTEGER          NOBSLV

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      INTEGER          IEBIN, ITBIN, IDBIN
      PARAMETER        (IEBIN=40,ITBIN=30,IDBIN=20)
      COMMON /CRTABLES/G_ARRAY, E_ARRAY, M_ARRAY,
     *                 EBOFF,EBFAC,TBOFF,TBFAC,DBOFF,DBFAC
      REAL             G_ARRAY(IEBIN,ITBIN,IDBIN)
      REAL             E_ARRAY(IEBIN,ITBIN,IDBIN)
      REAL             M_ARRAY(IEBIN,ITBIN,IDBIN)
      REAL             EBOFF,EBFAC,TBOFF,TBFAC,DBOFF,DBFAC
      REAL             EBMIN,EBMAX,TBMIN,TBMAX,DBMIN,DBMAX
      PARAMETER        (EBMIN=1.E-4,EBMAX=1.E4)
      PARAMETER        (TBMIN=10.,TBMAX=1.E4)
      PARAMETER        (DBMIN=5.E3,DBMAX=5.E5)

       

       

       

       

      DOUBLE PRECISION AUGM,AUGM2,ETOT,PHIMU,PHIPAR,PTOT,STT,XADDMU,
     *                 YADDMU
      REAL             EEE,TT,RR,TF
      INTEGER          IIE,IIT,IID
      INTEGER          I,IGG,III,NCOUNT
      LOGICAL          ROUT

      SAVE
      DATA             NCOUNT/0/, AUGM/1.D0/, AUGM2/1.D0/
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) (OUTPAR(I),I=0,9),LEVL
  444 FORMAT(' OUTPT1: OUTPAR=',1P,9E11.3,0P,F10.0,I5)

C  PRINT OUT PARTICLE IF IT IS ABOVE THE CUT
      IF ( FPRINT  .OR.  DEBUG  .OR.  DEBDEL ) THEN
        IF ( OUTPAR(1) .GE. ECTMAP ) THEN

          WRITE(MONIOU,3) (OUTPAR(I),I=0,10),ELEFT
    3     FORMAT(' OUTPT1:        ',1P,9E11.3,0P,F6.0,1P,2E10.3)

          IF ( DEBDEL ) THEN
            NCOUNT = NCOUNT + 1
            WRITE(MDEBUG,*) 'OUTPT1: NCOUNT = ',NCOUNT
            IF ( NCOUNT .GE. NDEBDL ) DEBUG = .TRUE.
            IF ( NCOUNT .GE. NDEBDL+2 ) DEBUG = .FALSE.
          ENDIF
        ENDIF
      ENDIF

      III  = NINT( OUTPAR(0) )
      IF ( III .GE. 71  .AND.  III .LE. 74 ) III = 17

C  COUNT PARTICLES SPECIFIED BY THEIR PARTICLE CODE < 25
      IF     ( III .LT. 18                       ) THEN
        NPARTO(LEVL,III) = NPARTO(LEVL,III) + AUGM
      ELSEIF ( III .EQ. 25                       ) THEN
        NNEUTB(LEVL) = NNEUTB(LEVL) + AUGM
      ELSEIF ( (III .GE. 18  .AND.  III .LE. 24)  .OR.
     *         (III .GE. 26  .AND.  III .LE. 32) ) THEN
        NHYP(LEVL)   = NHYP(LEVL) + AUGM
      ELSE
        IF     ( III .EQ. 201                      ) THEN
          NDEUT(LEVL)  = NDEUT(LEVL) + AUGM
        ELSEIF ( III .EQ. 301                      ) THEN
          NTRIT(LEVL)  = NTRIT(LEVL) + AUGM
        ELSEIF ( III .EQ. 302                      ) THEN
          NHELI3(LEVL) = NHELI3(LEVL) + AUGM
        ELSEIF ( III .EQ. 402                      ) THEN
          NALPHA(LEVL) = NALPHA(LEVL) + AUGM

        ELSE
          WRITE(MONIOU,*) 'OUTPT1: PARTICLE ON OBSLEV ',LEVL,
     *                    '  ID= ',III
          NOTHER(LEVL) = NOTHER(LEVL) + AUGM
        ENDIF
      ENDIF

      IF ( LLONGI  .AND.  LEVL .EQ. NOBSLV ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT IN LAST BIN NSTEP
        LHEIGH = NSTEP

        IF     ( III .EQ.  1                    ) THEN
          DLONG(LHEIGH,1) = DLONG(LHEIGH,1) + OUTPAR(1) * AUGM
        ELSEIF ( III .EQ.  2                    ) THEN
C  REMEMBER: FOR EM-PARTICLES OUTPAR(2) CONTAINS ENERGY IN GEV
          DLONG(LHEIGH,3) = DLONG(LHEIGH,3) + (OUTPAR(1)+PAMA(2))*AUGM
        ELSEIF ( III .EQ.  3                    ) THEN
          DLONG(LHEIGH,3) = DLONG(LHEIGH,3) + (OUTPAR(1)-PAMA(2))*AUGM
        ELSEIF ( III .EQ.  5  .OR.  III .EQ.  6 ) THEN
          DLONG(LHEIGH,5) = DLONG(LHEIGH,5)
     *                                   + OUTPAR(1)*PAMA(5)*AUGM
        ELSEIF ( III .EQ. 13  .OR.  III .EQ. 14 ) THEN
          DLONG(LHEIGH,7) = DLONG(LHEIGH,7)
     *                          + (OUTPAR(1)-1.D0)*PAMA(III)*AUGM
        ELSEIF ( III .EQ. 15  .OR.  III .EQ. 25 ) THEN
          DLONG(LHEIGH,7) = DLONG(LHEIGH,7)
     *                          + (OUTPAR(1)+1.D0)*PAMA(III)*AUGM

        ELSE
          DLONG(LHEIGH,7) = DLONG(LHEIGH,7) + (OUTPAR(1)*PAMA(III)
     *                                      - RESTMS(III)) * AUGM
        ENDIF
      ENDIF

      ROUT = .TRUE.

C  TREATE ADDITIONAL INFORMATION OF MUONS
C  THE COORDINATES OF MUON ORIGIN ARE STORED IN AMUPAR(.)
      IF ( ROUT ) THEN
        IF ( FMUADD  .AND.  (III .EQ. 5  .OR.  III .EQ. 6) ) THEN
          IGG = MIN( OUTPAR(9), 99.D0 )
          DATAB(LH+1) = (III + 70) * 1000 + IGG*10 + MOD(LEVL,10)
          PTOT = PAMA(III) * SQRT( (AMUPAR(1)-1.D0)*(AMUPAR(1)+1.D0) )

          DATAB(LH+4) = PTOT * AMUPAR(15)
          XADDMU = AMUPAR(7)
          YADDMU = AMUPAR(8)
          STT  = SQRT( (1.D0-AMUPAR(15))*(1.D0+AMUPAR(15)) )

          IF ( AMUPAR(4) .NE. 0.D0  .OR.  AMUPAR(3) .NE. 0.D0 ) THEN
            PHIMU = ATAN2( AMUPAR(4), AMUPAR(3) )
          ELSE
            PHIMU = 0.D0
          ENDIF
          DATAB(LH+2) = PTOT * STT * COS( PHIMU + ARRANR )
          DATAB(LH+3) = PTOT * STT * SIN( PHIMU + ARRANR )
          DATAB(LH+5) = XADDMU * COSANG + YADDMU * SINANG
          DATAB(LH+6) = YADDMU * COSANG - XADDMU * SINANG
          DATAB(LH+7) = AMUPAR(5)

          IF ( DEBUG ) WRITE(MDEBUG,445) (DATAB(LH+I),I=1,7)
  445     FORMAT(' OUTPT1: MUADDI=',1P,7E10.3)
          LH = LH + 7

C  WRITE A BLOCK OF 39 PARTICLES TO OUTPUT BUFFER AND CLEAR FIELD
          IF ( LH .GE. MAXBUF ) THEN

            IF ( FPAROUT ) CALL TOBUF( DATAB,0 )

            DO  I = 1, MAXBUF
              DATAB(I) = 0.
            ENDDO
            LH = 0
          ENDIF
        ENDIF

C   COPY PARTICLE TO DATAB FIELD
        IGG = MIN( OUTPAR(9), 99.D0 )
        DATAB(LH+1) = III*1000 + IGG*10 + MOD(LEVL,10)
        IF     ( OUTPAR(0) .LE. 3.D0 ) THEN
          ETOT = OUTPAR(1)

        ELSE
          ETOT = PAMA(III) * OUTPAR(1)
        ENDIF
        PTOT = SQRT( (ETOT-PAMA(III))*(ETOT+PAMA(III)) )
        STT  = SQRT( (1.D0-OUTPAR(2))*(1.D0+OUTPAR(2)) )
        IF ( OUTPAR(4) .NE. 0.D0  .OR.  OUTPAR(3) .NE. 0.D0 ) THEN
          PHIPAR = ATAN2( OUTPAR(4), OUTPAR(3) )
        ELSE
          PHIPAR = 0.D0
        ENDIF
        DATAB(LH+2) = PTOT * STT * COS( PHIPAR + ARRANR )
        DATAB(LH+3) = PTOT * STT * SIN( PHIPAR + ARRANR )
        DATAB(LH+4) = PTOT * OUTPAR(2)
        DATAB(LH+5) = OUTPAR(7) * COSANG + OUTPAR(8) * SINANG
        DATAB(LH+6) = OUTPAR(8) * COSANG - OUTPAR(7) * SINANG
        DATAB(LH+7) = OUTPAR(6) * 1.E9
      ENDIF

      IF ( FTABOUT ) THEN
C  CALCULATE TIME DELAY (IN NS) WITH RESPECT TO SPHERICAL SHOWER
C  FRONT AT POINT (X,Y)
        TF = SQRT( (HEIGHP - OBSLEV(LEVL))**2 +
     *             (OUTPAR(7)+XOFF(LEVL))**2 +
     *             (OUTPAR(8)+YOFF(LEVL))**2 ) / (C(25)*1.D-9)
        TT = OUTPAR(6)*1.D9 - TF
        IF ( OUTPAR(0) .LE. 3.D0 ) THEN
          ETOT = OUTPAR(1)
        ELSE
          ETOT = PAMA(III) * OUTPAR(1)
        ENDIF
        EEE = ETOT

        RR = SQRT( OUTPAR(7)**2 + OUTPAR(8)**2 )

        EEE = MAX( EBMIN, EEE )
        TT = MAX( TBMIN, TT )
        RR = MAX( DBMIN, RR )
C  GET CORRECT BIN
        IIE = (LOG10(EEE) - EBOFF)*EBFAC + 1.
        IIT = (LOG10(TT) - TBOFF)*TBFAC + 1.
        IID = (LOG10(RR) - DBOFF)*DBFAC + 1.
        IIE = MIN( IIE, IEBIN )
        IIE = MAX( 1, IIE )
        IIT = MIN( IIT, ITBIN )
        IIT = MAX( 1, IIT )
        IID = MIN( IID, IDBIN )
        IID = MAX( 1, IID )

        IF     ( III .EQ. 1 ) THEN
          G_ARRAY(IIE,IIT,IID) = G_ARRAY(IIE,IIT,IID) + AUGM
        ELSEIF ( III .LE. 3 ) THEN
          E_ARRAY(IIE,IIT,IID) = E_ARRAY(IIE,IIT,IID) + AUGM
        ELSEIF ( III .EQ. 5  .OR.  III .EQ. 6 ) THEN
          M_ARRAY(IIE,IIT,IID) = M_ARRAY(IIE,IIT,IID) + AUGM
        ENDIF
      ENDIF

      IF ( ROUT ) THEN
C  COUNT PARTICLES SPECIFIED BY THEIR PARTICLE CODE < 25
        IF     ( III .LT. 18                       ) THEN
          NPART2(LEVL,III) = NPART2(LEVL,III) + AUGM2
        ELSEIF ( III .EQ. 25                       ) THEN
          NPART2(LEVL,25) = NPART2(LEVL,25) + AUGM2
        ELSEIF ( (III .GE. 18  .AND.  III .LE. 24)  .OR.
     *           (III .GE. 26  .AND.  III .LE. 32) ) THEN
          NPART2(LEVL,18) = NPART2(LEVL,18) + AUGM2
        ELSEIF ( III .EQ. 201                      ) THEN
          NPART2(LEVL,19) = NPART2(LEVL,19) + AUGM2
        ELSEIF ( III .EQ. 301                      ) THEN
          NPART2(LEVL,20) = NPART2(LEVL,20) + AUGM2
        ELSEIF ( III .EQ. 402                      ) THEN
          NPART2(LEVL,21) = NPART2(LEVL,21) + AUGM2

        ELSE
          WRITE(MONIOU,*) 'OUTPT1: PARTICLE ON OBSLEV ',LEVL,
     *                    '  ID= ',III
          NPART2(LEVL,22) = NPART2(LEVL,22) + AUGM2
        ENDIF
C  COUNT PARTICLES, THAT ARE WRITTEN TO TAPE
        NOPART = NOPART + 1

        LH = LH + 7

C  WRITE A BLOCK OF 39 PARTICLES TO OUTPUT BUFFER AND CLEAR FIELD
        IF ( LH .GE. MAXBUF ) THEN

          IF ( FPAROUT ) CALL TOBUF( DATAB,0 )

          DO  I = 1, MAXBUF
            DATAB(I) = 0.
          ENDDO
          LH = 0
        ENDIF
      ENDIF

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE PAMAF

C-----------------------------------------------------------------------
C  PA(RTICLE) MA(SS) F(ILLING)
C
C  FILLS PARTICLE MASS FOR PARTICLE IP IN ARRAY PAMA,
C  RESONANCES AND STRANGE BARYONS INCLUDED.
C  PARTICLE MASSES ACCORDING TO PARTICLE DATA GROUP TABLES
C  OR CALCULATED WITH THE MASS FORMULA OF WEIZSAECKER.
C  LIFE TIMES ARE TAKEN FROM THE PARTICLE DATA GROUP TABLES.
C  THIS SUBROUTINE IS CALLED FROM START.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

       

       

       

       

      DOUBLE PRECISION CHARGE(75),MASSES(75)
      DOUBLE PRECISION CHARGE2(100),MASSES2(100)
C*    DOUBLE PRECISION AMUS(59,14),BIND,B1,B2,B3A,B4,B5,SS
      DOUBLE PRECISION DECTME(75),DECTME2(100)
      INTEGER          IA,IC,IN,IP
C*    INTEGER          I,L
      SAVE
C-----------------------------------------------------------------------

C  MASSES REVISED NOV  2004 BY D. HECK
      DATA MASSES /
     * 0.D0       ,.51099892D-3,.51099892D-3,  0.D0     ,.105658369D0,
     * .105658369D0, .1349766D0, .13957018D0,.13957018D0, 0.497648D0 ,!10
     * 0.493677D0 , 0.493677D0 ,.93956536D0 ,.93827203D0,.93827203D0 ,
     * 0.497648D0 , 0.54775D0  , 1.115683D0 , 1.18937D0 , 1.192642D0 ,!20
     * 1.197449D0 , 1.31483D0  , 1.32131D0  , 1.67245D0 ,.93956536D0 ,
     * 1.115683D0 , 1.18937D0  , 1.192642D0 , 1.197449D0, 1.31483D0  ,!30
     * 1.32131D0  , 1.67245D0  , 0.D0       , 0.D0      , 0.D0       ,
     * 0.D0       , 0.D0       , 0.D0       , 0.D0      , 0.D0       ,!40
     * 0.D0       , 0.D0       , 0.D0       , 0.D0      , 0.D0       ,
     * 0.D0       , 0.D0       , 0.D0       , 0.D0      , 0.78259D0  ,!50
     * 0.7690D0   , 0.7665D0   , 0.7665D0   , 1.2305D0  , 1.2318D0   ,
     * 1.2331D0   , 1.2344D0   , 1.2309D0   , 1.2323D0  , 1.2336D0   ,!60
     * 1.2349D0   , 0.89610D0  , 0.89166D0  , 0.89166D0 , 0.89610D0  ,
     * 0.D0       , 0.D0       , 0.D0       , 0.D0      , 0.D0       ,!70
     * 0.54775D0  , 0.54775D0  , 0.54775D0  , 0.54775D0 , 0.D0       /

      DATA CHARGE /
     *  0.D0,+1.D0,-1.D0, 0.D0,+1.D0,-1.D0, 0.D0,+1.D0,-1.D0, 0.D0,
     * +1.D0,-1.D0, 0.D0,+1.D0,-1.D0, 0.D0, 0.D0, 0.D0,+1.D0, 0.D0,
     * -1.D0, 0.D0,-1.D0,-1.D0, 0.D0, 0.D0,-1.D0, 0.D0,+1.D0, 0.D0,
     * +1.D0,+1.D0, 0.D0, 0.D0,+ 0D0,- 0D0, 0.D0, 0.D0, 0.D0, 0.D0,
     *  0.D0, 0.D0, 0.D0, 0.D0, 0.D0, 0.D0, 0.D0, 0.D0, 0.D0, 0.D0,
     *  0.D0,+1.D0,-1.D0,+2.D0,+1.D0, 0.D0,-1.D0,-2.D0,-1.D0, 0.D0,
     * +1.D0, 0.D0,+1.D0,-1.D0, 0.D0, 0.D0, 0.D0, 0.D0, 0.D0, 0.D0,
     *  0.D0, 0.D0, 0.D0, 0.D0, 0.D0 /

C  LIFE TIMES AT REST TAKEN FROM THE PARTICLE DATA GROUP TABLES
      DATA DECTME/
     *  0.D0      , 0.D0      , 0.D0      , 0.D0      , 2.19703D-6,
     *  2.19703D-6, 8.4D-17   , 2.6033D-8 , 2.6033D-8 , 5.18D-8   ,  !10
     *  1.2384D-8 , 1.2384D-8 , 885.7D0   , 0.D0      , 0.D0      ,
     *  0.8958D-10, 5.10D-19  , 2.632D-10 , 0.8018D-10, 7.4D-20   ,  !20
     *  1.479D-10 , 2.90D-10  , 1.639D-10 , 0.821D-10 , 885.7D0   ,
     *  2.632D-10 , 0.8018D-10, 7.4D-20   , 1.479D-10 , 2.90D-10  ,  !30
     *  1.639D-10 , 0.821D-10 , 0.D0      , 0.D0      , 0.D0      ,
     *  0.D0      , 0.D0      , 0.D0      , 0.D0      , 0.D0      ,  !40
     *  0.D0      , 0.D0      , 0.D0      , 0.D0      , 0.D0      ,
     *  0.D0      , 0.D0      , 0.D0      , 0.D0      , 7.75D-23  ,  !50
     *  4.38D-24  , 4.38D-24  , 4.38D-24  , 5.87D-24  , 5.02D-24  ,
     *  5.606D-24 , 5.D-24    , 5.87D-24  , 5.02D-24  , 5.606D-24 ,  !60
     *  5.D-24    , 1.298D-23 , 1.296D-23 , 1.296D-23 , 1.298D-23 ,
     *  0.D0      , 0.D0      , 0.D0      , 0.D0      , 0.D0      ,  !70
     *  5.10D-19  , 5.10D-19  , 5.10D-19  , 5.10D-19  , 0.D0      /

C  CHARGE2,  MASSES2 AND DECTME2  RUN FROM PARTICLE CODE 101 TO 200
      DATA MASSES2 /
     * 15*0.D0,
     * 1864.6D0   , 1869.4D0   , 1869.4D0   , 1864.6D0   , 1968.3D0   , !120
     * 1968.3D0   , 2979.6D0   , 2006.7D0   , 2010.0D0   , 2010.0D0   ,
     * 2006.7D0   , 2112.1D0   , 2112.1D0   , 3510.51D0  , 3096.916D0 , !130
     * 1776.99D0  , 1776.99D0  , 0.D0       , 0.D0       , 0.D0       ,
     * 0.D0       , 2284.9D0   , 2466.3D0   , 2471.8D0   , 2452.5D0   , !140
     * 2451.3D0   , 2452.2D0   , 2574.1D0   , 2578.8D0   , 2697.5D0   ,
     * 0.D0       , 0.D0       , 0.D0       , 2284.9D0   , 2466.3D0   , !150
     * 2471.8D0   , 2452.5D0   , 2451.3D0   , 2452.2D0   , 2574.1D0   ,
     * 2578.8D0   , 2697.5D0   , 0.D0       , 0.D0       , 0.D0       , !160
     * 2519.4D0   , 2515.9D0   , 2517.5D0   , 0.D0       , 0.D0       ,
     * 5*0.D0     ,                                                     !170
     * 2519.4D0   , 2515.9D0   , 2517.5D0   , 0.D0       , 0.D0       ,
     * 5*0.D0     ,                                                     !180
     * 20*0.D0/

      DATA CHARGE2 /
     * 10*0.D0,
     *  5*0.D0,                       0.D0,+1.D0,-1.D0, 0.D0,+1.D0,   !120
     * -1.D0, 0.D0, 0.D0, 7*0.D0,
     * -1.D0,+1.D0, 0.D0, 0.D0, 0.D0, 0.D0,+1.D0,+1.D0, 0.D0,+2.D0,   !140
     * +1.D0, 0.D0,+1.D0, 0.D0, 0.D0,+2.D0,+1.D0,+1.D0,-1.D0,-1.D0,
     *  0.D0,-2.D0,-1.D0, 0.D0,-1.D0, 0.D0, 0.D0,-2.D0,-1.D0,-1.D0,   !160
     * +2.D0,+1.D0, 0.D0, 6*0.D0,                            +2.D0,
     * -2.D0,-1.D0, 0.D0, 6*0.D0,                            -2.D0,   !180
     * 20*0.D0/

      DATA DECTME2/
     * 15* 0.D0      ,
     *  0.4103D-12, 1.040D-12 , 1.040D-12 , 0.4103D-12, 0.490D-12 ,  !120
     *  0.490D-12 , 3.805D-23 , 4.D-22    , 6.86D-21  , 6.86D-21  ,
     *  4.D-22    , 4.D-22    , 4.D-22    , 7.15D-20  , 7.233D-21 ,  !130
     * 290.6D-15  , 290.6D-15 , 0.D0      , 0.D0      , 0.D0      ,
     *  0.D0      , 0.200D-12 , 0.442D-12 , 0.112D-12 , 2.95D-22  ,  !140
     *  2.D-22    , 3.D-22    , 0.D0      , 0.D0      , 0.69D-13  ,
     *  0.D0      , 0.D0      , 0.D0      , 0.200D-12 , 0.442D-12 ,  !150
     *  0.112D-12 , 2.95D-22  , 2.D-22    , 3.D-22    , 0.D0      ,
     *  0.D0      , 0.69D-13  , 0.D0      , 0.D0      , 0.D0      ,  !160
     *  3.66D-23  , 4.D-23    , 5.06D-23  , 0.D0      , 0.D0      ,
     *  5*0.D0    ,                                                  !170
     *  3.66D-23  , 4.D-23    , 5.06D-23  , 0.D0      , 0.D0      ,
     *  5*0.D0    ,                                                  !180
     *  20*0.D0   /

C  ISOTOPE MASSES CALCULATED FROM: ATOMIC DATA AND NUCL.DATA TABLES 39
C  (1988) 289, (WAPSTRA''S VALUES, CORRECTED FOR ELECTRON MASSES)
C*    DATA ((AMUS(I,L),I=1,59),L=1,7) /
C*   * 1.8756D0,  2.8089D0,                                    57*0.D0,
C*   * 2.8083D0,  3.7273D0,  4.6678D0,  5.6054D0,  6.5454D0,   54*0.D0,
C*   * 2*0.D0  ,  5.6014D0,  6.5337D0,  7.4712D0,  8.4067D0,
C*   *                       9.3471D0, 10.2856D0,              51*0.D0,
C*   * 2*0.D0  ,  6.5341D0,  7.4547D0,  8.3926D0,  9.3253D0,
C*   *                      10.2644D0, 11.2008D0,              51*0.D0,
C*   * 2*0.D0  ,  7.4722D0,  8.3932D0,  9.3243D0, 10.2524D0,
C*   *           11.1886D0, 12.1232D0, 13.0618D0, 13.9986D0,   49*0.D0,
C*   * 2*0.D0  ,  8.4091D0,  9.3274D0, 10.2538D0, 11.1747D0, 12.1093D0,
C*   *           13.0406D0, 13.9790D0, 14.9143D0, 15.8531D0,   48*0.D0,
C*   * 4*0.D0  , 11.1915D0, 12.1110D0, 13.0400D0, 13.9687D0, 14.9057D0,
C*   *           15.8394D0, 16.7761D0, 17.7104D0,              47*0.D0/
C*    DATA ((AMUS(I,L),I=1,59),L=8,14) /
C*   * 4*0.D0, 12.1282D0, 13.0446D0, 13.9709D0, 14.8948D0, 15.8302D0,
C*   *             16.7617D0, 17.6973D0, 18.6293D0, 19.5650D0, 46*0.D0,
C*   * 7*0.D0, 15.8325D0, 16.7629D0, 17.6920D0, 18.6429D0, 19.5564D0,
C*   *             20.4907D0, 21.4227D0, 22.3587D0,            44*0.D0,
C*   * 6*0.D0, 15.8464D0, 16.7668D0, 17.6947D0, 18.6174D0, 19.5502D0,
C*   *  20.4794D0, 21.4137D0, 22.3444D0, 23.2839D0, 24.2138D0, 43*0.D0,
C*   * 8*0.D0, 18.6308D0, 19.5532D0, 20.4817D0, 21.4088D0, 22.3414D0,
C*   *  23.2720D0, 24.2059D0, 25.1387D0, 26.0746D0, 27.0099D0,
C*   *  27.9469D0, 28.8820D0, 29.8173D0, 30.7546D0, 31.6913D0, 36*0.D0,
C*   * 7*0.D0, 18.6410D0, 19.5658D0, 20.4860D0, 21.4124D0, 22.3354D0,
C*   *  23.2676D0, 24.1961D0, 25.1292D0, 26.0602D0, 26.9961D0,
C*   *  27.9291D0, 28.8660D0, 29.7994D0, 30.7376D0,            38*0.D0,
C*   * 9*0.D0, 21.4241D0, 22.3488D0, 23.2714D0, 24.1996D0, 25.1261D0,
C*   *  26.0579D0, 26.9880D0, 27.9218D0, 28.8541D0, 29.7894D0,
C*   *  30.7233D0, 31.6599D0, 32.5944D0, 33.5316D0,            36*0.D0,
C*   * 9*0.D0, 22.3591D0, 23.2836D0, 24.2041D0, 25.1304D0, 26.0527D0,
C*   *  26.9838D0, 27.9128D0, 28.8457D0, 29.7761D0, 30.7111D0,
C*   *  31.6431D0, 32.5803D0, 33.5128D0, 34.4505D0, 35.3837D0, 35*0.D0/
C-----------------------------------------------------------------------

C  GEANT PARTICLES  INCLUDING RHO, K*, AND DELTA
      DO  IP = 1, 75
        PAMA  (IP) = MASSES(IP)
        SIGNUM(IP) = CHARGE(IP)
        DECTIM(IP) = DECTME(IP)
      ENDDO

C  RESET REST OF THE ARRAY
      DO  IP = 76, 6000
        PAMA  (IP) = 0.D0
        SIGNUM(IP) = 0.D0
      ENDDO

C  NOW FILL IN CHARMED PARTICLES AND OTHER EXOTICS
      DO  IP = 1, 99
        PAMA  (IP+100) = MASSES2(IP)
        SIGNUM(IP+100) = CHARGE2(IP)
        DECTIM(IP+100) = DECTME2(IP)
      ENDDO

C  LIGHTEST NUCLEUS IS DEUTERON (IA=2, IC=1)
      DO  IA = 2, 59
        DO  IC = 1, IA
          IN = IA - IC
          IP = IA * 100 + IC
C*        IF ( IC .LE. 14 ) THEN
C  MASSES FROM MASS TABLE FOR ISOTOPES
C*          IF ( IN .EQ. 0 ) THEN
C*            PAMA(IP) = IC * PAMA(14)
C*          ELSE
C*            PAMA(IP) = AMUS(IN,IC)
C*          ENDIF
C  SIMPLE SUM OF PROTON AND NEUTRON MASSES
C*          IF ( PAMA(IP) .EQ. 0.D0 )
C*   *                 PAMA(IP) = IC * PAMA(14) + IN * PAMA(13)
C*        ELSE
C  WEIZSAECKERS MASS FORMULA GIVES BINDING ENERGY IN MEV
C*          B1 = 14.1D0 * IA
C*          B2 = (-13.D0) * IA**TB3
C*          B3 = (-0.595D0) * IC**2 / IA**OB3
C*          B4 = (-19.D0) * (IC-IN)**2 / IA
C*          B5 = 33.5D0 / IA**0.75D0
C*          IF     ( MOD(IC,2) .EQ. 0  .AND.  MOD(IN,2) .EQ. 0 ) THEN
C*            SS =  1.D0
C*          ELSEIF ( MOD(IC,2) .EQ. 1  .AND.  MOD(IN,2) .EQ. 1 ) THEN
C*            SS = -1.D0
C*          ELSE
C*            SS =  0.D0
C*          ENDIF
C*          BIND = (B1 + B2 + B3 + B4 + SS*B5)* 1.D-3
C*          BIND = MAX( 0.D0, BIND )
C*          PAMA(IP) = IN * MASSES(13) + IC * MASSES(14) - BIND
C*        ENDIF

C  FILL IN MASSES AND REST MASSES OF NUCLEI
C  DO NOT USE BINDING ENERGY EFFECTS
          PAMA(IP)   = IN * MASSES(13) + IC * MASSES(14)
          RESTMS(IP) = PAMA(IP)

C  NUCLEI ARE ASSUMED TO BE FULLY IONIZED
          SIGNUM(IP) = +IC
        ENDDO
      ENDDO

C  MASSES OF MULTINEUTRON CLUSTERS (MINUMIM 2 NEUTRONS)
      DO  IN = 2, 59
        IP = 100 * IN
        PAMA  (IP) = IN * PAMA(13)
        RESTMS(IP) = PAMA(IP)
        SIGNUM(IP) = 0.D0
      ENDDO
C  REST MASS OF LIGHT NUCLEI (DEUTERIUM, TRITIUM, 3HE, ALPHA)
      RESTMS(201) =        RESTMS(13) +        RESTMS(14)
      RESTMS(301) = 2.D0 * RESTMS(13) +        RESTMS(14)
      RESTMS(302) =        RESTMS(13) + 2.D0 * RESTMS(14)
      RESTMS(402) = 2.D0 * RESTMS(13) + 2.D0 * RESTMS(14)
      RESTMS(45)  = RESTMS(201)
      RESTMS(46)  = RESTMS(301)
      RESTMS(47)  = RESTMS(402)

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE PI0DEC

C-----------------------------------------------------------------------
C  PI 0 DEC(AY)
C
C  DECAY OF PI0 INTO 2 GAMMAS OR INTO E(+) + E(-) + GAMMA
C  THIS SUBROUTINE IS CALLED FROM NUCINT.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRDECAYC/GAM345,COS345,PHI345
      DOUBLE PRECISION GAM345(3),COS345(3),PHI345(3)

      COMMON /CRGENER/ GEN,ALEVEL
      DOUBLE PRECISION GEN,ALEVEL

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION AUX1,AUX2,COSTH1,COSTH2,EPITO2,FI1
      INTEGER          I

      SAVE
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) (CURPAR(I),I=0,9)
  444 FORMAT(' PI0DEC: CURPAR=',1P,10E11.3)

C  LOOK FOR DECAY MODE
      CALL RMMARD( RD,3,1 )

C  DECAY    PI(0)  ---->  GAMMA + GAMMA
      IF ( RD(3) .LT. 0.98798D0 ) THEN
C  HALF OF TOTAL ENERGY OF THE PION = EPITO2
        EPITO2 = 0.5D0 * GAMMA * PAMA(7)
        AUX1   = 1.D0 + BETA * RD(1)
        AUX2   = 1.D0 - BETA * RD(1)
        COSTH1 = (BETA + RD(1)) / AUX1
        COSTH2 = (BETA - RD(1)) / AUX2

C  FIRST GAMMA  (WITH HIGHER ENERGY)
        FI1  = PI2 * RD(2)
C  ENERGY OF GAMMA
        SECPAR(1) = AUX1 * EPITO2
        CALL ADDANG3( COSTHE,PHIX,PHIY, COSTH1,FI1,
     *                          SECPAR(2),SECPAR(3),SECPAR(4) )

        IF ( SECPAR(2) .GT. C(29) ) THEN

          SECPAR(0) = 1.D0

          CALL TSTACK
        ELSE
          IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

            DLONG(LHEIGH,11) = DLONG(LHEIGH,11) + SECPAR(1)

          ENDIF
        ENDIF

C  SECOND GAMMA   (WITH LOWER ENERGY)
C  ENERGY OF GAMMA
        SECPAR(1) = AUX2 * EPITO2
        CALL ADDANG3( COSTHE,PHIX,PHIY, COSTH2,FI1+PI,
     *                             SECPAR(2),SECPAR(3),SECPAR(4) )

        IF ( SECPAR(2) .GT. C(29) ) THEN

          SECPAR(0) = 1.D0

          CALL TSTACK
        ELSE
          IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

            DLONG(LHEIGH,11) = DLONG(LHEIGH,11) + SECPAR(1)

          ENDIF
        ENDIF

C  DECAY    PI(0)  ---->  E(-) + E(+) + GAMMA      (DALITZ DECAY)
C  (UNIFORM PHASE SPACE DISTRIBUTION IS ASSUMED FOR THIS DECAY)
      ELSE
        CALL DECAY6( PAMA(7), PAMA(2), PAMA(2), 0.D0,
     *                0.D0,0.D0,0.D0, 1.D0, 2 )
        DO  I = 1, 3
          CALL ADDANG3( COSTHE,PHIX,PHIY, COS345(I),PHI345(I),
     *                                SECPAR(2),SECPAR(3),SECPAR(4) )

          IF ( SECPAR(2) .GT. C(29) ) THEN

            SECPAR(0) = DBLE(4 - I)
            SECPAR(1) = GAM345(I)
            CALL TSTACK
          ELSE
            IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT
              IF     ( I .EQ. 1 ) THEN
                DLONG(LHEIGH,13) = DLONG(LHEIGH,13)
     *                             +(GAM345(I)-1.D0)*PAMA(2)
              ELSEIF ( I .EQ. 2 ) THEN
                DLONG(LHEIGH,13) = DLONG(LHEIGH,13)
     *                             +(GAM345(I)+1.D0)*PAMA(2)
              ELSE
                DLONG(LHEIGH,11) = DLONG(LHEIGH,11) + GAM345(I)

              ENDIF
            ENDIF
          ENDIF
       ENDDO
      ENDIF

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   26/06/2003
C=======================================================================

      DOUBLE PRECISION FUNCTION PPCE( R1 )

C-----------------------------------------------------------------------
C  P(AIR) P(RODUCTION) C(ROSS SECTION FOR GAUSS INTEGR.) E(NERGY LOSS)
C
C  FUNCTION TO BE CALLED BY DGQUAD FOR CALCULATION OF MUON
C  PAIR PRODUCTION ENERGY LOSS.
C  PARAMETERS TO BE GIVEN BY COMMON:
C   EE     =  ENERGY OF INCOMING MUON
C   VFRAC  =  (E+ + E-)/EE FRACTION OF MUON ENERGY TRANSMITTED TO PAIR
C   ZATOM  =  ATOMIC NUMBER OF TARGET ATOM
C  THIS FUNCTION IS CALLED FROM DGQUAD (BY DKOKOE)
C  ARGUMENT:
C   R1     = ASYMMETRY ENERGY ELECTRON-POSITRON: (E+ - E-)/(E+ + E-)
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

       

       

       

       

      DOUBLE PRECISION R
      PARAMETER        (R = 189.D0)

      DOUBLE PRECISION R1
      DOUBLE PRECISION ALE,ALE2,ALM,AUXIL,AUXIL2,BETA1,CSI,
     *                 DOWNLE,DOWNLM,DOWNYE,DOWNYM,
     *                 FIE,FIM,QFIE,QFIM,
     *                 RO2,UPPLE,UPPLM,UPPYE,UPPYM,YE,YM
      SAVE
C-----------------------------------------------------------------------

      RO2    = R1**2
      AUXIL2 = R / ZATOM**OB3
      BETA1  = 0.5D0 * VFRAC**2 / (1.D0 - VFRAC)
      CSI    =  (1.D0-RO2)  * (0.5D0*VFRAC / EBYMU)**2 / (1.D0-VFRAC)
      UPPYE  = 5.D0 - RO2 + 4.D0 * BETA1 * (1.D0+RO2)
      DOWNYE = 2.D0 * (1.D0 + 3.D0 * BETA1) * LOG(3.D0+1.D0/CSI)
     *                - RO2 - 2.D0 * BETA1 * (2.D0-RO2)
      YE     = UPPYE/DOWNYE
      UPPYM  = 4.D0 + RO2 + 3.D0 * BETA1 * (1.D0+RO2)
      DOWNYM = (1.D0+RO2) * (1.5D0 + 2.D0*BETA1) * LOG(3.D0+CSI)
     *                                       + 1.D0 - 1.5D0 * RO2
      YM     = UPPYM/DOWNYM
      AUXIL  = 1.D0 / ( EE*VFRAC*(1.D0-RO2))
      UPPLE  = SQRT( (1.D0+CSI)*(1.D0+YE) ) * AUXIL2
      DOWNLE = 1.D0 + ( 2.D0 * PAMA(2) * SE * (1.D0+CSI) * (1.D0+YE)
     *                                   * AUXIL2 ) * AUXIL
      ALE2   = 1.D0 + ( (1.5D0 * EBYMU * ZATOM**OB3)**2 ) * (1.D0+CSI)
     *                                                    * (1.D0+YE)
      ALE    = LOG(UPPLE/DOWNLE) - 0.5D0 * LOG(ALE2)
      UPPLM  = (TB3 / EBYMU) * R / ZATOM**TB3
      DOWNLM = 1.D0 + ( 2.D0 * PAMA(2) * SE * (1.D0+CSI) * (1.D0+YM)
     *                                   * AUXIL2 ) * AUXIL
      ALM    = LOG(UPPLM/DOWNLM)
      QFIE   = (2.D0+RO2) * (1.D0+BETA1) + CSI * (3.D0+RO2)
      FIE    = ( QFIE * LOG(1.D0+1.D0/CSI)
     *           + (1.D0-RO2-BETA1)/(1.D0+CSI) - (3.D0+RO2) ) * ALE
      QFIM   =  (1.D0 + 1.5D0*BETA1) * (1.D0+RO2)
     *         - (1.D0 + 2.D0*BETA1) * (1.D0-RO2) / CSI
      FIM    = ( QFIM*LOG(1.D0+CSI) + CSI*(1.D0-RO2-BETA1)/(1.D0+CSI)
     *           + (1.D0 + 2.D0*BETA1) * (1.D0-RO2) ) * ALM
C  NORMALIZATION IS MADE IN DPRELM AND IN DKOKOE
      PPCE   = ( FIE + FIM * EBYMU**2 ) * (1.D0-VFRAC)

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   22/05/2003
C=======================================================================

      DOUBLE PRECISION FUNCTION PPCS( R1 )

C-----------------------------------------------------------------------
C  P(AIR) P(RODUCTION) C(ROSS) S(ECTION FOR GAUSS INTEGRATION)
C
C  FUNCTION TO BE CALLED BY DGQUAD FOR CALCULATION OF MUON
C  PAIR PRODUCTION CROSS-SECTIONS.
C  PARAMETERS TO BE GIVEN BY COMMON:
C   EE     =  ENERGY OF INCOMING MUON
C   VFRAC  =  (E+ + E-)/EE FRACTION OF MUON ENERGY TRANSMITTED TO PAIR
C   ZATOM  =  ATOMIC NUMBER OF TARGET ATOM
C  THIS FUNCTION IS CALLED FROM DGQUAD (BY MUPRPR, DKOKOS, DKOKOS)
C  AND MUPRPR.
C  ARGUMENT:
C   R1     = ASYMMETRY ENERGY ELECTRON-POSITRON: (E+ - E-)/(E+ + E-)
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

       

       

       

       

      DOUBLE PRECISION R
      PARAMETER        (R = 189.D0)

      DOUBLE PRECISION R1
      DOUBLE PRECISION ALE,ALE2,ALM,AUXIL,AUXIL2,BETA1,CSI,
     *                 DOWNLE,DOWNLM,DOWNYE,DOWNYM,
     *                 FIE,FIM,QFIE,QFIM,
     *                 RO2,UPPLE,UPPLM,UPPYE,UPPYM,YE,YM
      SAVE
C-----------------------------------------------------------------------

      RO2    = R1**2
      AUXIL2 = R / ZATOM**OB3
      BETA1  = 0.5D0 * VFRAC**2 / (1.D0 - VFRAC)
      CSI    =  (1.D0-RO2)  * (0.5D0*VFRAC / EBYMU)**2 / (1.D0-VFRAC)
      UPPYE  = 5.D0 - RO2 + 4.D0 * BETA1 * (1.D0+RO2)
      DOWNYE = 2.D0 * (1.D0 + 3.D0 * BETA1) * LOG(3.D0+1.D0/CSI)
     *                - RO2 - 2.D0 * BETA1 * (2.D0-RO2)
      YE     = UPPYE/DOWNYE
      UPPYM  = 4.D0 + RO2 + 3.D0 * BETA1 * (1.D0+RO2)
      DOWNYM = (1.D0+RO2) * (1.5D0 + 2.D0*BETA1) * LOG(3.D0+CSI)
     *                                       + 1.D0 - 1.5D0 * RO2
      YM     = UPPYM/DOWNYM
      AUXIL  = 1.D0 / ( EE*VFRAC*(1.D0-RO2))
      UPPLE  = SQRT( (1.D0+CSI)*(1.D0+YE) ) * AUXIL2
      DOWNLE = 1.D0 + ( 2.D0 * PAMA(2) * SE * (1.D0+CSI) * (1.D0+YE)
     *                                   * AUXIL2 ) * AUXIL
      ALE2   = 1.D0 + ( (1.5D0 * EBYMU * ZATOM**OB3)**2 ) * (1.D0+CSI)
     *                                                    * (1.D0+YE)
      ALE    = LOG(UPPLE/DOWNLE) - 0.5D0 * LOG(ALE2)
      UPPLM  = (TB3 / EBYMU) * R / ZATOM**TB3
      DOWNLM = 1.D0 + ( 2.D0 * PAMA(2) * SE * (1.D0+CSI) * (1.D0+YM)
     *                                   * AUXIL2 ) * AUXIL
      ALM    = LOG(UPPLM/DOWNLM)
      QFIE   = (2.D0+RO2) * (1.D0+BETA1) + CSI * (3.D0+RO2)
      FIE    = ( QFIE * LOG(1.D0+1.D0/CSI)
     *           + (1.D0-RO2-BETA1)/(1.D0+CSI) - (3.D0+RO2) ) * ALE
      QFIM   =  (1.D0 + 1.5D0*BETA1) * (1.D0+RO2)
     *         - (1.D0 + 2.D0*BETA1) * (1.D0-RO2) / CSI
      FIM    = ( QFIM*LOG(1.D0+CSI) + CSI*(1.D0-RO2-BETA1)/(1.D0+CSI)
     *           + (1.D0 + 2.D0*BETA1) * (1.D0-RO2) ) * ALM
C  NORMALIZATION IS MADE IN DPRSGM AND IN DKOKOI
      PPCS   = ( FIE + FIM * EBYMU**2 ) * (1.D0-VFRAC)/VFRAC

      RETURN
      END

*-- Author :    F. SCHROEDER UNI WUPPERTAL      17/09/1998
C=======================================================================

      SUBROUTINE PRANGC( ARG,FLAGMU,HNEW )

C-----------------------------------------------------------------------
C  (DECAYING) P(ARTICLE''S) RANG(E IN A) C(URVED ATMOSPHERE)
C
C  DETERMINES MEAN FREE PATH FOR DECAYING PARTICLES IN CURVED
C  ATMOSPHERE INCLUDING IONIZATION ENERGY LOSS PRECISELY.
C  CALCULATE TOTAL PATH LENGTH FOR MUONS.
C  THIS SUBROUTINE IS CALLED FROM BOX2.
C  ARGUMENTS:
C   ARG    = -LOG(RANDOM NUMBER) * SPEED OF LIGHT * LIFETIME
C   FLAGMU = MUON FLAG (T FOR MUONS, F ELSE)
C   HNEW   = HEIGHT AFTER TOTAL STEP LENGTH
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRAIR/   COMPOS,PROBTA,AVERAW,AVOGDR
      DOUBLE PRECISION COMPOS(3),PROBTA(3),AVERAW,AVOGDR

      COMMON /CRATMOS/ AATM,AATM0,BATM,BATM0,CATM,CATM0,DATM,MODATM
      DOUBLE PRECISION AATM(5),AATM0(5,0:22),BATM(5),BATM0(5,0:22),
     *                 CATM(5),CATM0(5,0:22),DATM(5)
      INTEGER          MODATM

      COMMON /CRATMOS2/HLAY,HLAY0,THICKL,LAYNO,LAYNEW
      DOUBLE PRECISION HLAY(6),HLAY0(5,0:9),THICKL(5)
      INTEGER          LAYNO(0:22)
      LOGICAL          LAYNEW

C  EXTERNAL ATMOSPHERIC MODELS
      COMMON /CRATMOSX/IATMOX,FREFRX
      INTEGER          IATMOX
      LOGICAL          FREFRX

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRMUMULT/CHC,OMC,PHISCT,STEPL,VSCAT,FMOLI
      DOUBLE PRECISION CHC,OMC,PHISCT,STEPL,VSCAT
      LOGICAL          FMOLI

      COMMON /CROBSPAR/OBSLEV,THCKOB,XOFF,YOFF,HEIGHP,THETAP,PHIP,
     *                 THETPR,PHIPR,

     *                 VUECON,

     *                 NOBSLV
      DOUBLE PRECISION OBSLEV(20),THCKOB(20),XOFF(20),YOFF(20),
     *                 HEIGHP,THETAP,THETPR(2),PHIP,PHIPR(2)

      DOUBLE PRECISION VUECON(2)

      INTEGER          NOBSLV

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION ACOSTNEW,AK,ARG,ARG0,ARGNEW,AUXIL,AUX2,BETANEW,
     *                 BK,CHIT,CHIT2,COSDIF,COSPHI,COSTAPNEW,COSTHENEW,
     *                 DK,DL,ELOSS,ELOS2,GAMK,GAMNEW,
     *                 GAMSQ,GAM0,GMSQM1,HNEW,HOLD,H0,RADIUS,
     *                 SINPHI,SINTHE,SINTHENEW,
     *                 TH0,THNEW,THOLD,TRANS,TRANSNEW,XNEW,YNEW
      INTEGER          ILAY
      LOGICAL          FLAGMU

      DOUBLE PRECISION CDEDXM,HEIGH,THICK
      SAVE
      EXTERNAL         CDEDXM,HEIGH,THICK
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) ARG,THICKH
  444 FORMAT(' PRANGC: -LOG(RD)*C*TAU = ',1P,E10.3,' THICKH=',E10.3)

C  START VALUES
      CHI  = 0.D0
      HNEW = H
      GAM0 = GAMMA
      TH0  = THICKH
      XNEW = X
      YNEW = Y
      BETANEW   = BETA
      COSTHENEW = COSTHE
      COSTAPNEW = COSTAP
      STEPL  = 0.D0
      SINTHE = SQRT( (1.D0 - COSTHE) * (1.D0 + COSTHE) )
      IF ( SINTHE .NE. 0.D0 ) THEN
        COSPHI = PHIX / SINTHE
        SINPHI = PHIY / SINTHE
      ELSE
        COSPHI = 0.D0
        SINPHI = 0.D0
      ENDIF

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  LOOP OVER PIECES OF ARG (EACH IN ITS LOCAL FLAT COORDINATE FRAME)
  1   CONTINUE
C  STORE OLD VALUE OF THICKNESS
      THOLD     = TH0
      SINTHENEW = SQRT( MAX( 0.D0, (1.D0-COSTHENEW)*(1.D0+COSTHENEW) ) )
C  CALCULATE UPPER LIMIT FOR TRANSVERSAL LENGTH (IMPORTANT TO DO A CUT,
C  'UPPER LIMIT' BECAUSE GAM0 BECOMES SMALLER DUE TO IONISATION LOSS)
      AUXIL     = GAM0 * BETANEW * SINTHENEW
      TRANS     = ARG * AUXIL
C  MAXIMAL HORIZONTAL STEP (DEPENDS ON THICKNESS AT PARTICLE ALTITUDE)
CDH 17.06.2002
      TRANSNEW  = MIN( TRANS, MAX( (C(4) * THOLD + C(3)), C(2) ) )
C
      IF ( SINTHENEW .EQ. 0.D0 ) THEN
C  STEP IN VERTICAL DIRECTION
        ARGNEW = ARG
      ELSE
        ARGNEW = TRANSNEW / AUXIL
      ENDIF
      IF ( DEBUG ) WRITE(MDEBUG,*) 'PRANGC: TH0,ARGNEW,TRANSNEW=',
     *                     SNGL(TH0),SNGL(ARGNEW),SNGL(TRANSNEW)
C  SET START VALUES FOR ITERATION OVER THE AIR LAYERS
      ARG0     = ARGNEW
      CHIT     = 0.D0
      H0       = HNEW
      ACOSTNEW = ABS( COSTHENEW )

C  LOOK WITHIN WHICH LAYER THE PARTICLE STARTS
       IF     ( HNEW .LE. HLAY(2) ) THEN
         ILAY = 1
       ELSEIF ( HNEW .LE. HLAY(3) ) THEN
         ILAY = 2
       ELSEIF ( HNEW .LE. HLAY(4) ) THEN
         ILAY = 3
       ELSE
         ILAY = 4
         TH0  = MAX( TH0, THICKL(5) )
       ENDIF

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
  2    CONTINUE
       GAM0   = MAX( GAM0, 1.0001D0 )
       GAMSQ  = GAM0**2
       GMSQM1 = GAMSQ - 1.D0
C  ENERGY LOSS BY IONIZATION
       ELOSS  = SIGNUM(ITYPE)**2 * C(22) * ( GAMSQ * (LOG(GMSQM1)
     *              - 0.5D0 * LOG(GAM0 * C(16) + C(15))
     *              + C(23)) / GMSQM1 - 1.D0 )
       IF ( ITYPE .EQ. 5  .OR.  ITYPE .EQ. 6 ) THEN
C  ADD ENERGY LOSS OF SUBTHRESHOLD BEMSSTRAHLUNG AND PAIRPRODUCTION
         AUX2  = CDEDXM( PAMA(5)*GAM0 )
         IF ( DEBUG ) WRITE(MDEBUG,*)
     *                            'PRANGC: ELOSS,DEDXM=',ELOSS,AUX2
         ELOSS = ELOSS + AUX2
       ENDIF
       ELOS2 = ELOSS / ( PAMA(ITYPE) * ACOSTNEW )
       BK    = ELOS2 * (TH0 - AATM(ILAY))
       DK    = GAM0 + BK
       AK    = ARG0 * DK * ACOSTNEW * DATM(ILAY)

       IF ( AK .GT. 0.D0 ) THEN
C  LIMIT FOR EXPONENT
         IF ( AK .LT. 174.D0 ) THEN
C  SEE FZKA 6019, EQ. 4.6
           GAMNEW = MAX( GAM0*DK / (GAM0 + EXP(AK)*BK), 1.0001D0 )
         ELSE
           GAMNEW = 1.0001D0
         ENDIF
         GAMK   = GAM0 - ELOS2 * (THICKL(ILAY) - TH0)

       ELSE
         GAMK   = 1.D0
         GAMNEW = 1.0001D0
       ENDIF
       IF ( DEBUG ) WRITE(MDEBUG,*) 'PRANGC: GAMNEW,GAMK=',
     *                           SNGL(GAMNEW),SNGL(GAMK)
C  LOOK WHETHER PARTICLE PENETRATES LAYER BOUNDARY OR DECAYS BEFORE
C  HORIZONTAL PARTICLES SHOULD NOT PENETRATE ANY LAYER
       IF ( GAMNEW .LT. GAMK ) THEN
         IF ( ILAY .GT. 1 ) THEN

C  CALCULATE PORTION OF RANGE AND NEW START VALUES AT LAYER BOUNDARY
           ARG0  = ARG0 -( H0 - HLAY(ILAY) + CATM(ILAY)*LOG(GAM0/GAMK) )
     *                       / ( DK * COSTHENEW )
           CHIT  = CHIT + (THICKL(ILAY) - TH0) / COSTHENEW
           IF ( FLAGMU ) STEPL = STEPL + (H0 - HLAY(ILAY)) / COSTHENEW
           GAM0  = GAMK
           H0    = HLAY(ILAY)
           TH0   = THICKL(ILAY)
           ILAY  = ILAY - 1
           GOTO 2
         ENDIF
       ENDIF

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  PENETRATED MATTER THICKNESS
       CHIT2 = (GAM0 - GAMNEW) / (ELOS2 * ACOSTNEW)
       CHIT  = CHIT + CHIT2

       IF ( IATMOX .GT. 0 ) THEN
         IF ( TH0 + CHIT*COSTHENEW .GT. THICKL(1) ) THEN
           CHI  = CHI + (THICKL(1) - TH0)/COSTHENEW
           HNEW = HLAY(1)
           IF ( FLAGMU ) STEPL = STEPL + (H0 - HLAY(1))/COSTHENEW
           IF ( DEBUG ) WRITE(MDEBUG,*) 'PRANGC: CHI = ',SNGL(CHI)
           GOTO 100
         ENDIF
       ENDIF

       IF ( FLAGMU ) THEN
         STEPL = STEPL + ( H0 - HEIGH( MAX(0.D0,TH0+COSTHENEW*CHIT2) ) )
     *                                              / COSTHENEW
       ENDIF
C  ACTUAL VALUES
      CHI     = CHI + CHIT
      ARG     = ARG - ARGNEW
C  ACTUAL VALUE OF GAM0 IS CALCULATED IN THE LOOP ABOVE
      GAM0    = GAMNEW
      IF ( DEBUG ) WRITE(MDEBUG,11) CHI,CHIT,ARG
 11   FORMAT(' PRANGC: CHI,CHIT,ARG=',1P,3(E10.3, 1X),0P)
C  LOOP UNTIL THE COMPLETE PARTICLE TRACK LENGTHS IS TRANSFORMED IN CHI
      BETANEW = SQRT( (GAMNEW-1.D0)*(GAMNEW+1.D0) ) / GAMNEW

C  CALCULATE REAL TRANSNEW AND REAL GEOMETRIC LENGTH DL WHICH CROSSED
C  THE PARTICLE WITH GIVEN ARGNEW.  (GAMMA (= GAM0) HAS CHANGED DUE TO
C  IONIZATION LOSS). BECAUSE OF CUT ON TRANS AND ON ARG, IT IS POSSIBLE
C  TO CALCULATE WITHIN A FLAT ATMOSPHERE
      THNEW = MAX ( 0.D0, THOLD + COSTHENEW * CHIT )
      HOLD  = HNEW
C  NEW HEIGHT IN OLD COORDINATE FRAME
      HNEW  = HEIGH( THNEW )
      DL    = ( HOLD - HNEW ) / COSTHENEW

C  HORIZONTAL STEP LENGTH
      TRANSNEW = DL * SINTHENEW
C  NEW COORDINATE FRAME FOR NEXT STEP IN TRANSNEW
C  NEW ACTUAL HEIGHT AT NEW THICKNESS GRADIENT
C  (CALCULATED WITH PARAMETERS OF OLD COORDINATE FRAME)
      HNEW = SQRT( TRANSNEW**2 + (C(1)+HNEW)**2 ) - C(1)
C  TERMINATE PROCESS IF WELL BELOW OBSERVATION LEVEL
      IF ( HNEW .LT. OBSLEV(1) - 1.D7 ) THEN
CDH 21.02.2002
*     IF ( HNEW .LT. MIN( OBSLEV(1) - 1.D5,
*    *              OBSLEV(1)-2.D0*C(2)*COSTHENEW/SINTHENEW ) ) THEN
        IF ( DEBUG ) WRITE(MDEBUG,*) 'PRANGC: HNEW,CHI,ARG,STEPL=',
     *                    SNGL(HNEW),SNGL(CHI),SNGL(ARG),SNGL(STEPL)
        GOTO 100

      ENDIF
C  TERMINATE PROCESS IF PARTICLE IS STOPPED
      IF ( GAM0 .LE. 1.0001D0 ) THEN
        IF ( DEBUG ) WRITE(MDEBUG,*) 'PRANGC: HNEW,GAM0,CHI,ARG,STEPL=',
     *          SNGL(HNEW),SNGL(GAM0),SNGL(CHI),SNGL(ARG),SNGL(STEPL)
        GOTO 100
      ENDIF
C  DIF IS ANGLE AT CENTER OF EARTH, USE COSINE RULE FOR DETERMINATION
      COSDIF = ( (C(1)+HNEW)**2 + (C(1)+HOLD)**2 - DL**2 ) /
     *                            ( 2.D0 * (C(1)+HNEW) * (C(1)+HOLD) )
      IF ( DEBUG ) WRITE(MDEBUG,*) 'PRANGC: HNEW,COSDIF=',
     *                           SNGL(HNEW),SNGL(COSDIF)
      COSDIF = MIN( 1.D0, COSDIF )
C  DIRECTION OF PARTICLE RELATIVE TO DETECTOR CENTER
      IF ( COSDIF .LT. 1.D0 ) THEN
        RADIUS = DL * SQRT( (1.D0-COSTAPNEW)*(1.D0+COSTAPNEW)
     *                         /( (1.D0-COSDIF)*(1.D0+COSDIF) ) )
     *              * C(1) * ACOS( COSDIF )/(C(1)+HNEW)
      ELSE
        RADIUS = DL * SQRT( (1.D0-COSTAPNEW)*(1.D0+COSTAPNEW) )
      ENDIF
      XNEW   = XNEW + RADIUS * COSPHI
      YNEW   = YNEW + RADIUS * SINPHI
C  COSINE OF ZENITH ANGLE IN THE NEW FRAME
      COSTHENEW = MIN( 1.D0, ( COSTHENEW * COSDIF
     *             - SQRT( (1.D0-COSTHENEW)*(1.D0+COSTHENEW) *
     *                              (1.D0-COSDIF)*(1.D0+COSDIF) ) ) )
      IF ( DEBUG ) WRITE(MDEBUG,*) 'PRANGC: COSTHENEW =',COSTHENEW
C  TERMINATE PROCESS IF PARTICLE MOVES OUT OF ANGULAR RANGE (UPWARD?)
      IF ( COSTHENEW .LE. C(29) ) GOTO 100
      TH0 = THICK( HNEW )
C  NEXT STEP IF ARG NOT COMPLETELY TRANSFORMAED IN CHI
      IF ( ARG .GT. 0.D0 ) GOTO 1

 100  CONTINUE
      IF ( DEBUG ) THEN
        IF ( FLAGMU ) THEN
          WRITE(MDEBUG,*) 'PRANGC: HNEW,STEPL=',SNGL(HNEW),SNGL(STEPL)
        ELSE
          WRITE(MDEBUG,*) 'PRANGC: HNEW=',SNGL(HNEW)
        ENDIF
      ENDIF

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE       26/06/1995
C=======================================================================

      SUBROUTINE PRTIME( TTIME )

C-----------------------------------------------------------------------
C  PR(INT) TIME
C
C  PRINTS PRESENT DATE AND TIME AND GIVES IT IN A FORMAT SUITED FOR THE
C  RUNHEADER AND EVENTHEADER.
C  THIS SUBROUTINE IS CALLED FROM AAMAIN AND START.
C  ARGUMENT:
C   TTIME  = TIME (YYMMDD)
C
C  IF OUR DATE ROUTINE DOES NOT FIT TO YOUR COMPUTER, PLEASE REPLACE
C  IT BY A SUITABLE ROUTINE OF YOUR SYSTEM
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION TTIME
      CHARACTER*8      YYYYMMDD
      CHARACTER*10     HHMMSS

      INTEGER          IYEAR,MONTH,IDAY,IHOUR,IMINU,ISEC
      SAVE
C-----------------------------------------------------------------------

C  FOR COMPILERS WITH NEWER DATE FUNCTIONS, INCLUDING DEC UNIX f77
C  AND RECENT GNU g77 >0.5.21 (egcs 1.1.x, gcc 2.95, ...)
C  IF YOR COMPUTER DOES NOT KNOW SUBROUT. DATE_AND_TIME
C  REPLACE THIS CALL BY A CALL TO YOUR SYSTEM ROUTINES TO
C  FILL THE INTEGERS: IYEAR, MONTH, IDAY, IHOUR, IMINU, ISEC
      CALL DATE_AND_TIME( YYYYMMDD, HHMMSS )
      READ(YYYYMMDD,'(I4,2I2)') IYEAR,MONTH,IDAY
      READ(HHMMSS,'(3I2)') IHOUR,IMINU,ISEC
      WRITE(MONIOU,100) IDAY,MONTH,IYEAR,IHOUR,IMINU,ISEC
      TTIME = MOD(IYEAR,100)*10000 + MONTH*100 + IDAY
 100  FORMAT(' PRESENT TIME : ',I2.2,'.',I2.2,'.',I4,I4.2,':',I2.2,
     *       ':',I2.2)

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      DOUBLE PRECISION FUNCTION PTRANS()

C-----------------------------------------------------------------------
C  TRANS(VERSE MOMENTUM)
C
C  RANDOM SELECTION OF TRANSVERSE MOMENTUM
C  DISTRIBUTION IS OF FORM X*EXP(-X)
C  THIS FUNCTION IS CALLED FROM PIGEN1, PIGEN2.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION GX(0:50),HX(0:50),DX,SUMI,TT,X,XX,ZZ
      INTEGER          I,IMAX
      LOGICAL          FIRST
      SAVE
C  DX IS STEPSIZE FOR APPROXIMATING CURVE
      DATA             FIRST / .TRUE. /, DX / 0.5D0 /
C-----------------------------------------------------------------------

C     IF ( DEBUG ) WRITE(MDEBUG,*) 'PTRANS:'

C  COMPUTE FUNCTION VALUES AND INTEGRAL OF STEP FUNCTION H(X)
C  APPROXIMATING Y(X) = X * EXP(1-X) WITH H(X) > Y(X)
      IF ( FIRST ) THEN
        FIRST = .FALSE.
        IMAX  = C(34) / DX
        GX(0) = 0.D0
        HX(0) = DX*EXP(1.D0-DX)
        DO  I = 1, IMAX
          X     = I*DX
          IF ( X .LT. 1.D0 ) X = X + DX
          HX(I) = X*EXP(1.D0-X)
          GX(I) = GX(I-1) + HX(I-1)
        ENDDO
        SUMI = 1.D0 / GX(IMAX)
        DO  I = 1, IMAX
          GX(I) = GX(I) * SUMI
        ENDDO
      ENDIF

C-----------------------------------------------------------------------
C  GET RANDOM VARIABLE DISTRIBUTED AS HX(X)
   11 CONTINUE
      CALL RMMARD( RD,2,1 )
      I  = 0
    1 CONTINUE
      I  = I+1
      IF ( GX(I) .LT. RD(1) ) GOTO 1
      XX = ( (RD(1)-GX(I-1))/(GX(I)-GX(I-1)) + I-1 ) * DX
      ZZ = HX(I-1)
C  GET RANDOM VARIABLE DISTRIBUTED AS Y(X) BY REJECTION METHOD
      TT = XX * EXP(1.D0-XX)
      IF ( RD(2)*ZZ .GT. TT ) GOTO 11

C  GET REQUIRED PEAK VALUE
      PTRANS = XX * C(12)
      IF ( DEBUG ) WRITE(MDEBUG,*) 'PTRANS: PT = ',SNGL(PTRANS)

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      DOUBLE PRECISION FUNCTION RANNOR( A,B )

C-----------------------------------------------------------------------
C  RAN(DOM NUMBER) NOR(MALLY DISTRIBUTED)
C
C  GENERATES NORMAL DISTRIBUTED RANDOM NUMBER
C  DELIVERS 2 UNCORRELATED RANDOM NUMBERS,
C  THEREFORE RANDOM CALLS ARE ONLY NECESSARY EVERY SECOND TIME.
C  REFERENCE : NUMERICAL RECIPES, W.H. PRESS ET AL.,
C              CAMBRIDGE UNIVERSITY PRESS, 1992  ISBN 0 521 43064 X
C  THIS FUNCTION IS CALLED FROM HDPM, LEADDF, PARRAP, QGSTOR,
C  UPDATE, AND VAPOR.
C  ARGUMENTS:
C   A      = MEAN VALUE
C   B      = STANDARD DEVIATION
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION A,B,RR
      SAVE
C-----------------------------------------------------------------------

CC    IF ( DEBUG ) WRITE(MDEBUG,100) SNGL(A),SNGL(B)
CC100 FORMAT(' RANNOR: A,B=',1P,2E10.3)
      IF ( KNOR ) THEN
  1     CONTINUE
        CALL RMMARD( RD,2,1 )
        U1 = 2.D0*RD(1) - 1.D0
        U2 = 2.D0*RD(2) - 1.D0
        RR = U1**2 + U2**2
        IF ( RR .GE. 1.D0  .OR.  RR .EQ. 0.D0 ) GOTO 1
        FAC = SQRT( (-2.D0) * LOG(RR) / RR )

        RANNOR = FAC * U1 * B + A
        KNOR   = .FALSE.
      ELSE
        RANNOR = FAC * U2 * B + A
        KNOR   = .TRUE.
      ENDIF
CC    IF ( DEBUG ) WRITE(MDEBUG,101) RANNOR
CC101 FORMAT('+',34X,' RANNOR =',1P,E12.5)

      RETURN
      END

*-- Author :    Konrad Bernloehr, Uni Hamburg   30/08/1999
C=======================================================================

      SUBROUTINE RCLCHK( MUNIT,NLREC,IERR )

C-----------------------------------------------------------------------
C  R(E)C(ORD)L(ENGTH PARAMETER) CH(EC)K
C
C  CHECK IF THE RECL PARAMETER FOR OPENING UNFORMATTED DIRECT-ACCESS
C  FILES IS INTERPRETED AS IT SHOULD.
C  THIS SUBROUTINE IS CALLED FROM FILOPN.
C  ARGUMENTS:
C   MUNIT  = UNIT NUMBER FOR TEMPORARY FILE
C   NLREC  = 1  FOR RECL IN BYTES, 4 FOR RECL IN 4-BYTE WORDS
C   IERR   = ERROR INDICATOR
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      INTEGER          IERR,MUNIT,NLREC
      INTEGER          IDAT(5)
      SAVE
C-----------------------------------------------------------------------

      IERR = 0

      OPEN(UNIT=MUNIT,STATUS='SCRATCH',
     *     FORM='UNFORMATTED',ACCESS='DIRECT',RECL=16/NLREC)
C     IF NLREC=4 BUT RECL COUNTED IN BYTES, THE '990' STATEMENT
C     WILL TYPICALLY BE JUMPED TO, AS A RESULT OF A WRITE ERROR.
      WRITE(MUNIT,REC=1,ERR=990) 1,2,3,4
      WRITE(MUNIT,REC=3,ERR=990) 9,10,11,12
      WRITE(MUNIT,REC=2,ERR=990) 5,6,7,8
C     IF NLREC=4 BUT RECL IS COUNTED IN BYTES AND NO WRITE
C     ERROR WAS REPORTED, RECORDS SHOULD HAVE OVERLAPED AND
C     THE DATA IS CORRUPTED.
      READ(MUNIT,REC=1) IDAT(1),IDAT(2),IDAT(3),IDAT(4)
      IF ( IDAT(1) .NE.  1  .OR.  IDAT(2) .NE.  2  .OR.
     *     IDAT(3) .NE.  3  .OR.  IDAT(4) .NE.  4 ) IERR = 1
      READ(MUNIT,REC=2) IDAT(1),IDAT(2),IDAT(3),IDAT(4)
      IF ( IDAT(1) .NE.  5  .OR.  IDAT(2) .NE.  6  .OR.
     *     IDAT(3) .NE.  7  .OR.  IDAT(4) .NE.  8 ) IERR = IERR + 2
      READ(MUNIT,REC=3) IDAT(1),IDAT(2),IDAT(3),IDAT(4)
      IF ( IDAT(1) .NE.  9  .OR.  IDAT(2) .NE. 10  .OR.
     *     IDAT(3) .NE. 11  .OR.  IDAT(4) .NE. 12 ) IERR = IERR + 4

C     IF NLREC=1 BUT RECL COUNTED IN WORDS IS USUALLY NOT CAUGHT BY
C     THIS ROUTINE, BUT SHOULD BE RATHER HARMLESS. THE ONLY BAD
C     EFFECT EXPECTED IS THAT THE EXTERNAL STACK FILE WILL BE FOUR
C     TIMES AS LARGE AS NEEDED.

C     WELL, LET''S TRY TO CATCH THAT ONE AS WELL (READ ERROR IS O.K.)

      READ(MUNIT,REC=1,ERR=900) IDAT(1),IDAT(2),IDAT(3),IDAT(4),IDAT(5)
      WRITE(MONIOU,*) ' '
      WRITE(MONIOU,*) 'THE HANDLING OF UNFORMATTED DIRECT-ACCESS FILES',
     *    ' ON YOUR MACHINE SEEMS TO'
      WRITE(MONIOU,*) 'BE NOT AS EXPECTED. THE TEMPORARY CORSIKA ',
     *    'EXTERNAL STACK FILE MAY BECOME'
      WRITE(MONIOU,*) 'LARGER THAN NEEDED BUT NO DATA CORRUPTION IS ',
     *    'EXPECTED THERE.'
      WRITE(MONIOU,*) 'PERHAPS YOU USED THE BYTERECL OPTION FOR ',
     *    'EXTRACTING CORSIKA BUT DO NOT NEED IT.'
      WRITE(MONIOU,*) ' '

      IERR = -1
      RETURN

  990 IERR = 99

  900 CLOSE(MUNIT)

      IF ( IERR .NE. 0 ) THEN
        WRITE(MONIOU,*) ' '
        WRITE(MONIOU,*) 'THE HANDLING OF UNFORMATTED DIRECT-ACCESS ',
     *       'FILES ON YOUR MACHINE IS NOT AS'
        WRITE(MONIOU,*) 'EXPECTED. THIS MAY WELL LEAD TO CORRUPTION ',
     *       'OF THE CORSIKA EXTERNAL STACK.'
        WRITE(MONIOU,*) 'PERHAPS THIS PROBLEM IS DUE TO A MISSING ',
     *       'BYTERECL OPTION FOR EXTRACTING'
        WRITE(MONIOU,*) 'CORSIKA FROM THE SOURCE FILE. IT MAY ALSO BE ',
     *       'DUE TO USING COMPILER FLAGS'
        WRITE(MONIOU,*) 'INAPPROPRIATE FOR THE CORSIKA VERSION ',
     *       'EXTRACTED.'
        WRITE(MONIOU,*) ' '
      ENDIF

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE       16/07/1999
C=======================================================================

      SUBROUTINE RHO0DC

C-----------------------------------------------------------------------
C  RHO(0) D(E)C(AY)
C
C  TWO PARTICLE DECAY WITH FULL KINEMATIC; ENERGY AND MOMENTA CONSERVED
C  RHO(0) DECAYS INTO PI(+) + PI(-) WITH DIPOLE CHARACTERISTIC.
C  THIS SUBROUTINE IS CALLED FROM RHOGEN.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRGENER/ GEN,ALEVEL
      DOUBLE PRECISION GEN,ALEVEL

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSTACKE/E,TIM,U,V,W,X,Y,Z,DNEAR,

     *                 ZAP,WAP,WA,

     *                 IQ,IGEN,IR,IOBS,LPCTE,NP
      DOUBLE PRECISION E(60),TIM(60),U(60),V(60),W(60),
     *                 X(60),Y(60),Z(60),DNEAR(60)

     *                 ,ZAP(60),WAP(60),WA(60)

      INTEGER          IQ(60),IGEN(60),IR(60),IOBS(60),LPCTE(60),NP

       

       

       

       

      DOUBLE PRECISION AUX2A,BETA,COSTCM,COSTH3,COSTH4,
     *                 GAMMA3,GAMMA4,PHI4,WORK1,WORK2
      INTEGER          I

      SAVE
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) (CURPAR(I),I=0,9)
  444 FORMAT(' RHO0DC: CURPAR=',1P,9E11.3,0P,F10.0)

C  COPY VERTEX COORDINATES INTO SECPAR
      DO  I = 5, 8
        SECPAR(I) = CURPAR(I)
      ENDDO
C  SET GENERATION AND LEVEL OF LAST INTERACTION
      SECPAR( 9) = GEN
      SECPAR(10) = ALEVEL
C  RESET POLARIZATION, NOT USED FOR PARTICLES OTHER THAN MUONS YET
      SECPAR(11) = 0.D0
      SECPAR(12) = 0.D0

      SECPAR(14) = CURPAR(14)
      SECPAR(15) = CURPAR(15)
      SECPAR(16) = CURPAR(16)

C  CALCULATE AUXILIARY QUANTITIES
      BETA   = SQRT( (CURPAR(1)-1.D0)*(CURPAR(1)+1.D0) ) / CURPAR(1)
      AUX2A  = 0.5D0 * PAMA(51) / PAMA(8)
      WORK1  = CURPAR(1) * AUX2A
      WORK2  = BETA * CURPAR(1) * SQRT( (AUX2A-1.D0)*(AUX2A+1.D0) )

C  DETERMINE POLAR ANGLE IN CM SYSTEM WITH DIPOLE CHARACTERISTICS
C  PURE DIPOLE RADIATION: W(COSTH) = 1-3/5*COSTH**2
 210  CONTINUE
      CALL RMMARD( RD,2,1 )
      COSTCM = 2.D0 * RD(1) - 1.D0

C  PARAMETRIZATION FROM H1 COLLAB. [NUCL.PYS. B463(1996)3]
C  THIS PARAMETRIZATION SEEMS UNPHYSICALLY, AS IT RESULTS IN
C  NEGATIVE RATE IN FORWARD OR BACKWARD DIRECTION
C     IF ( RD(2) .GT. 1.D0 - 1.1982D0 * COSTCM**2 ) GOTO 210
C  PARAMETRIZATION FROM ZEUSS COLLAB. [Z.PHYS. C69(1995)39]
      IF ( RD(2) .GT. 1.D0 - 0.8836D0 * COSTCM**2 ) GOTO 210

      GAMMA3 = WORK1 + WORK2 * COSTCM
C  SECOND PRODUCT PARTICLE  IS PI(-)
      GAMMA4 = CURPAR(1) * (PAMA(51)/PAMA(8)) - GAMMA3
      COSTH4 = MIN( 1.D0, (CURPAR(1)*GAMMA4 - AUX2A)
     *          / (BETA*CURPAR(1)*SQRT( (GAMMA4-1.D0)*(GAMMA4+1.D0))) )
      CALL RMMARD( RD,1,1 )
      PHI4  = RD(1) * PI2
      CALL ADDANG3( CURPAR(2),CURPAR(3),CURPAR(4), COSTH4,PHI4,
     *                                  SECPAR(2),SECPAR(3),SECPAR(4) )

      IF ( SECPAR(2) .GT. C(29) ) THEN

        SECPAR(0) = 9.D0
        SECPAR(1) = GAMMA4

        IF ( DEBUG ) WRITE(MDEBUG,445) (SECPAR(I),I=0,9)
  445   FORMAT(' RHO0DC: SECPAR=',1P,9E11.3,0P,F10.0)

        CALL TSTACK
      ELSE
        IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

          DLONG(LPCTE(NP),17) = DLONG(LPCTE(NP),17) + GAMMA4 * PAMA(9)

        ENDIF
      ENDIF
C  FIRST PRODUCT PARTICLE IS PI(+)
      COSTH3 = MIN( 1.D0, (CURPAR(1) * GAMMA3 - AUX2A)
     *         / (BETA*CURPAR(1)*SQRT( (GAMMA3-1.D0)*(GAMMA3+1.D0) )) )
      CALL ADDANG3( CURPAR(2),CURPAR(3),CURPAR(4), COSTH3,PHI4+PI,
     *                                  SECPAR(2),SECPAR(3),SECPAR(4) )

      IF ( SECPAR(2) .GT. C(29) ) THEN

        SECPAR(0) = 8.D0
        SECPAR(1) = GAMMA3

        IF ( DEBUG ) WRITE(MDEBUG,445) (SECPAR(I),I=0,9)

        CALL TSTACK
      ELSE
        IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

          DLONG(LPCTE(NP),17) = DLONG(LPCTE(NP),17) + GAMMA3 * PAMA(8)

        ENDIF
      ENDIF

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      DOUBLE PRECISION FUNCTION RHOF( ARG )

C-----------------------------------------------------------------------
C  RHO (DENSITY) F(UNCTION)
C
C  CALCULATES DENSITY (G/CM**3) OF ATMOSPHERE DEPENDING ON HEIGHT (CM)
C  THIS FUNCTION IS CALLED FROM BOX2, LPMEFFECT, ININKG, CERENK,
C  MUTRAC, AND INRTAB.
C  ARGUMENT:
C   ARG    = HEIGHT IN CM
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRATMOS/ AATM,AATM0,BATM,BATM0,CATM,CATM0,DATM,MODATM
      DOUBLE PRECISION AATM(5),AATM0(5,0:22),BATM(5),BATM0(5,0:22),
     *                 CATM(5),CATM0(5,0:22),DATM(5)
      INTEGER          MODATM

      COMMON /CRATMOS2/HLAY,HLAY0,THICKL,LAYNO,LAYNEW
      DOUBLE PRECISION HLAY(6),HLAY0(5,0:9),THICKL(5)
      INTEGER          LAYNO(0:22)
      LOGICAL          LAYNEW

C  EXTERNAL ATMOSPHERIC MODELS
      COMMON /CRATMOSX/IATMOX,FREFRX
      INTEGER          IATMOX
      LOGICAL          FREFRX

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION ARG

      DOUBLE PRECISION RHOFX
      EXTERNAL         RHOFX

      SAVE
C-----------------------------------------------------------------------

CC    IF ( DEBUG ) WRITE(MDEBUG,*) 'RHOF  : ARG=',SNGL(ARG)

      IF ( IATMOX .GE. 1 ) THEN
        RHOF = RHOFX( ARG )
        RETURN
      ENDIF

      IF     ( ARG .LT. HLAY(2) ) THEN
        RHOF = BATM(1) * DATM(1) * EXP ( (-ARG) * DATM(1) )
      ELSEIF ( ARG .LT. HLAY(3) ) THEN
        RHOF = BATM(2) * DATM(2) * EXP ( (-ARG) * DATM(2) )
      ELSEIF ( ARG .LT. HLAY(4) ) THEN
        RHOF = BATM(3) * DATM(3) * EXP ( (-ARG) * DATM(3) )
      ELSEIF ( ARG .LT. HLAY(5) ) THEN
        RHOF = BATM(4) * DATM(4) * EXP ( (-ARG) * DATM(4) )
      ELSE
        RHOF = DATM(5)
      ENDIF

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   17/03/2003
C=======================================================================

      SUBROUTINE RMMAQD( ISEED,ISEQ,CHOPT )

C-----------------------------------------------------------------------
C
C  SUBROUTINE FOR INITIALIZATION OF RMMARD
C  THESE ROUTINE RMMAQD IS A MODIFIED VERSION OF ROUTINE RMMAQ FROM
C  THE CERN LIBRARIES. DESCRIPTION OF ALGORITHM SEE:
C               http://consult.cern.ch/shortwrups/v113/top.html
C  FURTHER DETAILS SEE SUBR. RMMARD
C  ARGUMENTS:
C   ISEED  = SEED TO INITIALIZE A SEQUENCE (3 INTEGERS)
C   ISEQ   = # OF RANDOM SEQUENCE
C   CHOPT  = CHARACTER TO STEER INITIALIZE OPTIONS
C-----------------------------------------------------------------------

      IMPLICIT NONE

      INTEGER          KSEQ
      PARAMETER        (KSEQ = 5)
      COMMON /CRRANMA3/CD,CINT,CM,TWOM24,TWOM48,MODCNS
      DOUBLE PRECISION CD,CINT,CM,TWOM24,TWOM48
      INTEGER          MODCNS

      COMMON /CRRANMA4/C,U,IJKL,I97,J97,NTOT,NTOT2,JSEQ
      DOUBLE PRECISION C(KSEQ),U(97,KSEQ),UNI
      INTEGER          IJKL(KSEQ),I97(KSEQ),J97(KSEQ),
     *                 NTOT(KSEQ),NTOT2(KSEQ),JSEQ

       

       

       

       

      DOUBLE PRECISION CC,S,T,UU(97)
      INTEGER          ISEED(3),I,IDUM,II,II97,IJ,IJ97,IORNDM,
     *                 ISEQ,J,JJ,K,KL,L,LOOP2,M,NITER
      CHARACTER        CHOPT*(*), CCHOPT*12
      LOGICAL          FIRST
      SAVE
      DATA             FIRST / .TRUE. /, IORNDM/11/, JSEQ/1/
C-----------------------------------------------------------------------

      IF ( FIRST ) THEN
        TWOM24 = 2.D0**(-24)
        TWOM48 = 2.D0**(-48)
        CD     = 7654321.D0*TWOM24
        CM     = 16777213.D0*TWOM24
        CINT   = 362436.D0*TWOM24
        MODCNS = 1000000000
        FIRST  = .FALSE.
      ENDIF

      CCHOPT = CHOPT
      IF ( CCHOPT .EQ. ' ' ) THEN
        ISEED(1) = 54217137
        ISEED(2) = 0
        ISEED(3) = 0
        CCHOPT   = 'S'
        JSEQ     = 1
      ENDIF

      IF     ( INDEX(CCHOPT,'S') .NE. 0 ) THEN
        IF ( ISEQ .GT. 0  .AND.  ISEQ .LE. KSEQ ) JSEQ = ISEQ
        IF ( INDEX(CCHOPT,'V') .NE. 0 ) THEN
          READ(IORNDM,'(3Z8)') IJKL(JSEQ),NTOT(JSEQ),NTOT2(JSEQ)
          READ(IORNDM,'(2Z8,Z16)') I97(JSEQ),J97(JSEQ),C(JSEQ)
          READ(IORNDM,'(24(4Z16,/),Z16)') U
          IJ = IJKL(JSEQ)/30082
          KL = IJKL(JSEQ) - 30082 * IJ
          I  = MOD(IJ/177, 177) + 2
          J  = MOD(IJ, 177)     + 2
          K  = MOD(KL/169, 178) + 1
          L  = MOD(KL, 169)
          CD =  7654321.D0 * TWOM24
          CM = 16777213.D0 * TWOM24
        ELSE
          IJKL(JSEQ)  = ISEED(1)
          NTOT(JSEQ)  = ISEED(2)
          NTOT2(JSEQ) = ISEED(3)
          IJ = IJKL(JSEQ) / 30082
          KL = IJKL(JSEQ) - 30082*IJ
          I  = MOD(IJ/177, 177) + 2
          J  = MOD(IJ, 177)     + 2
          K  = MOD(KL/169, 178) + 1
          L  = MOD(KL, 169)
          DO  II = 1, 97
            S = 0.D0
            T = 0.5D0
            DO  JJ = 1, 48
              M = MOD(MOD(I*J,179)*K, 179)
              I = J
              J = K
              K = M
              L = MOD(53*L+1, 169)
              IF ( MOD(L*M,64) .GE. 32 ) S = S + T
              T = 0.5D0 * T
            ENDDO
            UU(II) = S
          ENDDO
          CC    = CINT
          II97  = 97
          IJ97  = 33
C  COMPLETE INITIALIZATION BY SKIPPING (NTOT2*MODCNS+NTOT) RANDOMNUMBERS
          NITER = MODCNS
          DO  LOOP2 = 1, NTOT2(JSEQ)+1
            IF ( LOOP2 .GT. NTOT2(JSEQ) ) NITER = NTOT(JSEQ)
            DO  IDUM = 1, NITER
              UNI = UU(II97) - UU(IJ97)
              IF ( UNI .LT. 0.D0 ) UNI = UNI + 1.D0
              UU(II97) = UNI
              II97     = II97 - 1
              IF ( II97 .EQ. 0 ) II97 = 97
              IJ97     = IJ97 - 1
              IF ( IJ97 .EQ. 0 ) IJ97 = 97
              CC       = CC - CD
              IF ( CC .LT. 0.D0 ) CC  = CC + CM
            ENDDO
          ENDDO
          I97(JSEQ) = II97
          J97(JSEQ) = IJ97
          C(JSEQ)   = CC
          DO  JJ = 1, 97
            U(JJ,JSEQ) = UU(JJ)
          ENDDO
        ENDIF
      ELSEIF ( INDEX(CCHOPT,'R') .NE. 0 ) THEN
        IF ( ISEQ .GT. 0 ) THEN
          JSEQ = ISEQ
        ELSE
          ISEQ = JSEQ
        ENDIF
        IF ( INDEX(CCHOPT,'V') .NE. 0 ) THEN
          WRITE(IORNDM,'(3Z8)') IJKL(JSEQ),NTOT(JSEQ),NTOT2(JSEQ)
          WRITE(IORNDM,'(2Z8,Z16)') I97(JSEQ),J97(JSEQ),C(JSEQ)
          WRITE(IORNDM,'(24(4Z16,/),Z16)') U
        ELSE
          ISEED(1) = IJKL(JSEQ)
          ISEED(2) = NTOT(JSEQ)
          ISEED(3) = NTOT2(JSEQ)
        ENDIF
      ENDIF

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   17/03/2003
C=======================================================================

      SUBROUTINE RMMARD( RVEC,LENV,ISEQ )

C-----------------------------------------------------------------------
C  R(ANDO)M (NUMBER GENERATOR OF) MAR(SAGLIA TYPE) D(OUBLE PRECISION)
C
C  THESE ROUTINES (RMMARD,RMMAQD) ARE MODIFIED VERSIONS OF ROUTINES
C  FROM THE CERN LIBRARIES. DESCRIPTION OF ALGORITHM SEE:
C               http://consult.cern.ch/shortwrups/v113/top.html
C  IT HAS BEEN CHECKED THAT RESULTS ARE BIT-IDENTICAL WITH CERN
C  DOUBLE PRECISION RANDOM NUMBER GENERATOR RMM48, DESCRIBED IN
C               http://consult.cern.ch/shortwrups/v116/top.html
C  ARGUMENTS:
C   RVEC   = DOUBLE PREC. VECTOR FIELD TO BE FILLED WITH RANDOM NUMBERS
C   LENV   = LENGTH OF VECTOR (# OF RANDNUMBERS TO BE GENERATED)
C   ISEQ   = # OF RANDOM SEQUENCE
C
C  VERSION OF D. HECK FOR DOUBLE PRECISION RANDOM NUMBERS.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      INTEGER          KSEQ
      PARAMETER        (KSEQ = 5)
      COMMON /CRRANMA3/CD,CINT,CM,TWOM24,TWOM48,MODCNS
      DOUBLE PRECISION CD,CINT,CM,TWOM24,TWOM48
      INTEGER          MODCNS

      COMMON /CRRANMA4/C,U,IJKL,I97,J97,NTOT,NTOT2,JSEQ
      DOUBLE PRECISION C(KSEQ),U(97,KSEQ),UNI
      INTEGER          IJKL(KSEQ),I97(KSEQ),J97(KSEQ),
     *                 NTOT(KSEQ),NTOT2(KSEQ),JSEQ

       

       

       

       

      DOUBLE PRECISION RVEC(*)
      INTEGER          ISEQ,IVEC,LENV
      SAVE
C-----------------------------------------------------------------------

      IF ( ISEQ .GT. 0  .AND.  ISEQ .LE. KSEQ ) JSEQ = ISEQ

      DO  IVEC = 1, LENV
        UNI = U(I97(JSEQ),JSEQ) - U(J97(JSEQ),JSEQ)
        IF ( UNI .LT. 0.D0 ) UNI = UNI + 1.D0
        U(I97(JSEQ),JSEQ) = UNI
        I97(JSEQ)  = I97(JSEQ) - 1
        IF ( I97(JSEQ) .EQ. 0 ) I97(JSEQ) = 97
        J97(JSEQ)  = J97(JSEQ) - 1
        IF ( J97(JSEQ) .EQ. 0 ) J97(JSEQ) = 97
        C(JSEQ)    = C(JSEQ) - CD
        IF ( C(JSEQ) .LT. 0.D0 ) C(JSEQ)  = C(JSEQ) + CM
        UNI        = UNI - C(JSEQ)
        IF ( UNI .LT. 0.D0 ) UNI = UNI + 1.D0
C  AN EXACT ZERO HERE IS VERY UNLIKELY, BUT LET''S BE SAFE.
        IF ( UNI .EQ. 0.D0 ) UNI = TWOM48
        RVEC(IVEC) = UNI
      ENDDO

      NTOT(JSEQ) = NTOT(JSEQ) + LENV
      IF ( NTOT(JSEQ) .GE. MODCNS )  THEN
        NTOT2(JSEQ) = NTOT2(JSEQ) + 1
        NTOT(JSEQ)  = NTOT(JSEQ) - MODCNS
      ENDIF

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE       27/04/1994
C=======================================================================

      SUBROUTINE SDPM( LTA )

C-----------------------------------------------------------------------
C  S(TARTING) D(UAL) P(ARTON) M(ODEL)
C
C  THIS ROUTINE DETERMINES THE TARGET NUCLEUS.
C  IT CALLS ALSO THE VARIOUS INTERACTION MODELS.
C  FOR HDPM, THIS ROUTINE LOOKS, HOW MANY NUCLEONS INTERACT AND WHICH
C  RESIDUAL FRAGMENT OF THE PROJECTILE NUCLEUS REMAINS.
C  THIS SUBROUTINE IS CALLED FROM NUCINT AND PIGEN.
C  ARGUMENT:
C   LTA    = TARGET: 1=14N, 2=16O, 3=40AR, 0=RANDOM
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRAIR/   COMPOS,PROBTA,AVERAW,AVOGDR
      DOUBLE PRECISION COMPOS(3),PROBTA(3),AVERAW,AVOGDR

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRDPMFLG/NFLAIN,NFLDIF,NFLPI0,NFLCHE,NFLPIF,NFRAGM
      INTEGER          NFLAIN,NFLDIF,NFLPI0,NFLCHE,NFLPIF,NFRAGM

      COMMON /CRGENER/ GEN,ALEVEL
      DOUBLE PRECISION GEN,ALEVEL

      COMMON /CRINTER/ AVCH,AVCH3,DC0,DLOG,DMLOG,ECMDIF,ECMDPM,ELAB,
     *                 FNEUT,FNEUT2,GNU,PLAB,POSC2,POSC3,POSN2,POSN3,
     *                 RC3TO2,S,SEUGF,SEUGP,SLOG,SLOGSQ,SMLOG,
     *                 WIDC2,WIDC3,WIDN2,WIDN3,YCM,YY0,ZN,
     *                 IDIF,ITAR
      DOUBLE PRECISION AVCH,AVCH3,DC0,DLOG,DMLOG,ECMDIF,ECMDPM,ELAB,
     *                 FNEUT,FNEUT2,GNU,PLAB,POSC2,POSC3,POSN2,POSN3,
     *                 RC3TO2,S,SEUGF,SEUGP,SLOG,SLOGSQ,SMLOG,
     *                 WIDC2,WIDC3,WIDN2,WIDN3,YCM,YY0,ZN
      INTEGER          IDIF,ITAR

      COMMON /CRISTA/  IFINET,IFINNU,IFINKA,IFINPI,IFINHY,IFINOT
      INTEGER          IFINET,IFINNU,IFINKA,IFINPI,IFINHY,IFINOT

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRMULT/  EKINL,MSMM,MULTMA,MULTOT
      DOUBLE PRECISION EKINL
      INTEGER          MSMM,MULTMA(40,13),MULTOT(40,13)

      COMMON /CRNCSNCS/SIGN30,SIGN45,SIGN60,SIGO30,SIGO45,SIGO60,
     *                 SIGA30,SIGA45,SIGA60,PNOA30,PNOA45,PNOA60,
     *                 SIG30A,SIG45A,SIG60A
      DOUBLE PRECISION SIGN30(56),SIGN45(56),SIGN60(56),
     *                 SIGO30(56),SIGO45(56),SIGO60(56),
     *                 SIGA30(56),SIGA45(56),SIGA60(56),
     *                 PNOA30(1540,3),PNOA45(1540,3),PNOA60(1540,3),
     *                 SIG30A(56),SIG45A(56),SIG60A(56)

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRREST/  CONTNE,TAR,LT
      DOUBLE PRECISION CONTNE(3),TAR
      INTEGER          LT

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSIGM/  SIGMA,SIGANN,SIGAIR,FRACTN,FRCTNO
      DOUBLE PRECISION SIGMA,SIGANN,SIGAIR,FRACTN,FRCTNO

      COMMON /CRVKIN/  BETACM
      DOUBLE PRECISION BETACM

       

       

       

       

      COMMON /CRQGSC/  LEVLDQ,IQGSVER,FQGS,FQGSSG
      INTEGER          LEVLDQ,IQGSVER
      LOGICAL          FQGS,FQGSSG

      DOUBLE PRECISION PFRX(60),PFRY(60)
      DOUBLE PRECISION COSTET,CPHIV,EA,P,PTM,PT2,PTOT,SPHIV,
     *                 SIGMAA,SIGMAN,SIGMAO,SIG45,S45SQ,S4530
      DOUBLE PRECISION CGHSIG
      INTEGER          ITYP(60),I,IA,IANEW,INACTA,INACTZ,INDEX,INEUTR,
     *                 IZ,IZNEW,J,JFIN,KNEW,L,LL,LTA,NPRPRO,NNEPRO
      SAVE
      EXTERNAL         CGHSIG
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) (CURPAR(I),I=0,9)
  444 FORMAT(' SDPM  : CURPAR=',1P,10E11.3)

C  IA IS MASS NUMBER OF PROJECTILE
      IA = ITYPE / 100
      IF ( IA .GT. 56 ) THEN

        WRITE(MONIOU,444) (CURPAR(I),I=0,9)

        WRITE(MONIOU,*) 'SDPM  : NOT FORESEEN PARTICLE TYPE=',ITYPE
        STOP
      ENDIF

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  TREATMENT OF GAMMAS COMING FROM EGS4 (PIGEN)
      IF     ( ITYPE .EQ. 1 ) THEN
        IF ( LTA .EQ. 0 ) THEN
C  TAKE TARGET FROM CROSS SECTION RATIOS AT RANDOM
C  RATIOS OF CROSS-SECTIONS GO LIKE A**0.91
C  14**0.91 = 11.04; 16**0.91 = 12.47; 40**0.91 = 28.70
          FRACTN = COMPOS(1) * 11.04019D0
          FRCTNO = FRACTN + COMPOS(2) * 12.46663D0
          SIGAIR = FRCTNO + COMPOS(3) * 28.69952D0
C  TARGET IS CHOSEN AT RANDOM
          CALL RMMARD( RD,1,1 )
          IF     ( RD(1)*SIGAIR .LE. FRACTN ) THEN
C  INTERACTION WITH NITROGEN
            LT  = 1
            TAR = 14.D0
          ELSEIF ( RD(1)*SIGAIR .LE. FRCTNO ) THEN
C  INTERACTION WITH OXYGEN
            LT  = 2
            TAR = 16.D0
          ELSE
C  INTERACTION WITH ARGON
            LT  = 3
            TAR = 40.D0
          ENDIF

C  TARGET IS PREDETERMINED
        ELSEIF ( LTA .EQ. 1 ) THEN
           LT  = 1
           TAR = 14.D0
        ELSEIF ( LTA .EQ. 2 ) THEN
          LT = 2
          TAR = 16.D0
        ELSEIF ( LTA .EQ. 3 ) THEN
          LT = 3
          TAR = 40.D0
        ENDIF
C  GAMMAS ARE TREATED BY QGSJET, IF SUFFICIENT ENERGY
        IF ( FQGS  .AND.  CURPAR(1) .GT. HILOELB ) THEN
          CALL QGSLNK
        ELSE
          CALL HDPM
        ENDIF

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  NORMAL HADRON PROJECTILE
      ELSEIF ( ITYPE .LT. 200 ) THEN
C  WITH WHAT KIND OF TARGET DOES PROJECTILE INTERACT?
        IF ( FIXTAR ) THEN
C  TARGET OF FIRST INTERACTION IS FIXED
          LT = N1STTR
          IF     ( N1STTR .EQ. 1 ) THEN
            TAR = 14.D0
          ELSEIF ( N1STTR .EQ. 2 ) THEN
            TAR = 16.D0
          ELSE
            TAR = 40.D0
          ENDIF
          FIXTAR = .FALSE.
C  AUXIL. QUANTITIES FOR INTERPOLATION
          SIG45  = SIGMA - 45.D0
          S45SQ  = SIG45**2 / 450.D0
          S4530  = SIG45 / 30.D0
        ELSE
C  SELECT THE TARGET ACCORDING OCCURENCE AND CROSS SECTION CONTRIBUTION
C  TARGET IS CHOSEN AT RANDOM ACCORDING TO CROSS-SECTION
C  SIGAIR, FRACTN, FRCTNO HAVE BEEN DETERMINED IN BOX2/QGSSIG
          IF ( FQGSSG ) GOTO 333
C  SIGMA IS ENERGY DEPENDENT INELASTIC NUCLEON-NUCLEON CROSS-SECTION
C  AND IS SET IN BOX2
C  AUXIL. QUANTITIES FOR INTERPOLATION
          SIG45  = SIGMA - 45.D0
          S45SQ  = SIG45**2 / 450.D0
          S4530  = SIG45 / 30.D0
C  INELASTIC CROSS-SECTIONS FOR PROJECTICLE WITH MASS NUMBER 1
          SIGMAN = (1.D0 - 2.D0 * S45SQ) * SIGN45(1)
     *                  +(S45SQ - S4530) * SIGN30(1)
     *                  +(S45SQ + S4530) * SIGN60(1)
          FRACTN = COMPOS(1) * SIGMAN
          SIGMAO = (1.D0 - 2.D0 * S45SQ) * SIGO45(1)
     *                  +(S45SQ - S4530) * SIGO30(1)
     *                  +(S45SQ + S4530) * SIGO60(1)
          FRCTNO = FRACTN + COMPOS(2) * SIGMAO
          SIGMAA = (1.D0 - 2.D0 * S45SQ) * SIGA45(1)
     *                  +(S45SQ - S4530) * SIGA30(1)
     *                  +(S45SQ + S4530) * SIGA60(1)
C  INELASTIC CROSS-SECTIONS OF AIR FOR PROJECTILE WITH MASS NUMBER 1
          SIGAIR = FRCTNO + COMPOS(3)*SIGMAA

 333      CONTINUE

          CALL RMMARD( RD,1,1 )
          IF ( DEBUG ) WRITE(MDEBUG,*) 'SDPM  : FRACTN=',SNGL(FRACTN),
     *                      ' FRCTNO=',SNGL(FRCTNO),' RD=',SNGL(RD(1))
          IF     ( RD(1)*SIGAIR .LE. FRACTN ) THEN
C  INTERACTION WITH NITROGEN
            LT  = 1
            TAR = 14.D0
          ELSEIF ( RD(1)*SIGAIR .LE. FRCTNO ) THEN
C  INTERACTION WITH OXYGEN
            LT  = 2
            TAR = 16.D0
          ELSE
C  INTERACTION WITH ARGON
            LT  = 3
            TAR = 40.D0
          ENDIF
        ENDIF

        IF ( FQGS ) THEN
C  MESONS AND NUCLEONS ARE TREATED BY QGSJET (JAN 96)
          IF ( (ITYPE .GE.  7  .AND.  ITYPE .LE. 17)  .OR.
     *         (ITYPE .EQ. 25                      )  .OR.
     *         (ITYPE .GE. 71  .AND.  ITYPE .LE. 74) ) THEN
            CALL QGSLNK
          ELSE
            CALL HDPM
          ENDIF
        ELSE
          CALL HDPM
        ENDIF

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  HEAVY PRIMARY INCIDENT WITH IA NUCLEONS
      ELSEIF ( IA .LE. 56 ) THEN

        IZ = MOD(ITYPE,100)
C  WITH WHAT KIND OF TARGET DOES PROJECTILE INTERACT?
        IF ( FIXTAR ) THEN
C  TARGET OF FIRST INTERACTION IS FIXED
          LT = N1STTR
          IF     ( N1STTR .EQ. 1 ) THEN
            TAR = 14.D0
          ELSEIF ( N1STTR .EQ. 2 ) THEN
            TAR = 16.D0
          ELSE
            TAR = 40.D0
          ENDIF
          FIXTAR = .FALSE.
          CALL RMMARD( RD,2,1 )
C  AUXIL. QUANTITIES FOR INTERPOLATION
          SIG45  = SIGMA - 45.D0
          S45SQ  = SIG45**2 / 450.D0
          S4530  = SIG45 / 30.D0
        ELSE
C  ONLY INELASTIC INTERACTIONS WITH HEAVY PRIMARY/FRAGMENT
C  SIGMA IS ENERGY DEPENDENT INELASTIC NUCLEON-NUCLEON CROSS-SECTION

C  AND IS SET IN BOX2/QGSSIG
          IF ( FQGSSG ) GOTO 334
C  NO CORRECT CROSS SECTION AVAILABLE FOR NUCLEUS-NUCLEUS COLLISION
C  TAKE THE GRIEDER MODEL

C  AUXIL. QUANTITIES FOR INTERPOLATION
          SIG45  = SIGMA - 45.D0
          S45SQ  = SIG45**2 / 450.D0
          S4530  = SIG45 / 30.D0
C  INELASTIC CROSS-SECTIONS FOR PROJECTICLE WITH MASS NUMBER IA
          SIGMAN = (1.D0 - 2.D0 * S45SQ) * SIGN45(IA)
     *                  +(S45SQ - S4530) * SIGN30(IA)
     *                  +(S45SQ + S4530) * SIGN60(IA)
          FRACTN = COMPOS(1) * SIGMAN
          SIGMAO = (1.D0 - 2.D0 * S45SQ) * SIGO45(IA)
     *                  +(S45SQ - S4530) * SIGO30(IA)
     *                  +(S45SQ + S4530) * SIGO60(IA)
          FRCTNO = FRACTN + COMPOS(2) * SIGMAO
          SIGMAA = (1.D0 - 2.D0 * S45SQ) * SIGA45(IA)
     *                  +(S45SQ - S4530) * SIGA30(IA)
     *                  +(S45SQ + S4530) * SIGA60(IA)
C  INELASTIC CROSS-SECTIONS OF AIR FOR PROJECTILE WITH MASS NUMBER IA
          SIGAIR = FRCTNO +COMPOS(3)*SIGMAA

 334      CONTINUE

C  TARGET IS CHOSEN AT RANDOM
          CALL RMMARD( RD,2,1 )
          IF ( DEBUG ) WRITE(MDEBUG,*) 'SDPM  : FRACTN=',SNGL(FRACTN),
     *                      ' FRCTNO=',SNGL(FRCTNO),' RD=',SNGL(RD(1))
          IF     ( RD(1)*SIGAIR .LE. FRACTN ) THEN
C  INTERACTION WITH NITROGEN
            LT  = 1
            TAR = 14.D0
          ELSEIF ( RD(1)*SIGAIR .LE. FRCTNO ) THEN
C  INTERACTION WITH OXYGEN
            LT  = 2
            TAR = 16.D0
          ELSE
C  INTERACTION WITH ARGON
            LT  = 3
            TAR = 40.D0
          ENDIF
        ENDIF
C  TREAT NUCLEUS BY QGSJET, IF SELECTED AND ENERGY/NUCLEON HIGH ENOUGH
        IF ( FQGS  .AND.  PAMA(ITYPE)*GAMMA .GT. HILOELB*IA ) THEN
          CALL QGSLNK
          RETURN
        ENDIF

C  TREATMENT OF NUCLEUS-NUCLEUS INTERACTION IN HDPM BY SUPERPOSITION
C
C  INDEX CALCULATION 1<I=<56     NUCLEONS IN PROJECTILE
C                    1<J<I       INTERACTING NUCLEONS
C                    P(I,I)=1    CUMULATIVE PROBABILITIES
C                    P(I,J)  ---> P( I*(I-3)*0.5+J+1 )
C  IZ     IS NUMBER OF PROTONS IN PROJECTILE
C  LT     IS INDEX FOR TARGET 1 = N, 2 = O, 3 = AR
C  INACTA IS NUMBER OF INTERACTING NUCLEONS
C  INACTZ IS NUMBER OF INTERACTING PROTONS

C  LOOK, HOW MANY NUCLEONS INTERACT
        DO  J = 1, IA-1
          INACTA = J
          INDEX  = IA * (IA-3) * 0.5 + 1 + J
          P = ( 1.D0 - S45SQ *2.D0 ) * PNOA45(INDEX,LT)
     *            +( S45SQ - S4530 ) * PNOA30(INDEX,LT)
     *            +( S45SQ + S4530 ) * PNOA60(INDEX,LT)
          IF ( RD(2) .LT. P ) GOTO 110
        ENDDO
C  ALL NUCLEONS INTERACT  (INACTA EQUAL IA)
        INACTA = INACTA + 1

  110   CONTINUE
        IANEW  = IA - INACTA

C  REMAINING PROJECTILE WITH IANEW NUCLEONS
        DO  L = 1, 4
          SECPAR(L) = CURPAR(L)
        ENDDO

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  PROJECTILE NUCLEUS FRAGMENTS COMPLETELY, WRITE SPECTATOR NUCLEONS
C  ONTO STACK
        IF ( NFRAGM .EQ. 0 ) THEN
C  LOOK, HOW MANY PROTONS AND NEUTRONS ARE FORMED
          IZNEW  = IANEW / 2.15D0 + 0.7D0
          INEUTR = IANEW - IZNEW
          INACTZ = MAX( 0, IZ-IZNEW )

          IF ( IZNEW .GT. 0 ) THEN
C  PROTONS
            SECPAR(0) = 14.D0
            DO  L = 1, IZNEW
              CALL TSTACK
            ENDDO
          ENDIF
          IF ( INEUTR .GT. 0 ) THEN
C  NEUTRONS
            SECPAR(0) = 13.D0
            DO  L = 1, INEUTR
              CALL TSTACK
            ENDDO
          ENDIF

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  NO FRAGMENTATION, BUT SUCCESSIVE ABRASION OF PROJECTILE NUCLEUS
        ELSE
          IF ( DEBUG ) WRITE( MDEBUG,111 ) TAR,INACTA,IANEW
  111     FORMAT(' SDPM  : TARGET=',F4.0,' INACTA=',I4,' IANEW=',I4)

C  ALL NUCLEONS INTERACT, NO RESIDUAL NUCLEUS
          IF     ( IANEW .EQ. 0 ) THEN
            INACTZ    = IZ

            IF ( DEBUG ) WRITE(MDEBUG,554) (CURPAR(I),I=0,9)
  554       FORMAT(' SDPM  : CURPAR=',1P,10E11.3)

            KNEW = 0

C  REMAINING NUCLEUS IS A NUCLEON
          ELSEIF ( IANEW .EQ. 1 ) THEN
            CALL RMMARD( RD,1,1 )
            IZNEW  = NINT( RD(1) )
            INACTZ = IZ - IZNEW
            KNEW   = 13 + IZNEW

C  REMAINING NUCLEUS GETS A CHARGE WHICH IS ABOUT HALF THE MASS NUMBER
          ELSEIF ( IANEW .GT. 1 ) THEN
            IZNEW  = DBLE(IANEW) / 2.15D0 + 0.7D0
            INACTZ = MAX( 0, IZ - IZNEW )
            KNEW   = IANEW*100 + IZNEW

C  REMAINING NUCLEUS DEEXCITES BY EVAPORATION OF NUCLEONS/ALPHA PARTCLS.
            IF ( NFRAGM .GE. 2 ) THEN
              JFIN = 0
              CALL VAPOR( IA,KNEW,JFIN,ITYP,PFRX,PFRY )
              IF ( JFIN .LE. 0 ) GOTO 190
              KNEW = 0
              DO  135  J = 1,JFIN
                EA  = GAMMA * PAMA(ITYP(J))
                IF ( DEBUG ) WRITE(MDEBUG,*) 'SDPM  : J,ITYP,EA=',
     *                                            J,ITYP(J),SNGL(EA)
                PTM = (EA-PAMA(ITYP(J))) * (EA+PAMA(ITYP(J)))
                PT2 = PFRX(J)**2 + PFRY(J)**2
                IF ( PT2 .GE. PTM ) THEN
                  IF ( DEBUG ) WRITE(MDEBUG,*) 'SDPM  : PT REJECT ',J
                  GOTO 135
                ENDIF
                IF ( PTM .GT. 0.D0 ) THEN
                  COSTET = SQRT( 1.D0 - PT2/PTM )
                ELSE
                  COSTET = 1.D0
                ENDIF
                PTOT  = SQRT( PTM )
                CPHIV = PFRX(J) / PTOT
                SPHIV = PFRY(J) / PTOT
                CALL ADDANG4( COSTHE,PHIX,PHIY, COSTET,CPHIV,SPHIV,
     *                                 SECPAR(2),SECPAR(3),SECPAR(4) )

                IF ( SECPAR(2) .GT. C(29) ) THEN

                  IF ( J .LT. JFIN ) THEN
                    SECPAR(0) = ITYP(J)

                    CALL TSTACK
                  ELSE
                    KNEW  = ITYP(JFIN)
                    IANEW = KNEW/100
                  ENDIF
                ELSE
                  IF (DEBUG) WRITE(MDEBUG,*) 'SDPM  : ANGLE REJECT ',J
                  IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

                    DLONG(LHEIGH,17) = DLONG(LHEIGH,17)
     *                                          + EA - RESTMS(ITYP(J))

                  ENDIF
                ENDIF
 135          CONTINUE
            ENDIF
          ENDIF

C  REMAINING NUCLEUS: MASS 5 CANNOT BE TREATED IN BOX2
          IF     ( KNEW/100 .EQ. 5 ) THEN
            IF ( MOD(KNEW,100) .GE. 3 ) THEN
C  MASS 5: SPLIT OFF ONE PROTON
              SECPAR(0) = 14.D0
              CALL TSTACK
              KNEW = KNEW - 101
            ELSE
C  MASS 5: SPLIT OFF ONE NEUTRON
              SECPAR(0) = 13.D0
              CALL TSTACK
              KNEW = KNEW - 100
            ENDIF

C  REMAINING NUCLEUS: MASS 8 CANNOT BE TREATED IN BOX2
          ELSEIF ( KNEW/100 .EQ. 8 ) THEN
            IF     ( MOD(KNEW,100) .GE. 5 ) THEN
C  MASS 8: SPLIT OFF ONE PROTON
              SECPAR(0) = 14.D0
              CALL TSTACK
              KNEW = KNEW - 101
            ELSEIF ( MOD(KNEW,100) .LE. 3 ) THEN
C  MASS 8: SPLIT OFF ONE NEUTRON
              SECPAR(0) = 13.D0
              CALL TSTACK
              KNEW = KNEW - 100
            ELSE
C  MASS 8: SPLIT OFF ONE ALPHA PARTICLE
              SECPAR(0) = 402.D0
              CALL TSTACK
              KNEW = KNEW - 402
            ENDIF
          ENDIF

          IF ( KNEW .GT. 0 ) THEN
            SECPAR(0) = KNEW
              CALL TSTACK

            IF ( DEBUG ) WRITE(MDEBUG,555) (SECPAR(I),I=0,9)
 555        FORMAT (' SDPM  : SECPAR=',1P,9E11.3,0P,F10.0)

          ENDIF
        ENDIF

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  HERE THE REACTING NUCLEONS ARE TREATED
 190    CONTINUE
        NPRPRO = INACTZ
        NNEPRO = INACTA - INACTZ
        IF ( DEBUG ) WRITE(MDEBUG,*) 'SDPM  : REACTING PROTONS=',
     *         NPRPRO,' NEUTRONS=',NNEPRO

C  TREAT INTERACTING NEUTRONS FROM PROJECTILE
        IF ( NNEPRO .GE. 1 ) THEN
          CURPAR(0) = 13.D0
          ITYPE     = 13
C  CALCULATE GAMMA, BETA AND ENERGY IN CENTER OF MASS
          GCM       = SQRT( GAMMA * 0.5D0 + 0.5D0 )
          ECM       = PAMA(ITYPE) * GCM * 2.D0
          BETACM    = SQRT( (GCM-1.D0)*(GCM+1.D0) ) / GCM
          DO  LL = 1, NNEPRO
            IF ( ECM .LE. HILOECM ) THEN

C  TARGET MATERIAL IS DECIDED IN FLULNK
              CALL FLULNK
            ELSE
C  DUAL PARTON MODEL
              CALL HDPM
            ENDIF
          ENDDO
        ENDIF

C  TREAT INTERACTING PROTONS FROM PROJECTILE IN SUBROUT. HDPM
        IF ( NPRPRO .GE. 1 ) THEN
          CURPAR(0) = 14.D0
          ITYPE     = 14
C  CALCULATE GAMMA, BETA AND ENERGY IN CENTER OF MASS
          GCM       = SQRT( GAMMA * 0.5D0 + 0.5D0 )
          ECM       = PAMA(ITYPE) * GCM * 2.D0
          BETACM    = SQRT( (GCM-1.D0)*(GCM+1.D0) ) / GCM
          DO  LL = 1, NPRPRO
            IF ( ECM .LE. HILOECM ) THEN

C  TARGET MATERIAL IS DECIDED IN FLULNK
              CALL FLULNK
            ELSE
C  DUAL PARTON MODEL
              CALL HDPM
            ENDIF
          ENDDO
        ENDIF
C  ALL PARTICLES, INCLUDING THE LEADING ONE, ARE NOW WRITTEN TO STACK

      ELSE

        WRITE(MONIOU,444) (CURPAR(I),I=0,9)

        WRITE(MONIOU,*) 'SDPM  : NOT FORESEEN PARTICLE TYPE=',ITYPE
        STOP
      ENDIF

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE STAEND

C-----------------------------------------------------------------------
C  STA(RT) END
C
C  SUBROUTINE FOR GETTING THE CONTROL PRINTOUT OF THE CONSTANT ARRAYS
C  PRINT CONTROL OUTPUT.
C  THIS SUBROUTINE IS CALLED FROM AAMAIN AND START.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRATMOS/ AATM,AATM0,BATM,BATM0,CATM,CATM0,DATM,MODATM
      DOUBLE PRECISION AATM(5),AATM0(5,0:22),BATM(5),BATM0(5,0:22),
     *                 CATM(5),CATM0(5,0:22),DATM(5)
      INTEGER          MODATM

      COMMON /CRATMOS2/HLAY,HLAY0,THICKL,LAYNO,LAYNEW
      DOUBLE PRECISION HLAY(6),HLAY0(5,0:9),THICKL(5)
      INTEGER          LAYNO(0:22)
      LOGICAL          LAYNEW

C  EXTERNAL ATMOSPHERIC MODELS
      COMMON /CRATMOSX/IATMOX,FREFRX
      INTEGER          IATMOX
      LOGICAL          FREFRX

      COMMON /CREDECAY/CETA
      DOUBLE PRECISION CETA(5)

      COMMON /CRKAONS/ CKA
      DOUBLE PRECISION CKA(80)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSTRBAR/CSTRBA
      DOUBLE PRECISION CSTRBA(11)

       

       

       

       

      DOUBLE PRECISION HEIGH
      INTEGER          I
      SAVE
      EXTERNAL         HEIGH
C-----------------------------------------------------------------------

C  PRINT CONTROL OUTPUT
      WRITE(MONIOU,103) (C(I),I=1,50)
  103 FORMAT (/,/' ',10('='),' CONSTANTS AND PARAMETERS ',43('=')
     *        /,/' PHYSICAL CONSTANTS C(1) TO C(50)',
     *        / (1P,4(E15.8,1X),E15.8) )
      WRITE(MONIOU,110) (CKA(I),I=1,80)
  110 FORMAT (/,/' CONSTANTS FOR KAONS CKA(1) TO CKA(80)'
     *        / (1P,4(E15.8,1X),E15.8) )
      WRITE(MONIOU,114) (CETA(I),I=1,5)
  114 FORMAT (/,/' CONSTANTS FOR ETAS CETA(1) TO CETA(5)'
     *        / (1P,4(E15.8,1X),E15.8) )
      WRITE(MONIOU,115) (CSTRBA(I),I=1,11)
  115 FORMAT (/,/' CONSTANTS FOR STRANGE BARYONS CSTRBA(1) TO ',
     *            'CSTRBA(11)'/ (1P,4(E15.8,1X),E15.8) )

      WRITE(MONIOU,200)
  200 FORMAT(/,/' ',10('='),' ATMOSPHERE ', 57('=')/ )

      IF     ( IATMOX .GE.  1 ) THEN
        WRITE(MONIOU,299) IATMOX
  299   FORMAT('  ( EXTERNAL ATMOSPHERE FROM TABLE',I3,' AS FITTED )'/)
      ELSEIF ( MODATM .EQ.  0 ) THEN

        WRITE(MONIOU,300)
  300   FORMAT('  ( ATMOSPHERE GIVEN BY INPUT (LAYER 5 UNCHANGED)')
      ELSEIF ( MODATM .EQ.  1 ) THEN
        WRITE(MONIOU,301)
  301   FORMAT('  ( US STANDARD ATMOSPHERE PARAMETRIZED BY LINSLEY )')
      ELSEIF ( MODATM .EQ.  2 ) THEN
        WRITE(MONIOU,302)
  302   FORMAT('  ( ATMOSPHERE AT115     PARAMETRIZED BY H. ULRICH )')
      ELSEIF ( MODATM .EQ.  3 ) THEN
        WRITE(MONIOU,303)
  303   FORMAT('  ( ATMOSPHERE AT223     PARAMETRIZED BY H. ULRICH )')
      ELSEIF ( MODATM .EQ.  4 ) THEN
        WRITE(MONIOU,304)
  304   FORMAT('  ( ATMOSPHERE AT511     PARAMETRIZED BY H. ULRICH )')
      ELSEIF ( MODATM .EQ.  5 ) THEN
        WRITE(MONIOU,305)
  305   FORMAT('  ( ATMOSPHERE AT616     PARAMETRIZED BY H. ULRICH )')
      ELSEIF ( MODATM .EQ.  6 ) THEN
        WRITE(MONIOU,306)
  306   FORMAT('  ( ATMOSPHERE AT822     PARAMETRIZED BY H. ULRICH )')
      ELSEIF ( MODATM .EQ.  7 ) THEN
        WRITE(MONIOU,307)
  307   FORMAT('  ( ATMOSPHERE AT1014    PARAMETRIZED BY H. ULRICH )')
      ELSEIF ( MODATM .EQ.  8 ) THEN
        WRITE(MONIOU,308)
  308   FORMAT('  ( ATMOSPHERE AT1224    PARAMETRIZED BY H. ULRICH )')
      ELSEIF ( MODATM .EQ.  9 ) THEN
        WRITE(MONIOU,309)
  309   FORMAT('  ( ATMOSPHERE GIVEN BY INPUT (LAYER 5 UNCHANGED)')
      ELSEIF ( MODATM .EQ. 10 ) THEN
        WRITE(MONIOU,310)
  310   FORMAT('  ( ATMOSPHERE GIVEN BY INPUT (LAYER 5 CHANGED) )')
      ELSEIF ( MODATM .EQ. 11 ) THEN
        WRITE(MONIOU,311)
  311   FORMAT('  ( SOUTH POLE ATMOSPHERE FOR 97MAR31 (MSIS-90-E) )')
      ELSEIF ( MODATM .EQ. 12 ) THEN
        WRITE(MONIOU,312)
  312   FORMAT('  ( SOUTH POLE ATMOSPHERE FOR 97JUL01 (MSIS-90-E) )')
      ELSEIF ( MODATM .EQ. 13 ) THEN
        WRITE(MONIOU,313)
  313   FORMAT('  ( SOUTH POLE ATMOSPHERE FOR 97OCT01 (MSIS-90-E) )')
      ELSEIF ( MODATM .EQ. 14 ) THEN
        WRITE(MONIOU,314)
  314   FORMAT('  ( SOUTH POLE ATMOSPHERE FOR 97DEC31 (MSIS-90-E) )')
      ELSEIF ( MODATM .EQ. 15 ) THEN
        WRITE(MONIOU,315)
  315   FORMAT('  ( SOUTH POLE ATMOSPHERE FOR JANUARY, LIPARI(GS) )')
      ELSEIF ( MODATM .EQ. 16 ) THEN
        WRITE(MONIOU,316)
  316   FORMAT('  ( SOUTH POLE ATMOSPHERE FOR AUGUST, LIPARI(GS) )')
      ELSEIF ( MODATM .EQ. 17 ) THEN
        WRITE(MONIOU,317)
  317   FORMAT('  ( MALARGUE ATMOSPHERE FOR WINTER I (KEILHAUER) )')
      ELSEIF ( MODATM .EQ. 18 ) THEN
        WRITE(MONIOU,318)
  318   FORMAT('  ( MALARGUE ATMOSPHERE FOR WINTER II (KEILHAUER) )')
      ELSEIF ( MODATM .EQ. 19 ) THEN
        WRITE(MONIOU,319)
  319   FORMAT('  ( MALARGUE ATMOSPHERE FOR SPRING (KEILHAUER) )')
      ELSEIF ( MODATM .EQ. 20 ) THEN
        WRITE(MONIOU,320)
  320   FORMAT('  ( MALARGUE ATMOSPHERE FOR SUMMER (KEILHAUER) )')
      ELSEIF ( MODATM .EQ. 21 ) THEN
        WRITE(MONIOU,321)
  321   FORMAT('  ( MALARGUE ATMOSPHERE FOR AUTUMN (KEILHAUER) )')
      ELSEIF ( MODATM .EQ. 22 ) THEN
        WRITE(MONIOU,322)
  322   FORMAT('  ( US STANDARD ATMOSPHERE PARAMETRIZED BY KEILHAUER )')

      ENDIF
      WRITE(MONIOU,400) (HLAY(I)*1.D-6,HLAY(I+1)*1.D-6,
     *                        AATM(I),BATM(I),CATM(I)*1.E-5,I=1,4),
     *            HLAY(5)*1.D-6,HLAY(6)*1.D-6,AATM(5),CATM(5)*1.E-5
  400 FORMAT('  HEIGHT H IN KM GIVES THICKNESS OF ATMOSPHERE T IN ',
     * 'G/CM**2'/1P,' H = ',F5.1,'...',F5.1,' KM ---> T = ',
     * E12.5,' +',E11.4,' * EXP( -H /',E11.4,')'/
     *              ' H = ',F5.1,'...',F5.1,' KM ---> T = ',
     * E12.5,' +',E11.4,' * EXP( -H /',E11.4,')'/
     *              ' H = ',F5.1,'...',F5.1,' KM ---> T = ',
     * E12.5,' +',E11.4,' * EXP( -H /',E11.4,')'/
     *              ' H = ',F5.1,'...',F5.1,' KM ---> T = ',
     * E12.5,' +',E11.4,' * EXP( -H /',E11.4,')'/
     *              ' H = ',F5.1,'...',F5.1,' KM ---> T = ',
     * E12.5,' - H /',E11.4 )

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE START

C-----------------------------------------------------------------------
C  START
C
C  PRINTS HEADER AND ALL SELECTED OPTIONS
C  PERFORMS INITIALIZATIONS AND CHECKS AT THE BEGINNING OF RUN.
C  CALLS DATAC TO READ IN DATA CARDS.
C  INITIALIZES ATMOSPHERIC MODELS
C  CHECKS AND INITIALIZES SELECTED HADRONIC INTERACTION MODEL.
C  THIS SUBROUTINE IS CALLED FROM AAMAIN.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRAIR/   COMPOS,PROBTA,AVERAW,AVOGDR
      DOUBLE PRECISION COMPOS(3),PROBTA(3),AVERAW,AVOGDR

      COMMON /CRATMOS/ AATM,AATM0,BATM,BATM0,CATM,CATM0,DATM,MODATM
      DOUBLE PRECISION AATM(5),AATM0(5,0:22),BATM(5),BATM0(5,0:22),
     *                 CATM(5),CATM0(5,0:22),DATM(5)
      INTEGER          MODATM

      COMMON /CRATMOS2/HLAY,HLAY0,THICKL,LAYNO,LAYNEW
      DOUBLE PRECISION HLAY(6),HLAY0(5,0:9),THICKL(5)
      INTEGER          LAYNO(0:22)
      LOGICAL          LAYNEW

C  EXTERNAL ATMOSPHERIC MODELS
      COMMON /CRATMOSX/IATMOX,FREFRX
      INTEGER          IATMOX
      LOGICAL          FREFRX

      COMMON /CRBUFFS/ RUNH,RUNE,EVTH,EVTE,DATAB,ARRAYLONG,LH
      INTEGER          MAXBUF,MAXLEN
      PARAMETER        (MAXLEN=16)

      PARAMETER        (MAXBUF=39*7)
      REAL             RUNH(MAXBUF),EVTH(MAXBUF),EVTE(MAXBUF),
     *                 RUNE(MAXBUF),DATAB(MAXBUF),ARRAYLONG(MAXBUF)
      INTEGER          LH
      CHARACTER*4      CRUNH,CRUNE,CEVTH,CEVTE,CLONG
      EQUIVALENCE      (RUNH(1),CRUNH), (RUNE(1),CRUNE)
      EQUIVALENCE      (EVTH(1),CEVTH), (EVTE(1),CEVTE)
      EQUIVALENCE      (ARRAYLONG(1),CLONG)

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRDPMFLG/NFLAIN,NFLDIF,NFLPI0,NFLCHE,NFLPIF,NFRAGM
      INTEGER          NFLAIN,NFLDIF,NFLPI0,NFLCHE,NFLPIF,NFRAGM

      COMMON /CREDECAY/CETA
      DOUBLE PRECISION CETA(5)

      COMMON /CRELABCT/ELCUT
      DOUBLE PRECISION ELCUT(4)

      COMMON /CRETHMAP/ECTMAP,ELEFT
      DOUBLE PRECISION ECTMAP,ELEFT

      COMMON /CRKAONS/ CKA
      DOUBLE PRECISION CKA(80)

      COMMON /CRMAGNET/BX,BZ,BVAL,BNORMC,BNORM,COSB,SINB,BLIMIT
      DOUBLE PRECISION BX,BZ,BVAL,BNORMC,BNORM,COSB,SINB,BLIMIT

      COMMON /CRMUMULT/CHC,OMC,PHISCT,STEPL,VSCAT,FMOLI
      DOUBLE PRECISION CHC,OMC,PHISCT,STEPL,VSCAT
      LOGICAL          FMOLI

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRNCSNCS/SIGN30,SIGN45,SIGN60,SIGO30,SIGO45,SIGO60,
     *                 SIGA30,SIGA45,SIGA60,PNOA30,PNOA45,PNOA60,
     *                 SIG30A,SIG45A,SIG60A
      DOUBLE PRECISION SIGN30(56),SIGN45(56),SIGN60(56),
     *                 SIGO30(56),SIGO45(56),SIGO60(56),
     *                 SIGA30(56),SIGA45(56),SIGA60(56),
     *                 PNOA30(1540,3),PNOA45(1540,3),PNOA60(1540,3),
     *                 SIG30A(56),SIG45A(56),SIG60A(56)

      COMMON /CRNKGI/  SEL,SELLG,STH,ZEL,ZELLG,ZSL,DIST,
     *                 DISX,DISY,DISXY,DISYX,DLAX,DLAY,DLAXY,DLAYX,
     *                 OBSATI,RADNKG,RMOL,TLEV,TLEVCM,IALT
      DOUBLE PRECISION SEL(10),SELLG(10),STH(10),ZEL(10),ZELLG(10),
     *                 ZSL(10),DIST(10),
     *                 DISX(-10:10),DISY(-10:10),
     *                 DISXY(-10:10,2),DISYX(-10:10,2),
     *                 DLAX (-10:10,2),DLAY (-10:10,2),
     *                 DLAXY(-10:10,2),DLAYX(-10:10,2),
     *                 OBSATI(2),RADNKG,RMOL(2),TLEV(10),TLEVCM(10)
      INTEGER          IALT(2)

      COMMON /CROBSPAR/OBSLEV,THCKOB,XOFF,YOFF,HEIGHP,THETAP,PHIP,
     *                 THETPR,PHIPR,

     *                 VUECON,

     *                 NOBSLV
      DOUBLE PRECISION OBSLEV(20),THCKOB(20),XOFF(20),YOFF(20),
     *                 HEIGHP,THETAP,THETPR(2),PHIP,PHIPR(2)

      DOUBLE PRECISION VUECON(2)

      INTEGER          NOBSLV

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRPRIMSP/PSLOPE,LLIMIT,ULIMIT,LL,UL,SLEX,ISPEC
      DOUBLE PRECISION PSLOPE,LLIMIT,ULIMIT,LL,UL,SLEX
      INTEGER          ISPEC

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSTACKF/STACKI,MSTACKP,MEXST,NSHIFT,NOUREC,ICOUNT,
     *                 NTO,NFROM
      INTEGER          MAXSTK

      PARAMETER        (MAXSTK = 17*256*2)
      DOUBLE PRECISION STACKI(MAXSTK)
      INTEGER          MSTACKP,MEXST,NSHIFT,NOUREC,ICOUNT,NTO,NFROM

      COMMON /CRSTRBAR/CSTRBA
      DOUBLE PRECISION CSTRBA(11)

      COMMON /CRVERS/  VERNUM,MVDATE,VERDAT
      DOUBLE PRECISION VERNUM
      INTEGER          MVDATE
      CHARACTER*18     VERDAT

      COMMON /CRCEREN3/CERCNT,DATAB2,NRECER,LHCER
      INTEGER          MAXBF2

      PARAMETER        ( MAXBF2 = 39 * 7 )

      DOUBLE PRECISION CERCNT
      REAL             DATAB2(MAXBF2)
      INTEGER          NRECER,LHCER

       

       

       

       

      COMMON /CRQGSC/  LEVLDQ,IQGSVER,FQGS,FQGSSG
      INTEGER          LEVLDQ,IQGSVER
      LOGICAL          FQGS,FQGSSG

      DOUBLE PRECISION HEIGH,OOO,TEMP1,TEMP2,TEMP3,THICK,
     *                 TTIME,ZE,ZS,ZX
      INTEGER          I,IA,J,L
      CHARACTER*1      MARK
      SAVE
      EXTERNAL         HEIGH,THICK
C-----------------------------------------------------------------------

C  SAY HELLO
      WRITE(MONIOU,112)
  112 FORMAT(/' ',80('A')/,/
     *'   OOO      OOO     OOOO       OOOO    OO   O      O      O   '/
     *'  O   O    O   O    O    O    O    O   OO   O    O       O O  '/
     *' O        O     O   O     O   O        OO   O  O        O   O '/
     *' O        O     O   O    O     OOOO    OO   OO         O     O'/
     *' O        O     O   OOOO           O   OO   O  O       OOOOOOO'/
     *'  O   O    O   O    O   O     O    O   OO   O    O     O     O'/
     *'   OOO      OOO     O     O    OOOO    OO   O      O   O     O'/
     *,/' COSMIC RAY SIMULATION FOR KASCADE'/,/
     *' A PROGRAM TO SIMULATE EXTENSIVE AIR SHOWERS IN ATMOSPHERE'/,/
     *' BASED ON A PROGRAM OF P.K.F. GRIEDER, UNIVERSITY BERN,',
     *' SWITZERLAND'/
     *' QGSJET-II MODEL ACCORDING TO S.S. OSTAPCHENKO, IEKP, KARLSRUHE',
     *' AND MSU, MOSCOW, RUSSIA'/
     *' HDPM MODEL ACCORDING TO J.N. CAPDEVIELLE, COLLEGE DE FRANCE,',
     *' PARIS, FRANCE'/

     *' FLUKA MODEL FROM A.FERRARI AND P.SALA, INFN MILAN, MILAN,',
     *' ITALY, AND CERN, GENEVA, SWITZERLAND'/
     *' FLUKA MODEL FROM A. FASSO (CERN), A. FERRARI, J. RANFT',
     *' (SIEGEN), AND  P. SALA, INFN MILAN, MILAN, ITALY'/

     *' EGS4 ACCORDING TO W.R. NELSON, H. HIRAYAMA, D.W.O. ROGERS,',
     *' SLAC, STANFORD, USA'/
     *' NKG FORMULAS FOR FAST SIMULATION OF EL.MAG. PARTICLES'/,/
     *' REFERENCES: D. HECK, J.KNAPP, J.N. CAPDEVIELLE, G. SCHATZ,',
     *     ' T. THOUW,'/'             REPORT FZKA 6019 (1998)'/

     *'             SEE ALSO WEB PAGE  http://www-ik.fzk.de/corsika/'/)

      MARK = '1'

      WRITE(MONIOU,912) VERNUM,MARK,VERDAT
  912 FORMAT(/'             INSTITUT FUER KERNPHYSIK '/
     *        '             FORSCHUNGSZENTRUM KARLSRUHE'/
     *        '             POSTFACH 3640'/
     *        '             D-76021 KARLSRUHE'/
     *        '             GERMANY'/,/
     *        ' IN CASE OF PROBLEMS CONTACT:   Dr. Tanguy Pierog'/
     *        '                      e-mail:   tanguy.pierog@ik.fzk.de'/
     *        '                         FAX:   (49) 7247-82-4075 '/
     *        '                       PHONE:   (49) 7247-82-8134 '/
     *        '   OR                       :   Dr. Dieter Heck '/
     *        '                      e-mail:   dieter.heck@ik.fzk.de'/
     *        '                         FAX:   (49) 7247-82-4075 '/
     *        '                       PHONE:   (49) 7247-82-3777 '/,/
     *        ' NUMBER OF VERSION : ',F6.3,A1/
     *        ' DATE   OF VERSION : ',A18 /)

      WRITE(MONIOU,*) 'VERSION GENERATED FOR UNIX OR COMPATIBLE SYSTEMS'
      WRITE(MONIOU,*) '^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^'

      WRITE(MONIOU,*) ' (RECL IS DEFINED IN BYTES)'
      WRITE(MONIOU,*) ' WITH NEW DATE_AND_TIME ROUTINE'
      WRITE(MONIOU,*) 'ZENITH ANGLE DEPENDENCE FOR FLAT DETECTOR ARRAY'

      WRITE(MONIOU,*) ' '

      WRITE(MONIOU,1003)
 1003 FORMAT(' INTERFACE FOR EXTERNAL ATMOSPHERIC PROFILES ENABLED'/
     *       ' ==================================================='/)
      WRITE(MONIOU,1044)
 1044 FORMAT(' CHERENKOV RADIATION IS GENERATED'/
     *       ' ================================'/)
      WRITE(MONIOU,1502)
 1502 FORMAT(' CURVED VERSION WITH SLIDING PLANAR ATMOSPHERE'/
     *       ' ============================================='/)
      WRITE(MONIOU,1632)
 1632 FORMAT(' PRIMARY DIRECTION IS SELECTED FROM VIEWING CONE'/
     *       ' ==============================================='/)

      WRITE(MONIOU,*) ' '
C

C  INITIALIZE ARRAY WITH PARTICLE MASSES
      CALL PAMAF

C  READ RUN STEERING DATA CARDS
      CALL DATAC

      IF ( FREFRX ) WRITE(MONIOU,144)
  144 FORMAT(/' ATMOSPHERIC REFRACTION IS TAKEN INTO ACCOUNT'/
     *        ' ============================================'/)

      WRITE(MONIOU,1441)
 1441 FORMAT(/)

C  ORDERING OF OBSERVATION LEVELS FROM TOP TO BOTTOM
      IF ( NOBSLV .GT. 1 ) THEN
  215 CONTINUE
        DO  I = 2, NOBSLV
          IF ( OBSLEV(I) .GT. OBSLEV(I-1) ) THEN
            OOO         = OBSLEV(I)
            OBSLEV(I)   = OBSLEV(I-1)
            OBSLEV(I-1) = OOO
            GOTO 215
          ENDIF
        ENDDO
      ENDIF
      IF ( NOBSLV .LT. 20 ) THEN
        DO  I = NOBSLV+1, 20
          OBSLEV(I) = 0.D0
        ENDDO
      ENDIF

C  PREPARE ATMOSPHERIC MODEL
      IF ( MODATM .LT. 0  .OR.  MODATM .GT. 22 ) THEN
        WRITE(MONIOU,*) 'START : MODATM < 0 OR > 22 NOT POSSIBLE! STOP'
        WRITE(MONIOU,*)
        WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
        WRITE(MONIOU,*) 'SEE KEYWORD: ATMOD'
        STOP
      ENDIF
C  SET LOWER BOUNDARIES OF THE AIR LAYERS
      IF ( LAYNEW ) THEN
C  TAKE THE BOUNDARIES READ IN
        I = 0
      ELSE
C  TAKE THE DEFAULT BOUNDARIES
        I = LAYNO(MODATM)
      ENDIF
C  SET THE SELECTED ATMOSPHERE AND LAYERS
      DO  L = 1, 5
        HLAY(L) = HLAY0(L,I)
        AATM(L) = AATM0(L,MODATM)
        BATM(L) = BATM0(L,MODATM)
        CATM(L) = CATM0(L,MODATM)
        DATM(L) = 1.D0 / CATM(L)
      ENDDO

C  SET THE ATMOSPHERIC MODEL NUMBER, READING AN EXTERNAL FILE IF NEEDED.
C  PARAMETERS FOR TAKING REFRACTION INTO ACCOUNT ARE CALCULATED EVEN
C  FOR CORSIKA BUILT-IN MODELS.
      IF ( IATMOX .GE. 1  .OR.  FREFRX ) THEN
        CALL ATMSET( IATMOX,OBSLEV(NOBSLV) )
      ENDIF
C  FOR AN EXTERNAL ATMOSPHERE, FIT PARAMETERS USED IN CORSIKA-EGS PART.
      IF ( IATMOX .GE. 1 ) THEN
        IF ( LAYNEW ) THEN
          CALL ATMFIT( -5,HLAY,AATM,BATM,CATM )
        ELSE
          CALL ATMFIT( 5,HLAY,AATM,BATM,CATM )
        ENDIF
        WRITE(MONIOU,*) 'FITTED ATMOSPHERIC PARAMETERS:'
        WRITE(MONIOU,*) 'AATM =',(AATM(L),L=1,5)
        WRITE(MONIOU,*) 'BATM =',(BATM(L),L=1,5)
        WRITE(MONIOU,*) 'CATM =',(CATM(L),L=1,5)
        DO  L = 1, 5
          DATM(L) = 1.D0 / CATM(L)
        ENDDO
      ENDIF

C  CALCULATE THICKNESS AT LOWER BOUNDARIES OF AIR LAYERS
      DO  L = 1, 5
        THICKL(L) = THICK( HLAY(L) )
      ENDDO
      HLAY(6) = HEIGH( 0.D0 )
      IF ( DEBUG ) WRITE(MDEBUG,99)
     $                        (L,HLAY(L),THICKL(L),L=1,5),HLAY(6)
   99 FORMAT(' START : ATMOSPHERIC LAYERS',/,
     $       '         NR.   HLAY (CM)        THICKL (G/CM**2)',/,
     $        5(8X,I3,'  ',E14.8,'   ',E14.8,/),
     $          8X,'  6  ',E14.8,'   0.00000')

C  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

C  CLEARS BUFFERS FOR HEADER AND FILLS IN PERMANENT INFORMATION
      DO  L = 1, MAXBUF
        EVTH(L)  = 0.
        EVTE(L)  = 0.
        RUNH(L)  = 0.
        RUNE(L)  = 0.
        DATAB(L) = 0.
        ARRAYLONG(L) = 0.

        DATAB2(L) = 0.

      ENDDO

C  PERMANENT INFORMATION
C  CHARACTER STRINGS
      CRUNH = 'RUNH'
      CRUNE = 'RUNE'
      CEVTH = 'EVTH'
      CEVTE = 'EVTE'
      CLONG = 'LONG'

      RUNH(2)  = NRRUN
      RUNE(2)  = NRRUN
      EVTH(44) = NRRUN

C  DATE OF RUN
      WRITE(MONIOU,101)
  101 FORMAT(/' ',10('='),' START OF RUN ',55('=')/)
      CALL PRTIME( TTIME )
      RUNH(3)  = TTIME
      EVTH(45) = TTIME

C  VERSION OF PROGRAM
      RUNH(4)  = VERNUM
      EVTH(46) = VERNUM

C-----------------------------------------------------------------------
C  INITIALIZATION FOR RANDOM NUMBER GENERATOR
C  2 SEQUENCES NEEDED BECAUSE MUON NUCLEAR INTERACTIONS USE EGS ROUTINES
      IF ( NSEQ .LT. 2 ) THEN
        WRITE(MONIOU,*)
        WRITE(MONIOU,*) 'TOO FEW RANDOM SEEDS: NSEQ =',NSEQ
        WRITE(MONIOU,*) 'AT MINIMUM TWO RANDOM SEEDS ARE NECESSARY'
        WRITE(MONIOU,*) 'USE THE DEFAULT SEED(S)'
        WRITE(MONIOU,*)
        NSEQ = 2
      ENDIF
C  CHERENKOV SELECTION DEMANDS ALWAYS EGS CALCULATION
      FEGS = .TRUE.
C  IN CASE OF CHERENKOV CALCULATIONS THE 3RD RANDOM SEQUENCE IS NEEDED
C  EVENTUALLY THE DEFAULT SEED IS USED
      IF ( NSEQ .LT. 3 ) NSEQ = 3
      DO  I = 1, NSEQ
        IF ( ISEED(2,I) .GT. 1000  .OR.  ISEED(3,I) .GT. 0 ) THEN
          IF ( .NOT. DEBUG   .AND.  .NOT. DEBDEL ) THEN
            WRITE(MONIOU,2811) I
 2811       FORMAT(/' #########################################'/
     *              ' ##  IMPROPER INITIALIZATION OF RANDOM  ##'/
     *              ' ##   NUMBER GENERATOR SEQUENCE',I6,'   ##'/
     *              ' ##     IS EXTREMELY TIME CONSUMING     ##'/
     *              ' ##     PLEASE READ THE USERS GUIDE     ##'/
     *              ' ##          SEE KEYWORD: SEED          ##'/
     *              ' #########################################'/)
          ELSE
            WRITE(MONIOU,2812) I
 2812       FORMAT(' RANDOM NUMBER GENERATOR SEQUENCE ',I6,
     *             ' IS NOW POSITIONED')
          ENDIF
        ENDIF
        CALL RMMAQD( ISEED(1,I),I,'S' )
      ENDDO
      KNOR = .TRUE.

      WRITE(MONIOU,158) (L,(ISEED(J,L),J=1,3),L=1,NSEQ)
  158 FORMAT (' RANDOM NUMBER GENERATOR AT BEGIN OF RUN :'/
     *        (' SEQUENCE = ',I2,'  SEED = ',I9,'  CALLS = ',I9,
     *         '  BILLIONS = ',I9))
      IF ( DEBUG ) WRITE(MONIOU,*)

C-----------------------------------------------------------------------
C  READ CROSS-SECTIONS AND PROBABILITIES FOR NUCLEUS-NUCLEUS COLLISIONS
      OPEN(UNIT=NUCNUC,FILE='NUCNUCCS',STATUS='OLD')
      READ(NUCNUC,500) SIGN30,SIGN45,SIGN60,SIGO30,SIGO45,SIGO60,
     *                 SIGA30,SIGA45,SIGA60
      READ(NUCNUC,500) (PNOA30(I,1),I=1,1540),(PNOA45(I,1),I=1,1540),
     *                 (PNOA60(I,1),I=1,1540),(PNOA30(I,2),I=1,1540),
     *                 (PNOA45(I,2),I=1,1540),(PNOA60(I,2),I=1,1540),
     *                 (PNOA30(I,3),I=1,1540),(PNOA45(I,3),I=1,1540),
     *                 (PNOA60(I,3),I=1,1540)
  500 FORMAT( 5E16.10 )
      CLOSE(UNIT=NUCNUC)

C  INELASTIC CROSS-SECTIONS FOR PROJECTICLE WITH MASS NUMBER IA
      DO  IA = 1, 56
        SIG30A(IA) = COMPOS(1)*SIGN30(IA) + COMPOS(2)*SIGO30(IA)
     *                                    + COMPOS(3)*SIGA30(IA)
        SIG45A(IA) = COMPOS(1)*SIGN45(IA) + COMPOS(2)*SIGO45(IA)
     *                                    + COMPOS(3)*SIGA45(IA)
        SIG60A(IA) = COMPOS(1)*SIGN60(IA) + COMPOS(2)*SIGO60(IA)
     *                                    + COMPOS(3)*SIGA60(IA)

        IF (DEBUG) WRITE(MDEBUG,544) IA,SIG30A(IA),SIG45A(IA),SIG60A(IA)
  544   FORMAT(' START : CROSS-SECTIONS A-AIR : A=',I2,1P,3E14.6)
      ENDDO
C  NOW OPEN THE VARIOUS FILES
c-----changed--add

Cc>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
      print *,'JCIO::========================================'
      print *,'JCIO:: Initializing JCIO system for advanced'
      print *,'JCIO:: saving of data.'
      print *,'JCIO::========================================'
C
Cc- initialize jcio system
C      
      call jcinitio(dsn,nrrun)
Cc- create file run######
C      call jcstartrun(runh)
Cc>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
C
C- Modified JCSTARTRUN creates cer###### and dat###### files !
C
C     ###### is the RUN number !
C

      call jcstartrun(RUNH)

C
C- write Run Header on cer and dat files  
CBC++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      CALL FILOPN

      WRITE(MONIOU,503)
  503 FORMAT (/,/' ',10('='),' INTERACTION MODELS ',49('='))
      IF ( FQGS ) THEN
        WRITE(MONIOU,*) 'QGSJET TREATS HIGH ENERGY HADRONIC',
     *                  ' INTERACTIONS'
        IF ( .NOT. FQGSSG ) THEN
          CALL QGSINI( 1 )
        ELSE
          WRITE(MONIOU,*)
          WRITE(MONIOU,*) 'QGSJET CROSS-SECTIONS ARE TAKEN'
          CALL QGSINI( 3 )
        ENDIF
      ELSE
        WRITE(MONIOU,1506)
        IF ( FQGSSG ) THEN
          WRITE(MONIOU,*)
          WRITE(MONIOU,*) 'QGSJET CROSS-SECTIONS ARE TAKEN'
          CALL QGSINI( 2 )
        ENDIF
      ENDIF
 1506 FORMAT(' HDPM ROUTINES TREAT HIGH ENERGY HADRONIC INTERACTIONS')

      IF ( .NOT. FQGS ) THEN

C  INPUT FLAGS FOR HDPM OPTIONS
      WRITE(MONIOU,*) 'HDPM GENERATOR SPECIFICATIONS ARE:'
      IF ( NFLAIN .EQ. 0 ) THEN
        WRITE(MONIOU,*) ' RANDOM NUMBER OF INTERACTIONS IN AIR TARGET'
        IF ( NFLDIF .EQ. 0 ) THEN
          WRITE(MONIOU,*) ' NO DIFFRACTIVE SECOND INTERACTIONS'
        ELSE
          WRITE(MONIOU,*) ' DIFFRACTIVE SECOND INTERACTIONS'
        ENDIF
      ELSE
        WRITE(MONIOU,*) ' FIXED NUMBER OF INTERACTIONS IN AIR TARGET'
      ENDIF
      IF ( NFLPI0 .EQ. 0 ) THEN
        WRITE(MONIOU,*) ' RAPIDITY OF PI0 ACCORDING TO COLLIDER DATA'
      ELSE
        WRITE(MONIOU,*) ' RAPIDITY OF PI0 SAME AS THAT OF CHARGED'
      ENDIF
      IF ( NFLPIF .EQ. 0 ) THEN
        WRITE(MONIOU,*) ' NO FLUCTUATIONS OF NUMBER OF PI0'
      ELSE
        WRITE(MONIOU,*) ' FLUCTUATIONS OF NUMBER OF PI0 AS MEASURED ',
     *         'AT THE COLLIDER'
      ENDIF
      IF ( NFLCHE .EQ. 0 ) THEN
        WRITE(MONIOU,*) ' CHARGE EXCHANGE INTERACTION POSSIBLE '
      ELSE
        WRITE(MONIOU,*) ' NO CHARGE EXCHANGE INTERACTION POSSIBLE '
      ENDIF

      ENDIF

      IF     ( NFRAGM .EQ. 0 ) THEN
        WRITE(MONIOU,*) ' TOTAL FRAGMENTION OF PRIMARY NUCLEUS IN ',
     *          'FIRST INTERACTION'
      ELSEIF ( NFRAGM .EQ. 1 ) THEN
        WRITE(MONIOU,*) ' NO FRAGMENTATION, NO EVAPORATION OF REMAINDER'

      ELSEIF ( NFRAGM .EQ. 2 ) THEN
        WRITE(MONIOU,*)'FRAGMENTATION WITH EVAPORATION (PT AFTER JACEE)'
      ELSEIF ( NFRAGM .EQ. 3 ) THEN
        WRITE(MONIOU,*)
     *    'FRAGMENTATION WITH EVAPORATION (PT AFTER GOLDHABER)'
      ELSE
        NFRAGM = 4
        WRITE(MONIOU,*) 'FRAGMENTATION WITH EVAPORATION (PT=0)'
      ENDIF
      WRITE(MONIOU,*)

C  LOW ENERGY HADRONIC INTERACTION MODEL
C  FLUKA TREATS LOW ENERGY HADRONIC INTERACTIONS
      WRITE(MONIOU,*) 'FLUKA TREATS LOW ENERGY HADRONIC ',
     *                  'INTERACTIONS'
      CALL FLUINI

C  WRITE HADRONIC STEERING FLAGS TO RUNHEADER
      RUNH(270) = NFLAIN
      RUNH(271) = NFLDIF
      RUNH(272) = NFLPI0 + 100. * NFLPIF
      RUNH(273) = NFLCHE + 100. * NFRAGM
      EVTH(65)  = NFLAIN
      EVTH(66)  = NFLDIF
      EVTH(67)  = NFLPI0
      EVTH(68)  = NFLPIF
      EVTH(69)  = NFLCHE
      EVTH(70)  = NFRAGM
      HILOECM   = SQRT( 2.D0*PAMA(14)*(PAMA(14) + HILOELB) )
      IF ( DEBUG ) THEN
        WRITE(MDEBUG,1509) HILOELB,HILOECM
 1509   FORMAT(' START: HIGH ENERGY INTERACTION MODEL USED ABOVE  ',
     *              F8.3,' GEV LAB ENERGY   OR',/
     *          50X,F8.3,' GEV CM  ENERGY')
      ELSE
        WRITE(MONIOU,1510) HILOELB,HILOECM
 1510    FORMAT(' HIGH ENERGY INTERACTION MODEL USED ABOVE  ',
     *              F8.3,' GEV LAB ENERGY   OR',/
     *          43X,F8.3,' GEV CM  ENERGY')
      ENDIF

C-----------------------------------------------------------------------
C  INITIALIZE CONSTANTS FOR MUON MULTIPLE SCATTERING (MOLIERE)
C  SEE SUBROUT. GMOLI OF GEANT321 (CERN)
      IF ( FMOLI ) THEN
        TEMP1 = COMPOS(1) *  7.D0 *  8.D0
        TEMP2 = COMPOS(2) *  8.D0 *  9.D0
        TEMP3 = COMPOS(3) * 18.D0 * 19.D0
        ZS  = TEMP1 + TEMP2 + TEMP3
        ZE  = (-TB3)*(TEMP1*LOG(7.D0)+TEMP2*LOG(8.D0)+TEMP3*LOG(18.D0))
        ZX  =  TEMP1*LOG(1.D0 + 3.34D0 * ( 7.D0/C(50))**2)
     *        +TEMP2*LOG(1.D0 + 3.34D0 * ( 8.D0/C(50))**2)
     *        +TEMP3*LOG(1.D0 + 3.34D0 * (18.D0/C(50))**2)
C  NOTE: CHC IS DEFINED DIFFERENT FROM GEANT WITHOUT DENSITY
        CHC = 0.39612D-3 * SQRT( ZS / AVERAW )
C  NOTE: OMC IS DEFINED DIFFERENT FROM GEANT WITHOUT DENSITY
        OMC = 6702.33D0 * (ZS/AVERAW) * EXP( (ZE-ZX)/ZS )
        EVTH(146) = 1.
        WRITE(MONIOU,*) 'MUON MULTIPLE SCATTERING AFTER MOLIERE'
      ELSE
        EVTH(146) = 0.
        WRITE(MONIOU,*)'MUON MULTIPLE SCATTERING IN GAUSS APPROXIMATION'
      ENDIF

C-----------------------------------------------------------------------
C  INPUT STEERING FLAGS FOR ELECTROMAGNETIC PART
      WRITE(MONIOU,*)
      IF ( FNKG ) THEN

        WRITE(MONIOU,2121)
 2121   FORMAT(' ######################################################'
     *     ,/, ' # SIMULATION WITH NKG NOT POSSIBLE IN CURVED VERSION #'
     *     ,/, ' ######################################################'
     *     ,/ )
        FNKG = .FALSE.
      ENDIF
C  WRITE STEERING FLAGS FOR ELECTROMAGNETIC PART AS REAL TO HEADER
      IF ( FNKG ) THEN

        RUNH(20) = 1.
        EVTH(74) = 1.

      ELSE
        RUNH(20) = 0.
        EVTH(74) = 0.
      ENDIF
      IF ( FEGS ) THEN

        RUNH(19) = 1.
        EVTH(73) = 1.

      ELSE
        RUNH(19) = 0.
        EVTH(73) = 0.
      ENDIF

      EVTH(95)  = STEPFC

C  PROGRAM CONFIGURATIONS FOR EVENT HEADER

      EVTH(75)  = 3.

      EVTH(76)  = 0.
      EVTH(139) = 0.
      EVTH(140) = 0.
      EVTH(141) = 0.
      EVTH(142) = 0.
      EVTH(143) = 0.
      EVTH(144) = 0.
      EVTH(145) = 0.
      IF ( FQGS ) THEN
        EVTH(76)  = 3.
      ELSE
        EVTH(76)  = 0.
      ENDIF
      IF ( FQGS ) THEN

        EVTH(141) = 3.

      ELSE
        EVTH(141) = 0.
      ENDIF
      IF ( FQGSSG ) THEN

        EVTH(142) = 3.

      ELSE
        EVTH(142) = 0.
      ENDIF
      EVTH(153) = VUECON(1)
      EVTH(154) = VUECON(2)

      EVTH(155) = HILOELB

C  ---------------------------------------------------------
C  ELEMENT 77 OF EVENT HEADER HAS THE FOLLOWING CONTENTS IF
C  CONVERTED TO AN INTEGER WITH SUITABLE ROUNDING APPLIED:
C  BIT  1: CERENKOV OPTION COMPILED IN
C       2: IACT OPTION COMPILED IN
C       3: CEFFIC OPTION COMPILED IN
C       4: ATMEXT OPTION COMPILED IN
C       5: ATMEXT OPTION USED WITH REFRACTION ENABLED
C       6: VOLUMEDET OPTION COMPILED IN
C       7: CURVED OPTION COMPILED IN (SEE ALSO EVTH(79))
C   11-21: TABLE NUMBER FOR EXTERNAL ATMOSPHERE TABLE
C          (BUT LIMITED TO 1023 IF THE NUMBER IS LARGER)
C  --------------------------------------------------------
      EVTH(77) = 1.

      EVTH(77) = EVTH(77) + 8.
      IF ( FREFRX ) EVTH(77) = EVTH(77) + 16.
      EVTH(77) = EVTH(77) + 1024. * MIN(IATMOX,1023)

      EVTH(77) = EVTH(77) + 64.

C     BIT 8 (VALUE 128) IS USED BY THE IACT INTERFACE.
      EVTH(78) = 0.

      EVTH(79) = 2.

      EVTH(80) = 3.

C-----------------------------------------------------------------------
C  PHYSICAL CONSTANTS
      PI  = 2.D0 * ACOS( 0.D0 )
      PI2 = 4.D0 * ACOS( 0.D0 )
      OB3 = 1.D0/3.D0
      TB3 = 2.D0/3.D0
      ENEPER  = EXP(1.D0)
      C(6)    = ( PAMA(5) / PAMA(11) )**2
      C(7)    = ( PAMA(5) / PAMA(8) )**2
      C(8)    = ( PAMA(5)**2 + PAMA(2)**2 ) * 0.5D0 / PAMA(5)
C  RATIO ELECTRON MASS BY MUON MASS AND DERIVED QUANTITIES
      C(15)   = 1.D0 + (PAMA(2) / PAMA(5))**2
      C(16)   = 2.D0 * PAMA(2) / PAMA(5)

      C(27)   = COS( C(26) )

      C(29)   = COS( C(28) )

C  CALCULATE CONSTANT FOR MAXIMAL HORIZONTAL RANGE WITHIN LOCAL SYSTEM
      C(4)    = (C(2)-C(3)) / THICK( 0.D0 )

C  EXTEND ANGULAR CUT UP TO HORIZONTAL FOR CURVED VERSION
      C(29)   = 1.D-15

      C(45)   = PAMA(8) * PAMA(14) * 2.D0
      C(46)   = PAMA(8)**2 + PAMA(14)**2
      C(48)   = (PAMA(8)**2 + PAMA(5)**2) / (2.D0*PAMA(8)*PAMA(5))
      C(49)   = SQRT( C(48)**2 - 1.D0 ) / C(48)

      CKA(13) = 2.D0 * PAMA(11) * PAMA(14)
      CKA(14) = PAMA(11)**2 + PAMA(14)**2
      CKA(17) = SQRT( ( (PAMA(11)**2 + PAMA(5)**2)
     *          / (2.D0*PAMA(11)) )**2 - PAMA(5)**2 )
      CKA(28) = SQRT( 1.D0 + CKA(17)**2 / PAMA(5)**2 )
      CKA(29) = SQRT( 1.D0 - 1.D0 / CKA(28)**2 )

C-----------------------------------------------------------------------
C  FILL CONSTANTS IN RUN HEADER
      DO  L = 1, 50
        RUNH(24+L)  = C(L)
        RUNH(154+L) = 0.
        RUNH(204+L) = 0.
      ENDDO
      DO  L = 1, 20
        RUNH(74+L)  = 0.
      ENDDO
      DO  L = 1, 40
        RUNH(94+L)  = CKA(L)
      ENDDO
      DO  L = 1, 5
        RUNH(134+L) = CETA(L)
      ENDDO
      DO  L = 1, 11
        RUNH(139+L) = CSTRBA(L)
      ENDDO
      DO  L = 1, 5
        RUNH(254+L) = AATM(L)
        RUNH(259+L) = BATM(L)
        RUNH(264+L) = CATM(L)
      ENDDO

C  INITIALIZE EGS4 PACKAGE AS IT IS USED FOR MUON NUCL. INTERACTION
      CALL EGSIN1
      IF ( .NOT. (FNKG  .OR.  FEGS) ) WRITE(MONIOU,*)
     *              'ELECTROMAGNETIC COMPONENT IS NOT SIMULATED'
      IF ( FEGS ) THEN
        WRITE(MONIOU,*) 'ELECTROMAGNETIC COMPONENT SIMULATED WITH EGS4'
        WRITE(MONIOU,*)
        IF ( STEPFC .GT. 10.D0  .OR.  STEPFC .LE. 0.D0 ) THEN
          WRITE(MONIOU,*) 'STEP LENGTH FACTOR FOR ELECTRON MULTIPLE ',
     *       'SCATTERING =',SNGL(STEPFC),' NOT CORRECT'
          WRITE(MONIOU,*)
          WRITE(MONIOU,*) 'PLEASE READ THE USERS GUIDE'
          WRITE(MONIOU,*) 'SEE KEYWORD: STEPFC'
          STOP
        ENDIF
        IF ( STEPFC .NE. 1.D0 ) WRITE(MONIOU,*)'STEP LENGTH ',
     *        'FACTOR FOR ELECTRON MULTIPLE SCATTERING =',SNGL(STEPFC)
C  READ EGSDAT FILE IN EGSIN2
        CALL EGSIN2
      ENDIF

      CALL STAEND

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE STRDEC

C-----------------------------------------------------------------------
C  STR(ANGE BARYON) DEC(AY)
C
C  ROUTINE TREATES DECAY OF STRANGE BARYONS (LAMBDA, SIGMA, XI, OMEGA)
C  DECAY WITH FULL KINEMATIC, ENERGY AND MOMENTA CONSERVED.
C  THIS SUBROUTINE IS CALLED FROM NUCINT.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRIRET/  IRET1,IRET2,IRETE
      INTEGER          IRET1,IRET2
      LOGICAL          IRETE

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSTRBAR/CSTRBA
      DOUBLE PRECISION CSTRBA(11)

       

       

       

       

      INTEGER          I
      SAVE
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,444) (CURPAR(I),I=0,9)
 444  FORMAT(' STRDEC: CURPAR=',1P,10E11.3)

      IF     ( ITYPE .EQ. 18 ) THEN
        CALL RMMARD( RD,1,1 )
        IF ( RD(1) .LT. CSTRBA(5) ) THEN
C  DECAY LAMBDA  --->  P + PI(-)
          CALL DECAY1( ITYPE,14,9 )
        ELSE
C  DECAY LAMBDA  --->  N + PI(0)
          CALL DECAY1( ITYPE,13,7 )
        ENDIF

      ELSEIF ( ITYPE .EQ. 19 ) THEN
        CALL RMMARD( RD,1,1 )
        IF ( RD(1) .LT. CSTRBA(6) ) THEN
C  DECAY SIGMA(+)  --->  P + PI(0)
          CALL DECAY1( ITYPE,14,7 )
        ELSE
C  DECAY SIGMA(+)  --->  N + PI(+)
          CALL DECAY1( ITYPE,13,8 )
        ENDIF

      ELSEIF ( ITYPE .EQ. 20  .OR.  ITYPE .EQ. 28 ) THEN
C  DECAY      SIGMA(0)  --->       LAMBDA + GAMMA
C  DECAY ANTI-SIGMA(0)  --->  ANTI-LAMBDA + GAMMA
        CALL DECAY1( ITYPE,ITYPE-2,1 )

      ELSEIF ( ITYPE .EQ. 21 ) THEN
C  DECAY SIGMA(-)  --->  N + PI(-)
        CALL DECAY1( ITYPE,13,9 )

      ELSEIF ( ITYPE .EQ. 22  .OR.  ITYPE .EQ. 30 ) THEN
C  DECAY      XI(0)  --->       LAMBDA + PI(0)
C  DECAY ANTI-XI(0)  --->  ANTI-LAMBDA + PI(0)
        CALL DECAY1( ITYPE,ITYPE-4,7 )

      ELSEIF ( ITYPE .EQ. 23 ) THEN
C  DECAY XI(-)  --->  LAMBDA + PI(-)
        CALL DECAY1( ITYPE,18,9 )

      ELSEIF ( ITYPE .EQ. 24  .OR.  ITYPE .EQ. 32 ) THEN
        CALL RMMARD( RD,1,1 )
        IF     ( RD(1) .LT. CSTRBA(10) ) THEN
C  DECAY      OMEGA(-)  --->       LAMBDA + K(-)
C  DECAY ANTI-OMEGA(+)  --->  ANTI-LAMBDA + K(+)
          CALL DECAY1( ITYPE,ITYPE-6,15-ITYPE/8 )
        ELSEIF ( RD(1) .LT. CSTRBA(11) ) THEN
C  DECAY      OMEGA(-)  --->       XI(0) + PI(-)
C  DECAY ANTI-OMEGA(+)  --->  ANTI-XI(0) + PI(+)
          CALL DECAY1( ITYPE,ITYPE-2,12-ITYPE/8 )
        ELSE
C  DECAY      OMEGA(-)  --->       XI(-) + PI(0)
C  DECAY ANTI-OMEGA(+)  --->  ANTI-XI(+) + PI(0)
          CALL DECAY1( ITYPE,ITYPE-1,7 )
        ENDIF

      ELSEIF ( ITYPE .EQ. 26 ) THEN
        CALL RMMARD( RD,1,1 )
        IF ( RD(1) .LT. CSTRBA(5) ) THEN
C  DECAY ANTI-LAMBDA  --->  ANTI-P + PI(+)
          CALL DECAY1( ITYPE,15,8 )
        ELSE
C  DECAY ANTI-LAMBDA  --->  ANTI-N + PI(0)
          CALL DECAY1( ITYPE,25,7 )
        ENDIF

      ELSEIF ( ITYPE .EQ. 27 ) THEN
        CALL RMMARD( RD,1,1 )
        IF ( RD(1) .LT. CSTRBA(6) ) THEN
C  DECAY ANTI-SIGMA(-)  --->  ANTI-P + PI(0)
          CALL DECAY1( ITYPE,15,7 )
        ELSE
C  DECAY ANTI-SIGMA(-)  --->  ANTI-N + PI(-)
          CALL DECAY1( ITYPE,25,9 )
        ENDIF

      ELSEIF ( ITYPE .EQ. 29 ) THEN
C  DECAY ANTI-SIGMA(+)  --->  ANTI-N + PI(+)
        CALL DECAY1( ITYPE,25,8 )

      ELSEIF ( ITYPE .EQ. 31 ) THEN
C  DECAY ANTI-XI(+)  --->  ANTI-LAMBDA + PI(+)
        CALL DECAY1( ITYPE,26,8 )

      ELSE

        WRITE(MONIOU,444) (CURPAR(I),I=0,9)

        WRITE(MONIOU,*) 'STRDEC: UNFORESEEN PARTICLE CODE =',ITYPE
      ENDIF
      IRET1 = 1

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      DOUBLE PRECISION FUNCTION THICK( ARG )

C-----------------------------------------------------------------------
C  THICK(NESS OF ATMOSPHERE)
C
C  CALCULATES THICKNESS (G/CM**2) OF ATMOSPHERE DEPENDING ON HEIGHT (CM)
C  THIS FUNCTION IS CALLED FROM AAMAIN, BOX2, BOX3, EM, INPRM, MUBREM,
C  MUDECY, MUPRPR, MUTRAC, NRANGC, NUCINT, PRANGC, START, UPDATC,
C  UPDATE, EGS4, ELECTR, HOWFAR, PHOTON, ININKG, NKG, AND CERENK.
C  ARGUMENT:
C   ARG    = HEIGHT IN CM
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRATMOS/ AATM,AATM0,BATM,BATM0,CATM,CATM0,DATM,MODATM
      DOUBLE PRECISION AATM(5),AATM0(5,0:22),BATM(5),BATM0(5,0:22),
     *                 CATM(5),CATM0(5,0:22),DATM(5)
      INTEGER          MODATM

      COMMON /CRATMOS2/HLAY,HLAY0,THICKL,LAYNO,LAYNEW
      DOUBLE PRECISION HLAY(6),HLAY0(5,0:9),THICKL(5)
      INTEGER          LAYNO(0:22)
      LOGICAL          LAYNEW

C  EXTERNAL ATMOSPHERIC MODELS
      COMMON /CRATMOSX/IATMOX,FREFRX
      INTEGER          IATMOX
      LOGICAL          FREFRX

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION ARG
      SAVE

      DOUBLE PRECISION THICKX
      EXTERNAL         THICKX

C-----------------------------------------------------------------------

CC    IF ( DEBUG ) WRITE(MDEBUG,*) 'THICK : ARG=',SNGL(ARG)

      IF ( IATMOX .GE. 1 ) THEN
        THICK = THICKX(ARG)
        RETURN
      ENDIF

      IF     ( ARG .LT. HLAY(2) ) THEN
        THICK = AATM(1) + BATM(1) * EXP ( (-ARG) * DATM(1) )
      ELSEIF ( ARG .LT. HLAY(3) ) THEN
        THICK = AATM(2) + BATM(2) * EXP ( (-ARG) * DATM(2) )
      ELSEIF ( ARG .LT. HLAY(4) ) THEN
        THICK = AATM(3) + BATM(3) * EXP ( (-ARG) * DATM(3) )
      ELSEIF ( ARG .LT. HLAY(5) ) THEN
        THICK = AATM(4) + BATM(4) * EXP ( (-ARG) * DATM(4) )
      ELSE
        THICK = AATM(5) - ARG * DATM(5)
      ENDIF

      RETURN
      END

*-- Author :    F. SCHROEDER UNI WUPPERTAL      17/09/98
C=======================================================================

      DOUBLE PRECISION FUNCTION THICKC( ARG )

C-----------------------------------------------------------------------
C  THICK(NESS IN CASE OF) C(URVED ATMOSPHERE)
C
C  CALCULATES THE ATMOSPHERIC THICKNESS AT INTERACTION POINT IN CURVED
C  COORDINATE SYSTEM AFTER TRANSPORTING THE PARTICLE BY CHI G/CM**2.
C  THIS FUNCTION IS CALLED FROM AAMAIN.
C  ARGUMENT:
C   ARG    = PENETRATED MATTER THICKNESS IN CURVED ATMOSPHERE (G/CM**2)
C
C  REDESIGN: D. HECK      IK   FZK KARLSRUHE
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRATMOS/ AATM,AATM0,BATM,BATM0,CATM,CATM0,DATM,MODATM
      DOUBLE PRECISION AATM(5),AATM0(5,0:22),BATM(5),BATM0(5,0:22),
     *                 CATM(5),CATM0(5,0:22),DATM(5)
      INTEGER          MODATM

      COMMON /CRATMOS2/HLAY,HLAY0,THICKL,LAYNO,LAYNEW
      DOUBLE PRECISION HLAY(6),HLAY0(5,0:9),THICKL(5)
      INTEGER          LAYNO(0:22)
      LOGICAL          LAYNEW

      COMMON /CROBSPAR/OBSLEV,THCKOB,XOFF,YOFF,HEIGHP,THETAP,PHIP,
     *                 THETPR,PHIPR,

     *                 VUECON,

     *                 NOBSLV
      DOUBLE PRECISION OBSLEV(20),THCKOB(20),XOFF(20),YOFF(20),
     *                 HEIGHP,THETAP,THETPR(2),PHIP,PHIPR(2)

      DOUBLE PRECISION VUECON(2)

      INTEGER          NOBSLV

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION ARG,AUXIL,CHIC,CHIMAX,CHIN,CORR,COSDIF,COSPHI,
     *                 COSTAPNEW,COSTHENEW,COSTHEOLD,DL,
     *                 HEIGH,HNEW,HOLD,SINDIF,SINI,SINPHI,SINTHE,
     *                 THCKHN,THCKHO,THICK,TRANS,TRANS2,WORK,
     *                 XNEW,XOLD,YNEW,YOLD
      INTEGER          IL

      SAVE
      EXTERNAL         HEIGH,THICK
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,*) 'THICKC: ARG=',SNGL(ARG),'H=',SNGL(H)

C  START VALUES
      CHIC   = ARG
      HNEW   = H
      XNEW   = X
      YNEW   = Y
      THCKHN = THICKH
      SINTHE = SQRT( (1.D0 - COSTHE) * (1.D0 + COSTHE) )
      IF ( SINTHE .NE. 0.D0 ) THEN
        COSPHI = PHIX / SINTHE
        SINPHI = PHIY / SINTHE
      ELSE
        COSPHI = 0.D0
        SINPHI = 0.D0
      ENDIF
      COSTAPNEW = COSTAP
      COSTHENEW = COSTHE

C  CHOPPING OF TOTAL PATH LENGTH CHITOT INTO SMALLER PIECES  AND
C  TRANSPORT IN LOCAL PLANE SYSTEM. STEP LENGTH LIMITATION DEPENDS ON
C  THICKNESS OF STARTING POINT. THIS NEEDS A LOOP OVER ALL SMALL PIECES
C  OF STEP WHICH ENDS AT MAXIMAL HORIZONTAL STEP

 2    CONTINUE
C  SAVE OLD LOCAL HEIGHT FOR TRANSFORMATION AFTER UPDATE
      HOLD   = HNEW
      XOLD   = XNEW
      YOLD   = YNEW
      COSTHEOLD = COSTHENEW
      IF ( DEBUG ) WRITE(MDEBUG,*) 'THICKC: CHIC,HOLD,THCKHN=',
     *                     SNGL(CHIC),SNGL(HOLD),SNGL(THCKHN)
C  LOOK WITHIN WHICH LAYER THE PARTICLE STARTS
      IF     ( HOLD .LE. HLAY(2) ) THEN
        IL = 1
      ELSEIF ( HOLD .LE. HLAY(3) ) THEN
        IL = 2
      ELSEIF ( HOLD .LE. HLAY(4) ) THEN
        IL = 3
      ELSE
        IL = 4
      ENDIF

C  LOOK FOR MAXIMAL STEP OF CHIN, ONLY IF NOT CLOSE TO VERTICAL
      IF ( COSTHEOLD .LT. 0.98D0 ) THEN

        SINI = DATM(IL) / SQRT( (1.D0-COSTHEOLD)*(1.D0+COSTHEOLD) )
        WORK = C(4) * THCKHN + C(3)
        IF ( DEBUG ) WRITE(MDEBUG,*) 'THICKC: SINI,WORK=',SINI,WORK
        IF ( HOLD .LT. HLAY(5) ) THEN
          CHIMAX = ( THCKHN - AATM(IL) ) * SINI *
     *                     ( WORK + 0.5D0*COSTHEOLD*SINI * WORK**2 )
        ELSE
          CHIMAX = WORK * SINI * DATM(5)/DATM(IL)
        ENDIF
        IF ( DEBUG ) WRITE(MDEBUG,301) CHIMAX
 301    FORMAT(' THICKC: CHIMAX=',F10.5,' TO NEXT ATMOSPHERIC BOUNDARY')
        IF ( CHIC .GE. CHIMAX ) THEN
          CHIN = CHIMAX
        ELSE
          CHIN = CHIC
        ENDIF
      ELSE
        CHIN = CHIC
      ENDIF

C  ACTUAL VALUES
      THCKHO = THCKHN
      THCKHN = THCKHO + CHIN * COSTHEOLD
      THCKHN = MAX( 0.D0, THCKHN)
C  NEW COORDINATE FRAME, NEW ACTUAL HEIGHT AT NEW THICKNESS GRADIENT
C  (CALCULATED WITH PARAMETERS OF OLD COORDINATE FRAME)
      HNEW   = HEIGH( THCKHN )
      IF ( DEBUG ) WRITE(MDEBUG,*) 'THICKC: CHIN,HOLD,HNEW=',
     *                     SNGL(CHIN),SNGL(HOLD),SNGL(HNEW)
C  CALCULATE TRANSPORT LENGTH DL
      DL   = (HOLD - HNEW) / COSTHEOLD

C  CALCULATE THE REMAINING MATTER TO BE PANETRATED
      CHIC = CHIC - CHIN
      IF ( DEBUG ) WRITE(MDEBUG,*) 'THICKC: CHIC,THCKHN,DL=',
     *                     SNGL(CHIC),SNGL(THCKHN),SNGL(DL)
C  HORIZONTAL STEP IS TRANS, TRANS2 IS TRANS**2
      TRANS2 = DL**2 * (1.D0 - COSTHEOLD)*(1.D0 + COSTHEOLD)
      TRANS  = SQRT( TRANS2 )
      IF ( DEBUG ) WRITE(MDEBUG,*) 'THICKC: HNEW,DL,TRANS=',
     *                     SNGL(HNEW),SNGL(DL),SNGL(TRANS)
      AUXIL  = SQRT( TRANS2 + (C(1)+HNEW)**2 )
C  CALCULATE ANGLE DIFFERENCE BETWEEN OLD AND NEW FRAME
      SINDIF = TRANS / AUXIL
      COSDIF = (C(1)+HNEW) / AUXIL
      IF ( DEBUG ) WRITE(MDEBUG,*) 'THICKC: HNEW,COSDIF,AUXIL=',
     *                     SNGL(HNEW),SNGL(COSDIF),SNGL(AUXIL)
      COSDIF = MIN( 1.D0, COSDIF )
C  X AND Y HAVE TO BE TRANSFORMED INTO 'EARTH'-COORDINATES (SPHERE)
C  TRANSPORT DISTANCE IS CORRECTED TO GET DISTANCE AT EARTHS SURFACE
      HNEW   = AUXIL - C(1)
      THCKHN = THICK( HNEW )
      IF ( SINDIF .NE. 0.D0 ) THEN
        CORR = C(1) * ASIN( SINDIF ) / ( (C(1)+HNEW) * SINDIF )
C  NOW CALCULATE COORDINATES IN NEW SYSTEM
        XNEW = XOLD + TRANS * COSPHI * CORR
        YNEW = YOLD + TRANS * SINPHI * CORR
      ELSE
        XNEW = XOLD
        YNEW = YOLD
      ENDIF
      IF ( DEBUG ) THEN
        WRITE(MDEBUG,*) 'THICKC: XNEW,YNEW,HNEW=',
     *          SNGL(XNEW),SNGL(YNEW),SNGL(HNEW)
      ENDIF
C  IF WE ARRIVE OBSLEVEL HEIGHT, THEN MODIFY ARRIVAL HEIGHT
c      IF ( XNEW*XOLD .Lt. 0.D0 .OR. YNEW*YOLD .Lt. 0.D0 ) THEN
cdh 20060619
      IF ( XNEW*PRMPAR(3) + YNEW*PRMPAR(4)
     *                 + (OBSLEV(1) - HNEW)*PRMPAR(2) .GT. 0.D0 ) THEN
        IF ( DEBUG ) WRITE(MDEBUG,*) 'THICKC: HNEW=',HNEW
        HNEW = OBSLEV(1)
        GOTO 999
      ENDIF
C  IN FIRST ORDER APPROXIMATION COSTHEOLD AND COSDIF ARE IN THE SAME
C  PLANE OF PARTICLE MOVEMENT, THEREFORE THE ANGLES MAY BE ADDED
C  DIRECTLY: COSINE OF THE ZENITH ANGLE IN THE NEW FRAME
      COSTHENEW = COSTHEOLD * COSDIF
     *              - SQRT( (1.D0-COSTHEOLD) * (1.D0+COSTHEOLD) *
     *                      (1.D0-COSDIF) * (1.D0+COSDIF) )
      COSTHENEW = MIN( 1.D0, COSTHENEW )
      IF (DEBUG) WRITE(MDEBUG,*) 'THICKC: COSTHENEW=',SNGL(COSTHENEW)
      IF ( COSTHENEW .LE. C(29) ) GOTO 999
C  LOOP BACK, IF NOT COMPLETE MATTER IS PENETRATED
      IF ( CHIC .GT. 0.D0 ) GOTO 2

 999  CONTINUE
      THCKHN = THICK( HNEW )
      THICKC = THCKHN
      IF (DEBUG) WRITE(MDEBUG,*) 'THICKC: THICKC=',SNGL(THICKC),
     *                           ' HNEW=',HNEW

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE TOBUF( A,IFL )

C-----------------------------------------------------------------------
C  (WRITE) TO BUF(FER)
C
C  WRITES UP TO NSUBBL DATA BLOCKS TO OUTPUT BUFFER AND PUTS THE FULL
C  BUFFER TO TAPE.
C  THIS SUBROUTINE IS CALLED FROM AAMAIN, ELECTR, INPRM, OUTEND,
C  OUTPT1, OUTPT2, AND PHOTON.
C  ARGUMENTS:
C   A      = ARRAY TO BE WRITTEN TO TAPE
C   IFL    = STARTING OF FINAL OUTPUT
C          = 0  NORMAL BLOCK
C          = 1  NORMAL BLOCK WITH END OF OUTPUT
C          = 2  ONLY END OF OUTPUT
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRBUFFS/ RUNH,RUNE,EVTH,EVTE,DATAB,ARRAYLONG,LH
      INTEGER          MAXBUF,MAXLEN
      PARAMETER        (MAXLEN=16)

      PARAMETER        (MAXBUF=39*7)
      REAL             RUNH(MAXBUF),EVTH(MAXBUF),EVTE(MAXBUF),
     *                 RUNE(MAXBUF),DATAB(MAXBUF),ARRAYLONG(MAXBUF)
      INTEGER          LH
      CHARACTER*4      CRUNH,CRUNE,CEVTH,CEVTE,CLONG
      EQUIVALENCE      (RUNH(1),CRUNH), (RUNE(1),CRUNE)
      EQUIVALENCE      (EVTH(1),CEVTH), (EVTE(1),CEVTE)
      EQUIVALENCE      (ARRAYLONG(1),CLONG)

      COMMON /CRRECORD/IRECOR
      INTEGER          IRECOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

C  NSUBBL IS NUMBER OF SUBBLOCKS IN ONE OUTPUT RECORD
      INTEGER          NSUBBL
      PARAMETER        (NSUBBL=21)
      REAL             A(*)

C  (OUTPUT RECORD LENGTH = NSUBBL * 39 * 7 * 4 BYTES  <= 22932 )

C  OUTPUT BUFFER FOR PARTICLE OUTPUT
      REAL             OUTBUF(MAXBUF,NSUBBL)
C  IBLK  IS  COUNTER FOR SUBBLOCKS
      INTEGER          I,K

      INTEGER          IBLK,IFL
      SAVE
      DATA             IBLK / 0 /
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,*) 'TOBUF : IFL =',IFL

C  COPY TO BUFFER
      IF ( IFL .LE. 1 ) THEN
        IBLK = IBLK + 1

        DO  I = 1, MAXBUF
          OUTBUF(I,IBLK) = A(I)
        ENDDO

      ENDIF

C  WRITE TO TAPE IF BLOCK IS FULL OR IF IFL IS 1
      IF ( IFL .GE. 1  .OR.  IBLK .EQ. NSUBBL ) THEN
        NRECS = NRECS + 1
        NBLKS = NBLKS + IBLK
        IF ( FPAROUT ) THEN
c------changed--add-and-comand
c          WRITE(MPATAP) ((OUTBUF(I,K),I=1,MAXBUF),K=1,NSUBBL)
        call jcdatsave(outbuf)
c>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
c------changed--add-and-comand
        ENDIF
        IRECOR = IRECOR + MAXBUF * NSUBBL
        IBLK   = 0
        DO  K = 1, NSUBBL
          DO  I = 1, MAXBUF
            OUTBUF(I,K) = 0.0
          ENDDO
        ENDDO
      ENDIF

      RETURN
      END

*-- Author :    Johannes Knapp, IEKP U Karlsruhe    26/01/1997
C=======================================================================

      SUBROUTINE TSTACK

C-----------------------------------------------------------------------
C  T(O) STACK
C
C  ADDS PARTICLE TO INTERMEDIATE STACK UNTIL REACTION IS FINISHED.
C  ONLY PARTICLES ABOVE ENERGY CUT ARE TAKEN TO STACK.
C  THIS SUBROUTINE IS CALLED FROM MANY ROUTINES  ALL OVER THE PROGRAM.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRBUFFS/ RUNH,RUNE,EVTH,EVTE,DATAB,ARRAYLONG,LH
      INTEGER          MAXBUF,MAXLEN
      PARAMETER        (MAXLEN=16)

      PARAMETER        (MAXBUF=39*7)
      REAL             RUNH(MAXBUF),EVTH(MAXBUF),EVTE(MAXBUF),
     *                 RUNE(MAXBUF),DATAB(MAXBUF),ARRAYLONG(MAXBUF)
      INTEGER          LH
      CHARACTER*4      CRUNH,CRUNE,CEVTH,CEVTE,CLONG
      EQUIVALENCE      (RUNH(1),CRUNH), (RUNE(1),CRUNE)
      EQUIVALENCE      (EVTH(1),CEVTH), (EVTE(1),CEVTE)
      EQUIVALENCE      (ARRAYLONG(1),CLONG)

      COMMON /CRELABCT/ELCUT
      DOUBLE PRECISION ELCUT(4)

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRTHNVAR/STACKINT,

     *                 INT_ICOUNT,MODETHN,THINNING

      INTEGER          MAXICOUNT
      PARAMETER        (MAXICOUNT=200000)

      DOUBLE PRECISION STACKINT(0:16,MAXICOUNT)
      INTEGER          INT_ICOUNT,MODETHN
      LOGICAL          THINNING

       

       

       

       

      INTEGER          I,J

      DOUBLE PRECISION ANCUT

      SAVE
C-----------------------------------------------------------------------

      INT_ICOUNT = INT_ICOUNT + 1

      IF ( DEBUG ) WRITE(MDEBUG,1) INT_ICOUNT,(SECPAR(J),J=0,9)
 1    FORMAT(' TSTACK:',I7,1X,1P,9E11.3,0P,F10.0)

      IF ( INT_ICOUNT .GT. MAXICOUNT ) THEN
        WRITE(MONIOU,10) MAXICOUNT
 10     FORMAT(' TSTACK: TOO MANY SECONDARIES FOR THIS REACTION',
     *     '  EXCEEDED ',I7,'   A T T E N T I O N  PARTICLE IS LOST')
        WRITE(MONIOU,*)'TSTACK: INCREASE PARAMETER  MAXICOUNT TO ',
     *                 ' CIRCUMVENT THIS PROBLEM.'
        INT_ICOUNT = INT_ICOUNT - 1
        STOP
*       RETURN
      ENDIF

C  CALCULATE APPROPRIATE KINETIC ENERGY CUT AND APPLY IT
      IF     ( SECPAR(0) .EQ. 5.D0  .OR.  SECPAR(0) .EQ. 6.D0 ) THEN
C  ---MUONS---
        IF ( (SECPAR(1) - 1.D0)*PAMA(5) .LT. ELCUT(2) ) THEN
          FMUORG = .FALSE.
          IF ( DEBUG ) WRITE(MDEBUG,*) 'TSTACK: PARTICLE BELOW ',
     *       'ENERGY CUT'
          INT_ICOUNT = INT_ICOUNT - 1
          IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

            DLONG(LHEIGH,5) = DLONG(LHEIGH,5) + SECPAR(1) * PAMA(5)

          ENDIF
          RETURN
        ENDIF

      ELSEIF ( SECPAR(0) .EQ. 2.D0  .OR.  SECPAR(0) .EQ. 3.D0 ) THEN
C  ---ELECTRONS---
        IF ( (SECPAR(1) - 1.D0)*PAMA(2) .LT. ELCUT(3) ) THEN
          IF ( DEBUG ) WRITE(MDEBUG,*) 'TSTACK: PARTICLE BELOW ',
     *       'ENERGY CUT'
          INT_ICOUNT = INT_ICOUNT - 1
          IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT
            IF ( SECPAR(0) .EQ. 2.D0 ) THEN
              DLONG(LHEIGH,3) = DLONG(LHEIGH,3)

     *                        + (SECPAR(1)+1.D0) * PAMA(2)
            ELSE
              DLONG(LHEIGH,3) = DLONG(LHEIGH,3)
     *                        + (SECPAR(1)-1.D0) * PAMA(2)

            ENDIF
          ENDIF
          RETURN
        ENDIF

      ELSEIF ( SECPAR(0) .EQ. 1.D0 ) THEN
C  ---GAMMAS---
        IF ( SECPAR(1) .LT. ELCUT(4) ) THEN
          IF ( DEBUG ) WRITE(MDEBUG,*) 'TSTACK: PARTICLE BELOW ',
     *       'ENERGY CUT'
          INT_ICOUNT = INT_ICOUNT - 1
          IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

            DLONG(LHEIGH,1) = DLONG(LHEIGH,1) + SECPAR(1)

          ENDIF
          RETURN
        ENDIF

      ELSEIF ( SECPAR(0) .EQ. 7.D0 ) THEN
C  ---PI(0)---  TAKE THRESHOLD OF GAMMAS
        IF ( (SECPAR(1)-1.D0)*PAMA(7) .LT. ELCUT(4) ) THEN
          IF ( DEBUG ) WRITE(MDEBUG,*) 'TSTACK: PARTICLE BELOW ',
     *       'GAMMA ENERGY CUT'
          INT_ICOUNT = INT_ICOUNT - 1
          IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT

            DLONG(LHEIGH,1) = DLONG(LHEIGH,1) + SECPAR(1) * PAMA(7)

          ENDIF
          RETURN
        ENDIF

      ELSEIF ( SECPAR(0) .GE. 200.D0 ) THEN
C  ---NUCLEI---, CUTTED IF ENERGY/NUCLEON BELOW CUT
        IF ( (SECPAR(1)-1.D0)*PAMA(NINT(SECPAR(0)))
     *                     .LT.   ELCUT(1)*NINT(SECPAR(0)/100.D0) ) THEN
          IF ( DEBUG ) WRITE(MDEBUG,*) 'TSTACK: PARTICLE BELOW ',
     *       'ENERGY CUT'
          INT_ICOUNT = INT_ICOUNT - 1
          IF ( LLONGI ) THEN
C  ADD KINETIC ENERGY TO LONGITUDINAL ENERGY DEPOSIT
            DLONG(LHEIGH,7) = DLONG(LHEIGH,7)
     *                      + ( SECPAR(1)*PAMA(NINT(SECPAR(0)))

     *                                - RESTMS(NINT(SECPAR(0))) )

          ENDIF
          RETURN
        ENDIF

      ELSEIF ( SECPAR(0) .EQ. 25.D0 ) THEN
C  ---ANTI-NEUTRONS--- (WITH MIN CUT OF 50 MEV)
        ANCUT = MAX( ELCUT(1), 0.05D0 )
        IF ( (SECPAR(1)-1.D0)*PAMA(25) .LT. ANCUT ) THEN
          IF ( DEBUG ) WRITE(MDEBUG,*) 'TSTACK: PARTICLE BELOW ',
     *       'ENERGY CUT'
          INT_ICOUNT = INT_ICOUNT - 1
          IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT
C  IN CASE OF NUCLEONS TAKE ONLY KINETIC ENERGY
C  IN CASE OF ANTINUCLEONS TAKE RELEASABLE ENERGY
            DLONG(LHEIGH,7) = DLONG(LHEIGH,7)

     *                  + ( SECPAR(1) * PAMA(25) - RESTMS(25) )

          ENDIF
          RETURN
        ENDIF

      ELSE
C  ---HADRONS---
        IF ( (SECPAR(1)-1.D0)*PAMA(NINT(SECPAR(0))) .LT. ELCUT(1) ) THEN
          IF ( DEBUG ) WRITE(MDEBUG,*) 'TSTACK: PARTICLE BELOW ',
     *       'ENERGY CUT'
          INT_ICOUNT = INT_ICOUNT - 1
          IF ( LLONGI ) THEN
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT
C  IN CASE OF NUCLEONS TAKE ONLY KINETIC ENERGY
C  IN CASE OF ANTINUCLEONS TAKE RELEASABLE ENERGY
            DLONG(LHEIGH,7) = DLONG(LHEIGH,7)
     *                  + ( SECPAR(1) * PAMA(NINT(SECPAR(0)))

     *                              - RESTMS(NINT(SECPAR(0))) )

          ENDIF
          RETURN
        ENDIF

      ENDIF

C  WRITE PARTICLE ABOVE CUT TO INTERMEDIATE STACK
      DO  I = 0, MAXLEN
        STACKINT(I,INT_ICOUNT) = SECPAR(I)
      ENDDO

      RETURN
      END

*-- Author :    Johannes Knapp, IEKP U Karlsruhe    26/01/1997
C=======================================================================

      SUBROUTINE TSTEND

C-----------------------------------------------------------------------
C  T(O) ST(ACK) END (OF REACTION)
C
C  MOVE INTERMEDIATE REACTION STACK TO THE REAL STACK
C  AND PERFORM THINNING, IF SELECTED.
C  THIS SUBROUTINE IS CALLED FROM AAMAIN, BOX3, AND PIGEN.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRBUFFS/ RUNH,RUNE,EVTH,EVTE,DATAB,ARRAYLONG,LH
      INTEGER          MAXBUF,MAXLEN
      PARAMETER        (MAXLEN=16)

      PARAMETER        (MAXBUF=39*7)
      REAL             RUNH(MAXBUF),EVTH(MAXBUF),EVTE(MAXBUF),
     *                 RUNE(MAXBUF),DATAB(MAXBUF),ARRAYLONG(MAXBUF)
      INTEGER          LH
      CHARACTER*4      CRUNH,CRUNE,CEVTH,CEVTE,CLONG
      EQUIVALENCE      (RUNH(1),CRUNH), (RUNE(1),CRUNE)
      EQUIVALENCE      (EVTH(1),CEVTH), (EVTE(1),CEVTE)
      EQUIVALENCE      (ARRAYLONG(1),CLONG)

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRREJECT/AVNREJ,ALTMIN,ANEXP,THICKA,THICKD,CUTLN,EONCUT,

     *                 FNPRIM
      DOUBLE PRECISION AVNREJ(20),ALTMIN(20),ANEXP(20),THICKA(20),
     *                 THICKD(20),CUTLN,EONCUT

      LOGICAL          FNPRIM

      COMMON /CRRESON/ RDRES,RESRAN,IRESPAR
      DOUBLE PRECISION RDRES(2),RESRAN(100000)
      INTEGER          IRESPAR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRTHNVAR/STACKINT,

     *                 INT_ICOUNT,MODETHN,THINNING

      INTEGER          MAXICOUNT
      PARAMETER        (MAXICOUNT=200000)

      DOUBLE PRECISION STACKINT(0:16,MAXICOUNT)
      INTEGER          INT_ICOUNT,MODETHN
      LOGICAL          THINNING

       

       

       

       

      INTEGER          I,K
      SAVE
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,1) INT_ICOUNT
 1    FORMAT(' TSTEND: TRANSFER INTERNAL REACTION STACK',
     *       ' WITH ',I6,' PARTICLES  ')

      IF ( INT_ICOUNT .LE. 0 ) RETURN

C  PUT ALL PARTICLES FROM INTERMEDIATE STACK TO REAL STACK
      DO  K = 1, INT_ICOUNT
        DO  I = 0, MAXLEN
          SECPAR(I) = STACKINT(I,K)
          STACKINT(I,K) = 0.D0
        ENDDO
        CALL TSTOUT
      ENDDO

      RETURN
      END

*-- Author :    Johannes Knapp, IEKP U Karlsruhe    26/01/1997
C=======================================================================

      SUBROUTINE TSTOUT

C-----------------------------------------------------------------------
C  T(O) ST(ACK) OUT
C
C  MAKE OUTPUT AFTER ONE INTERACTION HAS FINISHED
C  ADDS PARTICLE TO STACK AND WRITES IT TO DISK IF NECESSARY.
C  THIS SUBROUTINE IS CALLED FROM TSTEND.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRBUFFS/ RUNH,RUNE,EVTH,EVTE,DATAB,ARRAYLONG,LH
      INTEGER          MAXBUF,MAXLEN
      PARAMETER        (MAXLEN=16)

      PARAMETER        (MAXBUF=39*7)
      REAL             RUNH(MAXBUF),EVTH(MAXBUF),EVTE(MAXBUF),
     *                 RUNE(MAXBUF),DATAB(MAXBUF),ARRAYLONG(MAXBUF)
      INTEGER          LH
      CHARACTER*4      CRUNH,CRUNE,CEVTH,CEVTE,CLONG
      EQUIVALENCE      (RUNH(1),CRUNH), (RUNE(1),CRUNE)
      EQUIVALENCE      (EVTH(1),CEVTH), (EVTE(1),CEVTE)
      EQUIVALENCE      (ARRAYLONG(1),CLONG)

      COMMON /CRETHMAP/ECTMAP,ELEFT
      DOUBLE PRECISION ECTMAP,ELEFT

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSTACKF/STACKI,MSTACKP,MEXST,NSHIFT,NOUREC,ICOUNT,
     *                 NTO,NFROM
      INTEGER          MAXSTK

      PARAMETER        (MAXSTK = 17*256*2)
      DOUBLE PRECISION STACKI(MAXSTK)
      INTEGER          MSTACKP,MEXST,NSHIFT,NOUREC,ICOUNT,NTO,NFROM

       

       

       

       

      INTEGER          I,ISTK,J
      SAVE
      DATA             ISTK / MAXSTK /
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,666) ICOUNT,(SECPAR(J),J=0,9)
 666  FORMAT(' TSTOUT:',I7,1X,1P,9E11.3,0P,F10.0)

      IF ( MSTACKP .GE. ISTK ) THEN
        WRITE(MEXST,REC=NOUREC+1) (STACKI(I),I=       1,ISTK/2)
        WRITE(MEXST,REC=NOUREC+2) (STACKI(I),I=ISTK/2+1,ISTK )
        NOUREC = NOUREC + 2
        NSHIFT = NSHIFT + 2
        MSTACKP = 0
      ENDIF

      NTO    = NTO + 1
      ICOUNT = ICOUNT + 1

      DO  J = 0, MAXLEN
        STACKI(MSTACKP+J+1) = SECPAR(J)
      ENDDO
      MSTACKP = MSTACKP + MAXLEN + 1

      IF ( SECPAR(0) .LE. 1.D0 ) THEN

        ELEFT  = ELEFT + SECPAR(1)
      ELSE
        ELEFT  = ELEFT + SECPAR(1) * PAMA(NINT( SECPAR(0) ))

      ENDIF

      RETURN
      END

*-- Author :    F. SCHROEDER UNI WUPPERTAL      17/11/1998
C=======================================================================
c----change
      SUBROUTINE UPDATC( IPASC,FLAGMU,fmfb )
c---change
C-----------------------------------------------------------------------
C  UPDAT(ES PARTICLE PARAMETERS IN A) C(URVED ATMOSPHERE)
C
C  IN THE CASE THE HORIZONTAL COMPONENT OF THE TRACK IS TO LONG (> 20KM)
C  THE PARTICLE TRACK IS CHOPPED IN SEVERAL SHORTER TRACKS.
C  FOR EACH OF THESE CHOPPED TRACKS SUBR. UPDATE IS CALLED.
C  THIS SUBROUTINE IS CALLED FROM AAMAIN, BOX3, AND MUTRAC.
C  ARGUMENTS:
C   IPASC  = 0  TRANSPORT LEADS TO END OF RANGE OF PARTICLE
C            1  TRANSPORT LEADS TO OBSERVATION LEVEL
C   FLAGMU      FLAG INDICATING THE TRACKING OF MUONS
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRATMOS/ AATM,AATM0,BATM,BATM0,CATM,CATM0,DATM,MODATM
      DOUBLE PRECISION AATM(5),AATM0(5,0:22),BATM(5),BATM0(5,0:22),
     *                 CATM(5),CATM0(5,0:22),DATM(5)
      INTEGER          MODATM

      COMMON /CRATMOS2/HLAY,HLAY0,THICKL,LAYNO,LAYNEW
      DOUBLE PRECISION HLAY(6),HLAY0(5,0:9),THICKL(5)
      INTEGER          LAYNO(0:22)
      LOGICAL          LAYNEW

      COMMON /CRCORFRAM/DETSYS
      LOGICAL          DETSYS

      COMMON /CRGENER/ GEN,ALEVEL
      DOUBLE PRECISION GEN,ALEVEL

      COMMON /CRIRET/  IRET1,IRET2,IRETE
      INTEGER          IRET1,IRET2
      LOGICAL          IRETE

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRMAGNET/BX,BZ,BVAL,BNORMC,BNORM,COSB,SINB,BLIMIT
      DOUBLE PRECISION BX,BZ,BVAL,BNORMC,BNORM,COSB,SINB,BLIMIT

      COMMON /CRMUMULT/CHC,OMC,PHISCT,STEPL,VSCAT,FMOLI
      DOUBLE PRECISION CHC,OMC,PHISCT,STEPL,VSCAT
      LOGICAL          FMOLI

      COMMON /CROBSPAR/OBSLEV,THCKOB,XOFF,YOFF,HEIGHP,THETAP,PHIP,
     *                 THETPR,PHIPR,

     *                 VUECON,

     *                 NOBSLV
      DOUBLE PRECISION OBSLEV(20),THCKOB(20),XOFF(20),YOFF(20),
     *                 HEIGHP,THETAP,THETPR(2),PHIP,PHIPR(2)

      DOUBLE PRECISION VUECON(2)

      INTEGER          NOBSLV

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRTIMLIM/DSTLIM,TIMLIM
      DOUBLE PRECISION DSTLIM,TIMLIM

       

       

       

       

      DOUBLE PRECISION ARG,AUXIL,AUXILSQ,AUX2SQ,CHIC,CHIMAX,CHIN,CORR,
     *                 COSDIF,COSPHI,COSTHENEW,DSTEFF,
     *                 EDEPB,EDEPN,EDEP1,EFRST,GAMMAOLD,GAMMAN,
     *                 HEIGH,HNEW,HOLD,HOLDM,PHICOR,PHIXNEW,
     *                 PHIYNEW,RADINV,SINDIF,SINI,SINPHI,SINTEA,
     *                 SINTHE,STEPLC,STEPLO,STEPT,THCKHN,THCKHO,THICK,
     *                 THICKHOLD,TRANS2,WORK,XNEW,XOLD,YNEW,YOLD
      INTEGER          I,IL,IPASC,LPCT1,LPCT2
      LOGICAL          FLAGMU
      LOGICAL          IRETC
c-----changed--add
      logical fmfb
c-----changed--add

      DOUBLE PRECISION HNEWO
      REAL             TRID,TRE,TRX1,TRY1,TRZ1,TRT1,TRX2,TRY2,TRZ2,TRT2
      LOGICAL          LPLOTCNT

      SAVE
      EXTERNAL         HEIGH,THICK
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,457) (CURPAR(I),I=0,9),FLAGMU
  457 FORMAT(' UPDATC: CURPAR=',1P,10E11.3,0P/
     *       '         FLAGMU=',L2)

C  NOTE: ARG = PENETRATED MATTER THICKNESS HAS TO BE A CONSTANT
C        FOR THE WHOLE PARTICLE UPDATING
C        => LOOP OVER PIECES OF ARG (ALSO CONSTANTS FOR UPDATE)
C  START VALUES FOR LOOP OVER PENETRATED MATTER THICKNESS
      IRET2  = 0
C  STORE THE THICKNES CHI TO BE TRANSPORTED
      CHIC   = CHI
      ARG    = CHI
C  STORE THE PATH LENGTH STEPL DO BE TRANSPORTED
      IF ( FLAGMU ) THEN
        STEPLC = STEPL
      ELSE
        STEPLC = 0.D0
      ENDIF
      STEPLO = 0.D0
      HNEW   = H
      THCKHN = THICKH
      XNEW   = X
      YNEW   = Y
      SINTEA = SQRT( (1.D0-COSTEA)*(1.D0+COSTEA) )
      IF ( LLONGI ) THEN
        GAMMAOLD  = GAMMA
        THICKHOLD = THICKH

        LPCT1 = INT( THICKHOLD*THSTPI + 1.D0 )
        LPCT1 = MIN( LPCT1, NSTEP )

      ENDIF

      LPLOTCNT = .FALSE.

C  CHOPPING OF TOTAL PATH LENGTH CHIC INTO SMALLER PIECES  AND
C  TRANSPORT IN LOCAL PLANE SYSTEMS. STEP LENGTH LIMITATION DEPENDS ON
C  THICKNESS OF STARTING POINT. LOOP OVER ALL SMALL PIECES OF STEP

   2  CONTINUE

C  SAVE OLD LOCAL HEIGHT FOR TRANSFORMATION AFTER UPDATE
      HOLD   = HNEW
      XOLD   = XNEW
      YOLD   = YNEW
      IF ( DEBUG ) WRITE(MDEBUG,*) 'UPDATC: CHIC,HOLD,THCKHN=',
     *                     SNGL(CHIC),SNGL(HOLD),SNGL(THCKHN)

C RECORD END OF INTERMEDIATE STEP (IF MORE THAN 1)
      IF ( LPLOTCNT ) THEN
        AUXILSQ = SQRT( X**2 + Y**2 )
        COSTEA  = COS( AUXILSQ / C(1) )
        COSTEA  = MIN( 1.D0, COSTEA )
        HAPP    = (C(1)+HNEW) * COSTEA - C(1)

C  END OF THE TRACKING STEP
      IF ( PLOTSH ) THEN
        TRX2 = X
        TRY2 = Y
        TRZ2 = HAPP
        TRT2 = T
        IF ( ITYPE .EQ. 5  .OR.  ITYPE .EQ. 6 ) THEN
          WRITE(56) TRID,TRE,TRX1,TRY1,TRZ1,TRT1,TRX2,TRY2,TRZ2,TRT2

          NPLMU  = NPLMU + 1
        ELSE
          WRITE(57) TRID,TRE,TRX1,TRY1,TRZ1,TRT1,TRX2,TRY2,TRZ2,TRT2

          NPLHAD = NPLHAD + 1
        ENDIF
        IF ( DEBUG ) THEN

          WRITE(MDEBUG,2552) TRID,TRE,TRX1,TRY1,TRZ1,TRT1,
     *                                TRX2,TRY2,TRZ2,TRT2

        ENDIF
      ENDIF

C END OF INTERMEDIATE STEP
      ELSE
        LPLOTCNT = .TRUE.
      ENDIF

      IF ( PLOTSH ) THEN
C  BEGINNING OF TRACKING STEP
        TRID = ITYPE
        TRE  = PAMA(ITYPE)*GAMMA
        TRX1 = X
        TRY1 = Y
        TRZ1 = HAPP
        TRT1 = T
      ENDIF

C  LOOK WITHIN WHICH LAYER THE PARTICLE STARTS
      IF     ( HOLD .LE. HLAY(2) ) THEN
        IL = 1
      ELSEIF ( HOLD .LE. HLAY(3) ) THEN
        IL = 2
      ELSEIF ( HOLD .LE. HLAY(4) ) THEN
        IL = 3
      ELSE
        IL = 4
      ENDIF
C  LOOK FOR MAXIMAL STEP OF CHIN, ONLY IF NOT CLOSE TO VERTICAL
C  BEFORE ENTERING NEW ATMOSPHERIC LAYER
      IF ( COSTHE .LT. 0.98D0 ) THEN

        SINTHE =  SQRT( (1.D0-COSTHE)*(1.D0+COSTHE) )
        SINI = DATM(IL) / SINTHE
*       IF ( DEBUG ) WRITE(MDEBUG,*) 'UPDATC: SINI=',SINI
        WORK = C(4) * THCKHN + C(3)
        WORK = MIN( WORK, 1.D3*BLIMIT * GAMMA * PAMA(ITYPE) * SINTHE )
        IF ( HOLD .LT. HLAY(5) ) THEN
          CHIMAX = ( THCKHN - AATM(IL) ) * SINI *
     *             ( WORK + 0.5D0* ABS( COSTHE ) *SINI * WORK**2 )
        ELSE
          CHIMAX = WORK * SINI * DATM(5)/DATM(IL)
        ENDIF
        IF ( DEBUG ) WRITE(MDEBUG,*) 'UPDATC: WORK,CHIC,CHIMAX=',
     *                       SNGL(WORK),SNGL(CHIC),SNGL(CHIMAX)
        IF ( CHIC .GE. CHIMAX ) THEN
          CHIN = CHIMAX
        ELSE
          CHIN = CHIC
        ENDIF
      ELSE
C  NEARLY VERTICAL MOVEMENT
        WORK   = 1.D3 * BLIMIT * GAMMA * PAMA(ITYPE)
        HOLDM  = MIN( HLAY(6), MAX( HLAY(1), HOLD - COSTHE * WORK ) )
        CHIMAX = ABS( THICK( HOLDM ) - THICK( HOLD ) )
        IF ( DEBUG ) WRITE(MDEBUG,*) 'UPDATC: WORK,CHIC,CHIMAX=',
     *                       SNGL(WORK),SNGL(CHIC),SNGL(CHIMAX)
        IF ( CHIC .GE. CHIMAX ) THEN
          CHIN = CHIMAX
        ELSE
          CHIN = CHIC
        ENDIF
      ENDIF

C  CALCULATE VALUES FOR UPDATE
      THCKHO = THCKHN
      THCKHN = THCKHO + CHIN * COSTHE
      HNEW   = HEIGH( THCKHN )
      IF ( HOLD .LT. HNEW ) THEN

C  MAKE A SMALL STEP  OF 0.1 CM DEEPER DOWN INTO THE ATMOSPHERE
        HNEW   = HOLD - 0.1D0
        THCKHN = THICK( HNEW )
      ENDIF

C  CHECK WHETHER PARTICLE PASSES OBSERVATION LEVEL

      IF ( HNEW .LE. OBSLEV(1) ) THEN

        IF ( DEBUG ) WRITE(MDEBUG,558) COSTHE,H,X,Y
  558   FORMAT(' UPDATC: UNCORR COSTHE,H,X,Y=',1P,4E17.10,0P)
C  CORRECT PARTICLE COORDINATES FOR DETECTOR SYSTEM
C  FIRST CALCULATE  COSTAP AND HAPP IN OLD SYSTEM
        AUXILSQ = SQRT( X**2 + Y**2 )
        COSTEA  = COS( AUXILSQ / C(1) )
        COSTEA  = MIN( 1.D0, COSTEA )
        HAPP    = (C(1)+HOLD) * COSTEA - C(1)

C  REJECT PARTICLE WHICH TRAVERSES BELOW OBSERVATION LEVEL MEASURED
C  IN THE DETECTOR FRAME
*       IF ( HAPP .LT. OBSLEV(1) ) THEN
*         IRETC = .TRUE.
*         GOTO 200
*       ENDIF

C  REGARD WHETHER PARTICLE IS MOVING TOWARDS DETECTOR
C  EFFECTIVE DISTANCE TO DETECTOR CENTER IS DISTANCE TO POINT
C  OF FLIGHT PATH PROJECTION WHICH COMES CLOSEST TO DETECTOR CENTER
        SINTHE = SQRT( (1.D0-COSTHE) * (1.D0+COSTHE) )
        IF ( SINTHE .NE. 0.D0 ) THEN
          COSPHI = PHIX / SINTHE
          SINPHI = PHIY / SINTHE
        ELSE
          COSPHI = 0.D0
          SINPHI = 0.D0
        ENDIF
        DSTEFF = -( COSPHI*X + SINPHI*Y )
C  CALCULATE CORRECTION ANGLE DIF FROM EFFECTIVE DISTANCE
        SINDIF = SIN( DSTEFF / C(1) )
        COSDIF = SQRT( (1.D0-SINDIF)*(1.D0+SINDIF) )
        COSTHENEW = COSTHE*COSDIF - SINDIF*SINTHE
        IF ( DEBUG ) WRITE(MDEBUG,*) 'UPDATC: COSDIF,COSTHENEW=',
     *                     COSDIF,COSTHENEW
        COSTHE = MIN( 1.D0, COSTHENEW )

C  KILL HORIZONTAL OR UPWARD GOING PARTICLES
        IF ( COSTHE .LE. C(29) ) THEN
          IF ( DEBUG ) WRITE(MDEBUG,556) (CURPAR(I),I=0,9)
  556     FORMAT(' UPDATC: KILL 1=',1P,11E11.3)
          IRETC = .FALSE.
          GOTO 200
        ENDIF
C  ANGLE DIF MIGHT BE LARGE (DUE TO CUT ON HAPP)
        X = (HAPP+C(1)) * TAN( X/C(1) )
        Y = (HAPP+C(1)) * TAN( Y/C(1) )
        H = HAPP
        THICKH = THICK(H)
        IF ( DEBUG ) WRITE(MDEBUG,559) COSTHE,H,X,Y,THICKH
  559   FORMAT(' UPDATC: CORREC COSTHE,H,X,Y,THICKH=',
     *                   1P,5E14.7,0P)
        HNEW   = OBSLEV(1)
        THCKHN = THCKOB(1)
C  TRANSPORT ENDS AT OBSERVATION LEVEL
        IPASC  = 1

        DETSYS = .TRUE.
      ELSE
        IPASC  = 0
        DETSYS = .FALSE.
      ENDIF
      HNEWO    = HNEW

C  CALL UPDATE WITH NEW INPUT PARAMETERS ( HNEW,THCKHN,CURPAR(..) )
      CHI  = CHIN
c-----changed--add
      CALL UPDATE( HNEW,THCKHN,0,fmfb )
c-----changed--add
      CHIN = CHI
C  DECREMENT THE THICKNESS STILL TO BE TRAVERSED
      CHIC = CHIC - CHI
C  INCREMENT STEPLO BY THE LENGTH PERFORMED IN UPDATE
      IF ( FLAGMU ) STEPLO = STEPLO + STEPL
      IF ( DEBUG ) WRITE(MDEBUG,*) 'UPDATC: CHIC,CHIN=',CHIC,CHIN
      IF ( IRET2 .NE. 0 ) THEN
        IF ( IRETE ) THEN
C  PARTICLE SUFFERED FROM ENERGY CUT
          IRETC = IRETE
          GOTO 150
        ELSE
C  PARTICLE SUFFERED FROM ANGULAR CUT
          GOTO 200
        ENDIF
      ENDIF

C  KILL PARTICLE AS IT HAS BEEN STOPPED (MODIFIED HNEW IN UPDATE)
C  (NORMALLY BECAUSE OF ENERGY CUT)
C     IF ( HNEW .NE. HNEWO ) THEN
C       IRET2 = 1
C       IRETE = .TRUE.
C       IRETC = .TRUE.
C       GOTO 200
C     ENDIF

C  FOR CHARGED PARTICLES COSINE OF ZENITH ANGLE IS CALCULATED IN UPDATE.
C  KILL HORIZONTAL OR UPWARD GOING PARTICLES
      IF ( OUTPAR(2) .LE. C(29) ) THEN
        IRETC = .FALSE.
        GOTO 200
      ENDIF

C  FILL CURPAR WITH ACTUAL VALUES OF PARTICLE AFTER TRANSPORT IN UPDATE
C  OUTPAR(13-16) IS NOT MODIFIED IN UPDATE
      DO  I = 0, 8
        CURPAR(I) = OUTPAR(I)
      ENDDO
      THICKH = THCKHN
C  CHECK WHETHER PARTICLE EXCEEDS TIME LIMIT
      IF ( OUTPAR(6) .GT. TIMLIM ) THEN
        IRET2 = 1
        IRETC = .FALSE.
        GOTO 150
      ENDIF

      IF ( IPASC .EQ. 0 ) THEN
C  TRACK ENDS NOT AT OBSERVATION LEVEL
C  HORIZONTAL COMPONENT OF TRACK LENGTH SQUARED
        TRANS2 = (X-XOLD)**2 + (Y-YOLD)**2
C  TRANSPORT AT MINIMUM 1 MM
        TRANS2 = MAX( TRANS2, 0.01D0 )
C  NEW COORDINATE FRAME, NEW ACTUAL HEIGHT AT NEW THICKNESS GRADIENT
C  (CALCULATED WITH PARAMETERS OF OLD COORDINATE FRAME)
        AUXIL  = SQRT( TRANS2 + (C(1)+H)**2 )
        HNEW   = AUXIL - C(1)

        IF ( HNEW .GE. HLAY(6) ) THEN
C  KILL PARTICLE WHICH LEAVES ATMOSPHERE

          IF ( DEBUG ) WRITE(MDEBUG,*) 'UPDATC: HNEW=',HNEW,' KILL'
          HNEW   = HLAY(6)
          THCKHN = 0.D0
          IRET2  = 1
          IRETC  = .FALSE.
          GOTO 150
        ENDIF
        THCKHN = THICK( HNEW )
C  CALCULATE ANGLE DIFFERENCE BETWEEN OLD AND NEW FRAME
        SINDIF = SQRT( TRANS2 ) / AUXIL
        COSDIF = (C(1)+H) / AUXIL
        IF ( DEBUG ) WRITE(MDEBUG,560) COSDIF,SINDIF,H,HNEW
  560   FORMAT(' UPDATC: COSDIF,SINDIF,H,HNEW=',2F18.15,1P,2E17.9)
        COSDIF = MIN( 1.D0, COSDIF )
C  X AND Y HAVE TO BE TRANSFORMED INTO 'EARTH'-COORDINATES (SPHERE)
C  TRANSPORT DISTANCE IS CORRECTED TO GET DISTANCE AT EARTHS SURFACE
        CORR   = C(1) * ASIN( SINDIF ) / ( (C(1)+HNEW) * SINDIF )
        XNEW   = XOLD + (X-XOLD)*CORR
        X      = XNEW
        YNEW   = YOLD + (Y-YOLD)*CORR
        Y      = YNEW
        H      = HNEW
        THICKH = THICK(H)

C  IN FIRST ORDER APPROXIMATION COSTHE AND COSDIF ARE IN THE SAME PLANE
C  OF PARTICLE MOVEMENT, THEREFORE THE ANGLES MAY BE ADDED DIRECTLY
C  USE ADDITION THEOREM FOR (THETA + DELTA)
C  COS(THETA+DELTA)= COS(THETA)*COS(DELTA) - SIN(THETA)*SIN(DELTA)
        SINTHE    = SQRT( (1.D0-COSTHE)*(1.D0+COSTHE) )
        COSTHENEW = COSTHE*COSDIF  - SINDIF*SINTHE
        COSTHENEW = MIN( 1.D0, COSTHENEW )
C  PROTECTION AGAINST SINTHE=0
        IF ( SINTHE .NE. 0.D0 ) THEN
          PHICOR  = COSDIF + COSTHE * SINDIF /SINTHE
          PHIXNEW = PHIX * PHICOR
          PHIYNEW = PHIY * PHICOR
        ELSE
C  VERTICAL MOVEMENT OF PARTICLE: PHIX AND PHIY MUST BE 0 FOR SINTHE=0
          PHIXNEW = 0
          PHIYNEW = 0
        ENDIF
        COSTHE = COSTHENEW
        PHIX   = PHIXNEW
        PHIY   = PHIYNEW
        RADINV = 1.5D0 - 0.5D0 * ( PHIX**2 + PHIY**2 + COSTHE**2 )
        COSTHE = RADINV * COSTHENEW
        PHIX   = RADINV * PHIX
        PHIY   = RADINV * PHIY
C  KILL HORIZONTAL OR UPWARD GOING PARTICLES
        IF ( COSTHE .LE. C(29) ) THEN
          IF ( DEBUG ) WRITE(MDEBUG,555) (CURPAR(I),I=0,9)
  555     FORMAT(' UPDATC: KILL 0=',1P,11E11.3)
          IRETC = .FALSE.
          GOTO 200
        ENDIF

        IF ( DEBUG ) WRITE(MDEBUG,562) COSTEA,HAPP
  562   FORMAT(' UPDATC: COSTEA,HAPP=',F18.15,1P,E17.9)

        IF ( DEBUG ) WRITE(MDEBUG,557) (CURPAR(I),I=0,9)
  557   FORMAT(' UPDATC: STPEND=',1P,10E11.3,0P)

C  WE ARE NOT YET AT DETECTOR.
        IF ( FDECAY ) THEN
C  JUMP BACK IF NOT WHOLE CHIC OR STEPLC TRAVERSED
          IF ( CHIC .GT. 1.D-10  .AND.  STEPLO .LT. STEPLC ) GOTO 2
        ELSE
C  JUMP BACK IF NOT WHOLE CHIC TRAVERSED
          IF ( CHIC .GT. 1.D-10 ) GOTO 2
        ENDIF
C  RESTORE CHI IN COMMON CUPPAR FOR CORRECT USE IN MUTRAC
        CHI = ARG - CHIC
C  RESTORE STEPL IN COMMON MUMULT FOR CORRECT USE IN MUTRAC
        IF ( FLAGMU ) STEPL = STEPLO
        IF ( DEBUG ) WRITE(MDEBUG,*) 'UPDATC: CHI,STEPL=',
     *                             SNGL(CHI),SNGL(STEPL)

C  CALCULATE ANGLES IN THE NEW FRAME
        AUXILSQ = SQRT( X**2 + Y**2 )
        COSTEA  = COS( AUXILSQ / C(1) )
        COSTEA  = MIN( 1.D0, COSTEA )
        HAPP    = (C(1)+HNEW) * COSTEA - C(1)
        AUX2SQ  = SQRT( (C(1)+HNEW)**2 * (1.D0-COSTEA)*(1.D0+COSTEA)
     *                                       + (HAPP-OBSLEV(1))**2 )
        COSTAP  = (HAPP-OBSLEV(1)) / AUX2SQ
        IF ( DEBUG ) WRITE(MDEBUG,*) 'UPDATC: COSTAP,HAPP=',
     *                             SNGL(COSTAP),SNGL(HAPP)
        COSTAP  = MIN( 1.D0, COSTAP )
        OUTPAR(2) = COSTHE
        OUTPAR(3) = PHIX
        OUTPAR(4) = PHIY
        OUTPAR(7) = X
        OUTPAR(8) = Y

        IF ( HAPP .LT. OBSLEV(1) ) THEN

C  BRING PARTICLE TO OUTPUT WHICH MOVES BELOW OBSERVATION LEVEL
C  IN THE DETECTOR FRAME
          HAPP   = OBSLEV(1)
          H      = OBSLEV(1)
          THCKHN = THCKOB(1)
          IF ( DEBUG ) WRITE(MDEBUG,*) 'UPDATC: HAPP=',HAPP
          IF ( DEBUG ) WRITE(MDEBUG,*) 'UPDATC: CORRECTED HEIGHT=',H
          IPASC  = 1
        ENDIF
        OUTPAR(5) = H
      ELSE
        HAPP   = OBSLEV(1)
        H      = OBSLEV(1)
        THCKHN = THCKOB(1)
      ENDIF

 150  IF ( LLONGI ) THEN
C  THE PARTICLE IS TRACKED FROM THICKHOLD DOWN TO THCKHN

*       IF ( THCKHN .LT. 0.D0  .OR.  
*    *       THCKHN .GT. THSTEP*(NSTEP+1) ) THEN
*         WRITE(MONIOU,*) 'UPDATC: LIMIT REACHED FOR LPCT2'
*         WRITE(MONIOU,*) 'UPDATC: THCKHN',THCKHN
*       ENDIF
        LPCT2 = INT( THCKHN*THSTPI )
        LPCT2 = MAX( LPCT2, 0 )
        LPCT2 = MIN( LPCT2, NSTEP + 1 )

C  TOTAL PATH LENGTH IN UNITS OF LONGI BINS

        STEPT = (THCKHN - THICKHOLD) * THSTPI

        IF ( SIGNUM(ITYPE) .NE. 0.D0 ) THEN
C  CHARGED PARTICLES
          GAMMAN = OUTPAR(1)

C  CHARGED PARTICLES SUFFER IONIZATION LOSS.
C  WE ASSUME HOMOGENEOUS ENERGY DEPOSIT ALONG PATH
            IF ( STEPT .GT. 0.D0 ) THEN
C  IONIZATION ENERGY DEPOSED IN EACH BIN

              EDEPB = PAMA(ITYPE) * (GAMMAOLD - GAMMAN) / STEPT

            ELSE
              EDEPB = 0.D0
            ENDIF
C  ENERGY DEPOSIT IN FIRST BIN

            EDEP1 = EDEPB * (DBLE(LPCT1) - THICKHOLD*THSTPI)

C  ENERGY AT FIRST BIN BOUNDARY

            EFRST = PAMA(ITYPE) * GAMMAOLD - EDEP1

            IF ( LPCT2 .LT. LPCT1 ) THEN
C  SMALL STEP

              EDEPN = EDEPB * (THCKHN*THSTPI - DBLE(LPCT1))

              IF ( IPASC .NE. 0 ) THEN
C  PARTICLE MOVES NEARLY HORIZONTAL TO DETECTOR, LAST STEP WAS SMALLER
C  THAN LONGITUDINAL BINNING, THEREFORE LPCT2 < LPCT1.
                LPCT2 = NSTEP
              ENDIF
            ELSE
C  STEP LONGER THAN ONE LONGITUDINAL BIN GIVES LPCT2 >= LPCT1
              IF ( IPASC .EQ. 0 ) THEN

                EDEPN = MAX( 0.D0, EDEPB*(THCKHN*THSTPI - DBLE(LPCT2)) )
              ELSE
C  PARTICLE ARRIVES AT DETECTOR
                LPCT2 = MIN( LPCT2, NSTEP )

                EDEPN = 0.D0
              ENDIF
            ENDIF

C  NOW FILL FIRST AND LAST+1 BIN, THEN LOOP OVER THE BINS BETWEEN
            IF     ( ITYPE .EQ. 5 ) THEN
C  MUON(+) LONGITUDINAL DEVELOPMENT FOR DEPOSIT, ENERGY, PARTICLES
              DLONG(LPCT1  ,4) = DLONG(LPCT1  ,4) + EDEP1
              DLONG(LPCT2+1,4) = DLONG(LPCT2+1,4) + EDEPN
              IF ( LPCT2 .GE. LPCT1 ) THEN
                ELONG(LPCT2,4) = ELONG(LPCT2,4)
     *                             + ( EFRST - (LPCT2-LPCT1) * EDEPB )

                PLONG(LPCT2,4) = PLONG(LPCT2,4) + 1.D0

              ENDIF
            ELSEIF ( ITYPE .EQ. 6 ) THEN
C  MUON(-) LONGITUDINAL DEVELOPMENT FOR DEPOSIT, ENERGY, PARTICLES
              DLONG(LPCT1  ,4) = DLONG(LPCT1  ,4) + EDEP1
              DLONG(LPCT2+1,4) = DLONG(LPCT2+1,4) + EDEPN
              IF ( LPCT2 .GE. LPCT1 ) THEN
                ELONG(LPCT2,5) = ELONG(LPCT2,5)
     *                             + ( EFRST - (LPCT2-LPCT1) * EDEPB )

                PLONG(LPCT2,5) = PLONG(LPCT2,5) + 1.D0

              ENDIF
            ELSEIF ( ITYPE .LT. 200 ) THEN
C  CHARGED HADRON LONGITUD. DEVELOPMENT FOR DEPOSIT, ENERGY, PARTICLES
              DLONG(LPCT1  ,6) = DLONG(LPCT1  ,6) + EDEP1
              DLONG(LPCT2+1,6) = DLONG(LPCT2+1,6) + EDEPN
              IF ( LPCT2 .GE. LPCT1 ) THEN
                ELONG(LPCT2,6) = ELONG(LPCT2,6)
     *                             + ( EFRST - (LPCT2-LPCT1) * EDEPB )
                ELONG(LPCT2,7) = ELONG(LPCT2,7)
     *                             + ( EFRST - (LPCT2-LPCT1) * EDEPB )
                PLONG(LPCT2,6) = PLONG(LPCT2,6) + 1.D0
                PLONG(LPCT2,7) = PLONG(LPCT2,7) + 1.D0

              ENDIF
            ELSE
C  NUCLEI LONGITUDINAL DEVELOPMENT FOR DEPOSIT, ENERGY, PARTICLES
              DLONG(LPCT1  ,6) = DLONG(LPCT1  ,6) + EDEP1
              DLONG(LPCT2+1,6) = DLONG(LPCT2+1,6) + EDEPN
              IF ( LPCT2 .GE. LPCT1 ) THEN
                ELONG(LPCT2,8) = ELONG(LPCT2,8)
     *                             + ( EFRST - (LPCT2-LPCT1) * EDEPB )

                PLONG(LPCT2,8) = PLONG(LPCT2,8) + 1.D0

              ENDIF
            ENDIF

C  LOOP OVER ALL LONGITUDINAL BINS
            IF ( LPCT2 .GT. LPCT1 ) THEN
              DO  IL = LPCT1, LPCT2-1
                IF     ( ITYPE .EQ. 5 ) THEN
C  MUON(+) LONGITUDINAL DEVELOPMENT FOR DEPOSIT, ENERGY, PARTICLES
                  DLONG(IL+1,4) = DLONG(IL+1,4) + EDEPB
                  ELONG(IL,4) = ELONG(IL,4) + ( EFRST-(IL-LPCT1)*EDEPB )

                  PLONG(IL,4) = PLONG(IL,4) + 1.D0

                ELSEIF ( ITYPE .EQ. 6 ) THEN
C  MUON(-) LONGITUDINAL DEVELOPMENT FOR DEPOSIT, ENERGY, PARTICLES
                  DLONG(IL+1,4) = DLONG(IL+1,4) + EDEPB
                  ELONG(IL,5) = ELONG(IL,5) + ( EFRST-(IL-LPCT1)*EDEPB )

                  PLONG(IL,5) = PLONG(IL,5) + 1.D0

                ELSEIF ( ITYPE .LT. 200 ) THEN
C  CHARGED HADRON LONGITUDINAL DEVELOPMENT FOR DEPOSIT, ENERGY, PARTICLES
                  DLONG(IL+1,6) = DLONG(IL+1,6) + EDEPB
                  ELONG(IL,6) = ELONG(IL,6) + ( EFRST-(IL-LPCT1)*EDEPB )
                  ELONG(IL,7) = ELONG(IL,7) + ( EFRST-(IL-LPCT1)*EDEPB )
                  PLONG(IL,6) = PLONG(IL,6) + 1.D0
                  PLONG(IL,7) = PLONG(IL,7) + 1.D0

                ELSE
C  NUCLEI LONGITUDINAL DEVELOPMENT FOR DEPOSIT, ENERGY, PARTICLES
                  DLONG(IL+1,6) = DLONG(IL+1,6) + EDEPB
                  ELONG(IL,8) = ELONG(IL,8) + ( EFRST-(IL-LPCT1)*EDEPB )

                  PLONG(IL,8) = PLONG(IL,8) + 1.D0

                ENDIF
              ENDDO
            ENDIF

        ELSE
C  NEUTRAL PARTICLES
C  LONGITUDINAL DISTRIBUTIONS FOR NEUTRAL HADRONS WITHOUT NEUTRINOS
C  THE PARTICLE IS TRACKED FROM THICKH DOWN TO THCKHN
C  COUNT THE PARTICLES FOR THE LONGITUDINAL DEVELOPMENT
          IF ( (ITYPE .GE.  7  .AND.  ITYPE .LE. 32)  .OR.
     *         (ITYPE .GE. 71  .AND.  ITYPE .LE. 74) ) THEN
            IF ( IPASC .NE. 0 ) THEN
C  PARTICLE ARRIVES AT DETECTOR
              LPCT2 = NSTEP
            ENDIF
            DO  IL = LPCT1, LPCT2

              ELONG(IL,6) = ELONG(IL,6) + GAMMA * PAMA(ITYPE)
              PLONG(IL,6) = PLONG(IL,6) + 1.D0
            ENDDO
          ENDIF
        ENDIF
        IF ( IRET2 .NE. 0  .AND.  IRETE ) THEN
C  FILL REMAINING CUTTED ENERGY INTO LONGI BIN AT ENERGY CUTTING POINT
          LHEIGH = LPCT2
          IF ( ITYPE .EQ. 5  .OR.  ITYPE .EQ. 6 ) THEN

            DLONG(LHEIGH,5) = DLONG(LHEIGH,5) + GAMMAN*PAMA(5)
          ELSE
            DLONG(LHEIGH,7) = DLONG(LHEIGH,7) + GAMMAN*PAMA(ITYPE)
     *                                        - RESTMS(ITYPE)

          ENDIF
C  ELIMINATE PARTICLE FALLING BELOW ENERGY CUT
          RETURN
        ENDIF
      ENDIF
C  ELIMINATE PARTICLE FALLING BELOW ENERGY CUT
      IF ( IRET2 .NE. 0  .AND.  IRETE ) RETURN
C  ELIMINATE PARTICLE MOVING OUT OF ATMOSPHERE OR EXCEEDING TIME LIMIT
      IF ( IRET2 .NE. 0  .AND.  .NOT.IRETC ) GOTO 200

C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

C  TRANSPORT TO END OF TRACK
      IF ( IPASC .EQ. 0 ) THEN
        ALEVEL = H
        BETA   = SQRT( (GAMMA-1.D0)*(GAMMA+1.D0) ) / GAMMA
        THICKH = THCKHN
      ELSE
C  TRANSPORT TO OBSERVATION LEVEL AND BRING TO OUTPUT
C  COORDINATE SYSTEM AT END OF TRACK HAS TO BE DETECTOR FRAME
        LEVL = 1
        CALL OUTPT1
      ENDIF

C  END OF THE TRACKING STEP
      IF ( PLOTSH ) THEN
        TRX2 = OUTPAR(7)
        TRY2 = OUTPAR(8)
        TRZ2 = HAPP
        TRT2 = OUTPAR(6)
        IF ( ITYPE .EQ. 5  .OR.  ITYPE .EQ. 6 ) THEN
          WRITE(56) TRID,TRE,TRX1,TRY1,TRZ1,TRT1,TRX2,TRY2,TRZ2,TRT2

          NPLMU  = NPLMU + 1
        ELSE
          WRITE(57) TRID,TRE,TRX1,TRY1,TRZ1,TRT1,TRX2,TRY2,TRZ2,TRT2

          NPLHAD = NPLHAD + 1
        ENDIF
        IF ( DEBUG ) THEN

          WRITE(MDEBUG,2552) TRID,TRE,TRX1,TRY1,TRZ1,TRT1,
     *                                TRX2,TRY2,TRZ2,TRT2
 2552     FORMAT(' TRACKINF ',1P,6E15.5,/,40X,4E15.5)

        ENDIF
      ENDIF

      RETURN

 200  CONTINUE
C  TREATMENT OF KILLED PARTICLES
C  ADD ENERGY TO LONGITUDINAL ENERGY DEPOSIT, IF PARTICLE IS CUTTED
      IF ( LLONGI ) THEN
C  PARTICLE SUFFERED FROM ANGULAR CUT OR MOVED OUT OF ATMOSPHERE
        IF     ( ITYPE .EQ.  5   .OR.  ITYPE .EQ. 6 ) THEN

          DLONG(LPCT1,15) = DLONG(LPCT1,15) + GAMMAOLD * PAMA(5)

        ELSE
          DLONG(LPCT1,17) = DLONG(LPCT1,17) + GAMMAOLD * PAMA(ITYPE)
     *                                      - RESTMS(ITYPE)

        ENDIF
      ENDIF
      IRET2 = 1

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================
c--change
      SUBROUTINE UPDATE( HNEW,THCKHN,IPAS,fmfb )
c--change
C-----------------------------------------------------------------------
C  UPDATE(S PARTICLE PARAMETERS)
C
C  UPDATES PARTICLE PARAMETERS TO OBSERVATION LEVEL WITH NUMBER IPAS
C                           OR TO POINT OF INTERACTION OR DECAY (IPAS=0)
C  FOR CHARGED PARTICLES THE ENERGY LOSS IS COMPUTED FOR THE WHOLE STEP,
C  SUBDIVIDED BY THE BOUNDARIES OF THE ATMOSPHERIC LAYERS.
C  THE PARTICLE IS FLYING THE 1ST HALF (CHI/2) WITH INITIAL ENERGY
C  AND ANGLE AND THE 2ND HALF WITH FINAL ENERGY AND ANGLE.
C  THE TIME CALCULATION FOLLOWS THIS SIMPLIFICATION.
C  CHARGED PARTICLES ARE DEFLECTED IN THE EARTH MAGNETIC FIELD.
C  THE ANGLE OF DEFLECTION BY MULTIPLE SCATTERING IS COMPUTED ONLY
C  FOR MUONS AND ONLY ONCE FOR THE WHOLE STEP AT HALF THICKNESS.
C  IF PARTICLES COME TO REST BY STOPPING, THEIR PATH TO THE STOPPING
C  POINT IS CALCULATED.

C  CHERENKOV RADIATION IS CALCULATED ONLY FOR LOWEST OBSERVATION LEVEL

C  THIS SUBROUTINE IS CALLED FROM AAMAIN, BOX3, MUTRAC, AND UPDATC.
C  ARGUMENTS:
C   HNEW   = ALTITUDE OF PARTICLE AFTER UPDATE
C   THCKHN = THICKNESS OF HNEW
C   IPAS   = 0  TRANSPORT TO END OF RANGE OF PARTICLE
C       .NE. 0  TRANSPORT TO PASSAGE OF OBSERVATION LEVEL IPAS
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRATMOS2/HLAY,HLAY0,THICKL,LAYNO,LAYNEW
      DOUBLE PRECISION HLAY(6),HLAY0(5,0:9),THICKL(5)
      INTEGER          LAYNO(0:22)
      LOGICAL          LAYNEW

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRCORFRAM/DETSYS
      LOGICAL          DETSYS

      COMMON /CRELABCT/ELCUT
      DOUBLE PRECISION ELCUT(4)

      COMMON /CRGENER/ GEN,ALEVEL
      DOUBLE PRECISION GEN,ALEVEL

      COMMON /CRIRET/  IRET1,IRET2,IRETE
      INTEGER          IRET1,IRET2
      LOGICAL          IRETE

      INTEGER          LNGMAX
      PARAMETER        (LNGMAX = 1825)
      COMMON /CRLONGI/ ADLONG,AELONG,APLONG,DLONG,ELONG,HLONG,PLONG,
     *                 SDLONG,SELONG,SPLONG,THSTEP,THSTPI,
     *                 LHEIGH,NSTEP,
     *                 LLONGI,FLGFIT
      DOUBLE PRECISION ADLONG(0:LNGMAX,19),AELONG(0:LNGMAX,10),
     *                 APLONG(0:LNGMAX,10),DLONG(0:LNGMAX,19),
     *                 ELONG(0:LNGMAX,10),
     *                 HLONG(0:LNGMAX),PLONG(0:LNGMAX,10),
     *                 SDLONG(0:LNGMAX,19),SELONG(0:LNGMAX,10),
     *                 SPLONG(0:LNGMAX,10),THSTEP,THSTPI

      INTEGER          LHEIGH,NSTEP
      LOGICAL          LLONGI,FLGFIT

      COMMON /CRMAGNET/BX,BZ,BVAL,BNORMC,BNORM,COSB,SINB,BLIMIT
      DOUBLE PRECISION BX,BZ,BVAL,BNORMC,BNORM,COSB,SINB,BLIMIT

      COMMON /CRMUMULT/CHC,OMC,PHISCT,STEPL,VSCAT,FMOLI
      DOUBLE PRECISION CHC,OMC,PHISCT,STEPL,VSCAT
      LOGICAL          FMOLI

      COMMON /CROBSPAR/OBSLEV,THCKOB,XOFF,YOFF,HEIGHP,THETAP,PHIP,
     *                 THETPR,PHIPR,

     *                 VUECON,

     *                 NOBSLV
      DOUBLE PRECISION OBSLEV(20),THCKOB(20),XOFF(20),YOFF(20),
     *                 HEIGHP,THETAP,THETPR(2),PHIP,PHIPR(2)

      DOUBLE PRECISION VUECON(2)

      INTEGER          NOBSLV

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      DOUBLE PRECISION GAMMA,COSTHE,PHIX,PHIY,H,T,X,Y,CHI,BETA,GCM,ECM

     *                 ,WEIGHT

     *                 ,HAPP,COSTAP,COSTEA

      EQUIVALENCE      (CURPAR(1), GAMMA ), (CURPAR(2), COSTHE),
     *                 (CURPAR(3), PHIX  ), (CURPAR(4), PHIY  ),
     *                 (CURPAR(5), H     ), (CURPAR(6), T     ),
     *                 (CURPAR(7), X     ), (CURPAR(8), Y     ),
     *                 (CURPAR(9), CHI   ), (CURPAR(10),BETA  ),
     *                 (CURPAR(11),GCM   ), (CURPAR(12),ECM   )

     *                ,(CURPAR(13),WEIGHT)

     *                ,(CURPAR(14),HAPP  ), (CURPAR(15),COSTAP),
     *                 (CURPAR(16),COSTEA)

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION ACOSTH,ALPHA1,ALPHA2,AUX2,BETAN,CHIT,DCHI,DENS,
     *                 DH,DT,ELOSS,ELOS2,FNORM1,FNORM2,
     *                 F1COS1,F1COS2,F1SIN1,F1SIN2,
     *                 GAMK,GAMMAN,GAMSQ,GAM0,GLCUT,GMSQM1,
     *                 HMIDDL,HNEW,HNEWC,OMEGA,RADINV,RATIO,
     *                 SN,SN1,SN2,SN3,SN4,
     *                 SNMIDDL1,SNMIDDL2,THCKHC,THCKHN,THICKMDL,TH0,
     *                 USW,U10,U12,U20,U22,V,VVV,V10,V12,V20,V22,
     *                 W10,W12,W20,W22
      INTEGER          I,IL,ILAY,IPAS
      LOGICAL          CFLAG,MUS,TCRNKV,TFLAG
c-----changed--add
      logical fmfb
c-----changed--add
      DOUBLE PRECISION CDEDXM,HEIGH,RANNOR,RHOF,THICK
      SAVE
      EXTERNAL         CDEDXM,HEIGH,RANNOR,RHOF,THICK

      DOUBLE PRECISION AUXIL,CORR,DX,DY,SINDIF,TRANS2

      DOUBLE PRECISION XBEG,YBEG,ZBEG,TBEG,EBEG,XEND,YEND,ZEND,TEND,
     *                 EEND,TPART,XPART,YPART,ZPART,WTPART,CTEA
      DATA             CFLAG /.TRUE./
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,457) 
     *                        (CURPAR(I),I=0,9),HNEW,THICKH,CHI,IPAS
  457 FORMAT(' UPDATE: CURPAR=',1P,10E11.3/
     *   9X,'TO HEIGHT ',0P,F11.1,' THICKH=',F11.5,' CHI=',F11.4
     *     ,' IPAS=',I1)

      IRET2  = 1
      IRETE  = .FALSE.
C  TOTAL HEIGHT DIFFERENCE

      DH     = MAX( H - HNEW, 1.D-10 )

      ACOSTH = ABS( COSTHE )
C  ATMOSPHERE THICKNESS TRAVERSED

       DCHI     = MAX( 0.D0, (THCKHN - THICKH) / COSTHE )
C  TOTAL PATH FOR UNDEFLECTED PARTICLE
       SN       = DH / COSTHE
C  GEOMETRICAL MIDDLE
CDH    HMIDDL   = H - 0.5D0*DH
C  MIDDLE OF THICKNESS
       THICKMDL = THICKH + 0.5D0*DCHI*COSTHE
       HMIDDL   = HEIGH( THICKMDL )
       SNMIDDL1 = ((H-HMIDDL))/COSTHE
      SNMIDDL2 = SN - SNMIDDL1
      SN1      = 0.5D0 * SNMIDDL1
      HNEWC    = HNEW

C  CALCULATE KINETIC ENERGY CUT
      IF ( ITYPE .EQ. 5  .OR.  ITYPE .EQ. 6 ) THEN
        MUS   = .TRUE.
        GLCUT = ELCUT(2) / PAMA(ITYPE) + 1.D0
      ELSE
        MUS   = .FALSE.
        GLCUT = ELCUT(1) / PAMA(ITYPE) + 1.D0

      ENDIF

C  CALCULATE THE ENERGY LOSS FOR CHARGED PARTICLES
      IF ( SIGNUM(ITYPE) .NE. 0.D0 ) THEN
C  LOOK WITHIN WHICH LAYER THE PARTICLE STARTS
        IF     ( H .LE. HLAY(2) ) THEN
          ILAY = 1
          TH0  = THICKH
        ELSEIF ( H .LE. HLAY(3) ) THEN
          ILAY = 2
          TH0  = THICKH
        ELSEIF ( H .LE. HLAY(4) ) THEN
          ILAY = 3
          TH0  = THICKH
        ELSE
          ILAY = 4
          TH0  = MAX( THICKH, THICKL(5) )
        ENDIF
C  SET START VALUES FOR ITERATION
        GAM0   = GAMMA

         IL     = ILAY
C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
 1       CONTINUE
         GAM0   = MAX( GAM0, 1.0001D0 )
         GAMSQ  = GAM0**2
         GMSQM1 = GAMSQ - 1.D0
C  ENERGY LOSS BY IONIZATION
         ELOSS  = SIGNUM(ITYPE)**2 * C(22) * ( GAMSQ * (LOG(GMSQM1)
     *              - 0.5D0 * LOG(GAM0 * C(16) + C(15))
     *              + C(23)) / GMSQM1 - 1.D0 )
         IF ( MUS ) THEN
C  ADD ENERGY LOSS OF SUBTHRESHOLD BEMSSTRAHLUNG AND PAIR PRODUCTION
           AUX2  = CDEDXM( PAMA(5)*GAM0 )
           IF (DEBUG) WRITE(MDEBUG,*) 'UPDATE: ELOSS,DEDXM=',ELOSS,AUX2
           ELOSS = ELOSS + AUX2
         ENDIF
         ELOS2  = ELOSS / ( PAMA(ITYPE) * ACOSTH )
C  LOOK WHETHER PARTICLE PENETRATES LAYER BOUNDARY
          IF ( IL .GT. 1  .AND.  THICKL(IL) .LT. THCKHN ) THEN
C  CALCULATE NEW START VALUES AT LAYER BOUNDARY
            GAM0 = GAM0 - ELOS2 * (THICKL(IL) - TH0)
            IF ( GAM0 .LE. 1.D0 ) THEN
              GAMMAN = 1.0001D0
              GOTO 3
            ENDIF
            TH0  = THICKL(IL)
            IL   = IL - 1
            GOTO 1
          ENDIF
C  GAMMA VALUE FOR CHARGED PARTICLES AT END OF STEP
          GAMMAN = GAM0 - ELOS2 * (THCKHN - TH0)

 3       CONTINUE
         IF ( DEBUG ) WRITE(MDEBUG,*) 
     *                           'UPDATE: GAM0,ELOS2,THCKHN,TH0=',
     *             SNGL(GAM0),SNGL(ELOS2),SNGL(THCKHN),SNGL(TH0)
      ELSE
C  NO LOSS FOR NEUTRAL PARTICLES
        GAMMAN = GAMMA
      ENDIF

      IF ( LLONGI  .OR.  CFLAG ) THEN

C  PARTICLE HAS TO BE TRACKED TO THE CUTOFF ENERGY FOR CHERENKOV PHOTONS
C  OR FOR LONGITUDINAL DISTRIBUTIONS  (AS NEUTRAL DO NOT LOOSE ENERGY IN
C  UPDATE, THIS CONDITION IS FULFILLED BY CHARGED PARTICLES ONLY)
        IF ( SIGNUM(ITYPE) .NE. 0.D0  .AND.  GAMMAN .LT. GLCUT ) THEN
          GAMMAN = 0.9D0 + GLCUT * 0.1D0
C  SET START VALUES FOR ITERATION
          IL     = ILAY
          CHIT   = 0.D0
          GAM0   = GAMMA

           TH0    = MAX( THICKH, THICKL(5) )
 2         CONTINUE
           GAM0   = MAX( GAM0, 1.0001D0 )
           GAMSQ  = GAM0**2
           GMSQM1 = GAMSQ - 1.D0
C  ENERGY LOSS BY IONIZATION
           ELOSS  = SIGNUM(ITYPE)**2 * C(22) * ( GAMSQ * (LOG(GMSQM1)
     *                - 0.5D0 * LOG(GAM0 * C(16) + C(15))
     *                + C(23)) / GMSQM1 -1.D0 )
           IF ( MUS ) THEN
C  ADD ENERGY LOSS OF SUBTHRESHOLD BEMSSTRAHLUNG AND PAIR PRODUCTION
             AUX2  = CDEDXM( PAMA(5)*GAM0 )
             IF ( DEBUG ) WRITE(MDEBUG,*)
     *                         'UPDATE: ELOSS,AUX2=',ELOSS,AUX2
             ELOSS = ELOSS + AUX2
           ENDIF
           ELOS2  = ELOSS / ( PAMA(ITYPE) * ACOSTH )
           GAMK   = GAM0 - ELOS2 * (THICKL(IL) - TH0)
           IF ( DEBUG ) WRITE(MDEBUG,*) 'UPDATE: ELOS2,GAMK=',
     *                                SNGL(ELOS2),SNGL(GAMK)
C  LOOK WHETHER PARTICLE PENETRATES LAYER BOUNDARY
           IF ( GAMMAN .LT. GAMK ) THEN
             IF ( IL. GT. 1 ) THEN

C  CALCULATE PORTION OF RANGE AND NEW START VALUES AT LAYER BOUNDARY
               CHIT = CHIT + (THICKL(IL) - TH0) / COSTHE
               GAM0 = GAMK
               TH0  = THICKL(IL)
               IL   = IL - 1
               GOTO 2
             ENDIF
           ENDIF
C  PENETRATED MATTER THICKNESS
           CHI    = CHIT + (GAM0 - GAMMAN) / ( ELOS2 * ACOSTH )
C  CALCULATE CORRECTED PATH PARAMETERS
           THCKHC = THICKH + COSTHE * CHI
           IF ( DEBUG ) WRITE(MDEBUG,*) 'UPDATE: GAMMAN,CHI,TRHCKHC=',
     *                           SNGL(GAMMAN),SNGL(CHI),SNGL(THCKHC)
           THCKHC = MIN( THCKHC, THCKHN )

           CHI    = (THCKHC - THICKH) / COSTHE
           HNEWC  = HEIGH( THCKHC )
           DT     = SN / (C(25) * BETA * GAMMA)
           RATIO  = 0.5D0 * (H-HNEWC) / DH

           DH     = MAX( H - HNEWC, 1.D-10 )

           SN     = DH / COSTHE
C  GEOMETRICAL MIDDLE
CDH        HMIDDL = H - 0.5D0 * DH
C  MIDDLE OF THICKNESS
           THICKMDL = THICKH + 0.5D0 * CHI * COSTHE
           HMIDDL   = HEIGH( THICKMDL )
           SNMIDDL1 = ( H - HMIDDL ) / COSTHE
           IF ( DEBUG ) WRITE(MDEBUG,*)
     *                      'UPDATE: CHI,THICKMDL,HMIDDL,SNMIDDL1=',
     *        SNGL(CHI),SNGL(THICKMDL),SNGL(HMIDDL),SNGL(SNMIDDL1)
          SNMIDDL2 = SN - SNMIDDL1
          SN1      = 0.5D0 * SNMIDDL1
          TFLAG    = .TRUE.
        ELSE
          TFLAG    = .FALSE.
        ENDIF

      ELSE
        IF ( GAMMAN .LT. GLCUT ) THEN
C  REJECT ALL PARTICLES IF BELOW KINETIC ENERGY CUT
          IF ( DEBUG ) WRITE(MDEBUG,*)
     *               'UPDATE: PARTICLE TYPE',ITYPE,' BELOW ENERGY CUT'
          IRETE = .TRUE.
          RETURN
        ENDIF
      ENDIF

C-----------------------------------------------------------------------
      IF ( IPAS .EQ. 0 ) THEN
C  UPDATE TO THE END POINT OF THE TRACK

        IF ( MUS ) THEN
C  COULOMB SCATTERING ANGLE (FOR MUONS ONLY)
          IF ( FMOLI) THEN
C  TREAT MUON MULTIPLE SCATTERING BY MOLIERE THEORY (SEE GEANT)
C  CALCULATE AVERAGE DENSITY AND NUMBER OF SCATTERING (OMEGA)
            IF ( DH .NE. 0.D0 ) THEN
              DENS  = COSTHE * CHI / DH
            ELSE
              DENS = RHOF( HNEW )
            ENDIF

            OMEGA = OMC * CHI / BETA**2
            IF ( OMEGA .LE. 20.D0 ) THEN
C  FEW SCATTERING EVENTS, APPLY PLURAL COULOMB SCATTERING
              CALL MUCOUL( OMEGA,DENS )
            ELSE
C  ENOUGH SCATTERING EVENTS, APPLY MOLIERE''S THEORY
              CALL MMOLIE( OMEGA,DENS )
            ENDIF
          ELSE
C  TREAT MUON MULTIPLE SCATTERING BY GAUSS DISTRIBUTION
            VSCAT = RANNOR( 0.D0, C(30) * SQRT( CHI/C(21) )
     *                          / (PAMA(5) * GAMMA * BETA**2) )
          ENDIF
          IF ( FIRSTI  .AND.  .NOT. TMARGIN ) THEN
C  IF WE TRACK MUON AS PRIMARY BEFORE FIRST INTERACTION, NO SCATTERING
            VSCAT  = 0.D0
            PHISCT = 0.D0
          ELSE
            CALL RMMARD( RD,1,1 )
            PHISCT = RD(1) * PI2
          ENDIF
          V = VSCAT
          IF ( DEBUG ) WRITE(MDEBUG,*) 'UPDATE: VSCAT=',SNGL(VSCAT),
     *                                      ' PHISCT=',SNGL(PHISCT)
        ENDIF

        IF ( LLONGI  .OR.  CFLAG ) THEN

          IF ( TFLAG ) THEN
            HNEW   = HNEWC
            THCKHN = THCKHC
            IF ( DEBUG ) WRITE(MDEBUG,*)
     *                         'UPDATE: CHANGED HNEW=',SNGL(HNEW)
          ENDIF
C  CHERENKOV RADIATION: LOOK, WHETHER PATH ENDS ABOVE LOWEST OBSERV.LEVEL

          TCRNKV   = .TRUE.
        ENDIF

      ELSE
C  UPDATE TO THE OBSERVATION LEVELS

        IF ( MUS ) THEN
C  COULOMB SCATTERING ANGLE (FOR MUONS ONLY)
          V = VSCAT * SQRT( DCHI / CHI )
        ENDIF
        IF ( LLONGI  .OR.  CFLAG ) THEN
C  CHERENKOV RADIATION: LOOK, WHETHER LOWEST OBSERVATION LEVEL
          IF ( IPAS .EQ. NOBSLV ) THEN
            TCRNKV = .TRUE.
          ELSE
            TCRNKV = .FALSE.
          ENDIF
        ENDIF
      ENDIF

      IF ( LLONGI  .OR.  CFLAG ) THEN
C  REJECT ALL PARTICLES IF BELOW KINETIC ENERGY CUT

        IF ( GAMMAN .LT. GLCUT  .AND.  .NOT.TCRNKV ) THEN
          IF ( DEBUG ) WRITE(MDEBUG,*) 'UPDATE: PARTICLE ',ITYPE,
     *      ' BELOW ENERGY CUT, CHERENKOV LIGHT NOT CALCULATED'

          OUTPAR(1) = GAMMAN

          IRETE = .TRUE.
          RETURN
        ENDIF
      ENDIF

C-----------------------------------------------------------------------
C  TRANSPORT CHARGED PARTICLES THE FIRST PORTION OF STEP
      IF ( SIGNUM(ITYPE) .NE. 0.D0 ) THEN
C  CHARGED PARTICLES SUFFER IONIZATION LOSS, DEFLECTION IN MAGNETIC
C  FIELD AND MUONS IN ADDITION DO MULTIPLE COULOMB SCATTERING.
C  DEFLECTION IN EARTH MAGNETIC FIELD ON FIRST HALF OF STEP
c--------changed---add
         if(fmfb) then

c--------changed---add
cc        ALPHA1 = SIGNUM(ITYPE) *
cc     *         MIN( 1.D0, 2.D0*SN1*BNORMC /(PAMA(ITYPE)*BETA*GAMMA) )
        U10    = PHIX
        V10    = -PHIY
        W10    = COSTHE
cc        FNORM1 = 1.D0 - 0.5D0*ALPHA1**2 * (1.D0 - 0.75D0*ALPHA1**2)
cc        F1COS1 = ( 1.D0 - FNORM1 ) * COSB
cc        F1SIN1 = ( 1.D0 - FNORM1 ) * SINB
cc        VVV    = V10 * ALPHA1 * FNORM1
cc        USW    = U10 * SINB - W10 * COSB
cc        U12    = U10 - F1SIN1 * USW + VVV * SINB
cc        V12    = FNORM1 * ( V10 - ALPHA1 * USW )
cc        W12    = W10 + F1COS1 * USW - VVV * COSB
        U12 = U10 
        V12 = V10 
        W12 = W10 

        RADINV = 1.5D0 - 0.5D0 * ( U12**2 + V12**2 + W12**2 )
        W12    = MIN( 1.D0, RADINV * W12 )
        IF ( W12 .LE. C(29) ) THEN
          IF ( DEBUG ) WRITE(MDEBUG,*)
     *                'UPDATE: PARTICLE',ITYPE,' BELOW ANGLE CUT 1'
          IRETE  = .FALSE.
          RETURN
        ENDIF
        SN2 = SN1 * COSTHE / W12

        U12 = RADINV * U12
        V12 = RADINV * V12
c--------changed---add
         else
c--------changed---add
        ALPHA1 = SIGNUM(ITYPE) *
     *         MIN( 1.D0, 2.D0*SN1*BNORMC /(PAMA(ITYPE)*BETA*GAMMA) )
        U10    = PHIX
        V10    = -PHIY
        W10    = COSTHE
        FNORM1 = 1.D0 - 0.5D0*ALPHA1**2 * (1.D0 - 0.75D0*ALPHA1**2)
        F1COS1 = ( 1.D0 - FNORM1 ) * COSB
        F1SIN1 = ( 1.D0 - FNORM1 ) * SINB
        VVV    = V10 * ALPHA1 * FNORM1
        USW    = U10 * SINB - W10 * COSB
        U12    = U10 - F1SIN1 * USW + VVV * SINB
        V12    = FNORM1 * ( V10 - ALPHA1 * USW )
        W12    = W10 + F1COS1 * USW - VVV * COSB
        RADINV = 1.5D0 - 0.5D0 * ( U12**2 + V12**2 + W12**2 )
        W12    = MIN( 1.D0, RADINV * W12 )
        IF ( W12 .LE. C(29) ) THEN
          IF ( DEBUG ) WRITE(MDEBUG,*)
     *                'UPDATE: PARTICLE',ITYPE,' BELOW ANGLE CUT 1'
          IRETE  = .FALSE.
          RETURN
        ENDIF
        SN2 = SN1 * COSTHE / W12

        U12 = RADINV * U12
        V12 = RADINV * V12
c--------changed---add
        endif
c--------changed---add

C  CHERENKOV RADIATION: FILL PARTICLE COORDINATES
        IF ( TCRNKV ) THEN
C  ..BEG  ARE THE COORDINATES AT BEGIN OF THIS STEP
C  ..PART ARE THE COORDINATES AT END   OF THIS STEP

          IF ( .NOT. DETSYS ) THEN
C  TRANSFORM INTO DETECTOR FRAME
C  FIRST CALCULATE STEP TO X AND Y ALONG EARTH SURFACE
            DX     = +SN1 * U10 + SN2 * U12
            DY     = -SN1 * V10 - SN2 * V12
            TRANS2 = DX**2 + DY**2
            AUXIL  = SQRT( TRANS2 + (C(1)+HMIDDL)**2 )
            SINDIF = SQRT( TRANS2 ) / AUXIL
            IF ( SINDIF .GT. 0.D0 ) THEN
              CORR = C(1) * ASIN( SINDIF ) / (AUXIL*SINDIF)
            ELSE
              CORR = 1.D0
            ENDIF
            XPART = X + DX*CORR
            YPART = Y + DY*CORR
C  CALCULATE ANGLE BETWEEN THE ACTUAL LOCAL AND THE APPARENT COORDINATE
C  SYSTEM  (IMPORTANT FOR DECIDING IN CERENK IF FIRST OR SECOND CALL
C  AND TO CALCULATE THE INTERMEDIATE DIF ANGLE)
            AUXIL = SQRT( X**2 + Y**2 )
            CTEA  = COS( AUXIL/C(1) )
C  NOW TRANSFORM THEM IN DETECTOR FRAME.  ATTENTION: ANGLE MIGHT BE
C  VERY LARGE, THEREFORE APPROXIMATION  TAN(X) EQUAL X IS NOT ALLOWED!
C  SINCE X = X(HAPP), DON''T TRANSFORM X AND Y HERE BUT IN CERENK
            XBEG  = X
            YBEG  = Y
          ELSE

            CTEA  = 1.D0
            XBEG  = X
            YBEG  = Y
            XPART = X + SN1 * U10 + SN2 * U12
            YPART = Y - SN1 * V10 - SN2 * V12

          ENDIF

          TPART = T + ( SN1 + SN2 ) / ( C(25) * BETA )
CDH       ZPART = H - DH * 0.5D0
          ZPART = HMIDDL
C  SET OTHER FUNCTION ARGUMENTS
          TBEG  = T
          ZBEG  = H
          EBEG  = PAMA(ITYPE)*GAMMA
          TEND  = TPART
          XEND  = XPART
          YEND  = YPART
          ZEND  = ZPART
          EEND  = PAMA(ITYPE)*GAMMAN

          WTPART = 1.D0
c----------changes --add itype
          CALL CERENK( SN1+SN2,U12,-V12,W12,EBEG,EEND-0.5D0*(EEND-EBEG),
     *       XBEG,YBEG,ZBEG,XEND,YEND,ZEND,TBEG,TEND,
     *       PAMA(ITYPE),SIGNUM(ITYPE),WTPART,CTEA,itype )
        ENDIF

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  CHANGE DIRECTION BY COULOMB SCATTERING (FOR MUONS ONLY)
        IF ( MUS ) THEN
C  BEFORE SCATTERING : DIRECTION COSINES ARE U12,V12,W12
          CALL ADDANG3( W12,U12,V12, COS( V ),-PHISCT, W20,U20,V20 )
          IF ( W20 .LE. C(29) ) THEN
            IF ( DEBUG ) WRITE(MDEBUG,*) 'UPDATE: MUON BELOW ANGLE CUT'
            IRETE  = .FALSE.
            RETURN
          ENDIF
C  AFTER  SCATTERING : DIRECTION COSINES ARE U20,V20,W20

          IF ( HNEW .GT. OBSLEV(1) ) THEN

C  CORRECT ARRIVAL HEIGHT ACCORDING TO INTERACTION OR DECAY
            IF ( FDECAY ) THEN
C  IN CASE OF DECAY THE PATH LENGTH SNMIDDL2 IS KEPT CONSTANT
              HNEW   = HMIDDL - SNMIDDL2 * W20
              THCKHN = THICK( HNEW )
              CHI    = 0.5D0 * CHI + (THCKHN - THICKMDL) / W20

              IF ( DEBUG ) WRITE(MDEBUG,*)
     *           'UPDATE: DECAY HNEW=',SNGL(HNEW),' CHI=',SNGL(CHI)
              CHI    = MAX( CHI, 1.D-20)
            ELSE
C  IN CASE OF INTERACTION THE PENETRATED MATTER CHI IS KEPT CONSTANT
              THCKHN   = THICKMDL + 0.5D0 * CHI * W20
              HNEW     = HEIGH( THCKHN )
              SNMIDDL2 = (HMIDDL - HNEW) / W20

              IF ( DEBUG ) WRITE(MDEBUG,*) 'UPDATE: INTAC HNEW=',
     *                        SNGL(HNEW),' SNMIDDL2=',SNGL(SNMIDDL2)
            ENDIF
            STEPL = SNMIDDL1 + SNMIDDL2
            SN3   = 0.5D0 * SNMIDDL2
          ELSE
C  KEEP ARRIVAL HEIGHT AND SNMIDDL2, PARTICLE ARRIVES AT OBSERV. LEVEL
            SN3   = 0.5D0 * SNMIDDL2 * COSTHE / W20

          ENDIF
        ELSE
          U20 = U12
          V20 = V12
          W20 = W12
          SN3 = 0.5D0 * SNMIDDL2 * COSTHE / W20

        ENDIF

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C  TRANSPORT CHARGED PARTICLES THE SECOND PORTION OF STEP
C  NEW PATH LENGTH, NEW BETA VALUE BECAUSE OF IONIZATION ENERGY LOSS
        BETAN  = SQRT( (GAMMAN-1.D0)*(GAMMAN+1.D0) ) / GAMMAN
C  DEFLECTION IN EARTH MAGNETIC FIELD ON SECOND HALF OF STEP
        ALPHA2 = SIGNUM(ITYPE) *
     *           MIN(1.D0,2.D0*SN3*BNORMC / (PAMA(ITYPE)*BETAN*GAMMAN))
        FNORM2 = 1.D0 - 0.5D0*ALPHA2**2 * (1.D0 - 0.75D0*ALPHA2**2)
        F1SIN2 = ( 1.D0 - FNORM2 ) * SINB
        F1COS2 = ( 1.D0 - FNORM2 ) * COSB
        VVV    = V20 * ALPHA2 * FNORM2
        USW    = U20 * SINB - W20 * COSB
        U22    = U20 - F1SIN2 * USW + VVV * SINB
        V22    = FNORM2 * ( V20 - ALPHA2 * USW )
        W22    = W20 + F1COS2 * USW - VVV * COSB
        RADINV = 1.5D0 - 0.5D0 * ( U22**2 + V22**2 + W22**2 )
        W22    = MIN( 1.D0, RADINV * W22 )
        IF ( W22 .LE. C(29) ) THEN
          IF ( DEBUG ) WRITE(MDEBUG,*)
     *                    'UPDATE: PARTICLE',ITYPE,' BELOW ANGLE CUT 2'
          IRETE = .FALSE.
          RETURN
        ENDIF
        SN4 = SN3 * W20 / W22

        U22 = RADINV * U22
        V22 = RADINV * V22

        OUTPAR(2) =  W22
        OUTPAR(3) =  U22
        OUTPAR(4) = -V22
C  UPDATE COORDINATES AND TIME TO THE END OF DISTANCE
        IF ( (LLONGI  .OR.  CFLAG)  .AND.  TFLAG ) THEN
          OUTPAR(6) = T + DT* ( RATIO*GAMMA + (1.D0-RATIO)*GAMMAN)
        ELSE
          OUTPAR(6) = T + (SN1 + SN2)/(BETA *C(25)) +
     *                    (SN3 + SN4)/(BETAN*C(25))
        ENDIF
        OUTPAR(7) = X + SN1*U10 + SN2*U12 + SN3*U20 + SN4*U22
        OUTPAR(8) = Y - SN1*V10 - SN2*V12 - SN3*V20 - SN4*V22

C  CHERENKOV RADIATION: FILL PARTICLE COORDINATES
        IF ( TCRNKV ) THEN

          IF ( .NOT. DETSYS ) THEN
C  RESAVE OLD COORDINATES DUE TO DIFFERENT DEFINITION IN CERENK
C  (COORDINATES WERE TRANSFORMED IN CERENK)
            XEND = XPART
            YEND = YPART
            ZEND = ZPART
C  TRANSFORM INTO DETECTOR FRAME
C  FIRST CALCULATE STEP TO X AND Y ALONG EARTH SURFACE
            DX     = +SN1*U10 + SN2*U12 + SN3*U20 + SN4*U22
            DY     = -SN1*V10 - SN2*V12 - SN3*V20 - SN4*V22
            TRANS2 = DX**2 + DY**2
            AUXIL  = SQRT( TRANS2 + (C(1)+HNEW)**2 )
            SINDIF = SQRT( TRANS2 ) / AUXIL
            IF ( SINDIF .GT. 0.D0 ) THEN
              CORR = C(1) * ASIN( SINDIF ) / (AUXIL*SINDIF)
            ELSE
              CORR = 1.D0
            ENDIF
            XPART = X + DX*CORR
            YPART = Y + DY*CORR
            TPART = OUTPAR(6)
C  CALCULATE EARTH ANGLE BETWEEN THE ACTUAL LOCAL AND THE
C  APPARENT COORDINATE SYSTEM (SEE ABOVE)
            AUXIL = SQRT( X**2 + Y**2 )
            CTEA  = COS( AUXIL/C(1) )
C  NOW TRANSFORM THEM IN DETECTOR FRAME.  ATTENTION: ANGLE MIGHT BE
C  VERY LARGE, THEREFORE APPROXIMATION  TAN(X) EQUAL X IS NOT ALLOWED!
C  DON''T TRANSFORM X AND Y HERE BUT IN CERENK (SEE ABOVE)
C  XBEG=XEND(LAST PART) AND YBEG=YEND(LAST PART) ARE SET ABOVE
          ELSE

            CTEA  = 1.D0
            XPART = OUTPAR(7)
            YPART = OUTPAR(8)
            TPART = OUTPAR(6)

          ENDIF

          ZPART = HNEW
*         TPART = OUTPAR(6)
C  SET OTHER FUNCTION ARGUMENTS (FORMER END IS NOW THE BEGIN)
          TBEG  = TEND
          XBEG  = XEND
          YBEG  = YEND
          ZBEG  = ZEND
          TEND  = TPART
          XEND  = XPART
          YEND  = YPART
          ZEND  = ZPART

          WTPART = 1.D0
c----------changes --add itype
          CALL CERENK( SN3+SN4,U22,-V22,W22,EBEG+0.5*(EEND-EBEG),EEND,
     *                XBEG,YBEG,ZBEG,XEND,YEND,ZEND,TBEG,TEND,
     *                PAMA(ITYPE),SIGNUM(ITYPE),WTPART,CTEA,itype )
        ENDIF

C - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

C  REJECT PARTICLES AFTER PRODUCTION OF CHERENKOV LIGHT
C  AND LONGITUDINAL DEVELOPMENT

        IF ( (LLONGI  .OR.  CFLAG)  .AND.  TCRNKV ) THEN

          IF ( GAMMAN .LT. GLCUT ) THEN

            IF ( DEBUG ) WRITE(MDEBUG,*) 'UPDATE: PARTICLE',ITYPE,
     *           ' BELOW ENERGY CUT AFTER CREATION OF CHERENKOV LIGHT'

            OUTPAR(1) = GAMMAN
            IRETE = .TRUE.
            RETURN
          ENDIF
        ENDIF

C-----------------------------------------------------------------------
      ELSE
C  NEUTRAL PARTICLES
C  NO COULOMB SCATTERING, NO DEFLECTION IN MAGNETIC FIELD

C  UPDATE COORDINATES AND TIME
        OUTPAR(2) = COSTHE
        OUTPAR(3) = PHIX
        OUTPAR(4) = PHIY
        OUTPAR(6) = T + SN / ( C(25) * BETA )
C  HORIZONTAL PATH LENGTH
        OUTPAR(7) = X + SN * PHIX
        OUTPAR(8) = Y + SN * PHIY

      ENDIF

C-----------------------------------------------------------------------
      OUTPAR( 0) = CURPAR(0)
      OUTPAR( 1) = GAMMAN
      OUTPAR( 5) = HNEW
      OUTPAR( 9) = GEN
      OUTPAR(10) = ALEVEL

      IF ( DEBUG ) WRITE(MDEBUG,458) (OUTPAR(I),I=0,9)
  458 FORMAT(' UPDATE: OUTPAR=',1P,9E11.3,0P,F10.0)

C  REGULAR END OF UPDATE
      IRET2 = 0

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE       27/04/1994
C=======================================================================

      SUBROUTINE VAPOR( MAPROJ,INEW,JFIN,ITYP,PFRX,PFRY )

C-----------------------------------------------------------------------
C  (E)VAPOR(ATION OF NUCLEONS AND ALPHA PARTICLES FROM FRAGMENT)
C
C  TREATES THE REMAINING UNFRAGMENTED NUCLEUS
C  EVAPORATION FOLLOWING CAMPI APPROXIMATION.
C  SEE: X. CAMPI AND J. HUEFNER, PHYS.REV. C24 (1981) 2199
C  AND  J.J. GAIMARD, THESE UNIVERSITE PARIS 7, (1990)
C  THIS SUBROUTINE IS CALLED FROM SDPM, DPMJST, NSTORE, AND VSTORE.
C  ARGUMENTS INPUT:
C   MAPROJ       = NUMBER OF NUCLEONS OF PROJECTILE
C   INEW         = PARTICLE TYPE OF SPECTATOR FRAGMENT
C  ARGUMENTS OUTPUT:
C   JFIN         = NUMBER OF FRAGMENTS
C   ITYP(1:JFIN) = NATURE (PARTICLE CODE) OF FRAGMENTS (GEANT)
C   PFRX(1:JFIN) = TRANSVERSE MOMENTUM OF FRAGMENTS IN X-DIRECTION
C   PFRY(1:JFIN) = TRANSVERSE MOMENTUM OF FRAGMENTS IN Y-DIRECTION
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRDPMFLG/NFLAIN,NFLDIF,NFLPI0,NFLCHE,NFLPIF,NFRAGM
      INTEGER          NFLAIN,NFLDIF,NFLPI0,NFLCHE,NFLPIF,NFRAGM

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

       

       

       

       

      DOUBLE PRECISION PFR(60),PFRX(60),PFRY(60)
      DOUBLE PRECISION AFIN,AGLH,APRF,BGLH,EEX,PHIFR,RANNOR,SPFRX,SPFRY
      INTEGER          ITYP(60),IARM,INEW,ITYPRM,INRM,IS,IZRM,JC,JFIN,
     *                 K,L,LS,MAPROJ,MF,NFIN,NINTA,NNUC,NPRF,NNSTEP
      SAVE
      EXTERNAL         RANNOR
C-----------------------------------------------------------------------

      IF ( DEBUG ) WRITE(MDEBUG,*) 'VAPOR : MAPROJ,INEW=',MAPROJ,INEW

      ITYPRM = INEW
      NPRF   = INEW/100
      NINTA  = MAPROJ - NPRF
      IF ( NINTA .EQ. 0 ) THEN
C  NO NUCLEON HAS INTERACTED
        JFIN    = 1
        PFR(1)  = 0.D0
        ITYP(1) = INEW
        IF ( DEBUG ) WRITE(MDEBUG,*) 'VAPOR : JFIN,NINTA=',JFIN,NINTA
        RETURN
      ENDIF

C  EXCITATION ENERGY EEX OF PREFRAGMENT
C  SEE: J.J. GAIMARD, THESE UNIVERSITE PARIS 7, (1990), CHPT. 4.2
      EEX = 0.D0
      CALL RMMARD( RD,2*NINTA,1 )
      DO  L = 1, NINTA
        IF ( RD(NINTA+L) .LT. RD(L) ) RD(L) = 1.D0 - RD(L)
        EEX = EEX + RD(L)
      ENDDO
C  DEPTH OF WOODS-SAXON POTENTIAL TO FERMI SURFACE IS 0.040 GEV
      IF (DEBUG) WRITE(MDEBUG,*)'VAPOR : EEX=',SNGL(EEX*0.04D0),' GEV'
C  EVAPORATION: EACH EVAPORATION STEP NEEDS ABOUT 0.020 GEV, THEREFORE
C  NNSTEP IS EEX * 0.04/0.02 = EEX * 2.
      NNSTEP = INT( EEX*2.D0 )

      IF ( NNSTEP .LE. 0 ) THEN
C  EXCITATION ENERGY TOO SMALL, NO EVAPORATION
        JFIN    = 1
        PFR(1)  = 0.D0
        ITYP(1) = INEW
        IF (DEBUG) WRITE(MDEBUG,*) 'VAPOR : JFIN,EEX=',JFIN,SNGL(EEX)
        RETURN
      ENDIF

C  AFIN IS ATOMIC NUMBER OF FINAL NUCLEUS
      APRF = DBLE(NPRF)
      AFIN = APRF - 1.6D0 * DBLE(NNSTEP)
      NFIN = MAX( 0, INT( AFIN+0.5D0 ) )
C  CORRESPONDS TO DEFINITION; FRAGMENTATION-EVAPORATION
C  CONVOLUTION EMU07 /MODEL ABRASION EVAPORATION (JNC FZK APRIL 94)
C  NNUC IS NUMBER OF EVAPORATING NUCLEONS
      NNUC = NPRF - NFIN
      IF ( DEBUG ) WRITE(MDEBUG,*) 'VAPOR : NFIN,NNUC=',NFIN,NNUC
      JC   = 0

      IF     ( NNUC .LE. 0 ) THEN
C  NO EVAPORATION
        JFIN    = 1
        PFR(1)  = 0.D0
        ITYP(1) = INEW
        RETURN

      ELSEIF ( NNUC .GE. 4 ) THEN
C  EVAPORATION WITH FORMATION OF ALPHA PARTICLES POSSIBLE
C  IARM, IZRM, INRM ARE NUMBER OF NUCLEONS, PROTONS, NEUTRONS OF
C  REMAINDER
        DO  LS = 1, NNSTEP
          IARM = ITYPRM/100
          IF ( IARM .LE. 0 ) GOTO 100
          IZRM = MOD(ITYPRM,100)
          INRM = IARM - IZRM
          JC   = JC + 1
          CALL RMMARD( RD,2,1 )
          IF ( RD(1) .LT. 0.2D0  .AND.  IZRM .GE. 2
     *                           .AND.  INRM .GE. 2 ) THEN
            ITYP(JC) = 402
            NNUC     = NNUC - 4
            ITYPRM   = ITYPRM - 402
          ELSE
            IF ( RD(2)*(IZRM+INRM) .LT. IZRM ) THEN
              ITYP(JC) = 14
              ITYPRM   = ITYPRM - 101
            ELSE
              ITYP(JC) = 13
              ITYPRM   = ITYPRM - 100
            ENDIF
            NNUC = NNUC - 1
          ENDIF
          IF ( NNUC .LE. 0 ) GOTO 50
        ENDDO
      ENDIF

      IF ( NNUC .LT. 4 ) THEN
C  EVAPORATION WITHOUT FORMATION OF ALPHA PARTICLES
        CALL RMMARD( RD,NNUC,1 )
        DO  IS = 1, NNUC
          IARM = ITYPRM/100
          IF ( IARM .LE. 0 ) GOTO 100
          IZRM = MOD(ITYPRM,100)
          JC   = JC + 1
          IF ( RD(IS)*IARM .LT. IZRM ) THEN
            ITYP(JC) = 14
            ITYPRM   = ITYPRM - 101
          ELSE
            ITYP(JC) = 13
            ITYPRM   = ITYPRM - 100
          ENDIF
        ENDDO
      ENDIF

 50   CONTINUE
      JC = JC + 1
      IF     ( ITYPRM .GE. 201 ) THEN
        ITYP(JC) = ITYPRM
      ELSEIF ( ITYPRM .EQ. 200 ) THEN
        ITYP(JC) = 13
        JC = JC + 1
        ITYP(JC) = 13
      ELSEIF ( ITYPRM .EQ. 101 ) THEN
        ITYP(JC) = 14
      ELSEIF ( ITYPRM .EQ. 100 ) THEN
        ITYP(JC) = 13
      ELSE
        JC = JC - 1
        IF ( ITYPRM .NE. 0 ) WRITE(MONIOU,*)
     *                  'VAPOR : ILLEGAL PARTICLE ITYPRM =',ITYPRM
      ENDIF

  100 CONTINUE
      JFIN = JC
      IF ( DEBUG ) WRITE(MDEBUG,*) 'VAPOR :  NO        ITYP     PFR'
      IF     ( NFRAGM .EQ. 2 ) THEN
C  EVAPORATION WITH PT AFTER PARAMETRIZED JACEE DATA
        DO  MF = 1, JFIN
          PFR(MF) = RANNOR(0.088D0,0.044D0)
          IF ( DEBUG ) WRITE(MDEBUG,*) MF,ITYP(MF),SNGL(PFR(MF))
        ENDDO
      ELSEIF ( NFRAGM .EQ. 3 ) THEN
C  EVAPORATION WITH PT AFTER GOLDHABER''S MODEL (PHYS.LETT.53B(1974)306)
        DO  MF = 1, JFIN
          K    = MAX( 1, ITYP(MF)/100 )
          BGLH = K * (MAPROJ - K) / DBLE(MAPROJ-1)
C  THE VALUE 0.103 [GEV] IS SIGMA(0)=P(FERMI)/SQRT(5.)
*         AGLH = 0.103D0 * SQRT( BGLH )
C  THE VALUE 0.090 [GEV] IS EXPERIMENTALLY DETERMINED SIGMA(0)
          AGLH = 0.090D0 * SQRT( BGLH )
          PFR(MF) = RANNOR(0.D0,AGLH)
          IF ( DEBUG ) WRITE(MDEBUG,*) MF,ITYP(MF),SNGL(PFR(MF))
        ENDDO
      ELSE
C  EVAPORATION WITHOUT TRANSVERSE MOMENTUM
        DO  MF = 1, JFIN
          PFR(MF) = 0.D0
          IF ( DEBUG ) WRITE(MDEBUG,*) MF,ITYP(MF),SNGL(PFR(MF))
        ENDDO
      ENDIF
C  CALCULATE RESIDUAL TRANSVERSE MOMENTUM
      SPFRX = 0.D0
      SPFRY = 0.D0
      CALL RMMARD( RD,JFIN,1 )
      DO  MF = 1, JFIN
        PHIFR = PI * RD(MF)
        PFRX(MF) = PFR(MF) * COS( PHIFR )
        PFRY(MF) = PFR(MF) * SIN( PHIFR )
        SPFRY = SPFRY + PFRY(MF)
        SPFRX = SPFRX + PFRX(MF)
      ENDDO
C  CORRECT ALL TRANSVERSE MOMENTA FOR MOMENTUM CONSERVATION
      SPFRX = SPFRX / JFIN
      SPFRY = SPFRY / JFIN
      DO  MF = 1, JFIN
        PFRX(MF) = PFRX(MF) - SPFRX
        PFRY(MF) = PFRY(MF) - SPFRY
      ENDDO

      IF ( DEBUG ) WRITE(MDEBUG,*) 'VAPOR : NINTA,JFIN=',NINTA,JFIN

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   25/06/2003
C=======================================================================

      DOUBLE PRECISION FUNCTION VBSE( Y )

C-----------------------------------------------------------------------
C
C  FUNCTION TO BE USED FOR INTEGRATION OF MUON BREMSSTRAHLUNG
C  ENERGY LOSS.
C  SEE: S. BOTTAI AND L. PERRONE, NUCL. INST. METH. A459 (2001) 319
C       YU.M. ANDREEV AND E.V. BUGAEV, PHYS. REV. D55 (1997) 1233
C  THIS FUNCTION IS CALLED FROM DADMUL (BY DBRELM).
C  ARGUMENTS: (TO BE USED BY DADMUL)
C   Y      = DUMMY ARRAY OF DIMENSION N
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

       

       

       

       

      DOUBLE PRECISION ALPHFA,BBS,CBS,RE
      PARAMETER        (ALPHFA = 7.297353D-3)
      PARAMETER        (BBS    = 184.15D0)
      PARAMETER        (CBS    = 1194.0D0)
      PARAMETER        (RE     = 2.81794092D-13) ! ELECTR. RADIUS IN CM
      DOUBLE PRECISION Y(2)
      DOUBLE PRECISION AA,AASQ,ABS,APAM,A1,A2,C1,C2,CC1,CC2,
     *                 D1,D2,DBS,DELTA1,DELTA2,FI1,FI10,FI2,FI20,
     *                 QMIN,RA,XX,X1,X1SQ,X2,X2SQ
      SAVE
C-----------------------------------------------------------------------

      XX    = Y(2)
      ABS   = ( 2.D0 * RE * ZATOM * EBYMU )**2
      DBS   = (1.D0 - XX)
C  EE IS THE TOTAL ENERGY OF INCOMING MUON
      QMIN  = XX * PAMA(5)**2 / (2.D0 * EE * DBS)
      A1    = BBS / ( SE * PAMA(2) * ZATOM**OB3 )
      A2    = CBS / ( SE * PAMA(2) * ZATOM**TB3 )

      X1    = A1 * QMIN
      X1SQ  = X1**2
      X2    = A2 * QMIN
      X2SQ  = X2**2
      RA    = ZATOM**OB3 / 1.9D0
C  ANDREEV EQ. 2.16B
      AASQ  = 1.D0 + 4.D0 * RA**2
      AA    = SQRT( AASQ )
      APAM  = LOG( (AA+1.D0) / (AA-1.D0) )
C  ANDREEV EQ. 2.16A
      DELTA1= LOG(RA) + 0.5D0  * AA * APAM
      DELTA2= LOG(RA) + 0.25D0 * AA * APAM * (3.D0-AASQ) + 2.D0*RA**2
      C1    = LOG( ( (PAMA(5)*A1)**2 ) / (1.D0+X1SQ) )
      C2    = LOG( ( (PAMA(5)*A2)**2 ) / (1.D0+X2SQ) )
      CC1   = ATAN( 1.D0/X1 )
      CC2   = ATAN( 1.D0/X2 )
C  ANDREEV EQ. 2.9A
      FI10  = ( 0.5D0*(1.D0+C2) - X2*CC2 ) / ZATOM
     *        + 0.5D0*(1.D0+C1) - X1*CC1
      FI1   = FI10 - DELTA1

      D1    = 0.75D0 * LOG( X1SQ / (1.D0+X1SQ) )
      D2    = 0.75D0 * LOG( X2SQ / (1.D0+X2SQ) )
C  ANDREEV EQ. 2.9B
      FI20  = ( 0.5D0*(TB3+C2) + 2.D0*X2SQ * (1.D0-X2*CC2+D2) ) / ZATOM
     *        + 0.5D0*(TB3+C1) + 2.D0*X1SQ * (1.D0-X1*CC1+D1)
C  ANDREEV EQ. 2.6
      FI2   = FI20 - DELTA2
C  FOR ENERGY LOSSES
      VBSE  = ALPHFA * ABS * ( (1.D0+DBS**2)*FI1 - TB3*DBS*FI2 )

      IF ( VBSE .LE. 0.D0 ) VBSE = 0.D0

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   13/05/2003
C=======================================================================

      DOUBLE PRECISION FUNCTION VBSS( Y )

C-----------------------------------------------------------------------
C
C  FUNCTION TO BE USED FOR INTEGRATION OF MUON BREMSSTRAHLUNG
C  CROSS SECTION.
C  SEE: S. BOTTAI AND L. PERRONE, NUCL. INST. METH. A459 (2001) 319
C       YU.M. ANDREEV AND E.V. BUGAEV, PHYS. REV. D55 (1997) 1233
C  THIS FUNCTION IS CALLED FROM DADMUL (BY DBRSGM).
C  ARGUMENTS: (TO BE USED BY DADMUL)
C   Y      = DUMMY ARRAY OF DIMENSION N
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

       

       

       

       

      DOUBLE PRECISION ALPHFA,BBS,CBS,RE
      PARAMETER        (ALPHFA = 7.297353D-3)
      PARAMETER        (BBS    = 184.15D0)
      PARAMETER        (CBS    = 1194.0D0)
      PARAMETER        (RE     = 2.81794092D-13) ! ELECTR. RADIUS IN CM
      DOUBLE PRECISION Y(2)
      DOUBLE PRECISION AA,AASQ,ABS,APAM,A1,A2,C1,C2,CC1,CC2,
     *                 D1,D2,DBS,DELTA1,DELTA2,FI1,FI10,FI2,FI20,
     *                 QMIN,RA,XX,X1,X1SQ,X2,X2SQ
      SAVE
C-----------------------------------------------------------------------

      XX    = Y(2)
      ABS   = ( 2.D0 * RE * ZATOM * EBYMU )**2
      DBS   = (1.D0 - XX)
C  EE IS THE TOTAL ENERGY OF INCOMING MUON
      QMIN  = XX * PAMA(5)**2 / (2.D0 * EE * DBS)
      A1    = BBS / ( SE * PAMA(2) * ZATOM**OB3 )
      A2    = CBS / ( SE * PAMA(2) * ZATOM**TB3 )

      X1    = A1 * QMIN
      X1SQ  = X1**2
      X2    = A2 * QMIN
      X2SQ  = X2**2
      RA    = ZATOM**OB3 / 1.9D0
C  ANDREEV EQ. 2.16B
      AASQ  = 1.D0 + 4.D0 * RA**2
      AA    = SQRT( AASQ )
      APAM  = LOG( (AA+1.D0) / (AA-1.D0) )
C  ANDREEV EQ. 2.16A
      DELTA1= LOG(RA) + 0.5D0  * AA * APAM
      DELTA2= LOG(RA) + 0.25D0 * AA * APAM * (3.D0-AASQ) + 2.D0*RA**2
      C1    = LOG( ( (PAMA(5)*A1)**2 ) / (1.D0+X1SQ) )
      C2    = LOG( ( (PAMA(5)*A2)**2 ) / (1.D0+X2SQ) )
      CC1   = ATAN( 1.D0/X1 )
      CC2   = ATAN( 1.D0/X2 )
C  ANDREEV EQ. 2.9A
      FI10  = ( 0.5D0*(1.D0+C2) - X2*CC2 ) / ZATOM
     *        + 0.5D0*(1.D0+C1) - X1*CC1
      FI1   = FI10 - DELTA1

      D1    = 0.75D0 * LOG( X1SQ / (1.D0+X1SQ) )
      D2    = 0.75D0 * LOG( X2SQ / (1.D0+X2SQ) )
C  ANDREEV EQ. 2.9B
      FI20  = ( 0.5D0*(TB3+C2) + 2.D0*X2SQ * (1.D0-X2*CC2+D2) ) / ZATOM
     *        + 0.5D0*(TB3+C1) + 2.D0*X1SQ * (1.D0-X1*CC1+D1)
C  ANDREEV EQ. 2.6
      FI2   = FI20 - DELTA2
C  FOR ENERGY LOSSES
      VBSS  = ALPHFA * ABS * ( (1.D0+DBS**2)*FI1 - TB3*DBS*FI2 )
C  FOR CROSS-SECTIONS
      VBSS  = VBSS / XX

      IF ( VBSS .LE. 0.D0 ) VBSS = 0.D0

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   04/02/2004
C=======================================================================

      DOUBLE PRECISION FUNCTION VPHL( Y )

C-----------------------------------------------------------------------
C
C  FUNCTION TO BE USED FOR INTEGRATION OF MUON NUCLEAR INTERACTION
C  ENERGY LOSS.
C  SEE: S. BOTTAI AND L. PERRONE, NUCL. INST. METH. A459 (2001) 319
C       YU.M. ANDREEV AND E.V. BUGAEV, PHYS. REV. D55 (1997) 1233
C  THIS FUNCTION IS CALLED FROM DADMUL (BY DNIELM).
C  ARGUMENTS: (TO BE USED BY DADMUL)
C   Y      = DUMMY ARRAY OF DIMENSION N
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

       

       

       

       

      DOUBLE PRECISION ALPHFA,AM21,AM22,APH,CSI,ELE1,ELE2
      PARAMETER        (ALPHFA = 7.297353D-3)
C  BEZRUKOV''S M1**2 AND M2**2
      PARAMETER        (AM21   = 0.54D0)         ! SQUARE MASS IN GEV**2
      PARAMETER        (AM22   = 1.80D0)         ! SQUARE MASS IN GEV**2
      PARAMETER        (APH    = 0.00282D0)
C  BEZRUKOV''S XI (POLARISATION DEPENDENCE) = CSI
      PARAMETER        (CSI    = 0.25D0)
      PARAMETER        (ELE1   = 0.0808D0)
      PARAMETER        (ELE2   = -0.4525D0)
      DOUBLE PRECISION Y(2)
      DOUBLE PRECISION BPH,CPH,DPH,EPH,FPH,GG,HHH,
     *                 SS,SIGN,TTT,VPH1,VPH2,XX,ZZZ
      SAVE
C-----------------------------------------------------------------------

      XX    = Y(2)
C  CALCULATE BEZRUKOV''S T
      TTT  = PAMA(5)**2 * XX**2 / (1.D0 - XX)
C  SS IS ENERGY**2 IN CM SYSTEM, EE IS TOTAL ENERGY OF INCOMING MUON
      SS   = 2.D0 * PAMA(14) * XX * EE
C  CROSS-SECTION OF VIRTUAL GAMMA WITH NUCLEON (IN MICROBARNS)
C  SEE: A. DONNACHIE + P.V. LANDSHOFF, PHYS.LETT. B296 (1992) 227
*     SIGN = 67.7D0 * SS**ELE1 + 129.D0 * SS**ELE2
C  SEE: PARTCIlE DATA GROUP, EUROPHYS. J. C15 (2000) 231
      SIGN = 59.3D0 * SS**0.093D0 + 120.2D0 * SS**(-0.358D0)
C  SCALE THE CROSS-SECTION WITH ATOMIC NUMBER
      ZZZ  = SIGN * APH * AATOM**OB3
C  CALCULATE BOTTAI''S H(V)
      HHH  = 1.D0 - 2.D0/XX + 2.D0/XX**2
C  CALCULATE BEZRUKOV''S NUCLEAR SHADOWING G(X)
      GG   = ( 0.5D0 + ((1.D0+ZZZ)*EXP(-ZZZ)-1.D0)/ZZZ**2 ) * 9.D0/ZZZ
C  FACTOR BEFORE LARGE BRACKET
      BPH  = AATOM * XX**2 * SIGN * (ALPHFA/(8.D0*PI)) * 1.D-30
C  AUXILIARY QUANTITIES
      CPH  = 1.D0 + AM21/TTT
      DPH  = 1.D0 + AM22/TTT
      EPH  = 2.D0 * PAMA(5)**2 / TTT
      FPH  = AM21 / (AM21 + TTT)
C  FIRST PART WITHIN LARGE BRACKET
      VPH1 = HHH * LOG(DPH) - EPH + GG * (HHH*LOG(CPH) - HHH*FPH - EPH)
C  SECOND PART WITHIN LARGE BRACKET
      VPH2 = (2.D0 * CSI * PAMA(5)**2/TTT)
     *         * ( GG * FPH + (AM22/TTT) * LOG( 1.D0 + (TTT/AM22) ) )
C  FOR ENERGY LOSSES
      VPHL = BPH * (VPH1+VPH2)

      IF ( VPHL .LE. 0.D0 ) VPHL = 0.D0

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE   15/05/2003
C=======================================================================

      DOUBLE PRECISION FUNCTION VPHM( Y )

C-----------------------------------------------------------------------
C
C  FUNCTION TO BE USED FOR INTEGRATION OF MUON NUCLEAR INTERACTION
C  CROSS SECTION.
C  SEE: S. BOTTAI AND L. PERRONE, NUCL. INST. METH. A459 (2001) 319
C       L.B. BEZRUKOV AND E.V. BUGAEV, SOV.J.NUCL.PHYS. 33 (1981) 635
C  THIS FUNCTION IS CALLED FROM DADMUL (BY DNUSGM).
C  ARGUMENTS: (TO BE USED BY DADMUL)
C   Y      = DUMMY ARRAY OF DIMENSION N
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRCONSTA/PI,PI2,OB3,TB3,ENEPER
      DOUBLE PRECISION PI,PI2,OB3,TB3,ENEPER

      COMMON /CRMUPART/AMUPAR,BCUT,CMUON,AATOM,CONSTKINE,EBYMU,EE,SE,
     *                 VFRAC,VMAX,VMIN,ZATOM,FMUBRM,FMUNUC,FMUORG
      DOUBLE PRECISION AMUPAR(0:16),BCUT,CMUON(11),AATOM,CONSTKINE,
     *                 EBYMU,EE,SE,VFRAC,VMAX,VMIN,ZATOM
      LOGICAL          FMUBRM,FMUNUC,FMUORG

      COMMON /CRPAM/   PAMA,SIGNUM,RESTMS,DECTIM
      DOUBLE PRECISION PAMA(6000),SIGNUM(6000),RESTMS(6000),
     *                 DECTIM(200)

       

       

       

       

      DOUBLE PRECISION ALPHFA,AM21,AM22,APH,CSI,ELE1,ELE2
      PARAMETER        (ALPHFA = 7.297353D-3)
C  BEZRUKOV''S M1**2 AND M2**2
      PARAMETER        (AM21   = 0.54D0)         ! SQUARE MASS IN GEV**2
      PARAMETER        (AM22   = 1.80D0)         ! SQUARE MASS IN GEV**2
      PARAMETER        (APH    = 0.00282D0)
C  BEZRUKOV''S XI (POLARISATION DEPENDENCE) = CSI
      PARAMETER        (CSI    = 0.25D0)
      PARAMETER        (ELE1   = 0.0808D0)
      PARAMETER        (ELE2   = -0.4525D0)
      DOUBLE PRECISION Y(2)
      DOUBLE PRECISION BPH,CPH,DPH,EPH,FPH,GG,HHH,
     *                 SS,SIGN,TTT,VPH1,VPH2,XX,ZZZ
      SAVE
C-----------------------------------------------------------------------

      XX   = Y(2)
C  CALCULATE BEZRUKOV''S T
      TTT  = PAMA(5)**2 * XX**2 / (1.D0 - XX)
C  SS IS ENERGY**2 IN CM SYSTEM, EE IS TOTAL ENERGY OF INCOMING MUO
      SS   = 2.D0 * PAMA(14) * XX * EE
C  CROSS-SECTION OF VIRTUAL GAMMA WITH NUCLEON (IN MICROBARNS)
C  SEE: A. DONNACHIE + P.V. LANDSHOFF, PHYS.LETT. B296 (1992) 227
*     SIGN = 67.7D0 * SS**ELE1 + 129.D0 * SS**ELE2
C  SEE: PARTICLE DATA GROUP, EUROPHYS. J. C15 (2000) 231
      SIGN = 59.3D0 * SS**0.093D0 + 120.2D0 * SS**(-0.358D0)
C  SCALE THE CROSS-SECTION WITH ATOMIC NUMBER
      ZZZ  = SIGN * APH * AATOM**OB3
C  CALCULATE BOTTAI''S H(V)
      HHH  = 1.D0 - 2.D0/XX + 2.D0/XX**2
C  CALCULATE BEZRUKOV''S NUCLEAR SHADOWING G(X)
      GG   = ( 0.5D0 + ((1.D0+ZZZ)*EXP(-ZZZ)-1.D0)/ZZZ**2 ) * 9.D0/ZZZ
C  FACTOR BEFORE LARGE BRACKET
      BPH  = AATOM * XX**2 * SIGN * (ALPHFA/(8.D0*PI)) * 1.D-30
C  AUXILIARY QUANTITIES
      CPH  = 1.D0 + AM21/TTT
      DPH  = 1.D0 + AM22/TTT
      EPH  = 2.D0 * PAMA(5)**2 / TTT
      FPH  = AM21 / (AM21 + TTT)
C  FIRST PART WITHIN LARGE BRACKET
      VPH1 = HHH * LOG(DPH) - EPH + GG * (HHH*LOG(CPH) - HHH*FPH - EPH)
C  SECOND PART WITHIN LARGE BRACKET
      VPH2 = (2.D0 * CSI * PAMA(5)**2/TTT)
     *         * ( GG * FPH + (AM22/TTT) * LOG( 1.D0 + (TTT/AM22) ) )
C  FINAL CROSS-SECTION
      VPHM = BPH * (VPH1+VPH2) / XX
      IF ( VPHM .LT. 0.D0 ) VPHM = 0.D0

      RETURN
      END

*-- Author :    D. HECK IK FZK KARLSRUHE       21/04/1994
C=======================================================================
C
C        EGS4 SUBROUTINE VERSION FOR CORSIKA
C
C-----------------------------------------------------------------------
C  AUTHORS OF EGS4-SOURCE WITHOUT CORSIKA-MODIFICATIONS:
C                WALTER R. NELSON
C                RADIATION PHYSICS GROUP
C                STANFORD LINEAR ACCELERATOR CENTER
C                STANFORD, CA 94305
C                U.S.A.
C
C                HIDEO HIRAYAMA
C                NATIONAL LABORATORY FOR HIGH ENERGY PHYSICS (KEK)
C                OHO-MACHI, TSUKUBA-GUN, IBARAKI,
C                JAPAN
C
C                DAVID W. O. ROGERS
C                DIVISION OF PHYSICS
C                NATIONAL RESEARCH COUNCIL OF CANADA
C                OTTAWA K1A 0R6
C                CANADA
C
C  MODIFICATIONS FOR CORSIKA:
C                DIETER HECK
C                FORSCHUNGSZENTRUM KARLSRUHE
C                INSTITUT FUER KERNPHYSIK
C                POSTFACH 3640
C                D-76021 KARLSRUHE, FED. REP. GERMANY
C                TEL: 07247-82-3777
C                FAX: 07247-82-4075
C                E-MAIL: DIETER.HECK@IK.FZK.DE
C-----------------------------------------------------------------------
C  EGS4 USER SUBROUTINES TO STUDY THE AIR SHOWER DEVELOPMENT IN THE
C  ATMOSPHERE WITH:
C      BAROMETRIC DENSITY DISTRIBUTION (4 LAYER WITH EXP. DENSITY)
C                         LAYER PARAMETERS ARE TAKEN FROM CORSIKA
C      STERNHEIMER CORRECTION OF DENSITY DEPENDENT IONISATION LOSS
C      PROPAGATION TIME
C      FAST REJECTION OF SUBSHOWERS, WHICH LEAD ONLY WITH SMALL
C              CHANCE TO CHARGED PARTICLES AT DETECTOR LEVEL
C      EARTH MAGNETIC FIELD WITH CORRECTED PATH LENGTH
C      AGE (GENERATION) OF PARTICLES IN HADRONIC INTERACTIONS
C      MULTIPLE SCATTERING IS MODIFIED 'STEPFC*(TEFF0*200)'
C      PHOTONUCLEAR REACTION LEADING TO PIONS
C      MUONIC PAIR FORMATION
C      FZK-IK/CORSIKA  STANDARDS FOR RANDOM GENERATOR, PARTICLE
C                      IDENTIFICATION, DETECTION LEVELS
C      CHERENKOV RADIATION, IF OPTION 'CERENKOV' IS SELECTED
C      LONGITUDINAL DISTRIBUTION OF PARTICLES, ENERGIES, ENERGY DEPOSITS
C      'THINNING' ENABLED BY OPTION 'THIN'
C      LANDAU-POMERANCHUK-MIGDAL EFFECT
C      SIN AND COSIN NOW AS FORTRAN FUNCTIONS
C      ALL QUANTITIES IN DOUBLE PRECISION, IF NOT FROM PEGS4-FILE
C      ALL ROUTINES WITH 'IMPLICIT NONE' AND 'SAVE'
C      EXTENSIONS FOR 'CURVED' VERSION OF CORSIKA
C      EXTENSIONS FOR UPWARD GOING PARTICLES
C      EXTENSIONS FOR 'SLANT' DEPTH LONGITUDINAL DISTRIBUTION
C      DEBUGGING STATEMENTS BY ACTIVATION OF COUNTERS JCLOCK, NCLOCK
C-----------------------------------------------------------------------
C  THE FOLLOWING UNITS ARE USED: UNIT 12 IS PEGS CROSS-SECTION FILE
C                                UNIT MDEBUG FOR DEBUG OUTPUT
C-----------------------------------------------------------------------
C  PHYSICAL UNITS INTERNALLY USED IN THE CORSIKA-EGS4 ARE:
C                                LENGTH IN CM
C                                ENERGY IN MEV
C                                TIME   IN SEC
C
C  DIRECTIONS OF COORDINATE SYSTEM WITHIN THE CORSIKA-EGS4 ARE:
C                                +X ----> NORTH
C                                +Y ----> EAST
C                                +Z ----> DOWN
C-----------------------------------------------------------------------

*-- Author :    STANFORD LINEAR ACCELERATOR CENTER
C=======================================================================
C                                STANFORD LINEAR ACCELERATOR CENTER
      SUBROUTINE ANNIH
C                                VERSION 4.00  --  26 JAN 1986/1900
C-----------------------------------------------------------------------
C  ANNIH(ILATION OF E+)
C
C  GAMMA SPECTRUM FOR TWO GAMMA IN-FLIGHT POSITRON ANNIHILATION.
C  USING SCHEME BASED ON HEITLER''S P269-270 FORMULAE
C  THIS ROUTINE SHOULD GIVE THE CORRECT DISTRIBUTION, BUT MORE
C  THOUGHT COULD BE PUT INTO DEVISING A FASTER SCHEME.  HOWEVER,
C  SINCE POSITRON ANNIHILATION IN FLIGHT IS RELATIVELY INFREQUENT
C  THIS MAY NOT BE WORTHWHILE.
C  THIS SUBROUTINE IS CALLED FROM ELECTR.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CREGSDEB/JCLOCK,NCLOCK,FEGSDB
      INTEGER          JCLOCK,NCLOCK
      LOGICAL          FEGSDB

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSTACKE/E,TIM,U,V,W,X,Y,Z,DNEAR,

     *                 ZAP,WAP,WA,

     *                 IQ,IGEN,IR,IOBS,LPCTE,NP
      DOUBLE PRECISION E(60),TIM(60),U(60),V(60),W(60),
     *                 X(60),Y(60),Z(60),DNEAR(60)

     *                 ,ZAP(60),WAP(60),WA(60)

      INTEGER          IQ(60),IGEN(60),IR(60),IOBS(60),LPCTE(60),NP

      COMMON /CRUPHIOT/THETA,SINTHE,COSTHE,SINPHI,COSPHI,PI,TWOPI
      DOUBLE PRECISION THETA,SINTHE,COSTHE,SINPHI,COSPHI,PI,TWOPI

      COMMON /CRUSEFUL/PRM,PRMT2,RMI,VCI,MEDIUM,MEDOLD,IBLOBE
      DOUBLE PRECISION PRM,PRMT2,RMI,VCI
      INTEGER          MEDIUM,MEDOLD,IBLOBE

       

       

       

       

      DOUBLE PRECISION A,AI,EP,EP0I,G,P,PESG1,PESG2,PAVIP,POT,REJF,T
      SAVE
C-----------------------------------------------------------------------

      IF ( FEGSDB ) THEN
        WRITE(MDEBUG,1) NP,IR(NP),IOBS(NP)
 1      FORMAT(' ANNIH : NP=',I3,' IR=',I3,' IOBS=',I3)
        CALL AUSGB2
      ENDIF

      PAVIP = E(NP)+PRM
      A     = PAVIP*RMI
      AI    = 1.D0/A
      G     = A - 1.D0
      T     = G - 1.D0
      P     = SQRT( A * T )
      POT   = P/T
      EP0I  = (A+P)
 331  CONTINUE
C  SAMPLE 1/EP FROM EP=1./EP0I TO 1.0-1./EP0I
      CALL RMMARD( RD,2,2 )
      EP   = EXP(DBLE(RD(1))*LOG(EP0I-1.D0))/EP0I
C  NOW DECIDE WHETHER TO ACCEPT
      REJF = 1.D0 - EP + AI*AI*(2.D0*G-1.D0/EP)
      IF ( RD(2) .GT. REJF ) GOTO 331
C  THIS COMPLETES SAMPLING OF A DISTRIBUTION WHICH IS ASYMMETRIC
C  ABOUT EP=1/2, BUT WHICH WHEN SYMMETRIZED IS THE SYMMETRIC
C  ANNIHILATION DISTRIBUTION. PICK EP IN (1/2,1-EP0).
      PESG1   = PAVIP*MAX(EP,1.D0-EP)
      E(NP)   = PESG1
      E(NP+1) = PAVIP-E(NP)
      PESG2   = E(NP+1)
C  SET UP ANGLES OF HIGHER ENERGY GAMMA
      IQ(NP)  = 1
      COSTHE  = (PESG1-PRM)*POT/PESG1
      SINTHE  = SQRT(MAX( 0.D0, (1.D0-COSTHE)*(1.D0+COSTHE) ))
      CALL UPHI( 2,1 )
      NP = NP+1
C  SET UP ANGLES OF LOWER ENERGY GAMMA
      IQ(NP) = 1
      COSTHE = (PESG2-PRM)*POT/PESG2
      SINTHE = SQRT(MAX( 0.D0, (1.D0-COSTHE)*(1.D0+COSTHE) ))
      CALL UPHI( 3,2 )

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE AUSGAB

C-----------------------------------------------------------------------
C  WE USE AUSGAB TO FILL OUTPAR WITH PARTICLE COORDINATES.
C  THIS SUBROUTINE IS CALLED FROM ELECTR AND PHOTON.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CREGSDEB/JCLOCK,NCLOCK,FEGSDB
      INTEGER          JCLOCK,NCLOCK
      LOGICAL          FEGSDB

      COMMON /CRGENER/ GEN,ALEVEL
      DOUBLE PRECISION GEN,ALEVEL

      COMMON /CRMISC/  DUNIT,RHOR,KMPI,KMPO,NOSCAT,MED,IRAYLR
      DOUBLE PRECISION DUNIT,RHOR(6)
      INTEGER          KMPI,KMPO,NOSCAT,MED(6),IRAYLR(6)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSTACKE/E,TIM,U,V,W,X,Y,Z,DNEAR,

     *                 ZAP,WAP,WA,

     *                 IQ,IGEN,IR,IOBS,LPCTE,NP
      DOUBLE PRECISION E(60),TIM(60),U(60),V(60),W(60),
     *                 X(60),Y(60),Z(60),DNEAR(60)

     *                 ,ZAP(60),WAP(60),WA(60)

      INTEGER          IQ(60),IGEN(60),IR(60),IOBS(60),LPCTE(60),NP

      COMMON /CRUPHIOT/THETA,SINTHE,COSTHE,SINPHI,COSPHI,PI,TWOPI
      DOUBLE PRECISION THETA,SINTHE,COSTHE,SINPHI,COSPHI,PI,TWOPI

      COMMON /CRUSEFUL/PRM,PRMT2,RMI,VCI,MEDIUM,MEDOLD,IBLOBE
      DOUBLE PRECISION PRM,PRMT2,RMI,VCI
      INTEGER          MEDIUM,MEDOLD,IBLOBE

       

       

       

       

      DOUBLE PRECISION ANGLEX,ANGLEY,ANGLEZ,XX,YY,ZZ
      SAVE
C-----------------------------------------------------------------------

C  ANGLE WITH RESPECT TO X AXIS
C  PARTICLE IS WRITTEN IN OUTPUT BUFFER ARRAY
      OUTPAR(0)  = IQ(NP)
      OUTPAR(1)  = E(NP)*0.001D0
      OUTPAR(2)  = MIN( 1.D0, W(NP) )
      OUTPAR(3)  = U(NP)
      OUTPAR(4)  =-V(NP)
      OUTPAR(5)  =-Z(NP)
      OUTPAR(6)  = TIM(NP)
      OUTPAR(7)  = X(NP)
      OUTPAR(8)  =-Y(NP)
      OUTPAR(9)  = IGEN(NP)
      OUTPAR(10) = ALEVEL

      LEVL = MAX( IOBS(NP), 1 )
      CALL OUTPT1
      IF ( FEGSDB ) THEN
        WRITE(MDEBUG,*) 'AUSGAB: NP=',NP,' IR=',IR(NP),' IOBS=',IOBS(NP)
        XX = X(NP)
        YY =-Y(NP)
        ZZ =-Z(NP)
        ANGLEX = U(NP)
        ANGLEY =-V(NP)
        ANGLEZ = W(NP)
        WRITE(MDEBUG,170) IQ(NP),E(NP)*.001D0,ANGLEZ,ANGLEX,ANGLEY,ZZ,
     *      TIM(NP)*1.D3,XX,YY,IGEN(NP)

 170    FORMAT(' AUSGAB:',13X,I4,1P,E11.3,0P,1X,F7.4,1X,F7.4,1X,F7.4,
     *          1X,F9.0,F9.6,1X,1P,E11.4,1X,E11.4,1X,I3

     *          )
      ENDIF

      RETURN
      END

*-- Author :    The CORSIKA development group   21/04/1994
C=======================================================================

      SUBROUTINE AUSGB2

C-----------------------------------------------------------------------
C  IN CASE OF DEBUGGING WE PRINT THE PARTICLE COORDINATES.
C  THIS SUBROUTINE IS CALLED FROM MANY EGS-ROUTINES.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CREGSDEB/JCLOCK,NCLOCK,FEGSDB
      INTEGER          JCLOCK,NCLOCK
      LOGICAL          FEGSDB

      COMMON /CRMISC/  DUNIT,RHOR,KMPI,KMPO,NOSCAT,MED,IRAYLR
      DOUBLE PRECISION DUNIT,RHOR(6)
      INTEGER          KMPI,KMPO,NOSCAT,MED(6),IRAYLR(6)

      COMMON /CRPARPAR/CURPAR,SECPAR,PRMPAR,OUTPAR,C,
     *                 E00,E00PN,PTOT0,PTOT0N,THICKH,ITYPE,LEVL

      DOUBLE PRECISION CURPAR(0:16),SECPAR(0:16),PRMPAR(0:16),
     *                 OUTPAR(0:16),

     *                 C(50),E00,E00PN,PTOT0,PTOT0N,THICKH
      INTEGER          ITYPE,LEVL

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSTACKE/E,TIM,U,V,W,X,Y,Z,DNEAR,

     *                 ZAP,WAP,WA,

     *                 IQ,IGEN,IR,IOBS,LPCTE,NP
      DOUBLE PRECISION E(60),TIM(60),U(60),V(60),W(60),
     *                 X(60),Y(60),Z(60),DNEAR(60)

     *                 ,ZAP(60),WAP(60),WA(60)

      INTEGER          IQ(60),IGEN(60),IR(60),IOBS(60),LPCTE(60),NP

      COMMON /CRUPHIOT/THETA,SINTHE,COSTHE,SINPHI,COSPHI,PI,TWOPI
      DOUBLE PRECISION THETA,SINTHE,COSTHE,SINPHI,COSPHI,PI,TWOPI

      COMMON /CRUSEFUL/PRM,PRMT2,RMI,VCI,MEDIUM,MEDOLD,IBLOBE
      DOUBLE PRECISION PRM,PRMT2,RMI,VCI
      INTEGER          MEDIUM,MEDOLD,IBLOBE

       

       

       

       

      DOUBLE PRECISION ANGLEX,ANGLEY,ANGLEZ,XX,YY,ZZ
      SAVE
C-----------------------------------------------------------------------

C  ANGLE WITH RESPECT TO X AXIS
      XX = X(NP)
      YY =-Y(NP)
      ZZ =-Z(NP)
      ANGLEZ = W(NP)
      ANGLEX = U(NP)
      ANGLEY =-V(NP)
      WRITE(MDEBUG,170) IQ(NP),E(NP)*.001D0,ANGLEZ,ANGLEX,ANGLEY,ZZ,
     *    TIM(NP)*1.0D3,XX,YY,IGEN(NP)

 170  FORMAT(' AUSGB2:',13X,I4,1P,E11.3,0P,1X,F8.5,1X,F7.4,1X,F7.4,
     *  1X,F9.0,1X,F9.6,1X,1P,E11.4,1X,E11.4,0P,1X,I3

     *  )

      RETURN
      END

*-- Author :    STANFORD LINEAR ACCELERATOR CENTER
C=======================================================================
C                                STANFORD LINEAR ACCELERATOR CENTER
      SUBROUTINE BHABHA
C                                VERSION 4.00  --  26 JAN 1986/1900
C-----------------------------------------------------------------------
C  BHABHA (SCATTERING)
C
C  DISCRETE BHABHA SCATTERING (A CALL TO THIS ROUTINE) HAS BEEN
C  ARBITRARILY DEFINED AND CALCULATED TO MEAN BHABHA SCATTERINGS
C  WHICH IMPART TO THE SECONDARY ELECTRON SUFFICIENT ENERGY THAT
C  IT BE TRANSPORTED DISCRETELY, I.E. E=AE OR T=TE.  IT IS NOT
C  GUARANTEED THAT THE FINAL POSITRON WILL HAVE THIS MUCH ENERGY
C  HOWEVER.  THE EXACT BHABHA DIFFERENTIAL CROSS-SECTION IS USED.
C  THIS SUBROUTINE IS CALLED FROM ELECTR.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CREGSDEB/JCLOCK,NCLOCK,FEGSDB
      INTEGER          JCLOCK,NCLOCK
      LOGICAL          FEGSDB

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSTACKE/E,TIM,U,V,W,X,Y,Z,DNEAR,

     *                 ZAP,WAP,WA,

     *                 IQ,IGEN,IR,IOBS,LPCTE,NP
      DOUBLE PRECISION E(60),TIM(60),U(60),V(60),W(60),
     *                 X(60),Y(60),Z(60),DNEAR(60)

     *                 ,ZAP(60),WAP(60),WA(60)

      INTEGER          IQ(60),IGEN(60),IR(60),IOBS(60),LPCTE(60),NP

      COMMON /CRTHRESH/RMSQ,API,TE,THMOLL,AP,AE,UP,UE
      DOUBLE PRECISION RMSQ,API,TE,THMOLL
      REAL             AP,AE,UP,UE

      COMMON /CRUPHIOT/THETA,SINTHE,COSTHE,SINPHI,COSPHI,PI,TWOPI
      DOUBLE PRECISION THETA,SINTHE,COSTHE,SINPHI,COSPHI,PI,TWOPI

      COMMON /CRUSEFUL/PRM,PRMT2,RMI,VCI,MEDIUM,MEDOLD,IBLOBE
      DOUBLE PRECISION PRM,PRMT2,RMI,VCI
      INTEGER          MEDIUM,MEDOLD,IBLOBE

       

       

       

       

      DOUBLE PRECISION BETA2,BR,B1,B2,B3,B4,DCOSTH,EP0,EP0C,E0,E02,H1,
     *                 PEIP,PEKIN,PEKINI,PEKSE2,PESE1,PESE2,REJF2,
     *                 T0,YY,Y2,YP,YP2
      SAVE
C-----------------------------------------------------------------------

      IF ( FEGSDB ) THEN
        WRITE(MDEBUG,1) NP,IR(NP),IOBS(NP)
 1      FORMAT(' BHABHA: NP=',I3,' IR=',I3,' IOBS=',I3)
        CALL AUSGB2
      ENDIF

      PEIP  = E(NP)
C  KINETIC ENERGY OF INCIDENT POSITRON
      PEKIN = PEIP-PRM
      PEKINI= 1.D0/PEKIN
      T0    = PEKIN*RMI
      E0    = T0+1.D0
      YY    = 1.D0/(T0+2.D0)
      E02   = E0**2
      BETA2 = (E02-1.D0)/E02
      EP0   = TE*PEKINI
      EP0C  = 1.D0-EP0
      Y2    = YY*YY
      YP    = 1.D0-2.D0*YY
      YP2   = YP**2
      B4    = YP2*YP
      B3    = B4+YP2
      B2    = YP*(3.D0+Y2)
      B1    = 2.D0-Y2
 341  CONTINUE
C  SAMPLE BR FROM MINIMUM(EP0) TO 1
      CALL RMMARD( RD,2,2 )
      BR    = EP0/(1.D0-EP0C*RD(1))
      REJF2 = (1.D0-BETA2*BR*(B1-BR*(B2-BR*(B3-BR*B4))))
      IF ( RD(2) .GT. REJF2 ) GOTO 341
      IF ( BR .LT. 0.5D0 ) THEN
        IQ(NP+1) = 3
      ELSE
C  IF E- GOT MORE THAN E+, MOVE THE E+ POINTER AND REFLECT B
        IQ(NP)   = 3
        IQ(NP+1) = 2
        BR = 1.D0-BR
      ENDIF
      BR     = MAX( 0.D0, BR )
C  DIVIDE UP THE ENERGY
      PEKSE2 = BR*PEKIN
      PESE1  = PEIP-PEKSE2
      PESE2  = PEKSE2+PRM
      E(NP)  = PESE1
      E(NP+1)= PESE2
C  DETERMINE ANGLES FROM KINEMATICS
      H1     = (PEIP+PRM)*PEKINI
C  DIRECTION COSINE CHANGE FOR 'OLD' ELECTRON
      DCOSTH = MIN( 1.D0, H1*(PESE1-PRM)/(PESE1+PRM) )
      SINTHE = SQRT( 1.D0 - DCOSTH )
      COSTHE = SQRT( DCOSTH )
      CALL UPHI( 2,1 )
      NP = NP+1
      DCOSTH = MIN( 1.D0, H1*(PESE2-PRM)/(PESE2+PRM) )
      SINTHE =-SQRT( 1.D0 - DCOSTH )
      COSTHE = SQRT( DCOSTH )
      CALL UPHI( 3,2 )

      RETURN
      END

*-- Author :    STANFORD LINEAR ACCELERATOR CENTER
C=======================================================================
C                                STANFORD LINEAR ACCELERATOR CENTER

      SUBROUTINE BREMS

C                                VERSION 4.00  --  26 JAN 1986/1900
C-----------------------------------------------------------------------
C  BREMS(STRAHLUNG GENERATION)
C
C  FOR ELECTRON ENERGY GREATER THAN 5.0 MEV, THE BETHE-HEITLER
C  CROSS-SECTION IS EMPLOYED.
C  THIS SUBROUTINE IS CALLED FROM ELECTR.

C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CRBREMPR/PWR2I,DL1,DL2,DL3,DL4,DL5,DL6,DELCM,ALPHI,BPAR,
     *                 DELPOS
      DOUBLE PRECISION PWR2I(60)
      REAL             DL1(6),DL2(6),DL3(6),DL4(6),DL5(6),DL6(6),
     *                 DELCM,ALPHI(2),BPAR(2),DELPOS(2)

      COMMON /CREGSDEB/JCLOCK,NCLOCK,FEGSDB
      INTEGER          JCLOCK,NCLOCK
      LOGICAL          FEGSDB

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSTACKE/E,TIM,U,V,W,X,Y,Z,DNEAR,

     *                 ZAP,WAP,WA,

     *                 IQ,IGEN,IR,IOBS,LPCTE,NP
      DOUBLE PRECISION E(60),TIM(60),U(60),V(60),W(60),
     *                 X(60),Y(60),Z(60),DNEAR(60)

     *                 ,ZAP(60),WAP(60),WA(60)

      INTEGER          IQ(60),IGEN(60),IR(60),IOBS(60),LPCTE(60),NP

      COMMON /CRTHRESH/RMSQ,API,TE,THMOLL,AP,AE,UP,UE
      DOUBLE PRECISION RMSQ,API,TE,THMOLL
      REAL             AP,AE,UP,UE

      COMMON /CRUPHIOT/THETA,SINTHE,COSTHE,SINPHI,COSPHI,PI,TWOPI
      DOUBLE PRECISION THETA,SINTHE,COSTHE,SINPHI,COSPHI,PI,TWOPI

      COMMON /CRUSEFUL/PRM,PRMT2,RMI,VCI,MEDIUM,MEDOLD,IBLOBE
      DOUBLE PRECISION PRM,PRMT2,RMI,VCI
      INTEGER          MEDIUM,MEDOLD,IBLOBE

       

       

       

       

      DOUBLE PRECISION ABREMS,AI2LN2,BR,DEL,DELTA,H,P,PEIE,PESG,PESE,
     *                 REJF,T
      INTEGER          IDISTR,LVL,LVL0,LVX

      SAVE
      DATA             AI2LN2/0.721347521D0/
C-----------------------------------------------------------------------

      IF ( FEGSDB ) THEN
        WRITE(MDEBUG,1)  NP,IR(NP),IOBS(NP)
 1      FORMAT(' BREMS : NP=',I3,' IR=',I3,' IOBS=',I3)
        CALL AUSGB2
      ENDIF

      PEIE = E(NP)
      NP   = NP+1
C  DECIDE WHICH DISTRIBUTION TO USE
      IF ( PEIE .LT. 50.D0 ) THEN
C  (B-H IS USED 1.5 TO 50 MEV)
        LVX  = 1
        LVL0 = 0
      ELSE
C  (B-H COULOMB CORRECTED IS USED ABOVE 50 MEV)
        LVX  = 2
        LVL0 = 3
      ENDIF
C  TWO TIMES AI2LN2 = 1.442695041
      ABREMS = DBLE(INT( 1.442695041D0*LOG( PEIE*API ) ))
C  THE METHOD OF BUTCHER AND MESSEL FOR SAMPLING A CLASS OF FACTORIZABLE
C  FREQUENCY DISTRIBUTIONS IS USED. OUR 'BR' VARIABLE IS THE SAME AS
C  THEIR 'EPSILON' VARIABLE. (SEE BUTCHER AND MESSEL,NUCL.PHYS.,VOL.20,
C  PP23,24. COMPUTE NUMBER OF SUBDISTRIBUTIONS NEEDED TO PRODUCE GAMMAS
C  OF MINIMUM DISCRETE TRANSPORT ENRGY AP, IN CASE THE (1-BR)/BR
C  PART OF THE DISTRIBUTION IS USED.
 351  CONTINUE
      CALL RMMARD( RD,3,2 )
C  DECIDE WHETHER TO SAMPLE FROM (1-BR)/BR OR 2*BR PART OF DISTRIBUTION
      IF ( (ABREMS*ALPHI(LVX)+0.5D0)*RD(1) .GE. 0.5D0 ) THEN
C  USE THE (1-BR)/BR PART.  WHICH SUBDISTRIBUTION?
        IDISTR = ABREMS*RD(2)
C  THIS CHOOSES IDISTR AT RANDOM FROM SET (0,1,2, ..., NBREMS-1)
        P = PWR2I(IDISTR+1)
C  SELECT SCREENING REJECTION FUNCTION
C                   LVL=1    UNCOULOMB CORRECTED     A(DELTA)
C                   LVL=2    UNCOULOMB CORRECTED     B(DELTA)
C                   LVL=3    UNCOULOMB CORRECTED     C(DELTA)
C                   LVL=4      COULOMB CORRECTED     A(DELTA)
C                   LVL=5      COULOMB CORRECTED     B(DELTA)
C                   LVL=6      COULOMB CORRECTED     C(DELTA)
        LVL = LVL0+1
C   USE A(DELTA), EITHER BORN OR COULOMB CORRECTED, DEPENDING ON
C   WHETHER LVL HAS BEEN PREVIOUSLY SET TO 0 OR 3.
C   ALL SUBDISTRIBUTIONS ARE SAMPLED BY FIRST SAMPLING FROM
C            (1./LOG(2.))*(1.-BR)/BR     IF 0.5 .LE. BR .LE. 1.
C            1./LOG(2.)                  IF   BR.LT. 0.5
C   AND THEN TAKING BR = BR*P
C   AI2LN2 IS ACTUALLY 1./(2.*LOG(2.)), WHICH IS THE PROBABILITY
C   THAT BR IS LESS THAN 0.5 IN THE ELEMENTARY DISTRIBUTION ABOVE.
        IF ( RD(3) .GE. AI2LN2 ) THEN
 361      CONTINUE
          CALL RMMARD( RD,3,2 )
          H  = MAX( RD(2), RD(3) )
          BR = 1.D0-0.5D0*H
          IF ( BR*RD(1) .GT. 0.5D0 ) GOTO 361
        ELSE
          CALL RMMARD( RD,1,2 )
          BR = RD(1)*0.5D0
        ENDIF
        BR  = BR*P
      ELSE
        BR  = MAX( RD(2), RD(3) )
C  USE B(DELTA) FOR SCREENING FUNCTION
        LVL = LVL0+2
      ENDIF
C  NOW ATTRIBUTE ENERGIES TO THE PARTICLES
      PESG = PEIE*BR
C  AP IS SELECTED IN PROGRAM PEGS (ESTABLISHING CROSS-SECTION FILE)
C  MINIMUM HARDNESS REQUIREMENT, CORRESPONDING TO LOWER BOUND
C  CHOICE FOR TOTAL CROSS-SECTION INTEGRAL
      IF ( PESG .LT. AP ) GOTO 351
      PESE = PEIE-PESG
C  THE ELECTRON MUST HAVE A MINIMUM ENERGY EQUAL TO 0.511 MEV
      IF ( PESE .LT. PRM ) GOTO 351
C  DEFINITION OF DELTA IS DELTA=136.0*EXP(ZG)*RM*EE/(E*(1.0-EE))
C                              =DELCM*EE/(E*(1.0-EE))=DELCM*DEL
C  WHERE E=ELECTRON INCIDENT ENERGY(MEV), AND EE=(GAMMA ENERGY)/E
C  ZG IS DEFINED IN THE PROGRAM SHINP, AND IS A WEIGHTED AVERAGE
C  OF LOG(Z**(-1./3.))  OVER THE VARIOUS TYPES OF ATOMS IN THE
C  MOLECULE (BUTCHER AND MESSEL, OP.CIT., P.17-19,22-24).
      DEL = BR/PESE
C  A(DELTA) AND B(DELTA) MUST ALWAYS BE POSITIVE
      IF ( DEL .GE. DELPOS(LVX) ) GOTO 351
      DELTA = DELCM*DEL
      IF ( DELTA .LT. 1.D0 ) THEN
        REJF = DL1(LVL)+DELTA*(DL2(LVL)+DELTA*DL3(LVL))
      ELSE
        REJF = DL4(LVL)+DL5(LVL)*LOG(DELTA+DL6(LVL))
      ENDIF
      CALL RMMARD( RD,1,2 )
C  SCREENING REJECTION
      IF ( RD(1) .GT. REJF ) GOTO 351
      THETA = PRM/PEIE
      CALL UPHI( 1,3 )
C  ATTRIBUTE PARTICLE ENERGIES AND PROPERTIES
      IF ( PESG .LE. PESE ) THEN
        IQ(NP ) = 1
        E(NP)   = PESG
        E(NP-1) = PESE
      ELSE
        IQ(NP)  = IQ(NP-1)
        IQ(NP-1)= 1
        E(NP)   = PESE
        E(NP-1) = PESG
C  INTERCHANGE STACK POSITION OF ELECTRON AND GAMMA
        T       = U(NP)
        U(NP)   = U(NP-1)
        U(NP-1) = T
        T       = V(NP)
        V(NP)   = V(NP-1)
        V(NP-1) = T
        T       = W(NP)
        W(NP)   = W(NP-1)
        W(NP-1) = T
      ENDIF

      RETURN
      END

*-- Author :    STANFORD LINEAR ACCELERATOR CENTER
C=======================================================================
C                                STANFORD LINEAR ACCELERATOR CENTER
      SUBROUTINE COMPT
C                                VERSION 4.00  --  26 JAN 1986/1900
C-----------------------------------------------------------------------
C  COMPT(ON SCATTERING)
C
C  BUTCHER AND MESSEL''S CROSS-SECTION EXPRESSION IS USED
C  (BUTCHER AND MESSEL, OP.CIT., P. 17-19,25), BUT THE
C  1/EPSILON PART IS NOT SAMPLED IN THE WAY THAT THEY DO.
C  THIS ROUTINE CALLS THEIR 'EPSILON' VARIABLE BY THE NAME 'BR'.
C  BR=FINAL GAMMA ENERGY /INITIAL GAMMA ENERGY.
C  BR0 = MINIMUM BR = 1./(1.+2.*(E(NP)/PRM))
C  MAXIMUM BR IS 1.
C  BUTCHER AND MESSEL''S EXPRESSION FOR THE DIFFERENTIAL CROSS-
C  SECTION IS PROPORTIONAL TO
C       (1./BR+BR)*(1.-BR*SINTHE**2/(1.+BR*BR))
C  WE SHALL SAMPLE FROM THE FIRST FACTOR FROM THE INTERVAL (BR0,1)
C  AND USE THE SECOND FACTOR AS A REJECTION FUNCTION.
C  THIS SUBROUTINE IS CALLED FROM PHOTO.
C-----------------------------------------------------------------------

      IMPLICIT NONE

      COMMON /CREGSDEB/JCLOCK,NCLOCK,FEGSDB
      INTEGER          JCLOCK,NCLOCK
      LOGICAL          FEGSDB

      COMMON /CRRANDPA/RD,FAC,U1,U2,NSEQ,ISEED,KNOR
      DOUBLE PRECISION RD(3000),FAC,U1,U2
      INTEGER          ISEED(3,10),NSEQ
      LOGICAL          KNOR

      COMMON /CRRUNPAR/FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,
     *                 STEPFC,

     *                 NRRUN,NSHOW,MPATAP,MONIIN,
     *                 MONIOU,MDEBUG,NUCNUC,MTABOUT,MLONGOUT,

     *                 MCETAP,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,

     *                 NPLEM,NPLMU,NPLHAD,

     *                 DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

     *                 ,FFLUDB,FFLUKA,FFLUSIG

     *                 ,PLOTSH

      COMMON /CRRUNPAC/DSN,DSNTAB,DSNLONG,HOST,USER

     *                 ,LSTDSN

     *                 ,DSNFLOUT,DSNFLERR
     *                 ,CPLOT

      DOUBLE PRECISION FIXHEI,THICK0,HILOECM,HILOELB,SIG1I,TARG1I,STEPFC

      INTEGER          NRRUN,NSHOW,MPATAP,MONIIN,MONIOU,MDEBUG,NUCNUC,
     *                 ISHOWNO,ISHW,NOPART,NRECS,NBLKS,MAXPRT,NDEBDL,
     *                 N1STTR,MDBASE,MTABOUT,MLONGOUT

      INTEGER          MCETAP

      INTEGER          NPLEM,NPLMU,NPLHAD
      CHARACTER*79     DSN,DSNTAB,DSNLONG
      CHARACTER*20     HOST,USER

      CHARACTER*9      LSTDSN
      CHARACTER*80     CPLOT

      LOGICAL          DEBDEL,DEBUG,FDECAY,FEGS,FIRSTI,FIXINC,FIXTAR,
     *                 FIX1I,FMUADD,FNKG,FPRINT,FDBASE,FPAROUT,FTABOUT,
     *                 FLONGOUT,GHEISH,GHESIG,GHEISDB,USELOW,TMARGIN

      CHARACTER*79     DSNFLOUT,DSNFLERR
      LOGICAL          FFLUDB,FFLUKA,FFLUSIG

      LOGICAL          PLOTSH

      COMMON /CRSTACKE/E,TIM,U,V,W,X,Y,Z,DNEAR,

     *                 ZAP,WAP,WA,

     *                 IQ,IGEN,IR,IOBS,LPCTE,NP
      DOUBLE PRECISION E(60),TIM(60),U(60),V(60),W(60),
     *              