<?php

function GetSup($style, $sup)
{
    switch($style)
    {
    case "html":
        return " &lt;sup&gt;".$sup."&lt;/sup&gt;";
        break;
    case "text":
        return " <sup>".$sup."</sup>";
        break;
    case "latex":
        return " $^".$sup."$";
        break;
    default:
        break;
    }

}

function GetBla($style, $text)
{
    switch($style)
    {
    case "html":
        return str_replace("'", "\'", str_replace("ä", '&amp;auml;', str_replace("ü", '&amp;uuml;', mb_convert_encoding($text, 'utf-8', 'iso-8859-1'))));
        break;
    case "text":
        return str_replace("'", "\'", str_replace("ä", '&auml;', str_replace("ü", '&uuml;', mb_convert_encoding($text, 'utf-8', 'iso-8859-1'))));
        break;
    case "latex":
        return str_replace("'", "\'", str_replace("ä", '{\"a}', str_replace("ü", '{\"u}', mb_convert_encoding($text, 'utf-8', 'iso-8859-1'))));
        break;
    default:
        break;
    }
}

function GetEndl($style, $comma)
{
    switch($style)
    {
    case "latex":
        return $comma." &bsol;&bsol; <br>\n";
        break;
    case "html":
        return $comma." &lt;br&gt; <br>\n";
        break;
    case "text":
        return $comma." \n";
        break;
    default:
        return $comma." <br>\n";
        break;
    }
}
    echo "<html>\n";
    echo "<head>\n";
    echo "<meta name='Author' content='Daniela Dorner' />\n";
    echo "<meta http-equiv='content-type' content='text/html; charset=utf-8' />\n";
    echo "<title>FACT Project</title>\n";
    echo "<link rel='StyleSheet' type='text/css' href='../style.css' />\n";
    echo "</head>\n";
    echo "<body>\n";
    //echo (file_get_contents("../shifteval/header.html"));

    if (!empty($_GET["date"]))
        $date=$_GET["date"];
    else
        $date=date("Ymd");

    if (!empty($_GET["listformat"]))
        $listformat=$_GET["listformat"];
    else
        $listformat="long";

    if (!empty($_GET["textformat"]))
        $textformat=$_GET["textformat"];
    else
        $textformat="latex";

    $starttimestamp = new DateTime($startdate);
    date_add($starttimestamp, date_interval_create_from_date_string("12 hours"));
    $stoptimestamp = new DateTime($stopdate);
    date_add($stoptimestamp, date_interval_create_from_date_string("12 hours"));

    echo "<form action='memberlist.php' METHOD='GET'>\n";
    echo "<b>FACT Collaboration</b> status of date ";
    printf("<input name='date' type='text' size='10' maxlength='10' value='%s'>\n", $date);
    echo "<input type='submit' value='Show'> \n";

    include ("db.php");
    $db_id = mysql_connect($host, $user, $pw);

    //without institute:
    //select username, Date(Min(start)) as 'from', if(Max(stop)='2020-12-31
    //23:59:59', 'unlimited', Date(Max(stop))) as 'until',
    //Date(Adddate(Min(start), interval 6 MONTH)) as 'author since',
    //if(Max(stop)='2020-12-31 23:59:59', 'unlimited',
    //Date(Adddate(Max(stop), interval 1 year))) as 'author until' from
    //members where not isnull(start) and not isnull(stop) group by username;

    $selectcurrent="SELECT userid, firstname, middlename, lastname, inst.institutename, also.institutefullname, inst.institutefullname, inst.instituteadresse ";
    $selectall="SELECT username, Date(start) AS 'from', if(stop='2020-12-31 23:59:59', 'unlimited', Date(stop)) AS 'until',";
    $selectall.=" DATE(ADDDATE(start, INTERVAL 6 MONTH)) AS 'author since', ";
    $selectall.=" IF(stop='2020-12-31 23:59:59', 'unlimited', DATE(ADDDATE(stop, INTERVAL 1 YEAR))) AS 'author until', ";
    $selectall.=" inst.institutename, MID(username, LOCATE(' ', username)+1) AS surname, ";
    $selectall.=" MID(username, 1, LOCATE(' ', username)) AS firstname, ";
    $selectall.=" firstname, middlename, lastname, also.institutefullname, inst.institutefullname, inst.instituteadresse ";
    $selectlist="SELECT ";
    if ($textformat=="latex")
        $sep="~";
    else
        $sep=" ";
    switch ($listformat)
    {
    case "long":
        $selectlist.="CONCAT(firstname, ' ', if (not isnull(middlename), middlename, ''), ' ', lastname), ";
        break;
    case "short":
        $selectlist.="CONCAT(LEFT(firstname, 1), '.', if (not isnull(middlename), CONCAT(LEFT(middlename, 1), '.".$sep."'), '".$sep."'), lastname), ";
        break;
    }
    $selectlist.="inst.institutename, also.institutefullname, inst.institutefullname, inst.instituteadresse  ";
    $from=" FROM memberlist.members ";
    $join=" LEFT JOIN memberlist.institutes inst USING(instituteid) ";
    $join.=" LEFT JOIN memberlist.institutes also ON also.instituteid=alsoat ";
    $where.=" WHERE NOT start='1970-01-01 00:00:00' AND NOT isnull(stop) ";

    $corresponding="";
    foreach ($_GET as $key => $name)
    {
        if (strpos($key, 'corresponding') !== false)
        {
            if ($corresponding=="")
                $corresponding.=str_replace('corresponding', '', $key);
            else
                $corresponding.=", ".str_replace('corresponding', '', $key);
        }
    }


    $current=" AND ADDDATE(start, INTERVAL 6 MONTH) <= '".$date."' AND ADDDATE(stop, INTERVAL 1 YEAR) >= '".$date."' ";
    $order=" ORDER BY lastname";
    $querycurrent=$selectcurrent.$from.$join.$where.$current;
    $querycurrent=$querycurrent.$order;
    $queryall=$selectall.$from.$join.$where.$order.", start";
    if ($corresponding=="")
    {
        $querylist=$selectlist.$from.$join.$where.$current.$order;
    }
    else
    {
        $querylist=$selectlist.$from.$join.$where." AND userid IN (".$corresponding.") ".$current.$order;
        $querylist2=$selectlist.$from.$join.$where." AND userid NOT IN (".$corresponding.") ".$current.$order;
    }

    echo "<br>\n<br>\n";
//    echo $querycurrent."<br>\n<br>\n";
//    echo $queryall."<br>\n<br>\n";
//    echo $querylist."<br>\n<br>\n";
    echo $_GET["corresponding"];
    echo "<h3>Current Author List:</h3>\n";
    echo "<table border='1'>\n";
    echo "<thead><tr><th>*</th><th>First Middle Lastname</th><th>Institute (#)</th><th>also at</th></tr></thead>\n";
    echo "<tbody>\n";
    $result  = mysql_query($querycurrent);
    $counter=0;
    $letter=a;
    $institutes = [];
    $instnames = [];
    $instaddresses = [];
    $alsos = [];
    while ($row = mysql_fetch_row($result))
    {
        echo "<tr>";
        if ($_GET["corresponding".$row[0]]=="yes")
            echo "<td><input type='checkbox' name='corresponding".$row[0]."' value='yes' checked='checked'></td>";
        else
            echo "<td><input type='checkbox' name='corresponding".$row[0]."' value='yes'></td>";
        echo "<td title='".$row[0]."'>".$row[1]." ".$row[2]." ".$row[3]."</td>";
        if (!in_array($row[4],$institutes))
        {
            $counter++;
            $institutes[$counter]=$row[4];
            $instnames[$counter]=$row[6];
            $instaddresses[$counter]=$row[7];
        }
        echo "<td>".mb_convert_encoding($row[4], 'utf-8', 'iso-8859-1')." (".array_search($row[4], $institutes).")</td>";
        if ($row[5])
        {
            if (!in_array($row[5], $alsos))
            {
                $alsos[$letter]=$row[5];
                $letter++;
            }
            echo "<td>".$row[5]." (".array_search($row[5], $alsos).") </td></tr>";
        }
        else
            echo "<td></td></tr>";
    }
    //print_r($institutes);
    //print_r($alsos);
    echo "</tbody>\n";
    echo "</table>\n<br>\n";
    mysql_free_result($result);

    echo "<h3>Institute List:</h3>\n";
    echo "<table border='1'>\n";
    echo "<thead><tr><th>#</th><th>Institute</th><th>Institute Adresse</th></tr></thead>\n";
    echo "<tbody>\n";
    for ($i = 1; $i <= $counter; $i++)
    {
        echo "<tr><td>".$i."</td><td>".mb_convert_encoding($instnames[$i], 'utf-8', 'iso-8859-1')."</td><td>".mb_convert_encoding($instaddresses[$i], 'utf-8', 'iso-8859-1')."</td></tr>";
    }
    echo "<tr><td></td><td></td><td></td></tr>";
    foreach ($alsos as $num => $name)
    {
        echo "<tr><td>".$num."</td><td>".mb_convert_encoding($name, 'utf-8', 'iso-8859-1')."</td><td></td></tr>";
    }
    echo "</tbody>\n";
    echo "</table>\n<br>\n";

    echo "<br>\n<br>\n";
    echo "<h3>Full list:</h3>\n";
    echo "<table border='1'>\n";
    echo "<thead><tr><th>Name</th><th>Institute</th><th>Member since</th><th>Member until</th><th>Author since</th><th>Author until</th></tr></thead>\n";
    $result  = mysql_query($queryall);
    echo "<tbody>\n";
    while ($row = mysql_fetch_row($result))
        echo "<tr><td>".$row[0]."</td><td>".$row[5]."</td><td>".$row[1]."</td><td>".$row[2]."</td><td>".$row[3]."</td><td>".$row[4]."</td></tr>";
    echo "</tbody>\n";
    echo "</table>\n<br>\n";
    mysql_free_result($result);


    $queryassoc="SELECT username, firstname, middlename, lastname, Date(associatedstart), if(associatedstop='2020-12-31 23:59:59', 'unlimited', Date(associatedstop)), inst.institutename FROM memberlist.members LEFT JOIN memberlist.institutes inst USING(instituteid) ";
    $queryassoc.="WHERE not isnull(associatedstop) ORDER BY associatedstart";
    //$queryassoc.="WHERE associatedstart <= '".$date."' AND associatedstop >= '".$date."' ";
    //echo $queryassoc;
    $result  = mysql_query($queryassoc);
    //associated members
    echo "<h3>Associated Members:</h3>\n";
    echo "<table border='1'>\n";
    echo "<tbody>\n";
    echo "<thead><tr><th>First Middle Lastname</th><th>associated since</th><th>associated until</th><th>Host Institute (#)</th></tr></thead>\n";
    while ($row = mysql_fetch_row($result))
    {
        echo "<tr>";
        echo "<td>".$row[1]." ".$row[2]." ".$row[3]."</td>";
        echo "<td>".$row[4]."</td>";
        echo "<td>".$row[5]."</td>";
        echo "<td>".mb_convert_encoding($row[6], 'utf-8', 'iso-8859-1')." (".array_search($row[6], $institutes).")</td>";
    }

    echo "</tbody>\n";
    echo "</table>\n<br>\n";
    mysql_free_result($result);

    echo "<form name='formular' action='memberlist.php' METHOD='GET'>\n";
    echo "<h3>Author List:</h3>\n";
    echo "Format: <br>\n";
    if ($_GET["listformat"]=="short")
        echo "<input type=radio name='listformat' value='short' checked='checked'> short &nbsp;";
    else
        echo "<input type=radio name='listformat' value='short'> short &nbsp;";
    if ($_GET["listformat"]=="long")
        echo "<input type=radio name='listformat' value='long' checked='checked'> long <br>";
    else
        echo "<input type=radio name='listformat' value='long'> long <br>";
    if ($_GET["textformat"]=="latex")
        echo "<input type=radio name='textformat' value='latex' checked='checked'> latex &nbsp;";
    else
        echo "<input type=radio name='textformat' value='latex'> latex &nbsp;";
    if ($_GET["textformat"]=="html")
        echo "<input type=radio name='textformat' value='html' checked='checked'> html ";
    else
        echo "<input type=radio name='textformat' value='html'> html ";
    if ($_GET["textformat"]=="text")
        echo "<input type=radio name='textformat' value='text' checked='checked'> text <br>";
    else
        echo "<input type=radio name='textformat' value='text'> text <br>";
    echo "<br><input type='submit' value='Get List'>\n";
    echo "</form>\n";

    $counter=0;
    $letter=a;
    $institutes = [];
    $instnames = [];
    $instaddresses = [];
    $alsos = [];
    $result  = mysql_query($querylist);
    while ($row = mysql_fetch_row($result))
    {
        if (!in_array($row[1],$institutes))
        {
            $counter++;
            $institutes[$counter]=$row[1];
            $instnames[$counter]=$row[3];
            $instaddresses[$counter]=$row[4];
        }
        if ($corresponding=="" || $textformat!="latex")
            echo $row[0].GetSup($textformat, array_search($row[1], $institutes));
        else
            echo " \speaker{".$row[0]."} ".GetSup($textformat, array_search($row[1], $institutes));
        if ($row[2])
        {
            if (!in_array($row[2], $alsos))
            {
                $alsos[$letter]=$row[2];
                $letter++;
            }
        }
        if ($row[2])
            echo GetSup($textformat, array_search($row[2], $alsos));
        echo GetEndl($textformat, ",");
    }
    mysql_free_result($result);
    if ($querylist2)
    {
        $result  = mysql_query($querylist2);
        while ($row = mysql_fetch_row($result))
        {
            if (!in_array($row[1],$institutes))
            {
                $counter++;
                $institutes[$counter]=$row[1];
                $instnames[$counter]=$row[3];
                $instaddresses[$counter]=$row[4];
            }
            echo " ".$row[0]." ".GetSup($textformat, array_search($row[1], $institutes));
            if ($row[2])
            {
                if (!in_array($row[2], $alsos))
                {
                    $alsos[$letter]=$row[2];
                    $letter++;
                }
            }
            if ($row[2])
                echo GetSup($textformat, array_search($row[2], $alsos));
            echo GetEndl($textformat, ",");
        }
        mysql_free_result($result);
    }
    for ($i = 1; $i <= $counter; $i++)
        echo GetSup($textformat, $i)." ".GetBla($textformat, $instnames[$i]).", ".
            GetBla($textformat, $instaddresses[$i]).GetEndl($textformat, "");
    foreach ($alsos as $num => $name)
        echo GetSup($textformat, $num)." also at ".GetBla($textformat, $name).GetEndl($textformat, "");



    mysql_close($db_id);

    echo "</form>\n";
    echo "</body>\n";
    echo "</html>\n";
?>
