<!DOCTYPE HTML>
<html>
<head>
  <meta name="Author" content="The FACT Group" />
  <meta http-equiv="content-type" content="text/html; charset=utf-8" />
    <title>FACT Project</title>

  <link rel="StyleSheet" type="text/css" href="../../style.css" />
  <link rel="stylesheet" href="//code.jquery.com/ui/1.11.0/themes/smoothness/jquery-ui.css">
  <script src="//code.jquery.com/ui/1.11.0/jquery-ui.js"></script>
</head>
<body>
<?php

function print_popup($text)
{
    echo "<script type=\"text/javascript\" language=\"Javascript\">\n";
    echo "alert(\"".$text."\")\n";
    echo "</script>\n";
}
$maintenance=0;
#$maintenance=1;

if ($maintenance)
{
    echo "<hr>\n <p style='font-size:xx-large'> MAINTENANCE ONGOING </p>\n";
    echo "<p>check again later...</p>\n<p>\n<hr>\n<p>\n<p>\n";
}


$tables=array(
      "AnalysisResultsRunLP"     => "QLA",
      "AnalysisResultsRunISDC"   => "ISDC",
      "AnalysisResultsRunCutsLC" => "CutsLC",
      );

$times=array(
      "timestamp"   => "timestamp [YYYY-MM-DD HH:MM:SS]",
      "unix"   => "unix-timestamp [seconds]",
      "mjd"   => "modified julian date [days]",
      );

$zdcuts=array(
      "all"  => "all data",
      "75"   => "zd<75",
      "45"   => "zd<45",
      "35"   => "zd<35",
      "30"   => "zd<30",
      );

$thcuts=array(
      "all"   => "all data",
      "550"   => "th<550",
      "350"   => "th<350",
      );
$lights=array(
      "all"    => "all data",
      "nomoon" => "no moon",
      "dark"   => "only dark night",
      );


$dchs=array(
      "no"    => "all data",
      "yes"   => "apply data check (R750)",
      );

$rmemptyrows=array(
      "no"      => "all data",
      "yes"     => "remove rows with empty columns",
      );

$dusts=array(
      "all"  => "all data",
      "20"    => "dust<20",
      "10"    => "dust<10",
      "1.0"   => "dust<1",
      );

$factorcuts=array(
      "all"   => "all data",
      "0.1"   => "zdfactor * thfactor > 0.1",
      "0.2"   => "zdfactor * thfactor > 0.2",
      "0.3"   => "zdfactor * thfactor > 0.3",
      "0.4"   => "zdfactor * thfactor > 0.4",
      "0.5"   => "zdfactor * thfactor > 0.5",
      "0.6"   => "zdfactor * thfactor > 0.6",
      "0.7"   => "zdfactor * thfactor > 0.7",
      "0.8"   => "zdfactor * thfactor > 0.8",
      "0.9"   => "zdfactor * thfactor > 0.9",
      );

$timebins=array(
      "5"    => "5 minutes",
      "10"   => "10 minutes",
      "20"   => "20 minutes",
      "30"   => "30 minutes",
      "40"   => "40 minutes",
      "60"   => "1 hour",
      "90"   => "1.5 hours",
      "120"  => "2 hours",
      "180"  => "3 hours",
      "240"  => "4 hours",
      "300"  => "5 hours",
      "360"  => "6 hours",
      "-1"   => "1 night",
      "-2"   => "2 nights",
      "-3"   => "3 nights",
      "-4"   => "4 nights",
      "-5"   => "5 nights",
      "-6"   => "6 nights",
      "-7"   => "7 nights",
      "-10"  => "10 nights",
      "00"   => "period",
      );

$timebinsext=array(
      "20"   => "20 minutes",
      "-1"   => "1 night",
      );

// get/define initial values

if (!empty($_POST["start"]))
    $start=$_POST["start"];

if (!empty($_POST["stop"]))
    $stop=$_POST["stop"];

if (!empty($_POST["dch"]))
    $dch=$_POST["dch"];
else
    $dch="yes";

if (!empty($_POST["dust"]))
    $dust=$_POST["dust"];
else
    $dust="novalue";

if (!empty($_GET["expert"]))
    $_POST["expert"]=$_GET["expert"];

if (!empty($_POST["expert"]))
    $expert=$_POST["expert"];
else
    $expert="no";

if (!empty($_POST["email"]))
    $email=$_POST["email"];
else
    $email="";

if (!empty($_POST["light"]))
    $light=$_POST["light"];
else
    $light="novalue";

if (!empty($_POST["source"]))
    $source=$_POST["source"];
else
    $source=-1;

if (!empty($_POST["timebin"]))
    $timebin=$_POST["timebin"];
else
    $timebin="novalue";

if (!empty($_POST["time"]))
    $time=$_POST["time"];
else
    $time="novalue";

if (!empty($_POST["factorcut"]))
    $factorcut=$_POST["factorcut"];
else
    $factorcut="0.3";

if (!empty($_POST["table"]))
    $table=$_POST["table"];
else
    $table="AnalysisResultsRunLP";

if (!empty($_POST["rmemptyrow"]))
    $rmemptyrow=$_POST["rmemptyrow"];
else
    $rmemptyrow="novalue";

if (!empty($_POST["th"]))
    $th=$_POST["th"];
else
    $th="novalue";

if (!empty($_POST["zd"]))
    $zd=$_POST["zd"];
else
    $zd="novalue";

if (!empty($_POST["crabflux"]))
    $crabflux=$_POST["crabflux"];
else
    $crabflux="-";

//variable for non-combinable date/source
$warn="";


include ("db.php");
$db_id = mysql_connect($host, $user, $pw);
mysql_select_db($db);

ini_set("display_errors",   "On");
ini_set("mysql.trace_mode", "On");

echo "<h1><u>FACT Quick Look Analysis - Download Area</u></h1>\n";
//echo "<hr>\n";
echo "<h2>Data Usage Policy</h2>\n";

if ($expert=="yes")
{
    echo "As a member or associated member of the FACT Collaboration, you have access to internal information.<br>\n";
    echo "Any publication using FACT internal information has to have the full FACT author list.<br><br>\n";
}
else
{
    echo "<b>Using data from the FACT Quick Look Analysis, you agree to cite the FACT design paper (H. Anderhub et al. JINST 8 P6008) ";
//    echo "<a target='_blank' href='http://iopscience.iop.org/1748-0221/8/06/P06008'>FACT design paper</a>\n ";
    echo "and the quick look analysis (https://fact-project.org/monitoring).</b>\n";
    echo "<br><br>\n \n ";
    echo "<u>References:</u>\n";
    echo "<ul>\n";
    echo "<li>Website Quick Look Analysis: <a target='_blank' href='https://fact-project.org/monitoring'>https://fact-project.org/monitoring </a></li>\n";
    echo "<li>FACT Design Paper: H. Anderhub et al. JINST 8 P6008 <a target='_blank' href='http://adsabs.harvard.edu/abs/2013JInst...8P6008A'>ADS</a>\n ";
    echo "<a target='_blank' href='http://iopscience.iop.org/1748-0221/8/06/P06008'>open access</a>\n</li>\n";
    echo "<li>FACT Performance Paper: A. Biland et al. JINST 9 P10012 <a target='_blank' href='http://adsabs.harvard.edu/abs/2014JInst...9P0012B'>ADS</a>\n ";
    echo "<a target='_blank' href='http://iopscience.iop.org/1748-0221/9/10/P10012/'>open access</a>\n</li>\n";
    echo "<li>Information on the Quick Look Analysis: D. Dorner et al. Proceedings Fermi Symposium 2014 <a target='_blank' href='http://adsabs.harvard.edu/abs/2015arXiv150202582D'>ADS</a>\n ";
    echo "<a target='_blank' href='https://arxiv.org/pdf/1502.02582v1.pdf'>open access</a>\n</li>\n";
    echo "</ul>\n";
}


echo "If you intend to use data or information from this website, please let us know for reference.<br>\n";


//echo "<hr>\n";
echo "<form name='formular' action='download.php' METHOD='POST'>\n";

//$query="SELECT fSourceKey, fSourceName, (SELECT COUNT(*) FROM ".$_POST["table"]." LEFT JOIN RunInfo USING(fNight, fRunID) WHERE fRunTypeKey=1 AND RunInfo.fSourceKey=Source.fSourceKey) AS num FROM Source WHERE fSourceTypeKey=1";
$query="SELECT fSourceKey, fSourceName, COUNT(*) AS num FROM RunInfo LEFT JOIN Source USING(fSourceKey) WHERE fSourceTypeKey=1 AND fRunTypeKey=1 GROUP BY fSourceKey ORDER BY num DESC";
//echo $query."<br>";

$sources=array();
$result=mysql_query($query);
while ($row = mysql_fetch_row($result))
    $sources[$row[0]]=$row[1];
mysql_free_result($result);

//$query="SELECT Min(fNight), Max(fNight) FROM ".$_POST["table"];
$query="SELECT Min(fNight), Max(fNight) FROM RunInfo";
//echo $query."<br>";

$result=mysql_query($query);
while ($row = mysql_fetch_row($result))
{
    if (empty($start))
        $start=$row[0];
    if (empty($stop))
        $stop=$row[1];
}
mysql_free_result($result);

if (strpos($email, "@")!= false && $source<0)
    print_popup("Please select a source.");

if (strpos($email, "@")!= false && $time=="novalue")
    print_popup("Please select a time format.");

if (strpos($email, "@")!= false && $timebin=="novalue")
    print_popup("Please select a time binning.");

if (empty($email) && $time!="novalue" && $timebin!="novalue" && $source>0)
    print_popup("Please provide an email address.");


if (strpos($email, "@")!= false && empty($_POST["emailcopy"]))
    print_popup("Please agree that a copy of the email is stored.");


if (strpos($email, "@")!= false && $source>0 && !empty($_POST["emailcopy"]))
{
    //echo "<h2>Sending data...</h2>\n";
    //print_popup("Sent email to ".$email." containing the data of ".$sources[$source]." from ".$start." till ".$stop." for ".$timebins[$timebin]." binning.");
    print_popup("Email with data sent to ".$email);
    if ($maintenance)
        echo $start." ".$stop." ".$source." ".$timebin." ".$email." ".$table." ".$time." ".$expert." ".$dch." ".$zd." ".$th." ".$light." ".$dust." ".$rmemptyrow." ".$factorcut." ".$crabflux."<br>\n";
    $sent=shell_exec("/users/fact/SW.automatic.processing/DataCheck/Tools/get_data.sh ".$start." ".$stop." ".$source." ".$timebin." ".$email." ".$table." ".$time." ".$expert." ".$dch." ".$zd." ".$th." ".$light." ".$dust." ".$rmemptyrow." ".$factorcut." ".$crabflux);
    echo $sent;
    if (!empty($_POST["newsletter"]))
    {
        $query_interested="SELECT * FROM memberlist.interested WHERE email='".$email."'";
        $result_interested=mysql_query($query_interested);
        //echo "num rows: ".mysql_num_rows($result_interested)."<br>\n";
        //while ($row = mysql_fetch_row($result_interested))
        //    echo $row[0]." ".$row[1]." ".$row[2]." ".$row[3]."<br>\n";
        if (mysql_num_rows($result_interested)>0)
            $query_interested="UPDATE ";
        else
            $query_interested="INSERT ";
        $query_interested.=" memberlist.interested SET date=NOW(), email='".$email."'";
        if (mysql_num_rows($result_interested)>0)
            $query_interested.=" WHERE email='".$email."'";
        //echo $query_interested;
        mysql_free_result($result_interested);
        $result_interested=mysql_query($query_interested);
        if ($maintenance)
            echo "num affected rows: ".mysql_affected_rows()."<br>\n";
    }
}

//#DFE6FA #CDD7F4
echo "<br>\n<div style='background-color: #DFE6FA; padding-left: 20px; padding-right: 20px; padding-top: 1px; padding-bottom: 10px; border: 3px solid #394979; border-radius: 20px'>\n";
echo "<h2>Select here the settings for your data sample:</h2>\n";

// SOURCE
echo "<select name='source' size='1'>\n";
if ($source == -1)
    printf("<option value='-1' selected>Select Source</option>\n");
else
    printf("<option value='-1'>Select Source</option>\n");
foreach ($sources as $key => $sourcename)
{
    if ($source==$key)
        printf("<option value='%s' selected>%s</option>\n", $key, $sourcename);
    else
        printf("<option value='%s'>%s</option>\n", $key, $sourcename);
}
echo "</select><sup>*</sup>\n";

// Time Format
echo "<select name='time' size='1'>\n";
if ($time == "")
    printf("<option value='novalue' selected>Select Time Format</option>\n");
else
    printf("<option value='novalue'>Select Time Format</option>\n");
foreach ($times as $key => $name)
{
    if ($time == $key)
        printf("<option value='%s' selected>%s</option>\n", $key, $name);
    else
        printf("<option value='%s'>%s</option>\n", $key, $name);
}
echo "</select><sup>*</sup>\n ";

// Binning
echo "<select name='timebin' size='1'>\n";
if ($timebin == "novalue")
    printf("<option value='novalue' selected>Select Binning</option>\n");
else
    printf("<option value='novalue'>Select Binning</option>\n");
if ($expert != "yes")
    $timebins=$timebinsext;
foreach ($timebins as $key => $name)
{
    if ($timebin == $key)
        printf("<option value='%s' selected>%s</option>\n", $key, $name);
    else
        printf("<option value='%s'>%s</option>\n", $key, $name);
}
echo "</select><sup>*</sup>\n";
echo "<br>\n";

printf("Time Range: from <input name='start' type='text' size='8' maxlength='8' value='%s'> \n", $start);
printf("to <input name='stop' type='text' size='8' maxlength='8' value='%s'> \n ", $stop);
//echo "<input class='Width' type='button' value='Reset' onClick='self.location.href=\"download.php\"'><br>\n";
echo "<input class='Width' type='button' value='Reset' onClick='self.location.href=\"download.php";
if ($expert == "yes")
    echo "?expert=yes";
echo "\"'><br>\n";

if ($expert == "yes")
{
    echo "<h2>Further settings for internal use: </h2>\n";
    echo "<input type='hidden' name='expert' value='yes'>\n";

    echo "Select Analysis: <select name='table' size='1'>\n";
    foreach ($tables as $key => $name)
    {
        if ($table == $key)
            printf("<option value='%s' selected>%s</option>\n", $key, $name);
        else
            printf("<option value='%s'>%s</option>\n", $key, $name);
    }
    echo "</select><br>\n";

    echo "Cuts: \n";
    //DATACHECK
    echo "<select name='dch' size='1'>\n";
    if ($dch == "novalue")
        printf("<option value='novalue' selected>Select DataCheck</option>\n");
    else
        printf("<option value='novalue'>Select DataCheck</option>\n");
    foreach ($dchs as $key => $name)
    {
        if ($dch == $key)
            printf("<option value='%s' selected>%s</option>\n", $key, $name);
        else
            printf("<option value='%s'>%s</option>\n", $key, $name);
    }
    echo "</select>\n ";

    //DUST
    echo "<select name='dust' size='1'>\n";
    if ($dust == "novalue")
        printf("<option value='novalue' selected>Select Calima-Cut</option>\n");
    else
        printf("<option value='novalue'>Select Calima-Cut</option>\n");
    foreach ($dusts as $key => $name)
    {
        if ($dust == $key)
            printf("<option value='%s' selected>%s</option>\n", $key, $name);
        else
            printf("<option value='%s'>%s</option>\n", $key, $name);
    }
    echo "</select>\n ";

    //ZD
    echo "<select name='zd' size='1'>\n";
    if ($zd == "novalue")
        printf("<option value='novalue' selected>Select Zd-Cut</option>\n");
    else
        printf("<option value='novalue'>Select Zd-Cut</option>\n");
    foreach ($zdcuts as $key => $name)
    {
        if ($zd == $key)
            printf("<option value='%s' selected>%s</option>\n", $key, $name);
        else
            printf("<option value='%s'>%s</option>\n", $key, $name);
    }
    echo "</select>\n ";

    //TH
    echo "<select name='th' size='1'>\n";
    if ($th == "novalue")
        printf("<option value='novalue' selected>Select Threshold-Cut</option>\n");
    else
        printf("<option value='novalue'>Select Threshold-Cut</option>\n");
    foreach ($thcuts as $key => $name)
    {
        if ($th == $key)
            printf("<option value='%s' selected>%s</option>\n", $key, $name);
        else
            printf("<option value='%s'>%s</option>\n", $key, $name);
    }
    echo "</select>\n ";

    echo "<select name='light' size='1'>\n";
    if ($light == "novalue")
        printf("<option value='novalue' selected>Select Light-Condition-Cut</option>\n");
    else
        printf("<option value='novalue'>Select Light-Condition-Cut</option>\n");
    foreach ($lights as $key => $name)
    {
        if ($light == $key)
            printf("<option value='%s' selected>%s</option>\n", $key, $name);
        else
            printf("<option value='%s'>%s</option>\n", $key, $name);
    }
    echo "</select>\n";

    echo "<select name='factorcut' size='1'>\n";
    if ($factorcut == "novalue")
        printf("<option value='novalue' selected>Select Factor-Cut</option>\n");
    else
        printf("<option value='novalue'>Select Factor-Cut</option>\n");
    foreach ($factorcuts as $key => $name)
    {
        if ($factorcut == $key)
            printf("<option value='%s' selected>%s</option>\n", $key, $name);
        else
            printf("<option value='%s'>%s</option>\n", $key, $name);
    }
    echo "</select>\n";

    echo "<select name='rmemptyrows' size='1'>\n";
    if ($rmemptyrow == "novalue")
        printf("<option value='novalue' selected>Empty Rows (data w/o zd/th info lack corr. fluxes)</option>\n");
    else
        printf("<option value='novalue'>Empty Rows (data w/o zd/th info lack corr. fluxes)</option>\n");
    foreach ($rmemptyrows as $key => $name)
    {
        if ($rmemptyrow == $key)
            printf("<option value='%s' selected>%s</option>\n", $key, $name);
        else
            printf("<option value='%s'>%s</option>\n", $key, $name);
    }
    echo "</select>\n <br>\n";
    printf("Custom conversion factor to flux: <input name='crabflux' type='text' size='4' maxlength='4' value='%s'>[10^-11 ph/s/cm2] <br>\n", $crabflux);
}

echo "<h2>Get data:</h2>\n";

echo "Provide your email address to receive the data: \n";
printf("<input name='email' type='text' size='20' maxlength='50' value='%s'><sup>*</sup>\n<br>\n", $email);

if (empty($_POST["emailcopy"]))
    echo "<input type='checkbox' name='emailcopy'><sup>*</sup> I agree that a copy of the email is stored for the statistical evaluation of data requests.<br>\n";
else
    echo "<input type='checkbox' name='emailcopy' checked><sup>*</sup> I agree that a copy of the email is stored for the statistical evaluation of data requests.<br>\n";
if (empty($_POST["newsletter"]))
    echo "<input type='checkbox' name='newsletter'> I would like to receive updates on the data and agree that my email address is stored for this purpose.<br><br>\n";
else
    echo "<input type='checkbox' name='newsletter' checked> I would like to receive updates on the data and agree that my email address is stored for this purpose.<br><br>\n";

echo "Clicking on the button, you agree to the data usage policy: <br><br>\n";
//echo "Clicking on the button, you agree to the data usage policy and that a copy of my email is stored: <br><br>\n";
echo "<input type='button' style='width: 250px; height: 40px; font-size: 22px; ' value='Send data by Email' onClick='submit()'><br>\n";
//border: 3px solid #394979; border-radius: 10px
echo "<sup>*</sup> required<br>\n";


echo "</form>\n";
echo "</div>\n";
//echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;* required<br>\n";

echo "<h2>Remarks:</h2> ";


if ($expert=="yes")
{
    echo "<ul>\n";
    echo "<li>The correction formula to correct the excess rate for the effects of zd and threshold is not yet final.</li>\n";
    //echo "<li>The CU conversion is currently only valid for QLA and until summer 2016.</li>\n";
    echo "<li>The data quality selection based on the artificial trigger rate R750 \n";
    echo "<ul>\n";
    echo "<li>might not work for all data (effect of lidar).</li>\n";
    echo "<li>might not be available for the newest data (reference value needs to be determined).</li>\n";
    echo "</ul></li>\n";
    echo "<li>Not for all data dust measurements are available.</li>\n";
    echo "<li>Empty columns: Be aware that no corrected rates and fluxes can be calculated if the zenith distance and/or threshold are missing.</li>\n";
    echo "<li>Conversion factors:<br>\n";
    echo "<ul>\n";
    echo "<li>Be aware that the conversion factors to flux are for a slope of -2.63. If your source has a different spectrum, ";
    echo "the conversion factor has to be adapted because of a changing energy threshold.</li>\n";
    echo "<li>For the conversion factors the Crab spectrum from the PL of the HESS publication in 2006 has been used.</li>\n";
    echo "<li>If you use a custom conversion factor to flux, make sure that it is consistent with the analysis you choose.</li>\n";
    echo "</ul></li>\n";
    echo "</ul>";
}
else
{
    echo "<ul>\n";
    //echo "<li>The results shown on this page are <b><i>PRELIMINARY</i></b>.</li>";
    echo "<li>These are the results of a <b>fast quick look analysis</b> on site, i.e. they are <b>preliminary</b>.</li>\n";
    echo "<li>The quick look analysis includes all data, i.e. no data selection done.</li>\n";
    //echo "<li><b>NO data check</b> is included in the analysis.</li>";
    echo "<li>The shown curves are not fluxes but <b>excess rates</b> (number of excess events per effective ontime), \n";
    echo "i.e. there is a dependence on trigger threshold and zenith distance of the observation (with the current \n";
    echo "analysis for zenith distance > 40 degree and trigger threshold > 500 DAC counts).</li>\n";
    //echo "i.e. a dependence on trigger threshold and zenith distance of the observation is expected ";
    //echo "for zenith distance larger than 40 degree and very strong moon light.</li>";
    //echo "<li><b>NO corrections</b> for the dependence on zenith distance and trigger threshold of the observation are applied so far.</li>";
    //echo "<li>This webpage shows the <b>excess rates</b> (black), i.e. number of excess events ";
    //echo "(signal minus background in the signal region) devided by the ontime of the observation, ";
    //echo "and the <b>background rates</b> (blue), i.e. number of background events devided by ontime. </li>";
    echo "<li>The curves are provided with 20 min binning and nightly binning.</li>\n";
    echo "<li>In case, you need further details about the data or a different binning, please do not hesitate to contact us.</li>\n";
    echo "<li>QLA results are available for the data since 12.12.2012. For older data, please contact us.</li>\n";
    echo "<li>New software versions were introduced at the following dates: 24.5.2014</li>\n";
    echo "</ul>\n";
    echo "In case you are interested in more than the public data, please contact us.\n";
}

echo "<h2>Contact</h2>";
echo "<i>qla&lt;at&gt;fact-project.org</i><br>";
//echo "You acknowledge these regulations by clicking on the 'Show' button.</b></big> <br><br><br>";

/*
$ranges=array(
//              "5min" => " 5 min",
//              "10min" => "10 min",
              "20min" => "20 min",
              "30min" => "30 min",
              "40min" => "40 min",
              "60min" => "60 min",
              "90min" => "90 min",
              "120min" => "120 min",
              "180min" => "180 min",
              "240min" => "240 min",
              "300min" => "300 min",
              "360min" => "360 min",
//              "0001nights" => "1 night",
//              "0002nights" => "2 nights",
//              "0004nights" => "4 nights",
//              "0008nights" => "8 nights",
//              "0016nights" => "16 nights",
              );

echo "</body>";
echo "</html>";
*/
//$dom = new DOMDocument();
//$dom->loadHTML("download.php");
//echo $dom->getElementById("logged");

?>
</body>
</html>
