<html>
<head>
  <meta name="Author" content="The FACT Group" />
  <meta http-equiv="content-type" content="text/html; charset=utf-8" />
  <title>FACT Contact Info</title>
  <link rel="StyleSheet" type="text/css" href="../style.css" />
</head>


<body>


<a href='https://www.fact-project.org/smartfact'>Is FACT taking data?</a><br><br>
Who is on shift?
(from <a href='https://www.fact-project.org/shift'>FACT shift plan<a>
and <a href='https://www.fact-project.org/logbook/memberlist.php'>FACT logbook<a>)<br>
<?php

//find out if php was started with command-line or on browswer
//echo php_sapi_name();
//echo PHP_SAPI;
if (strcmp(php_sapi_name(), "cli")==0 && $argv)
{
    parse_str(implode('&', array_slice($argv, 1)), $_GET);
    $_SERVER["REMOTE_USER"]="FACT";
}

if (isset($_GET['date']))
    $today=date("Ymd", strtotime($_GET["date"]));
else
{
    if (date("H")>8)
        $today=date("Ymd", mktime(0,0,0,date("m"), date("d"), date("Y")));
    else
        $today=date("Ymd",strtotime(date("Y-m-d", mktime(0,0,0,date("m"), date("d"), date("Y")))." -1 day"));
}


function send_email($date, $msg_part)
{
    $to = "fact-online@lists.phys.ethz.ch";
    $subject = $date.": shifter-info missing";
    $msg = "WARNING: No shifter-info available for ".$date."\n\n";
    $msg .= $msg_part;

    if (!mail($to, $subject, $msg, 'From:observations@fact-project.org'))
        echo "Sending warning email failed.<br>\n\n";
}

function get_userinfo($db, $username)
{
    // this is getting exactly one entry from the DB, since we get only
    //   one username, which is unique in the DB.
    // contactinfo and availability need to be queried as else PHP complains
    //   in the function userinfo_to_string(), but for shifter they can/should be empty
    $query="SELECT username as login, usertitle as name, email, fid5 as mobile, fid7 as skype, '' as contactinfo, '' as availability
        FROM logbook.userfields
        LEFT JOIN logbook.users
        ON (uid=ufid)
        WHERE username='".$username."'";
    $result  = $db->query($query);
    $all = $result->fetch_assoc();
    $result->free();
    return $all;
}


function get_expertinfo($db, $type)
{
    $query="SELECT username as login, usertitle as name, email, fid5 as mobile, fid7 as skype, fid8 as contactinfo, fid6 as availability
        FROM logbook.userfields
        LEFT JOIN logbook.users ON (uid=ufid)
        LEFT JOIN memberlist.experts
        ON (ufid=userid)
        WHERE now() < stop and now() > start AND not isnull (".$type.")";
    $result  = $db->query($query);
    $all = $result->fetch_all(MYSQLI_ASSOC);
    $result->free();
    return $all;
}

function userinfo_to_string($userinfo)
{
    $s = $userinfo['name'] . "[" .$userinfo['login']."]" . ": <br>";
    if (str_replace(' ', '', $userinfo['contactinfo']))
        $s .= $userinfo['contactinfo']."<br>";
    else
    {
        $s .= "    email:" . $userinfo['email'] . "<br>";
        $s .= "    mobile:" . $userinfo['mobile'] . "<br>";
        $s .= "    skype:" . $userinfo['skype'] . "<br>";
    }
    if ((strcmp($_SERVER['REMOTE_USER'], "FACT")==0) && str_replace(' ', '', $userinfo['availability']))
        $s .= "availability information: <br>".$userinfo['availability']."<br>";
    return $s;
}

function send_warning_mail_to_user($userinfo, $today)
{
    $msg = "Dear " . $userinfo['name'] . "[".$userinfo['login']."]," ."\n\n";
    $msg .= "please insert your 'Shifthelper Mobile Phone Number' in ";
    $msg .= ' https://www.fact-project.org/logbook/usercp.php?action=profile';
    send_email($today, $msg);
}

echo "<br> &nbsp;&nbsp;Night: ".$today." (date of sunset) <br>";
$query="SELECT u FROM calendar.Data WHERE CONCAT(y, LPAD(m+1, 2, 0), LPAD(d,2,0))='".$today."'";
$query.=" AND NOT x=1 AND u NOT in('ISDC','ETHZ','TUDO','UNIWUE')";
include ("db.php");
$db = new mysqli($host, $user, $pw, $database);
$db->set_charset("utf8");
$result  = $db->query($query);
$numrows=mysqli_num_rows($result);
if ($numrows==0)
    send_email($today, "Whoever is on shift, please insert your name to the shift calendar!\n");
else
    echo "&nbsp;&nbsp;Contact Info Shiftcrew: <br>\n ";
echo "<ul>\n";
while ($row = $result->fetch_assoc())
{
    $userinfo = get_userinfo($db, $row['u']);
    if ($userinfo['name'])
    {
        echo "<li>".userinfo_to_string($userinfo)."</li>\n";
        if (!$userinfo['mobile'])
            send_warning_mail_to_user($userinfo, $today);
    }
}
echo "</ul>\n <br>\n";
$result->free();

echo "Remark for MAGIC shifters: please keep in mind that FACT shifters and experts will \n ";
echo "usually be asleep during the night, so that messages on skype or by email might stay \n ";
echo "unnoticed until the next morning.<br>\n  <br>\n ";


echo "Expert-On-Call Contact Info: <br>\n <ul>\n";

foreach (get_expertinfo($db, "expert") as $expertinfo)
{
    echo "<li>".userinfo_to_string($expertinfo)."</li><br>\n";

}
echo "</ul>\n";

echo "Flare-Expert-On-Call Contact Info: <br>\n <ul>\n";

foreach (get_expertinfo($db, "flare") as $expertinfo)
{
    echo "<li>".userinfo_to_string($expertinfo)."</li><br>\n";

}
echo "</ul>\n";

echo "SH-Expert-On-Call Contact Info: <br>\n <ul>\n";

foreach (get_expertinfo($db, "sh") as $expertinfo)
{
    echo "<li>".userinfo_to_string($expertinfo)."</li><br>\n";

}
echo "</ul>\n";

echo "Fallback-Shifter Contact Info: <br>\n <ul>\n";

foreach (get_expertinfo($db, "fallback") as $expertinfo)
{
    echo "<li>".userinfo_to_string($expertinfo)."</li><br>\n";

}
echo "</ul>\n";
?>

</body>
</html>
