<?php

function GetLDAPOptions()
{
    return array(
                 'ldapHost'    => 'fact01.ethz.ch',
                 'ldapDomain'  => 'fact.iac.es',
                 'ldapPort'    =>  '389',

                 'baseDN'      => 'dc=fact,dc=iac,dc=es',
                 'factDN'      => 'cn=FACT Developers,ou=FACT,ou=Groups'
                );
}

function CheckUsernameAndPassword($username, $password, $LDAPOptions)
{
    //$errorMessage = "The username/password combination you entered was invalid.";
    $ldaphost    = $LDAPOptions{'ldapHost'};
    $ldap_domain = $LDAPOptions{'ldapDomain'};
    $ldapport    = $LDAPOptions{'ldapPort'};

    $baseDN= $LDAPOptions{'baseDN'};
    $factDN= $LDAPOptions{'factDN'}.','.$baseDN;

    $ds = ldap_connect($ldaphost, $ldapport);
    if (!$ds)
    {
        echo "Could not connect to the LDAP server: " . $ldaphost;
        return false;
    }

    //------------------ Look for user common name
    $attributes = array('cn');
    $dn= 'ou=People,'.$baseDN;
    $filter= '(uid='.$username.')';
    if (!($sr = ldap_search($ds, $dn, $filter, $attributes)))
    {
        echo "Could not connect to the LDAP server: " . $ldaphost;
        return false;
    }
    $srData = ldap_get_entries($ds, $sr);
    if ($srData["count"]==0)
    {
        echo "Could not find user " . $username . " in the LDAP list.";
        return false;
    }
    $userCommonName= $srData[0]['cn'][0];
    $userDN= $srData[0]['dn'];

    //------------------ Authenticate user
    $ldapbind = ldap_bind($ds, $userDN, $password);
    if (strlen($password) && $ldapbind)
    {
        //------------------ Check if the user is in FACT ldap group
        $attributes= array("member");
        $filter= '(objectClass=*)';
        $sr = ldap_read($ds, $factDN, $filter, $attributes);
        $srData = ldap_get_entries($ds, $sr);
        $factGroupMembers= $srData[0]['member'];
        for ($i=0; $i < $factGroupMembers["count"]; $i++)
            if (strpos($factGroupMembers[$i], $userCommonName))
            {
                ldap_close($ds);
                return true;
            }
        ldap_close($ds);
        echo 'Sorry, you are not in the LDAP group FACT !';
        return false;
    }
    else
    {
        ldap_close($ds);
        return false;
    }
}

?>
