
#ifndef PROCESSIO_H_SEEN
#define PROCESSIO_H_SEEN

#include <stdarg.h>
#include <errno.h>
#include <math.h>
#include <signal.h>

#include "HVConfig.h"
#include "HVCalib.h"
#include "HV.h"
#include "../pixelmap/PixelMap.h"
#include "../drsdaq/SlowData.h"

#define MAX_NUM_TOKEN 10

#define MsgToConsole 1
#define MsgToLog 2
#define MsgToSocket 4

typedef enum stateenum { active, stopped, na } state_enum;

class ProcessIO {

  time_t StartTime;
  FILE *Logfile;
  PixelMap *pm;

 public:
  
  HVConfig    *config;
  HVCalib     *calib;
  HVBoard **fHVBoard;
  SlowData *SlowDataClass;
  
  pthread_mutex_t control_mutex;

  char Prompt[MAX_COM_SIZE];
  const char *Param[MAX_NUM_TOKEN]; // For parser
  int NParam;
  bool CmdFromSocket;
  
  // Status variables  
  pthread_t HVMonitor;       // exit function sends signal to these threads
  pthread_t SocketThread;

  bool Verbose;  
  int Socket;                // -1 if not connected

  int NumHVBoards;
  int FirstBoard;
  int LastBoard;
  int FirstChain;
  int LastChain;
  
  float fStatusRefreshRate;
  state_enum   state;
  bool Exit;
    
  // Methods
  ProcessIO(const char *);
  ~ProcessIO();

  void PrintMessage(int, const char *, ...);
  void PrintMessage(const char *, ...);
  void PrintMessage(int, const char *, va_list);
  void CommandControl(char*);
  bool RampVoltage(unsigned int, int, int, int);
  void Monitor();
  void ResetBoard(int);
  void PrintBoardStatus(int);
  int ParseInput(char*, const char *Param[]);
};

bool Match(const char *, const char *);
bool ConvertToDouble(const char *, double *);
bool ConvertToInt(const char *, int *);

#endif
